package resource

import (
	"fmt"
	"strings"
)

var mapping = map[string]ResourceType{
	"AWS::AccessAnalyzer::Analyzer":                               AccessAnalyzerAnalyzer,
	"AWS::ACMPCA::Certificate":                                    Unmapped,
	"AWS::ACMPCA::CertificateAuthority":                           Unmapped,
	"AWS::ACMPCA::CertificateAuthorityActivation":                 Unmapped,
	"AWS::AmazonMQ::Broker":                                       AmazonMQBroker,
	"AWS::AmazonMQ::Configuration":                                AmazonMQBrokerConfiguration,
	"AWS::AmazonMQ::ConfigurationAssociation":                     AmazonMQBroker,
	"AWS::Amplify::App":                                           AmplifyApp,
	"AWS::Amplify::Branch":                                        AmplifyBranch,
	"AWS::Amplify::Domain":                                        AmplifyDomain,
	"AWS::ApiGateway::Account":                                    Unmapped,
	"AWS::ApiGateway::ApiKey":                                     ApiGatewayApiKey,
	"AWS::ApiGateway::Authorizer":                                 ApiGatewayAuthorizer,
	"AWS::ApiGateway::BasePathMapping":                            ApiGatewayBasePathMapping,
	"AWS::ApiGateway::ClientCertificate":                          Unmapped,
	"AWS::ApiGateway::Deployment":                                 ApiGatewayDeployment,
	"AWS::ApiGateway::DocumentationPart":                          Unmapped,
	"AWS::ApiGateway::DocumentationVersion":                       Unmapped,
	"AWS::ApiGateway::DomainName":                                 ApiGatewayDomainName,
	"AWS::ApiGateway::GatewayResponse":                            ApiGatewayRestApi,
	"AWS::ApiGateway::Method":                                     Unmapped,
	"AWS::ApiGateway::Model":                                      ApiGatewayModel,
	"AWS::ApiGateway::RequestValidator":                           Unmapped,
	"AWS::ApiGateway::Resource":                                   ApiGatewayResource,
	"AWS::ApiGateway::RestApi":                                    ApiGatewayRestApi,
	"AWS::ApiGateway::Stage":                                      ApiGatewayStage,
	"AWS::ApiGateway::UsagePlan":                                  ApiGatewayUsagePlan,
	"AWS::ApiGateway::UsagePlanKey":                               ApiGatewayUsagePlanKey,
	"AWS::ApiGateway::VpcLink":                                    ApiGatewayVpcLink,
	"AWS::ApiGatewayV2::Api":                                      ApiGatewayV2Api,
	"AWS::ApiGatewayV2::ApiGatewayManagedOverrides":               Unmapped,
	"AWS::ApiGatewayV2::ApiMapping":                               ApiGatewayV2ApiMapping,
	"AWS::ApiGatewayV2::Authorizer":                               ApiGatewayV2Authorizer,
	"AWS::ApiGatewayV2::Deployment":                               ApiGatewayV2Deployment,
	"AWS::ApiGatewayV2::DomainName":                               ApiGatewayV2DomainName,
	"AWS::ApiGatewayV2::Integration":                              ApiGatewayV2Integration,
	"AWS::ApiGatewayV2::IntegrationResponse":                      Unmapped,
	"AWS::ApiGatewayV2::Model":                                    ApiGatewayV2Model,
	"AWS::ApiGatewayV2::Route":                                    ApiGatewayV2Route,
	"AWS::ApiGatewayV2::RouteResponse":                            Unmapped,
	"AWS::ApiGatewayV2::Stage":                                    ApiGatewayV2Stage,
	"AWS::ApiGatewayV2::VpcLink":                                  Unmapped,
	"AWS::AppConfig::Application":                                 Unmapped,
	"AWS::AppConfig::ConfigurationProfile":                        Unmapped,
	"AWS::AppConfig::Deployment":                                  Unmapped,
	"AWS::AppConfig::DeploymentStrategy":                          Unmapped,
	"AWS::AppConfig::Environment":                                 Unmapped,
	"AWS::AppConfig::HostedConfigurationVersion":                  Unmapped,
	"AWS::AppMesh::GatewayRoute":                                  Unmapped,
	"AWS::AppMesh::Mesh":                                          AppMeshMesh,
	"AWS::AppMesh::Route":                                         AppMeshRoute,
	"AWS::AppMesh::VirtualGateway":                                AppMeshVirtualGateway,
	"AWS::AppMesh::VirtualNode":                                   AppMeshVirtualNode,
	"AWS::AppMesh::VirtualRouter":                                 AppMeshVirtualRouter,
	"AWS::AppMesh::VirtualService":                                AppMeshVirtualService,
	"AWS::AppStream::DirectoryConfig":                             Unmapped,
	"AWS::AppStream::Fleet":                                       Unmapped,
	"AWS::AppStream::ImageBuilder":                                Unmapped,
	"AWS::AppStream::Stack":                                       Unmapped,
	"AWS::AppStream::StackFleetAssociation":                       Unmapped,
	"AWS::AppStream::StackUserAssociation":                        Unmapped,
	"AWS::AppStream::User":                                        Unmapped,
	"AWS::AppSync::ApiCache":                                      AppSyncApiCache,
	"AWS::AppSync::ApiKey":                                        AppSyncApiKey,
	"AWS::AppSync::DataSource":                                    AppSyncDataSource,
	"AWS::AppSync::FunctionConfiguration":                         AppSyncFunction,
	"AWS::AppSync::GraphQLApi":                                    AppSyncGraphQLApi,
	"AWS::AppSync::GraphQLSchema":                                 AppSyncGraphQLSchema,
	"AWS::AppSync::Resolver":                                      AppSyncResolver,
	"AWS::ApplicationAutoScaling::ScalableTarget":                 Unmapped,
	"AWS::ApplicationAutoScaling::ScalingPolicy":                  Unmapped,
	"AWS::ApplicationInsights::Application":                       Unmapped,
	"AWS::Athena::DataCatalog":                                    AthenaDataCatalog,
	"AWS::Athena::NamedQuery":                                     AthenaNamedQuery,
	"AWS::Athena::WorkGroup":                                      AthenaWorkGroup,
	"AWS::AutoScaling::AutoScalingGroup":                          AutoscalingGroup,
	"AWS::AutoScaling::LaunchConfiguration":                       AutoscalingLaunchConfig,
	"AWS::AutoScaling::LifecycleHook":                             AutoscalingLifecycleHook,
	"AWS::AutoScaling::ScalingPolicy":                             AutoscalingPolicy,
	"AWS::AutoScaling::ScheduledAction":                           AutoscalingScheduledAction,
	"AWS::AutoScalingPlans::ScalingPlan":                          Unmapped,
	"AWS::Backup::BackupPlan":                                     BackupPlan,
	"AWS::Backup::BackupSelection":                                BackupSelection,
	"AWS::Backup::BackupVault":                                    BackupVault,
	"AWS::Batch::ComputeEnvironment":                              BatchComputeEnvironment,
	"AWS::Batch::JobDefinition":                                   BatchJobDefinition,
	"AWS::Batch::JobQueue":                                        BatchJobQueue,
	"AWS::Budgets::Budget":                                        BudgetsBudget,
	"AWS::CE::CostCategory":                                       Unmapped,
	"AWS::Cassandra::Keyspace":                                    Unmapped,
	"AWS::Cassandra::Table":                                       Unmapped,
	"AWS::CertificateManager::Certificate":                        AcmCertificate,
	"AWS::Chatbot::SlackChannelConfiguration":                     Unmapped,
	"AWS::Cloud9::EnvironmentEC2":                                 Cloud9Environment,
	"AWS::CloudFormation::CustomResource":                         Unmapped, // Unnecessary?
	"AWS::CloudFormation::Macro":                                  Unmapped,
	"AWS::CloudFormation::Stack":                                  CloudFormationStack,
	"AWS::CloudFormation::WaitCondition":                          Unnecessary,
	"AWS::CloudFormation::WaitConditionHandle":                    Unnecessary,
	"AWS::CloudFront::CachePolicy":                                CloudFrontCachePolicy,
	"AWS::CloudFront::CloudFrontOriginAccessIdentity":             CloudFrontOriginAccessIdentity,
	"AWS::CloudFront::Distribution":                               CloudFrontDistribution,
	"AWS::CloudFront::OriginRequestPolicy":                        CloudFrontOriginRequestPolicy,
	"AWS::CloudFront::RealtimeLogConfig":                          Unmapped,
	"AWS::CloudFront::StreamingDistribution":                      CloudFrontStreamingDistribution,
	"AWS::CloudTrail::Trail":                                      CloudtrailTrail,
	"AWS::CloudWatch::Alarm":                                      CloudwatchAlarm,
	"AWS::CloudWatch::AnomalyDetector":                            Unmapped,
	"AWS::CloudWatch::CompositeAlarm":                             Unmapped,
	"AWS::CloudWatch::Dashboard":                                  CloudwatchDashboard,
	"AWS::CloudWatch::InsightRule":                                Unmapped,
	"AWS::CodeBuild::Project":                                     CodeBuildProject,
	"AWS::CodeBuild::ReportGroup":                                 Unmapped,
	"AWS::CodeBuild::SourceCredential":                            Unmapped,
	"AWS::CodeCommit::Repository":                                 CodeCommitRepository,
	"AWS::CodeDeploy::Application":                                Unmapped,
	"AWS::CodeDeploy::DeploymentConfig":                           Unmapped,
	"AWS::CodeDeploy::DeploymentGroup":                            Unmapped,
	"AWS::CodeGuruProfiler::ProfilingGroup":                       Unmapped,
	"AWS::CodeGuruReviewer::RepositoryAssociation":                Unmapped,
	"AWS::CodePipeline::CustomActionType":                         Unmapped,
	"AWS::CodePipeline::Pipeline":                                 CodePipelinePipeline,
	"AWS::CodePipeline::Webhook":                                  CodePipelineWebhook,
	"AWS::CodeStar::GitHubRepository":                             Unmapped,
	"AWS::CodeStarConnections::Connection":                        Unmapped,
	"AWS::CodeStarNotifications::NotificationRule":                Unmapped,
	"AWS::Cognito::IdentityPool":                                  CognitoIdentityPool,
	"AWS::Cognito::IdentityPoolRoleAttachment":                    Unmapped,
	"AWS::Cognito::UserPool":                                      CognitoUserPool,
	"AWS::Cognito::UserPoolClient":                                CognitoUserPoolClient,
	"AWS::Cognito::UserPoolDomain":                                CognitoUserPool, // TODO might need to confirm this
	"AWS::Cognito::UserPoolGroup":                                 CognitoUserPoolGroup,
	"AWS::Cognito::UserPoolIdentityProvider":                      CognitoUserPoolIdentityProvider,
	"AWS::Cognito::UserPoolResourceServer":                        CognitoUserPoolResourceServer,
	"AWS::Cognito::UserPoolRiskConfigurationAttachment":           Unmapped,
	"AWS::Cognito::UserPoolUICustomizationAttachment":             Unmapped,
	"AWS::Cognito::UserPoolUser":                                  Unmapped,
	"AWS::Cognito::UserPoolUserToGroupAttachment":                 Unmapped,
	"AWS::Config::AggregationAuthorization":                       ConfigAggregationAuthorization,
	"AWS::Config::ConfigRule":                                     ConfigRule,
	"AWS::Config::ConfigurationAggregator":                        ConfigConfigurationAggregator,
	"AWS::Config::ConfigurationRecorder":                          ConfigConfigurationRecorder,
	"AWS::Config::ConformancePack":                                ConfigConformancePack,
	"AWS::Config::DeliveryChannel":                                ConfigDeliveryChannel,
	"AWS::Config::OrganizationConfigRule":                         ConfigOrganizationConfigRule,
	"AWS::Config::OrganizationConformancePack":                    ConfigOrganizationConformancePack,
	"AWS::Config::RemediationConfiguration":                       ConfigRemediationConfiguration,
	"AWS::DAX::Cluster":                                           DAXCluster,
	"AWS::DAX::ParameterGroup":                                    DAXParameterGroup,
	"AWS::DAX::SubnetGroup":                                       DAXSubnetGroup,
	"AWS::DLM::LifecyclePolicy":                                   Unmapped,
	"AWS::DMS::Certificate":                                       Unmapped,
	"AWS::DMS::Endpoint":                                          DMSEndpoint,
	"AWS::DMS::EventSubscription":                                 Unmapped,
	"AWS::DMS::ReplicationInstance":                               DMSReplicationInstance,
	"AWS::DMS::ReplicationSubnetGroup":                            DMSReplicationSubnetGroup,
	"AWS::DMS::ReplicationTask":                                   DMSReplicationTask,
	"AWS::DataPipeline::Pipeline":                                 Unmapped,
	"AWS::Detective::Graph":                                       Unmapped,
	"AWS::Detective::MemberInvitation":                            Unmapped,
	"AWS::DirectoryService::MicrosoftAD":                          Unmapped,
	"AWS::DirectoryService::SimpleAD":                             Unmapped,
	"AWS::DocDB::DBCluster":                                       DocDBCluster,
	"AWS::DocDB::DBClusterParameterGroup":                         DocDBParameterGroup,
	"AWS::DocDB::DBInstance":                                      DocDBInstance,
	"AWS::DocDB::DBSubnetGroup":                                   DocDBSubnetGroup,
	"AWS::DynamoDB::Table":                                        DynamoDbTable,
	"AWS::EC2::CapacityReservation":                               Unmapped,
	"AWS::EC2::CarrierGateway":                                    Unmapped,
	"AWS::EC2::ClientVpnAuthorizationRule":                        Unmapped,
	"AWS::EC2::ClientVpnEndpoint":                                 Unmapped,
	"AWS::EC2::ClientVpnRoute":                                    Unmapped,
	"AWS::EC2::ClientVpnTargetNetworkAssociation":                 Unmapped,
	"AWS::EC2::CustomerGateway":                                   Unmapped,
	"AWS::EC2::DHCPOptions":                                       Unmapped,
	"AWS::EC2::EC2Fleet":                                          Unmapped,
	"AWS::EC2::EIP":                                               Ec2Eip,
	"AWS::EC2::EIPAssociation":                                    Ec2Eip,
	"AWS::EC2::EgressOnlyInternetGateway":                         Unmapped,
	"AWS::EC2::FlowLog":                                           Ec2FlowLog,
	"AWS::EC2::GatewayRouteTableAssociation":                      Unmapped,
	"AWS::EC2::Host":                                              Unmapped,
	"AWS::EC2::Instance":                                          Ec2Instance,
	"AWS::EC2::InternetGateway":                                   Ec2InternetGateway,
	"AWS::EC2::LaunchTemplate":                                    Ec2LaunchTemplate,
	"AWS::EC2::LocalGatewayRoute":                                 Unmapped,
	"AWS::EC2::LocalGatewayRouteTableVPCAssociation":              Unmapped,
	"AWS::EC2::NatGateway":                                        Ec2NatGateway,
	"AWS::EC2::NetworkAcl":                                        Ec2NetworkACL,
	"AWS::EC2::NetworkAclEntry":                                   Ec2NetworkACL,
	"AWS::EC2::NetworkInterface":                                  Ec2NetworkInterface,
	"AWS::EC2::NetworkInterfaceAttachment":                        Ec2NetworkInterface,
	"AWS::EC2::NetworkInterfacePermission":                        Unmapped,
	"AWS::EC2::PlacementGroup":                                    Unmapped,
	"AWS::EC2::PrefixList":                                        Unmapped,
	"AWS::EC2::Route":                                             Ec2Route,
	"AWS::EC2::RouteTable":                                        Ec2RouteTable,
	"AWS::EC2::SecurityGroup":                                     Ec2SecurityGroup,
	"AWS::EC2::SecurityGroupEgress":                               Ec2SecurityGroup,
	"AWS::EC2::SecurityGroupIngress":                              Ec2SecurityGroup,
	"AWS::EC2::SpotFleet":                                         Unmapped,
	"AWS::EC2::Subnet":                                            Ec2Subnet,
	"AWS::EC2::SubnetCidrBlock":                                   Ec2Subnet,
	"AWS::EC2::SubnetNetworkAclAssociation":                       Ec2NetworkACL,
	"AWS::EC2::SubnetRouteTableAssociation":                       Ec2RouteTable,
	"AWS::EC2::TrafficMirrorFilter":                               Unmapped,
	"AWS::EC2::TrafficMirrorFilterRule":                           Unmapped,
	"AWS::EC2::TrafficMirrorSession":                              Unmapped,
	"AWS::EC2::TrafficMirrorTarget":                               Unmapped,
	"AWS::EC2::TransitGateway":                                    Ec2TransitGateway,
	"AWS::EC2::TransitGatewayAttachment":                          Unmapped,
	"AWS::EC2::TransitGatewayRoute":                               Unmapped,
	"AWS::EC2::TransitGatewayRouteTable":                          Unmapped,
	"AWS::EC2::TransitGatewayRouteTableAssociation":               Unmapped,
	"AWS::EC2::TransitGatewayRouteTablePropagation":               Unmapped,
	"AWS::EC2::VPC":                                               Ec2Vpc,
	"AWS::EC2::VPCCidrBlock":                                      Unmapped,
	"AWS::EC2::VPCDHCPOptionsAssociation":                         Unmapped,
	"AWS::EC2::VPCEndpoint":                                       Unmapped,
	"AWS::EC2::VPCEndpointConnectionNotification":                 Unmapped,
	"AWS::EC2::VPCEndpointService":                                Unmapped,
	"AWS::EC2::VPCEndpointServicePermissions":                     Unmapped,
	"AWS::EC2::VPCGatewayAttachment":                              Ec2VpnGateway,
	"AWS::EC2::VPCPeeringConnection":                              Ec2VpcPeering,
	"AWS::EC2::VPNConnection":                                     Unmapped,
	"AWS::EC2::VPNConnectionRoute":                                Unmapped,
	"AWS::EC2::VPNGateway":                                        Ec2VpnGateway,
	"AWS::EC2::VPNGatewayRoutePropagation":                        Unmapped,
	"AWS::EC2::Volume":                                            Ec2Volume,
	"AWS::EC2::VolumeAttachment":                                  Ec2Volume,
	"AWS::ECR::Repository":                                        EcrRepository,
	"AWS::ECS::CapacityProvider":                                  EcsCapacityProvider,
	"AWS::ECS::Cluster":                                           EcsCluster,
	"AWS::ECS::PrimaryTaskSet":                                    Unmapped,
	"AWS::ECS::Service":                                           EcsService,
	"AWS::ECS::TaskDefinition":                                    EcsTaskDefinition,
	"AWS::ECS::TaskSet":                                           Unmapped,
	"AWS::EFS::AccessPoint":                                       EfsAccessPoint,
	"AWS::EFS::FileSystem":                                        EfsFileSystem,
	"AWS::EFS::MountTarget":                                       EfsMountTarget,
	"AWS::EKS::Cluster":                                           EksCluster,
	"AWS::EKS::FargateProfile":                                    EksFargateProfile,
	"AWS::EKS::Nodegroup":                                         EksNodeGroup,
	"AWS::EMR::Cluster":                                           EmrCluster,
	"AWS::EMR::InstanceFleetConfig":                               EmrInstanceFleetConfig,
	"AWS::EMR::InstanceGroupConfig":                               EmrInstanceGroupConfig,
	"AWS::EMR::SecurityConfiguration":                             EmrSecurityConfiguration,
	"AWS::EMR::Step":                                              EmrStep,
	"AWS::ElastiCache::CacheCluster":                              ElasticacheCluster,
	"AWS::ElastiCache::ParameterGroup":                            ElasticacheParameterGroup,
	"AWS::ElastiCache::ReplicationGroup":                          ElasticacheReplicationGroup,
	"AWS::ElastiCache::SecurityGroup":                             ElasticacheSecurityGroup,
	"AWS::ElastiCache::SecurityGroupIngress":                      Unmapped,
	"AWS::ElastiCache::SubnetGroup":                               ElasticacheSubnetGroup,
	"AWS::ElasticBeanstalk::Application":                          ElasticBeanstalkApplication,
	"AWS::ElasticBeanstalk::ApplicationVersion":                   Unmapped,
	"AWS::ElasticBeanstalk::ConfigurationTemplate":                ElasticBeanstalkEnvironment,
	"AWS::ElasticBeanstalk::Environment":                          ElasticBeanstalkEnvironment,
	"AWS::ElasticLoadBalancing::LoadBalancer":                     ElbLoadBalancer,
	"AWS::ElasticLoadBalancingV2::Listener":                       ElbV2Listener,
	"AWS::ElasticLoadBalancingV2::ListenerCertificate":            Unmapped,
	"AWS::ElasticLoadBalancingV2::ListenerRule":                   ElbV2ListenerRule,
	"AWS::ElasticLoadBalancingV2::LoadBalancer":                   ElbV2LoadBalancer,
	"AWS::ElasticLoadBalancingV2::TargetGroup":                    ElbV2TargetGroup,
	"AWS::Elasticsearch::Domain":                                  ElasticsearchDomain,
	"AWS::Events::EventBus":                                       EventsBus,
	"AWS::Events::EventBusPolicy":                                 EventsBus,
	"AWS::Events::Rule":                                           EventsRule,
	"AWS::EventSchemas::Discoverer":                               Unmapped,
	"AWS::EventSchemas::Registry":                                 Unmapped,
	"AWS::EventSchemas::RegistryPolicy":                           Unmapped,
	"AWS::EventSchemas::Schema":                                   Unmapped,
	"AWS::FMS::NotificationChannel":                               Unmapped,
	"AWS::FMS::Policy":                                            Unmapped,
	"AWS::FSx::FileSystem":                                        FSxFileSystem,
	"AWS::GameLift::Alias":                                        Unmapped,
	"AWS::GameLift::Build":                                        Unmapped,
	"AWS::GameLift::Fleet":                                        Unmapped,
	"AWS::GameLift::GameServerGroup":                              Unmapped,
	"AWS::GameLift::GameSessionQueue":                             Unmapped,
	"AWS::GameLift::MatchmakingConfiguration":                     Unmapped,
	"AWS::GameLift::MatchmakingRuleSet":                           Unmapped,
	"AWS::GameLift::Script":                                       Unmapped,
	"AWS::GlobalAccelerator::Accelerator":                         Unmapped,
	"AWS::GlobalAccelerator::EndpointGroup":                       Unmapped,
	"AWS::GlobalAccelerator::Listener":                            Unmapped,
	"AWS::Glue::Classifier":                                       Unmapped,
	"AWS::Glue::Connection":                                       Unmapped,
	"AWS::Glue::Crawler":                                          Unmapped,
	"AWS::Glue::DataCatalogEncryptionSettings":                    Unmapped,
	"AWS::Glue::Database":                                         Unmapped,
	"AWS::Glue::DevEndpoint":                                      Unmapped,
	"AWS::Glue::Job":                                              Unmapped,
	"AWS::Glue::MLTransform":                                      Unmapped,
	"AWS::Glue::Partition":                                        Unmapped,
	"AWS::Glue::SecurityConfiguration":                            Unmapped,
	"AWS::Glue::Table":                                            Unmapped,
	"AWS::Glue::Trigger":                                          Unmapped,
	"AWS::Glue::Workflow":                                         Unmapped,
	"AWS::Greengrass::ConnectorDefinition":                        GreengrassConnectorDefinition,
	"AWS::Greengrass::ConnectorDefinitionVersion":                 GreengrassConnectorDefinitionVersion,
	"AWS::Greengrass::CoreDefinition":                             GreengrassCoreDefinition,
	"AWS::Greengrass::CoreDefinitionVersion":                      GreengrassCoreDefinitionVersion,
	"AWS::Greengrass::DeviceDefinition":                           GreengrassDeviceDefinition,
	"AWS::Greengrass::DeviceDefinitionVersion":                    GreengrassDeviceDefinitionVersion,
	"AWS::Greengrass::FunctionDefinition":                         GreengrassFunctionDefinition,
	"AWS::Greengrass::FunctionDefinitionVersion":                  GreengrassFunctionDefinitionVersion,
	"AWS::Greengrass::Group":                                      GreengrassGroup,
	"AWS::Greengrass::GroupVersion":                               GreengrassGroupVersion,
	"AWS::Greengrass::LoggerDefinition":                           GreengrassLoggerDefinition,
	"AWS::Greengrass::LoggerDefinitionVersion":                    GreengrassLoggerDefinitionVersion,
	"AWS::Greengrass::ResourceDefinition":                         GreengrassResourceDefinition,
	"AWS::Greengrass::ResourceDefinitionVersion":                  GreengrassResourceDefinitionVersion,
	"AWS::Greengrass::SubscriptionDefinition":                     GreengrassSubscriptionDefinition,
	"AWS::Greengrass::SubscriptionDefinitionVersion":              GreengrassSubscriptionDefinitionVersion,
	"AWS::GuardDuty::Detector":                                    Unmapped,
	"AWS::GuardDuty::Filter":                                      Unmapped,
	"AWS::GuardDuty::IPSet":                                       Unmapped,
	"AWS::GuardDuty::Master":                                      Unmapped,
	"AWS::GuardDuty::Member":                                      Unmapped,
	"AWS::GuardDuty::ThreatIntelSet":                              Unmapped,
	"AWS::IAM::AccessKey":                                         IamAccessKey,
	"AWS::IAM::Group":                                             IamGroup,
	"AWS::IAM::InstanceProfile":                                   IamInstanceProfile,
	"AWS::IAM::ManagedPolicy":                                     IamPolicy,
	"AWS::IAM::Policy":                                            IamPolicy,
	"AWS::IAM::Role":                                              IamRole,
	"AWS::IAM::ServiceLinkedRole":                                 Unmapped,
	"AWS::IAM::User":                                              IamUser,
	"AWS::IAM::UserToGroupAddition":                               Unmapped,
	"AWS::ImageBuilder::Component":                                Unmapped,
	"AWS::ImageBuilder::DistributionConfiguration":                Unmapped,
	"AWS::ImageBuilder::Image":                                    Unmapped,
	"AWS::ImageBuilder::ImagePipeline":                            Unmapped,
	"AWS::ImageBuilder::ImageRecipe":                              Unmapped,
	"AWS::ImageBuilder::InfrastructureConfiguration":              Unmapped,
	"AWS::Inspector::AssessmentTarget":                            Unmapped,
	"AWS::Inspector::AssessmentTemplate":                          Unmapped,
	"AWS::Inspector::ResourceGroup":                               Unmapped,
	"AWS::IoT1Click::Device":                                      Unmapped,
	"AWS::IoT1Click::Placement":                                   Unmapped,
	"AWS::IoT1Click::Project":                                     Unmapped,
	"AWS::IoT::Authorizer":                                        Unmapped,
	"AWS::IoT::Certificate":                                       IoTCertificate,
	"AWS::IoT::Policy":                                            IoTPolicy,
	"AWS::IoT::PolicyPrincipalAttachment":                         Unmapped,
	"AWS::IoT::ProvisioningTemplate":                              Unmapped,
	"AWS::IoT::Thing":                                             IoTThing,
	"AWS::IoT::ThingPrincipalAttachment":                          Unmapped,
	"AWS::IoT::TopicRule":                                         IotTopicRule,
	"AWS::IoTAnalytics::Channel":                                  Unmapped,
	"AWS::IoTAnalytics::Dataset":                                  Unmapped,
	"AWS::IoTAnalytics::Datastore":                                Unmapped,
	"AWS::IoTAnalytics::Pipeline":                                 Unmapped,
	"AWS::IoTEvents::DetectorModel":                               Unmapped,
	"AWS::IoTEvents::Input":                                       Unmapped,
	"AWS::IoTThingsGraph::FlowTemplate":                           Unmapped,
	"AWS::KMS::Alias":                                             KmsAlias,
	"AWS::KMS::Key":                                               KmsKey,
	"AWS::Kendra::DataSource":                                     Unmapped,
	"AWS::Kendra::Faq":                                            Unmapped,
	"AWS::Kendra::Index":                                          Unmapped,
	"AWS::Kinesis::Stream":                                        KinesisStream,
	"AWS::Kinesis::StreamConsumer":                                Unmapped,
	"AWS::KinesisAnalytics::Application":                          Unmapped,
	"AWS::KinesisAnalytics::ApplicationOutput":                    Unmapped,
	"AWS::KinesisAnalytics::ApplicationReferenceDataSource":       Unmapped,
	"AWS::KinesisAnalyticsV2::Application":                        Unmapped,
	"AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption": Unmapped,
	"AWS::KinesisAnalyticsV2::ApplicationOutput":                  Unmapped,
	"AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource":     Unmapped,
	"AWS::KinesisFirehose::DeliveryStream":                        FirehoseDeliveryStream,
	"AWS::LakeFormation::DataLakeSettings":                        Unmapped,
	"AWS::LakeFormation::Permissions":                             Unmapped,
	"AWS::LakeFormation::Resource":                                Unmapped,
	"AWS::Lambda::Alias":                                          LambdaAlias,
	"AWS::Lambda::EventInvokeConfig":                              LambdaFunction, //LambdaEventInvokeConfig,
	"AWS::Lambda::EventSourceMapping":                             LambdaEventSourceMapping,
	"AWS::Lambda::Function":                                       LambdaFunction,
	"AWS::Lambda::LayerVersion":                                   LambdaLayerVersion,
	"AWS::Lambda::LayerVersionPermission":                         Unmapped,
	"AWS::Lambda::Permission":                                     Unnecessary,
	"AWS::Lambda::Version":                                        LambdaVersion,
	"AWS::Logs::Destination":                                      Unmapped,
	"AWS::Logs::LogGroup":                                         LogGroup,
	"AWS::Logs::LogStream":                                        LogStream,
	"AWS::Logs::MetricFilter":                                     LogMetricFilter,
	"AWS::Logs::SubscriptionFilter":                               LogSubscriptionFilter,
	"AWS::MSK::Cluster":                                           KafkaCluster,
	"AWS::Macie::CustomDataIdentifier":                            Unmapped,
	"AWS::Macie::FindingsFilter":                                  Unmapped,
	"AWS::Macie::Session":                                         Unmapped,
	"AWS::ManagedBlockchain::Member":                              Unmapped,
	"AWS::ManagedBlockchain::Node":                                Unmapped,
	"AWS::MediaConvert::JobTemplate":                              Unmapped,
	"AWS::MediaConvert::Preset":                                   Unmapped,
	"AWS::MediaConvert::Queue":                                    Unmapped,
	"AWS::MediaLive::Channel":                                     Unmapped,
	"AWS::MediaLive::Input":                                       Unmapped,
	"AWS::MediaLive::InputSecurityGroup":                          Unmapped,
	"AWS::MediaStore::Container":                                  Unmapped,
	"AWS::Neptune::DBCluster":                                     NeptuneDbCluster,
	"AWS::Neptune::DBClusterParameterGroup":                       NeptuneDbClusterParameterGroup,
	"AWS::Neptune::DBInstance":                                    NeptuneDbInstance,
	"AWS::Neptune::DBParameterGroup":                              NeptuneDbParameterGroup,
	"AWS::Neptune::DBSubnetGroup":                                 NeptuneDbSubnetGroup,
	"AWS::NetworkManager::CustomerGatewayAssociation":             Unmapped,
	"AWS::NetworkManager::Device":                                 Unmapped,
	"AWS::NetworkManager::GlobalNetwork":                          Unmapped,
	"AWS::NetworkManager::Link":                                   Unmapped,
	"AWS::NetworkManager::LinkAssociation":                        Unmapped,
	"AWS::NetworkManager::Site":                                   Unmapped,
	"AWS::NetworkManager::TransitGatewayRegistration":             Unmapped,
	"AWS::OpsWorks::App":                                          Unmapped,
	"AWS::OpsWorks::ElasticLoadBalancerAttachment":                Unmapped,
	"AWS::OpsWorks::Instance":                                     Unmapped,
	"AWS::OpsWorks::Layer":                                        Unmapped,
	"AWS::OpsWorks::Stack":                                        Unmapped,
	"AWS::OpsWorks::UserProfile":                                  Unmapped,
	"AWS::OpsWorks::Volume":                                       Unmapped,
	"AWS::OpsWorksCM::Server":                                     Unmapped,
	"AWS::Pinpoint::ADMChannel":                                   Unmapped,
	"AWS::Pinpoint::APNSChannel":                                  Unmapped,
	"AWS::Pinpoint::APNSSandboxChannel":                           Unmapped,
	"AWS::Pinpoint::APNSVoipChannel":                              Unmapped,
	"AWS::Pinpoint::APNSVoipSandboxChannel":                       Unmapped,
	"AWS::Pinpoint::App":                                          Unmapped,
	"AWS::Pinpoint::ApplicationSettings":                          Unmapped,
	"AWS::Pinpoint::BaiduChannel":                                 Unmapped,
	"AWS::Pinpoint::Campaign":                                     Unmapped,
	"AWS::Pinpoint::EmailChannel":                                 Unmapped,
	"AWS::Pinpoint::EmailTemplate":                                Unmapped,
	"AWS::Pinpoint::EventStream":                                  Unmapped,
	"AWS::Pinpoint::GCMChannel":                                   Unmapped,
	"AWS::Pinpoint::PushTemplate":                                 Unmapped,
	"AWS::Pinpoint::SMSChannel":                                   Unmapped,
	"AWS::Pinpoint::SmsTemplate":                                  Unmapped,
	"AWS::Pinpoint::Segment":                                      Unmapped,
	"AWS::Pinpoint::VoiceChannel":                                 Unmapped,
	"AWS::PinpointEmail::ConfigurationSet":                        Unmapped,
	"AWS::PinpointEmail::ConfigurationSetEventDestination":        Unmapped,
	"AWS::PinpointEmail::DedicatedIpPool":                         Unmapped,
	"AWS::PinpointEmail::Identity":                                Unmapped,
	"AWS::QLDB::Ledger":                                           QLDBLedger,
	"AWS::QLDB::Stream":                                           Unmapped,
	"AWS::RAM::ResourceShare":                                     Unmapped,
	"AWS::RDS::DBCluster":                                         RdsDbCluster,
	"AWS::RDS::DBClusterParameterGroup":                           RdsDbClusterParameterGroup,
	"AWS::RDS::DBInstance":                                        RdsDbInstance,
	"AWS::RDS::DBParameterGroup":                                  RdsDbParameterGroup,
	"AWS::RDS::DBProxy":                                           RdsDbProxy,
	"AWS::RDS::DBProxyTargetGroup":                                Unmapped,
	"AWS::RDS::DBSecurityGroup":                                   Unmapped, // TODO: are these different than ec2 security groups?
	"AWS::RDS::DBSecurityGroupIngress":                            Unmapped,
	"AWS::RDS::DBSubnetGroup":                                     RdsDbSubnetGroup,
	"AWS::RDS::EventSubscription":                                 Unmapped,
	"AWS::RDS::OptionGroup":                                       Unmapped,
	"AWS::Redshift::Cluster":                                      RedshiftCluster,
	"AWS::Redshift::ClusterParameterGroup":                        RedshiftParameterGroup,
	"AWS::Redshift::ClusterSecurityGroup":                         RedshiftSecurityGroup,
	"AWS::Redshift::ClusterSecurityGroupIngress":                  Unmapped,
	"AWS::Redshift::ClusterSubnetGroup":                           RedshiftSubnetGroup,
	"AWS::ResourceGroups::Group":                                  Unmapped,
	"AWS::RoboMaker::Fleet":                                       Unmapped,
	"AWS::RoboMaker::Robot":                                       Unmapped,
	"AWS::RoboMaker::RobotApplication":                            Unmapped,
	"AWS::RoboMaker::RobotApplicationVersion":                     Unmapped,
	"AWS::RoboMaker::SimulationApplication":                       Unmapped,
	"AWS::RoboMaker::SimulationApplicationVersion":                Unmapped,
	"AWS::Route53::HealthCheck":                                   Route53HealthCheck,
	"AWS::Route53::HostedZone":                                    Route53HostedZone,
	"AWS::Route53::RecordSet":                                     Route53RecordSet,
	"AWS::Route53::RecordSetGroup":                                Unmapped,
	"AWS::Route53Resolver::ResolverEndpoint":                      Unmapped,
	"AWS::Route53Resolver::ResolverQueryLoggingConfig":            Unmapped,
	"AWS::Route53Resolver::ResolverQueryLoggingConfigAssociation": Unmapped,
	"AWS::Route53Resolver::ResolverRule":                          Unmapped,
	"AWS::Route53Resolver::ResolverRuleAssociation":               Unmapped,
	"AWS::S3::AccessPoint":                                        Unmapped,
	"AWS::S3::Bucket":                                             S3Bucket,
	"AWS::S3::BucketPolicy":                                       S3Bucket,
	"AWS::SDB::Domain":                                            Unmapped,
	"AWS::SES::ConfigurationSet":                                  Unmapped,
	"AWS::SES::ConfigurationSetEventDestination":                  Unmapped,
	"AWS::SES::ReceiptFilter":                                     Unmapped,
	"AWS::SES::ReceiptRule":                                       Unmapped,
	"AWS::SES::ReceiptRuleSet":                                    Unmapped,
	"AWS::SES::Template":                                          Unmapped,
	"AWS::SNS::Subscription":                                      SnsSubscription,
	"AWS::SNS::Topic":                                             SnsTopic,
	"AWS::SNS::TopicPolicy":                                       SnsTopic,
	"AWS::SQS::Queue":                                             SqsQueue,
	"AWS::SQS::QueuePolicy":                                       SqsQueue,
	"AWS::SSM::Association":                                       Unmapped,
	"AWS::SSM::Document":                                          SsmDocument,
	"AWS::SSM::MaintenanceWindow":                                 Unmapped,
	"AWS::SSM::MaintenanceWindowTarget":                           Unmapped,
	"AWS::SSM::MaintenanceWindowTask":                             Unmapped,
	"AWS::SSM::Parameter":                                         SsmParameter,
	"AWS::SSM::PatchBaseline":                                     Unmapped,
	"AWS::SSM::ResourceDataSync":                                  Unmapped,
	"AWS::SSO::Assignment":                                        Unmapped,
	"AWS::SSO::PermissionSet":                                     Unmapped,
	"AWS::SageMaker::CodeRepository":                              Unmapped,
	"AWS::SageMaker::Endpoint":                                    Unmapped,
	"AWS::SageMaker::EndpointConfig":                              Unmapped,
	"AWS::SageMaker::Model":                                       Unmapped,
	"AWS::SageMaker::MonitoringSchedule":                          Unmapped,
	"AWS::SageMaker::NotebookInstance":                            Unmapped,
	"AWS::SageMaker::NotebookInstanceLifecycleConfig":             Unmapped,
	"AWS::SageMaker::Workteam":                                    Unmapped,
	"AWS::SecretsManager::ResourcePolicy":                         SecretManagerSecret,
	"AWS::SecretsManager::RotationSchedule":                       SecretManagerSecret,
	"AWS::SecretsManager::Secret":                                 SecretManagerSecret,
	"AWS::SecretsManager::SecretTargetAttachment":                 Unmapped,
	"AWS::SecurityHub::Hub":                                       Unmapped,
	"AWS::ServiceCatalog::AcceptedPortfolioShare":                 ServiceCatalogAcceptedPortfolioShare,
	"AWS::ServiceCatalog::CloudFormationProduct":                  Unmapped,
	"AWS::ServiceCatalog::CloudFormationProvisionedProduct":       Unmapped,
	"AWS::ServiceCatalog::LaunchNotificationConstraint":           Unmapped,
	"AWS::ServiceCatalog::LaunchRoleConstraint":                   Unmapped,
	"AWS::ServiceCatalog::LaunchTemplateConstraint":               Unmapped,
	"AWS::ServiceCatalog::Portfolio":                              ServiceCatalogPortfolio,
	"AWS::ServiceCatalog::PortfolioPrincipalAssociation":          ServiceCatalogPortfolio,
	"AWS::ServiceCatalog::PortfolioProductAssociation":            Unmapped,
	"AWS::ServiceCatalog::PortfolioShare":                         Unmapped,
	"AWS::ServiceCatalog::ResourceUpdateConstraint":               Unmapped,
	"AWS::ServiceCatalog::StackSetConstraint":                     Unmapped,
	"AWS::ServiceCatalog::TagOption":                              ServiceCatalogPortfolio,
	"AWS::ServiceCatalog::TagOptionAssociation":                   ServiceCatalogPortfolio,
	"AWS::ServiceDiscovery::HttpNamespace":                        Unmapped,
	"AWS::ServiceDiscovery::Instance":                             Unmapped,
	"AWS::ServiceDiscovery::PrivateDnsNamespace":                  Unmapped,
	"AWS::ServiceDiscovery::PublicDnsNamespace":                   Unmapped,
	"AWS::ServiceDiscovery::Service":                              Unmapped,
	"AWS::StepFunctions::Activity":                                Unmapped,
	"AWS::StepFunctions::StateMachine":                            StepFunctionStateMachine,
	"AWS::Synthetics::Canary":                                     Unmapped,
	"AWS::Transfer::Server":                                       Unmapped,
	"AWS::Transfer::User":                                         Unmapped,
	"AWS::WAF::ByteMatchSet":                                      WafByteMatchSet,
	"AWS::WAF::IPSet":                                             WafIpSet,
	"AWS::WAF::Rule":                                              WafRule,
	"AWS::WAF::SizeConstraintSet":                                 WafSizeConstraintSet,
	"AWS::WAF::SqlInjectionMatchSet":                              WafSqlInjectionMatchSet,
	"AWS::WAF::WebACL":                                            WafWebACL,
	"AWS::WAF::XssMatchSet":                                       WafXssMatchSet,
	"AWS::WAFv2::IPSet":                                           Wafv2IpSet,
	"AWS::WAFv2::RegexPatternSet":                                 Wafv2RegexPatternSet,
	"AWS::WAFv2::RuleGroup":                                       Wafv2RuleGroup,
	"AWS::WAFv2::WebACL":                                          Wafv2WebACL,
	"AWS::WAFv2::WebACLAssociation":                               Unmapped,
	"AWS::WAFRegional::ByteMatchSet":                              WafRegionalByteMatchSet,
	"AWS::WAFRegional::GeoMatchSet":                               WafRegionalGeoMatchSet,
	"AWS::WAFRegional::IPSet":                                     WafRegionalIpSet,
	"AWS::WAFRegional::RateBasedRule":                             WafRegionalRateBasedRule,
	"AWS::WAFRegional::RegexPatternSet":                           WafRegionalRegexPatternSet,
	"AWS::WAFRegional::Rule":                                      WafRegionalRule,
	"AWS::WAFRegional::SizeConstraintSet":                         WafRegionalSizeConstraint,
	"AWS::WAFRegional::SqlInjectionMatchSet":                      WafRegionalSqlInjectionMatchSet,
	"AWS::WAFRegional::WebACL":                                    WafRegionalWebACL,
	"AWS::WAFRegional::WebACLAssociation":                         Unmapped,
	"AWS::WAFRegional::XssMatchSet":                               WafRegionalXssMatchSet,
	"AWS::WorkSpaces::Workspace":                                  WorkspacesWorkspace,
}

func FromCfn(input string) (ResourceType, error) {
	val, ok := mapping[input]
	if !ok || val == Unmapped {
		return ResourceType(strings.ReplaceAll(input, "::", "/")), fmt.Errorf("no type defined for %s", input)
	}
	return val, nil
}
