// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Each step type has its own StepDetails structure.
type CopyStepDetails struct {

	// Specifies the location for the file being copied. Only applicable for the Copy
	// type of workflow steps.
	DestinationFileLocation *InputFileLocation

	// The name of the step, used as an identifier.
	Name *string

	// A flag that indicates whether or not to overwrite an existing file of the same
	// name. The default is FALSE.
	OverwriteExisting OverwriteExisting

	noSmithyDocumentSerde
}

// Each step type has its own StepDetails structure.
type CustomStepDetails struct {

	// The name of the step, used as an identifier.
	Name *string

	// The ARN for the lambda function that is being called.
	Target *string

	// Timeout, in seconds, for the step.
	TimeoutSeconds *int32

	noSmithyDocumentSerde
}

// The name of the step, used to identify the delete step.
type DeleteStepDetails struct {

	// The name of the step, used as an identifier.
	Name *string

	noSmithyDocumentSerde
}

// Describes the properties of the access that was specified.
type DescribedAccess struct {

	// A unique identifier that is required to identify specific groups within your
	// directory. The users of the group that you associate have access to your Amazon
	// S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services
	// Transfer Family. If you know the group name, you can view the SID values by
	// running the following command using Windows PowerShell. Get-ADGroup -Filter
	// {samAccountName -like "YourGroupName*"} -Properties * | Select
	// SamAccountName,ObjectSid In that command, replace YourGroupName with the name of
	// your Active Directory group. The regex used to validate this parameter is a
	// string of characters consisting of uppercase and lowercase alphanumeric
	// characters with no spaces. You can also include underscores or any of the
	// following characters: =,.@:/-
	ExternalId *string

	// The landing directory (folder) for a user when they log in to the server using
	// the client. A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string

	// Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and
	// keys should be visible to your user and how you want to make them visible. You
	// must specify the Entry and Target pair, where Entry shows how the path is made
	// visible and Target is the actual Amazon S3 or Amazon EFS path. If you only
	// specify a target, it is displayed as is. You also must ensure that your Amazon
	// Web Services Identity and Access Management (IAM) role provides access to paths
	// in Target. This value can only be set when HomeDirectoryType is set to LOGICAL.
	// In most cases, you can use this value instead of the session policy to lock down
	// the associated access to the designated home directory ("chroot"). To do this,
	// you can set Entry to '/' and set Target to the HomeDirectory parameter value.
	HomeDirectoryMappings []HomeDirectoryMapEntry

	// The type of landing directory (folder) you want your users' home directory to be
	// when they log into the server. If you set it to PATH, the user will see the
	// absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol
	// clients. If you set it LOGICAL, you need to provide mappings in the
	// HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths visible to
	// your users.
	HomeDirectoryType HomeDirectoryType

	// A session policy for your user so that you can use the same IAM role across
	// multiple users. This policy scopes down user access to portions of their Amazon
	// S3 bucket. Variables that you can use inside this policy include
	// ${Transfer:UserName}, ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	Policy *string

	// The full POSIX identity, including user ID (Uid), group ID (Gid), and any
	// secondary groups IDs (SecondaryGids), that controls your users' access to your
	// Amazon EFS file systems. The POSIX permissions that are set on files and
	// directories in your file system determine the level of access your users get
	// when transferring files into and out of your Amazon EFS file systems.
	PosixProfile *PosixProfile

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your users
	// when transferring files into and out of your Amazon S3 bucket or EFS file
	// system. The IAM role should also contain a trust relationship that allows the
	// server to access your resources when servicing your users' transfer requests.
	Role *string

	noSmithyDocumentSerde
}

// The details for an execution object.
type DescribedExecution struct {

	// A unique identifier for the execution of a workflow.
	ExecutionId *string

	// The IAM role associated with the execution.
	ExecutionRole *string

	// A structure that describes the Amazon S3 or EFS file location. This is the file
	// location when the execution begins: if the file is being copied, this is the
	// initial (as opposed to destination) file location.
	InitialFileLocation *FileLocation

	// The IAM logging role associated with the execution.
	LoggingConfiguration *LoggingConfiguration

	// The full POSIX identity, including user ID (Uid), group ID (Gid), and any
	// secondary groups IDs (SecondaryGids), that controls your users' access to your
	// Amazon EFS file systems. The POSIX permissions that are set on files and
	// directories in your file system determine the level of access your users get
	// when transferring files into and out of your Amazon EFS file systems.
	PosixProfile *PosixProfile

	// A structure that describes the execution results. This includes a list of the
	// steps along with the details of each step, error type and message (if any), and
	// the OnExceptionSteps structure.
	Results *ExecutionResults

	// A container object for the session details associated with a workflow.
	ServiceMetadata *ServiceMetadata

	// The status is one of the execution. Can be in progress, completed, exception
	// encountered, or handling the exception.
	Status ExecutionStatus

	noSmithyDocumentSerde
}

// Describes the properties of a security policy that was specified. For more
// information about security policies, see Working with security policies
// (https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html).
type DescribedSecurityPolicy struct {

	// Specifies the name of the security policy that is attached to the server.
	//
	// This member is required.
	SecurityPolicyName *string

	// Specifies whether this policy enables Federal Information Processing Standards
	// (FIPS).
	Fips *bool

	// Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the
	// security policy that is attached to the server.
	SshCiphers []string

	// Specifies the enabled SSH key exchange (KEX) encryption algorithms in the
	// security policy that is attached to the server.
	SshKexs []string

	// Specifies the enabled SSH message authentication code (MAC) encryption
	// algorithms in the security policy that is attached to the server.
	SshMacs []string

	// Specifies the enabled Transport Layer Security (TLS) cipher encryption
	// algorithms in the security policy that is attached to the server.
	TlsCiphers []string

	noSmithyDocumentSerde
}

// Describes the properties of a file transfer protocol-enabled server that was
// specified.
type DescribedServer struct {

	// Specifies the unique Amazon Resource Name (ARN) of the server.
	//
	// This member is required.
	Arn *string

	// Specifies the ARN of the Amazon Web ServicesCertificate Manager (ACM)
	// certificate. Required when Protocols is set to FTPS.
	Certificate *string

	// Specifies the domain of the storage system that is used for file transfers.
	Domain Domain

	// The virtual private cloud (VPC) endpoint settings that are configured for your
	// server. When you host your endpoint within your VPC, you can make it accessible
	// only to resources within your VPC, or you can attach Elastic IP addresses and
	// make it accessible to clients over the internet. Your VPC's default security
	// groups are automatically assigned to your endpoint.
	EndpointDetails *EndpointDetails

	// Defines the type of endpoint that your server is connected to. If your server is
	// connected to a VPC endpoint, your server isn't accessible over the public
	// internet.
	EndpointType EndpointType

	// Specifies the Base64-encoded SHA256 fingerprint of the server's host key. This
	// value is equivalent to the output of the ssh-keygen -l -f my-new-server-key
	// command.
	HostKeyFingerprint *string

	// Specifies information to call a customer-supplied authentication API. This field
	// is not populated when the IdentityProviderType of a server is
	// AWS_DIRECTORY_SERVICE or SERVICE_MANAGED.
	IdentityProviderDetails *IdentityProviderDetails

	// Specifies the mode of authentication for a server. The default value is
	// SERVICE_MANAGED, which allows you to store and access user credentials within
	// the Amazon Web Services Transfer Family service. Use AWS_DIRECTORY_SERVICE to
	// provide access to Active Directory groups in Amazon Web Services Managed Active
	// Directory or Microsoft Active Directory in your on-premises environment or in
	// Amazon Web Services using AD Connectors. This option also requires you to
	// provide a Directory ID using the IdentityProviderDetails parameter. Use the
	// API_GATEWAY value to integrate with an identity provider of your choosing. The
	// API_GATEWAY setting requires you to provide an API Gateway endpoint URL to call
	// for authentication using the IdentityProviderDetails parameter.
	IdentityProviderType IdentityProviderType

	// Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and
	// Access Management (IAM) role that allows a server to turn on Amazon CloudWatch
	// logging for Amazon S3 or Amazon EFS events. When set, user activity can be
	// viewed in your CloudWatch logs.
	LoggingRole *string

	// The protocol settings that are configured for your server. Use the PassiveIp
	// parameter to indicate passive mode. Enter a single dotted-quad IPv4 address,
	// such as the external IP address of a firewall, router, or load balancer.
	ProtocolDetails *ProtocolDetails

	// Specifies the file transfer protocol or protocols over which your file transfer
	// protocol client can connect to your server's endpoint. The available protocols
	// are:
	//
	// * SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over
	// SSH
	//
	// * FTPS (File Transfer Protocol Secure): File transfer with TLS
	// encryption
	//
	// * FTP (File Transfer Protocol): Unencrypted file transfer
	Protocols []Protocol

	// Specifies the name of the security policy that is attached to the server.
	SecurityPolicyName *string

	// Specifies the unique system-assigned identifier for a server that you
	// instantiate.
	ServerId *string

	// Specifies the condition of a server for the server that was described. A value
	// of ONLINE indicates that the server can accept jobs and transfer files. A State
	// value of OFFLINE means that the server cannot perform file transfer operations.
	// The states of STARTING and STOPPING indicate that the server is in an
	// intermediate state, either not fully able to respond, or not fully offline. The
	// values of START_FAILED or STOP_FAILED can indicate an error condition.
	State State

	// Specifies the key-value pairs that you can use to search for and group servers
	// that were assigned to the server that was described.
	Tags []Tag

	// Specifies the number of users that are assigned to a server you specified with
	// the ServerId.
	UserCount *int32

	// Specifies the workflow ID for the workflow to assign and the execution role used
	// for executing the workflow.
	WorkflowDetails *WorkflowDetails

	noSmithyDocumentSerde
}

// Describes the properties of a user that was specified.
type DescribedUser struct {

	// Specifies the unique Amazon Resource Name (ARN) for the user that was requested
	// to be described.
	//
	// This member is required.
	Arn *string

	// The landing directory (folder) for a user when they log in to the server using
	// the client. A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string

	// Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and
	// keys should be visible to your user and how you want to make them visible. You
	// must specify the Entry and Target pair, where Entry shows how the path is made
	// visible and Target is the actual Amazon S3 or Amazon EFS path. If you only
	// specify a target, it is displayed as is. You also must ensure that your Amazon
	// Web Services Identity and Access Management (IAM) role provides access to paths
	// in Target. This value can only be set when HomeDirectoryType is set to LOGICAL.
	// In most cases, you can use this value instead of the session policy to lock your
	// user down to the designated home directory ("chroot"). To do this, you can set
	// Entry to '/' and set Target to the HomeDirectory parameter value.
	HomeDirectoryMappings []HomeDirectoryMapEntry

	// The type of landing directory (folder) you want your users' home directory to be
	// when they log into the server. If you set it to PATH, the user will see the
	// absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol
	// clients. If you set it LOGICAL, you need to provide mappings in the
	// HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths visible to
	// your users.
	HomeDirectoryType HomeDirectoryType

	// A session policy for your user so that you can use the same IAM role across
	// multiple users. This policy scopes down user access to portions of their Amazon
	// S3 bucket. Variables that you can use inside this policy include
	// ${Transfer:UserName}, ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	Policy *string

	// Specifies the full POSIX identity, including user ID (Uid), group ID (Gid), and
	// any secondary groups IDs (SecondaryGids), that controls your users' access to
	// your Amazon Elastic File System (Amazon EFS) file systems. The POSIX permissions
	// that are set on files and directories in your file system determine the level of
	// access your users get when transferring files into and out of your Amazon EFS
	// file systems.
	PosixProfile *PosixProfile

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your users
	// when transferring files into and out of your Amazon S3 bucket or EFS file
	// system. The IAM role should also contain a trust relationship that allows the
	// server to access your resources when servicing your users' transfer requests.
	Role *string

	// Specifies the public key portion of the Secure Shell (SSH) keys stored for the
	// described user.
	SshPublicKeys []SshPublicKey

	// Specifies the key-value pairs for the user requested. Tag can be used to search
	// for and group users for a variety of purposes.
	Tags []Tag

	// Specifies the name of the user that was requested to be described. User names
	// are used for authentication purposes. This is the string that will be used by
	// your user when they log in to your server.
	UserName *string

	noSmithyDocumentSerde
}

// Describes the properties of the specified workflow
type DescribedWorkflow struct {

	// Specifies the unique Amazon Resource Name (ARN) for the workflow.
	//
	// This member is required.
	Arn *string

	// Specifies the text description for the workflow.
	Description *string

	// Specifies the steps (actions) to take if errors are encountered during execution
	// of the workflow.
	OnExceptionSteps []WorkflowStep

	// Specifies the details for the steps that are in the specified workflow.
	Steps []WorkflowStep

	// Key-value pairs that can be used to group and search for workflows. Tags are
	// metadata attached to workflows for any purpose.
	Tags []Tag

	// A unique identifier for the workflow.
	WorkflowId *string

	noSmithyDocumentSerde
}

// Reserved for future use.
type EfsFileLocation struct {

	// The ID of the file system, assigned by Amazon EFS.
	FileSystemId *string

	// The pathname for the folder being used by a workflow.
	Path *string

	noSmithyDocumentSerde
}

// The virtual private cloud (VPC) endpoint settings that are configured for your
// file transfer protocol-enabled server. With a VPC endpoint, you can restrict
// access to your server and resources only within your VPC. To control incoming
// internet traffic, invoke the UpdateServer API and attach an Elastic IP address
// to your server's endpoint. After May 19, 2021, you won't be able to create a
// server using EndpointType=VPC_ENDPOINT in your Amazon Web Servicesaccount if
// your account hasn't already done so before May 19, 2021. If you have already
// created servers with EndpointType=VPC_ENDPOINT in your Amazon Web
// Servicesaccount on or before May 19, 2021, you will not be affected. After this
// date, use EndpointType=VPC. For more information, see
// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
type EndpointDetails struct {

	// A list of address allocation IDs that are required to attach an Elastic IP
	// address to your server's endpoint. This property can only be set when
	// EndpointType is set to VPC and it is only valid in the UpdateServer API.
	AddressAllocationIds []string

	// A list of security groups IDs that are available to attach to your server's
	// endpoint. This property can only be set when EndpointType is set to VPC. You can
	// edit the SecurityGroupIds property in the UpdateServer
	// (https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html)
	// API only if you are changing the EndpointType from PUBLIC or VPC_ENDPOINT to
	// VPC. To change security groups associated with your server's VPC endpoint after
	// creation, use the Amazon EC2 ModifyVpcEndpoint
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html)
	// API.
	SecurityGroupIds []string

	// A list of subnet IDs that are required to host your server endpoint in your VPC.
	// This property can only be set when EndpointType is set to VPC.
	SubnetIds []string

	// The ID of the VPC endpoint. This property can only be set when EndpointType is
	// set to VPC_ENDPOINT. For more information, see
	// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
	VpcEndpointId *string

	// The VPC ID of the VPC in which a server's endpoint will be hosted. This property
	// can only be set when EndpointType is set to VPC.
	VpcId *string

	noSmithyDocumentSerde
}

// Specifies the error message and type, for an error that occurs during the
// execution of the workflow.
type ExecutionError struct {

	// Specifies the descriptive message that corresponds to the ErrorType.
	//
	// This member is required.
	Message *string

	// Specifies the error type: currently, the only valid value is PERMISSION_DENIED,
	// which occurs if your policy does not contain the correct permissions to complete
	// one or more of the steps in the workflow.
	//
	// This member is required.
	Type ExecutionErrorType

	noSmithyDocumentSerde
}

// Specifies the steps in the workflow, as well as the steps to execute in case of
// any errors during workflow execution.
type ExecutionResults struct {

	// Specifies the steps (actions) to take if errors are encountered during execution
	// of the workflow.
	OnExceptionSteps []ExecutionStepResult

	// Specifies the details for the steps that are in the specified workflow.
	Steps []ExecutionStepResult

	noSmithyDocumentSerde
}

// Specifies the following details for the step: error (if any), outputs (if any),
// and the step type.
type ExecutionStepResult struct {

	// Specifies the details for an error, if it occurred during execution of the
	// specified workfow step.
	Error *ExecutionError

	// The values for the key/value pair applied as a tag to the file. Only applicable
	// if the step type is TAG.
	Outputs *string

	// One of the available step types.
	//
	// * Copy: copy the file to another location
	//
	// *
	// Custom: custom step with a lambda target
	//
	// * Delete: delete the file
	//
	// * Tag: add
	// a tag to the file
	StepType WorkflowStepType

	noSmithyDocumentSerde
}

// Specifies the Amazon S3 or EFS file details to be used in the step.
type FileLocation struct {

	// Specifies the Amazon EFS ID and the path for the file being used.
	EfsFileLocation *EfsFileLocation

	// Specifies the S3 details for the file being used, such as bucket, Etag, and so
	// forth.
	S3FileLocation *S3FileLocation

	noSmithyDocumentSerde
}

// Represents an object that contains entries and targets for
// HomeDirectoryMappings. The following is an Entry and Target pair example for
// chroot. [ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ] If the
// target of a logical directory entry does not exist in Amazon S3 or EFS, the
// entry is ignored. As a workaround, you can use the Amazon S3 API or EFS API to
// create 0 byte objects as place holders for your directory. If using the CLI, use
// the s3api or efsapi call instead of s3 or efs so you can use the put-object
// operation. For example, you use the following: aws s3api put-object --bucket
// bucketname --key path/to/folder/. Make sure that the end of the key name ends in
// a / for it to be considered a folder.
type HomeDirectoryMapEntry struct {

	// Represents an entry for HomeDirectoryMappings.
	//
	// This member is required.
	Entry *string

	// Represents the map target that is used in a HomeDirectorymapEntry.
	//
	// This member is required.
	Target *string

	noSmithyDocumentSerde
}

// Returns information related to the type of user authentication that is in use
// for a file transfer protocol-enabled server's users. A server can have only one
// method of authentication.
type IdentityProviderDetails struct {

	// The identifier of the Amazon Web ServicesDirectory Service directory that you
	// want to stop sharing.
	DirectoryId *string

	// Provides the type of InvocationRole used to authenticate the user account.
	InvocationRole *string

	// Provides the location of the service endpoint used to authenticate users.
	Url *string

	noSmithyDocumentSerde
}

// Specifies the location for the file being copied. Only applicable for the Copy
// type of workflow steps.
type InputFileLocation struct {

	// Reserved for future use.
	EfsFileLocation *EfsFileLocation

	// Specifies the details for the S3 file being copied.
	S3FileLocation *S3InputFileLocation

	noSmithyDocumentSerde
}

// Lists the properties for one or more specified associated accesses.
type ListedAccess struct {

	// A unique identifier that is required to identify specific groups within your
	// directory. The users of the group that you associate have access to your Amazon
	// S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services
	// Transfer Family. If you know the group name, you can view the SID values by
	// running the following command using Windows PowerShell. Get-ADGroup -Filter
	// {samAccountName -like "YourGroupName*"} -Properties * | Select
	// SamAccountName,ObjectSid In that command, replace YourGroupName with the name of
	// your Active Directory group. The regex used to validate this parameter is a
	// string of characters consisting of uppercase and lowercase alphanumeric
	// characters with no spaces. You can also include underscores or any of the
	// following characters: =,.@:/-
	ExternalId *string

	// The landing directory (folder) for a user when they log in to the server using
	// the client. A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string

	// The type of landing directory (folder) you want your users' home directory to be
	// when they log into the server. If you set it to PATH, the user will see the
	// absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol
	// clients. If you set it LOGICAL, you need to provide mappings in the
	// HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths visible to
	// your users.
	HomeDirectoryType HomeDirectoryType

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your users
	// when transferring files into and out of your Amazon S3 bucket or EFS file
	// system. The IAM role should also contain a trust relationship that allows the
	// server to access your resources when servicing your users' transfer requests.
	Role *string

	noSmithyDocumentSerde
}

// Returns properties of the execution that is specified.
type ListedExecution struct {

	// A unique identifier for the execution of a workflow.
	ExecutionId *string

	// A structure that describes the Amazon S3 or EFS file location. This is the file
	// location when the execution begins: if the file is being copied, this is the
	// initial (as opposed to destination) file location.
	InitialFileLocation *FileLocation

	// A container object for the session details associated with a workflow.
	ServiceMetadata *ServiceMetadata

	// The status is one of the execution. Can be in progress, completed, exception
	// encountered, or handling the exception.
	Status ExecutionStatus

	noSmithyDocumentSerde
}

// Returns properties of a file transfer protocol-enabled server that was
// specified.
type ListedServer struct {

	// Specifies the unique Amazon Resource Name (ARN) for a server to be listed.
	//
	// This member is required.
	Arn *string

	// Specifies the domain of the storage system that is used for file transfers.
	Domain Domain

	// Specifies the type of VPC endpoint that your server is connected to. If your
	// server is connected to a VPC endpoint, your server isn't accessible over the
	// public internet.
	EndpointType EndpointType

	// Specifies the mode of authentication for a server. The default value is
	// SERVICE_MANAGED, which allows you to store and access user credentials within
	// the Amazon Web Services Transfer Family service. Use AWS_DIRECTORY_SERVICE to
	// provide access to Active Directory groups in Amazon Web Services Managed Active
	// Directory or Microsoft Active Directory in your on-premises environment or in
	// Amazon Web Services using AD Connectors. This option also requires you to
	// provide a Directory ID using the IdentityProviderDetails parameter. Use the
	// API_GATEWAY value to integrate with an identity provider of your choosing. The
	// API_GATEWAY setting requires you to provide an API Gateway endpoint URL to call
	// for authentication using the IdentityProviderDetails parameter.
	IdentityProviderType IdentityProviderType

	// Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and
	// Access Management (IAM) role that allows a server to turn on Amazon CloudWatch
	// logging for Amazon S3 or Amazon EFS events. When set, user activity can be
	// viewed in your CloudWatch logs.
	LoggingRole *string

	// Specifies the unique system assigned identifier for the servers that were
	// listed.
	ServerId *string

	// Specifies the condition of a server for the server that was described. A value
	// of ONLINE indicates that the server can accept jobs and transfer files. A State
	// value of OFFLINE means that the server cannot perform file transfer operations.
	// The states of STARTING and STOPPING indicate that the server is in an
	// intermediate state, either not fully able to respond, or not fully offline. The
	// values of START_FAILED or STOP_FAILED can indicate an error condition.
	State State

	// Specifies the number of users that are assigned to a server you specified with
	// the ServerId.
	UserCount *int32

	noSmithyDocumentSerde
}

// Returns properties of the user that you specify.
type ListedUser struct {

	// Provides the unique Amazon Resource Name (ARN) for the user that you want to
	// learn about.
	//
	// This member is required.
	Arn *string

	// The landing directory (folder) for a user when they log in to the server using
	// the client. A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string

	// The type of landing directory (folder) you want your users' home directory to be
	// when they log into the server. If you set it to PATH, the user will see the
	// absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol
	// clients. If you set it LOGICAL, you need to provide mappings in the
	// HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths visible to
	// your users.
	HomeDirectoryType HomeDirectoryType

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your users
	// when transferring files into and out of your Amazon S3 bucket or EFS file
	// system. The IAM role should also contain a trust relationship that allows the
	// server to access your resources when servicing your users' transfer requests.
	// The IAM role that controls your users' access to your Amazon S3 bucket for
	// servers with Domain=S3, or your EFS file system for servers with Domain=EFS. The
	// policies attached to this role determine the level of access you want to provide
	// your users when transferring files into and out of your S3 buckets or EFS file
	// systems.
	Role *string

	// Specifies the number of SSH public keys stored for the user you specified.
	SshPublicKeyCount *int32

	// Specifies the name of the user whose ARN was specified. User names are used for
	// authentication purposes.
	UserName *string

	noSmithyDocumentSerde
}

// Contains the ID, text description, and Amazon Resource Name (ARN) for the
// workflow.
type ListedWorkflow struct {

	// Specifies the unique Amazon Resource Name (ARN) for the workflow.
	Arn *string

	// Specifies the text description for the workflow.
	Description *string

	// A unique identifier for the workflow.
	WorkflowId *string

	noSmithyDocumentSerde
}

// Consists of the logging role and the log group name.
type LoggingConfiguration struct {

	// The name of the CloudWatch logging group for the Amazon Web Services Transfer
	// server to which this workflow belongs.
	LogGroupName *string

	// Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and
	// Access Management (IAM) role that allows a server to turn on Amazon CloudWatch
	// logging for Amazon S3 or Amazon EFS events. When set, user activity can be
	// viewed in your CloudWatch logs.
	LoggingRole *string

	noSmithyDocumentSerde
}

// The full POSIX identity, including user ID (Uid), group ID (Gid), and any
// secondary groups IDs (SecondaryGids), that controls your users' access to your
// Amazon EFS file systems. The POSIX permissions that are set on files and
// directories in your file system determine the level of access your users get
// when transferring files into and out of your Amazon EFS file systems.
type PosixProfile struct {

	// The POSIX group ID used for all EFS operations by this user.
	//
	// This member is required.
	Gid *int64

	// The POSIX user ID used for all EFS operations by this user.
	//
	// This member is required.
	Uid *int64

	// The secondary POSIX group IDs used for all EFS operations by this user.
	SecondaryGids []int64

	noSmithyDocumentSerde
}

// The protocol settings that are configured for your server. This type is only
// valid in the UpdateServer API.
type ProtocolDetails struct {

	// Indicates passive mode, for FTP and FTPS protocols. Enter a single dotted-quad
	// IPv4 address, such as the external IP address of a firewall, router, or load
	// balancer. For example:  aws transfer update-server --protocol-details
	// PassiveIp=0.0.0.0  Replace  0.0.0.0  in the example above with the actual IP
	// address you want to use. If you change the PassiveIp value, you must stop and
	// then restart your Transfer server for the change to take effect. For details on
	// using Passive IP (PASV) in a NAT environment, see Configuring your FTPS server
	// behind a firewall or NAT with Amazon Web Services Transfer Family
	// (http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/).
	PassiveIp *string

	noSmithyDocumentSerde
}

// Specifies the details for the file location for the file being used in the
// workflow. Only applicable if you are using S3 storage.
type S3FileLocation struct {

	// Specifies the S3 bucket that contains the file being used.
	Bucket *string

	// The entity tag is a hash of the object. The ETag reflects changes only to the
	// contents of an object, not its metadata.
	Etag *string

	// The name assigned to the file when it was created in S3. You use the object key
	// to retrieve the object.
	Key *string

	// Specifies the file version.
	VersionId *string

	noSmithyDocumentSerde
}

// Specifies the customer input S3 file location. If it is used inside
// copyStepDetails.DestinationFileLocation, it should be the S3 copy destination.
// You need to provide the bucket and key. The key can represent either a path or a
// file. This is determined by whether or not you end the key value with the
// forward slash (/) character. If the final character is "/", then your file is
// copied to the folder, and its name does not change. If, rather, the final
// character is alphanumeric, your uploaded file is renamed to the path value. In
// this case, if a file with that name already exists, it is overwritten. For
// example, if your path is shared-files/bob/, your uploaded files are copied to
// the shared-files/bob/, folder. If your path is shared-files/today, each uploaded
// file is copied to the shared-files folder and named today: each upload
// overwrites the previous version of the bob file.
type S3InputFileLocation struct {

	// Specifies the S3 bucket for the customer input file.
	Bucket *string

	// The name assigned to the file when it was created in S3. You use the object key
	// to retrieve the object.
	Key *string

	noSmithyDocumentSerde
}

// Specifies the key-value pair that are assigned to a file during the execution of
// a Tagging step.
type S3Tag struct {

	// The name assigned to the tag that you create.
	//
	// This member is required.
	Key *string

	// The value that corresponds to the key.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A container object for the session details associated with a workflow.
type ServiceMetadata struct {

	// The Server ID (ServerId), Session ID (SessionId) and user (UserName) make up the
	// UserDetails.
	//
	// This member is required.
	UserDetails *UserDetails

	noSmithyDocumentSerde
}

// Provides information about the public Secure Shell (SSH) key that is associated
// with a user account for the specific file transfer protocol-enabled server (as
// identified by ServerId). The information returned includes the date the key was
// imported, the public key contents, and the public key ID. A user can store more
// than one SSH public key associated with their user name on a specific server.
type SshPublicKey struct {

	// Specifies the date that the public key was added to the user account.
	//
	// This member is required.
	DateImported *time.Time

	// Specifies the content of the SSH public key as specified by the PublicKeyId.
	//
	// This member is required.
	SshPublicKeyBody *string

	// Specifies the SshPublicKeyId parameter contains the identifier of the public
	// key.
	//
	// This member is required.
	SshPublicKeyId *string

	noSmithyDocumentSerde
}

// Creates a key-value pair for a specific resource. Tags are metadata that you can
// use to search for and group a resource for various purposes. You can apply tags
// to servers, users, and roles. A tag key can take more than one value. For
// example, to group servers for accounting purposes, you might create a tag called
// Group and assign the values Research and Accounting to that group.
type Tag struct {

	// The name assigned to the tag that you create.
	//
	// This member is required.
	Key *string

	// Contains one or more values that you assigned to the key name you create.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Each step type has its own StepDetails structure. The key/value pairs used to
// tag a file during the execution of a workflow step.
type TagStepDetails struct {

	// The name of the step, used as an identifier.
	Name *string

	// Array that contains from 1 to 10 key/value pairs.
	Tags []S3Tag

	noSmithyDocumentSerde
}

// Specifies the user name, server ID, and session ID for a workflow.
type UserDetails struct {

	// The system-assigned unique identifier for a Transfer server instance.
	//
	// This member is required.
	ServerId *string

	// A unique string that identifies a user account associated with a server.
	//
	// This member is required.
	UserName *string

	// The system-assigned unique identifier for a session that corresponds to the
	// workflow.
	SessionId *string

	noSmithyDocumentSerde
}

// Specifies the workflow ID for the workflow to assign and the execution role used
// for executing the workflow.
type WorkflowDetail struct {

	// Includes the necessary permissions for S3, EFS, and Lambda operations that
	// Transfer can assume, so that all workflow steps can operate on the required
	// resources
	//
	// This member is required.
	ExecutionRole *string

	// A unique identifier for the workflow.
	//
	// This member is required.
	WorkflowId *string

	noSmithyDocumentSerde
}

// Container for the WorkflowDetail data type. It is used by actions that trigger a
// workflow to begin execution.
type WorkflowDetails struct {

	// A trigger that starts a workflow: the workflow begins to execute after a file is
	// uploaded.
	//
	// This member is required.
	OnUpload []WorkflowDetail

	noSmithyDocumentSerde
}

// The basic building block of a workflow.
type WorkflowStep struct {

	// Details for a step that performs a file copy. Consists of the following
	// values:
	//
	// * A description
	//
	// * An S3 location for the destination of the file
	// copy.
	//
	// * A flag that indicates whether or not to overwrite an existing file of
	// the same name. The default is FALSE.
	CopyStepDetails *CopyStepDetails

	// Details for a step that invokes a lambda function. Consists of the lambda
	// function name, target, and timeout (in seconds).
	CustomStepDetails *CustomStepDetails

	// Details for a step that deletes the file.
	DeleteStepDetails *DeleteStepDetails

	// Details for a step that creates one or more tags. You specify one or more tags:
	// each tag contains a key/value pair.
	TagStepDetails *TagStepDetails

	// Currently, the following step types are supported.
	//
	// * Copy: copy the file to
	// another location
	//
	// * Custom: custom step with a lambda target
	//
	// * Delete: delete
	// the file
	//
	// * Tag: add a tag to the file
	Type WorkflowStepType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
