// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// These are Amazon Web Services SSO identity store attributes that you can
// configure for use in attributes-based access control (ABAC). You can create
// permissions policies that determine who can access your Amazon Web Services
// resources based upon the configured attribute values. When you enable ABAC and
// specify AccessControlAttributes, Amazon Web Services SSO passes the attribute
// values of the authenticated user into IAM for use in policy evaluation.
type AccessControlAttribute struct {

	// The name of the attribute associated with your identities in your identity
	// source. This is used to map a specified attribute in your identity source with
	// an attribute in Amazon Web Services SSO.
	//
	// This member is required.
	Key *string

	// The value used for mapping a specified attribute to an identity source.
	//
	// This member is required.
	Value *AccessControlAttributeValue

	noSmithyDocumentSerde
}

// The value used for mapping a specified attribute to an identity source.
type AccessControlAttributeValue struct {

	// The identity source to use when mapping a specified attribute to Amazon Web
	// Services SSO.
	//
	// This member is required.
	Source []string

	noSmithyDocumentSerde
}

// The assignment that indicates a principal's limited access to a specified Amazon
// Web Services account with a specified permission set. The term principal here
// refers to a user or group that is defined in Amazon Web Services SSO.
type AccountAssignment struct {

	// The identifier of the Amazon Web Services account.
	AccountId *string

	// The ARN of the permission set. For more information about ARNs, see Amazon
	// Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon
	// Web Services General Reference.
	PermissionSetArn *string

	// An identifier for an object in Amazon Web Services SSO, such as a user or group.
	// PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For
	// more information about PrincipalIds in Amazon Web Services SSO, see the Amazon
	// Web Services SSO Identity Store API Reference.
	PrincipalId *string

	// The entity type for which the assignment will be created.
	PrincipalType PrincipalType

	noSmithyDocumentSerde
}

// The status of the creation or deletion operation of an assignment that a
// principal needs to access an account.
type AccountAssignmentOperationStatus struct {

	// The date that the permission set was created.
	CreatedDate *time.Time

	// The message that contains an error or exception in case of an operation failure.
	FailureReason *string

	// The ARN of the permission set. For more information about ARNs, see Amazon
	// Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon
	// Web Services General Reference.
	PermissionSetArn *string

	// An identifier for an object in Amazon Web Services SSO, such as a user or group.
	// PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For
	// more information about PrincipalIds in Amazon Web Services SSO, see the Amazon
	// Web Services SSO Identity Store API Reference.
	PrincipalId *string

	// The entity type for which the assignment will be created.
	PrincipalType PrincipalType

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string

	// The status of the permission set provisioning process.
	Status StatusValues

	// TargetID is an Amazon Web Services account identifier, typically a 10-12 digit
	// string (For example, 123456789012).
	TargetId *string

	// The entity type for which the assignment will be created.
	TargetType TargetType

	noSmithyDocumentSerde
}

// Provides information about the AccountAssignment creation request.
type AccountAssignmentOperationStatusMetadata struct {

	// The date that the permission set was created.
	CreatedDate *time.Time

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string

	// The status of the permission set provisioning process.
	Status StatusValues

	noSmithyDocumentSerde
}

// A structure that stores the details of the IAM managed policy.
type AttachedManagedPolicy struct {

	// The ARN of the IAM managed policy. For more information about ARNs, see Amazon
	// Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon
	// Web Services General Reference.
	Arn *string

	// The name of the IAM managed policy.
	Name *string

	noSmithyDocumentSerde
}

// Specifies the attributes to add to your attribute-based access control (ABAC)
// configuration.
type InstanceAccessControlAttributeConfiguration struct {

	// Lists the attributes that are configured for ABAC in the specified Amazon Web
	// Services SSO instance.
	//
	// This member is required.
	AccessControlAttributes []AccessControlAttribute

	noSmithyDocumentSerde
}

// Provides information about the SSO instance.
type InstanceMetadata struct {

	// The identifier of the identity store that is connected to the SSO instance.
	IdentityStoreId *string

	// The ARN of the SSO instance under which the operation will be executed. For more
	// information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces in the Amazon Web Services General Reference.
	InstanceArn *string

	noSmithyDocumentSerde
}

// Filters he operation status list based on the passed attribute value.
type OperationStatusFilter struct {

	// Filters the list operations result based on the status attribute.
	Status StatusValues

	noSmithyDocumentSerde
}

// An entity that contains IAM policies.
type PermissionSet struct {

	// The date that the permission set was created.
	CreatedDate *time.Time

	// The description of the PermissionSet.
	Description *string

	// The name of the permission set.
	Name *string

	// The ARN of the permission set. For more information about ARNs, see Amazon
	// Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon
	// Web Services General Reference.
	PermissionSetArn *string

	// Used to redirect users within the application during the federation
	// authentication process.
	RelayState *string

	// The length of time that the application user sessions are valid for in the
	// ISO-8601 standard.
	SessionDuration *string

	noSmithyDocumentSerde
}

// A structure that is used to provide the status of the provisioning operation for
// a specified permission set.
type PermissionSetProvisioningStatus struct {

	// The identifier of the Amazon Web Services account from which to list the
	// assignments.
	AccountId *string

	// The date that the permission set was created.
	CreatedDate *time.Time

	// The message that contains an error or exception in case of an operation failure.
	FailureReason *string

	// The ARN of the permission set that is being provisioned. For more information
	// about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service
	// Namespaces in the Amazon Web Services General Reference.
	PermissionSetArn *string

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string

	// The status of the permission set provisioning process.
	Status StatusValues

	noSmithyDocumentSerde
}

// Provides information about the permission set provisioning status.
type PermissionSetProvisioningStatusMetadata struct {

	// The date that the permission set was created.
	CreatedDate *time.Time

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string

	// The status of the permission set provisioning process.
	Status StatusValues

	noSmithyDocumentSerde
}

// A set of key-value pairs that are used to manage the resource. Tags can only be
// applied to permission sets and cannot be applied to corresponding roles that
// Amazon Web Services SSO creates in Amazon Web Services accounts.
type Tag struct {

	// The key for the tag.
	Key *string

	// The value of the tag.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
