// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// Exception that indicates the specified AttackId does not exist, or the requester
// does not have the appropriate permissions to access the AttackId.
type AccessDeniedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string             { return "AccessDeniedException" }
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// In order to grant the necessary access to the Shield Response Team (SRT) the
// user submitting the request must have the iam:PassRole permission. This error
// indicates the user did not have the appropriate permissions. For more
// information, see Granting a User Permissions to Pass a Role to an Amazon Web
// Services Service
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html).
type AccessDeniedForDependencyException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedForDependencyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedForDependencyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedForDependencyException) ErrorCode() string {
	return "AccessDeniedForDependencyException"
}
func (e *AccessDeniedForDependencyException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Exception that indicates that a problem occurred with the service
// infrastructure. You can retry the request.
type InternalErrorException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalErrorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalErrorException) ErrorCode() string             { return "InternalErrorException" }
func (e *InternalErrorException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Exception that indicates that the operation would not cause any change to occur.
type InvalidOperationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOperationException) ErrorCode() string             { return "InvalidOperationException" }
func (e *InvalidOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Exception that indicates that the NextToken specified in the request is invalid.
// Submit the request using the NextToken value that was returned in the response.
type InvalidPaginationTokenException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidPaginationTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPaginationTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPaginationTokenException) ErrorCode() string {
	return "InvalidPaginationTokenException"
}
func (e *InvalidPaginationTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Exception that indicates that the parameters passed to the API are invalid. If
// available, this exception includes details in additional properties.
type InvalidParameterException struct {
	Message *string

	Reason ValidationExceptionReason
	Fields []ValidationExceptionField

	noSmithyDocumentSerde
}

func (e *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterException) ErrorCode() string             { return "InvalidParameterException" }
func (e *InvalidParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Exception that indicates that the resource is invalid. You might not have access
// to the resource, or the resource might not exist.
type InvalidResourceException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidResourceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResourceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResourceException) ErrorCode() string             { return "InvalidResourceException" }
func (e *InvalidResourceException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Exception that indicates that the operation would exceed a limit.
type LimitsExceededException struct {
	Message *string

	Type  *string
	Limit int64

	noSmithyDocumentSerde
}

func (e *LimitsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitsExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitsExceededException) ErrorCode() string             { return "LimitsExceededException" }
func (e *LimitsExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You are trying to update a subscription that has not yet completed the 1-year
// commitment. You can change the AutoRenew parameter during the last 30 days of
// your subscription. This exception indicates that you are attempting to change
// AutoRenew prior to that period.
type LockedSubscriptionException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *LockedSubscriptionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LockedSubscriptionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LockedSubscriptionException) ErrorCode() string             { return "LockedSubscriptionException" }
func (e *LockedSubscriptionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The ARN of the role that you specifed does not exist.
type NoAssociatedRoleException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoAssociatedRoleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoAssociatedRoleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoAssociatedRoleException) ErrorCode() string             { return "NoAssociatedRoleException" }
func (e *NoAssociatedRoleException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Exception that indicates that the resource state has been modified by another
// client. Retrieve the resource and then retry your request.
type OptimisticLockException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *OptimisticLockException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OptimisticLockException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OptimisticLockException) ErrorCode() string             { return "OptimisticLockException" }
func (e *OptimisticLockException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Exception indicating the specified resource already exists. If available, this
// exception includes details in additional properties.
type ResourceAlreadyExistsException struct {
	Message *string

	ResourceType *string

	noSmithyDocumentSerde
}

func (e *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceAlreadyExistsException) ErrorCode() string             { return "ResourceAlreadyExistsException" }
func (e *ResourceAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Exception indicating the specified resource does not exist. If available, this
// exception includes details in additional properties.
type ResourceNotFoundException struct {
	Message *string

	ResourceType *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string             { return "ResourceNotFoundException" }
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
