// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists the model packages that have been created.
func (c *Client) ListModelPackages(ctx context.Context, params *ListModelPackagesInput, optFns ...func(*Options)) (*ListModelPackagesOutput, error) {
	if params == nil {
		params = &ListModelPackagesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListModelPackages", params, optFns, c.addOperationListModelPackagesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListModelPackagesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListModelPackagesInput struct {

	// A filter that returns only model packages created after the specified time
	// (timestamp).
	CreationTimeAfter *time.Time

	// A filter that returns only model packages created before the specified time
	// (timestamp).
	CreationTimeBefore *time.Time

	// The maximum number of model packages to return in the response.
	MaxResults *int32

	// A filter that returns only the model packages with the specified approval
	// status.
	ModelApprovalStatus types.ModelApprovalStatus

	// A filter that returns only model versions that belong to the specified model
	// group.
	ModelPackageGroupName *string

	// A filter that returns onlyl the model packages of the specified type. This can
	// be one of the following values.
	//
	// * VERSIONED - List only versioned models.
	//
	// *
	// UNVERSIONED - List only unversioined models.
	//
	// * BOTH - List both versioned and
	// unversioned models.
	ModelPackageType types.ModelPackageType

	// A string in the model package name. This filter returns only model packages
	// whose name contains the specified string.
	NameContains *string

	// If the response to a previous ListModelPackages request was truncated, the
	// response includes a NextToken. To retrieve the next set of model packages, use
	// the token in the next request.
	NextToken *string

	// The parameter by which to sort the results. The default is CreationTime.
	SortBy types.ModelPackageSortBy

	// The sort order for the results. The default is Ascending.
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListModelPackagesOutput struct {

	// An array of ModelPackageSummary objects, each of which lists a model package.
	//
	// This member is required.
	ModelPackageSummaryList []types.ModelPackageSummary

	// If the response is truncated, Amazon SageMaker returns this token. To retrieve
	// the next set of model packages, use it in the subsequent request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListModelPackagesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListModelPackages{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListModelPackages{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListModelPackages(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListModelPackagesAPIClient is a client that implements the ListModelPackages
// operation.
type ListModelPackagesAPIClient interface {
	ListModelPackages(context.Context, *ListModelPackagesInput, ...func(*Options)) (*ListModelPackagesOutput, error)
}

var _ ListModelPackagesAPIClient = (*Client)(nil)

// ListModelPackagesPaginatorOptions is the paginator options for ListModelPackages
type ListModelPackagesPaginatorOptions struct {
	// The maximum number of model packages to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListModelPackagesPaginator is a paginator for ListModelPackages
type ListModelPackagesPaginator struct {
	options   ListModelPackagesPaginatorOptions
	client    ListModelPackagesAPIClient
	params    *ListModelPackagesInput
	nextToken *string
	firstPage bool
}

// NewListModelPackagesPaginator returns a new ListModelPackagesPaginator
func NewListModelPackagesPaginator(client ListModelPackagesAPIClient, params *ListModelPackagesInput, optFns ...func(*ListModelPackagesPaginatorOptions)) *ListModelPackagesPaginator {
	if params == nil {
		params = &ListModelPackagesInput{}
	}

	options := ListModelPackagesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListModelPackagesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListModelPackagesPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListModelPackages page.
func (p *ListModelPackagesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListModelPackagesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListModelPackages(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListModelPackages(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sagemaker",
		OperationName: "ListModelPackages",
	}
}
