// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A Cell and its properties
type CellOutput struct {

	// The arn for the Cell
	//
	// This member is required.
	CellArn *string

	// The name of the Cell
	//
	// This member is required.
	CellName *string

	// A list of Cell arns
	//
	// This member is required.
	Cells []string

	// A list of Cell ARNs and/or RecoveryGroup ARNs
	//
	// This member is required.
	ParentReadinessScopes []string

	// A collection of tags associated with a resource
	Tags map[string]string

	noSmithyDocumentSerde
}

// A component for DNS/Routing Control Readiness Checks
type DNSTargetResource struct {

	// The DNS Name that acts as ingress point to a portion of application
	DomainName *string

	// The Hosted Zone ARN that contains the DNS record with the provided name of
	// target resource.
	HostedZoneArn *string

	// The R53 Set Id to uniquely identify a record given a Name and a Type
	RecordSetId *string

	// The Type of DNS Record of target resource
	RecordType *string

	// The target resource the R53 record points to
	TargetResource *TargetResource

	noSmithyDocumentSerde
}

// A collection of rules used in a readiness check
type ListRulesOutput struct {

	// The resource type the rule applies to.
	//
	// This member is required.
	ResourceType *string

	// A description of the rule
	//
	// This member is required.
	RuleDescription *string

	// The Rule's ID.
	//
	// This member is required.
	RuleId *string

	noSmithyDocumentSerde
}

// Information relating to readiness check status
type Message struct {

	// The text of a readiness check message
	MessageText *string

	noSmithyDocumentSerde
}

// The NLB resource a DNS Target Resource points to
type NLBResource struct {

	// An NLB resource arn
	Arn *string

	noSmithyDocumentSerde
}

// The Route 53 resource a DNS Target Resource record points to
type R53ResourceRecord struct {

	// The DNS target name
	DomainName *string

	// The Resource Record set id
	RecordSetId *string

	noSmithyDocumentSerde
}

// A resource used for checking the readiness of a Resource Set
type ReadinessCheckOutput struct {

	// Arn associated with ReadinessCheck
	//
	// This member is required.
	ReadinessCheckArn *string

	// Name of the ResourceSet to be checked
	//
	// This member is required.
	ResourceSet *string

	// Name for a ReadinessCheck
	ReadinessCheckName *string

	// A collection of tags associated with a resource
	Tags map[string]string

	noSmithyDocumentSerde
}

// Summary of ReadinessCheck status, paginated in GetRecoveryGroupReadinessSummary
// and GetCellReadinessSummary
type ReadinessCheckSummary struct {

	// The readiness of this ReadinessCheck
	Readiness Readiness

	// The name of a ReadinessCheck which is part of the given RecoveryGroup or Cell
	ReadinessCheckName *string

	noSmithyDocumentSerde
}

// Guidance for improving Recovery Group resilliancy
type Recommendation struct {

	// Guidance text for recommendation
	//
	// This member is required.
	RecommendationText *string

	noSmithyDocumentSerde
}

// A Recovery Group generally containing multiple Cells
type RecoveryGroupOutput struct {

	// A list of Cell arns
	//
	// This member is required.
	Cells []string

	// The arn for the RecoveryGroup
	//
	// This member is required.
	RecoveryGroupArn *string

	// The name of the RecoveryGroup
	//
	// This member is required.
	RecoveryGroupName *string

	// A collection of tags associated with a resource
	Tags map[string]string

	noSmithyDocumentSerde
}

// The resource element of a ResourceSet
type Resource struct {

	// The component id of the resource, generated by the service when
	// dnsTargetResource is used
	ComponentId *string

	// A component for DNS/Routing Control Readiness Checks
	DnsTargetResource *DNSTargetResource

	// A list of RecoveryGroup ARNs and/or Cell ARNs that this resource is contained
	// within.
	ReadinessScopes []string

	// The ARN of the AWS resource, can be skipped if dnsTargetResource is used
	ResourceArn *string

	noSmithyDocumentSerde
}

// Result with status for an individual resource.
type ResourceResult struct {

	// The time the resource was last checked for readiness, in ISO-8601 format, UTC.
	//
	// This member is required.
	LastCheckedTimestamp *time.Time

	// The readiness of the resource.
	//
	// This member is required.
	Readiness Readiness

	// The component id of the resource
	ComponentId *string

	// The ARN of the resource
	ResourceArn *string

	noSmithyDocumentSerde
}

// A collection of resources of the same type
type ResourceSetOutput struct {

	// The arn for the ResourceSet
	//
	// This member is required.
	ResourceSetArn *string

	// The name of the ResourceSet
	//
	// This member is required.
	ResourceSetName *string

	// AWS Resource Type of the resources in the ResourceSet
	//
	// This member is required.
	ResourceSetType *string

	// A list of Resource objects
	//
	// This member is required.
	Resources []Resource

	// A collection of tags associated with a resource
	Tags map[string]string

	noSmithyDocumentSerde
}

// Result with status for an individual rule..
type RuleResult struct {

	// The time the resource was last checked for readiness, in ISO-8601 format, UTC.
	//
	// This member is required.
	LastCheckedTimestamp *time.Time

	// Details about the resource's readiness
	//
	// This member is required.
	Messages []Message

	// The readiness at rule level.
	//
	// This member is required.
	Readiness Readiness

	// The identifier of the rule.
	//
	// This member is required.
	RuleId *string

	noSmithyDocumentSerde
}

// The target resource the R53 record points to
type TargetResource struct {

	// The NLB resource a DNS Target Resource points to
	NLBResource *NLBResource

	// The Route 53 resource a DNS Target Resource record points to
	R53Resource *R53ResourceRecord

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
