// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpoint

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/pinpoint/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpCreateApp struct {
}

func (*awsRestjson1_serializeOpCreateApp) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateApp) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAppInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.CreateApplicationRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentCreateApplicationRequest(input.CreateApplicationRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAppInput(v *CreateAppInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpCreateCampaign struct {
}

func (*awsRestjson1_serializeOpCreateCampaign) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateCampaign) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCampaignInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/campaigns")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateCampaignInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.WriteCampaignRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentWriteCampaignRequest(input.WriteCampaignRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateCampaignInput(v *CreateCampaignInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateEmailTemplate struct {
}

func (*awsRestjson1_serializeOpCreateEmailTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateEmailTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEmailTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/email")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateEmailTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.EmailTemplateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentEmailTemplateRequest(input.EmailTemplateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateEmailTemplateInput(v *CreateEmailTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateExportJob struct {
}

func (*awsRestjson1_serializeOpCreateExportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateExportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateExportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/jobs/export")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateExportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.ExportJobRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentExportJobRequest(input.ExportJobRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateExportJobInput(v *CreateExportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateImportJob struct {
}

func (*awsRestjson1_serializeOpCreateImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/jobs/import")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateImportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.ImportJobRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentImportJobRequest(input.ImportJobRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateImportJobInput(v *CreateImportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateInAppTemplate struct {
}

func (*awsRestjson1_serializeOpCreateInAppTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateInAppTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInAppTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/inapp")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateInAppTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.InAppTemplateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentInAppTemplateRequest(input.InAppTemplateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateInAppTemplateInput(v *CreateInAppTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateJourney struct {
}

func (*awsRestjson1_serializeOpCreateJourney) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateJourney) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateJourneyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/journeys")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateJourneyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.WriteJourneyRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentWriteJourneyRequest(input.WriteJourneyRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateJourneyInput(v *CreateJourneyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePushTemplate struct {
}

func (*awsRestjson1_serializeOpCreatePushTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePushTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePushTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/push")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreatePushTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.PushNotificationTemplateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentPushNotificationTemplateRequest(input.PushNotificationTemplateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePushTemplateInput(v *CreatePushTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateRecommenderConfiguration struct {
}

func (*awsRestjson1_serializeOpCreateRecommenderConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRecommenderConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRecommenderConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/recommenders")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.CreateRecommenderConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentCreateRecommenderConfigurationShape(input.CreateRecommenderConfiguration, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRecommenderConfigurationInput(v *CreateRecommenderConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpCreateSegment struct {
}

func (*awsRestjson1_serializeOpCreateSegment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateSegment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSegmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/segments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateSegmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.WriteSegmentRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentWriteSegmentRequest(input.WriteSegmentRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSegmentInput(v *CreateSegmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateSmsTemplate struct {
}

func (*awsRestjson1_serializeOpCreateSmsTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateSmsTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSmsTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/sms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateSmsTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.SMSTemplateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentSMSTemplateRequest(input.SMSTemplateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSmsTemplateInput(v *CreateSmsTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateVoiceTemplate struct {
}

func (*awsRestjson1_serializeOpCreateVoiceTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateVoiceTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVoiceTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/voice")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateVoiceTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.VoiceTemplateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentVoiceTemplateRequest(input.VoiceTemplateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateVoiceTemplateInput(v *CreateVoiceTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAdmChannel struct {
}

func (*awsRestjson1_serializeOpDeleteAdmChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAdmChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAdmChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/adm")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAdmChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAdmChannelInput(v *DeleteAdmChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApnsChannel struct {
}

func (*awsRestjson1_serializeOpDeleteApnsChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApnsChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApnsChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteApnsChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteApnsChannelInput(v *DeleteApnsChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApnsSandboxChannel struct {
}

func (*awsRestjson1_serializeOpDeleteApnsSandboxChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApnsSandboxChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApnsSandboxChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns_sandbox")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteApnsSandboxChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteApnsSandboxChannelInput(v *DeleteApnsSandboxChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApnsVoipChannel struct {
}

func (*awsRestjson1_serializeOpDeleteApnsVoipChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApnsVoipChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApnsVoipChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns_voip")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteApnsVoipChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteApnsVoipChannelInput(v *DeleteApnsVoipChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApnsVoipSandboxChannel struct {
}

func (*awsRestjson1_serializeOpDeleteApnsVoipSandboxChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApnsVoipSandboxChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApnsVoipSandboxChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns_voip_sandbox")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteApnsVoipSandboxChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteApnsVoipSandboxChannelInput(v *DeleteApnsVoipSandboxChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApp struct {
}

func (*awsRestjson1_serializeOpDeleteApp) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApp) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAppInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAppInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAppInput(v *DeleteAppInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBaiduChannel struct {
}

func (*awsRestjson1_serializeOpDeleteBaiduChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBaiduChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBaiduChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/baidu")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBaiduChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBaiduChannelInput(v *DeleteBaiduChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCampaign struct {
}

func (*awsRestjson1_serializeOpDeleteCampaign) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCampaign) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCampaignInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/campaigns/{CampaignId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteCampaignInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCampaignInput(v *DeleteCampaignInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.CampaignId == nil || len(*v.CampaignId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CampaignId must not be empty")}
	}
	if v.CampaignId != nil {
		if err := encoder.SetURI("CampaignId").String(*v.CampaignId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteEmailChannel struct {
}

func (*awsRestjson1_serializeOpDeleteEmailChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteEmailChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEmailChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/email")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteEmailChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteEmailChannelInput(v *DeleteEmailChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteEmailTemplate struct {
}

func (*awsRestjson1_serializeOpDeleteEmailTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteEmailTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEmailTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/email")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteEmailTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteEmailTemplateInput(v *DeleteEmailTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteEndpoint struct {
}

func (*awsRestjson1_serializeOpDeleteEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/endpoints/{EndpointId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteEndpointInput(v *DeleteEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.EndpointId == nil || len(*v.EndpointId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EndpointId must not be empty")}
	}
	if v.EndpointId != nil {
		if err := encoder.SetURI("EndpointId").String(*v.EndpointId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteEventStream struct {
}

func (*awsRestjson1_serializeOpDeleteEventStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteEventStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEventStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/eventstream")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteEventStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteEventStreamInput(v *DeleteEventStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGcmChannel struct {
}

func (*awsRestjson1_serializeOpDeleteGcmChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGcmChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGcmChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/gcm")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGcmChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGcmChannelInput(v *DeleteGcmChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteInAppTemplate struct {
}

func (*awsRestjson1_serializeOpDeleteInAppTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteInAppTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInAppTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/inapp")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteInAppTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteInAppTemplateInput(v *DeleteInAppTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteJourney struct {
}

func (*awsRestjson1_serializeOpDeleteJourney) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteJourney) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteJourneyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/journeys/{JourneyId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteJourneyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteJourneyInput(v *DeleteJourneyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.JourneyId == nil || len(*v.JourneyId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JourneyId must not be empty")}
	}
	if v.JourneyId != nil {
		if err := encoder.SetURI("JourneyId").String(*v.JourneyId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePushTemplate struct {
}

func (*awsRestjson1_serializeOpDeletePushTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePushTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePushTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/push")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePushTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePushTemplateInput(v *DeletePushTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRecommenderConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteRecommenderConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRecommenderConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRecommenderConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/recommenders/{RecommenderId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRecommenderConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRecommenderConfigurationInput(v *DeleteRecommenderConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RecommenderId == nil || len(*v.RecommenderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RecommenderId must not be empty")}
	}
	if v.RecommenderId != nil {
		if err := encoder.SetURI("RecommenderId").String(*v.RecommenderId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteSegment struct {
}

func (*awsRestjson1_serializeOpDeleteSegment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSegment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSegmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/segments/{SegmentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSegmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSegmentInput(v *DeleteSegmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.SegmentId == nil || len(*v.SegmentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SegmentId must not be empty")}
	}
	if v.SegmentId != nil {
		if err := encoder.SetURI("SegmentId").String(*v.SegmentId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteSmsChannel struct {
}

func (*awsRestjson1_serializeOpDeleteSmsChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSmsChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSmsChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/sms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSmsChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSmsChannelInput(v *DeleteSmsChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteSmsTemplate struct {
}

func (*awsRestjson1_serializeOpDeleteSmsTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSmsTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSmsTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/sms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSmsTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSmsTemplateInput(v *DeleteSmsTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteUserEndpoints struct {
}

func (*awsRestjson1_serializeOpDeleteUserEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteUserEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/users/{UserId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteUserEndpointsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteUserEndpointsInput(v *DeleteUserEndpointsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("UserId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVoiceChannel struct {
}

func (*awsRestjson1_serializeOpDeleteVoiceChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVoiceChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVoiceChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/voice")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVoiceChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVoiceChannelInput(v *DeleteVoiceChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVoiceTemplate struct {
}

func (*awsRestjson1_serializeOpDeleteVoiceTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVoiceTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVoiceTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/voice")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVoiceTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVoiceTemplateInput(v *DeleteVoiceTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpGetAdmChannel struct {
}

func (*awsRestjson1_serializeOpGetAdmChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAdmChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAdmChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/adm")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAdmChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAdmChannelInput(v *GetAdmChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApnsChannel struct {
}

func (*awsRestjson1_serializeOpGetApnsChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApnsChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApnsChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApnsChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApnsChannelInput(v *GetApnsChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApnsSandboxChannel struct {
}

func (*awsRestjson1_serializeOpGetApnsSandboxChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApnsSandboxChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApnsSandboxChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns_sandbox")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApnsSandboxChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApnsSandboxChannelInput(v *GetApnsSandboxChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApnsVoipChannel struct {
}

func (*awsRestjson1_serializeOpGetApnsVoipChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApnsVoipChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApnsVoipChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns_voip")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApnsVoipChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApnsVoipChannelInput(v *GetApnsVoipChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApnsVoipSandboxChannel struct {
}

func (*awsRestjson1_serializeOpGetApnsVoipSandboxChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApnsVoipSandboxChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApnsVoipSandboxChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns_voip_sandbox")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApnsVoipSandboxChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApnsVoipSandboxChannelInput(v *GetApnsVoipSandboxChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApp struct {
}

func (*awsRestjson1_serializeOpGetApp) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApp) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAppInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAppInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAppInput(v *GetAppInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApplicationDateRangeKpi struct {
}

func (*awsRestjson1_serializeOpGetApplicationDateRangeKpi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApplicationDateRangeKpi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApplicationDateRangeKpiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/kpis/daterange/{KpiName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApplicationDateRangeKpiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApplicationDateRangeKpiInput(v *GetApplicationDateRangeKpiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.EndTime != nil {
		encoder.SetQuery("end-time").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.KpiName == nil || len(*v.KpiName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member KpiName must not be empty")}
	}
	if v.KpiName != nil {
		if err := encoder.SetURI("KpiName").String(*v.KpiName); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.StartTime != nil {
		encoder.SetQuery("start-time").String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

type awsRestjson1_serializeOpGetApplicationSettings struct {
}

func (*awsRestjson1_serializeOpGetApplicationSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApplicationSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApplicationSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApplicationSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApplicationSettingsInput(v *GetApplicationSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApps struct {
}

func (*awsRestjson1_serializeOpGetApps) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAppsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAppsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAppsInput(v *GetAppsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpGetBaiduChannel struct {
}

func (*awsRestjson1_serializeOpGetBaiduChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBaiduChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBaiduChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/baidu")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBaiduChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBaiduChannelInput(v *GetBaiduChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCampaign struct {
}

func (*awsRestjson1_serializeOpGetCampaign) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCampaign) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCampaignInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/campaigns/{CampaignId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCampaignInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCampaignInput(v *GetCampaignInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.CampaignId == nil || len(*v.CampaignId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CampaignId must not be empty")}
	}
	if v.CampaignId != nil {
		if err := encoder.SetURI("CampaignId").String(*v.CampaignId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCampaignActivities struct {
}

func (*awsRestjson1_serializeOpGetCampaignActivities) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCampaignActivities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCampaignActivitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/campaigns/{CampaignId}/activities")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCampaignActivitiesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCampaignActivitiesInput(v *GetCampaignActivitiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.CampaignId == nil || len(*v.CampaignId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CampaignId must not be empty")}
	}
	if v.CampaignId != nil {
		if err := encoder.SetURI("CampaignId").String(*v.CampaignId); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpGetCampaignDateRangeKpi struct {
}

func (*awsRestjson1_serializeOpGetCampaignDateRangeKpi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCampaignDateRangeKpi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCampaignDateRangeKpiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/campaigns/{CampaignId}/kpis/daterange/{KpiName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCampaignDateRangeKpiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCampaignDateRangeKpiInput(v *GetCampaignDateRangeKpiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.CampaignId == nil || len(*v.CampaignId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CampaignId must not be empty")}
	}
	if v.CampaignId != nil {
		if err := encoder.SetURI("CampaignId").String(*v.CampaignId); err != nil {
			return err
		}
	}

	if v.EndTime != nil {
		encoder.SetQuery("end-time").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.KpiName == nil || len(*v.KpiName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member KpiName must not be empty")}
	}
	if v.KpiName != nil {
		if err := encoder.SetURI("KpiName").String(*v.KpiName); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.StartTime != nil {
		encoder.SetQuery("start-time").String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

type awsRestjson1_serializeOpGetCampaigns struct {
}

func (*awsRestjson1_serializeOpGetCampaigns) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCampaigns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCampaignsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/campaigns")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCampaignsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCampaignsInput(v *GetCampaignsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpGetCampaignVersion struct {
}

func (*awsRestjson1_serializeOpGetCampaignVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCampaignVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCampaignVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/campaigns/{CampaignId}/versions/{Version}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCampaignVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCampaignVersionInput(v *GetCampaignVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.CampaignId == nil || len(*v.CampaignId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CampaignId must not be empty")}
	}
	if v.CampaignId != nil {
		if err := encoder.SetURI("CampaignId").String(*v.CampaignId); err != nil {
			return err
		}
	}

	if v.Version == nil || len(*v.Version) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Version must not be empty")}
	}
	if v.Version != nil {
		if err := encoder.SetURI("Version").String(*v.Version); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCampaignVersions struct {
}

func (*awsRestjson1_serializeOpGetCampaignVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCampaignVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCampaignVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/campaigns/{CampaignId}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCampaignVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCampaignVersionsInput(v *GetCampaignVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.CampaignId == nil || len(*v.CampaignId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CampaignId must not be empty")}
	}
	if v.CampaignId != nil {
		if err := encoder.SetURI("CampaignId").String(*v.CampaignId); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpGetChannels struct {
}

func (*awsRestjson1_serializeOpGetChannels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetChannels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetChannelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetChannelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetChannelsInput(v *GetChannelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetEmailChannel struct {
}

func (*awsRestjson1_serializeOpGetEmailChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEmailChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEmailChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/email")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEmailChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEmailChannelInput(v *GetEmailChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetEmailTemplate struct {
}

func (*awsRestjson1_serializeOpGetEmailTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEmailTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEmailTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/email")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEmailTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEmailTemplateInput(v *GetEmailTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpGetEndpoint struct {
}

func (*awsRestjson1_serializeOpGetEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/endpoints/{EndpointId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEndpointInput(v *GetEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.EndpointId == nil || len(*v.EndpointId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EndpointId must not be empty")}
	}
	if v.EndpointId != nil {
		if err := encoder.SetURI("EndpointId").String(*v.EndpointId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetEventStream struct {
}

func (*awsRestjson1_serializeOpGetEventStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEventStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEventStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/eventstream")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEventStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEventStreamInput(v *GetEventStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetExportJob struct {
}

func (*awsRestjson1_serializeOpGetExportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetExportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetExportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/jobs/export/{JobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetExportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetExportJobInput(v *GetExportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("JobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetExportJobs struct {
}

func (*awsRestjson1_serializeOpGetExportJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetExportJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetExportJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/jobs/export")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetExportJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetExportJobsInput(v *GetExportJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpGetGcmChannel struct {
}

func (*awsRestjson1_serializeOpGetGcmChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetGcmChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGcmChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/gcm")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetGcmChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetGcmChannelInput(v *GetGcmChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetImportJob struct {
}

func (*awsRestjson1_serializeOpGetImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/jobs/import/{JobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetImportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetImportJobInput(v *GetImportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("JobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetImportJobs struct {
}

func (*awsRestjson1_serializeOpGetImportJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetImportJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetImportJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/jobs/import")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetImportJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetImportJobsInput(v *GetImportJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpGetInAppMessages struct {
}

func (*awsRestjson1_serializeOpGetInAppMessages) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetInAppMessages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetInAppMessagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/endpoints/{EndpointId}/inappmessages")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetInAppMessagesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetInAppMessagesInput(v *GetInAppMessagesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.EndpointId == nil || len(*v.EndpointId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EndpointId must not be empty")}
	}
	if v.EndpointId != nil {
		if err := encoder.SetURI("EndpointId").String(*v.EndpointId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetInAppTemplate struct {
}

func (*awsRestjson1_serializeOpGetInAppTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetInAppTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetInAppTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/inapp")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetInAppTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetInAppTemplateInput(v *GetInAppTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpGetJourney struct {
}

func (*awsRestjson1_serializeOpGetJourney) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetJourney) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJourneyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/journeys/{JourneyId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetJourneyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetJourneyInput(v *GetJourneyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.JourneyId == nil || len(*v.JourneyId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JourneyId must not be empty")}
	}
	if v.JourneyId != nil {
		if err := encoder.SetURI("JourneyId").String(*v.JourneyId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetJourneyDateRangeKpi struct {
}

func (*awsRestjson1_serializeOpGetJourneyDateRangeKpi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetJourneyDateRangeKpi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJourneyDateRangeKpiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/journeys/{JourneyId}/kpis/daterange/{KpiName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetJourneyDateRangeKpiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetJourneyDateRangeKpiInput(v *GetJourneyDateRangeKpiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.EndTime != nil {
		encoder.SetQuery("end-time").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.JourneyId == nil || len(*v.JourneyId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JourneyId must not be empty")}
	}
	if v.JourneyId != nil {
		if err := encoder.SetURI("JourneyId").String(*v.JourneyId); err != nil {
			return err
		}
	}

	if v.KpiName == nil || len(*v.KpiName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member KpiName must not be empty")}
	}
	if v.KpiName != nil {
		if err := encoder.SetURI("KpiName").String(*v.KpiName); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.StartTime != nil {
		encoder.SetQuery("start-time").String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

type awsRestjson1_serializeOpGetJourneyExecutionActivityMetrics struct {
}

func (*awsRestjson1_serializeOpGetJourneyExecutionActivityMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetJourneyExecutionActivityMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJourneyExecutionActivityMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/journeys/{JourneyId}/activities/{JourneyActivityId}/execution-metrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetJourneyExecutionActivityMetricsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetJourneyExecutionActivityMetricsInput(v *GetJourneyExecutionActivityMetricsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.JourneyActivityId == nil || len(*v.JourneyActivityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JourneyActivityId must not be empty")}
	}
	if v.JourneyActivityId != nil {
		if err := encoder.SetURI("JourneyActivityId").String(*v.JourneyActivityId); err != nil {
			return err
		}
	}

	if v.JourneyId == nil || len(*v.JourneyId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JourneyId must not be empty")}
	}
	if v.JourneyId != nil {
		if err := encoder.SetURI("JourneyId").String(*v.JourneyId); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpGetJourneyExecutionMetrics struct {
}

func (*awsRestjson1_serializeOpGetJourneyExecutionMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetJourneyExecutionMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJourneyExecutionMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/journeys/{JourneyId}/execution-metrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetJourneyExecutionMetricsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetJourneyExecutionMetricsInput(v *GetJourneyExecutionMetricsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.JourneyId == nil || len(*v.JourneyId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JourneyId must not be empty")}
	}
	if v.JourneyId != nil {
		if err := encoder.SetURI("JourneyId").String(*v.JourneyId); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpGetPushTemplate struct {
}

func (*awsRestjson1_serializeOpGetPushTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPushTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPushTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/push")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPushTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPushTemplateInput(v *GetPushTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpGetRecommenderConfiguration struct {
}

func (*awsRestjson1_serializeOpGetRecommenderConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRecommenderConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRecommenderConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/recommenders/{RecommenderId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRecommenderConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRecommenderConfigurationInput(v *GetRecommenderConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RecommenderId == nil || len(*v.RecommenderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RecommenderId must not be empty")}
	}
	if v.RecommenderId != nil {
		if err := encoder.SetURI("RecommenderId").String(*v.RecommenderId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRecommenderConfigurations struct {
}

func (*awsRestjson1_serializeOpGetRecommenderConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRecommenderConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRecommenderConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/recommenders")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRecommenderConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRecommenderConfigurationsInput(v *GetRecommenderConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpGetSegment struct {
}

func (*awsRestjson1_serializeOpGetSegment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSegment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSegmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/segments/{SegmentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSegmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSegmentInput(v *GetSegmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.SegmentId == nil || len(*v.SegmentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SegmentId must not be empty")}
	}
	if v.SegmentId != nil {
		if err := encoder.SetURI("SegmentId").String(*v.SegmentId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSegmentExportJobs struct {
}

func (*awsRestjson1_serializeOpGetSegmentExportJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSegmentExportJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSegmentExportJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/segments/{SegmentId}/jobs/export")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSegmentExportJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSegmentExportJobsInput(v *GetSegmentExportJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.SegmentId == nil || len(*v.SegmentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SegmentId must not be empty")}
	}
	if v.SegmentId != nil {
		if err := encoder.SetURI("SegmentId").String(*v.SegmentId); err != nil {
			return err
		}
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpGetSegmentImportJobs struct {
}

func (*awsRestjson1_serializeOpGetSegmentImportJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSegmentImportJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSegmentImportJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/segments/{SegmentId}/jobs/import")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSegmentImportJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSegmentImportJobsInput(v *GetSegmentImportJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.SegmentId == nil || len(*v.SegmentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SegmentId must not be empty")}
	}
	if v.SegmentId != nil {
		if err := encoder.SetURI("SegmentId").String(*v.SegmentId); err != nil {
			return err
		}
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpGetSegments struct {
}

func (*awsRestjson1_serializeOpGetSegments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSegments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSegmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/segments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSegmentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSegmentsInput(v *GetSegmentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpGetSegmentVersion struct {
}

func (*awsRestjson1_serializeOpGetSegmentVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSegmentVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSegmentVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/segments/{SegmentId}/versions/{Version}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSegmentVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSegmentVersionInput(v *GetSegmentVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.SegmentId == nil || len(*v.SegmentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SegmentId must not be empty")}
	}
	if v.SegmentId != nil {
		if err := encoder.SetURI("SegmentId").String(*v.SegmentId); err != nil {
			return err
		}
	}

	if v.Version == nil || len(*v.Version) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Version must not be empty")}
	}
	if v.Version != nil {
		if err := encoder.SetURI("Version").String(*v.Version); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSegmentVersions struct {
}

func (*awsRestjson1_serializeOpGetSegmentVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSegmentVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSegmentVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/segments/{SegmentId}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSegmentVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSegmentVersionsInput(v *GetSegmentVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.SegmentId == nil || len(*v.SegmentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SegmentId must not be empty")}
	}
	if v.SegmentId != nil {
		if err := encoder.SetURI("SegmentId").String(*v.SegmentId); err != nil {
			return err
		}
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpGetSmsChannel struct {
}

func (*awsRestjson1_serializeOpGetSmsChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSmsChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSmsChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/sms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSmsChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSmsChannelInput(v *GetSmsChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSmsTemplate struct {
}

func (*awsRestjson1_serializeOpGetSmsTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSmsTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSmsTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/sms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSmsTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSmsTemplateInput(v *GetSmsTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpGetUserEndpoints struct {
}

func (*awsRestjson1_serializeOpGetUserEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetUserEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUserEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/users/{UserId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetUserEndpointsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetUserEndpointsInput(v *GetUserEndpointsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("UserId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetVoiceChannel struct {
}

func (*awsRestjson1_serializeOpGetVoiceChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetVoiceChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVoiceChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/voice")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetVoiceChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetVoiceChannelInput(v *GetVoiceChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetVoiceTemplate struct {
}

func (*awsRestjson1_serializeOpGetVoiceTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetVoiceTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVoiceTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/voice")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetVoiceTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetVoiceTemplateInput(v *GetVoiceTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpListJourneys struct {
}

func (*awsRestjson1_serializeOpListJourneys) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJourneys) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJourneysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/journeys")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJourneysInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJourneysInput(v *ListJourneysInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTemplates struct {
}

func (*awsRestjson1_serializeOpListTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTemplatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTemplatesInput(v *ListTemplatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.Prefix != nil {
		encoder.SetQuery("prefix").String(*v.Prefix)
	}

	if v.TemplateType != nil {
		encoder.SetQuery("template-type").String(*v.TemplateType)
	}

	return nil
}

type awsRestjson1_serializeOpListTemplateVersions struct {
}

func (*awsRestjson1_serializeOpListTemplateVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTemplateVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTemplateVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/{TemplateType}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTemplateVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTemplateVersionsInput(v *ListTemplateVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("page-size").String(*v.PageSize)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.TemplateType == nil || len(*v.TemplateType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateType must not be empty")}
	}
	if v.TemplateType != nil {
		if err := encoder.SetURI("TemplateType").String(*v.TemplateType); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPhoneNumberValidate struct {
}

func (*awsRestjson1_serializeOpPhoneNumberValidate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPhoneNumberValidate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PhoneNumberValidateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/phone/number/validate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.NumberValidateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentNumberValidateRequest(input.NumberValidateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPhoneNumberValidateInput(v *PhoneNumberValidateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpPutEvents struct {
}

func (*awsRestjson1_serializeOpPutEvents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutEvents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutEventsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/events")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutEventsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.EventsRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentEventsRequest(input.EventsRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutEventsInput(v *PutEventsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutEventStream struct {
}

func (*awsRestjson1_serializeOpPutEventStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutEventStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutEventStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/eventstream")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutEventStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.WriteEventStream != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentWriteEventStream(input.WriteEventStream, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutEventStreamInput(v *PutEventStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveAttributes struct {
}

func (*awsRestjson1_serializeOpRemoveAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/attributes/{AttributeType}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.UpdateAttributesRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentUpdateAttributesRequest(input.UpdateAttributesRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveAttributesInput(v *RemoveAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.AttributeType == nil || len(*v.AttributeType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AttributeType must not be empty")}
	}
	if v.AttributeType != nil {
		if err := encoder.SetURI("AttributeType").String(*v.AttributeType); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSendMessages struct {
}

func (*awsRestjson1_serializeOpSendMessages) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSendMessages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendMessagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/messages")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSendMessagesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.MessageRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentMessageRequest(input.MessageRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSendMessagesInput(v *SendMessagesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSendUsersMessages struct {
}

func (*awsRestjson1_serializeOpSendUsersMessages) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSendUsersMessages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendUsersMessagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/users-messages")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSendUsersMessagesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.SendUsersMessageRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentSendUsersMessageRequest(input.SendUsersMessageRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSendUsersMessagesInput(v *SendUsersMessagesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.TagsModel != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentTagsModel(input.TagsModel, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAdmChannel struct {
}

func (*awsRestjson1_serializeOpUpdateAdmChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAdmChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAdmChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/adm")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAdmChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.ADMChannelRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentADMChannelRequest(input.ADMChannelRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAdmChannelInput(v *UpdateAdmChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApnsChannel struct {
}

func (*awsRestjson1_serializeOpUpdateApnsChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApnsChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApnsChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApnsChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.APNSChannelRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentAPNSChannelRequest(input.APNSChannelRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApnsChannelInput(v *UpdateApnsChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApnsSandboxChannel struct {
}

func (*awsRestjson1_serializeOpUpdateApnsSandboxChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApnsSandboxChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApnsSandboxChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns_sandbox")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApnsSandboxChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.APNSSandboxChannelRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentAPNSSandboxChannelRequest(input.APNSSandboxChannelRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApnsSandboxChannelInput(v *UpdateApnsSandboxChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApnsVoipChannel struct {
}

func (*awsRestjson1_serializeOpUpdateApnsVoipChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApnsVoipChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApnsVoipChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns_voip")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApnsVoipChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.APNSVoipChannelRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentAPNSVoipChannelRequest(input.APNSVoipChannelRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApnsVoipChannelInput(v *UpdateApnsVoipChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApnsVoipSandboxChannel struct {
}

func (*awsRestjson1_serializeOpUpdateApnsVoipSandboxChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApnsVoipSandboxChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApnsVoipSandboxChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/apns_voip_sandbox")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApnsVoipSandboxChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.APNSVoipSandboxChannelRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentAPNSVoipSandboxChannelRequest(input.APNSVoipSandboxChannelRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApnsVoipSandboxChannelInput(v *UpdateApnsVoipSandboxChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApplicationSettings struct {
}

func (*awsRestjson1_serializeOpUpdateApplicationSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApplicationSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApplicationSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApplicationSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.WriteApplicationSettingsRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentWriteApplicationSettingsRequest(input.WriteApplicationSettingsRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApplicationSettingsInput(v *UpdateApplicationSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBaiduChannel struct {
}

func (*awsRestjson1_serializeOpUpdateBaiduChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBaiduChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBaiduChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/baidu")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBaiduChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.BaiduChannelRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentBaiduChannelRequest(input.BaiduChannelRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBaiduChannelInput(v *UpdateBaiduChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateCampaign struct {
}

func (*awsRestjson1_serializeOpUpdateCampaign) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateCampaign) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCampaignInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/campaigns/{CampaignId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateCampaignInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.WriteCampaignRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentWriteCampaignRequest(input.WriteCampaignRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateCampaignInput(v *UpdateCampaignInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.CampaignId == nil || len(*v.CampaignId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CampaignId must not be empty")}
	}
	if v.CampaignId != nil {
		if err := encoder.SetURI("CampaignId").String(*v.CampaignId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateEmailChannel struct {
}

func (*awsRestjson1_serializeOpUpdateEmailChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateEmailChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEmailChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/email")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateEmailChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.EmailChannelRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentEmailChannelRequest(input.EmailChannelRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateEmailChannelInput(v *UpdateEmailChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateEmailTemplate struct {
}

func (*awsRestjson1_serializeOpUpdateEmailTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateEmailTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEmailTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/email")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateEmailTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.EmailTemplateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentEmailTemplateRequest(input.EmailTemplateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateEmailTemplateInput(v *UpdateEmailTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreateNewVersion {
		encoder.SetQuery("create-new-version").Boolean(v.CreateNewVersion)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateEndpoint struct {
}

func (*awsRestjson1_serializeOpUpdateEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/endpoints/{EndpointId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.EndpointRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentEndpointRequest(input.EndpointRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateEndpointInput(v *UpdateEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.EndpointId == nil || len(*v.EndpointId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EndpointId must not be empty")}
	}
	if v.EndpointId != nil {
		if err := encoder.SetURI("EndpointId").String(*v.EndpointId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateEndpointsBatch struct {
}

func (*awsRestjson1_serializeOpUpdateEndpointsBatch) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateEndpointsBatch) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEndpointsBatchInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/endpoints")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateEndpointsBatchInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.EndpointBatchRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentEndpointBatchRequest(input.EndpointBatchRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateEndpointsBatchInput(v *UpdateEndpointsBatchInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateGcmChannel struct {
}

func (*awsRestjson1_serializeOpUpdateGcmChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateGcmChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGcmChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/gcm")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateGcmChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.GCMChannelRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentGCMChannelRequest(input.GCMChannelRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateGcmChannelInput(v *UpdateGcmChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateInAppTemplate struct {
}

func (*awsRestjson1_serializeOpUpdateInAppTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateInAppTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateInAppTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/inapp")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateInAppTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.InAppTemplateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentInAppTemplateRequest(input.InAppTemplateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateInAppTemplateInput(v *UpdateInAppTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreateNewVersion {
		encoder.SetQuery("create-new-version").Boolean(v.CreateNewVersion)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateJourney struct {
}

func (*awsRestjson1_serializeOpUpdateJourney) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateJourney) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJourneyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/journeys/{JourneyId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateJourneyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.WriteJourneyRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentWriteJourneyRequest(input.WriteJourneyRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateJourneyInput(v *UpdateJourneyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.JourneyId == nil || len(*v.JourneyId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JourneyId must not be empty")}
	}
	if v.JourneyId != nil {
		if err := encoder.SetURI("JourneyId").String(*v.JourneyId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateJourneyState struct {
}

func (*awsRestjson1_serializeOpUpdateJourneyState) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateJourneyState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJourneyStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/journeys/{JourneyId}/state")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateJourneyStateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.JourneyStateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentJourneyStateRequest(input.JourneyStateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateJourneyStateInput(v *UpdateJourneyStateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.JourneyId == nil || len(*v.JourneyId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JourneyId must not be empty")}
	}
	if v.JourneyId != nil {
		if err := encoder.SetURI("JourneyId").String(*v.JourneyId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePushTemplate struct {
}

func (*awsRestjson1_serializeOpUpdatePushTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePushTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePushTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/push")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePushTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.PushNotificationTemplateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentPushNotificationTemplateRequest(input.PushNotificationTemplateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePushTemplateInput(v *UpdatePushTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreateNewVersion {
		encoder.SetQuery("create-new-version").Boolean(v.CreateNewVersion)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRecommenderConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateRecommenderConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRecommenderConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRecommenderConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/recommenders/{RecommenderId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRecommenderConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.UpdateRecommenderConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentUpdateRecommenderConfigurationShape(input.UpdateRecommenderConfiguration, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRecommenderConfigurationInput(v *UpdateRecommenderConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RecommenderId == nil || len(*v.RecommenderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RecommenderId must not be empty")}
	}
	if v.RecommenderId != nil {
		if err := encoder.SetURI("RecommenderId").String(*v.RecommenderId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSegment struct {
}

func (*awsRestjson1_serializeOpUpdateSegment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSegment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSegmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/segments/{SegmentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSegmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.WriteSegmentRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentWriteSegmentRequest(input.WriteSegmentRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSegmentInput(v *UpdateSegmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.SegmentId == nil || len(*v.SegmentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SegmentId must not be empty")}
	}
	if v.SegmentId != nil {
		if err := encoder.SetURI("SegmentId").String(*v.SegmentId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSmsChannel struct {
}

func (*awsRestjson1_serializeOpUpdateSmsChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSmsChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSmsChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/sms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSmsChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.SMSChannelRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentSMSChannelRequest(input.SMSChannelRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSmsChannelInput(v *UpdateSmsChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSmsTemplate struct {
}

func (*awsRestjson1_serializeOpUpdateSmsTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSmsTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSmsTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/sms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSmsTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.SMSTemplateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentSMSTemplateRequest(input.SMSTemplateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSmsTemplateInput(v *UpdateSmsTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreateNewVersion {
		encoder.SetQuery("create-new-version").Boolean(v.CreateNewVersion)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTemplateActiveVersion struct {
}

func (*awsRestjson1_serializeOpUpdateTemplateActiveVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTemplateActiveVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTemplateActiveVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/{TemplateType}/active-version")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTemplateActiveVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.TemplateActiveVersionRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentTemplateActiveVersionRequest(input.TemplateActiveVersionRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTemplateActiveVersionInput(v *UpdateTemplateActiveVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.TemplateType == nil || len(*v.TemplateType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateType must not be empty")}
	}
	if v.TemplateType != nil {
		if err := encoder.SetURI("TemplateType").String(*v.TemplateType); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateVoiceChannel struct {
}

func (*awsRestjson1_serializeOpUpdateVoiceChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateVoiceChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVoiceChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apps/{ApplicationId}/channels/voice")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateVoiceChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.VoiceChannelRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentVoiceChannelRequest(input.VoiceChannelRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateVoiceChannelInput(v *UpdateVoiceChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApplicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("ApplicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateVoiceTemplate struct {
}

func (*awsRestjson1_serializeOpUpdateVoiceTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateVoiceTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVoiceTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/templates/{TemplateName}/voice")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateVoiceTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.VoiceTemplateRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/json")
		}

		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentVoiceTemplateRequest(input.VoiceTemplateRequest, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateVoiceTemplateInput(v *UpdateVoiceTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreateNewVersion {
		encoder.SetQuery("create-new-version").Boolean(v.CreateNewVersion)
	}

	if v.TemplateName == nil || len(*v.TemplateName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateName must not be empty")}
	}
	if v.TemplateName != nil {
		if err := encoder.SetURI("TemplateName").String(*v.TemplateName); err != nil {
			return err
		}
	}

	if v.Version != nil {
		encoder.SetQuery("version").String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentActivity(v *types.Activity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionalSplit != nil {
		ok := object.Key("ConditionalSplit")
		if err := awsRestjson1_serializeDocumentConditionalSplitActivity(v.ConditionalSplit, ok); err != nil {
			return err
		}
	}

	if v.ContactCenter != nil {
		ok := object.Key("ContactCenter")
		if err := awsRestjson1_serializeDocumentContactCenterActivity(v.ContactCenter, ok); err != nil {
			return err
		}
	}

	if v.CUSTOM != nil {
		ok := object.Key("CUSTOM")
		if err := awsRestjson1_serializeDocumentCustomMessageActivity(v.CUSTOM, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EMAIL != nil {
		ok := object.Key("EMAIL")
		if err := awsRestjson1_serializeDocumentEmailMessageActivity(v.EMAIL, ok); err != nil {
			return err
		}
	}

	if v.Holdout != nil {
		ok := object.Key("Holdout")
		if err := awsRestjson1_serializeDocumentHoldoutActivity(v.Holdout, ok); err != nil {
			return err
		}
	}

	if v.MultiCondition != nil {
		ok := object.Key("MultiCondition")
		if err := awsRestjson1_serializeDocumentMultiConditionalSplitActivity(v.MultiCondition, ok); err != nil {
			return err
		}
	}

	if v.PUSH != nil {
		ok := object.Key("PUSH")
		if err := awsRestjson1_serializeDocumentPushMessageActivity(v.PUSH, ok); err != nil {
			return err
		}
	}

	if v.RandomSplit != nil {
		ok := object.Key("RandomSplit")
		if err := awsRestjson1_serializeDocumentRandomSplitActivity(v.RandomSplit, ok); err != nil {
			return err
		}
	}

	if v.SMS != nil {
		ok := object.Key("SMS")
		if err := awsRestjson1_serializeDocumentSMSMessageActivity(v.SMS, ok); err != nil {
			return err
		}
	}

	if v.Wait != nil {
		ok := object.Key("Wait")
		if err := awsRestjson1_serializeDocumentWaitActivity(v.Wait, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAddressConfiguration(v *types.AddressConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BodyOverride != nil {
		ok := object.Key("BodyOverride")
		ok.String(*v.BodyOverride)
	}

	if len(v.ChannelType) > 0 {
		ok := object.Key("ChannelType")
		ok.String(string(v.ChannelType))
	}

	if v.Context != nil {
		ok := object.Key("Context")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Context, ok); err != nil {
			return err
		}
	}

	if v.RawContent != nil {
		ok := object.Key("RawContent")
		ok.String(*v.RawContent)
	}

	if v.Substitutions != nil {
		ok := object.Key("Substitutions")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Substitutions, ok); err != nil {
			return err
		}
	}

	if v.TitleOverride != nil {
		ok := object.Key("TitleOverride")
		ok.String(*v.TitleOverride)
	}

	return nil
}

func awsRestjson1_serializeDocumentADMChannelRequest(v *types.ADMChannelRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientSecret != nil {
		ok := object.Key("ClientSecret")
		ok.String(*v.ClientSecret)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentADMMessage(v *types.ADMMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.ConsolidationKey != nil {
		ok := object.Key("ConsolidationKey")
		ok.String(*v.ConsolidationKey)
	}

	if v.Data != nil {
		ok := object.Key("Data")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Data, ok); err != nil {
			return err
		}
	}

	if v.ExpiresAfter != nil {
		ok := object.Key("ExpiresAfter")
		ok.String(*v.ExpiresAfter)
	}

	if v.IconReference != nil {
		ok := object.Key("IconReference")
		ok.String(*v.IconReference)
	}

	if v.ImageIconUrl != nil {
		ok := object.Key("ImageIconUrl")
		ok.String(*v.ImageIconUrl)
	}

	if v.ImageUrl != nil {
		ok := object.Key("ImageUrl")
		ok.String(*v.ImageUrl)
	}

	if v.MD5 != nil {
		ok := object.Key("MD5")
		ok.String(*v.MD5)
	}

	if v.RawContent != nil {
		ok := object.Key("RawContent")
		ok.String(*v.RawContent)
	}

	if v.SilentPush {
		ok := object.Key("SilentPush")
		ok.Boolean(v.SilentPush)
	}

	if v.SmallImageIconUrl != nil {
		ok := object.Key("SmallImageIconUrl")
		ok.String(*v.SmallImageIconUrl)
	}

	if v.Sound != nil {
		ok := object.Key("Sound")
		ok.String(*v.Sound)
	}

	if v.Substitutions != nil {
		ok := object.Key("Substitutions")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Substitutions, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentAndroidPushNotificationTemplate(v *types.AndroidPushNotificationTemplate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.ImageIconUrl != nil {
		ok := object.Key("ImageIconUrl")
		ok.String(*v.ImageIconUrl)
	}

	if v.ImageUrl != nil {
		ok := object.Key("ImageUrl")
		ok.String(*v.ImageUrl)
	}

	if v.RawContent != nil {
		ok := object.Key("RawContent")
		ok.String(*v.RawContent)
	}

	if v.SmallImageIconUrl != nil {
		ok := object.Key("SmallImageIconUrl")
		ok.String(*v.SmallImageIconUrl)
	}

	if v.Sound != nil {
		ok := object.Key("Sound")
		ok.String(*v.Sound)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentAPNSChannelRequest(v *types.APNSChannelRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BundleId != nil {
		ok := object.Key("BundleId")
		ok.String(*v.BundleId)
	}

	if v.Certificate != nil {
		ok := object.Key("Certificate")
		ok.String(*v.Certificate)
	}

	if v.DefaultAuthenticationMethod != nil {
		ok := object.Key("DefaultAuthenticationMethod")
		ok.String(*v.DefaultAuthenticationMethod)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.PrivateKey != nil {
		ok := object.Key("PrivateKey")
		ok.String(*v.PrivateKey)
	}

	if v.TeamId != nil {
		ok := object.Key("TeamId")
		ok.String(*v.TeamId)
	}

	if v.TokenKey != nil {
		ok := object.Key("TokenKey")
		ok.String(*v.TokenKey)
	}

	if v.TokenKeyId != nil {
		ok := object.Key("TokenKeyId")
		ok.String(*v.TokenKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAPNSMessage(v *types.APNSMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.APNSPushType != nil {
		ok := object.Key("APNSPushType")
		ok.String(*v.APNSPushType)
	}

	if v.Badge != 0 {
		ok := object.Key("Badge")
		ok.Integer(v.Badge)
	}

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.Category != nil {
		ok := object.Key("Category")
		ok.String(*v.Category)
	}

	if v.CollapseId != nil {
		ok := object.Key("CollapseId")
		ok.String(*v.CollapseId)
	}

	if v.Data != nil {
		ok := object.Key("Data")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Data, ok); err != nil {
			return err
		}
	}

	if v.MediaUrl != nil {
		ok := object.Key("MediaUrl")
		ok.String(*v.MediaUrl)
	}

	if v.PreferredAuthenticationMethod != nil {
		ok := object.Key("PreferredAuthenticationMethod")
		ok.String(*v.PreferredAuthenticationMethod)
	}

	if v.Priority != nil {
		ok := object.Key("Priority")
		ok.String(*v.Priority)
	}

	if v.RawContent != nil {
		ok := object.Key("RawContent")
		ok.String(*v.RawContent)
	}

	if v.SilentPush {
		ok := object.Key("SilentPush")
		ok.Boolean(v.SilentPush)
	}

	if v.Sound != nil {
		ok := object.Key("Sound")
		ok.String(*v.Sound)
	}

	if v.Substitutions != nil {
		ok := object.Key("Substitutions")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Substitutions, ok); err != nil {
			return err
		}
	}

	if v.ThreadId != nil {
		ok := object.Key("ThreadId")
		ok.String(*v.ThreadId)
	}

	if v.TimeToLive != 0 {
		ok := object.Key("TimeToLive")
		ok.Integer(v.TimeToLive)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentAPNSPushNotificationTemplate(v *types.APNSPushNotificationTemplate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.MediaUrl != nil {
		ok := object.Key("MediaUrl")
		ok.String(*v.MediaUrl)
	}

	if v.RawContent != nil {
		ok := object.Key("RawContent")
		ok.String(*v.RawContent)
	}

	if v.Sound != nil {
		ok := object.Key("Sound")
		ok.String(*v.Sound)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentAPNSSandboxChannelRequest(v *types.APNSSandboxChannelRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BundleId != nil {
		ok := object.Key("BundleId")
		ok.String(*v.BundleId)
	}

	if v.Certificate != nil {
		ok := object.Key("Certificate")
		ok.String(*v.Certificate)
	}

	if v.DefaultAuthenticationMethod != nil {
		ok := object.Key("DefaultAuthenticationMethod")
		ok.String(*v.DefaultAuthenticationMethod)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.PrivateKey != nil {
		ok := object.Key("PrivateKey")
		ok.String(*v.PrivateKey)
	}

	if v.TeamId != nil {
		ok := object.Key("TeamId")
		ok.String(*v.TeamId)
	}

	if v.TokenKey != nil {
		ok := object.Key("TokenKey")
		ok.String(*v.TokenKey)
	}

	if v.TokenKeyId != nil {
		ok := object.Key("TokenKeyId")
		ok.String(*v.TokenKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAPNSVoipChannelRequest(v *types.APNSVoipChannelRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BundleId != nil {
		ok := object.Key("BundleId")
		ok.String(*v.BundleId)
	}

	if v.Certificate != nil {
		ok := object.Key("Certificate")
		ok.String(*v.Certificate)
	}

	if v.DefaultAuthenticationMethod != nil {
		ok := object.Key("DefaultAuthenticationMethod")
		ok.String(*v.DefaultAuthenticationMethod)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.PrivateKey != nil {
		ok := object.Key("PrivateKey")
		ok.String(*v.PrivateKey)
	}

	if v.TeamId != nil {
		ok := object.Key("TeamId")
		ok.String(*v.TeamId)
	}

	if v.TokenKey != nil {
		ok := object.Key("TokenKey")
		ok.String(*v.TokenKey)
	}

	if v.TokenKeyId != nil {
		ok := object.Key("TokenKeyId")
		ok.String(*v.TokenKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAPNSVoipSandboxChannelRequest(v *types.APNSVoipSandboxChannelRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BundleId != nil {
		ok := object.Key("BundleId")
		ok.String(*v.BundleId)
	}

	if v.Certificate != nil {
		ok := object.Key("Certificate")
		ok.String(*v.Certificate)
	}

	if v.DefaultAuthenticationMethod != nil {
		ok := object.Key("DefaultAuthenticationMethod")
		ok.String(*v.DefaultAuthenticationMethod)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.PrivateKey != nil {
		ok := object.Key("PrivateKey")
		ok.String(*v.PrivateKey)
	}

	if v.TeamId != nil {
		ok := object.Key("TeamId")
		ok.String(*v.TeamId)
	}

	if v.TokenKey != nil {
		ok := object.Key("TokenKey")
		ok.String(*v.TokenKey)
	}

	if v.TokenKeyId != nil {
		ok := object.Key("TokenKeyId")
		ok.String(*v.TokenKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributeDimension(v *types.AttributeDimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AttributeType) > 0 {
		ok := object.Key("AttributeType")
		ok.String(string(v.AttributeType))
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentListOf__string(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBaiduChannelRequest(v *types.BaiduChannelRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKey != nil {
		ok := object.Key("ApiKey")
		ok.String(*v.ApiKey)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.SecretKey != nil {
		ok := object.Key("SecretKey")
		ok.String(*v.SecretKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentBaiduMessage(v *types.BaiduMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.Data != nil {
		ok := object.Key("Data")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Data, ok); err != nil {
			return err
		}
	}

	if v.IconReference != nil {
		ok := object.Key("IconReference")
		ok.String(*v.IconReference)
	}

	if v.ImageIconUrl != nil {
		ok := object.Key("ImageIconUrl")
		ok.String(*v.ImageIconUrl)
	}

	if v.ImageUrl != nil {
		ok := object.Key("ImageUrl")
		ok.String(*v.ImageUrl)
	}

	if v.RawContent != nil {
		ok := object.Key("RawContent")
		ok.String(*v.RawContent)
	}

	if v.SilentPush {
		ok := object.Key("SilentPush")
		ok.Boolean(v.SilentPush)
	}

	if v.SmallImageIconUrl != nil {
		ok := object.Key("SmallImageIconUrl")
		ok.String(*v.SmallImageIconUrl)
	}

	if v.Sound != nil {
		ok := object.Key("Sound")
		ok.String(*v.Sound)
	}

	if v.Substitutions != nil {
		ok := object.Key("Substitutions")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Substitutions, ok); err != nil {
			return err
		}
	}

	if v.TimeToLive != 0 {
		ok := object.Key("TimeToLive")
		ok.Integer(v.TimeToLive)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentCampaignCustomMessage(v *types.CampaignCustomMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Data != nil {
		ok := object.Key("Data")
		ok.String(*v.Data)
	}

	return nil
}

func awsRestjson1_serializeDocumentCampaignEmailMessage(v *types.CampaignEmailMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.FromAddress != nil {
		ok := object.Key("FromAddress")
		ok.String(*v.FromAddress)
	}

	if v.HtmlBody != nil {
		ok := object.Key("HtmlBody")
		ok.String(*v.HtmlBody)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentCampaignEventFilter(v *types.CampaignEventFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dimensions != nil {
		ok := object.Key("Dimensions")
		if err := awsRestjson1_serializeDocumentEventDimensions(v.Dimensions, ok); err != nil {
			return err
		}
	}

	if len(v.FilterType) > 0 {
		ok := object.Key("FilterType")
		ok.String(string(v.FilterType))
	}

	return nil
}

func awsRestjson1_serializeDocumentCampaignHook(v *types.CampaignHook, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaFunctionName != nil {
		ok := object.Key("LambdaFunctionName")
		ok.String(*v.LambdaFunctionName)
	}

	if len(v.Mode) > 0 {
		ok := object.Key("Mode")
		ok.String(string(v.Mode))
	}

	if v.WebUrl != nil {
		ok := object.Key("WebUrl")
		ok.String(*v.WebUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentCampaignInAppMessage(v *types.CampaignInAppMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.Content != nil {
		ok := object.Key("Content")
		if err := awsRestjson1_serializeDocumentListOfInAppMessageContent(v.Content, ok); err != nil {
			return err
		}
	}

	if v.CustomConfig != nil {
		ok := object.Key("CustomConfig")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.CustomConfig, ok); err != nil {
			return err
		}
	}

	if len(v.Layout) > 0 {
		ok := object.Key("Layout")
		ok.String(string(v.Layout))
	}

	return nil
}

func awsRestjson1_serializeDocumentCampaignLimits(v *types.CampaignLimits, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Daily != 0 {
		ok := object.Key("Daily")
		ok.Integer(v.Daily)
	}

	if v.MaximumDuration != 0 {
		ok := object.Key("MaximumDuration")
		ok.Integer(v.MaximumDuration)
	}

	if v.MessagesPerSecond != 0 {
		ok := object.Key("MessagesPerSecond")
		ok.Integer(v.MessagesPerSecond)
	}

	if v.Session != 0 {
		ok := object.Key("Session")
		ok.Integer(v.Session)
	}

	if v.Total != 0 {
		ok := object.Key("Total")
		ok.Integer(v.Total)
	}

	return nil
}

func awsRestjson1_serializeDocumentCampaignSmsMessage(v *types.CampaignSmsMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.EntityId != nil {
		ok := object.Key("EntityId")
		ok.String(*v.EntityId)
	}

	if len(v.MessageType) > 0 {
		ok := object.Key("MessageType")
		ok.String(string(v.MessageType))
	}

	if v.OriginationNumber != nil {
		ok := object.Key("OriginationNumber")
		ok.String(*v.OriginationNumber)
	}

	if v.SenderId != nil {
		ok := object.Key("SenderId")
		ok.String(*v.SenderId)
	}

	if v.TemplateId != nil {
		ok := object.Key("TemplateId")
		ok.String(*v.TemplateId)
	}

	return nil
}

func awsRestjson1_serializeDocumentCondition(v *types.Condition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Conditions != nil {
		ok := object.Key("Conditions")
		if err := awsRestjson1_serializeDocumentListOfSimpleCondition(v.Conditions, ok); err != nil {
			return err
		}
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	return nil
}

func awsRestjson1_serializeDocumentConditionalSplitActivity(v *types.ConditionalSplitActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Condition != nil {
		ok := object.Key("Condition")
		if err := awsRestjson1_serializeDocumentCondition(v.Condition, ok); err != nil {
			return err
		}
	}

	if v.EvaluationWaitTime != nil {
		ok := object.Key("EvaluationWaitTime")
		if err := awsRestjson1_serializeDocumentWaitTime(v.EvaluationWaitTime, ok); err != nil {
			return err
		}
	}

	if v.FalseActivity != nil {
		ok := object.Key("FalseActivity")
		ok.String(*v.FalseActivity)
	}

	if v.TrueActivity != nil {
		ok := object.Key("TrueActivity")
		ok.String(*v.TrueActivity)
	}

	return nil
}

func awsRestjson1_serializeDocumentContactCenterActivity(v *types.ContactCenterActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NextActivity != nil {
		ok := object.Key("NextActivity")
		ok.String(*v.NextActivity)
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateApplicationRequest(v *types.CreateApplicationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateRecommenderConfigurationShape(v *types.CreateRecommenderConfigurationShape, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RecommendationProviderIdType != nil {
		ok := object.Key("RecommendationProviderIdType")
		ok.String(*v.RecommendationProviderIdType)
	}

	if v.RecommendationProviderRoleArn != nil {
		ok := object.Key("RecommendationProviderRoleArn")
		ok.String(*v.RecommendationProviderRoleArn)
	}

	if v.RecommendationProviderUri != nil {
		ok := object.Key("RecommendationProviderUri")
		ok.String(*v.RecommendationProviderUri)
	}

	if v.RecommendationsDisplayName != nil {
		ok := object.Key("RecommendationsDisplayName")
		ok.String(*v.RecommendationsDisplayName)
	}

	if v.RecommendationsPerMessage != 0 {
		ok := object.Key("RecommendationsPerMessage")
		ok.Integer(v.RecommendationsPerMessage)
	}

	if v.RecommendationTransformerUri != nil {
		ok := object.Key("RecommendationTransformerUri")
		ok.String(*v.RecommendationTransformerUri)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomDeliveryConfiguration(v *types.CustomDeliveryConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryUri != nil {
		ok := object.Key("DeliveryUri")
		ok.String(*v.DeliveryUri)
	}

	if v.EndpointTypes != nil {
		ok := object.Key("EndpointTypes")
		if err := awsRestjson1_serializeDocumentListOf__EndpointTypesElement(v.EndpointTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomMessageActivity(v *types.CustomMessageActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryUri != nil {
		ok := object.Key("DeliveryUri")
		ok.String(*v.DeliveryUri)
	}

	if v.EndpointTypes != nil {
		ok := object.Key("EndpointTypes")
		if err := awsRestjson1_serializeDocumentListOf__EndpointTypesElement(v.EndpointTypes, ok); err != nil {
			return err
		}
	}

	if v.MessageConfig != nil {
		ok := object.Key("MessageConfig")
		if err := awsRestjson1_serializeDocumentJourneyCustomMessage(v.MessageConfig, ok); err != nil {
			return err
		}
	}

	if v.NextActivity != nil {
		ok := object.Key("NextActivity")
		ok.String(*v.NextActivity)
	}

	if v.TemplateName != nil {
		ok := object.Key("TemplateName")
		ok.String(*v.TemplateName)
	}

	if v.TemplateVersion != nil {
		ok := object.Key("TemplateVersion")
		ok.String(*v.TemplateVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultButtonConfiguration(v *types.DefaultButtonConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackgroundColor != nil {
		ok := object.Key("BackgroundColor")
		ok.String(*v.BackgroundColor)
	}

	if v.BorderRadius != 0 {
		ok := object.Key("BorderRadius")
		ok.Integer(v.BorderRadius)
	}

	if len(v.ButtonAction) > 0 {
		ok := object.Key("ButtonAction")
		ok.String(string(v.ButtonAction))
	}

	if v.Link != nil {
		ok := object.Key("Link")
		ok.String(*v.Link)
	}

	if v.Text != nil {
		ok := object.Key("Text")
		ok.String(*v.Text)
	}

	if v.TextColor != nil {
		ok := object.Key("TextColor")
		ok.String(*v.TextColor)
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultMessage(v *types.DefaultMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.Substitutions != nil {
		ok := object.Key("Substitutions")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Substitutions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultPushNotificationMessage(v *types.DefaultPushNotificationMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.Data != nil {
		ok := object.Key("Data")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Data, ok); err != nil {
			return err
		}
	}

	if v.SilentPush {
		ok := object.Key("SilentPush")
		ok.Boolean(v.SilentPush)
	}

	if v.Substitutions != nil {
		ok := object.Key("Substitutions")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Substitutions, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultPushNotificationTemplate(v *types.DefaultPushNotificationTemplate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.Sound != nil {
		ok := object.Key("Sound")
		ok.String(*v.Sound)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentDirectMessageConfiguration(v *types.DirectMessageConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ADMMessage != nil {
		ok := object.Key("ADMMessage")
		if err := awsRestjson1_serializeDocumentADMMessage(v.ADMMessage, ok); err != nil {
			return err
		}
	}

	if v.APNSMessage != nil {
		ok := object.Key("APNSMessage")
		if err := awsRestjson1_serializeDocumentAPNSMessage(v.APNSMessage, ok); err != nil {
			return err
		}
	}

	if v.BaiduMessage != nil {
		ok := object.Key("BaiduMessage")
		if err := awsRestjson1_serializeDocumentBaiduMessage(v.BaiduMessage, ok); err != nil {
			return err
		}
	}

	if v.DefaultMessage != nil {
		ok := object.Key("DefaultMessage")
		if err := awsRestjson1_serializeDocumentDefaultMessage(v.DefaultMessage, ok); err != nil {
			return err
		}
	}

	if v.DefaultPushNotificationMessage != nil {
		ok := object.Key("DefaultPushNotificationMessage")
		if err := awsRestjson1_serializeDocumentDefaultPushNotificationMessage(v.DefaultPushNotificationMessage, ok); err != nil {
			return err
		}
	}

	if v.EmailMessage != nil {
		ok := object.Key("EmailMessage")
		if err := awsRestjson1_serializeDocumentEmailMessage(v.EmailMessage, ok); err != nil {
			return err
		}
	}

	if v.GCMMessage != nil {
		ok := object.Key("GCMMessage")
		if err := awsRestjson1_serializeDocumentGCMMessage(v.GCMMessage, ok); err != nil {
			return err
		}
	}

	if v.SMSMessage != nil {
		ok := object.Key("SMSMessage")
		if err := awsRestjson1_serializeDocumentSMSMessage(v.SMSMessage, ok); err != nil {
			return err
		}
	}

	if v.VoiceMessage != nil {
		ok := object.Key("VoiceMessage")
		if err := awsRestjson1_serializeDocumentVoiceMessage(v.VoiceMessage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEmailChannelRequest(v *types.EmailChannelRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationSet != nil {
		ok := object.Key("ConfigurationSet")
		ok.String(*v.ConfigurationSet)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.FromAddress != nil {
		ok := object.Key("FromAddress")
		ok.String(*v.FromAddress)
	}

	if v.Identity != nil {
		ok := object.Key("Identity")
		ok.String(*v.Identity)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentEmailMessage(v *types.EmailMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.FeedbackForwardingAddress != nil {
		ok := object.Key("FeedbackForwardingAddress")
		ok.String(*v.FeedbackForwardingAddress)
	}

	if v.FromAddress != nil {
		ok := object.Key("FromAddress")
		ok.String(*v.FromAddress)
	}

	if v.RawEmail != nil {
		ok := object.Key("RawEmail")
		if err := awsRestjson1_serializeDocumentRawEmail(v.RawEmail, ok); err != nil {
			return err
		}
	}

	if v.ReplyToAddresses != nil {
		ok := object.Key("ReplyToAddresses")
		if err := awsRestjson1_serializeDocumentListOf__string(v.ReplyToAddresses, ok); err != nil {
			return err
		}
	}

	if v.SimpleEmail != nil {
		ok := object.Key("SimpleEmail")
		if err := awsRestjson1_serializeDocumentSimpleEmail(v.SimpleEmail, ok); err != nil {
			return err
		}
	}

	if v.Substitutions != nil {
		ok := object.Key("Substitutions")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Substitutions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEmailMessageActivity(v *types.EmailMessageActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MessageConfig != nil {
		ok := object.Key("MessageConfig")
		if err := awsRestjson1_serializeDocumentJourneyEmailMessage(v.MessageConfig, ok); err != nil {
			return err
		}
	}

	if v.NextActivity != nil {
		ok := object.Key("NextActivity")
		ok.String(*v.NextActivity)
	}

	if v.TemplateName != nil {
		ok := object.Key("TemplateName")
		ok.String(*v.TemplateName)
	}

	if v.TemplateVersion != nil {
		ok := object.Key("TemplateVersion")
		ok.String(*v.TemplateVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentEmailTemplateRequest(v *types.EmailTemplateRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultSubstitutions != nil {
		ok := object.Key("DefaultSubstitutions")
		ok.String(*v.DefaultSubstitutions)
	}

	if v.HtmlPart != nil {
		ok := object.Key("HtmlPart")
		ok.String(*v.HtmlPart)
	}

	if v.RecommenderId != nil {
		ok := object.Key("RecommenderId")
		ok.String(*v.RecommenderId)
	}

	if v.Subject != nil {
		ok := object.Key("Subject")
		ok.String(*v.Subject)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TemplateDescription != nil {
		ok := object.Key("TemplateDescription")
		ok.String(*v.TemplateDescription)
	}

	if v.TextPart != nil {
		ok := object.Key("TextPart")
		ok.String(*v.TextPart)
	}

	return nil
}

func awsRestjson1_serializeDocumentEndpointBatchItem(v *types.EndpointBatchItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Address != nil {
		ok := object.Key("Address")
		ok.String(*v.Address)
	}

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Attributes, ok); err != nil {
			return err
		}
	}

	if len(v.ChannelType) > 0 {
		ok := object.Key("ChannelType")
		ok.String(string(v.ChannelType))
	}

	if v.Demographic != nil {
		ok := object.Key("Demographic")
		if err := awsRestjson1_serializeDocumentEndpointDemographic(v.Demographic, ok); err != nil {
			return err
		}
	}

	if v.EffectiveDate != nil {
		ok := object.Key("EffectiveDate")
		ok.String(*v.EffectiveDate)
	}

	if v.EndpointStatus != nil {
		ok := object.Key("EndpointStatus")
		ok.String(*v.EndpointStatus)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		if err := awsRestjson1_serializeDocumentEndpointLocation(v.Location, ok); err != nil {
			return err
		}
	}

	if v.Metrics != nil {
		ok := object.Key("Metrics")
		if err := awsRestjson1_serializeDocumentMapOf__double(v.Metrics, ok); err != nil {
			return err
		}
	}

	if v.OptOut != nil {
		ok := object.Key("OptOut")
		ok.String(*v.OptOut)
	}

	if v.RequestId != nil {
		ok := object.Key("RequestId")
		ok.String(*v.RequestId)
	}

	if v.User != nil {
		ok := object.Key("User")
		if err := awsRestjson1_serializeDocumentEndpointUser(v.User, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEndpointBatchRequest(v *types.EndpointBatchRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Item != nil {
		ok := object.Key("Item")
		if err := awsRestjson1_serializeDocumentListOfEndpointBatchItem(v.Item, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEndpointDemographic(v *types.EndpointDemographic, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppVersion != nil {
		ok := object.Key("AppVersion")
		ok.String(*v.AppVersion)
	}

	if v.Locale != nil {
		ok := object.Key("Locale")
		ok.String(*v.Locale)
	}

	if v.Make != nil {
		ok := object.Key("Make")
		ok.String(*v.Make)
	}

	if v.Model != nil {
		ok := object.Key("Model")
		ok.String(*v.Model)
	}

	if v.ModelVersion != nil {
		ok := object.Key("ModelVersion")
		ok.String(*v.ModelVersion)
	}

	if v.Platform != nil {
		ok := object.Key("Platform")
		ok.String(*v.Platform)
	}

	if v.PlatformVersion != nil {
		ok := object.Key("PlatformVersion")
		ok.String(*v.PlatformVersion)
	}

	if v.Timezone != nil {
		ok := object.Key("Timezone")
		ok.String(*v.Timezone)
	}

	return nil
}

func awsRestjson1_serializeDocumentEndpointLocation(v *types.EndpointLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.City != nil {
		ok := object.Key("City")
		ok.String(*v.City)
	}

	if v.Country != nil {
		ok := object.Key("Country")
		ok.String(*v.Country)
	}

	if v.Latitude != 0 {
		ok := object.Key("Latitude")
		switch {
		case math.IsNaN(v.Latitude):
			ok.String("NaN")

		case math.IsInf(v.Latitude, 1):
			ok.String("Infinity")

		case math.IsInf(v.Latitude, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Latitude)

		}
	}

	if v.Longitude != 0 {
		ok := object.Key("Longitude")
		switch {
		case math.IsNaN(v.Longitude):
			ok.String("NaN")

		case math.IsInf(v.Longitude, 1):
			ok.String("Infinity")

		case math.IsInf(v.Longitude, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Longitude)

		}
	}

	if v.PostalCode != nil {
		ok := object.Key("PostalCode")
		ok.String(*v.PostalCode)
	}

	if v.Region != nil {
		ok := object.Key("Region")
		ok.String(*v.Region)
	}

	return nil
}

func awsRestjson1_serializeDocumentEndpointRequest(v *types.EndpointRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Address != nil {
		ok := object.Key("Address")
		ok.String(*v.Address)
	}

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Attributes, ok); err != nil {
			return err
		}
	}

	if len(v.ChannelType) > 0 {
		ok := object.Key("ChannelType")
		ok.String(string(v.ChannelType))
	}

	if v.Demographic != nil {
		ok := object.Key("Demographic")
		if err := awsRestjson1_serializeDocumentEndpointDemographic(v.Demographic, ok); err != nil {
			return err
		}
	}

	if v.EffectiveDate != nil {
		ok := object.Key("EffectiveDate")
		ok.String(*v.EffectiveDate)
	}

	if v.EndpointStatus != nil {
		ok := object.Key("EndpointStatus")
		ok.String(*v.EndpointStatus)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		if err := awsRestjson1_serializeDocumentEndpointLocation(v.Location, ok); err != nil {
			return err
		}
	}

	if v.Metrics != nil {
		ok := object.Key("Metrics")
		if err := awsRestjson1_serializeDocumentMapOf__double(v.Metrics, ok); err != nil {
			return err
		}
	}

	if v.OptOut != nil {
		ok := object.Key("OptOut")
		ok.String(*v.OptOut)
	}

	if v.RequestId != nil {
		ok := object.Key("RequestId")
		ok.String(*v.RequestId)
	}

	if v.User != nil {
		ok := object.Key("User")
		if err := awsRestjson1_serializeDocumentEndpointUser(v.User, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEndpointSendConfiguration(v *types.EndpointSendConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BodyOverride != nil {
		ok := object.Key("BodyOverride")
		ok.String(*v.BodyOverride)
	}

	if v.Context != nil {
		ok := object.Key("Context")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Context, ok); err != nil {
			return err
		}
	}

	if v.RawContent != nil {
		ok := object.Key("RawContent")
		ok.String(*v.RawContent)
	}

	if v.Substitutions != nil {
		ok := object.Key("Substitutions")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Substitutions, ok); err != nil {
			return err
		}
	}

	if v.TitleOverride != nil {
		ok := object.Key("TitleOverride")
		ok.String(*v.TitleOverride)
	}

	return nil
}

func awsRestjson1_serializeDocumentEndpointUser(v *types.EndpointUser, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserAttributes != nil {
		ok := object.Key("UserAttributes")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.UserAttributes, ok); err != nil {
			return err
		}
	}

	if v.UserId != nil {
		ok := object.Key("UserId")
		ok.String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvent(v *types.Event, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppPackageName != nil {
		ok := object.Key("AppPackageName")
		ok.String(*v.AppPackageName)
	}

	if v.AppTitle != nil {
		ok := object.Key("AppTitle")
		ok.String(*v.AppTitle)
	}

	if v.AppVersionCode != nil {
		ok := object.Key("AppVersionCode")
		ok.String(*v.AppVersionCode)
	}

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.ClientSdkVersion != nil {
		ok := object.Key("ClientSdkVersion")
		ok.String(*v.ClientSdkVersion)
	}

	if v.EventType != nil {
		ok := object.Key("EventType")
		ok.String(*v.EventType)
	}

	if v.Metrics != nil {
		ok := object.Key("Metrics")
		if err := awsRestjson1_serializeDocumentMapOf__double(v.Metrics, ok); err != nil {
			return err
		}
	}

	if v.SdkName != nil {
		ok := object.Key("SdkName")
		ok.String(*v.SdkName)
	}

	if v.Session != nil {
		ok := object.Key("Session")
		if err := awsRestjson1_serializeDocumentSession(v.Session, ok); err != nil {
			return err
		}
	}

	if v.Timestamp != nil {
		ok := object.Key("Timestamp")
		ok.String(*v.Timestamp)
	}

	return nil
}

func awsRestjson1_serializeDocumentEventCondition(v *types.EventCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dimensions != nil {
		ok := object.Key("Dimensions")
		if err := awsRestjson1_serializeDocumentEventDimensions(v.Dimensions, ok); err != nil {
			return err
		}
	}

	if v.MessageActivity != nil {
		ok := object.Key("MessageActivity")
		ok.String(*v.MessageActivity)
	}

	return nil
}

func awsRestjson1_serializeDocumentEventDimensions(v *types.EventDimensions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentMapOfAttributeDimension(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.EventType != nil {
		ok := object.Key("EventType")
		if err := awsRestjson1_serializeDocumentSetDimension(v.EventType, ok); err != nil {
			return err
		}
	}

	if v.Metrics != nil {
		ok := object.Key("Metrics")
		if err := awsRestjson1_serializeDocumentMapOfMetricDimension(v.Metrics, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEventFilter(v *types.EventFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dimensions != nil {
		ok := object.Key("Dimensions")
		if err := awsRestjson1_serializeDocumentEventDimensions(v.Dimensions, ok); err != nil {
			return err
		}
	}

	if len(v.FilterType) > 0 {
		ok := object.Key("FilterType")
		ok.String(string(v.FilterType))
	}

	return nil
}

func awsRestjson1_serializeDocumentEventsBatch(v *types.EventsBatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Endpoint != nil {
		ok := object.Key("Endpoint")
		if err := awsRestjson1_serializeDocumentPublicEndpoint(v.Endpoint, ok); err != nil {
			return err
		}
	}

	if v.Events != nil {
		ok := object.Key("Events")
		if err := awsRestjson1_serializeDocumentMapOfEvent(v.Events, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEventsRequest(v *types.EventsRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchItem != nil {
		ok := object.Key("BatchItem")
		if err := awsRestjson1_serializeDocumentMapOfEventsBatch(v.BatchItem, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEventStartCondition(v *types.EventStartCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventFilter != nil {
		ok := object.Key("EventFilter")
		if err := awsRestjson1_serializeDocumentEventFilter(v.EventFilter, ok); err != nil {
			return err
		}
	}

	if v.SegmentId != nil {
		ok := object.Key("SegmentId")
		ok.String(*v.SegmentId)
	}

	return nil
}

func awsRestjson1_serializeDocumentExportJobRequest(v *types.ExportJobRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.S3UrlPrefix != nil {
		ok := object.Key("S3UrlPrefix")
		ok.String(*v.S3UrlPrefix)
	}

	if v.SegmentId != nil {
		ok := object.Key("SegmentId")
		ok.String(*v.SegmentId)
	}

	if v.SegmentVersion != 0 {
		ok := object.Key("SegmentVersion")
		ok.Integer(v.SegmentVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentGCMChannelRequest(v *types.GCMChannelRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKey != nil {
		ok := object.Key("ApiKey")
		ok.String(*v.ApiKey)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentGCMMessage(v *types.GCMMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.CollapseKey != nil {
		ok := object.Key("CollapseKey")
		ok.String(*v.CollapseKey)
	}

	if v.Data != nil {
		ok := object.Key("Data")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Data, ok); err != nil {
			return err
		}
	}

	if v.IconReference != nil {
		ok := object.Key("IconReference")
		ok.String(*v.IconReference)
	}

	if v.ImageIconUrl != nil {
		ok := object.Key("ImageIconUrl")
		ok.String(*v.ImageIconUrl)
	}

	if v.ImageUrl != nil {
		ok := object.Key("ImageUrl")
		ok.String(*v.ImageUrl)
	}

	if v.Priority != nil {
		ok := object.Key("Priority")
		ok.String(*v.Priority)
	}

	if v.RawContent != nil {
		ok := object.Key("RawContent")
		ok.String(*v.RawContent)
	}

	if v.RestrictedPackageName != nil {
		ok := object.Key("RestrictedPackageName")
		ok.String(*v.RestrictedPackageName)
	}

	if v.SilentPush {
		ok := object.Key("SilentPush")
		ok.Boolean(v.SilentPush)
	}

	if v.SmallImageIconUrl != nil {
		ok := object.Key("SmallImageIconUrl")
		ok.String(*v.SmallImageIconUrl)
	}

	if v.Sound != nil {
		ok := object.Key("Sound")
		ok.String(*v.Sound)
	}

	if v.Substitutions != nil {
		ok := object.Key("Substitutions")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Substitutions, ok); err != nil {
			return err
		}
	}

	if v.TimeToLive != 0 {
		ok := object.Key("TimeToLive")
		ok.Integer(v.TimeToLive)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentGPSCoordinates(v *types.GPSCoordinates, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("Latitude")
		switch {
		case math.IsNaN(v.Latitude):
			ok.String("NaN")

		case math.IsInf(v.Latitude, 1):
			ok.String("Infinity")

		case math.IsInf(v.Latitude, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Latitude)

		}
	}

	{
		ok := object.Key("Longitude")
		switch {
		case math.IsNaN(v.Longitude):
			ok.String("NaN")

		case math.IsInf(v.Longitude, 1):
			ok.String("Infinity")

		case math.IsInf(v.Longitude, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Longitude)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGPSPointDimension(v *types.GPSPointDimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Coordinates != nil {
		ok := object.Key("Coordinates")
		if err := awsRestjson1_serializeDocumentGPSCoordinates(v.Coordinates, ok); err != nil {
			return err
		}
	}

	if v.RangeInKilometers != 0 {
		ok := object.Key("RangeInKilometers")
		switch {
		case math.IsNaN(v.RangeInKilometers):
			ok.String("NaN")

		case math.IsInf(v.RangeInKilometers, 1):
			ok.String("Infinity")

		case math.IsInf(v.RangeInKilometers, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.RangeInKilometers)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHoldoutActivity(v *types.HoldoutActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NextActivity != nil {
		ok := object.Key("NextActivity")
		ok.String(*v.NextActivity)
	}

	{
		ok := object.Key("Percentage")
		ok.Integer(v.Percentage)
	}

	return nil
}

func awsRestjson1_serializeDocumentImportJobRequest(v *types.ImportJobRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefineSegment {
		ok := object.Key("DefineSegment")
		ok.Boolean(v.DefineSegment)
	}

	if v.ExternalId != nil {
		ok := object.Key("ExternalId")
		ok.String(*v.ExternalId)
	}

	if len(v.Format) > 0 {
		ok := object.Key("Format")
		ok.String(string(v.Format))
	}

	if v.RegisterEndpoints {
		ok := object.Key("RegisterEndpoints")
		ok.Boolean(v.RegisterEndpoints)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.S3Url != nil {
		ok := object.Key("S3Url")
		ok.String(*v.S3Url)
	}

	if v.SegmentId != nil {
		ok := object.Key("SegmentId")
		ok.String(*v.SegmentId)
	}

	if v.SegmentName != nil {
		ok := object.Key("SegmentName")
		ok.String(*v.SegmentName)
	}

	return nil
}

func awsRestjson1_serializeDocumentInAppMessageBodyConfig(v *types.InAppMessageBodyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Alignment) > 0 {
		ok := object.Key("Alignment")
		ok.String(string(v.Alignment))
	}

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.TextColor != nil {
		ok := object.Key("TextColor")
		ok.String(*v.TextColor)
	}

	return nil
}

func awsRestjson1_serializeDocumentInAppMessageButton(v *types.InAppMessageButton, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Android != nil {
		ok := object.Key("Android")
		if err := awsRestjson1_serializeDocumentOverrideButtonConfiguration(v.Android, ok); err != nil {
			return err
		}
	}

	if v.DefaultConfig != nil {
		ok := object.Key("DefaultConfig")
		if err := awsRestjson1_serializeDocumentDefaultButtonConfiguration(v.DefaultConfig, ok); err != nil {
			return err
		}
	}

	if v.IOS != nil {
		ok := object.Key("IOS")
		if err := awsRestjson1_serializeDocumentOverrideButtonConfiguration(v.IOS, ok); err != nil {
			return err
		}
	}

	if v.Web != nil {
		ok := object.Key("Web")
		if err := awsRestjson1_serializeDocumentOverrideButtonConfiguration(v.Web, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInAppMessageContent(v *types.InAppMessageContent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackgroundColor != nil {
		ok := object.Key("BackgroundColor")
		ok.String(*v.BackgroundColor)
	}

	if v.BodyConfig != nil {
		ok := object.Key("BodyConfig")
		if err := awsRestjson1_serializeDocumentInAppMessageBodyConfig(v.BodyConfig, ok); err != nil {
			return err
		}
	}

	if v.HeaderConfig != nil {
		ok := object.Key("HeaderConfig")
		if err := awsRestjson1_serializeDocumentInAppMessageHeaderConfig(v.HeaderConfig, ok); err != nil {
			return err
		}
	}

	if v.ImageUrl != nil {
		ok := object.Key("ImageUrl")
		ok.String(*v.ImageUrl)
	}

	if v.PrimaryBtn != nil {
		ok := object.Key("PrimaryBtn")
		if err := awsRestjson1_serializeDocumentInAppMessageButton(v.PrimaryBtn, ok); err != nil {
			return err
		}
	}

	if v.SecondaryBtn != nil {
		ok := object.Key("SecondaryBtn")
		if err := awsRestjson1_serializeDocumentInAppMessageButton(v.SecondaryBtn, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInAppMessageHeaderConfig(v *types.InAppMessageHeaderConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Alignment) > 0 {
		ok := object.Key("Alignment")
		ok.String(string(v.Alignment))
	}

	if v.Header != nil {
		ok := object.Key("Header")
		ok.String(*v.Header)
	}

	if v.TextColor != nil {
		ok := object.Key("TextColor")
		ok.String(*v.TextColor)
	}

	return nil
}

func awsRestjson1_serializeDocumentInAppTemplateRequest(v *types.InAppTemplateRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("Content")
		if err := awsRestjson1_serializeDocumentListOfInAppMessageContent(v.Content, ok); err != nil {
			return err
		}
	}

	if v.CustomConfig != nil {
		ok := object.Key("CustomConfig")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.CustomConfig, ok); err != nil {
			return err
		}
	}

	if len(v.Layout) > 0 {
		ok := object.Key("Layout")
		ok.String(string(v.Layout))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TemplateDescription != nil {
		ok := object.Key("TemplateDescription")
		ok.String(*v.TemplateDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentJourneyCustomMessage(v *types.JourneyCustomMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Data != nil {
		ok := object.Key("Data")
		ok.String(*v.Data)
	}

	return nil
}

func awsRestjson1_serializeDocumentJourneyEmailMessage(v *types.JourneyEmailMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FromAddress != nil {
		ok := object.Key("FromAddress")
		ok.String(*v.FromAddress)
	}

	return nil
}

func awsRestjson1_serializeDocumentJourneyLimits(v *types.JourneyLimits, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DailyCap != 0 {
		ok := object.Key("DailyCap")
		ok.Integer(v.DailyCap)
	}

	if v.EndpointReentryCap != 0 {
		ok := object.Key("EndpointReentryCap")
		ok.Integer(v.EndpointReentryCap)
	}

	if v.EndpointReentryInterval != nil {
		ok := object.Key("EndpointReentryInterval")
		ok.String(*v.EndpointReentryInterval)
	}

	if v.MessagesPerSecond != 0 {
		ok := object.Key("MessagesPerSecond")
		ok.Integer(v.MessagesPerSecond)
	}

	return nil
}

func awsRestjson1_serializeDocumentJourneyPushMessage(v *types.JourneyPushMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TimeToLive != nil {
		ok := object.Key("TimeToLive")
		ok.String(*v.TimeToLive)
	}

	return nil
}

func awsRestjson1_serializeDocumentJourneySchedule(v *types.JourneySchedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		ok.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.String(smithytime.FormatDateTime(*v.StartTime))
	}

	if v.Timezone != nil {
		ok := object.Key("Timezone")
		ok.String(*v.Timezone)
	}

	return nil
}

func awsRestjson1_serializeDocumentJourneySMSMessage(v *types.JourneySMSMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityId != nil {
		ok := object.Key("EntityId")
		ok.String(*v.EntityId)
	}

	if len(v.MessageType) > 0 {
		ok := object.Key("MessageType")
		ok.String(string(v.MessageType))
	}

	if v.OriginationNumber != nil {
		ok := object.Key("OriginationNumber")
		ok.String(*v.OriginationNumber)
	}

	if v.SenderId != nil {
		ok := object.Key("SenderId")
		ok.String(*v.SenderId)
	}

	if v.TemplateId != nil {
		ok := object.Key("TemplateId")
		ok.String(*v.TemplateId)
	}

	return nil
}

func awsRestjson1_serializeDocumentJourneyStateRequest(v *types.JourneyStateRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.State) > 0 {
		ok := object.Key("State")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentListOf__EndpointTypesElement(v []types.EndpointTypesElement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentListOf__string(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfEndpointBatchItem(v []types.EndpointBatchItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEndpointBatchItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfInAppMessageContent(v []types.InAppMessageContent, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInAppMessageContent(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfMultiConditionalBranch(v []types.MultiConditionalBranch, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMultiConditionalBranch(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfRandomSplitEntry(v []types.RandomSplitEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRandomSplitEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfSegmentDimensions(v []types.SegmentDimensions, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSegmentDimensions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfSegmentGroup(v []types.SegmentGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSegmentGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfSegmentReference(v []types.SegmentReference, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSegmentReference(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfSimpleCondition(v []types.SimpleCondition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSimpleCondition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfWriteTreatmentResource(v []types.WriteTreatmentResource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentWriteTreatmentResource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapOf__double(v map[string]float64, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		switch {
		case math.IsNaN(v[key]):
			om.String("NaN")

		case math.IsInf(v[key], 1):
			om.String("Infinity")

		case math.IsInf(v[key], -1):
			om.String("-Infinity")

		default:
			om.Double(v[key])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapOf__string(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentMapOfActivity(v map[string]types.Activity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentActivity(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapOfAddressConfiguration(v map[string]types.AddressConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentAddressConfiguration(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapOfAttributeDimension(v map[string]types.AttributeDimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentAttributeDimension(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapOfEndpointSendConfiguration(v map[string]types.EndpointSendConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentEndpointSendConfiguration(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapOfEvent(v map[string]types.Event, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentEvent(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapOfEventsBatch(v map[string]types.EventsBatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentEventsBatch(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapOfListOf__string(v map[string][]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentListOf__string(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapOfMetricDimension(v map[string]types.MetricDimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentMetricDimension(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMessage(v *types.Message, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.ImageIconUrl != nil {
		ok := object.Key("ImageIconUrl")
		ok.String(*v.ImageIconUrl)
	}

	if v.ImageSmallIconUrl != nil {
		ok := object.Key("ImageSmallIconUrl")
		ok.String(*v.ImageSmallIconUrl)
	}

	if v.ImageUrl != nil {
		ok := object.Key("ImageUrl")
		ok.String(*v.ImageUrl)
	}

	if v.JsonBody != nil {
		ok := object.Key("JsonBody")
		ok.String(*v.JsonBody)
	}

	if v.MediaUrl != nil {
		ok := object.Key("MediaUrl")
		ok.String(*v.MediaUrl)
	}

	if v.RawContent != nil {
		ok := object.Key("RawContent")
		ok.String(*v.RawContent)
	}

	if v.SilentPush {
		ok := object.Key("SilentPush")
		ok.Boolean(v.SilentPush)
	}

	if v.TimeToLive != 0 {
		ok := object.Key("TimeToLive")
		ok.Integer(v.TimeToLive)
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentMessageConfiguration(v *types.MessageConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ADMMessage != nil {
		ok := object.Key("ADMMessage")
		if err := awsRestjson1_serializeDocumentMessage(v.ADMMessage, ok); err != nil {
			return err
		}
	}

	if v.APNSMessage != nil {
		ok := object.Key("APNSMessage")
		if err := awsRestjson1_serializeDocumentMessage(v.APNSMessage, ok); err != nil {
			return err
		}
	}

	if v.BaiduMessage != nil {
		ok := object.Key("BaiduMessage")
		if err := awsRestjson1_serializeDocumentMessage(v.BaiduMessage, ok); err != nil {
			return err
		}
	}

	if v.CustomMessage != nil {
		ok := object.Key("CustomMessage")
		if err := awsRestjson1_serializeDocumentCampaignCustomMessage(v.CustomMessage, ok); err != nil {
			return err
		}
	}

	if v.DefaultMessage != nil {
		ok := object.Key("DefaultMessage")
		if err := awsRestjson1_serializeDocumentMessage(v.DefaultMessage, ok); err != nil {
			return err
		}
	}

	if v.EmailMessage != nil {
		ok := object.Key("EmailMessage")
		if err := awsRestjson1_serializeDocumentCampaignEmailMessage(v.EmailMessage, ok); err != nil {
			return err
		}
	}

	if v.GCMMessage != nil {
		ok := object.Key("GCMMessage")
		if err := awsRestjson1_serializeDocumentMessage(v.GCMMessage, ok); err != nil {
			return err
		}
	}

	if v.InAppMessage != nil {
		ok := object.Key("InAppMessage")
		if err := awsRestjson1_serializeDocumentCampaignInAppMessage(v.InAppMessage, ok); err != nil {
			return err
		}
	}

	if v.SMSMessage != nil {
		ok := object.Key("SMSMessage")
		if err := awsRestjson1_serializeDocumentCampaignSmsMessage(v.SMSMessage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMessageRequest(v *types.MessageRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Addresses != nil {
		ok := object.Key("Addresses")
		if err := awsRestjson1_serializeDocumentMapOfAddressConfiguration(v.Addresses, ok); err != nil {
			return err
		}
	}

	if v.Context != nil {
		ok := object.Key("Context")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Context, ok); err != nil {
			return err
		}
	}

	if v.Endpoints != nil {
		ok := object.Key("Endpoints")
		if err := awsRestjson1_serializeDocumentMapOfEndpointSendConfiguration(v.Endpoints, ok); err != nil {
			return err
		}
	}

	if v.MessageConfiguration != nil {
		ok := object.Key("MessageConfiguration")
		if err := awsRestjson1_serializeDocumentDirectMessageConfiguration(v.MessageConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TemplateConfiguration != nil {
		ok := object.Key("TemplateConfiguration")
		if err := awsRestjson1_serializeDocumentTemplateConfiguration(v.TemplateConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TraceId != nil {
		ok := object.Key("TraceId")
		ok.String(*v.TraceId)
	}

	return nil
}

func awsRestjson1_serializeDocumentMetricDimension(v *types.MetricDimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComparisonOperator != nil {
		ok := object.Key("ComparisonOperator")
		ok.String(*v.ComparisonOperator)
	}

	{
		ok := object.Key("Value")
		switch {
		case math.IsNaN(v.Value):
			ok.String("NaN")

		case math.IsInf(v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiConditionalBranch(v *types.MultiConditionalBranch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Condition != nil {
		ok := object.Key("Condition")
		if err := awsRestjson1_serializeDocumentSimpleCondition(v.Condition, ok); err != nil {
			return err
		}
	}

	if v.NextActivity != nil {
		ok := object.Key("NextActivity")
		ok.String(*v.NextActivity)
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiConditionalSplitActivity(v *types.MultiConditionalSplitActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Branches != nil {
		ok := object.Key("Branches")
		if err := awsRestjson1_serializeDocumentListOfMultiConditionalBranch(v.Branches, ok); err != nil {
			return err
		}
	}

	if v.DefaultActivity != nil {
		ok := object.Key("DefaultActivity")
		ok.String(*v.DefaultActivity)
	}

	if v.EvaluationWaitTime != nil {
		ok := object.Key("EvaluationWaitTime")
		if err := awsRestjson1_serializeDocumentWaitTime(v.EvaluationWaitTime, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNumberValidateRequest(v *types.NumberValidateRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IsoCountryCode != nil {
		ok := object.Key("IsoCountryCode")
		ok.String(*v.IsoCountryCode)
	}

	if v.PhoneNumber != nil {
		ok := object.Key("PhoneNumber")
		ok.String(*v.PhoneNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentOverrideButtonConfiguration(v *types.OverrideButtonConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ButtonAction) > 0 {
		ok := object.Key("ButtonAction")
		ok.String(string(v.ButtonAction))
	}

	if v.Link != nil {
		ok := object.Key("Link")
		ok.String(*v.Link)
	}

	return nil
}

func awsRestjson1_serializeDocumentPublicEndpoint(v *types.PublicEndpoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Address != nil {
		ok := object.Key("Address")
		ok.String(*v.Address)
	}

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Attributes, ok); err != nil {
			return err
		}
	}

	if len(v.ChannelType) > 0 {
		ok := object.Key("ChannelType")
		ok.String(string(v.ChannelType))
	}

	if v.Demographic != nil {
		ok := object.Key("Demographic")
		if err := awsRestjson1_serializeDocumentEndpointDemographic(v.Demographic, ok); err != nil {
			return err
		}
	}

	if v.EffectiveDate != nil {
		ok := object.Key("EffectiveDate")
		ok.String(*v.EffectiveDate)
	}

	if v.EndpointStatus != nil {
		ok := object.Key("EndpointStatus")
		ok.String(*v.EndpointStatus)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		if err := awsRestjson1_serializeDocumentEndpointLocation(v.Location, ok); err != nil {
			return err
		}
	}

	if v.Metrics != nil {
		ok := object.Key("Metrics")
		if err := awsRestjson1_serializeDocumentMapOf__double(v.Metrics, ok); err != nil {
			return err
		}
	}

	if v.OptOut != nil {
		ok := object.Key("OptOut")
		ok.String(*v.OptOut)
	}

	if v.RequestId != nil {
		ok := object.Key("RequestId")
		ok.String(*v.RequestId)
	}

	if v.User != nil {
		ok := object.Key("User")
		if err := awsRestjson1_serializeDocumentEndpointUser(v.User, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPushMessageActivity(v *types.PushMessageActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MessageConfig != nil {
		ok := object.Key("MessageConfig")
		if err := awsRestjson1_serializeDocumentJourneyPushMessage(v.MessageConfig, ok); err != nil {
			return err
		}
	}

	if v.NextActivity != nil {
		ok := object.Key("NextActivity")
		ok.String(*v.NextActivity)
	}

	if v.TemplateName != nil {
		ok := object.Key("TemplateName")
		ok.String(*v.TemplateName)
	}

	if v.TemplateVersion != nil {
		ok := object.Key("TemplateVersion")
		ok.String(*v.TemplateVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentPushNotificationTemplateRequest(v *types.PushNotificationTemplateRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ADM != nil {
		ok := object.Key("ADM")
		if err := awsRestjson1_serializeDocumentAndroidPushNotificationTemplate(v.ADM, ok); err != nil {
			return err
		}
	}

	if v.APNS != nil {
		ok := object.Key("APNS")
		if err := awsRestjson1_serializeDocumentAPNSPushNotificationTemplate(v.APNS, ok); err != nil {
			return err
		}
	}

	if v.Baidu != nil {
		ok := object.Key("Baidu")
		if err := awsRestjson1_serializeDocumentAndroidPushNotificationTemplate(v.Baidu, ok); err != nil {
			return err
		}
	}

	if v.Default != nil {
		ok := object.Key("Default")
		if err := awsRestjson1_serializeDocumentDefaultPushNotificationTemplate(v.Default, ok); err != nil {
			return err
		}
	}

	if v.DefaultSubstitutions != nil {
		ok := object.Key("DefaultSubstitutions")
		ok.String(*v.DefaultSubstitutions)
	}

	if v.GCM != nil {
		ok := object.Key("GCM")
		if err := awsRestjson1_serializeDocumentAndroidPushNotificationTemplate(v.GCM, ok); err != nil {
			return err
		}
	}

	if v.RecommenderId != nil {
		ok := object.Key("RecommenderId")
		ok.String(*v.RecommenderId)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TemplateDescription != nil {
		ok := object.Key("TemplateDescription")
		ok.String(*v.TemplateDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentQuietTime(v *types.QuietTime, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.End != nil {
		ok := object.Key("End")
		ok.String(*v.End)
	}

	if v.Start != nil {
		ok := object.Key("Start")
		ok.String(*v.Start)
	}

	return nil
}

func awsRestjson1_serializeDocumentRandomSplitActivity(v *types.RandomSplitActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Branches != nil {
		ok := object.Key("Branches")
		if err := awsRestjson1_serializeDocumentListOfRandomSplitEntry(v.Branches, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRandomSplitEntry(v *types.RandomSplitEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NextActivity != nil {
		ok := object.Key("NextActivity")
		ok.String(*v.NextActivity)
	}

	if v.Percentage != 0 {
		ok := object.Key("Percentage")
		ok.Integer(v.Percentage)
	}

	return nil
}

func awsRestjson1_serializeDocumentRawEmail(v *types.RawEmail, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Data != nil {
		ok := object.Key("Data")
		ok.Base64EncodeBytes(v.Data)
	}

	return nil
}

func awsRestjson1_serializeDocumentRecencyDimension(v *types.RecencyDimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Duration) > 0 {
		ok := object.Key("Duration")
		ok.String(string(v.Duration))
	}

	if len(v.RecencyType) > 0 {
		ok := object.Key("RecencyType")
		ok.String(string(v.RecencyType))
	}

	return nil
}

func awsRestjson1_serializeDocumentSchedule(v *types.Schedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		ok.String(*v.EndTime)
	}

	if v.EventFilter != nil {
		ok := object.Key("EventFilter")
		if err := awsRestjson1_serializeDocumentCampaignEventFilter(v.EventFilter, ok); err != nil {
			return err
		}
	}

	if len(v.Frequency) > 0 {
		ok := object.Key("Frequency")
		ok.String(string(v.Frequency))
	}

	if v.IsLocalTime {
		ok := object.Key("IsLocalTime")
		ok.Boolean(v.IsLocalTime)
	}

	if v.QuietTime != nil {
		ok := object.Key("QuietTime")
		if err := awsRestjson1_serializeDocumentQuietTime(v.QuietTime, ok); err != nil {
			return err
		}
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.String(*v.StartTime)
	}

	if v.Timezone != nil {
		ok := object.Key("Timezone")
		ok.String(*v.Timezone)
	}

	return nil
}

func awsRestjson1_serializeDocumentSegmentBehaviors(v *types.SegmentBehaviors, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Recency != nil {
		ok := object.Key("Recency")
		if err := awsRestjson1_serializeDocumentRecencyDimension(v.Recency, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSegmentCondition(v *types.SegmentCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SegmentId != nil {
		ok := object.Key("SegmentId")
		ok.String(*v.SegmentId)
	}

	return nil
}

func awsRestjson1_serializeDocumentSegmentDemographics(v *types.SegmentDemographics, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppVersion != nil {
		ok := object.Key("AppVersion")
		if err := awsRestjson1_serializeDocumentSetDimension(v.AppVersion, ok); err != nil {
			return err
		}
	}

	if v.Channel != nil {
		ok := object.Key("Channel")
		if err := awsRestjson1_serializeDocumentSetDimension(v.Channel, ok); err != nil {
			return err
		}
	}

	if v.DeviceType != nil {
		ok := object.Key("DeviceType")
		if err := awsRestjson1_serializeDocumentSetDimension(v.DeviceType, ok); err != nil {
			return err
		}
	}

	if v.Make != nil {
		ok := object.Key("Make")
		if err := awsRestjson1_serializeDocumentSetDimension(v.Make, ok); err != nil {
			return err
		}
	}

	if v.Model != nil {
		ok := object.Key("Model")
		if err := awsRestjson1_serializeDocumentSetDimension(v.Model, ok); err != nil {
			return err
		}
	}

	if v.Platform != nil {
		ok := object.Key("Platform")
		if err := awsRestjson1_serializeDocumentSetDimension(v.Platform, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSegmentDimensions(v *types.SegmentDimensions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentMapOfAttributeDimension(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Behavior != nil {
		ok := object.Key("Behavior")
		if err := awsRestjson1_serializeDocumentSegmentBehaviors(v.Behavior, ok); err != nil {
			return err
		}
	}

	if v.Demographic != nil {
		ok := object.Key("Demographic")
		if err := awsRestjson1_serializeDocumentSegmentDemographics(v.Demographic, ok); err != nil {
			return err
		}
	}

	if v.Location != nil {
		ok := object.Key("Location")
		if err := awsRestjson1_serializeDocumentSegmentLocation(v.Location, ok); err != nil {
			return err
		}
	}

	if v.Metrics != nil {
		ok := object.Key("Metrics")
		if err := awsRestjson1_serializeDocumentMapOfMetricDimension(v.Metrics, ok); err != nil {
			return err
		}
	}

	if v.UserAttributes != nil {
		ok := object.Key("UserAttributes")
		if err := awsRestjson1_serializeDocumentMapOfAttributeDimension(v.UserAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSegmentGroup(v *types.SegmentGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dimensions != nil {
		ok := object.Key("Dimensions")
		if err := awsRestjson1_serializeDocumentListOfSegmentDimensions(v.Dimensions, ok); err != nil {
			return err
		}
	}

	if v.SourceSegments != nil {
		ok := object.Key("SourceSegments")
		if err := awsRestjson1_serializeDocumentListOfSegmentReference(v.SourceSegments, ok); err != nil {
			return err
		}
	}

	if len(v.SourceType) > 0 {
		ok := object.Key("SourceType")
		ok.String(string(v.SourceType))
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentSegmentGroupList(v *types.SegmentGroupList, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Groups != nil {
		ok := object.Key("Groups")
		if err := awsRestjson1_serializeDocumentListOfSegmentGroup(v.Groups, ok); err != nil {
			return err
		}
	}

	if len(v.Include) > 0 {
		ok := object.Key("Include")
		ok.String(string(v.Include))
	}

	return nil
}

func awsRestjson1_serializeDocumentSegmentLocation(v *types.SegmentLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Country != nil {
		ok := object.Key("Country")
		if err := awsRestjson1_serializeDocumentSetDimension(v.Country, ok); err != nil {
			return err
		}
	}

	if v.GPSPoint != nil {
		ok := object.Key("GPSPoint")
		if err := awsRestjson1_serializeDocumentGPSPointDimension(v.GPSPoint, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSegmentReference(v *types.SegmentReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Version != 0 {
		ok := object.Key("Version")
		ok.Integer(v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentSendUsersMessageRequest(v *types.SendUsersMessageRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Context != nil {
		ok := object.Key("Context")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Context, ok); err != nil {
			return err
		}
	}

	if v.MessageConfiguration != nil {
		ok := object.Key("MessageConfiguration")
		if err := awsRestjson1_serializeDocumentDirectMessageConfiguration(v.MessageConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TemplateConfiguration != nil {
		ok := object.Key("TemplateConfiguration")
		if err := awsRestjson1_serializeDocumentTemplateConfiguration(v.TemplateConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TraceId != nil {
		ok := object.Key("TraceId")
		ok.String(*v.TraceId)
	}

	if v.Users != nil {
		ok := object.Key("Users")
		if err := awsRestjson1_serializeDocumentMapOfEndpointSendConfiguration(v.Users, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSession(v *types.Session, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Duration != 0 {
		ok := object.Key("Duration")
		ok.Integer(v.Duration)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.StartTimestamp != nil {
		ok := object.Key("StartTimestamp")
		ok.String(*v.StartTimestamp)
	}

	if v.StopTimestamp != nil {
		ok := object.Key("StopTimestamp")
		ok.String(*v.StopTimestamp)
	}

	return nil
}

func awsRestjson1_serializeDocumentSetDimension(v *types.SetDimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DimensionType) > 0 {
		ok := object.Key("DimensionType")
		ok.String(string(v.DimensionType))
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentListOf__string(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSimpleCondition(v *types.SimpleCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventCondition != nil {
		ok := object.Key("EventCondition")
		if err := awsRestjson1_serializeDocumentEventCondition(v.EventCondition, ok); err != nil {
			return err
		}
	}

	if v.SegmentCondition != nil {
		ok := object.Key("SegmentCondition")
		if err := awsRestjson1_serializeDocumentSegmentCondition(v.SegmentCondition, ok); err != nil {
			return err
		}
	}

	if v.SegmentDimensions != nil {
		ok := object.Key("segmentDimensions")
		if err := awsRestjson1_serializeDocumentSegmentDimensions(v.SegmentDimensions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSimpleEmail(v *types.SimpleEmail, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HtmlPart != nil {
		ok := object.Key("HtmlPart")
		if err := awsRestjson1_serializeDocumentSimpleEmailPart(v.HtmlPart, ok); err != nil {
			return err
		}
	}

	if v.Subject != nil {
		ok := object.Key("Subject")
		if err := awsRestjson1_serializeDocumentSimpleEmailPart(v.Subject, ok); err != nil {
			return err
		}
	}

	if v.TextPart != nil {
		ok := object.Key("TextPart")
		if err := awsRestjson1_serializeDocumentSimpleEmailPart(v.TextPart, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSimpleEmailPart(v *types.SimpleEmailPart, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Charset != nil {
		ok := object.Key("Charset")
		ok.String(*v.Charset)
	}

	if v.Data != nil {
		ok := object.Key("Data")
		ok.String(*v.Data)
	}

	return nil
}

func awsRestjson1_serializeDocumentSMSChannelRequest(v *types.SMSChannelRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.SenderId != nil {
		ok := object.Key("SenderId")
		ok.String(*v.SenderId)
	}

	if v.ShortCode != nil {
		ok := object.Key("ShortCode")
		ok.String(*v.ShortCode)
	}

	return nil
}

func awsRestjson1_serializeDocumentSMSMessage(v *types.SMSMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.EntityId != nil {
		ok := object.Key("EntityId")
		ok.String(*v.EntityId)
	}

	if v.Keyword != nil {
		ok := object.Key("Keyword")
		ok.String(*v.Keyword)
	}

	if v.MediaUrl != nil {
		ok := object.Key("MediaUrl")
		ok.String(*v.MediaUrl)
	}

	if len(v.MessageType) > 0 {
		ok := object.Key("MessageType")
		ok.String(string(v.MessageType))
	}

	if v.OriginationNumber != nil {
		ok := object.Key("OriginationNumber")
		ok.String(*v.OriginationNumber)
	}

	if v.SenderId != nil {
		ok := object.Key("SenderId")
		ok.String(*v.SenderId)
	}

	if v.Substitutions != nil {
		ok := object.Key("Substitutions")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Substitutions, ok); err != nil {
			return err
		}
	}

	if v.TemplateId != nil {
		ok := object.Key("TemplateId")
		ok.String(*v.TemplateId)
	}

	return nil
}

func awsRestjson1_serializeDocumentSMSMessageActivity(v *types.SMSMessageActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MessageConfig != nil {
		ok := object.Key("MessageConfig")
		if err := awsRestjson1_serializeDocumentJourneySMSMessage(v.MessageConfig, ok); err != nil {
			return err
		}
	}

	if v.NextActivity != nil {
		ok := object.Key("NextActivity")
		ok.String(*v.NextActivity)
	}

	if v.TemplateName != nil {
		ok := object.Key("TemplateName")
		ok.String(*v.TemplateName)
	}

	if v.TemplateVersion != nil {
		ok := object.Key("TemplateVersion")
		ok.String(*v.TemplateVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentSMSTemplateRequest(v *types.SMSTemplateRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.DefaultSubstitutions != nil {
		ok := object.Key("DefaultSubstitutions")
		ok.String(*v.DefaultSubstitutions)
	}

	if v.RecommenderId != nil {
		ok := object.Key("RecommenderId")
		ok.String(*v.RecommenderId)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TemplateDescription != nil {
		ok := object.Key("TemplateDescription")
		ok.String(*v.TemplateDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentStartCondition(v *types.StartCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EventStartCondition != nil {
		ok := object.Key("EventStartCondition")
		if err := awsRestjson1_serializeDocumentEventStartCondition(v.EventStartCondition, ok); err != nil {
			return err
		}
	}

	if v.SegmentStartCondition != nil {
		ok := object.Key("SegmentStartCondition")
		if err := awsRestjson1_serializeDocumentSegmentCondition(v.SegmentStartCondition, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTagsModel(v *types.TagsModel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTemplate(v *types.Template, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentTemplateActiveVersionRequest(v *types.TemplateActiveVersionRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentTemplateConfiguration(v *types.TemplateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EmailTemplate != nil {
		ok := object.Key("EmailTemplate")
		if err := awsRestjson1_serializeDocumentTemplate(v.EmailTemplate, ok); err != nil {
			return err
		}
	}

	if v.PushTemplate != nil {
		ok := object.Key("PushTemplate")
		if err := awsRestjson1_serializeDocumentTemplate(v.PushTemplate, ok); err != nil {
			return err
		}
	}

	if v.SMSTemplate != nil {
		ok := object.Key("SMSTemplate")
		if err := awsRestjson1_serializeDocumentTemplate(v.SMSTemplate, ok); err != nil {
			return err
		}
	}

	if v.VoiceTemplate != nil {
		ok := object.Key("VoiceTemplate")
		if err := awsRestjson1_serializeDocumentTemplate(v.VoiceTemplate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateAttributesRequest(v *types.UpdateAttributesRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Blacklist != nil {
		ok := object.Key("Blacklist")
		if err := awsRestjson1_serializeDocumentListOf__string(v.Blacklist, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateRecommenderConfigurationShape(v *types.UpdateRecommenderConfigurationShape, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RecommendationProviderIdType != nil {
		ok := object.Key("RecommendationProviderIdType")
		ok.String(*v.RecommendationProviderIdType)
	}

	if v.RecommendationProviderRoleArn != nil {
		ok := object.Key("RecommendationProviderRoleArn")
		ok.String(*v.RecommendationProviderRoleArn)
	}

	if v.RecommendationProviderUri != nil {
		ok := object.Key("RecommendationProviderUri")
		ok.String(*v.RecommendationProviderUri)
	}

	if v.RecommendationsDisplayName != nil {
		ok := object.Key("RecommendationsDisplayName")
		ok.String(*v.RecommendationsDisplayName)
	}

	if v.RecommendationsPerMessage != 0 {
		ok := object.Key("RecommendationsPerMessage")
		ok.Integer(v.RecommendationsPerMessage)
	}

	if v.RecommendationTransformerUri != nil {
		ok := object.Key("RecommendationTransformerUri")
		ok.String(*v.RecommendationTransformerUri)
	}

	return nil
}

func awsRestjson1_serializeDocumentVoiceChannelRequest(v *types.VoiceChannelRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentVoiceMessage(v *types.VoiceMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.LanguageCode != nil {
		ok := object.Key("LanguageCode")
		ok.String(*v.LanguageCode)
	}

	if v.OriginationNumber != nil {
		ok := object.Key("OriginationNumber")
		ok.String(*v.OriginationNumber)
	}

	if v.Substitutions != nil {
		ok := object.Key("Substitutions")
		if err := awsRestjson1_serializeDocumentMapOfListOf__string(v.Substitutions, ok); err != nil {
			return err
		}
	}

	if v.VoiceId != nil {
		ok := object.Key("VoiceId")
		ok.String(*v.VoiceId)
	}

	return nil
}

func awsRestjson1_serializeDocumentVoiceTemplateRequest(v *types.VoiceTemplateRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("Body")
		ok.String(*v.Body)
	}

	if v.DefaultSubstitutions != nil {
		ok := object.Key("DefaultSubstitutions")
		ok.String(*v.DefaultSubstitutions)
	}

	if v.LanguageCode != nil {
		ok := object.Key("LanguageCode")
		ok.String(*v.LanguageCode)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TemplateDescription != nil {
		ok := object.Key("TemplateDescription")
		ok.String(*v.TemplateDescription)
	}

	if v.VoiceId != nil {
		ok := object.Key("VoiceId")
		ok.String(*v.VoiceId)
	}

	return nil
}

func awsRestjson1_serializeDocumentWaitActivity(v *types.WaitActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NextActivity != nil {
		ok := object.Key("NextActivity")
		ok.String(*v.NextActivity)
	}

	if v.WaitTime != nil {
		ok := object.Key("WaitTime")
		if err := awsRestjson1_serializeDocumentWaitTime(v.WaitTime, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWaitTime(v *types.WaitTime, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WaitFor != nil {
		ok := object.Key("WaitFor")
		ok.String(*v.WaitFor)
	}

	if v.WaitUntil != nil {
		ok := object.Key("WaitUntil")
		ok.String(*v.WaitUntil)
	}

	return nil
}

func awsRestjson1_serializeDocumentWriteApplicationSettingsRequest(v *types.WriteApplicationSettingsRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CampaignHook != nil {
		ok := object.Key("CampaignHook")
		if err := awsRestjson1_serializeDocumentCampaignHook(v.CampaignHook, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchMetricsEnabled {
		ok := object.Key("CloudWatchMetricsEnabled")
		ok.Boolean(v.CloudWatchMetricsEnabled)
	}

	if v.EventTaggingEnabled {
		ok := object.Key("EventTaggingEnabled")
		ok.Boolean(v.EventTaggingEnabled)
	}

	if v.Limits != nil {
		ok := object.Key("Limits")
		if err := awsRestjson1_serializeDocumentCampaignLimits(v.Limits, ok); err != nil {
			return err
		}
	}

	if v.QuietTime != nil {
		ok := object.Key("QuietTime")
		if err := awsRestjson1_serializeDocumentQuietTime(v.QuietTime, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWriteCampaignRequest(v *types.WriteCampaignRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalTreatments != nil {
		ok := object.Key("AdditionalTreatments")
		if err := awsRestjson1_serializeDocumentListOfWriteTreatmentResource(v.AdditionalTreatments, ok); err != nil {
			return err
		}
	}

	if v.CustomDeliveryConfiguration != nil {
		ok := object.Key("CustomDeliveryConfiguration")
		if err := awsRestjson1_serializeDocumentCustomDeliveryConfiguration(v.CustomDeliveryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.HoldoutPercent != 0 {
		ok := object.Key("HoldoutPercent")
		ok.Integer(v.HoldoutPercent)
	}

	if v.Hook != nil {
		ok := object.Key("Hook")
		if err := awsRestjson1_serializeDocumentCampaignHook(v.Hook, ok); err != nil {
			return err
		}
	}

	if v.IsPaused {
		ok := object.Key("IsPaused")
		ok.Boolean(v.IsPaused)
	}

	if v.Limits != nil {
		ok := object.Key("Limits")
		if err := awsRestjson1_serializeDocumentCampaignLimits(v.Limits, ok); err != nil {
			return err
		}
	}

	if v.MessageConfiguration != nil {
		ok := object.Key("MessageConfiguration")
		if err := awsRestjson1_serializeDocumentMessageConfiguration(v.MessageConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Priority != 0 {
		ok := object.Key("Priority")
		ok.Integer(v.Priority)
	}

	if v.Schedule != nil {
		ok := object.Key("Schedule")
		if err := awsRestjson1_serializeDocumentSchedule(v.Schedule, ok); err != nil {
			return err
		}
	}

	if v.SegmentId != nil {
		ok := object.Key("SegmentId")
		ok.String(*v.SegmentId)
	}

	if v.SegmentVersion != 0 {
		ok := object.Key("SegmentVersion")
		ok.Integer(v.SegmentVersion)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TemplateConfiguration != nil {
		ok := object.Key("TemplateConfiguration")
		if err := awsRestjson1_serializeDocumentTemplateConfiguration(v.TemplateConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TreatmentDescription != nil {
		ok := object.Key("TreatmentDescription")
		ok.String(*v.TreatmentDescription)
	}

	if v.TreatmentName != nil {
		ok := object.Key("TreatmentName")
		ok.String(*v.TreatmentName)
	}

	return nil
}

func awsRestjson1_serializeDocumentWriteEventStream(v *types.WriteEventStream, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationStreamArn != nil {
		ok := object.Key("DestinationStreamArn")
		ok.String(*v.DestinationStreamArn)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentWriteJourneyRequest(v *types.WriteJourneyRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Activities != nil {
		ok := object.Key("Activities")
		if err := awsRestjson1_serializeDocumentMapOfActivity(v.Activities, ok); err != nil {
			return err
		}
	}

	if v.CreationDate != nil {
		ok := object.Key("CreationDate")
		ok.String(*v.CreationDate)
	}

	if v.LastModifiedDate != nil {
		ok := object.Key("LastModifiedDate")
		ok.String(*v.LastModifiedDate)
	}

	if v.Limits != nil {
		ok := object.Key("Limits")
		if err := awsRestjson1_serializeDocumentJourneyLimits(v.Limits, ok); err != nil {
			return err
		}
	}

	if v.LocalTime {
		ok := object.Key("LocalTime")
		ok.Boolean(v.LocalTime)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.QuietTime != nil {
		ok := object.Key("QuietTime")
		if err := awsRestjson1_serializeDocumentQuietTime(v.QuietTime, ok); err != nil {
			return err
		}
	}

	if v.RefreshFrequency != nil {
		ok := object.Key("RefreshFrequency")
		ok.String(*v.RefreshFrequency)
	}

	if v.RefreshOnSegmentUpdate {
		ok := object.Key("RefreshOnSegmentUpdate")
		ok.Boolean(v.RefreshOnSegmentUpdate)
	}

	if v.Schedule != nil {
		ok := object.Key("Schedule")
		if err := awsRestjson1_serializeDocumentJourneySchedule(v.Schedule, ok); err != nil {
			return err
		}
	}

	if v.StartActivity != nil {
		ok := object.Key("StartActivity")
		ok.String(*v.StartActivity)
	}

	if v.StartCondition != nil {
		ok := object.Key("StartCondition")
		if err := awsRestjson1_serializeDocumentStartCondition(v.StartCondition, ok); err != nil {
			return err
		}
	}

	if len(v.State) > 0 {
		ok := object.Key("State")
		ok.String(string(v.State))
	}

	if v.WaitForQuietTime {
		ok := object.Key("WaitForQuietTime")
		ok.Boolean(v.WaitForQuietTime)
	}

	return nil
}

func awsRestjson1_serializeDocumentWriteSegmentRequest(v *types.WriteSegmentRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dimensions != nil {
		ok := object.Key("Dimensions")
		if err := awsRestjson1_serializeDocumentSegmentDimensions(v.Dimensions, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SegmentGroups != nil {
		ok := object.Key("SegmentGroups")
		if err := awsRestjson1_serializeDocumentSegmentGroupList(v.SegmentGroups, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentMapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWriteTreatmentResource(v *types.WriteTreatmentResource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomDeliveryConfiguration != nil {
		ok := object.Key("CustomDeliveryConfiguration")
		if err := awsRestjson1_serializeDocumentCustomDeliveryConfiguration(v.CustomDeliveryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MessageConfiguration != nil {
		ok := object.Key("MessageConfiguration")
		if err := awsRestjson1_serializeDocumentMessageConfiguration(v.MessageConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Schedule != nil {
		ok := object.Key("Schedule")
		if err := awsRestjson1_serializeDocumentSchedule(v.Schedule, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("SizePercent")
		ok.Integer(v.SizePercent)
	}

	if v.TemplateConfiguration != nil {
		ok := object.Key("TemplateConfiguration")
		if err := awsRestjson1_serializeDocumentTemplateConfiguration(v.TemplateConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TreatmentDescription != nil {
		ok := object.Key("TreatmentDescription")
		ok.String(*v.TreatmentDescription)
	}

	if v.TreatmentName != nil {
		ok := object.Key("TreatmentName")
		ok.String(*v.TreatmentName)
	}

	return nil
}
