// Code generated by smithy-go-codegen DO NOT EDIT.

package opensearch

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/opensearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the cluster configuration of the specified domain, such as setting the
// instance type and the number of instances.
func (c *Client) UpdateDomainConfig(ctx context.Context, params *UpdateDomainConfigInput, optFns ...func(*Options)) (*UpdateDomainConfigOutput, error) {
	if params == nil {
		params = &UpdateDomainConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDomainConfig", params, optFns, c.addOperationUpdateDomainConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDomainConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Container for the parameters to the UpdateDomain operation. Specifies the type
// and number of instances in the domain cluster.
type UpdateDomainConfigInput struct {

	// The name of the domain you're updating.
	//
	// This member is required.
	DomainName *string

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string

	// Modifies the advanced option to allow references to indices in an HTTP request
	// body. Must be false when configuring access to individual sub-resources. By
	// default, the value is true. See Advanced options
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]string

	// Specifies advanced security options.
	AdvancedSecurityOptions *types.AdvancedSecurityOptionsInput

	// Specifies Auto-Tune options.
	AutoTuneOptions *types.AutoTuneOptions

	// The type and number of instances to instantiate for the domain cluster.
	ClusterConfig *types.ClusterConfig

	// Options to specify the Cognito user and identity pools for OpenSearch Dashboards
	// authentication. For more information, see Configuring Amazon Cognito
	// authentication for OpenSearch Dashboards
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
	CognitoOptions *types.CognitoOptions

	// Options to specify configuration that will be applied to the domain endpoint.
	DomainEndpointOptions *types.DomainEndpointOptions

	// Specify the type and size of the EBS volume to use.
	EBSOptions *types.EBSOptions

	// Specifies encryption of data at rest options.
	EncryptionAtRestOptions *types.EncryptionAtRestOptions

	// Map of LogType and LogPublishingOption, each containing options to publish a
	// given type of OpenSearch log.
	LogPublishingOptions map[string]types.LogPublishingOption

	// Specifies node-to-node encryption options.
	NodeToNodeEncryptionOptions *types.NodeToNodeEncryptionOptions

	// Option to set the time, in UTC format, for the daily automated snapshot. Default
	// value is 0 hours.
	SnapshotOptions *types.SnapshotOptions

	// Options to specify the subnets and security groups for the VPC endpoint. For
	// more information, see Launching your Amazon OpenSearch Service domains using a
	// VPC
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
	VPCOptions *types.VPCOptions

	noSmithyDocumentSerde
}

// The result of an UpdateDomain request. Contains the status of the domain being
// updated.
type UpdateDomainConfigOutput struct {

	// The status of the updated domain.
	//
	// This member is required.
	DomainConfig *types.DomainConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDomainConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateDomainConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateDomainConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateDomainConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDomainConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDomainConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "es",
		OperationName: "UpdateDomainConfig",
	}
}
