// Code generated by smithy-go-codegen DO NOT EDIT.

package migrationhub

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/migrationhub/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsAwsjson11_serializeOpAssociateCreatedArtifact struct {
}

func (*awsAwsjson11_serializeOpAssociateCreatedArtifact) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAssociateCreatedArtifact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateCreatedArtifactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.AssociateCreatedArtifact")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAssociateCreatedArtifactInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAssociateDiscoveredResource struct {
}

func (*awsAwsjson11_serializeOpAssociateDiscoveredResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAssociateDiscoveredResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateDiscoveredResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.AssociateDiscoveredResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAssociateDiscoveredResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateProgressUpdateStream struct {
}

func (*awsAwsjson11_serializeOpCreateProgressUpdateStream) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateProgressUpdateStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateProgressUpdateStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.CreateProgressUpdateStream")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateProgressUpdateStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteProgressUpdateStream struct {
}

func (*awsAwsjson11_serializeOpDeleteProgressUpdateStream) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteProgressUpdateStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProgressUpdateStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.DeleteProgressUpdateStream")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteProgressUpdateStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeApplicationState struct {
}

func (*awsAwsjson11_serializeOpDescribeApplicationState) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeApplicationState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeApplicationStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.DescribeApplicationState")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeApplicationStateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeMigrationTask struct {
}

func (*awsAwsjson11_serializeOpDescribeMigrationTask) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeMigrationTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMigrationTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.DescribeMigrationTask")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeMigrationTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDisassociateCreatedArtifact struct {
}

func (*awsAwsjson11_serializeOpDisassociateCreatedArtifact) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDisassociateCreatedArtifact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateCreatedArtifactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.DisassociateCreatedArtifact")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDisassociateCreatedArtifactInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDisassociateDiscoveredResource struct {
}

func (*awsAwsjson11_serializeOpDisassociateDiscoveredResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDisassociateDiscoveredResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateDiscoveredResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.DisassociateDiscoveredResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDisassociateDiscoveredResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpImportMigrationTask struct {
}

func (*awsAwsjson11_serializeOpImportMigrationTask) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpImportMigrationTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportMigrationTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.ImportMigrationTask")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentImportMigrationTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListApplicationStates struct {
}

func (*awsAwsjson11_serializeOpListApplicationStates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListApplicationStates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApplicationStatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.ListApplicationStates")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListApplicationStatesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListCreatedArtifacts struct {
}

func (*awsAwsjson11_serializeOpListCreatedArtifacts) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListCreatedArtifacts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCreatedArtifactsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.ListCreatedArtifacts")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListCreatedArtifactsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListDiscoveredResources struct {
}

func (*awsAwsjson11_serializeOpListDiscoveredResources) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListDiscoveredResources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDiscoveredResourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.ListDiscoveredResources")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListDiscoveredResourcesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListMigrationTasks struct {
}

func (*awsAwsjson11_serializeOpListMigrationTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListMigrationTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMigrationTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.ListMigrationTasks")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListMigrationTasksInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListProgressUpdateStreams struct {
}

func (*awsAwsjson11_serializeOpListProgressUpdateStreams) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListProgressUpdateStreams) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProgressUpdateStreamsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.ListProgressUpdateStreams")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListProgressUpdateStreamsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpNotifyApplicationState struct {
}

func (*awsAwsjson11_serializeOpNotifyApplicationState) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpNotifyApplicationState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NotifyApplicationStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.NotifyApplicationState")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentNotifyApplicationStateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpNotifyMigrationTaskState struct {
}

func (*awsAwsjson11_serializeOpNotifyMigrationTaskState) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpNotifyMigrationTaskState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NotifyMigrationTaskStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.NotifyMigrationTaskState")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentNotifyMigrationTaskStateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutResourceAttributes struct {
}

func (*awsAwsjson11_serializeOpPutResourceAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutResourceAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutResourceAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSMigrationHub.PutResourceAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutResourceAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentApplicationIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCreatedArtifact(v *types.CreatedArtifact, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDiscoveredResource(v *types.DiscoveredResource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationId != nil {
		ok := object.Key("ConfigurationId")
		ok.String(*v.ConfigurationId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	return nil
}

func awsAwsjson11_serializeDocumentResourceAttribute(v *types.ResourceAttribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentResourceAttributeList(v []types.ResourceAttribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentResourceAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTask(v *types.Task, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProgressPercent != nil {
		ok := object.Key("ProgressPercent")
		ok.Integer(*v.ProgressPercent)
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if v.StatusDetail != nil {
		ok := object.Key("StatusDetail")
		ok.String(*v.StatusDetail)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAssociateCreatedArtifactInput(v *AssociateCreatedArtifactInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CreatedArtifact != nil {
		ok := object.Key("CreatedArtifact")
		if err := awsAwsjson11_serializeDocumentCreatedArtifact(v.CreatedArtifact, ok); err != nil {
			return err
		}
	}

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.MigrationTaskName != nil {
		ok := object.Key("MigrationTaskName")
		ok.String(*v.MigrationTaskName)
	}

	if v.ProgressUpdateStream != nil {
		ok := object.Key("ProgressUpdateStream")
		ok.String(*v.ProgressUpdateStream)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAssociateDiscoveredResourceInput(v *AssociateDiscoveredResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DiscoveredResource != nil {
		ok := object.Key("DiscoveredResource")
		if err := awsAwsjson11_serializeDocumentDiscoveredResource(v.DiscoveredResource, ok); err != nil {
			return err
		}
	}

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.MigrationTaskName != nil {
		ok := object.Key("MigrationTaskName")
		ok.String(*v.MigrationTaskName)
	}

	if v.ProgressUpdateStream != nil {
		ok := object.Key("ProgressUpdateStream")
		ok.String(*v.ProgressUpdateStream)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateProgressUpdateStreamInput(v *CreateProgressUpdateStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.ProgressUpdateStreamName != nil {
		ok := object.Key("ProgressUpdateStreamName")
		ok.String(*v.ProgressUpdateStreamName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteProgressUpdateStreamInput(v *DeleteProgressUpdateStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.ProgressUpdateStreamName != nil {
		ok := object.Key("ProgressUpdateStreamName")
		ok.String(*v.ProgressUpdateStreamName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeApplicationStateInput(v *DescribeApplicationStateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationId != nil {
		ok := object.Key("ApplicationId")
		ok.String(*v.ApplicationId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeMigrationTaskInput(v *DescribeMigrationTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MigrationTaskName != nil {
		ok := object.Key("MigrationTaskName")
		ok.String(*v.MigrationTaskName)
	}

	if v.ProgressUpdateStream != nil {
		ok := object.Key("ProgressUpdateStream")
		ok.String(*v.ProgressUpdateStream)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDisassociateCreatedArtifactInput(v *DisassociateCreatedArtifactInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CreatedArtifactName != nil {
		ok := object.Key("CreatedArtifactName")
		ok.String(*v.CreatedArtifactName)
	}

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.MigrationTaskName != nil {
		ok := object.Key("MigrationTaskName")
		ok.String(*v.MigrationTaskName)
	}

	if v.ProgressUpdateStream != nil {
		ok := object.Key("ProgressUpdateStream")
		ok.String(*v.ProgressUpdateStream)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDisassociateDiscoveredResourceInput(v *DisassociateDiscoveredResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationId != nil {
		ok := object.Key("ConfigurationId")
		ok.String(*v.ConfigurationId)
	}

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.MigrationTaskName != nil {
		ok := object.Key("MigrationTaskName")
		ok.String(*v.MigrationTaskName)
	}

	if v.ProgressUpdateStream != nil {
		ok := object.Key("ProgressUpdateStream")
		ok.String(*v.ProgressUpdateStream)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentImportMigrationTaskInput(v *ImportMigrationTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.MigrationTaskName != nil {
		ok := object.Key("MigrationTaskName")
		ok.String(*v.MigrationTaskName)
	}

	if v.ProgressUpdateStream != nil {
		ok := object.Key("ProgressUpdateStream")
		ok.String(*v.ProgressUpdateStream)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListApplicationStatesInput(v *ListApplicationStatesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationIds != nil {
		ok := object.Key("ApplicationIds")
		if err := awsAwsjson11_serializeDocumentApplicationIds(v.ApplicationIds, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListCreatedArtifactsInput(v *ListCreatedArtifactsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.MigrationTaskName != nil {
		ok := object.Key("MigrationTaskName")
		ok.String(*v.MigrationTaskName)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ProgressUpdateStream != nil {
		ok := object.Key("ProgressUpdateStream")
		ok.String(*v.ProgressUpdateStream)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListDiscoveredResourcesInput(v *ListDiscoveredResourcesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.MigrationTaskName != nil {
		ok := object.Key("MigrationTaskName")
		ok.String(*v.MigrationTaskName)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ProgressUpdateStream != nil {
		ok := object.Key("ProgressUpdateStream")
		ok.String(*v.ProgressUpdateStream)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListMigrationTasksInput(v *ListMigrationTasksInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ResourceName != nil {
		ok := object.Key("ResourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListProgressUpdateStreamsInput(v *ListProgressUpdateStreamsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentNotifyApplicationStateInput(v *NotifyApplicationStateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationId != nil {
		ok := object.Key("ApplicationId")
		ok.String(*v.ApplicationId)
	}

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if v.UpdateDateTime != nil {
		ok := object.Key("UpdateDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.UpdateDateTime))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentNotifyMigrationTaskStateInput(v *NotifyMigrationTaskStateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.MigrationTaskName != nil {
		ok := object.Key("MigrationTaskName")
		ok.String(*v.MigrationTaskName)
	}

	{
		ok := object.Key("NextUpdateSeconds")
		ok.Integer(v.NextUpdateSeconds)
	}

	if v.ProgressUpdateStream != nil {
		ok := object.Key("ProgressUpdateStream")
		ok.String(*v.ProgressUpdateStream)
	}

	if v.Task != nil {
		ok := object.Key("Task")
		if err := awsAwsjson11_serializeDocumentTask(v.Task, ok); err != nil {
			return err
		}
	}

	if v.UpdateDateTime != nil {
		ok := object.Key("UpdateDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.UpdateDateTime))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutResourceAttributesInput(v *PutResourceAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.MigrationTaskName != nil {
		ok := object.Key("MigrationTaskName")
		ok.String(*v.MigrationTaskName)
	}

	if v.ProgressUpdateStream != nil {
		ok := object.Key("ProgressUpdateStream")
		ok.String(*v.ProgressUpdateStream)
	}

	if v.ResourceAttributeList != nil {
		ok := object.Key("ResourceAttributeList")
		if err := awsAwsjson11_serializeDocumentResourceAttributeList(v.ResourceAttributeList, ok); err != nil {
			return err
		}
	}

	return nil
}
