// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Represents an FinSpace environment.
type Environment struct {

	// The ID of the AWS account in which the FinSpace environment is created.
	AwsAccountId *string

	// The AWS account ID of the dedicated service account associated with your
	// FinSpace environment.
	DedicatedServiceAccountId *string

	// The description of the FinSpace environment.
	Description *string

	// The Amazon Resource Name (ARN) of your FinSpace environment.
	EnvironmentArn *string

	// The identifier of the FinSpace environment.
	EnvironmentId *string

	// The sign-in url for the web application of your FinSpace environment.
	EnvironmentUrl *string

	// The authentication mode for the environment.
	FederationMode FederationMode

	// Configuration information when authentication mode is FEDERATED.
	FederationParameters *FederationParameters

	// The KMS key id used to encrypt in the FinSpace environment.
	KmsKeyId *string

	// The name of the FinSpace environment.
	Name *string

	// The url of the integrated FinSpace notebook environment in your web application.
	SageMakerStudioDomainUrl *string

	// The current status of creation of the FinSpace environment.
	Status EnvironmentStatus

	noSmithyDocumentSerde
}

// Configuration information when authentication mode is FEDERATED.
type FederationParameters struct {

	// The redirect or sign-in URL that should be entered into the SAML 2.0 compliant
	// identity provider configuration (IdP).
	ApplicationCallBackURL *string

	// SAML attribute name and value. The name must always be Email and the value
	// should be set to the attribute definition in which user email is set. For
	// example, name would be Email and value
	// http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress. Please check
	// your SAML 2.0 compliant identity provider (IdP) documentation for details.
	AttributeMap map[string]string

	// Name of the identity provider (IdP).
	FederationProviderName *string

	// The Uniform Resource Name (URN). Also referred as Service Provider URN or
	// Audience URI or Service Provider Entity ID.
	FederationURN *string

	// SAML 2.0 Metadata document from identity provider (IdP).
	SamlMetadataDocument *string

	// Provide the metadata URL from your SAML 2.0 compliant identity provider (IdP).
	SamlMetadataURL *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
