// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizer

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/restjson"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizer/types"
	smithy "github.com/aws/smithy-go"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"math"
	"strings"
	"time"
)

type awsAwsjson10_deserializeOpDescribeRecommendationExportJobs struct {
}

func (*awsAwsjson10_deserializeOpDescribeRecommendationExportJobs) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpDescribeRecommendationExportJobs) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorDescribeRecommendationExportJobs(response, &metadata)
	}
	output := &DescribeRecommendationExportJobsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentDescribeRecommendationExportJobsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorDescribeRecommendationExportJobs(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("OptInRequiredException", errorCode):
		return awsAwsjson10_deserializeErrorOptInRequiredException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsAwsjson10_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpExportAutoScalingGroupRecommendations struct {
}

func (*awsAwsjson10_deserializeOpExportAutoScalingGroupRecommendations) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpExportAutoScalingGroupRecommendations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorExportAutoScalingGroupRecommendations(response, &metadata)
	}
	output := &ExportAutoScalingGroupRecommendationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentExportAutoScalingGroupRecommendationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorExportAutoScalingGroupRecommendations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("OptInRequiredException", errorCode):
		return awsAwsjson10_deserializeErrorOptInRequiredException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpExportEBSVolumeRecommendations struct {
}

func (*awsAwsjson10_deserializeOpExportEBSVolumeRecommendations) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpExportEBSVolumeRecommendations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorExportEBSVolumeRecommendations(response, &metadata)
	}
	output := &ExportEBSVolumeRecommendationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentExportEBSVolumeRecommendationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorExportEBSVolumeRecommendations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("OptInRequiredException", errorCode):
		return awsAwsjson10_deserializeErrorOptInRequiredException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpExportEC2InstanceRecommendations struct {
}

func (*awsAwsjson10_deserializeOpExportEC2InstanceRecommendations) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpExportEC2InstanceRecommendations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorExportEC2InstanceRecommendations(response, &metadata)
	}
	output := &ExportEC2InstanceRecommendationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentExportEC2InstanceRecommendationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorExportEC2InstanceRecommendations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("OptInRequiredException", errorCode):
		return awsAwsjson10_deserializeErrorOptInRequiredException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpExportLambdaFunctionRecommendations struct {
}

func (*awsAwsjson10_deserializeOpExportLambdaFunctionRecommendations) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpExportLambdaFunctionRecommendations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorExportLambdaFunctionRecommendations(response, &metadata)
	}
	output := &ExportLambdaFunctionRecommendationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentExportLambdaFunctionRecommendationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorExportLambdaFunctionRecommendations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("OptInRequiredException", errorCode):
		return awsAwsjson10_deserializeErrorOptInRequiredException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpGetAutoScalingGroupRecommendations struct {
}

func (*awsAwsjson10_deserializeOpGetAutoScalingGroupRecommendations) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpGetAutoScalingGroupRecommendations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorGetAutoScalingGroupRecommendations(response, &metadata)
	}
	output := &GetAutoScalingGroupRecommendationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentGetAutoScalingGroupRecommendationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorGetAutoScalingGroupRecommendations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("OptInRequiredException", errorCode):
		return awsAwsjson10_deserializeErrorOptInRequiredException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsAwsjson10_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpGetEBSVolumeRecommendations struct {
}

func (*awsAwsjson10_deserializeOpGetEBSVolumeRecommendations) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpGetEBSVolumeRecommendations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorGetEBSVolumeRecommendations(response, &metadata)
	}
	output := &GetEBSVolumeRecommendationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentGetEBSVolumeRecommendationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorGetEBSVolumeRecommendations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("OptInRequiredException", errorCode):
		return awsAwsjson10_deserializeErrorOptInRequiredException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsAwsjson10_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpGetEC2InstanceRecommendations struct {
}

func (*awsAwsjson10_deserializeOpGetEC2InstanceRecommendations) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpGetEC2InstanceRecommendations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorGetEC2InstanceRecommendations(response, &metadata)
	}
	output := &GetEC2InstanceRecommendationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentGetEC2InstanceRecommendationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorGetEC2InstanceRecommendations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("OptInRequiredException", errorCode):
		return awsAwsjson10_deserializeErrorOptInRequiredException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsAwsjson10_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpGetEC2RecommendationProjectedMetrics struct {
}

func (*awsAwsjson10_deserializeOpGetEC2RecommendationProjectedMetrics) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpGetEC2RecommendationProjectedMetrics) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorGetEC2RecommendationProjectedMetrics(response, &metadata)
	}
	output := &GetEC2RecommendationProjectedMetricsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentGetEC2RecommendationProjectedMetricsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorGetEC2RecommendationProjectedMetrics(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("OptInRequiredException", errorCode):
		return awsAwsjson10_deserializeErrorOptInRequiredException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsAwsjson10_deserializeErrorResourceNotFoundException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpGetEnrollmentStatus struct {
}

func (*awsAwsjson10_deserializeOpGetEnrollmentStatus) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpGetEnrollmentStatus) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorGetEnrollmentStatus(response, &metadata)
	}
	output := &GetEnrollmentStatusOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentGetEnrollmentStatusOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorGetEnrollmentStatus(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpGetEnrollmentStatusesForOrganization struct {
}

func (*awsAwsjson10_deserializeOpGetEnrollmentStatusesForOrganization) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpGetEnrollmentStatusesForOrganization) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorGetEnrollmentStatusesForOrganization(response, &metadata)
	}
	output := &GetEnrollmentStatusesForOrganizationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentGetEnrollmentStatusesForOrganizationOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorGetEnrollmentStatusesForOrganization(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpGetLambdaFunctionRecommendations struct {
}

func (*awsAwsjson10_deserializeOpGetLambdaFunctionRecommendations) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpGetLambdaFunctionRecommendations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorGetLambdaFunctionRecommendations(response, &metadata)
	}
	output := &GetLambdaFunctionRecommendationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentGetLambdaFunctionRecommendationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorGetLambdaFunctionRecommendations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("OptInRequiredException", errorCode):
		return awsAwsjson10_deserializeErrorOptInRequiredException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpGetRecommendationSummaries struct {
}

func (*awsAwsjson10_deserializeOpGetRecommendationSummaries) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpGetRecommendationSummaries) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorGetRecommendationSummaries(response, &metadata)
	}
	output := &GetRecommendationSummariesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentGetRecommendationSummariesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorGetRecommendationSummaries(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("OptInRequiredException", errorCode):
		return awsAwsjson10_deserializeErrorOptInRequiredException(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpUpdateEnrollmentStatus struct {
}

func (*awsAwsjson10_deserializeOpUpdateEnrollmentStatus) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpUpdateEnrollmentStatus) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorUpdateEnrollmentStatus(response, &metadata)
	}
	output := &UpdateEnrollmentStatusOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentUpdateEnrollmentStatusOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorUpdateEnrollmentStatus(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsAwsjson10_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalServerException", errorCode):
		return awsAwsjson10_deserializeErrorInternalServerException(response, errorBody)

	case strings.EqualFold("InvalidParameterValueException", errorCode):
		return awsAwsjson10_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("MissingAuthenticationToken", errorCode):
		return awsAwsjson10_deserializeErrorMissingAuthenticationToken(response, errorBody)

	case strings.EqualFold("ServiceUnavailableException", errorCode):
		return awsAwsjson10_deserializeErrorServiceUnavailableException(response, errorBody)

	case strings.EqualFold("ThrottlingException", errorCode):
		return awsAwsjson10_deserializeErrorThrottlingException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsAwsjson10_deserializeErrorAccessDeniedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.AccessDeniedException{}
	err := awsAwsjson10_deserializeDocumentAccessDeniedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorInternalServerException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InternalServerException{}
	err := awsAwsjson10_deserializeDocumentInternalServerException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorInvalidParameterValueException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidParameterValueException{}
	err := awsAwsjson10_deserializeDocumentInvalidParameterValueException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.LimitExceededException{}
	err := awsAwsjson10_deserializeDocumentLimitExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorMissingAuthenticationToken(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MissingAuthenticationToken{}
	err := awsAwsjson10_deserializeDocumentMissingAuthenticationToken(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorOptInRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.OptInRequiredException{}
	err := awsAwsjson10_deserializeDocumentOptInRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorResourceNotFoundException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ResourceNotFoundException{}
	err := awsAwsjson10_deserializeDocumentResourceNotFoundException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorServiceUnavailableException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ServiceUnavailableException{}
	err := awsAwsjson10_deserializeDocumentServiceUnavailableException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorThrottlingException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ThrottlingException{}
	err := awsAwsjson10_deserializeDocumentThrottlingException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeDocumentAccessDeniedException(v **types.AccessDeniedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AccessDeniedException
	if *v == nil {
		sv = &types.AccessDeniedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentAccountEnrollmentStatus(v **types.AccountEnrollmentStatus, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AccountEnrollmentStatus
	if *v == nil {
		sv = &types.AccountEnrollmentStatus{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "accountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "lastUpdatedTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastUpdatedTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastUpdatedTimestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Status to be of type string, got %T instead", value)
				}
				sv.Status = types.Status(jtv)
			}

		case "statusReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected StatusReason to be of type string, got %T instead", value)
				}
				sv.StatusReason = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentAccountEnrollmentStatuses(v *[]types.AccountEnrollmentStatus, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AccountEnrollmentStatus
	if *v == nil {
		cv = []types.AccountEnrollmentStatus{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AccountEnrollmentStatus
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentAccountEnrollmentStatus(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentAutoScalingGroupConfiguration(v **types.AutoScalingGroupConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AutoScalingGroupConfiguration
	if *v == nil {
		sv = &types.AutoScalingGroupConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "desiredCapacity":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected DesiredCapacity to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DesiredCapacity = int32(i64)
			}

		case "instanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected InstanceType to be of type string, got %T instead", value)
				}
				sv.InstanceType = ptr.String(jtv)
			}

		case "maxSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected MaxSize to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxSize = int32(i64)
			}

		case "minSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected MinSize to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MinSize = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentAutoScalingGroupRecommendation(v **types.AutoScalingGroupRecommendation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AutoScalingGroupRecommendation
	if *v == nil {
		sv = &types.AutoScalingGroupRecommendation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "accountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "autoScalingGroupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AutoScalingGroupArn to be of type string, got %T instead", value)
				}
				sv.AutoScalingGroupArn = ptr.String(jtv)
			}

		case "autoScalingGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AutoScalingGroupName to be of type string, got %T instead", value)
				}
				sv.AutoScalingGroupName = ptr.String(jtv)
			}

		case "currentConfiguration":
			if err := awsAwsjson10_deserializeDocumentAutoScalingGroupConfiguration(&sv.CurrentConfiguration, value); err != nil {
				return err
			}

		case "finding":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Finding to be of type string, got %T instead", value)
				}
				sv.Finding = types.Finding(jtv)
			}

		case "lastRefreshTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastRefreshTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastRefreshTimestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "lookBackPeriodInDays":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LookBackPeriodInDays = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.LookBackPeriodInDays = f64

				default:
					return fmt.Errorf("expected LookBackPeriodInDays to be a JSON Number, got %T instead", value)

				}
			}

		case "recommendationOptions":
			if err := awsAwsjson10_deserializeDocumentAutoScalingGroupRecommendationOptions(&sv.RecommendationOptions, value); err != nil {
				return err
			}

		case "utilizationMetrics":
			if err := awsAwsjson10_deserializeDocumentUtilizationMetrics(&sv.UtilizationMetrics, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentAutoScalingGroupRecommendationOption(v **types.AutoScalingGroupRecommendationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AutoScalingGroupRecommendationOption
	if *v == nil {
		sv = &types.AutoScalingGroupRecommendationOption{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "configuration":
			if err := awsAwsjson10_deserializeDocumentAutoScalingGroupConfiguration(&sv.Configuration, value); err != nil {
				return err
			}

		case "performanceRisk":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.PerformanceRisk = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.PerformanceRisk = f64

				default:
					return fmt.Errorf("expected PerformanceRisk to be a JSON Number, got %T instead", value)

				}
			}

		case "projectedUtilizationMetrics":
			if err := awsAwsjson10_deserializeDocumentProjectedUtilizationMetrics(&sv.ProjectedUtilizationMetrics, value); err != nil {
				return err
			}

		case "rank":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Rank to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Rank = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentAutoScalingGroupRecommendationOptions(v *[]types.AutoScalingGroupRecommendationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AutoScalingGroupRecommendationOption
	if *v == nil {
		cv = []types.AutoScalingGroupRecommendationOption{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AutoScalingGroupRecommendationOption
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentAutoScalingGroupRecommendationOption(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentAutoScalingGroupRecommendations(v *[]types.AutoScalingGroupRecommendation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AutoScalingGroupRecommendation
	if *v == nil {
		cv = []types.AutoScalingGroupRecommendation{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AutoScalingGroupRecommendation
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentAutoScalingGroupRecommendation(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentEBSUtilizationMetric(v **types.EBSUtilizationMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EBSUtilizationMetric
	if *v == nil {
		sv = &types.EBSUtilizationMetric{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected EBSMetricName to be of type string, got %T instead", value)
				}
				sv.Name = types.EBSMetricName(jtv)
			}

		case "statistic":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MetricStatistic to be of type string, got %T instead", value)
				}
				sv.Statistic = types.MetricStatistic(jtv)
			}

		case "value":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Value = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Value = f64

				default:
					return fmt.Errorf("expected MetricValue to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentEBSUtilizationMetrics(v *[]types.EBSUtilizationMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.EBSUtilizationMetric
	if *v == nil {
		cv = []types.EBSUtilizationMetric{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.EBSUtilizationMetric
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentEBSUtilizationMetric(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentExportDestination(v **types.ExportDestination, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ExportDestination
	if *v == nil {
		sv = &types.ExportDestination{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "s3":
			if err := awsAwsjson10_deserializeDocumentS3Destination(&sv.S3, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentGetRecommendationError(v **types.GetRecommendationError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GetRecommendationError
	if *v == nil {
		sv = &types.GetRecommendationError{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Code to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "identifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Identifier to be of type string, got %T instead", value)
				}
				sv.Identifier = ptr.String(jtv)
			}

		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentGetRecommendationErrors(v *[]types.GetRecommendationError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.GetRecommendationError
	if *v == nil {
		cv = []types.GetRecommendationError{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.GetRecommendationError
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentGetRecommendationError(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentInstanceRecommendation(v **types.InstanceRecommendation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InstanceRecommendation
	if *v == nil {
		sv = &types.InstanceRecommendation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "accountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "currentInstanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CurrentInstanceType to be of type string, got %T instead", value)
				}
				sv.CurrentInstanceType = ptr.String(jtv)
			}

		case "finding":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Finding to be of type string, got %T instead", value)
				}
				sv.Finding = types.Finding(jtv)
			}

		case "findingReasonCodes":
			if err := awsAwsjson10_deserializeDocumentInstanceRecommendationFindingReasonCodes(&sv.FindingReasonCodes, value); err != nil {
				return err
			}

		case "instanceArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected InstanceArn to be of type string, got %T instead", value)
				}
				sv.InstanceArn = ptr.String(jtv)
			}

		case "instanceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected InstanceName to be of type string, got %T instead", value)
				}
				sv.InstanceName = ptr.String(jtv)
			}

		case "lastRefreshTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastRefreshTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastRefreshTimestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "lookBackPeriodInDays":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LookBackPeriodInDays = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.LookBackPeriodInDays = f64

				default:
					return fmt.Errorf("expected LookBackPeriodInDays to be a JSON Number, got %T instead", value)

				}
			}

		case "recommendationOptions":
			if err := awsAwsjson10_deserializeDocumentRecommendationOptions(&sv.RecommendationOptions, value); err != nil {
				return err
			}

		case "recommendationSources":
			if err := awsAwsjson10_deserializeDocumentRecommendationSources(&sv.RecommendationSources, value); err != nil {
				return err
			}

		case "utilizationMetrics":
			if err := awsAwsjson10_deserializeDocumentUtilizationMetrics(&sv.UtilizationMetrics, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentInstanceRecommendationFindingReasonCodes(v *[]types.InstanceRecommendationFindingReasonCode, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.InstanceRecommendationFindingReasonCode
	if *v == nil {
		cv = []types.InstanceRecommendationFindingReasonCode{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.InstanceRecommendationFindingReasonCode
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected InstanceRecommendationFindingReasonCode to be of type string, got %T instead", value)
			}
			col = types.InstanceRecommendationFindingReasonCode(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentInstanceRecommendationOption(v **types.InstanceRecommendationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InstanceRecommendationOption
	if *v == nil {
		sv = &types.InstanceRecommendationOption{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "instanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected InstanceType to be of type string, got %T instead", value)
				}
				sv.InstanceType = ptr.String(jtv)
			}

		case "performanceRisk":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.PerformanceRisk = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.PerformanceRisk = f64

				default:
					return fmt.Errorf("expected PerformanceRisk to be a JSON Number, got %T instead", value)

				}
			}

		case "platformDifferences":
			if err := awsAwsjson10_deserializeDocumentPlatformDifferences(&sv.PlatformDifferences, value); err != nil {
				return err
			}

		case "projectedUtilizationMetrics":
			if err := awsAwsjson10_deserializeDocumentProjectedUtilizationMetrics(&sv.ProjectedUtilizationMetrics, value); err != nil {
				return err
			}

		case "rank":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Rank to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Rank = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentInstanceRecommendations(v *[]types.InstanceRecommendation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.InstanceRecommendation
	if *v == nil {
		cv = []types.InstanceRecommendation{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.InstanceRecommendation
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentInstanceRecommendation(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentInternalServerException(v **types.InternalServerException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InternalServerException
	if *v == nil {
		sv = &types.InternalServerException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentInvalidParameterValueException(v **types.InvalidParameterValueException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidParameterValueException
	if *v == nil {
		sv = &types.InvalidParameterValueException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionMemoryProjectedMetric(v **types.LambdaFunctionMemoryProjectedMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LambdaFunctionMemoryProjectedMetric
	if *v == nil {
		sv = &types.LambdaFunctionMemoryProjectedMetric{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected LambdaFunctionMemoryMetricName to be of type string, got %T instead", value)
				}
				sv.Name = types.LambdaFunctionMemoryMetricName(jtv)
			}

		case "statistic":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected LambdaFunctionMemoryMetricStatistic to be of type string, got %T instead", value)
				}
				sv.Statistic = types.LambdaFunctionMemoryMetricStatistic(jtv)
			}

		case "value":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Value = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Value = f64

				default:
					return fmt.Errorf("expected MetricValue to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionMemoryProjectedMetrics(v *[]types.LambdaFunctionMemoryProjectedMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.LambdaFunctionMemoryProjectedMetric
	if *v == nil {
		cv = []types.LambdaFunctionMemoryProjectedMetric{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.LambdaFunctionMemoryProjectedMetric
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentLambdaFunctionMemoryProjectedMetric(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionMemoryRecommendationOption(v **types.LambdaFunctionMemoryRecommendationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LambdaFunctionMemoryRecommendationOption
	if *v == nil {
		sv = &types.LambdaFunctionMemoryRecommendationOption{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "memorySize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected MemorySize to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MemorySize = int32(i64)
			}

		case "projectedUtilizationMetrics":
			if err := awsAwsjson10_deserializeDocumentLambdaFunctionMemoryProjectedMetrics(&sv.ProjectedUtilizationMetrics, value); err != nil {
				return err
			}

		case "rank":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Rank to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Rank = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionMemoryRecommendationOptions(v *[]types.LambdaFunctionMemoryRecommendationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.LambdaFunctionMemoryRecommendationOption
	if *v == nil {
		cv = []types.LambdaFunctionMemoryRecommendationOption{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.LambdaFunctionMemoryRecommendationOption
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentLambdaFunctionMemoryRecommendationOption(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionRecommendation(v **types.LambdaFunctionRecommendation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LambdaFunctionRecommendation
	if *v == nil {
		sv = &types.LambdaFunctionRecommendation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "accountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "currentMemorySize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected MemorySize to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CurrentMemorySize = int32(i64)
			}

		case "finding":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected LambdaFunctionRecommendationFinding to be of type string, got %T instead", value)
				}
				sv.Finding = types.LambdaFunctionRecommendationFinding(jtv)
			}

		case "findingReasonCodes":
			if err := awsAwsjson10_deserializeDocumentLambdaFunctionRecommendationFindingReasonCodes(&sv.FindingReasonCodes, value); err != nil {
				return err
			}

		case "functionArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FunctionArn to be of type string, got %T instead", value)
				}
				sv.FunctionArn = ptr.String(jtv)
			}

		case "functionVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FunctionVersion to be of type string, got %T instead", value)
				}
				sv.FunctionVersion = ptr.String(jtv)
			}

		case "lastRefreshTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastRefreshTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastRefreshTimestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "lookbackPeriodInDays":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LookbackPeriodInDays = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.LookbackPeriodInDays = f64

				default:
					return fmt.Errorf("expected LookBackPeriodInDays to be a JSON Number, got %T instead", value)

				}
			}

		case "memorySizeRecommendationOptions":
			if err := awsAwsjson10_deserializeDocumentLambdaFunctionMemoryRecommendationOptions(&sv.MemorySizeRecommendationOptions, value); err != nil {
				return err
			}

		case "numberOfInvocations":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected NumberOfInvocations to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NumberOfInvocations = i64
			}

		case "utilizationMetrics":
			if err := awsAwsjson10_deserializeDocumentLambdaFunctionUtilizationMetrics(&sv.UtilizationMetrics, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionRecommendationFindingReasonCodes(v *[]types.LambdaFunctionRecommendationFindingReasonCode, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.LambdaFunctionRecommendationFindingReasonCode
	if *v == nil {
		cv = []types.LambdaFunctionRecommendationFindingReasonCode{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.LambdaFunctionRecommendationFindingReasonCode
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected LambdaFunctionRecommendationFindingReasonCode to be of type string, got %T instead", value)
			}
			col = types.LambdaFunctionRecommendationFindingReasonCode(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionRecommendations(v *[]types.LambdaFunctionRecommendation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.LambdaFunctionRecommendation
	if *v == nil {
		cv = []types.LambdaFunctionRecommendation{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.LambdaFunctionRecommendation
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentLambdaFunctionRecommendation(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionUtilizationMetric(v **types.LambdaFunctionUtilizationMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LambdaFunctionUtilizationMetric
	if *v == nil {
		sv = &types.LambdaFunctionUtilizationMetric{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected LambdaFunctionMetricName to be of type string, got %T instead", value)
				}
				sv.Name = types.LambdaFunctionMetricName(jtv)
			}

		case "statistic":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected LambdaFunctionMetricStatistic to be of type string, got %T instead", value)
				}
				sv.Statistic = types.LambdaFunctionMetricStatistic(jtv)
			}

		case "value":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Value = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Value = f64

				default:
					return fmt.Errorf("expected MetricValue to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionUtilizationMetrics(v *[]types.LambdaFunctionUtilizationMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.LambdaFunctionUtilizationMetric
	if *v == nil {
		cv = []types.LambdaFunctionUtilizationMetric{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.LambdaFunctionUtilizationMetric
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentLambdaFunctionUtilizationMetric(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentLimitExceededException(v **types.LimitExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LimitExceededException
	if *v == nil {
		sv = &types.LimitExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentMetricValues(v *[]float64, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []float64
	if *v == nil {
		cv = []float64{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col float64
		if value != nil {
			switch jtv := value.(type) {
			case json.Number:
				f64, err := jtv.Float64()
				if err != nil {
					return err
				}
				col = f64

			case string:
				var f64 float64
				switch {
				case strings.EqualFold(jtv, "NaN"):
					f64 = math.NaN()

				case strings.EqualFold(jtv, "Infinity"):
					f64 = math.Inf(1)

				case strings.EqualFold(jtv, "-Infinity"):
					f64 = math.Inf(-1)

				default:
					return fmt.Errorf("unknown JSON number value: %s", jtv)

				}
				col = f64

			default:
				return fmt.Errorf("expected MetricValue to be a JSON Number, got %T instead", value)

			}
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentMissingAuthenticationToken(v **types.MissingAuthenticationToken, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MissingAuthenticationToken
	if *v == nil {
		sv = &types.MissingAuthenticationToken{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentOptInRequiredException(v **types.OptInRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.OptInRequiredException
	if *v == nil {
		sv = &types.OptInRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentPlatformDifferences(v *[]types.PlatformDifference, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.PlatformDifference
	if *v == nil {
		cv = []types.PlatformDifference{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.PlatformDifference
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected PlatformDifference to be of type string, got %T instead", value)
			}
			col = types.PlatformDifference(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentProjectedMetric(v **types.ProjectedMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ProjectedMetric
	if *v == nil {
		sv = &types.ProjectedMetric{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MetricName to be of type string, got %T instead", value)
				}
				sv.Name = types.MetricName(jtv)
			}

		case "timestamps":
			if err := awsAwsjson10_deserializeDocumentTimestamps(&sv.Timestamps, value); err != nil {
				return err
			}

		case "values":
			if err := awsAwsjson10_deserializeDocumentMetricValues(&sv.Values, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentProjectedMetrics(v *[]types.ProjectedMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ProjectedMetric
	if *v == nil {
		cv = []types.ProjectedMetric{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ProjectedMetric
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentProjectedMetric(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentProjectedUtilizationMetrics(v *[]types.UtilizationMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.UtilizationMetric
	if *v == nil {
		cv = []types.UtilizationMetric{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.UtilizationMetric
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentUtilizationMetric(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentReasonCodeSummaries(v *[]types.ReasonCodeSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ReasonCodeSummary
	if *v == nil {
		cv = []types.ReasonCodeSummary{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ReasonCodeSummary
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentReasonCodeSummary(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentReasonCodeSummary(v **types.ReasonCodeSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ReasonCodeSummary
	if *v == nil {
		sv = &types.ReasonCodeSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FindingReasonCode to be of type string, got %T instead", value)
				}
				sv.Name = types.FindingReasonCode(jtv)
			}

		case "value":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Value = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Value = f64

				default:
					return fmt.Errorf("expected SummaryValue to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentRecommendationExportJob(v **types.RecommendationExportJob, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RecommendationExportJob
	if *v == nil {
		sv = &types.RecommendationExportJob{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "creationTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.CreationTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected CreationTimestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "destination":
			if err := awsAwsjson10_deserializeDocumentExportDestination(&sv.Destination, value); err != nil {
				return err
			}

		case "failureReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FailureReason to be of type string, got %T instead", value)
				}
				sv.FailureReason = ptr.String(jtv)
			}

		case "jobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected JobId to be of type string, got %T instead", value)
				}
				sv.JobId = ptr.String(jtv)
			}

		case "lastUpdatedTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastUpdatedTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastUpdatedTimestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "resourceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ResourceType to be of type string, got %T instead", value)
				}
				sv.ResourceType = types.ResourceType(jtv)
			}

		case "status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected JobStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.JobStatus(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentRecommendationExportJobs(v *[]types.RecommendationExportJob, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RecommendationExportJob
	if *v == nil {
		cv = []types.RecommendationExportJob{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RecommendationExportJob
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentRecommendationExportJob(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentRecommendationOptions(v *[]types.InstanceRecommendationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.InstanceRecommendationOption
	if *v == nil {
		cv = []types.InstanceRecommendationOption{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.InstanceRecommendationOption
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentInstanceRecommendationOption(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentRecommendationSource(v **types.RecommendationSource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RecommendationSource
	if *v == nil {
		sv = &types.RecommendationSource{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "recommendationSourceArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RecommendationSourceArn to be of type string, got %T instead", value)
				}
				sv.RecommendationSourceArn = ptr.String(jtv)
			}

		case "recommendationSourceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RecommendationSourceType to be of type string, got %T instead", value)
				}
				sv.RecommendationSourceType = types.RecommendationSourceType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentRecommendationSources(v *[]types.RecommendationSource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RecommendationSource
	if *v == nil {
		cv = []types.RecommendationSource{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RecommendationSource
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentRecommendationSource(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentRecommendationSummaries(v *[]types.RecommendationSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RecommendationSummary
	if *v == nil {
		cv = []types.RecommendationSummary{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RecommendationSummary
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentRecommendationSummary(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentRecommendationSummary(v **types.RecommendationSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RecommendationSummary
	if *v == nil {
		sv = &types.RecommendationSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "accountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "recommendationResourceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RecommendationSourceType to be of type string, got %T instead", value)
				}
				sv.RecommendationResourceType = types.RecommendationSourceType(jtv)
			}

		case "summaries":
			if err := awsAwsjson10_deserializeDocumentSummaries(&sv.Summaries, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentRecommendedOptionProjectedMetric(v **types.RecommendedOptionProjectedMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RecommendedOptionProjectedMetric
	if *v == nil {
		sv = &types.RecommendedOptionProjectedMetric{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "projectedMetrics":
			if err := awsAwsjson10_deserializeDocumentProjectedMetrics(&sv.ProjectedMetrics, value); err != nil {
				return err
			}

		case "rank":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Rank to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Rank = int32(i64)
			}

		case "recommendedInstanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RecommendedInstanceType to be of type string, got %T instead", value)
				}
				sv.RecommendedInstanceType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentRecommendedOptionProjectedMetrics(v *[]types.RecommendedOptionProjectedMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RecommendedOptionProjectedMetric
	if *v == nil {
		cv = []types.RecommendedOptionProjectedMetric{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RecommendedOptionProjectedMetric
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentRecommendedOptionProjectedMetric(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentResourceNotFoundException(v **types.ResourceNotFoundException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ResourceNotFoundException
	if *v == nil {
		sv = &types.ResourceNotFoundException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentS3Destination(v **types.S3Destination, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.S3Destination
	if *v == nil {
		sv = &types.S3Destination{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "bucket":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DestinationBucket to be of type string, got %T instead", value)
				}
				sv.Bucket = ptr.String(jtv)
			}

		case "key":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DestinationKey to be of type string, got %T instead", value)
				}
				sv.Key = ptr.String(jtv)
			}

		case "metadataKey":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MetadataKey to be of type string, got %T instead", value)
				}
				sv.MetadataKey = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentServiceUnavailableException(v **types.ServiceUnavailableException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ServiceUnavailableException
	if *v == nil {
		sv = &types.ServiceUnavailableException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentSummaries(v *[]types.Summary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Summary
	if *v == nil {
		cv = []types.Summary{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Summary
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentSummary(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentSummary(v **types.Summary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Summary
	if *v == nil {
		sv = &types.Summary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Finding to be of type string, got %T instead", value)
				}
				sv.Name = types.Finding(jtv)
			}

		case "reasonCodeSummaries":
			if err := awsAwsjson10_deserializeDocumentReasonCodeSummaries(&sv.ReasonCodeSummaries, value); err != nil {
				return err
			}

		case "value":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Value = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Value = f64

				default:
					return fmt.Errorf("expected SummaryValue to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentThrottlingException(v **types.ThrottlingException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ThrottlingException
	if *v == nil {
		sv = &types.ThrottlingException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentTimestamps(v *[]time.Time, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []time.Time
	if *v == nil {
		cv = []time.Time{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col time.Time
		if value != nil {
			switch jtv := value.(type) {
			case json.Number:
				f64, err := jtv.Float64()
				if err != nil {
					return err
				}
				col = smithytime.ParseEpochSeconds(f64)

			default:
				return fmt.Errorf("expected Timestamp to be a JSON Number, got %T instead", value)

			}
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentUtilizationMetric(v **types.UtilizationMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.UtilizationMetric
	if *v == nil {
		sv = &types.UtilizationMetric{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MetricName to be of type string, got %T instead", value)
				}
				sv.Name = types.MetricName(jtv)
			}

		case "statistic":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MetricStatistic to be of type string, got %T instead", value)
				}
				sv.Statistic = types.MetricStatistic(jtv)
			}

		case "value":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Value = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Value = f64

				default:
					return fmt.Errorf("expected MetricValue to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentUtilizationMetrics(v *[]types.UtilizationMetric, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.UtilizationMetric
	if *v == nil {
		cv = []types.UtilizationMetric{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.UtilizationMetric
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentUtilizationMetric(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentVolumeConfiguration(v **types.VolumeConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.VolumeConfiguration
	if *v == nil {
		sv = &types.VolumeConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "volumeBaselineIOPS":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected VolumeBaselineIOPS to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.VolumeBaselineIOPS = int32(i64)
			}

		case "volumeBaselineThroughput":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected VolumeBaselineThroughput to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.VolumeBaselineThroughput = int32(i64)
			}

		case "volumeBurstIOPS":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected VolumeBurstIOPS to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.VolumeBurstIOPS = int32(i64)
			}

		case "volumeBurstThroughput":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected VolumeBurstThroughput to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.VolumeBurstThroughput = int32(i64)
			}

		case "volumeSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected VolumeSize to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.VolumeSize = int32(i64)
			}

		case "volumeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected VolumeType to be of type string, got %T instead", value)
				}
				sv.VolumeType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentVolumeRecommendation(v **types.VolumeRecommendation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.VolumeRecommendation
	if *v == nil {
		sv = &types.VolumeRecommendation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "accountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "currentConfiguration":
			if err := awsAwsjson10_deserializeDocumentVolumeConfiguration(&sv.CurrentConfiguration, value); err != nil {
				return err
			}

		case "finding":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected EBSFinding to be of type string, got %T instead", value)
				}
				sv.Finding = types.EBSFinding(jtv)
			}

		case "lastRefreshTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastRefreshTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastRefreshTimestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "lookBackPeriodInDays":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LookBackPeriodInDays = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.LookBackPeriodInDays = f64

				default:
					return fmt.Errorf("expected LookBackPeriodInDays to be a JSON Number, got %T instead", value)

				}
			}

		case "utilizationMetrics":
			if err := awsAwsjson10_deserializeDocumentEBSUtilizationMetrics(&sv.UtilizationMetrics, value); err != nil {
				return err
			}

		case "volumeArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected VolumeArn to be of type string, got %T instead", value)
				}
				sv.VolumeArn = ptr.String(jtv)
			}

		case "volumeRecommendationOptions":
			if err := awsAwsjson10_deserializeDocumentVolumeRecommendationOptions(&sv.VolumeRecommendationOptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentVolumeRecommendationOption(v **types.VolumeRecommendationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.VolumeRecommendationOption
	if *v == nil {
		sv = &types.VolumeRecommendationOption{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "configuration":
			if err := awsAwsjson10_deserializeDocumentVolumeConfiguration(&sv.Configuration, value); err != nil {
				return err
			}

		case "performanceRisk":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.PerformanceRisk = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.PerformanceRisk = f64

				default:
					return fmt.Errorf("expected PerformanceRisk to be a JSON Number, got %T instead", value)

				}
			}

		case "rank":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Rank to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Rank = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentVolumeRecommendationOptions(v *[]types.VolumeRecommendationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.VolumeRecommendationOption
	if *v == nil {
		cv = []types.VolumeRecommendationOption{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.VolumeRecommendationOption
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentVolumeRecommendationOption(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentVolumeRecommendations(v *[]types.VolumeRecommendation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.VolumeRecommendation
	if *v == nil {
		cv = []types.VolumeRecommendation{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.VolumeRecommendation
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentVolumeRecommendation(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeOpDocumentDescribeRecommendationExportJobsOutput(v **DescribeRecommendationExportJobsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeRecommendationExportJobsOutput
	if *v == nil {
		sv = &DescribeRecommendationExportJobsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "recommendationExportJobs":
			if err := awsAwsjson10_deserializeDocumentRecommendationExportJobs(&sv.RecommendationExportJobs, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentExportAutoScalingGroupRecommendationsOutput(v **ExportAutoScalingGroupRecommendationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ExportAutoScalingGroupRecommendationsOutput
	if *v == nil {
		sv = &ExportAutoScalingGroupRecommendationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "jobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected JobId to be of type string, got %T instead", value)
				}
				sv.JobId = ptr.String(jtv)
			}

		case "s3Destination":
			if err := awsAwsjson10_deserializeDocumentS3Destination(&sv.S3Destination, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentExportEBSVolumeRecommendationsOutput(v **ExportEBSVolumeRecommendationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ExportEBSVolumeRecommendationsOutput
	if *v == nil {
		sv = &ExportEBSVolumeRecommendationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "jobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected JobId to be of type string, got %T instead", value)
				}
				sv.JobId = ptr.String(jtv)
			}

		case "s3Destination":
			if err := awsAwsjson10_deserializeDocumentS3Destination(&sv.S3Destination, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentExportEC2InstanceRecommendationsOutput(v **ExportEC2InstanceRecommendationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ExportEC2InstanceRecommendationsOutput
	if *v == nil {
		sv = &ExportEC2InstanceRecommendationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "jobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected JobId to be of type string, got %T instead", value)
				}
				sv.JobId = ptr.String(jtv)
			}

		case "s3Destination":
			if err := awsAwsjson10_deserializeDocumentS3Destination(&sv.S3Destination, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentExportLambdaFunctionRecommendationsOutput(v **ExportLambdaFunctionRecommendationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ExportLambdaFunctionRecommendationsOutput
	if *v == nil {
		sv = &ExportLambdaFunctionRecommendationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "jobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected JobId to be of type string, got %T instead", value)
				}
				sv.JobId = ptr.String(jtv)
			}

		case "s3Destination":
			if err := awsAwsjson10_deserializeDocumentS3Destination(&sv.S3Destination, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentGetAutoScalingGroupRecommendationsOutput(v **GetAutoScalingGroupRecommendationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetAutoScalingGroupRecommendationsOutput
	if *v == nil {
		sv = &GetAutoScalingGroupRecommendationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "autoScalingGroupRecommendations":
			if err := awsAwsjson10_deserializeDocumentAutoScalingGroupRecommendations(&sv.AutoScalingGroupRecommendations, value); err != nil {
				return err
			}

		case "errors":
			if err := awsAwsjson10_deserializeDocumentGetRecommendationErrors(&sv.Errors, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentGetEBSVolumeRecommendationsOutput(v **GetEBSVolumeRecommendationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetEBSVolumeRecommendationsOutput
	if *v == nil {
		sv = &GetEBSVolumeRecommendationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "errors":
			if err := awsAwsjson10_deserializeDocumentGetRecommendationErrors(&sv.Errors, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "volumeRecommendations":
			if err := awsAwsjson10_deserializeDocumentVolumeRecommendations(&sv.VolumeRecommendations, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentGetEC2InstanceRecommendationsOutput(v **GetEC2InstanceRecommendationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetEC2InstanceRecommendationsOutput
	if *v == nil {
		sv = &GetEC2InstanceRecommendationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "errors":
			if err := awsAwsjson10_deserializeDocumentGetRecommendationErrors(&sv.Errors, value); err != nil {
				return err
			}

		case "instanceRecommendations":
			if err := awsAwsjson10_deserializeDocumentInstanceRecommendations(&sv.InstanceRecommendations, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentGetEC2RecommendationProjectedMetricsOutput(v **GetEC2RecommendationProjectedMetricsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetEC2RecommendationProjectedMetricsOutput
	if *v == nil {
		sv = &GetEC2RecommendationProjectedMetricsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "recommendedOptionProjectedMetrics":
			if err := awsAwsjson10_deserializeDocumentRecommendedOptionProjectedMetrics(&sv.RecommendedOptionProjectedMetrics, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentGetEnrollmentStatusesForOrganizationOutput(v **GetEnrollmentStatusesForOrganizationOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetEnrollmentStatusesForOrganizationOutput
	if *v == nil {
		sv = &GetEnrollmentStatusesForOrganizationOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "accountEnrollmentStatuses":
			if err := awsAwsjson10_deserializeDocumentAccountEnrollmentStatuses(&sv.AccountEnrollmentStatuses, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentGetEnrollmentStatusOutput(v **GetEnrollmentStatusOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetEnrollmentStatusOutput
	if *v == nil {
		sv = &GetEnrollmentStatusOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "lastUpdatedTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastUpdatedTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastUpdatedTimestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "memberAccountsEnrolled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected MemberAccountsEnrolled to be of type *bool, got %T instead", value)
				}
				sv.MemberAccountsEnrolled = jtv
			}

		case "numberOfMemberAccountsOptedIn":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected NumberOfMemberAccountsOptedIn to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NumberOfMemberAccountsOptedIn = ptr.Int32(int32(i64))
			}

		case "status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Status to be of type string, got %T instead", value)
				}
				sv.Status = types.Status(jtv)
			}

		case "statusReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected StatusReason to be of type string, got %T instead", value)
				}
				sv.StatusReason = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentGetLambdaFunctionRecommendationsOutput(v **GetLambdaFunctionRecommendationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetLambdaFunctionRecommendationsOutput
	if *v == nil {
		sv = &GetLambdaFunctionRecommendationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "lambdaFunctionRecommendations":
			if err := awsAwsjson10_deserializeDocumentLambdaFunctionRecommendations(&sv.LambdaFunctionRecommendations, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentGetRecommendationSummariesOutput(v **GetRecommendationSummariesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetRecommendationSummariesOutput
	if *v == nil {
		sv = &GetRecommendationSummariesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "recommendationSummaries":
			if err := awsAwsjson10_deserializeDocumentRecommendationSummaries(&sv.RecommendationSummaries, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentUpdateEnrollmentStatusOutput(v **UpdateEnrollmentStatusOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateEnrollmentStatusOutput
	if *v == nil {
		sv = &UpdateEnrollmentStatusOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Status to be of type string, got %T instead", value)
				}
				sv.Status = types.Status(jtv)
			}

		case "statusReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected StatusReason to be of type string, got %T instead", value)
				}
				sv.StatusReason = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}
