// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkidentity

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkidentity/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateAppInstance struct {
}

func (*awsRestjson1_serializeOpCreateAppInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAppInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAppInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAppInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAppInstanceInput(v *CreateAppInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAppInstanceInput(v *CreateAppInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Metadata != nil {
		ok := object.Key("Metadata")
		ok.String(*v.Metadata)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateAppInstanceAdmin struct {
}

func (*awsRestjson1_serializeOpCreateAppInstanceAdmin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAppInstanceAdmin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAppInstanceAdminInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instances/{AppInstanceArn}/admins")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAppInstanceAdminInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAppInstanceAdminInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAppInstanceAdminInput(v *CreateAppInstanceAdminInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceArn == nil || len(*v.AppInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceArn must not be empty")}
	}
	if v.AppInstanceArn != nil {
		if err := encoder.SetURI("AppInstanceArn").String(*v.AppInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAppInstanceAdminInput(v *CreateAppInstanceAdminInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppInstanceAdminArn != nil {
		ok := object.Key("AppInstanceAdminArn")
		ok.String(*v.AppInstanceAdminArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateAppInstanceUser struct {
}

func (*awsRestjson1_serializeOpCreateAppInstanceUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAppInstanceUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAppInstanceUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instance-users")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAppInstanceUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAppInstanceUserInput(v *CreateAppInstanceUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAppInstanceUserInput(v *CreateAppInstanceUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppInstanceArn != nil {
		ok := object.Key("AppInstanceArn")
		ok.String(*v.AppInstanceArn)
	}

	if v.AppInstanceUserId != nil {
		ok := object.Key("AppInstanceUserId")
		ok.String(*v.AppInstanceUserId)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Metadata != nil {
		ok := object.Key("Metadata")
		ok.String(*v.Metadata)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAppInstance struct {
}

func (*awsRestjson1_serializeOpDeleteAppInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAppInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAppInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instances/{AppInstanceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAppInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAppInstanceInput(v *DeleteAppInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceArn == nil || len(*v.AppInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceArn must not be empty")}
	}
	if v.AppInstanceArn != nil {
		if err := encoder.SetURI("AppInstanceArn").String(*v.AppInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAppInstanceAdmin struct {
}

func (*awsRestjson1_serializeOpDeleteAppInstanceAdmin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAppInstanceAdmin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAppInstanceAdminInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instances/{AppInstanceArn}/admins/{AppInstanceAdminArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAppInstanceAdminInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAppInstanceAdminInput(v *DeleteAppInstanceAdminInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceAdminArn == nil || len(*v.AppInstanceAdminArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceAdminArn must not be empty")}
	}
	if v.AppInstanceAdminArn != nil {
		if err := encoder.SetURI("AppInstanceAdminArn").String(*v.AppInstanceAdminArn); err != nil {
			return err
		}
	}

	if v.AppInstanceArn == nil || len(*v.AppInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceArn must not be empty")}
	}
	if v.AppInstanceArn != nil {
		if err := encoder.SetURI("AppInstanceArn").String(*v.AppInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAppInstanceUser struct {
}

func (*awsRestjson1_serializeOpDeleteAppInstanceUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAppInstanceUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAppInstanceUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instance-users/{AppInstanceUserArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAppInstanceUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAppInstanceUserInput(v *DeleteAppInstanceUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceUserArn == nil || len(*v.AppInstanceUserArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceUserArn must not be empty")}
	}
	if v.AppInstanceUserArn != nil {
		if err := encoder.SetURI("AppInstanceUserArn").String(*v.AppInstanceUserArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAppInstance struct {
}

func (*awsRestjson1_serializeOpDescribeAppInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAppInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAppInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instances/{AppInstanceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAppInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAppInstanceInput(v *DescribeAppInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceArn == nil || len(*v.AppInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceArn must not be empty")}
	}
	if v.AppInstanceArn != nil {
		if err := encoder.SetURI("AppInstanceArn").String(*v.AppInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAppInstanceAdmin struct {
}

func (*awsRestjson1_serializeOpDescribeAppInstanceAdmin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAppInstanceAdmin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAppInstanceAdminInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instances/{AppInstanceArn}/admins/{AppInstanceAdminArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAppInstanceAdminInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAppInstanceAdminInput(v *DescribeAppInstanceAdminInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceAdminArn == nil || len(*v.AppInstanceAdminArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceAdminArn must not be empty")}
	}
	if v.AppInstanceAdminArn != nil {
		if err := encoder.SetURI("AppInstanceAdminArn").String(*v.AppInstanceAdminArn); err != nil {
			return err
		}
	}

	if v.AppInstanceArn == nil || len(*v.AppInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceArn must not be empty")}
	}
	if v.AppInstanceArn != nil {
		if err := encoder.SetURI("AppInstanceArn").String(*v.AppInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAppInstanceUser struct {
}

func (*awsRestjson1_serializeOpDescribeAppInstanceUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAppInstanceUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAppInstanceUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instance-users/{AppInstanceUserArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAppInstanceUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAppInstanceUserInput(v *DescribeAppInstanceUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceUserArn == nil || len(*v.AppInstanceUserArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceUserArn must not be empty")}
	}
	if v.AppInstanceUserArn != nil {
		if err := encoder.SetURI("AppInstanceUserArn").String(*v.AppInstanceUserArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetAppInstanceRetentionSettings struct {
}

func (*awsRestjson1_serializeOpGetAppInstanceRetentionSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAppInstanceRetentionSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAppInstanceRetentionSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instances/{AppInstanceArn}/retention-settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAppInstanceRetentionSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAppInstanceRetentionSettingsInput(v *GetAppInstanceRetentionSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceArn == nil || len(*v.AppInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceArn must not be empty")}
	}
	if v.AppInstanceArn != nil {
		if err := encoder.SetURI("AppInstanceArn").String(*v.AppInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAppInstanceAdmins struct {
}

func (*awsRestjson1_serializeOpListAppInstanceAdmins) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAppInstanceAdmins) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAppInstanceAdminsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instances/{AppInstanceArn}/admins")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAppInstanceAdminsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAppInstanceAdminsInput(v *ListAppInstanceAdminsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceArn == nil || len(*v.AppInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceArn must not be empty")}
	}
	if v.AppInstanceArn != nil {
		if err := encoder.SetURI("AppInstanceArn").String(*v.AppInstanceArn); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListAppInstances struct {
}

func (*awsRestjson1_serializeOpListAppInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAppInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAppInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAppInstancesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAppInstancesInput(v *ListAppInstancesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListAppInstanceUsers struct {
}

func (*awsRestjson1_serializeOpListAppInstanceUsers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAppInstanceUsers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAppInstanceUsersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instance-users")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAppInstanceUsersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAppInstanceUsersInput(v *ListAppInstanceUsersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceArn != nil {
		encoder.SetQuery("app-instance-arn").String(*v.AppInstanceArn)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpPutAppInstanceRetentionSettings struct {
}

func (*awsRestjson1_serializeOpPutAppInstanceRetentionSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutAppInstanceRetentionSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAppInstanceRetentionSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instances/{AppInstanceArn}/retention-settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutAppInstanceRetentionSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutAppInstanceRetentionSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutAppInstanceRetentionSettingsInput(v *PutAppInstanceRetentionSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceArn == nil || len(*v.AppInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceArn must not be empty")}
	}
	if v.AppInstanceArn != nil {
		if err := encoder.SetURI("AppInstanceArn").String(*v.AppInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutAppInstanceRetentionSettingsInput(v *PutAppInstanceRetentionSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppInstanceRetentionSettings != nil {
		ok := object.Key("AppInstanceRetentionSettings")
		if err := awsRestjson1_serializeDocumentAppInstanceRetentionSettings(v.AppInstanceRetentionSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAppInstance struct {
}

func (*awsRestjson1_serializeOpUpdateAppInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAppInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAppInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instances/{AppInstanceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAppInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAppInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAppInstanceInput(v *UpdateAppInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceArn == nil || len(*v.AppInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceArn must not be empty")}
	}
	if v.AppInstanceArn != nil {
		if err := encoder.SetURI("AppInstanceArn").String(*v.AppInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAppInstanceInput(v *UpdateAppInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Metadata != nil {
		ok := object.Key("Metadata")
		ok.String(*v.Metadata)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAppInstanceUser struct {
}

func (*awsRestjson1_serializeOpUpdateAppInstanceUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAppInstanceUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAppInstanceUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app-instance-users/{AppInstanceUserArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAppInstanceUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAppInstanceUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAppInstanceUserInput(v *UpdateAppInstanceUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppInstanceUserArn == nil || len(*v.AppInstanceUserArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppInstanceUserArn must not be empty")}
	}
	if v.AppInstanceUserArn != nil {
		if err := encoder.SetURI("AppInstanceUserArn").String(*v.AppInstanceUserArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAppInstanceUserInput(v *UpdateAppInstanceUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Metadata != nil {
		ok := object.Key("Metadata")
		ok.String(*v.Metadata)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAppInstanceRetentionSettings(v *types.AppInstanceRetentionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelRetentionSettings != nil {
		ok := object.Key("ChannelRetentionSettings")
		if err := awsRestjson1_serializeDocumentChannelRetentionSettings(v.ChannelRetentionSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentChannelRetentionSettings(v *types.ChannelRetentionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RetentionDays != nil {
		ok := object.Key("RetentionDays")
		ok.Integer(*v.RetentionDays)
	}

	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}
