// Code generated by smithy-go-codegen DO NOT EDIT.

package auditmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/auditmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the evidence folders from a specified assessment in Audit Manager.
func (c *Client) GetEvidenceFoldersByAssessment(ctx context.Context, params *GetEvidenceFoldersByAssessmentInput, optFns ...func(*Options)) (*GetEvidenceFoldersByAssessmentOutput, error) {
	if params == nil {
		params = &GetEvidenceFoldersByAssessmentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEvidenceFoldersByAssessment", params, optFns, c.addOperationGetEvidenceFoldersByAssessmentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEvidenceFoldersByAssessmentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEvidenceFoldersByAssessmentInput struct {

	// The identifier for the specified assessment.
	//
	// This member is required.
	AssessmentId *string

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int32

	// The pagination token used to fetch the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetEvidenceFoldersByAssessmentOutput struct {

	// The list of evidence folders returned by the GetEvidenceFoldersByAssessment API.
	EvidenceFolders []types.AssessmentEvidenceFolder

	// The pagination token used to fetch the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEvidenceFoldersByAssessmentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetEvidenceFoldersByAssessment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetEvidenceFoldersByAssessment{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetEvidenceFoldersByAssessmentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEvidenceFoldersByAssessment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// GetEvidenceFoldersByAssessmentAPIClient is a client that implements the
// GetEvidenceFoldersByAssessment operation.
type GetEvidenceFoldersByAssessmentAPIClient interface {
	GetEvidenceFoldersByAssessment(context.Context, *GetEvidenceFoldersByAssessmentInput, ...func(*Options)) (*GetEvidenceFoldersByAssessmentOutput, error)
}

var _ GetEvidenceFoldersByAssessmentAPIClient = (*Client)(nil)

// GetEvidenceFoldersByAssessmentPaginatorOptions is the paginator options for
// GetEvidenceFoldersByAssessment
type GetEvidenceFoldersByAssessmentPaginatorOptions struct {
	// Represents the maximum number of results per page, or per API request call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetEvidenceFoldersByAssessmentPaginator is a paginator for
// GetEvidenceFoldersByAssessment
type GetEvidenceFoldersByAssessmentPaginator struct {
	options   GetEvidenceFoldersByAssessmentPaginatorOptions
	client    GetEvidenceFoldersByAssessmentAPIClient
	params    *GetEvidenceFoldersByAssessmentInput
	nextToken *string
	firstPage bool
}

// NewGetEvidenceFoldersByAssessmentPaginator returns a new
// GetEvidenceFoldersByAssessmentPaginator
func NewGetEvidenceFoldersByAssessmentPaginator(client GetEvidenceFoldersByAssessmentAPIClient, params *GetEvidenceFoldersByAssessmentInput, optFns ...func(*GetEvidenceFoldersByAssessmentPaginatorOptions)) *GetEvidenceFoldersByAssessmentPaginator {
	if params == nil {
		params = &GetEvidenceFoldersByAssessmentInput{}
	}

	options := GetEvidenceFoldersByAssessmentPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetEvidenceFoldersByAssessmentPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetEvidenceFoldersByAssessmentPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next GetEvidenceFoldersByAssessment page.
func (p *GetEvidenceFoldersByAssessmentPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetEvidenceFoldersByAssessmentOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.GetEvidenceFoldersByAssessment(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetEvidenceFoldersByAssessment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "auditmanager",
		OperationName: "GetEvidenceFoldersByAssessment",
	}
}
