// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAcceptAdministratorInvitation struct {
}

func (*awsRestjson1_serializeOpAcceptAdministratorInvitation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAcceptAdministratorInvitation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptAdministratorInvitationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/administrator")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAcceptAdministratorInvitationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAcceptAdministratorInvitationInput(v *AcceptAdministratorInvitationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAcceptAdministratorInvitationInput(v *AcceptAdministratorInvitationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdministratorId != nil {
		ok := object.Key("AdministratorId")
		ok.String(*v.AdministratorId)
	}

	if v.InvitationId != nil {
		ok := object.Key("InvitationId")
		ok.String(*v.InvitationId)
	}

	return nil
}

type awsRestjson1_serializeOpAcceptInvitation struct {
}

func (*awsRestjson1_serializeOpAcceptInvitation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAcceptInvitation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptInvitationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/master")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAcceptInvitationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAcceptInvitationInput(v *AcceptInvitationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAcceptInvitationInput(v *AcceptInvitationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InvitationId != nil {
		ok := object.Key("InvitationId")
		ok.String(*v.InvitationId)
	}

	if v.MasterId != nil {
		ok := object.Key("MasterId")
		ok.String(*v.MasterId)
	}

	return nil
}

type awsRestjson1_serializeOpBatchDisableStandards struct {
}

func (*awsRestjson1_serializeOpBatchDisableStandards) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDisableStandards) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDisableStandardsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/standards/deregister")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDisableStandardsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDisableStandardsInput(v *BatchDisableStandardsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDisableStandardsInput(v *BatchDisableStandardsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StandardsSubscriptionArns != nil {
		ok := object.Key("StandardsSubscriptionArns")
		if err := awsRestjson1_serializeDocumentStandardsSubscriptionArns(v.StandardsSubscriptionArns, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchEnableStandards struct {
}

func (*awsRestjson1_serializeOpBatchEnableStandards) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchEnableStandards) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchEnableStandardsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/standards/register")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchEnableStandardsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchEnableStandardsInput(v *BatchEnableStandardsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchEnableStandardsInput(v *BatchEnableStandardsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StandardsSubscriptionRequests != nil {
		ok := object.Key("StandardsSubscriptionRequests")
		if err := awsRestjson1_serializeDocumentStandardsSubscriptionRequests(v.StandardsSubscriptionRequests, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchImportFindings struct {
}

func (*awsRestjson1_serializeOpBatchImportFindings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchImportFindings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchImportFindingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/findings/import")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchImportFindingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchImportFindingsInput(v *BatchImportFindingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchImportFindingsInput(v *BatchImportFindingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Findings != nil {
		ok := object.Key("Findings")
		if err := awsRestjson1_serializeDocumentBatchImportFindingsRequestFindingList(v.Findings, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchUpdateFindings struct {
}

func (*awsRestjson1_serializeOpBatchUpdateFindings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchUpdateFindings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchUpdateFindingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/findings/batchupdate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchUpdateFindingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchUpdateFindingsInput(v *BatchUpdateFindingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchUpdateFindingsInput(v *BatchUpdateFindingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Confidence != 0 {
		ok := object.Key("Confidence")
		ok.Integer(v.Confidence)
	}

	if v.Criticality != 0 {
		ok := object.Key("Criticality")
		ok.Integer(v.Criticality)
	}

	if v.FindingIdentifiers != nil {
		ok := object.Key("FindingIdentifiers")
		if err := awsRestjson1_serializeDocumentAwsSecurityFindingIdentifierList(v.FindingIdentifiers, ok); err != nil {
			return err
		}
	}

	if v.Note != nil {
		ok := object.Key("Note")
		if err := awsRestjson1_serializeDocumentNoteUpdate(v.Note, ok); err != nil {
			return err
		}
	}

	if v.RelatedFindings != nil {
		ok := object.Key("RelatedFindings")
		if err := awsRestjson1_serializeDocumentRelatedFindingList(v.RelatedFindings, ok); err != nil {
			return err
		}
	}

	if v.Severity != nil {
		ok := object.Key("Severity")
		if err := awsRestjson1_serializeDocumentSeverityUpdate(v.Severity, ok); err != nil {
			return err
		}
	}

	if v.Types != nil {
		ok := object.Key("Types")
		if err := awsRestjson1_serializeDocumentTypeList(v.Types, ok); err != nil {
			return err
		}
	}

	if v.UserDefinedFields != nil {
		ok := object.Key("UserDefinedFields")
		if err := awsRestjson1_serializeDocumentFieldMap(v.UserDefinedFields, ok); err != nil {
			return err
		}
	}

	if len(v.VerificationState) > 0 {
		ok := object.Key("VerificationState")
		ok.String(string(v.VerificationState))
	}

	if v.Workflow != nil {
		ok := object.Key("Workflow")
		if err := awsRestjson1_serializeDocumentWorkflowUpdate(v.Workflow, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateActionTarget struct {
}

func (*awsRestjson1_serializeOpCreateActionTarget) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateActionTarget) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateActionTargetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/actionTargets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateActionTargetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateActionTargetInput(v *CreateActionTargetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateActionTargetInput(v *CreateActionTargetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpCreateInsight struct {
}

func (*awsRestjson1_serializeOpCreateInsight) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateInsight) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInsightInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/insights")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateInsightInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateInsightInput(v *CreateInsightInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateInsightInput(v *CreateInsightInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentAwsSecurityFindingFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.GroupByAttribute != nil {
		ok := object.Key("GroupByAttribute")
		ok.String(*v.GroupByAttribute)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpCreateMembers struct {
}

func (*awsRestjson1_serializeOpCreateMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/members")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMembersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMembersInput(v *CreateMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMembersInput(v *CreateMembersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountDetails != nil {
		ok := object.Key("AccountDetails")
		if err := awsRestjson1_serializeDocumentAccountDetailsList(v.AccountDetails, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeclineInvitations struct {
}

func (*awsRestjson1_serializeOpDeclineInvitations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeclineInvitations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeclineInvitationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/invitations/decline")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeclineInvitationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeclineInvitationsInput(v *DeclineInvitationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeclineInvitationsInput(v *DeclineInvitationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("AccountIds")
		if err := awsRestjson1_serializeDocumentAccountIdList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteActionTarget struct {
}

func (*awsRestjson1_serializeOpDeleteActionTarget) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteActionTarget) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteActionTargetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/actionTargets/{ActionTargetArn+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteActionTargetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteActionTargetInput(v *DeleteActionTargetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ActionTargetArn == nil || len(*v.ActionTargetArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ActionTargetArn must not be empty")}
	}
	if v.ActionTargetArn != nil {
		if err := encoder.SetURI("ActionTargetArn").String(*v.ActionTargetArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteInsight struct {
}

func (*awsRestjson1_serializeOpDeleteInsight) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteInsight) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInsightInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/insights/{InsightArn+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteInsightInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteInsightInput(v *DeleteInsightInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InsightArn == nil || len(*v.InsightArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InsightArn must not be empty")}
	}
	if v.InsightArn != nil {
		if err := encoder.SetURI("InsightArn").String(*v.InsightArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteInvitations struct {
}

func (*awsRestjson1_serializeOpDeleteInvitations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteInvitations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInvitationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/invitations/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteInvitationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteInvitationsInput(v *DeleteInvitationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteInvitationsInput(v *DeleteInvitationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("AccountIds")
		if err := awsRestjson1_serializeDocumentAccountIdList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMembers struct {
}

func (*awsRestjson1_serializeOpDeleteMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/members/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteMembersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMembersInput(v *DeleteMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteMembersInput(v *DeleteMembersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("AccountIds")
		if err := awsRestjson1_serializeDocumentAccountIdList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeActionTargets struct {
}

func (*awsRestjson1_serializeOpDescribeActionTargets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeActionTargets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeActionTargetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/actionTargets/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeActionTargetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeActionTargetsInput(v *DescribeActionTargetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeActionTargetsInput(v *DescribeActionTargetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionTargetArns != nil {
		ok := object.Key("ActionTargetArns")
		if err := awsRestjson1_serializeDocumentArnList(v.ActionTargetArns, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeHub struct {
}

func (*awsRestjson1_serializeOpDescribeHub) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeHub) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeHubInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeHubInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeHubInput(v *DescribeHubInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.HubArn != nil {
		encoder.SetQuery("HubArn").String(*v.HubArn)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeOrganizationConfiguration struct {
}

func (*awsRestjson1_serializeOpDescribeOrganizationConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeOrganizationConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeOrganizationConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/organization/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeOrganizationConfigurationInput(v *DescribeOrganizationConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeProducts struct {
}

func (*awsRestjson1_serializeOpDescribeProducts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeProducts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeProductsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/products")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeProductsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeProductsInput(v *DescribeProductsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.ProductArn != nil {
		encoder.SetQuery("ProductArn").String(*v.ProductArn)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeStandards struct {
}

func (*awsRestjson1_serializeOpDescribeStandards) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeStandards) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeStandardsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/standards")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeStandardsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeStandardsInput(v *DescribeStandardsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeStandardsControls struct {
}

func (*awsRestjson1_serializeOpDescribeStandardsControls) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeStandardsControls) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeStandardsControlsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/standards/controls/{StandardsSubscriptionArn+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeStandardsControlsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeStandardsControlsInput(v *DescribeStandardsControlsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.StandardsSubscriptionArn == nil || len(*v.StandardsSubscriptionArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StandardsSubscriptionArn must not be empty")}
	}
	if v.StandardsSubscriptionArn != nil {
		if err := encoder.SetURI("StandardsSubscriptionArn").String(*v.StandardsSubscriptionArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisableImportFindingsForProduct struct {
}

func (*awsRestjson1_serializeOpDisableImportFindingsForProduct) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisableImportFindingsForProduct) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableImportFindingsForProductInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/productSubscriptions/{ProductSubscriptionArn+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisableImportFindingsForProductInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisableImportFindingsForProductInput(v *DisableImportFindingsForProductInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ProductSubscriptionArn == nil || len(*v.ProductSubscriptionArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ProductSubscriptionArn must not be empty")}
	}
	if v.ProductSubscriptionArn != nil {
		if err := encoder.SetURI("ProductSubscriptionArn").String(*v.ProductSubscriptionArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisableOrganizationAdminAccount struct {
}

func (*awsRestjson1_serializeOpDisableOrganizationAdminAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisableOrganizationAdminAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableOrganizationAdminAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/organization/admin/disable")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDisableOrganizationAdminAccountInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisableOrganizationAdminAccountInput(v *DisableOrganizationAdminAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDisableOrganizationAdminAccountInput(v *DisableOrganizationAdminAccountInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdminAccountId != nil {
		ok := object.Key("AdminAccountId")
		ok.String(*v.AdminAccountId)
	}

	return nil
}

type awsRestjson1_serializeOpDisableSecurityHub struct {
}

func (*awsRestjson1_serializeOpDisableSecurityHub) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisableSecurityHub) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableSecurityHubInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisableSecurityHubInput(v *DisableSecurityHubInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateFromAdministratorAccount struct {
}

func (*awsRestjson1_serializeOpDisassociateFromAdministratorAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateFromAdministratorAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateFromAdministratorAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/administrator/disassociate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateFromAdministratorAccountInput(v *DisassociateFromAdministratorAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateFromMasterAccount struct {
}

func (*awsRestjson1_serializeOpDisassociateFromMasterAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateFromMasterAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateFromMasterAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/master/disassociate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateFromMasterAccountInput(v *DisassociateFromMasterAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateMembers struct {
}

func (*awsRestjson1_serializeOpDisassociateMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/members/disassociate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDisassociateMembersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateMembersInput(v *DisassociateMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDisassociateMembersInput(v *DisassociateMembersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("AccountIds")
		if err := awsRestjson1_serializeDocumentAccountIdList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpEnableImportFindingsForProduct struct {
}

func (*awsRestjson1_serializeOpEnableImportFindingsForProduct) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpEnableImportFindingsForProduct) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableImportFindingsForProductInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/productSubscriptions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentEnableImportFindingsForProductInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsEnableImportFindingsForProductInput(v *EnableImportFindingsForProductInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentEnableImportFindingsForProductInput(v *EnableImportFindingsForProductInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProductArn != nil {
		ok := object.Key("ProductArn")
		ok.String(*v.ProductArn)
	}

	return nil
}

type awsRestjson1_serializeOpEnableOrganizationAdminAccount struct {
}

func (*awsRestjson1_serializeOpEnableOrganizationAdminAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpEnableOrganizationAdminAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableOrganizationAdminAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/organization/admin/enable")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentEnableOrganizationAdminAccountInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsEnableOrganizationAdminAccountInput(v *EnableOrganizationAdminAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentEnableOrganizationAdminAccountInput(v *EnableOrganizationAdminAccountInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdminAccountId != nil {
		ok := object.Key("AdminAccountId")
		ok.String(*v.AdminAccountId)
	}

	return nil
}

type awsRestjson1_serializeOpEnableSecurityHub struct {
}

func (*awsRestjson1_serializeOpEnableSecurityHub) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpEnableSecurityHub) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableSecurityHubInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentEnableSecurityHubInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsEnableSecurityHubInput(v *EnableSecurityHubInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentEnableSecurityHubInput(v *EnableSecurityHubInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnableDefaultStandards {
		ok := object.Key("EnableDefaultStandards")
		ok.Boolean(v.EnableDefaultStandards)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetAdministratorAccount struct {
}

func (*awsRestjson1_serializeOpGetAdministratorAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAdministratorAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAdministratorAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/administrator")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAdministratorAccountInput(v *GetAdministratorAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetEnabledStandards struct {
}

func (*awsRestjson1_serializeOpGetEnabledStandards) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEnabledStandards) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEnabledStandardsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/standards/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetEnabledStandardsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEnabledStandardsInput(v *GetEnabledStandardsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetEnabledStandardsInput(v *GetEnabledStandardsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.StandardsSubscriptionArns != nil {
		ok := object.Key("StandardsSubscriptionArns")
		if err := awsRestjson1_serializeDocumentStandardsSubscriptionArns(v.StandardsSubscriptionArns, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetFindings struct {
}

func (*awsRestjson1_serializeOpGetFindings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFindings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFindingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/findings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetFindingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFindingsInput(v *GetFindingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetFindingsInput(v *GetFindingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentAwsSecurityFindingFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.SortCriteria != nil {
		ok := object.Key("SortCriteria")
		if err := awsRestjson1_serializeDocumentSortCriteria(v.SortCriteria, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetInsightResults struct {
}

func (*awsRestjson1_serializeOpGetInsightResults) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetInsightResults) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetInsightResultsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/insights/results/{InsightArn+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetInsightResultsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetInsightResultsInput(v *GetInsightResultsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InsightArn == nil || len(*v.InsightArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InsightArn must not be empty")}
	}
	if v.InsightArn != nil {
		if err := encoder.SetURI("InsightArn").String(*v.InsightArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetInsights struct {
}

func (*awsRestjson1_serializeOpGetInsights) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetInsights) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetInsightsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/insights/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetInsightsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetInsightsInput(v *GetInsightsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetInsightsInput(v *GetInsightsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InsightArns != nil {
		ok := object.Key("InsightArns")
		if err := awsRestjson1_serializeDocumentArnList(v.InsightArns, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		ok := object.Key("MaxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetInvitationsCount struct {
}

func (*awsRestjson1_serializeOpGetInvitationsCount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetInvitationsCount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetInvitationsCountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/invitations/count")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetInvitationsCountInput(v *GetInvitationsCountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetMasterAccount struct {
}

func (*awsRestjson1_serializeOpGetMasterAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMasterAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMasterAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/master")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMasterAccountInput(v *GetMasterAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetMembers struct {
}

func (*awsRestjson1_serializeOpGetMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/members/get")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetMembersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMembersInput(v *GetMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetMembersInput(v *GetMembersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("AccountIds")
		if err := awsRestjson1_serializeDocumentAccountIdList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpInviteMembers struct {
}

func (*awsRestjson1_serializeOpInviteMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInviteMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InviteMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/members/invite")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentInviteMembersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInviteMembersInput(v *InviteMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentInviteMembersInput(v *InviteMembersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("AccountIds")
		if err := awsRestjson1_serializeDocumentAccountIdList(v.AccountIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListEnabledProductsForImport struct {
}

func (*awsRestjson1_serializeOpListEnabledProductsForImport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEnabledProductsForImport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEnabledProductsForImportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/productSubscriptions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEnabledProductsForImportInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEnabledProductsForImportInput(v *ListEnabledProductsForImportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListInvitations struct {
}

func (*awsRestjson1_serializeOpListInvitations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInvitations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInvitationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/invitations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListInvitationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInvitationsInput(v *ListInvitationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListMembers struct {
}

func (*awsRestjson1_serializeOpListMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/members")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMembersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMembersInput(v *ListMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.OnlyAssociated {
		encoder.SetQuery("OnlyAssociated").Boolean(v.OnlyAssociated)
	}

	return nil
}

type awsRestjson1_serializeOpListOrganizationAdminAccounts struct {
}

func (*awsRestjson1_serializeOpListOrganizationAdminAccounts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListOrganizationAdminAccounts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListOrganizationAdminAccountsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/organization/admin")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListOrganizationAdminAccountsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListOrganizationAdminAccountsInput(v *ListOrganizationAdminAccountsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("MaxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateActionTarget struct {
}

func (*awsRestjson1_serializeOpUpdateActionTarget) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateActionTarget) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateActionTargetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/actionTargets/{ActionTargetArn+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateActionTargetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateActionTargetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateActionTargetInput(v *UpdateActionTargetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ActionTargetArn == nil || len(*v.ActionTargetArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ActionTargetArn must not be empty")}
	}
	if v.ActionTargetArn != nil {
		if err := encoder.SetURI("ActionTargetArn").String(*v.ActionTargetArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateActionTargetInput(v *UpdateActionTargetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFindings struct {
}

func (*awsRestjson1_serializeOpUpdateFindings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFindings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFindingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/findings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFindingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFindingsInput(v *UpdateFindingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFindingsInput(v *UpdateFindingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentAwsSecurityFindingFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.Note != nil {
		ok := object.Key("Note")
		if err := awsRestjson1_serializeDocumentNoteUpdate(v.Note, ok); err != nil {
			return err
		}
	}

	if len(v.RecordState) > 0 {
		ok := object.Key("RecordState")
		ok.String(string(v.RecordState))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateInsight struct {
}

func (*awsRestjson1_serializeOpUpdateInsight) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateInsight) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateInsightInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/insights/{InsightArn+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateInsightInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateInsightInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateInsightInput(v *UpdateInsightInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InsightArn == nil || len(*v.InsightArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InsightArn must not be empty")}
	}
	if v.InsightArn != nil {
		if err := encoder.SetURI("InsightArn").String(*v.InsightArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateInsightInput(v *UpdateInsightInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentAwsSecurityFindingFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.GroupByAttribute != nil {
		ok := object.Key("GroupByAttribute")
		ok.String(*v.GroupByAttribute)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateOrganizationConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateOrganizationConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateOrganizationConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateOrganizationConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/organization/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateOrganizationConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateOrganizationConfigurationInput(v *UpdateOrganizationConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateOrganizationConfigurationInput(v *UpdateOrganizationConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("AutoEnable")
		ok.Boolean(v.AutoEnable)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSecurityHubConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateSecurityHubConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSecurityHubConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSecurityHubConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSecurityHubConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSecurityHubConfigurationInput(v *UpdateSecurityHubConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSecurityHubConfigurationInput(v *UpdateSecurityHubConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoEnableControls {
		ok := object.Key("AutoEnableControls")
		ok.Boolean(v.AutoEnableControls)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateStandardsControl struct {
}

func (*awsRestjson1_serializeOpUpdateStandardsControl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateStandardsControl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStandardsControlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/standards/control/{StandardsControlArn+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateStandardsControlInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateStandardsControlInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateStandardsControlInput(v *UpdateStandardsControlInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.StandardsControlArn == nil || len(*v.StandardsControlArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StandardsControlArn must not be empty")}
	}
	if v.StandardsControlArn != nil {
		if err := encoder.SetURI("StandardsControlArn").String(*v.StandardsControlArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateStandardsControlInput(v *UpdateStandardsControlInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ControlStatus) > 0 {
		ok := object.Key("ControlStatus")
		ok.String(string(v.ControlStatus))
	}

	if v.DisabledReason != nil {
		ok := object.Key("DisabledReason")
		ok.String(*v.DisabledReason)
	}

	return nil
}

func awsRestjson1_serializeDocumentAccountDetails(v *types.AccountDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("AccountId")
		ok.String(*v.AccountId)
	}

	if v.Email != nil {
		ok := object.Key("Email")
		ok.String(*v.Email)
	}

	return nil
}

func awsRestjson1_serializeDocumentAccountDetailsList(v []types.AccountDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAccountDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAccountIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAction(v *types.Action, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionType != nil {
		ok := object.Key("ActionType")
		ok.String(*v.ActionType)
	}

	if v.AwsApiCallAction != nil {
		ok := object.Key("AwsApiCallAction")
		if err := awsRestjson1_serializeDocumentAwsApiCallAction(v.AwsApiCallAction, ok); err != nil {
			return err
		}
	}

	if v.DnsRequestAction != nil {
		ok := object.Key("DnsRequestAction")
		if err := awsRestjson1_serializeDocumentDnsRequestAction(v.DnsRequestAction, ok); err != nil {
			return err
		}
	}

	if v.NetworkConnectionAction != nil {
		ok := object.Key("NetworkConnectionAction")
		if err := awsRestjson1_serializeDocumentNetworkConnectionAction(v.NetworkConnectionAction, ok); err != nil {
			return err
		}
	}

	if v.PortProbeAction != nil {
		ok := object.Key("PortProbeAction")
		if err := awsRestjson1_serializeDocumentPortProbeAction(v.PortProbeAction, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentActionLocalIpDetails(v *types.ActionLocalIpDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IpAddressV4 != nil {
		ok := object.Key("IpAddressV4")
		ok.String(*v.IpAddressV4)
	}

	return nil
}

func awsRestjson1_serializeDocumentActionLocalPortDetails(v *types.ActionLocalPortDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Port != 0 {
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	if v.PortName != nil {
		ok := object.Key("PortName")
		ok.String(*v.PortName)
	}

	return nil
}

func awsRestjson1_serializeDocumentActionRemoteIpDetails(v *types.ActionRemoteIpDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.City != nil {
		ok := object.Key("City")
		if err := awsRestjson1_serializeDocumentCity(v.City, ok); err != nil {
			return err
		}
	}

	if v.Country != nil {
		ok := object.Key("Country")
		if err := awsRestjson1_serializeDocumentCountry(v.Country, ok); err != nil {
			return err
		}
	}

	if v.GeoLocation != nil {
		ok := object.Key("GeoLocation")
		if err := awsRestjson1_serializeDocumentGeoLocation(v.GeoLocation, ok); err != nil {
			return err
		}
	}

	if v.IpAddressV4 != nil {
		ok := object.Key("IpAddressV4")
		ok.String(*v.IpAddressV4)
	}

	if v.Organization != nil {
		ok := object.Key("Organization")
		if err := awsRestjson1_serializeDocumentIpOrganizationDetails(v.Organization, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentActionRemotePortDetails(v *types.ActionRemotePortDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Port != 0 {
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	if v.PortName != nil {
		ok := object.Key("PortName")
		ok.String(*v.PortName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAdjustment(v *types.Adjustment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Metric != nil {
		ok := object.Key("Metric")
		ok.String(*v.Metric)
	}

	if v.Reason != nil {
		ok := object.Key("Reason")
		ok.String(*v.Reason)
	}

	return nil
}

func awsRestjson1_serializeDocumentAdjustmentList(v []types.Adjustment, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAdjustment(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAvailabilityZone(v *types.AvailabilityZone, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SubnetId != nil {
		ok := object.Key("SubnetId")
		ok.String(*v.SubnetId)
	}

	if v.ZoneName != nil {
		ok := object.Key("ZoneName")
		ok.String(*v.ZoneName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAvailabilityZones(v []types.AvailabilityZone, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAvailabilityZone(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsApiCallAction(v *types.AwsApiCallAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AffectedResources != nil {
		ok := object.Key("AffectedResources")
		if err := awsRestjson1_serializeDocumentFieldMap(v.AffectedResources, ok); err != nil {
			return err
		}
	}

	if v.Api != nil {
		ok := object.Key("Api")
		ok.String(*v.Api)
	}

	if v.CallerType != nil {
		ok := object.Key("CallerType")
		ok.String(*v.CallerType)
	}

	if v.DomainDetails != nil {
		ok := object.Key("DomainDetails")
		if err := awsRestjson1_serializeDocumentAwsApiCallActionDomainDetails(v.DomainDetails, ok); err != nil {
			return err
		}
	}

	if v.FirstSeen != nil {
		ok := object.Key("FirstSeen")
		ok.String(*v.FirstSeen)
	}

	if v.LastSeen != nil {
		ok := object.Key("LastSeen")
		ok.String(*v.LastSeen)
	}

	if v.RemoteIpDetails != nil {
		ok := object.Key("RemoteIpDetails")
		if err := awsRestjson1_serializeDocumentActionRemoteIpDetails(v.RemoteIpDetails, ok); err != nil {
			return err
		}
	}

	if v.ServiceName != nil {
		ok := object.Key("ServiceName")
		ok.String(*v.ServiceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsApiCallActionDomainDetails(v *types.AwsApiCallActionDomainDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsApiGatewayAccessLogSettings(v *types.AwsApiGatewayAccessLogSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationArn != nil {
		ok := object.Key("DestinationArn")
		ok.String(*v.DestinationArn)
	}

	if v.Format != nil {
		ok := object.Key("Format")
		ok.String(*v.Format)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsApiGatewayCanarySettings(v *types.AwsApiGatewayCanarySettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeploymentId != nil {
		ok := object.Key("DeploymentId")
		ok.String(*v.DeploymentId)
	}

	if v.PercentTraffic != 0 {
		ok := object.Key("PercentTraffic")
		switch {
		case math.IsNaN(v.PercentTraffic):
			ok.String("NaN")

		case math.IsInf(v.PercentTraffic, 1):
			ok.String("Infinity")

		case math.IsInf(v.PercentTraffic, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.PercentTraffic)

		}
	}

	if v.StageVariableOverrides != nil {
		ok := object.Key("StageVariableOverrides")
		if err := awsRestjson1_serializeDocumentFieldMap(v.StageVariableOverrides, ok); err != nil {
			return err
		}
	}

	if v.UseStageCache {
		ok := object.Key("UseStageCache")
		ok.Boolean(v.UseStageCache)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsApiGatewayEndpointConfiguration(v *types.AwsApiGatewayEndpointConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Types != nil {
		ok := object.Key("Types")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Types, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsApiGatewayMethodSettings(v *types.AwsApiGatewayMethodSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CacheDataEncrypted {
		ok := object.Key("CacheDataEncrypted")
		ok.Boolean(v.CacheDataEncrypted)
	}

	if v.CacheTtlInSeconds != 0 {
		ok := object.Key("CacheTtlInSeconds")
		ok.Integer(v.CacheTtlInSeconds)
	}

	if v.CachingEnabled {
		ok := object.Key("CachingEnabled")
		ok.Boolean(v.CachingEnabled)
	}

	if v.DataTraceEnabled {
		ok := object.Key("DataTraceEnabled")
		ok.Boolean(v.DataTraceEnabled)
	}

	if v.HttpMethod != nil {
		ok := object.Key("HttpMethod")
		ok.String(*v.HttpMethod)
	}

	if v.LoggingLevel != nil {
		ok := object.Key("LoggingLevel")
		ok.String(*v.LoggingLevel)
	}

	if v.MetricsEnabled {
		ok := object.Key("MetricsEnabled")
		ok.Boolean(v.MetricsEnabled)
	}

	if v.RequireAuthorizationForCacheControl {
		ok := object.Key("RequireAuthorizationForCacheControl")
		ok.Boolean(v.RequireAuthorizationForCacheControl)
	}

	if v.ResourcePath != nil {
		ok := object.Key("ResourcePath")
		ok.String(*v.ResourcePath)
	}

	if v.ThrottlingBurstLimit != 0 {
		ok := object.Key("ThrottlingBurstLimit")
		ok.Integer(v.ThrottlingBurstLimit)
	}

	if v.ThrottlingRateLimit != 0 {
		ok := object.Key("ThrottlingRateLimit")
		switch {
		case math.IsNaN(v.ThrottlingRateLimit):
			ok.String("NaN")

		case math.IsInf(v.ThrottlingRateLimit, 1):
			ok.String("Infinity")

		case math.IsInf(v.ThrottlingRateLimit, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.ThrottlingRateLimit)

		}
	}

	if v.UnauthorizedCacheControlHeaderStrategy != nil {
		ok := object.Key("UnauthorizedCacheControlHeaderStrategy")
		ok.String(*v.UnauthorizedCacheControlHeaderStrategy)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsApiGatewayMethodSettingsList(v []types.AwsApiGatewayMethodSettings, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsApiGatewayMethodSettings(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsApiGatewayRestApiDetails(v *types.AwsApiGatewayRestApiDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKeySource != nil {
		ok := object.Key("ApiKeySource")
		ok.String(*v.ApiKeySource)
	}

	if v.BinaryMediaTypes != nil {
		ok := object.Key("BinaryMediaTypes")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.BinaryMediaTypes, ok); err != nil {
			return err
		}
	}

	if v.CreatedDate != nil {
		ok := object.Key("CreatedDate")
		ok.String(*v.CreatedDate)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EndpointConfiguration != nil {
		ok := object.Key("EndpointConfiguration")
		if err := awsRestjson1_serializeDocumentAwsApiGatewayEndpointConfiguration(v.EndpointConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.MinimumCompressionSize != 0 {
		ok := object.Key("MinimumCompressionSize")
		ok.Integer(v.MinimumCompressionSize)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsApiGatewayStageDetails(v *types.AwsApiGatewayStageDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessLogSettings != nil {
		ok := object.Key("AccessLogSettings")
		if err := awsRestjson1_serializeDocumentAwsApiGatewayAccessLogSettings(v.AccessLogSettings, ok); err != nil {
			return err
		}
	}

	if v.CacheClusterEnabled {
		ok := object.Key("CacheClusterEnabled")
		ok.Boolean(v.CacheClusterEnabled)
	}

	if v.CacheClusterSize != nil {
		ok := object.Key("CacheClusterSize")
		ok.String(*v.CacheClusterSize)
	}

	if v.CacheClusterStatus != nil {
		ok := object.Key("CacheClusterStatus")
		ok.String(*v.CacheClusterStatus)
	}

	if v.CanarySettings != nil {
		ok := object.Key("CanarySettings")
		if err := awsRestjson1_serializeDocumentAwsApiGatewayCanarySettings(v.CanarySettings, ok); err != nil {
			return err
		}
	}

	if v.ClientCertificateId != nil {
		ok := object.Key("ClientCertificateId")
		ok.String(*v.ClientCertificateId)
	}

	if v.CreatedDate != nil {
		ok := object.Key("CreatedDate")
		ok.String(*v.CreatedDate)
	}

	if v.DeploymentId != nil {
		ok := object.Key("DeploymentId")
		ok.String(*v.DeploymentId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.DocumentationVersion != nil {
		ok := object.Key("DocumentationVersion")
		ok.String(*v.DocumentationVersion)
	}

	if v.LastUpdatedDate != nil {
		ok := object.Key("LastUpdatedDate")
		ok.String(*v.LastUpdatedDate)
	}

	if v.MethodSettings != nil {
		ok := object.Key("MethodSettings")
		if err := awsRestjson1_serializeDocumentAwsApiGatewayMethodSettingsList(v.MethodSettings, ok); err != nil {
			return err
		}
	}

	if v.StageName != nil {
		ok := object.Key("StageName")
		ok.String(*v.StageName)
	}

	if v.TracingEnabled {
		ok := object.Key("TracingEnabled")
		ok.Boolean(v.TracingEnabled)
	}

	if v.Variables != nil {
		ok := object.Key("Variables")
		if err := awsRestjson1_serializeDocumentFieldMap(v.Variables, ok); err != nil {
			return err
		}
	}

	if v.WebAclArn != nil {
		ok := object.Key("WebAclArn")
		ok.String(*v.WebAclArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsApiGatewayV2ApiDetails(v *types.AwsApiGatewayV2ApiDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiEndpoint != nil {
		ok := object.Key("ApiEndpoint")
		ok.String(*v.ApiEndpoint)
	}

	if v.ApiId != nil {
		ok := object.Key("ApiId")
		ok.String(*v.ApiId)
	}

	if v.ApiKeySelectionExpression != nil {
		ok := object.Key("ApiKeySelectionExpression")
		ok.String(*v.ApiKeySelectionExpression)
	}

	if v.CorsConfiguration != nil {
		ok := object.Key("CorsConfiguration")
		if err := awsRestjson1_serializeDocumentAwsCorsConfiguration(v.CorsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CreatedDate != nil {
		ok := object.Key("CreatedDate")
		ok.String(*v.CreatedDate)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ProtocolType != nil {
		ok := object.Key("ProtocolType")
		ok.String(*v.ProtocolType)
	}

	if v.RouteSelectionExpression != nil {
		ok := object.Key("RouteSelectionExpression")
		ok.String(*v.RouteSelectionExpression)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsApiGatewayV2RouteSettings(v *types.AwsApiGatewayV2RouteSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataTraceEnabled {
		ok := object.Key("DataTraceEnabled")
		ok.Boolean(v.DataTraceEnabled)
	}

	if v.DetailedMetricsEnabled {
		ok := object.Key("DetailedMetricsEnabled")
		ok.Boolean(v.DetailedMetricsEnabled)
	}

	if v.LoggingLevel != nil {
		ok := object.Key("LoggingLevel")
		ok.String(*v.LoggingLevel)
	}

	if v.ThrottlingBurstLimit != 0 {
		ok := object.Key("ThrottlingBurstLimit")
		ok.Integer(v.ThrottlingBurstLimit)
	}

	if v.ThrottlingRateLimit != 0 {
		ok := object.Key("ThrottlingRateLimit")
		switch {
		case math.IsNaN(v.ThrottlingRateLimit):
			ok.String("NaN")

		case math.IsInf(v.ThrottlingRateLimit, 1):
			ok.String("Infinity")

		case math.IsInf(v.ThrottlingRateLimit, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.ThrottlingRateLimit)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsApiGatewayV2StageDetails(v *types.AwsApiGatewayV2StageDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessLogSettings != nil {
		ok := object.Key("AccessLogSettings")
		if err := awsRestjson1_serializeDocumentAwsApiGatewayAccessLogSettings(v.AccessLogSettings, ok); err != nil {
			return err
		}
	}

	if v.ApiGatewayManaged {
		ok := object.Key("ApiGatewayManaged")
		ok.Boolean(v.ApiGatewayManaged)
	}

	if v.AutoDeploy {
		ok := object.Key("AutoDeploy")
		ok.Boolean(v.AutoDeploy)
	}

	if v.ClientCertificateId != nil {
		ok := object.Key("ClientCertificateId")
		ok.String(*v.ClientCertificateId)
	}

	if v.CreatedDate != nil {
		ok := object.Key("CreatedDate")
		ok.String(*v.CreatedDate)
	}

	if v.DefaultRouteSettings != nil {
		ok := object.Key("DefaultRouteSettings")
		if err := awsRestjson1_serializeDocumentAwsApiGatewayV2RouteSettings(v.DefaultRouteSettings, ok); err != nil {
			return err
		}
	}

	if v.DeploymentId != nil {
		ok := object.Key("DeploymentId")
		ok.String(*v.DeploymentId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.LastDeploymentStatusMessage != nil {
		ok := object.Key("LastDeploymentStatusMessage")
		ok.String(*v.LastDeploymentStatusMessage)
	}

	if v.LastUpdatedDate != nil {
		ok := object.Key("LastUpdatedDate")
		ok.String(*v.LastUpdatedDate)
	}

	if v.RouteSettings != nil {
		ok := object.Key("RouteSettings")
		if err := awsRestjson1_serializeDocumentAwsApiGatewayV2RouteSettings(v.RouteSettings, ok); err != nil {
			return err
		}
	}

	if v.StageName != nil {
		ok := object.Key("StageName")
		ok.String(*v.StageName)
	}

	if v.StageVariables != nil {
		ok := object.Key("StageVariables")
		if err := awsRestjson1_serializeDocumentFieldMap(v.StageVariables, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsAutoScalingAutoScalingGroupDetails(v *types.AwsAutoScalingAutoScalingGroupDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CreatedTime != nil {
		ok := object.Key("CreatedTime")
		ok.String(*v.CreatedTime)
	}

	if v.HealthCheckGracePeriod != 0 {
		ok := object.Key("HealthCheckGracePeriod")
		ok.Integer(v.HealthCheckGracePeriod)
	}

	if v.HealthCheckType != nil {
		ok := object.Key("HealthCheckType")
		ok.String(*v.HealthCheckType)
	}

	if v.LaunchConfigurationName != nil {
		ok := object.Key("LaunchConfigurationName")
		ok.String(*v.LaunchConfigurationName)
	}

	if v.LoadBalancerNames != nil {
		ok := object.Key("LoadBalancerNames")
		if err := awsRestjson1_serializeDocumentStringList(v.LoadBalancerNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails(v *types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceName != nil {
		ok := object.Key("DeviceName")
		ok.String(*v.DeviceName)
	}

	if v.Ebs != nil {
		ok := object.Key("Ebs")
		if err := awsRestjson1_serializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(v.Ebs, ok); err != nil {
			return err
		}
	}

	if v.NoDevice {
		ok := object.Key("NoDevice")
		ok.Boolean(v.NoDevice)
	}

	if v.VirtualName != nil {
		ok := object.Key("VirtualName")
		ok.String(*v.VirtualName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(v *types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeleteOnTermination {
		ok := object.Key("DeleteOnTermination")
		ok.Boolean(v.DeleteOnTermination)
	}

	if v.Encrypted {
		ok := object.Key("Encrypted")
		ok.Boolean(v.Encrypted)
	}

	if v.Iops != 0 {
		ok := object.Key("Iops")
		ok.Integer(v.Iops)
	}

	if v.SnapshotId != nil {
		ok := object.Key("SnapshotId")
		ok.String(*v.SnapshotId)
	}

	if v.VolumeSize != 0 {
		ok := object.Key("VolumeSize")
		ok.Integer(v.VolumeSize)
	}

	if v.VolumeType != nil {
		ok := object.Key("VolumeType")
		ok.String(*v.VolumeType)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsList(v []types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsAutoScalingLaunchConfigurationDetails(v *types.AwsAutoScalingLaunchConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssociatePublicIpAddress {
		ok := object.Key("AssociatePublicIpAddress")
		ok.Boolean(v.AssociatePublicIpAddress)
	}

	if v.BlockDeviceMappings != nil {
		ok := object.Key("BlockDeviceMappings")
		if err := awsRestjson1_serializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsList(v.BlockDeviceMappings, ok); err != nil {
			return err
		}
	}

	if v.ClassicLinkVpcId != nil {
		ok := object.Key("ClassicLinkVpcId")
		ok.String(*v.ClassicLinkVpcId)
	}

	if v.ClassicLinkVpcSecurityGroups != nil {
		ok := object.Key("ClassicLinkVpcSecurityGroups")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.ClassicLinkVpcSecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.CreatedTime != nil {
		ok := object.Key("CreatedTime")
		ok.String(*v.CreatedTime)
	}

	if v.EbsOptimized {
		ok := object.Key("EbsOptimized")
		ok.Boolean(v.EbsOptimized)
	}

	if v.IamInstanceProfile != nil {
		ok := object.Key("IamInstanceProfile")
		ok.String(*v.IamInstanceProfile)
	}

	if v.ImageId != nil {
		ok := object.Key("ImageId")
		ok.String(*v.ImageId)
	}

	if v.InstanceMonitoring != nil {
		ok := object.Key("InstanceMonitoring")
		if err := awsRestjson1_serializeDocumentAwsAutoScalingLaunchConfigurationInstanceMonitoringDetails(v.InstanceMonitoring, ok); err != nil {
			return err
		}
	}

	if v.InstanceType != nil {
		ok := object.Key("InstanceType")
		ok.String(*v.InstanceType)
	}

	if v.KernelId != nil {
		ok := object.Key("KernelId")
		ok.String(*v.KernelId)
	}

	if v.KeyName != nil {
		ok := object.Key("KeyName")
		ok.String(*v.KeyName)
	}

	if v.LaunchConfigurationName != nil {
		ok := object.Key("LaunchConfigurationName")
		ok.String(*v.LaunchConfigurationName)
	}

	if v.PlacementTenancy != nil {
		ok := object.Key("PlacementTenancy")
		ok.String(*v.PlacementTenancy)
	}

	if v.RamdiskId != nil {
		ok := object.Key("RamdiskId")
		ok.String(*v.RamdiskId)
	}

	if v.SecurityGroups != nil {
		ok := object.Key("SecurityGroups")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.SecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.SpotPrice != nil {
		ok := object.Key("SpotPrice")
		ok.String(*v.SpotPrice)
	}

	if v.UserData != nil {
		ok := object.Key("UserData")
		ok.String(*v.UserData)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsAutoScalingLaunchConfigurationInstanceMonitoringDetails(v *types.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCertificateManagerCertificateDetails(v *types.AwsCertificateManagerCertificateDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.CreatedAt != nil {
		ok := object.Key("CreatedAt")
		ok.String(*v.CreatedAt)
	}

	if v.DomainName != nil {
		ok := object.Key("DomainName")
		ok.String(*v.DomainName)
	}

	if v.DomainValidationOptions != nil {
		ok := object.Key("DomainValidationOptions")
		if err := awsRestjson1_serializeDocumentAwsCertificateManagerCertificateDomainValidationOptions(v.DomainValidationOptions, ok); err != nil {
			return err
		}
	}

	if v.ExtendedKeyUsages != nil {
		ok := object.Key("ExtendedKeyUsages")
		if err := awsRestjson1_serializeDocumentAwsCertificateManagerCertificateExtendedKeyUsages(v.ExtendedKeyUsages, ok); err != nil {
			return err
		}
	}

	if v.FailureReason != nil {
		ok := object.Key("FailureReason")
		ok.String(*v.FailureReason)
	}

	if v.ImportedAt != nil {
		ok := object.Key("ImportedAt")
		ok.String(*v.ImportedAt)
	}

	if v.InUseBy != nil {
		ok := object.Key("InUseBy")
		if err := awsRestjson1_serializeDocumentStringList(v.InUseBy, ok); err != nil {
			return err
		}
	}

	if v.IssuedAt != nil {
		ok := object.Key("IssuedAt")
		ok.String(*v.IssuedAt)
	}

	if v.Issuer != nil {
		ok := object.Key("Issuer")
		ok.String(*v.Issuer)
	}

	if v.KeyAlgorithm != nil {
		ok := object.Key("KeyAlgorithm")
		ok.String(*v.KeyAlgorithm)
	}

	if v.KeyUsages != nil {
		ok := object.Key("KeyUsages")
		if err := awsRestjson1_serializeDocumentAwsCertificateManagerCertificateKeyUsages(v.KeyUsages, ok); err != nil {
			return err
		}
	}

	if v.NotAfter != nil {
		ok := object.Key("NotAfter")
		ok.String(*v.NotAfter)
	}

	if v.NotBefore != nil {
		ok := object.Key("NotBefore")
		ok.String(*v.NotBefore)
	}

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsRestjson1_serializeDocumentAwsCertificateManagerCertificateOptions(v.Options, ok); err != nil {
			return err
		}
	}

	if v.RenewalEligibility != nil {
		ok := object.Key("RenewalEligibility")
		ok.String(*v.RenewalEligibility)
	}

	if v.RenewalSummary != nil {
		ok := object.Key("RenewalSummary")
		if err := awsRestjson1_serializeDocumentAwsCertificateManagerCertificateRenewalSummary(v.RenewalSummary, ok); err != nil {
			return err
		}
	}

	if v.Serial != nil {
		ok := object.Key("Serial")
		ok.String(*v.Serial)
	}

	if v.SignatureAlgorithm != nil {
		ok := object.Key("SignatureAlgorithm")
		ok.String(*v.SignatureAlgorithm)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.Subject != nil {
		ok := object.Key("Subject")
		ok.String(*v.Subject)
	}

	if v.SubjectAlternativeNames != nil {
		ok := object.Key("SubjectAlternativeNames")
		if err := awsRestjson1_serializeDocumentStringList(v.SubjectAlternativeNames, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCertificateManagerCertificateDomainValidationOption(v *types.AwsCertificateManagerCertificateDomainValidationOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DomainName != nil {
		ok := object.Key("DomainName")
		ok.String(*v.DomainName)
	}

	if v.ResourceRecord != nil {
		ok := object.Key("ResourceRecord")
		if err := awsRestjson1_serializeDocumentAwsCertificateManagerCertificateResourceRecord(v.ResourceRecord, ok); err != nil {
			return err
		}
	}

	if v.ValidationDomain != nil {
		ok := object.Key("ValidationDomain")
		ok.String(*v.ValidationDomain)
	}

	if v.ValidationEmails != nil {
		ok := object.Key("ValidationEmails")
		if err := awsRestjson1_serializeDocumentStringList(v.ValidationEmails, ok); err != nil {
			return err
		}
	}

	if v.ValidationMethod != nil {
		ok := object.Key("ValidationMethod")
		ok.String(*v.ValidationMethod)
	}

	if v.ValidationStatus != nil {
		ok := object.Key("ValidationStatus")
		ok.String(*v.ValidationStatus)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCertificateManagerCertificateDomainValidationOptions(v []types.AwsCertificateManagerCertificateDomainValidationOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsCertificateManagerCertificateDomainValidationOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsCertificateManagerCertificateExtendedKeyUsage(v *types.AwsCertificateManagerCertificateExtendedKeyUsage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OId != nil {
		ok := object.Key("OId")
		ok.String(*v.OId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCertificateManagerCertificateExtendedKeyUsages(v []types.AwsCertificateManagerCertificateExtendedKeyUsage, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsCertificateManagerCertificateExtendedKeyUsage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsCertificateManagerCertificateKeyUsage(v *types.AwsCertificateManagerCertificateKeyUsage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCertificateManagerCertificateKeyUsages(v []types.AwsCertificateManagerCertificateKeyUsage, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsCertificateManagerCertificateKeyUsage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsCertificateManagerCertificateOptions(v *types.AwsCertificateManagerCertificateOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateTransparencyLoggingPreference != nil {
		ok := object.Key("CertificateTransparencyLoggingPreference")
		ok.String(*v.CertificateTransparencyLoggingPreference)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCertificateManagerCertificateRenewalSummary(v *types.AwsCertificateManagerCertificateRenewalSummary, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DomainValidationOptions != nil {
		ok := object.Key("DomainValidationOptions")
		if err := awsRestjson1_serializeDocumentAwsCertificateManagerCertificateDomainValidationOptions(v.DomainValidationOptions, ok); err != nil {
			return err
		}
	}

	if v.RenewalStatus != nil {
		ok := object.Key("RenewalStatus")
		ok.String(*v.RenewalStatus)
	}

	if v.RenewalStatusReason != nil {
		ok := object.Key("RenewalStatusReason")
		ok.String(*v.RenewalStatusReason)
	}

	if v.UpdatedAt != nil {
		ok := object.Key("UpdatedAt")
		ok.String(*v.UpdatedAt)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCertificateManagerCertificateResourceRecord(v *types.AwsCertificateManagerCertificateResourceRecord, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionCacheBehavior(v *types.AwsCloudFrontDistributionCacheBehavior, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ViewerProtocolPolicy != nil {
		ok := object.Key("ViewerProtocolPolicy")
		ok.String(*v.ViewerProtocolPolicy)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionCacheBehaviors(v *types.AwsCloudFrontDistributionCacheBehaviors, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Items != nil {
		ok := object.Key("Items")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionCacheBehaviorsItemList(v.Items, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionCacheBehaviorsItemList(v []types.AwsCloudFrontDistributionCacheBehavior, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionCacheBehavior(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionDefaultCacheBehavior(v *types.AwsCloudFrontDistributionDefaultCacheBehavior, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ViewerProtocolPolicy != nil {
		ok := object.Key("ViewerProtocolPolicy")
		ok.String(*v.ViewerProtocolPolicy)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionDetails(v *types.AwsCloudFrontDistributionDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CacheBehaviors != nil {
		ok := object.Key("CacheBehaviors")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionCacheBehaviors(v.CacheBehaviors, ok); err != nil {
			return err
		}
	}

	if v.DefaultCacheBehavior != nil {
		ok := object.Key("DefaultCacheBehavior")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionDefaultCacheBehavior(v.DefaultCacheBehavior, ok); err != nil {
			return err
		}
	}

	if v.DefaultRootObject != nil {
		ok := object.Key("DefaultRootObject")
		ok.String(*v.DefaultRootObject)
	}

	if v.DomainName != nil {
		ok := object.Key("DomainName")
		ok.String(*v.DomainName)
	}

	if v.ETag != nil {
		ok := object.Key("ETag")
		ok.String(*v.ETag)
	}

	if v.LastModifiedTime != nil {
		ok := object.Key("LastModifiedTime")
		ok.String(*v.LastModifiedTime)
	}

	if v.Logging != nil {
		ok := object.Key("Logging")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionLogging(v.Logging, ok); err != nil {
			return err
		}
	}

	if v.OriginGroups != nil {
		ok := object.Key("OriginGroups")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroups(v.OriginGroups, ok); err != nil {
			return err
		}
	}

	if v.Origins != nil {
		ok := object.Key("Origins")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionOrigins(v.Origins, ok); err != nil {
			return err
		}
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.WebAclId != nil {
		ok := object.Key("WebAclId")
		ok.String(*v.WebAclId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionLogging(v *types.AwsCloudFrontDistributionLogging, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("Bucket")
		ok.String(*v.Bucket)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.IncludeCookies {
		ok := object.Key("IncludeCookies")
		ok.Boolean(v.IncludeCookies)
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroup(v *types.AwsCloudFrontDistributionOriginGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FailoverCriteria != nil {
		ok := object.Key("FailoverCriteria")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroupFailover(v.FailoverCriteria, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroupFailover(v *types.AwsCloudFrontDistributionOriginGroupFailover, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StatusCodes != nil {
		ok := object.Key("StatusCodes")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodes(v.StatusCodes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodes(v *types.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Items != nil {
		ok := object.Key("Items")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemList(v.Items, ok); err != nil {
			return err
		}
	}

	if v.Quantity != 0 {
		ok := object.Key("Quantity")
		ok.Integer(v.Quantity)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemList(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroups(v *types.AwsCloudFrontDistributionOriginGroups, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Items != nil {
		ok := object.Key("Items")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroupsItemList(v.Items, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroupsItemList(v []types.AwsCloudFrontDistributionOriginGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginItem(v *types.AwsCloudFrontDistributionOriginItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DomainName != nil {
		ok := object.Key("DomainName")
		ok.String(*v.DomainName)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.OriginPath != nil {
		ok := object.Key("OriginPath")
		ok.String(*v.OriginPath)
	}

	if v.S3OriginConfig != nil {
		ok := object.Key("S3OriginConfig")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginS3OriginConfig(v.S3OriginConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginItemList(v []types.AwsCloudFrontDistributionOriginItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionOrigins(v *types.AwsCloudFrontDistributionOrigins, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Items != nil {
		ok := object.Key("Items")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginItemList(v.Items, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudFrontDistributionOriginS3OriginConfig(v *types.AwsCloudFrontDistributionOriginS3OriginConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OriginAccessIdentity != nil {
		ok := object.Key("OriginAccessIdentity")
		ok.String(*v.OriginAccessIdentity)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCloudTrailTrailDetails(v *types.AwsCloudTrailTrailDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLogsLogGroupArn != nil {
		ok := object.Key("CloudWatchLogsLogGroupArn")
		ok.String(*v.CloudWatchLogsLogGroupArn)
	}

	if v.CloudWatchLogsRoleArn != nil {
		ok := object.Key("CloudWatchLogsRoleArn")
		ok.String(*v.CloudWatchLogsRoleArn)
	}

	if v.HasCustomEventSelectors {
		ok := object.Key("HasCustomEventSelectors")
		ok.Boolean(v.HasCustomEventSelectors)
	}

	if v.HomeRegion != nil {
		ok := object.Key("HomeRegion")
		ok.String(*v.HomeRegion)
	}

	if v.IncludeGlobalServiceEvents {
		ok := object.Key("IncludeGlobalServiceEvents")
		ok.Boolean(v.IncludeGlobalServiceEvents)
	}

	if v.IsMultiRegionTrail {
		ok := object.Key("IsMultiRegionTrail")
		ok.Boolean(v.IsMultiRegionTrail)
	}

	if v.IsOrganizationTrail {
		ok := object.Key("IsOrganizationTrail")
		ok.Boolean(v.IsOrganizationTrail)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.LogFileValidationEnabled {
		ok := object.Key("LogFileValidationEnabled")
		ok.Boolean(v.LogFileValidationEnabled)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.S3BucketName != nil {
		ok := object.Key("S3BucketName")
		ok.String(*v.S3BucketName)
	}

	if v.S3KeyPrefix != nil {
		ok := object.Key("S3KeyPrefix")
		ok.String(*v.S3KeyPrefix)
	}

	if v.SnsTopicArn != nil {
		ok := object.Key("SnsTopicArn")
		ok.String(*v.SnsTopicArn)
	}

	if v.SnsTopicName != nil {
		ok := object.Key("SnsTopicName")
		ok.String(*v.SnsTopicName)
	}

	if v.TrailArn != nil {
		ok := object.Key("TrailArn")
		ok.String(*v.TrailArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCodeBuildProjectDetails(v *types.AwsCodeBuildProjectDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionKey != nil {
		ok := object.Key("EncryptionKey")
		ok.String(*v.EncryptionKey)
	}

	if v.Environment != nil {
		ok := object.Key("Environment")
		if err := awsRestjson1_serializeDocumentAwsCodeBuildProjectEnvironment(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ServiceRole != nil {
		ok := object.Key("ServiceRole")
		ok.String(*v.ServiceRole)
	}

	if v.Source != nil {
		ok := object.Key("Source")
		if err := awsRestjson1_serializeDocumentAwsCodeBuildProjectSource(v.Source, ok); err != nil {
			return err
		}
	}

	if v.VpcConfig != nil {
		ok := object.Key("VpcConfig")
		if err := awsRestjson1_serializeDocumentAwsCodeBuildProjectVpcConfig(v.VpcConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCodeBuildProjectEnvironment(v *types.AwsCodeBuildProjectEnvironment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Certificate != nil {
		ok := object.Key("Certificate")
		ok.String(*v.Certificate)
	}

	if v.ImagePullCredentialsType != nil {
		ok := object.Key("ImagePullCredentialsType")
		ok.String(*v.ImagePullCredentialsType)
	}

	if v.RegistryCredential != nil {
		ok := object.Key("RegistryCredential")
		if err := awsRestjson1_serializeDocumentAwsCodeBuildProjectEnvironmentRegistryCredential(v.RegistryCredential, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCodeBuildProjectEnvironmentRegistryCredential(v *types.AwsCodeBuildProjectEnvironmentRegistryCredential, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Credential != nil {
		ok := object.Key("Credential")
		ok.String(*v.Credential)
	}

	if v.CredentialProvider != nil {
		ok := object.Key("CredentialProvider")
		ok.String(*v.CredentialProvider)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCodeBuildProjectSource(v *types.AwsCodeBuildProjectSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GitCloneDepth != 0 {
		ok := object.Key("GitCloneDepth")
		ok.Integer(v.GitCloneDepth)
	}

	if v.InsecureSsl {
		ok := object.Key("InsecureSsl")
		ok.Boolean(v.InsecureSsl)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCodeBuildProjectVpcConfig(v *types.AwsCodeBuildProjectVpcConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.Subnets != nil {
		ok := object.Key("Subnets")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Subnets, ok); err != nil {
			return err
		}
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsCorsConfiguration(v *types.AwsCorsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowCredentials {
		ok := object.Key("AllowCredentials")
		ok.Boolean(v.AllowCredentials)
	}

	if v.AllowHeaders != nil {
		ok := object.Key("AllowHeaders")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.AllowHeaders, ok); err != nil {
			return err
		}
	}

	if v.AllowMethods != nil {
		ok := object.Key("AllowMethods")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.AllowMethods, ok); err != nil {
			return err
		}
	}

	if v.AllowOrigins != nil {
		ok := object.Key("AllowOrigins")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.AllowOrigins, ok); err != nil {
			return err
		}
	}

	if v.ExposeHeaders != nil {
		ok := object.Key("ExposeHeaders")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.ExposeHeaders, ok); err != nil {
			return err
		}
	}

	if v.MaxAge != 0 {
		ok := object.Key("MaxAge")
		ok.Integer(v.MaxAge)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableAttributeDefinition(v *types.AwsDynamoDbTableAttributeDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeName != nil {
		ok := object.Key("AttributeName")
		ok.String(*v.AttributeName)
	}

	if v.AttributeType != nil {
		ok := object.Key("AttributeType")
		ok.String(*v.AttributeType)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableAttributeDefinitionList(v []types.AwsDynamoDbTableAttributeDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableAttributeDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableBillingModeSummary(v *types.AwsDynamoDbTableBillingModeSummary, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BillingMode != nil {
		ok := object.Key("BillingMode")
		ok.String(*v.BillingMode)
	}

	if v.LastUpdateToPayPerRequestDateTime != nil {
		ok := object.Key("LastUpdateToPayPerRequestDateTime")
		ok.String(*v.LastUpdateToPayPerRequestDateTime)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableDetails(v *types.AwsDynamoDbTableDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeDefinitions != nil {
		ok := object.Key("AttributeDefinitions")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableAttributeDefinitionList(v.AttributeDefinitions, ok); err != nil {
			return err
		}
	}

	if v.BillingModeSummary != nil {
		ok := object.Key("BillingModeSummary")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableBillingModeSummary(v.BillingModeSummary, ok); err != nil {
			return err
		}
	}

	if v.CreationDateTime != nil {
		ok := object.Key("CreationDateTime")
		ok.String(*v.CreationDateTime)
	}

	if v.GlobalSecondaryIndexes != nil {
		ok := object.Key("GlobalSecondaryIndexes")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableGlobalSecondaryIndexList(v.GlobalSecondaryIndexes, ok); err != nil {
			return err
		}
	}

	if v.GlobalTableVersion != nil {
		ok := object.Key("GlobalTableVersion")
		ok.String(*v.GlobalTableVersion)
	}

	if v.ItemCount != 0 {
		ok := object.Key("ItemCount")
		ok.Integer(v.ItemCount)
	}

	if v.KeySchema != nil {
		ok := object.Key("KeySchema")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableKeySchemaList(v.KeySchema, ok); err != nil {
			return err
		}
	}

	if v.LatestStreamArn != nil {
		ok := object.Key("LatestStreamArn")
		ok.String(*v.LatestStreamArn)
	}

	if v.LatestStreamLabel != nil {
		ok := object.Key("LatestStreamLabel")
		ok.String(*v.LatestStreamLabel)
	}

	if v.LocalSecondaryIndexes != nil {
		ok := object.Key("LocalSecondaryIndexes")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableLocalSecondaryIndexList(v.LocalSecondaryIndexes, ok); err != nil {
			return err
		}
	}

	if v.ProvisionedThroughput != nil {
		ok := object.Key("ProvisionedThroughput")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableProvisionedThroughput(v.ProvisionedThroughput, ok); err != nil {
			return err
		}
	}

	if v.Replicas != nil {
		ok := object.Key("Replicas")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableReplicaList(v.Replicas, ok); err != nil {
			return err
		}
	}

	if v.RestoreSummary != nil {
		ok := object.Key("RestoreSummary")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableRestoreSummary(v.RestoreSummary, ok); err != nil {
			return err
		}
	}

	if v.SseDescription != nil {
		ok := object.Key("SseDescription")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableSseDescription(v.SseDescription, ok); err != nil {
			return err
		}
	}

	if v.StreamSpecification != nil {
		ok := object.Key("StreamSpecification")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableStreamSpecification(v.StreamSpecification, ok); err != nil {
			return err
		}
	}

	if v.TableId != nil {
		ok := object.Key("TableId")
		ok.String(*v.TableId)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if v.TableSizeBytes != 0 {
		ok := object.Key("TableSizeBytes")
		ok.Long(v.TableSizeBytes)
	}

	if v.TableStatus != nil {
		ok := object.Key("TableStatus")
		ok.String(*v.TableStatus)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableGlobalSecondaryIndex(v *types.AwsDynamoDbTableGlobalSecondaryIndex, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Backfilling {
		ok := object.Key("Backfilling")
		ok.Boolean(v.Backfilling)
	}

	if v.IndexArn != nil {
		ok := object.Key("IndexArn")
		ok.String(*v.IndexArn)
	}

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if v.IndexSizeBytes != 0 {
		ok := object.Key("IndexSizeBytes")
		ok.Long(v.IndexSizeBytes)
	}

	if v.IndexStatus != nil {
		ok := object.Key("IndexStatus")
		ok.String(*v.IndexStatus)
	}

	if v.ItemCount != 0 {
		ok := object.Key("ItemCount")
		ok.Integer(v.ItemCount)
	}

	if v.KeySchema != nil {
		ok := object.Key("KeySchema")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableKeySchemaList(v.KeySchema, ok); err != nil {
			return err
		}
	}

	if v.Projection != nil {
		ok := object.Key("Projection")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableProjection(v.Projection, ok); err != nil {
			return err
		}
	}

	if v.ProvisionedThroughput != nil {
		ok := object.Key("ProvisionedThroughput")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableProvisionedThroughput(v.ProvisionedThroughput, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableGlobalSecondaryIndexList(v []types.AwsDynamoDbTableGlobalSecondaryIndex, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableGlobalSecondaryIndex(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableKeySchema(v *types.AwsDynamoDbTableKeySchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeName != nil {
		ok := object.Key("AttributeName")
		ok.String(*v.AttributeName)
	}

	if v.KeyType != nil {
		ok := object.Key("KeyType")
		ok.String(*v.KeyType)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableKeySchemaList(v []types.AwsDynamoDbTableKeySchema, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableKeySchema(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableLocalSecondaryIndex(v *types.AwsDynamoDbTableLocalSecondaryIndex, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexArn != nil {
		ok := object.Key("IndexArn")
		ok.String(*v.IndexArn)
	}

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if v.KeySchema != nil {
		ok := object.Key("KeySchema")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableKeySchemaList(v.KeySchema, ok); err != nil {
			return err
		}
	}

	if v.Projection != nil {
		ok := object.Key("Projection")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableProjection(v.Projection, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableLocalSecondaryIndexList(v []types.AwsDynamoDbTableLocalSecondaryIndex, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableLocalSecondaryIndex(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableProjection(v *types.AwsDynamoDbTableProjection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NonKeyAttributes != nil {
		ok := object.Key("NonKeyAttributes")
		if err := awsRestjson1_serializeDocumentStringList(v.NonKeyAttributes, ok); err != nil {
			return err
		}
	}

	if v.ProjectionType != nil {
		ok := object.Key("ProjectionType")
		ok.String(*v.ProjectionType)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableProvisionedThroughput(v *types.AwsDynamoDbTableProvisionedThroughput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LastDecreaseDateTime != nil {
		ok := object.Key("LastDecreaseDateTime")
		ok.String(*v.LastDecreaseDateTime)
	}

	if v.LastIncreaseDateTime != nil {
		ok := object.Key("LastIncreaseDateTime")
		ok.String(*v.LastIncreaseDateTime)
	}

	if v.NumberOfDecreasesToday != 0 {
		ok := object.Key("NumberOfDecreasesToday")
		ok.Integer(v.NumberOfDecreasesToday)
	}

	if v.ReadCapacityUnits != 0 {
		ok := object.Key("ReadCapacityUnits")
		ok.Integer(v.ReadCapacityUnits)
	}

	if v.WriteCapacityUnits != 0 {
		ok := object.Key("WriteCapacityUnits")
		ok.Integer(v.WriteCapacityUnits)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableProvisionedThroughputOverride(v *types.AwsDynamoDbTableProvisionedThroughputOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReadCapacityUnits != 0 {
		ok := object.Key("ReadCapacityUnits")
		ok.Integer(v.ReadCapacityUnits)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableReplica(v *types.AwsDynamoDbTableReplica, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GlobalSecondaryIndexes != nil {
		ok := object.Key("GlobalSecondaryIndexes")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndexList(v.GlobalSecondaryIndexes, ok); err != nil {
			return err
		}
	}

	if v.KmsMasterKeyId != nil {
		ok := object.Key("KmsMasterKeyId")
		ok.String(*v.KmsMasterKeyId)
	}

	if v.ProvisionedThroughputOverride != nil {
		ok := object.Key("ProvisionedThroughputOverride")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableProvisionedThroughputOverride(v.ProvisionedThroughputOverride, ok); err != nil {
			return err
		}
	}

	if v.RegionName != nil {
		ok := object.Key("RegionName")
		ok.String(*v.RegionName)
	}

	if v.ReplicaStatus != nil {
		ok := object.Key("ReplicaStatus")
		ok.String(*v.ReplicaStatus)
	}

	if v.ReplicaStatusDescription != nil {
		ok := object.Key("ReplicaStatusDescription")
		ok.String(*v.ReplicaStatusDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndex(v *types.AwsDynamoDbTableReplicaGlobalSecondaryIndex, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if v.ProvisionedThroughputOverride != nil {
		ok := object.Key("ProvisionedThroughputOverride")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableProvisionedThroughputOverride(v.ProvisionedThroughputOverride, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndexList(v []types.AwsDynamoDbTableReplicaGlobalSecondaryIndex, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndex(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableReplicaList(v []types.AwsDynamoDbTableReplica, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableReplica(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableRestoreSummary(v *types.AwsDynamoDbTableRestoreSummary, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RestoreDateTime != nil {
		ok := object.Key("RestoreDateTime")
		ok.String(*v.RestoreDateTime)
	}

	if v.RestoreInProgress {
		ok := object.Key("RestoreInProgress")
		ok.Boolean(v.RestoreInProgress)
	}

	if v.SourceBackupArn != nil {
		ok := object.Key("SourceBackupArn")
		ok.String(*v.SourceBackupArn)
	}

	if v.SourceTableArn != nil {
		ok := object.Key("SourceTableArn")
		ok.String(*v.SourceTableArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableSseDescription(v *types.AwsDynamoDbTableSseDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InaccessibleEncryptionDateTime != nil {
		ok := object.Key("InaccessibleEncryptionDateTime")
		ok.String(*v.InaccessibleEncryptionDateTime)
	}

	if v.KmsMasterKeyArn != nil {
		ok := object.Key("KmsMasterKeyArn")
		ok.String(*v.KmsMasterKeyArn)
	}

	if v.SseType != nil {
		ok := object.Key("SseType")
		ok.String(*v.SseType)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsDynamoDbTableStreamSpecification(v *types.AwsDynamoDbTableStreamSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StreamEnabled {
		ok := object.Key("StreamEnabled")
		ok.Boolean(v.StreamEnabled)
	}

	if v.StreamViewType != nil {
		ok := object.Key("StreamViewType")
		ok.String(*v.StreamViewType)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2EipDetails(v *types.AwsEc2EipDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllocationId != nil {
		ok := object.Key("AllocationId")
		ok.String(*v.AllocationId)
	}

	if v.AssociationId != nil {
		ok := object.Key("AssociationId")
		ok.String(*v.AssociationId)
	}

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	if v.NetworkBorderGroup != nil {
		ok := object.Key("NetworkBorderGroup")
		ok.String(*v.NetworkBorderGroup)
	}

	if v.NetworkInterfaceId != nil {
		ok := object.Key("NetworkInterfaceId")
		ok.String(*v.NetworkInterfaceId)
	}

	if v.NetworkInterfaceOwnerId != nil {
		ok := object.Key("NetworkInterfaceOwnerId")
		ok.String(*v.NetworkInterfaceOwnerId)
	}

	if v.PrivateIpAddress != nil {
		ok := object.Key("PrivateIpAddress")
		ok.String(*v.PrivateIpAddress)
	}

	if v.PublicIp != nil {
		ok := object.Key("PublicIp")
		ok.String(*v.PublicIp)
	}

	if v.PublicIpv4Pool != nil {
		ok := object.Key("PublicIpv4Pool")
		ok.String(*v.PublicIpv4Pool)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2InstanceDetails(v *types.AwsEc2InstanceDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IamInstanceProfileArn != nil {
		ok := object.Key("IamInstanceProfileArn")
		ok.String(*v.IamInstanceProfileArn)
	}

	if v.ImageId != nil {
		ok := object.Key("ImageId")
		ok.String(*v.ImageId)
	}

	if v.IpV4Addresses != nil {
		ok := object.Key("IpV4Addresses")
		if err := awsRestjson1_serializeDocumentStringList(v.IpV4Addresses, ok); err != nil {
			return err
		}
	}

	if v.IpV6Addresses != nil {
		ok := object.Key("IpV6Addresses")
		if err := awsRestjson1_serializeDocumentStringList(v.IpV6Addresses, ok); err != nil {
			return err
		}
	}

	if v.KeyName != nil {
		ok := object.Key("KeyName")
		ok.String(*v.KeyName)
	}

	if v.LaunchedAt != nil {
		ok := object.Key("LaunchedAt")
		ok.String(*v.LaunchedAt)
	}

	if v.NetworkInterfaces != nil {
		ok := object.Key("NetworkInterfaces")
		if err := awsRestjson1_serializeDocumentAwsEc2InstanceNetworkInterfacesList(v.NetworkInterfaces, ok); err != nil {
			return err
		}
	}

	if v.SubnetId != nil {
		ok := object.Key("SubnetId")
		ok.String(*v.SubnetId)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2InstanceNetworkInterfacesDetails(v *types.AwsEc2InstanceNetworkInterfacesDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkInterfaceId != nil {
		ok := object.Key("NetworkInterfaceId")
		ok.String(*v.NetworkInterfaceId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2InstanceNetworkInterfacesList(v []types.AwsEc2InstanceNetworkInterfacesDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2InstanceNetworkInterfacesDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkAclAssociation(v *types.AwsEc2NetworkAclAssociation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkAclAssociationId != nil {
		ok := object.Key("NetworkAclAssociationId")
		ok.String(*v.NetworkAclAssociationId)
	}

	if v.NetworkAclId != nil {
		ok := object.Key("NetworkAclId")
		ok.String(*v.NetworkAclId)
	}

	if v.SubnetId != nil {
		ok := object.Key("SubnetId")
		ok.String(*v.SubnetId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkAclAssociationList(v []types.AwsEc2NetworkAclAssociation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkAclAssociation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkAclDetails(v *types.AwsEc2NetworkAclDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Associations != nil {
		ok := object.Key("Associations")
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkAclAssociationList(v.Associations, ok); err != nil {
			return err
		}
	}

	if v.Entries != nil {
		ok := object.Key("Entries")
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkAclEntryList(v.Entries, ok); err != nil {
			return err
		}
	}

	if v.IsDefault {
		ok := object.Key("IsDefault")
		ok.Boolean(v.IsDefault)
	}

	if v.NetworkAclId != nil {
		ok := object.Key("NetworkAclId")
		ok.String(*v.NetworkAclId)
	}

	if v.OwnerId != nil {
		ok := object.Key("OwnerId")
		ok.String(*v.OwnerId)
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkAclEntry(v *types.AwsEc2NetworkAclEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CidrBlock != nil {
		ok := object.Key("CidrBlock")
		ok.String(*v.CidrBlock)
	}

	if v.Egress {
		ok := object.Key("Egress")
		ok.Boolean(v.Egress)
	}

	if v.IcmpTypeCode != nil {
		ok := object.Key("IcmpTypeCode")
		if err := awsRestjson1_serializeDocumentIcmpTypeCode(v.IcmpTypeCode, ok); err != nil {
			return err
		}
	}

	if v.Ipv6CidrBlock != nil {
		ok := object.Key("Ipv6CidrBlock")
		ok.String(*v.Ipv6CidrBlock)
	}

	if v.PortRange != nil {
		ok := object.Key("PortRange")
		if err := awsRestjson1_serializeDocumentPortRangeFromTo(v.PortRange, ok); err != nil {
			return err
		}
	}

	if v.Protocol != nil {
		ok := object.Key("Protocol")
		ok.String(*v.Protocol)
	}

	if v.RuleAction != nil {
		ok := object.Key("RuleAction")
		ok.String(*v.RuleAction)
	}

	if v.RuleNumber != 0 {
		ok := object.Key("RuleNumber")
		ok.Integer(v.RuleNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkAclEntryList(v []types.AwsEc2NetworkAclEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkAclEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceAttachment(v *types.AwsEc2NetworkInterfaceAttachment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttachmentId != nil {
		ok := object.Key("AttachmentId")
		ok.String(*v.AttachmentId)
	}

	if v.AttachTime != nil {
		ok := object.Key("AttachTime")
		ok.String(*v.AttachTime)
	}

	if v.DeleteOnTermination {
		ok := object.Key("DeleteOnTermination")
		ok.Boolean(v.DeleteOnTermination)
	}

	if v.DeviceIndex != 0 {
		ok := object.Key("DeviceIndex")
		ok.Integer(v.DeviceIndex)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	if v.InstanceOwnerId != nil {
		ok := object.Key("InstanceOwnerId")
		ok.String(*v.InstanceOwnerId)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceDetails(v *types.AwsEc2NetworkInterfaceDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attachment != nil {
		ok := object.Key("Attachment")
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceAttachment(v.Attachment, ok); err != nil {
			return err
		}
	}

	if v.IpV6Addresses != nil {
		ok := object.Key("IpV6Addresses")
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceIpV6AddressList(v.IpV6Addresses, ok); err != nil {
			return err
		}
	}

	if v.NetworkInterfaceId != nil {
		ok := object.Key("NetworkInterfaceId")
		ok.String(*v.NetworkInterfaceId)
	}

	if v.PrivateIpAddresses != nil {
		ok := object.Key("PrivateIpAddresses")
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkInterfacePrivateIpAddressList(v.PrivateIpAddresses, ok); err != nil {
			return err
		}
	}

	if v.PublicDnsName != nil {
		ok := object.Key("PublicDnsName")
		ok.String(*v.PublicDnsName)
	}

	if v.PublicIp != nil {
		ok := object.Key("PublicIp")
		ok.String(*v.PublicIp)
	}

	if v.SecurityGroups != nil {
		ok := object.Key("SecurityGroups")
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceSecurityGroupList(v.SecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.SourceDestCheck {
		ok := object.Key("SourceDestCheck")
		ok.Boolean(v.SourceDestCheck)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceIpV6AddressDetail(v *types.AwsEc2NetworkInterfaceIpV6AddressDetail, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IpV6Address != nil {
		ok := object.Key("IpV6Address")
		ok.String(*v.IpV6Address)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceIpV6AddressList(v []types.AwsEc2NetworkInterfaceIpV6AddressDetail, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceIpV6AddressDetail(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkInterfacePrivateIpAddressDetail(v *types.AwsEc2NetworkInterfacePrivateIpAddressDetail, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PrivateDnsName != nil {
		ok := object.Key("PrivateDnsName")
		ok.String(*v.PrivateDnsName)
	}

	if v.PrivateIpAddress != nil {
		ok := object.Key("PrivateIpAddress")
		ok.String(*v.PrivateIpAddress)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkInterfacePrivateIpAddressList(v []types.AwsEc2NetworkInterfacePrivateIpAddressDetail, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkInterfacePrivateIpAddressDetail(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceSecurityGroup(v *types.AwsEc2NetworkInterfaceSecurityGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupId != nil {
		ok := object.Key("GroupId")
		ok.String(*v.GroupId)
	}

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceSecurityGroupList(v []types.AwsEc2NetworkInterfaceSecurityGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceSecurityGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SecurityGroupDetails(v *types.AwsEc2SecurityGroupDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupId != nil {
		ok := object.Key("GroupId")
		ok.String(*v.GroupId)
	}

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.IpPermissions != nil {
		ok := object.Key("IpPermissions")
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpPermissionList(v.IpPermissions, ok); err != nil {
			return err
		}
	}

	if v.IpPermissionsEgress != nil {
		ok := object.Key("IpPermissionsEgress")
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpPermissionList(v.IpPermissionsEgress, ok); err != nil {
			return err
		}
	}

	if v.OwnerId != nil {
		ok := object.Key("OwnerId")
		ok.String(*v.OwnerId)
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpPermission(v *types.AwsEc2SecurityGroupIpPermission, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FromPort != 0 {
		ok := object.Key("FromPort")
		ok.Integer(v.FromPort)
	}

	if v.IpProtocol != nil {
		ok := object.Key("IpProtocol")
		ok.String(*v.IpProtocol)
	}

	if v.IpRanges != nil {
		ok := object.Key("IpRanges")
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpRangeList(v.IpRanges, ok); err != nil {
			return err
		}
	}

	if v.Ipv6Ranges != nil {
		ok := object.Key("Ipv6Ranges")
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpv6RangeList(v.Ipv6Ranges, ok); err != nil {
			return err
		}
	}

	if v.PrefixListIds != nil {
		ok := object.Key("PrefixListIds")
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupPrefixListIdList(v.PrefixListIds, ok); err != nil {
			return err
		}
	}

	if v.ToPort != 0 {
		ok := object.Key("ToPort")
		ok.Integer(v.ToPort)
	}

	if v.UserIdGroupPairs != nil {
		ok := object.Key("UserIdGroupPairs")
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupUserIdGroupPairList(v.UserIdGroupPairs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpPermissionList(v []types.AwsEc2SecurityGroupIpPermission, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpPermission(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpRange(v *types.AwsEc2SecurityGroupIpRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CidrIp != nil {
		ok := object.Key("CidrIp")
		ok.String(*v.CidrIp)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpRangeList(v []types.AwsEc2SecurityGroupIpRange, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpRange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpv6Range(v *types.AwsEc2SecurityGroupIpv6Range, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CidrIpv6 != nil {
		ok := object.Key("CidrIpv6")
		ok.String(*v.CidrIpv6)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpv6RangeList(v []types.AwsEc2SecurityGroupIpv6Range, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupIpv6Range(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SecurityGroupPrefixListId(v *types.AwsEc2SecurityGroupPrefixListId, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PrefixListId != nil {
		ok := object.Key("PrefixListId")
		ok.String(*v.PrefixListId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SecurityGroupPrefixListIdList(v []types.AwsEc2SecurityGroupPrefixListId, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupPrefixListId(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SecurityGroupUserIdGroupPair(v *types.AwsEc2SecurityGroupUserIdGroupPair, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupId != nil {
		ok := object.Key("GroupId")
		ok.String(*v.GroupId)
	}

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.PeeringStatus != nil {
		ok := object.Key("PeeringStatus")
		ok.String(*v.PeeringStatus)
	}

	if v.UserId != nil {
		ok := object.Key("UserId")
		ok.String(*v.UserId)
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	if v.VpcPeeringConnectionId != nil {
		ok := object.Key("VpcPeeringConnectionId")
		ok.String(*v.VpcPeeringConnectionId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SecurityGroupUserIdGroupPairList(v []types.AwsEc2SecurityGroupUserIdGroupPair, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupUserIdGroupPair(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2SubnetDetails(v *types.AwsEc2SubnetDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssignIpv6AddressOnCreation {
		ok := object.Key("AssignIpv6AddressOnCreation")
		ok.Boolean(v.AssignIpv6AddressOnCreation)
	}

	if v.AvailabilityZone != nil {
		ok := object.Key("AvailabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.AvailabilityZoneId != nil {
		ok := object.Key("AvailabilityZoneId")
		ok.String(*v.AvailabilityZoneId)
	}

	if v.AvailableIpAddressCount != 0 {
		ok := object.Key("AvailableIpAddressCount")
		ok.Integer(v.AvailableIpAddressCount)
	}

	if v.CidrBlock != nil {
		ok := object.Key("CidrBlock")
		ok.String(*v.CidrBlock)
	}

	if v.DefaultForAz {
		ok := object.Key("DefaultForAz")
		ok.Boolean(v.DefaultForAz)
	}

	if v.Ipv6CidrBlockAssociationSet != nil {
		ok := object.Key("Ipv6CidrBlockAssociationSet")
		if err := awsRestjson1_serializeDocumentIpv6CidrBlockAssociationList(v.Ipv6CidrBlockAssociationSet, ok); err != nil {
			return err
		}
	}

	if v.MapPublicIpOnLaunch {
		ok := object.Key("MapPublicIpOnLaunch")
		ok.Boolean(v.MapPublicIpOnLaunch)
	}

	if v.OwnerId != nil {
		ok := object.Key("OwnerId")
		ok.String(*v.OwnerId)
	}

	if v.State != nil {
		ok := object.Key("State")
		ok.String(*v.State)
	}

	if v.SubnetArn != nil {
		ok := object.Key("SubnetArn")
		ok.String(*v.SubnetArn)
	}

	if v.SubnetId != nil {
		ok := object.Key("SubnetId")
		ok.String(*v.SubnetId)
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VolumeAttachment(v *types.AwsEc2VolumeAttachment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttachTime != nil {
		ok := object.Key("AttachTime")
		ok.String(*v.AttachTime)
	}

	if v.DeleteOnTermination {
		ok := object.Key("DeleteOnTermination")
		ok.Boolean(v.DeleteOnTermination)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VolumeAttachmentList(v []types.AwsEc2VolumeAttachment, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2VolumeAttachment(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VolumeDetails(v *types.AwsEc2VolumeDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attachments != nil {
		ok := object.Key("Attachments")
		if err := awsRestjson1_serializeDocumentAwsEc2VolumeAttachmentList(v.Attachments, ok); err != nil {
			return err
		}
	}

	if v.CreateTime != nil {
		ok := object.Key("CreateTime")
		ok.String(*v.CreateTime)
	}

	if v.Encrypted {
		ok := object.Key("Encrypted")
		ok.Boolean(v.Encrypted)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.Size != 0 {
		ok := object.Key("Size")
		ok.Integer(v.Size)
	}

	if v.SnapshotId != nil {
		ok := object.Key("SnapshotId")
		ok.String(*v.SnapshotId)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VpcDetails(v *types.AwsEc2VpcDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CidrBlockAssociationSet != nil {
		ok := object.Key("CidrBlockAssociationSet")
		if err := awsRestjson1_serializeDocumentCidrBlockAssociationList(v.CidrBlockAssociationSet, ok); err != nil {
			return err
		}
	}

	if v.DhcpOptionsId != nil {
		ok := object.Key("DhcpOptionsId")
		ok.String(*v.DhcpOptionsId)
	}

	if v.Ipv6CidrBlockAssociationSet != nil {
		ok := object.Key("Ipv6CidrBlockAssociationSet")
		if err := awsRestjson1_serializeDocumentIpv6CidrBlockAssociationList(v.Ipv6CidrBlockAssociationSet, ok); err != nil {
			return err
		}
	}

	if v.State != nil {
		ok := object.Key("State")
		ok.String(*v.State)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VpnConnectionDetails(v *types.AwsEc2VpnConnectionDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("Category")
		ok.String(*v.Category)
	}

	if v.CustomerGatewayConfiguration != nil {
		ok := object.Key("CustomerGatewayConfiguration")
		ok.String(*v.CustomerGatewayConfiguration)
	}

	if v.CustomerGatewayId != nil {
		ok := object.Key("CustomerGatewayId")
		ok.String(*v.CustomerGatewayId)
	}

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsRestjson1_serializeDocumentAwsEc2VpnConnectionOptionsDetails(v.Options, ok); err != nil {
			return err
		}
	}

	if v.Routes != nil {
		ok := object.Key("Routes")
		if err := awsRestjson1_serializeDocumentAwsEc2VpnConnectionRoutesList(v.Routes, ok); err != nil {
			return err
		}
	}

	if v.State != nil {
		ok := object.Key("State")
		ok.String(*v.State)
	}

	if v.TransitGatewayId != nil {
		ok := object.Key("TransitGatewayId")
		ok.String(*v.TransitGatewayId)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	if v.VgwTelemetry != nil {
		ok := object.Key("VgwTelemetry")
		if err := awsRestjson1_serializeDocumentAwsEc2VpnConnectionVgwTelemetryList(v.VgwTelemetry, ok); err != nil {
			return err
		}
	}

	if v.VpnConnectionId != nil {
		ok := object.Key("VpnConnectionId")
		ok.String(*v.VpnConnectionId)
	}

	if v.VpnGatewayId != nil {
		ok := object.Key("VpnGatewayId")
		ok.String(*v.VpnGatewayId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VpnConnectionOptionsDetails(v *types.AwsEc2VpnConnectionOptionsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StaticRoutesOnly {
		ok := object.Key("StaticRoutesOnly")
		ok.Boolean(v.StaticRoutesOnly)
	}

	if v.TunnelOptions != nil {
		ok := object.Key("TunnelOptions")
		if err := awsRestjson1_serializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsList(v.TunnelOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsDetails(v *types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DpdTimeoutSeconds != 0 {
		ok := object.Key("DpdTimeoutSeconds")
		ok.Integer(v.DpdTimeoutSeconds)
	}

	if v.IkeVersions != nil {
		ok := object.Key("IkeVersions")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.IkeVersions, ok); err != nil {
			return err
		}
	}

	if v.OutsideIpAddress != nil {
		ok := object.Key("OutsideIpAddress")
		ok.String(*v.OutsideIpAddress)
	}

	if v.Phase1DhGroupNumbers != nil {
		ok := object.Key("Phase1DhGroupNumbers")
		if err := awsRestjson1_serializeDocumentIntegerList(v.Phase1DhGroupNumbers, ok); err != nil {
			return err
		}
	}

	if v.Phase1EncryptionAlgorithms != nil {
		ok := object.Key("Phase1EncryptionAlgorithms")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Phase1EncryptionAlgorithms, ok); err != nil {
			return err
		}
	}

	if v.Phase1IntegrityAlgorithms != nil {
		ok := object.Key("Phase1IntegrityAlgorithms")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Phase1IntegrityAlgorithms, ok); err != nil {
			return err
		}
	}

	if v.Phase1LifetimeSeconds != 0 {
		ok := object.Key("Phase1LifetimeSeconds")
		ok.Integer(v.Phase1LifetimeSeconds)
	}

	if v.Phase2DhGroupNumbers != nil {
		ok := object.Key("Phase2DhGroupNumbers")
		if err := awsRestjson1_serializeDocumentIntegerList(v.Phase2DhGroupNumbers, ok); err != nil {
			return err
		}
	}

	if v.Phase2EncryptionAlgorithms != nil {
		ok := object.Key("Phase2EncryptionAlgorithms")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Phase2EncryptionAlgorithms, ok); err != nil {
			return err
		}
	}

	if v.Phase2IntegrityAlgorithms != nil {
		ok := object.Key("Phase2IntegrityAlgorithms")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Phase2IntegrityAlgorithms, ok); err != nil {
			return err
		}
	}

	if v.Phase2LifetimeSeconds != 0 {
		ok := object.Key("Phase2LifetimeSeconds")
		ok.Integer(v.Phase2LifetimeSeconds)
	}

	if v.PreSharedKey != nil {
		ok := object.Key("PreSharedKey")
		ok.String(*v.PreSharedKey)
	}

	if v.RekeyFuzzPercentage != 0 {
		ok := object.Key("RekeyFuzzPercentage")
		ok.Integer(v.RekeyFuzzPercentage)
	}

	if v.RekeyMarginTimeSeconds != 0 {
		ok := object.Key("RekeyMarginTimeSeconds")
		ok.Integer(v.RekeyMarginTimeSeconds)
	}

	if v.ReplayWindowSize != 0 {
		ok := object.Key("ReplayWindowSize")
		ok.Integer(v.ReplayWindowSize)
	}

	if v.TunnelInsideCidr != nil {
		ok := object.Key("TunnelInsideCidr")
		ok.String(*v.TunnelInsideCidr)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsList(v []types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VpnConnectionRoutesDetails(v *types.AwsEc2VpnConnectionRoutesDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationCidrBlock != nil {
		ok := object.Key("DestinationCidrBlock")
		ok.String(*v.DestinationCidrBlock)
	}

	if v.State != nil {
		ok := object.Key("State")
		ok.String(*v.State)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VpnConnectionRoutesList(v []types.AwsEc2VpnConnectionRoutesDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2VpnConnectionRoutesDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VpnConnectionVgwTelemetryDetails(v *types.AwsEc2VpnConnectionVgwTelemetryDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AcceptedRouteCount != 0 {
		ok := object.Key("AcceptedRouteCount")
		ok.Integer(v.AcceptedRouteCount)
	}

	if v.CertificateArn != nil {
		ok := object.Key("CertificateArn")
		ok.String(*v.CertificateArn)
	}

	if v.LastStatusChange != nil {
		ok := object.Key("LastStatusChange")
		ok.String(*v.LastStatusChange)
	}

	if v.OutsideIpAddress != nil {
		ok := object.Key("OutsideIpAddress")
		ok.String(*v.OutsideIpAddress)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.StatusMessage != nil {
		ok := object.Key("StatusMessage")
		ok.String(*v.StatusMessage)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEc2VpnConnectionVgwTelemetryList(v []types.AwsEc2VpnConnectionVgwTelemetryDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEc2VpnConnectionVgwTelemetryDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcrContainerImageDetails(v *types.AwsEcrContainerImageDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Architecture != nil {
		ok := object.Key("Architecture")
		ok.String(*v.Architecture)
	}

	if v.ImageDigest != nil {
		ok := object.Key("ImageDigest")
		ok.String(*v.ImageDigest)
	}

	if v.ImagePublishedAt != nil {
		ok := object.Key("ImagePublishedAt")
		ok.String(*v.ImagePublishedAt)
	}

	if v.ImageTags != nil {
		ok := object.Key("ImageTags")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.ImageTags, ok); err != nil {
			return err
		}
	}

	if v.RegistryId != nil {
		ok := object.Key("RegistryId")
		ok.String(*v.RegistryId)
	}

	if v.RepositoryName != nil {
		ok := object.Key("RepositoryName")
		ok.String(*v.RepositoryName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsClusterClusterSettingsDetails(v *types.AwsEcsClusterClusterSettingsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsClusterClusterSettingsList(v []types.AwsEcsClusterClusterSettingsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsClusterClusterSettingsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsClusterConfigurationDetails(v *types.AwsEcsClusterConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExecuteCommandConfiguration != nil {
		ok := object.Key("ExecuteCommandConfiguration")
		if err := awsRestjson1_serializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationDetails(v.ExecuteCommandConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationDetails(v *types.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.LogConfiguration != nil {
		ok := object.Key("LogConfiguration")
		if err := awsRestjson1_serializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails(v.LogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Logging != nil {
		ok := object.Key("Logging")
		ok.String(*v.Logging)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails(v *types.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchEncryptionEnabled {
		ok := object.Key("CloudWatchEncryptionEnabled")
		ok.Boolean(v.CloudWatchEncryptionEnabled)
	}

	if v.CloudWatchLogGroupName != nil {
		ok := object.Key("CloudWatchLogGroupName")
		ok.String(*v.CloudWatchLogGroupName)
	}

	if v.S3BucketName != nil {
		ok := object.Key("S3BucketName")
		ok.String(*v.S3BucketName)
	}

	if v.S3EncryptionEnabled {
		ok := object.Key("S3EncryptionEnabled")
		ok.Boolean(v.S3EncryptionEnabled)
	}

	if v.S3KeyPrefix != nil {
		ok := object.Key("S3KeyPrefix")
		ok.String(*v.S3KeyPrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyDetails(v *types.AwsEcsClusterDefaultCapacityProviderStrategyDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Base != 0 {
		ok := object.Key("Base")
		ok.Integer(v.Base)
	}

	if v.CapacityProvider != nil {
		ok := object.Key("CapacityProvider")
		ok.String(*v.CapacityProvider)
	}

	if v.Weight != 0 {
		ok := object.Key("Weight")
		ok.Integer(v.Weight)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyList(v []types.AwsEcsClusterDefaultCapacityProviderStrategyDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsClusterDetails(v *types.AwsEcsClusterDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityProviders != nil {
		ok := object.Key("CapacityProviders")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.CapacityProviders, ok); err != nil {
			return err
		}
	}

	if v.ClusterSettings != nil {
		ok := object.Key("ClusterSettings")
		if err := awsRestjson1_serializeDocumentAwsEcsClusterClusterSettingsList(v.ClusterSettings, ok); err != nil {
			return err
		}
	}

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		if err := awsRestjson1_serializeDocumentAwsEcsClusterConfigurationDetails(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.DefaultCapacityProviderStrategy != nil {
		ok := object.Key("DefaultCapacityProviderStrategy")
		if err := awsRestjson1_serializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyList(v.DefaultCapacityProviderStrategy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceCapacityProviderStrategyDetails(v *types.AwsEcsServiceCapacityProviderStrategyDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Base != 0 {
		ok := object.Key("Base")
		ok.Integer(v.Base)
	}

	if v.CapacityProvider != nil {
		ok := object.Key("CapacityProvider")
		ok.String(*v.CapacityProvider)
	}

	if v.Weight != 0 {
		ok := object.Key("Weight")
		ok.Integer(v.Weight)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceCapacityProviderStrategyList(v []types.AwsEcsServiceCapacityProviderStrategyDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsServiceCapacityProviderStrategyDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails(v *types.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enable {
		ok := object.Key("Enable")
		ok.Boolean(v.Enable)
	}

	if v.Rollback {
		ok := object.Key("Rollback")
		ok.Boolean(v.Rollback)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceDeploymentConfigurationDetails(v *types.AwsEcsServiceDeploymentConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeploymentCircuitBreaker != nil {
		ok := object.Key("DeploymentCircuitBreaker")
		if err := awsRestjson1_serializeDocumentAwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails(v.DeploymentCircuitBreaker, ok); err != nil {
			return err
		}
	}

	if v.MaximumPercent != 0 {
		ok := object.Key("MaximumPercent")
		ok.Integer(v.MaximumPercent)
	}

	if v.MinimumHealthyPercent != 0 {
		ok := object.Key("MinimumHealthyPercent")
		ok.Integer(v.MinimumHealthyPercent)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceDeploymentControllerDetails(v *types.AwsEcsServiceDeploymentControllerDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceDetails(v *types.AwsEcsServiceDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityProviderStrategy != nil {
		ok := object.Key("CapacityProviderStrategy")
		if err := awsRestjson1_serializeDocumentAwsEcsServiceCapacityProviderStrategyList(v.CapacityProviderStrategy, ok); err != nil {
			return err
		}
	}

	if v.Cluster != nil {
		ok := object.Key("Cluster")
		ok.String(*v.Cluster)
	}

	if v.DeploymentConfiguration != nil {
		ok := object.Key("DeploymentConfiguration")
		if err := awsRestjson1_serializeDocumentAwsEcsServiceDeploymentConfigurationDetails(v.DeploymentConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DeploymentController != nil {
		ok := object.Key("DeploymentController")
		if err := awsRestjson1_serializeDocumentAwsEcsServiceDeploymentControllerDetails(v.DeploymentController, ok); err != nil {
			return err
		}
	}

	if v.DesiredCount != 0 {
		ok := object.Key("DesiredCount")
		ok.Integer(v.DesiredCount)
	}

	if v.EnableEcsManagedTags {
		ok := object.Key("EnableEcsManagedTags")
		ok.Boolean(v.EnableEcsManagedTags)
	}

	if v.EnableExecuteCommand {
		ok := object.Key("EnableExecuteCommand")
		ok.Boolean(v.EnableExecuteCommand)
	}

	if v.HealthCheckGracePeriodSeconds != 0 {
		ok := object.Key("HealthCheckGracePeriodSeconds")
		ok.Integer(v.HealthCheckGracePeriodSeconds)
	}

	if v.LaunchType != nil {
		ok := object.Key("LaunchType")
		ok.String(*v.LaunchType)
	}

	if v.LoadBalancers != nil {
		ok := object.Key("LoadBalancers")
		if err := awsRestjson1_serializeDocumentAwsEcsServiceLoadBalancersList(v.LoadBalancers, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("NetworkConfiguration")
		if err := awsRestjson1_serializeDocumentAwsEcsServiceNetworkConfigurationDetails(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PlacementConstraints != nil {
		ok := object.Key("PlacementConstraints")
		if err := awsRestjson1_serializeDocumentAwsEcsServicePlacementConstraintsList(v.PlacementConstraints, ok); err != nil {
			return err
		}
	}

	if v.PlacementStrategies != nil {
		ok := object.Key("PlacementStrategies")
		if err := awsRestjson1_serializeDocumentAwsEcsServicePlacementStrategiesList(v.PlacementStrategies, ok); err != nil {
			return err
		}
	}

	if v.PlatformVersion != nil {
		ok := object.Key("PlatformVersion")
		ok.String(*v.PlatformVersion)
	}

	if v.PropagateTags != nil {
		ok := object.Key("PropagateTags")
		ok.String(*v.PropagateTags)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.SchedulingStrategy != nil {
		ok := object.Key("SchedulingStrategy")
		ok.String(*v.SchedulingStrategy)
	}

	if v.ServiceArn != nil {
		ok := object.Key("ServiceArn")
		ok.String(*v.ServiceArn)
	}

	if v.ServiceName != nil {
		ok := object.Key("ServiceName")
		ok.String(*v.ServiceName)
	}

	if v.ServiceRegistries != nil {
		ok := object.Key("ServiceRegistries")
		if err := awsRestjson1_serializeDocumentAwsEcsServiceServiceRegistriesList(v.ServiceRegistries, ok); err != nil {
			return err
		}
	}

	if v.TaskDefinition != nil {
		ok := object.Key("TaskDefinition")
		ok.String(*v.TaskDefinition)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceLoadBalancersDetails(v *types.AwsEcsServiceLoadBalancersDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerName != nil {
		ok := object.Key("ContainerName")
		ok.String(*v.ContainerName)
	}

	if v.ContainerPort != 0 {
		ok := object.Key("ContainerPort")
		ok.Integer(v.ContainerPort)
	}

	if v.LoadBalancerName != nil {
		ok := object.Key("LoadBalancerName")
		ok.String(*v.LoadBalancerName)
	}

	if v.TargetGroupArn != nil {
		ok := object.Key("TargetGroupArn")
		ok.String(*v.TargetGroupArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceLoadBalancersList(v []types.AwsEcsServiceLoadBalancersDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsServiceLoadBalancersDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(v *types.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssignPublicIp != nil {
		ok := object.Key("AssignPublicIp")
		ok.String(*v.AssignPublicIp)
	}

	if v.SecurityGroups != nil {
		ok := object.Key("SecurityGroups")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.SecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.Subnets != nil {
		ok := object.Key("Subnets")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Subnets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceNetworkConfigurationDetails(v *types.AwsEcsServiceNetworkConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsVpcConfiguration != nil {
		ok := object.Key("AwsVpcConfiguration")
		if err := awsRestjson1_serializeDocumentAwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(v.AwsVpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServicePlacementConstraintsDetails(v *types.AwsEcsServicePlacementConstraintsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServicePlacementConstraintsList(v []types.AwsEcsServicePlacementConstraintsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsServicePlacementConstraintsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServicePlacementStrategiesDetails(v *types.AwsEcsServicePlacementStrategiesDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Field != nil {
		ok := object.Key("Field")
		ok.String(*v.Field)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServicePlacementStrategiesList(v []types.AwsEcsServicePlacementStrategiesDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsServicePlacementStrategiesDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceServiceRegistriesDetails(v *types.AwsEcsServiceServiceRegistriesDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerName != nil {
		ok := object.Key("ContainerName")
		ok.String(*v.ContainerName)
	}

	if v.ContainerPort != 0 {
		ok := object.Key("ContainerPort")
		ok.Integer(v.ContainerPort)
	}

	if v.Port != 0 {
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	if v.RegistryArn != nil {
		ok := object.Key("RegistryArn")
		ok.String(*v.RegistryArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsServiceServiceRegistriesList(v []types.AwsEcsServiceServiceRegistriesDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsServiceServiceRegistriesDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Condition != nil {
		ok := object.Key("Condition")
		ok.String(*v.Condition)
	}

	if v.ContainerName != nil {
		ok := object.Key("ContainerName")
		ok.String(*v.ContainerName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnList(v []types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Command != nil {
		ok := object.Key("Command")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Cpu != 0 {
		ok := object.Key("Cpu")
		ok.Integer(v.Cpu)
	}

	if v.DependsOn != nil {
		ok := object.Key("DependsOn")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnList(v.DependsOn, ok); err != nil {
			return err
		}
	}

	if v.DisableNetworking {
		ok := object.Key("DisableNetworking")
		ok.Boolean(v.DisableNetworking)
	}

	if v.DnsSearchDomains != nil {
		ok := object.Key("DnsSearchDomains")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.DnsSearchDomains, ok); err != nil {
			return err
		}
	}

	if v.DnsServers != nil {
		ok := object.Key("DnsServers")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.DnsServers, ok); err != nil {
			return err
		}
	}

	if v.DockerLabels != nil {
		ok := object.Key("DockerLabels")
		if err := awsRestjson1_serializeDocumentFieldMap(v.DockerLabels, ok); err != nil {
			return err
		}
	}

	if v.DockerSecurityOptions != nil {
		ok := object.Key("DockerSecurityOptions")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.DockerSecurityOptions, ok); err != nil {
			return err
		}
	}

	if v.EntryPoint != nil {
		ok := object.Key("EntryPoint")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.EntryPoint, ok); err != nil {
			return err
		}
	}

	if v.Environment != nil {
		ok := object.Key("Environment")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentList(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.EnvironmentFiles != nil {
		ok := object.Key("EnvironmentFiles")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesList(v.EnvironmentFiles, ok); err != nil {
			return err
		}
	}

	if v.Essential {
		ok := object.Key("Essential")
		ok.Boolean(v.Essential)
	}

	if v.ExtraHosts != nil {
		ok := object.Key("ExtraHosts")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsList(v.ExtraHosts, ok); err != nil {
			return err
		}
	}

	if v.FirelensConfiguration != nil {
		ok := object.Key("FirelensConfiguration")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails(v.FirelensConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HealthCheck != nil {
		ok := object.Key("HealthCheck")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(v.HealthCheck, ok); err != nil {
			return err
		}
	}

	if v.Hostname != nil {
		ok := object.Key("Hostname")
		ok.String(*v.Hostname)
	}

	if v.Image != nil {
		ok := object.Key("Image")
		ok.String(*v.Image)
	}

	if v.Interactive {
		ok := object.Key("Interactive")
		ok.Boolean(v.Interactive)
	}

	if v.Links != nil {
		ok := object.Key("Links")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Links, ok); err != nil {
			return err
		}
	}

	if v.LinuxParameters != nil {
		ok := object.Key("LinuxParameters")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails(v.LinuxParameters, ok); err != nil {
			return err
		}
	}

	if v.LogConfiguration != nil {
		ok := object.Key("LogConfiguration")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(v.LogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Memory != 0 {
		ok := object.Key("Memory")
		ok.Integer(v.Memory)
	}

	if v.MemoryReservation != 0 {
		ok := object.Key("MemoryReservation")
		ok.Integer(v.MemoryReservation)
	}

	if v.MountPoints != nil {
		ok := object.Key("MountPoints")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsList(v.MountPoints, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PortMappings != nil {
		ok := object.Key("PortMappings")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsList(v.PortMappings, ok); err != nil {
			return err
		}
	}

	if v.Privileged {
		ok := object.Key("Privileged")
		ok.Boolean(v.Privileged)
	}

	if v.PseudoTerminal {
		ok := object.Key("PseudoTerminal")
		ok.Boolean(v.PseudoTerminal)
	}

	if v.ReadonlyRootFilesystem {
		ok := object.Key("ReadonlyRootFilesystem")
		ok.Boolean(v.ReadonlyRootFilesystem)
	}

	if v.RepositoryCredentials != nil {
		ok := object.Key("RepositoryCredentials")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails(v.RepositoryCredentials, ok); err != nil {
			return err
		}
	}

	if v.ResourceRequirements != nil {
		ok := object.Key("ResourceRequirements")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsList(v.ResourceRequirements, ok); err != nil {
			return err
		}
	}

	if v.Secrets != nil {
		ok := object.Key("Secrets")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsList(v.Secrets, ok); err != nil {
			return err
		}
	}

	if v.StartTimeout != 0 {
		ok := object.Key("StartTimeout")
		ok.Integer(v.StartTimeout)
	}

	if v.StopTimeout != 0 {
		ok := object.Key("StopTimeout")
		ok.Integer(v.StopTimeout)
	}

	if v.SystemControls != nil {
		ok := object.Key("SystemControls")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsList(v.SystemControls, ok); err != nil {
			return err
		}
	}

	if v.Ulimits != nil {
		ok := object.Key("Ulimits")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsList(v.Ulimits, ok); err != nil {
			return err
		}
	}

	if v.User != nil {
		ok := object.Key("User")
		ok.String(*v.User)
	}

	if v.VolumesFrom != nil {
		ok := object.Key("VolumesFrom")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromList(v.VolumesFrom, ok); err != nil {
			return err
		}
	}

	if v.WorkingDirectory != nil {
		ok := object.Key("WorkingDirectory")
		ok.String(*v.WorkingDirectory)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesList(v []types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentList(v []types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hostname != nil {
		ok := object.Key("Hostname")
		ok.String(*v.Hostname)
	}

	if v.IpAddress != nil {
		ok := object.Key("IpAddress")
		ok.String(*v.IpAddress)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsList(v []types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsRestjson1_serializeDocumentFieldMap(v.Options, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Command != nil {
		ok := object.Key("Command")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Interval != 0 {
		ok := object.Key("Interval")
		ok.Integer(v.Interval)
	}

	if v.Retries != 0 {
		ok := object.Key("Retries")
		ok.Integer(v.Retries)
	}

	if v.StartPeriod != 0 {
		ok := object.Key("StartPeriod")
		ok.Integer(v.StartPeriod)
	}

	if v.Timeout != 0 {
		ok := object.Key("Timeout")
		ok.Integer(v.Timeout)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Add != nil {
		ok := object.Key("Add")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Add, ok); err != nil {
			return err
		}
	}

	if v.Drop != nil {
		ok := object.Key("Drop")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Drop, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Capabilities != nil {
		ok := object.Key("Capabilities")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails(v.Capabilities, ok); err != nil {
			return err
		}
	}

	if v.Devices != nil {
		ok := object.Key("Devices")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesList(v.Devices, ok); err != nil {
			return err
		}
	}

	if v.InitProcessEnabled {
		ok := object.Key("InitProcessEnabled")
		ok.Boolean(v.InitProcessEnabled)
	}

	if v.MaxSwap != 0 {
		ok := object.Key("MaxSwap")
		ok.Integer(v.MaxSwap)
	}

	if v.SharedMemorySize != 0 {
		ok := object.Key("SharedMemorySize")
		ok.Integer(v.SharedMemorySize)
	}

	if v.Swappiness != 0 {
		ok := object.Key("Swappiness")
		ok.Integer(v.Swappiness)
	}

	if v.Tmpfs != nil {
		ok := object.Key("Tmpfs")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsList(v.Tmpfs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerPath != nil {
		ok := object.Key("ContainerPath")
		ok.String(*v.ContainerPath)
	}

	if v.HostPath != nil {
		ok := object.Key("HostPath")
		ok.String(*v.HostPath)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.Permissions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesList(v []types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerPath != nil {
		ok := object.Key("ContainerPath")
		ok.String(*v.ContainerPath)
	}

	if v.MountOptions != nil {
		ok := object.Key("MountOptions")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.MountOptions, ok); err != nil {
			return err
		}
	}

	if v.Size != 0 {
		ok := object.Key("Size")
		ok.Integer(v.Size)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsList(v []types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsList(v []types.AwsEcsTaskDefinitionContainerDefinitionsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogDriver != nil {
		ok := object.Key("LogDriver")
		ok.String(*v.LogDriver)
	}

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsRestjson1_serializeDocumentFieldMap(v.Options, ok); err != nil {
			return err
		}
	}

	if v.SecretOptions != nil {
		ok := object.Key("SecretOptions")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsList(v.SecretOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ValueFrom != nil {
		ok := object.Key("ValueFrom")
		ok.String(*v.ValueFrom)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsList(v []types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerPath != nil {
		ok := object.Key("ContainerPath")
		ok.String(*v.ContainerPath)
	}

	if v.ReadOnly {
		ok := object.Key("ReadOnly")
		ok.Boolean(v.ReadOnly)
	}

	if v.SourceVolume != nil {
		ok := object.Key("SourceVolume")
		ok.String(*v.SourceVolume)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsList(v []types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerPort != 0 {
		ok := object.Key("ContainerPort")
		ok.Integer(v.ContainerPort)
	}

	if v.HostPort != 0 {
		ok := object.Key("HostPort")
		ok.Integer(v.HostPort)
	}

	if v.Protocol != nil {
		ok := object.Key("Protocol")
		ok.String(*v.Protocol)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsList(v []types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CredentialsParameter != nil {
		ok := object.Key("CredentialsParameter")
		ok.String(*v.CredentialsParameter)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsList(v []types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ValueFrom != nil {
		ok := object.Key("ValueFrom")
		ok.String(*v.ValueFrom)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsList(v []types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Namespace != nil {
		ok := object.Key("Namespace")
		ok.String(*v.Namespace)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsList(v []types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HardLimit != 0 {
		ok := object.Key("HardLimit")
		ok.Integer(v.HardLimit)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SoftLimit != 0 {
		ok := object.Key("SoftLimit")
		ok.Integer(v.SoftLimit)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsList(v []types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails(v *types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReadOnly {
		ok := object.Key("ReadOnly")
		ok.Boolean(v.ReadOnly)
	}

	if v.SourceContainer != nil {
		ok := object.Key("SourceContainer")
		ok.String(*v.SourceContainer)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromList(v []types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionDetails(v *types.AwsEcsTaskDefinitionDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerDefinitions != nil {
		ok := object.Key("ContainerDefinitions")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionContainerDefinitionsList(v.ContainerDefinitions, ok); err != nil {
			return err
		}
	}

	if v.Cpu != nil {
		ok := object.Key("Cpu")
		ok.String(*v.Cpu)
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.Family != nil {
		ok := object.Key("Family")
		ok.String(*v.Family)
	}

	if v.InferenceAccelerators != nil {
		ok := object.Key("InferenceAccelerators")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsList(v.InferenceAccelerators, ok); err != nil {
			return err
		}
	}

	if v.IpcMode != nil {
		ok := object.Key("IpcMode")
		ok.String(*v.IpcMode)
	}

	if v.Memory != nil {
		ok := object.Key("Memory")
		ok.String(*v.Memory)
	}

	if v.NetworkMode != nil {
		ok := object.Key("NetworkMode")
		ok.String(*v.NetworkMode)
	}

	if v.PidMode != nil {
		ok := object.Key("PidMode")
		ok.String(*v.PidMode)
	}

	if v.PlacementConstraints != nil {
		ok := object.Key("PlacementConstraints")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionPlacementConstraintsList(v.PlacementConstraints, ok); err != nil {
			return err
		}
	}

	if v.ProxyConfiguration != nil {
		ok := object.Key("ProxyConfiguration")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionProxyConfigurationDetails(v.ProxyConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RequiresCompatibilities != nil {
		ok := object.Key("RequiresCompatibilities")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.RequiresCompatibilities, ok); err != nil {
			return err
		}
	}

	if v.TaskRoleArn != nil {
		ok := object.Key("TaskRoleArn")
		ok.String(*v.TaskRoleArn)
	}

	if v.Volumes != nil {
		ok := object.Key("Volumes")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesList(v.Volumes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsDetails(v *types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceName != nil {
		ok := object.Key("DeviceName")
		ok.String(*v.DeviceName)
	}

	if v.DeviceType != nil {
		ok := object.Key("DeviceType")
		ok.String(*v.DeviceType)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsList(v []types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionPlacementConstraintsDetails(v *types.AwsEcsTaskDefinitionPlacementConstraintsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionPlacementConstraintsList(v []types.AwsEcsTaskDefinitionPlacementConstraintsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionPlacementConstraintsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionProxyConfigurationDetails(v *types.AwsEcsTaskDefinitionProxyConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerName != nil {
		ok := object.Key("ContainerName")
		ok.String(*v.ContainerName)
	}

	if v.ProxyConfigurationProperties != nil {
		ok := object.Key("ProxyConfigurationProperties")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesList(v.ProxyConfigurationProperties, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails(v *types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesList(v []types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesDetails(v *types.AwsEcsTaskDefinitionVolumesDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DockerVolumeConfiguration != nil {
		ok := object.Key("DockerVolumeConfiguration")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(v.DockerVolumeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EfsVolumeConfiguration != nil {
		ok := object.Key("EfsVolumeConfiguration")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(v.EfsVolumeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Host != nil {
		ok := object.Key("Host")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesHostDetails(v.Host, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(v *types.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Autoprovision {
		ok := object.Key("Autoprovision")
		ok.Boolean(v.Autoprovision)
	}

	if v.Driver != nil {
		ok := object.Key("Driver")
		ok.String(*v.Driver)
	}

	if v.DriverOpts != nil {
		ok := object.Key("DriverOpts")
		if err := awsRestjson1_serializeDocumentFieldMap(v.DriverOpts, ok); err != nil {
			return err
		}
	}

	if v.Labels != nil {
		ok := object.Key("Labels")
		if err := awsRestjson1_serializeDocumentFieldMap(v.Labels, ok); err != nil {
			return err
		}
	}

	if v.Scope != nil {
		ok := object.Key("Scope")
		ok.String(*v.Scope)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails(v *types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessPointId != nil {
		ok := object.Key("AccessPointId")
		ok.String(*v.AccessPointId)
	}

	if v.Iam != nil {
		ok := object.Key("Iam")
		ok.String(*v.Iam)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(v *types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizationConfig != nil {
		ok := object.Key("AuthorizationConfig")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails(v.AuthorizationConfig, ok); err != nil {
			return err
		}
	}

	if v.FilesystemId != nil {
		ok := object.Key("FilesystemId")
		ok.String(*v.FilesystemId)
	}

	if v.RootDirectory != nil {
		ok := object.Key("RootDirectory")
		ok.String(*v.RootDirectory)
	}

	if v.TransitEncryption != nil {
		ok := object.Key("TransitEncryption")
		ok.String(*v.TransitEncryption)
	}

	if v.TransitEncryptionPort != 0 {
		ok := object.Key("TransitEncryptionPort")
		ok.Integer(v.TransitEncryptionPort)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesHostDetails(v *types.AwsEcsTaskDefinitionVolumesHostDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourcePath != nil {
		ok := object.Key("SourcePath")
		ok.String(*v.SourcePath)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesList(v []types.AwsEcsTaskDefinitionVolumesDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionVolumesDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentDetails(v *types.AwsElasticBeanstalkEnvironmentDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationName != nil {
		ok := object.Key("ApplicationName")
		ok.String(*v.ApplicationName)
	}

	if v.Cname != nil {
		ok := object.Key("Cname")
		ok.String(*v.Cname)
	}

	if v.DateCreated != nil {
		ok := object.Key("DateCreated")
		ok.String(*v.DateCreated)
	}

	if v.DateUpdated != nil {
		ok := object.Key("DateUpdated")
		ok.String(*v.DateUpdated)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EndpointUrl != nil {
		ok := object.Key("EndpointUrl")
		ok.String(*v.EndpointUrl)
	}

	if v.EnvironmentArn != nil {
		ok := object.Key("EnvironmentArn")
		ok.String(*v.EnvironmentArn)
	}

	if v.EnvironmentId != nil {
		ok := object.Key("EnvironmentId")
		ok.String(*v.EnvironmentId)
	}

	if v.EnvironmentLinks != nil {
		ok := object.Key("EnvironmentLinks")
		if err := awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLinks(v.EnvironmentLinks, ok); err != nil {
			return err
		}
	}

	if v.EnvironmentName != nil {
		ok := object.Key("EnvironmentName")
		ok.String(*v.EnvironmentName)
	}

	if v.OptionSettings != nil {
		ok := object.Key("OptionSettings")
		if err := awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentOptionSettings(v.OptionSettings, ok); err != nil {
			return err
		}
	}

	if v.PlatformArn != nil {
		ok := object.Key("PlatformArn")
		ok.String(*v.PlatformArn)
	}

	if v.SolutionStackName != nil {
		ok := object.Key("SolutionStackName")
		ok.String(*v.SolutionStackName)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.Tier != nil {
		ok := object.Key("Tier")
		if err := awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentTier(v.Tier, ok); err != nil {
			return err
		}
	}

	if v.VersionLabel != nil {
		ok := object.Key("VersionLabel")
		ok.String(*v.VersionLabel)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLink(v *types.AwsElasticBeanstalkEnvironmentEnvironmentLink, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnvironmentName != nil {
		ok := object.Key("EnvironmentName")
		ok.String(*v.EnvironmentName)
	}

	if v.LinkName != nil {
		ok := object.Key("LinkName")
		ok.String(*v.LinkName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLinks(v []types.AwsElasticBeanstalkEnvironmentEnvironmentLink, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLink(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentOptionSetting(v *types.AwsElasticBeanstalkEnvironmentOptionSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Namespace != nil {
		ok := object.Key("Namespace")
		ok.String(*v.Namespace)
	}

	if v.OptionName != nil {
		ok := object.Key("OptionName")
		ok.String(*v.OptionName)
	}

	if v.ResourceName != nil {
		ok := object.Key("ResourceName")
		ok.String(*v.ResourceName)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentOptionSettings(v []types.AwsElasticBeanstalkEnvironmentOptionSetting, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentOptionSetting(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentTier(v *types.AwsElasticBeanstalkEnvironmentTier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticsearchDomainDetails(v *types.AwsElasticsearchDomainDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessPolicies != nil {
		ok := object.Key("AccessPolicies")
		ok.String(*v.AccessPolicies)
	}

	if v.DomainEndpointOptions != nil {
		ok := object.Key("DomainEndpointOptions")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainDomainEndpointOptions(v.DomainEndpointOptions, ok); err != nil {
			return err
		}
	}

	if v.DomainId != nil {
		ok := object.Key("DomainId")
		ok.String(*v.DomainId)
	}

	if v.DomainName != nil {
		ok := object.Key("DomainName")
		ok.String(*v.DomainName)
	}

	if v.ElasticsearchClusterConfig != nil {
		ok := object.Key("ElasticsearchClusterConfig")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigDetails(v.ElasticsearchClusterConfig, ok); err != nil {
			return err
		}
	}

	if v.ElasticsearchVersion != nil {
		ok := object.Key("ElasticsearchVersion")
		ok.String(*v.ElasticsearchVersion)
	}

	if v.EncryptionAtRestOptions != nil {
		ok := object.Key("EncryptionAtRestOptions")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainEncryptionAtRestOptions(v.EncryptionAtRestOptions, ok); err != nil {
			return err
		}
	}

	if v.Endpoint != nil {
		ok := object.Key("Endpoint")
		ok.String(*v.Endpoint)
	}

	if v.Endpoints != nil {
		ok := object.Key("Endpoints")
		if err := awsRestjson1_serializeDocumentFieldMap(v.Endpoints, ok); err != nil {
			return err
		}
	}

	if v.LogPublishingOptions != nil {
		ok := object.Key("LogPublishingOptions")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainLogPublishingOptions(v.LogPublishingOptions, ok); err != nil {
			return err
		}
	}

	if v.NodeToNodeEncryptionOptions != nil {
		ok := object.Key("NodeToNodeEncryptionOptions")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainNodeToNodeEncryptionOptions(v.NodeToNodeEncryptionOptions, ok); err != nil {
			return err
		}
	}

	if v.ServiceSoftwareOptions != nil {
		ok := object.Key("ServiceSoftwareOptions")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainServiceSoftwareOptions(v.ServiceSoftwareOptions, ok); err != nil {
			return err
		}
	}

	if v.VPCOptions != nil {
		ok := object.Key("VPCOptions")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainVPCOptions(v.VPCOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticsearchDomainDomainEndpointOptions(v *types.AwsElasticsearchDomainDomainEndpointOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnforceHTTPS {
		ok := object.Key("EnforceHTTPS")
		ok.Boolean(v.EnforceHTTPS)
	}

	if v.TLSSecurityPolicy != nil {
		ok := object.Key("TLSSecurityPolicy")
		ok.String(*v.TLSSecurityPolicy)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigDetails(v *types.AwsElasticsearchDomainElasticsearchClusterConfigDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DedicatedMasterCount != 0 {
		ok := object.Key("DedicatedMasterCount")
		ok.Integer(v.DedicatedMasterCount)
	}

	if v.DedicatedMasterEnabled {
		ok := object.Key("DedicatedMasterEnabled")
		ok.Boolean(v.DedicatedMasterEnabled)
	}

	if v.DedicatedMasterType != nil {
		ok := object.Key("DedicatedMasterType")
		ok.String(*v.DedicatedMasterType)
	}

	if v.InstanceCount != 0 {
		ok := object.Key("InstanceCount")
		ok.Integer(v.InstanceCount)
	}

	if v.InstanceType != nil {
		ok := object.Key("InstanceType")
		ok.String(*v.InstanceType)
	}

	if v.ZoneAwarenessConfig != nil {
		ok := object.Key("ZoneAwarenessConfig")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails(v.ZoneAwarenessConfig, ok); err != nil {
			return err
		}
	}

	if v.ZoneAwarenessEnabled {
		ok := object.Key("ZoneAwarenessEnabled")
		ok.Boolean(v.ZoneAwarenessEnabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails(v *types.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZoneCount != 0 {
		ok := object.Key("AvailabilityZoneCount")
		ok.Integer(v.AvailabilityZoneCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticsearchDomainEncryptionAtRestOptions(v *types.AwsElasticsearchDomainEncryptionAtRestOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticsearchDomainLogPublishingOptions(v *types.AwsElasticsearchDomainLogPublishingOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditLogs != nil {
		ok := object.Key("AuditLogs")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(v.AuditLogs, ok); err != nil {
			return err
		}
	}

	if v.IndexSlowLogs != nil {
		ok := object.Key("IndexSlowLogs")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(v.IndexSlowLogs, ok); err != nil {
			return err
		}
	}

	if v.SearchSlowLogs != nil {
		ok := object.Key("SearchSlowLogs")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(v.SearchSlowLogs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(v *types.AwsElasticsearchDomainLogPublishingOptionsLogConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLogsLogGroupArn != nil {
		ok := object.Key("CloudWatchLogsLogGroupArn")
		ok.String(*v.CloudWatchLogsLogGroupArn)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticsearchDomainNodeToNodeEncryptionOptions(v *types.AwsElasticsearchDomainNodeToNodeEncryptionOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticsearchDomainServiceSoftwareOptions(v *types.AwsElasticsearchDomainServiceSoftwareOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutomatedUpdateDate != nil {
		ok := object.Key("AutomatedUpdateDate")
		ok.String(*v.AutomatedUpdateDate)
	}

	if v.Cancellable {
		ok := object.Key("Cancellable")
		ok.Boolean(v.Cancellable)
	}

	if v.CurrentVersion != nil {
		ok := object.Key("CurrentVersion")
		ok.String(*v.CurrentVersion)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.NewVersion != nil {
		ok := object.Key("NewVersion")
		ok.String(*v.NewVersion)
	}

	if v.UpdateAvailable {
		ok := object.Key("UpdateAvailable")
		ok.Boolean(v.UpdateAvailable)
	}

	if v.UpdateStatus != nil {
		ok := object.Key("UpdateStatus")
		ok.String(*v.UpdateStatus)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElasticsearchDomainVPCOptions(v *types.AwsElasticsearchDomainVPCOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZones != nil {
		ok := object.Key("AvailabilityZones")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.AvailabilityZones, ok); err != nil {
			return err
		}
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.VPCId != nil {
		ok := object.Key("VPCId")
		ok.String(*v.VPCId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbAppCookieStickinessPolicies(v []types.AwsElbAppCookieStickinessPolicy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsElbAppCookieStickinessPolicy(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsElbAppCookieStickinessPolicy(v *types.AwsElbAppCookieStickinessPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CookieName != nil {
		ok := object.Key("CookieName")
		ok.String(*v.CookieName)
	}

	if v.PolicyName != nil {
		ok := object.Key("PolicyName")
		ok.String(*v.PolicyName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLbCookieStickinessPolicies(v []types.AwsElbLbCookieStickinessPolicy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsElbLbCookieStickinessPolicy(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsElbLbCookieStickinessPolicy(v *types.AwsElbLbCookieStickinessPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CookieExpirationPeriod != 0 {
		ok := object.Key("CookieExpirationPeriod")
		ok.Long(v.CookieExpirationPeriod)
	}

	if v.PolicyName != nil {
		ok := object.Key("PolicyName")
		ok.String(*v.PolicyName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerAccessLog(v *types.AwsElbLoadBalancerAccessLog, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EmitInterval != 0 {
		ok := object.Key("EmitInterval")
		ok.Integer(v.EmitInterval)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.S3BucketName != nil {
		ok := object.Key("S3BucketName")
		ok.String(*v.S3BucketName)
	}

	if v.S3BucketPrefix != nil {
		ok := object.Key("S3BucketPrefix")
		ok.String(*v.S3BucketPrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerAttributes(v *types.AwsElbLoadBalancerAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessLog != nil {
		ok := object.Key("AccessLog")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerAccessLog(v.AccessLog, ok); err != nil {
			return err
		}
	}

	if v.ConnectionDraining != nil {
		ok := object.Key("ConnectionDraining")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerConnectionDraining(v.ConnectionDraining, ok); err != nil {
			return err
		}
	}

	if v.ConnectionSettings != nil {
		ok := object.Key("ConnectionSettings")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerConnectionSettings(v.ConnectionSettings, ok); err != nil {
			return err
		}
	}

	if v.CrossZoneLoadBalancing != nil {
		ok := object.Key("CrossZoneLoadBalancing")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerCrossZoneLoadBalancing(v.CrossZoneLoadBalancing, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerBackendServerDescription(v *types.AwsElbLoadBalancerBackendServerDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstancePort != 0 {
		ok := object.Key("InstancePort")
		ok.Integer(v.InstancePort)
	}

	if v.PolicyNames != nil {
		ok := object.Key("PolicyNames")
		if err := awsRestjson1_serializeDocumentStringList(v.PolicyNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerBackendServerDescriptions(v []types.AwsElbLoadBalancerBackendServerDescription, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerBackendServerDescription(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerConnectionDraining(v *types.AwsElbLoadBalancerConnectionDraining, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.Timeout != 0 {
		ok := object.Key("Timeout")
		ok.Integer(v.Timeout)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerConnectionSettings(v *types.AwsElbLoadBalancerConnectionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdleTimeout != 0 {
		ok := object.Key("IdleTimeout")
		ok.Integer(v.IdleTimeout)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerCrossZoneLoadBalancing(v *types.AwsElbLoadBalancerCrossZoneLoadBalancing, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerDetails(v *types.AwsElbLoadBalancerDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZones != nil {
		ok := object.Key("AvailabilityZones")
		if err := awsRestjson1_serializeDocumentStringList(v.AvailabilityZones, ok); err != nil {
			return err
		}
	}

	if v.BackendServerDescriptions != nil {
		ok := object.Key("BackendServerDescriptions")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerBackendServerDescriptions(v.BackendServerDescriptions, ok); err != nil {
			return err
		}
	}

	if v.CanonicalHostedZoneName != nil {
		ok := object.Key("CanonicalHostedZoneName")
		ok.String(*v.CanonicalHostedZoneName)
	}

	if v.CanonicalHostedZoneNameID != nil {
		ok := object.Key("CanonicalHostedZoneNameID")
		ok.String(*v.CanonicalHostedZoneNameID)
	}

	if v.CreatedTime != nil {
		ok := object.Key("CreatedTime")
		ok.String(*v.CreatedTime)
	}

	if v.DnsName != nil {
		ok := object.Key("DnsName")
		ok.String(*v.DnsName)
	}

	if v.HealthCheck != nil {
		ok := object.Key("HealthCheck")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerHealthCheck(v.HealthCheck, ok); err != nil {
			return err
		}
	}

	if v.Instances != nil {
		ok := object.Key("Instances")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerInstances(v.Instances, ok); err != nil {
			return err
		}
	}

	if v.ListenerDescriptions != nil {
		ok := object.Key("ListenerDescriptions")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerListenerDescriptions(v.ListenerDescriptions, ok); err != nil {
			return err
		}
	}

	if v.LoadBalancerAttributes != nil {
		ok := object.Key("LoadBalancerAttributes")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerAttributes(v.LoadBalancerAttributes, ok); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		ok := object.Key("LoadBalancerName")
		ok.String(*v.LoadBalancerName)
	}

	if v.Policies != nil {
		ok := object.Key("Policies")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerPolicies(v.Policies, ok); err != nil {
			return err
		}
	}

	if v.Scheme != nil {
		ok := object.Key("Scheme")
		ok.String(*v.Scheme)
	}

	if v.SecurityGroups != nil {
		ok := object.Key("SecurityGroups")
		if err := awsRestjson1_serializeDocumentStringList(v.SecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.SourceSecurityGroup != nil {
		ok := object.Key("SourceSecurityGroup")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerSourceSecurityGroup(v.SourceSecurityGroup, ok); err != nil {
			return err
		}
	}

	if v.Subnets != nil {
		ok := object.Key("Subnets")
		if err := awsRestjson1_serializeDocumentStringList(v.Subnets, ok); err != nil {
			return err
		}
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerHealthCheck(v *types.AwsElbLoadBalancerHealthCheck, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HealthyThreshold != 0 {
		ok := object.Key("HealthyThreshold")
		ok.Integer(v.HealthyThreshold)
	}

	if v.Interval != 0 {
		ok := object.Key("Interval")
		ok.Integer(v.Interval)
	}

	if v.Target != nil {
		ok := object.Key("Target")
		ok.String(*v.Target)
	}

	if v.Timeout != 0 {
		ok := object.Key("Timeout")
		ok.Integer(v.Timeout)
	}

	if v.UnhealthyThreshold != 0 {
		ok := object.Key("UnhealthyThreshold")
		ok.Integer(v.UnhealthyThreshold)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerInstance(v *types.AwsElbLoadBalancerInstance, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerInstances(v []types.AwsElbLoadBalancerInstance, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerInstance(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerListener(v *types.AwsElbLoadBalancerListener, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstancePort != 0 {
		ok := object.Key("InstancePort")
		ok.Integer(v.InstancePort)
	}

	if v.InstanceProtocol != nil {
		ok := object.Key("InstanceProtocol")
		ok.String(*v.InstanceProtocol)
	}

	if v.LoadBalancerPort != 0 {
		ok := object.Key("LoadBalancerPort")
		ok.Integer(v.LoadBalancerPort)
	}

	if v.Protocol != nil {
		ok := object.Key("Protocol")
		ok.String(*v.Protocol)
	}

	if v.SslCertificateId != nil {
		ok := object.Key("SslCertificateId")
		ok.String(*v.SslCertificateId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerListenerDescription(v *types.AwsElbLoadBalancerListenerDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Listener != nil {
		ok := object.Key("Listener")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerListener(v.Listener, ok); err != nil {
			return err
		}
	}

	if v.PolicyNames != nil {
		ok := object.Key("PolicyNames")
		if err := awsRestjson1_serializeDocumentStringList(v.PolicyNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerListenerDescriptions(v []types.AwsElbLoadBalancerListenerDescription, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerListenerDescription(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerPolicies(v *types.AwsElbLoadBalancerPolicies, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppCookieStickinessPolicies != nil {
		ok := object.Key("AppCookieStickinessPolicies")
		if err := awsRestjson1_serializeDocumentAwsElbAppCookieStickinessPolicies(v.AppCookieStickinessPolicies, ok); err != nil {
			return err
		}
	}

	if v.LbCookieStickinessPolicies != nil {
		ok := object.Key("LbCookieStickinessPolicies")
		if err := awsRestjson1_serializeDocumentAwsElbLbCookieStickinessPolicies(v.LbCookieStickinessPolicies, ok); err != nil {
			return err
		}
	}

	if v.OtherPolicies != nil {
		ok := object.Key("OtherPolicies")
		if err := awsRestjson1_serializeDocumentStringList(v.OtherPolicies, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbLoadBalancerSourceSecurityGroup(v *types.AwsElbLoadBalancerSourceSecurityGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.OwnerAlias != nil {
		ok := object.Key("OwnerAlias")
		ok.String(*v.OwnerAlias)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsElbv2LoadBalancerDetails(v *types.AwsElbv2LoadBalancerDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZones != nil {
		ok := object.Key("AvailabilityZones")
		if err := awsRestjson1_serializeDocumentAvailabilityZones(v.AvailabilityZones, ok); err != nil {
			return err
		}
	}

	if v.CanonicalHostedZoneId != nil {
		ok := object.Key("CanonicalHostedZoneId")
		ok.String(*v.CanonicalHostedZoneId)
	}

	if v.CreatedTime != nil {
		ok := object.Key("CreatedTime")
		ok.String(*v.CreatedTime)
	}

	if v.DNSName != nil {
		ok := object.Key("DNSName")
		ok.String(*v.DNSName)
	}

	if v.IpAddressType != nil {
		ok := object.Key("IpAddressType")
		ok.String(*v.IpAddressType)
	}

	if v.Scheme != nil {
		ok := object.Key("Scheme")
		ok.String(*v.Scheme)
	}

	if v.SecurityGroups != nil {
		ok := object.Key("SecurityGroups")
		if err := awsRestjson1_serializeDocumentSecurityGroups(v.SecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.State != nil {
		ok := object.Key("State")
		if err := awsRestjson1_serializeDocumentLoadBalancerState(v.State, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamAccessKeyDetails(v *types.AwsIamAccessKeyDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessKeyId != nil {
		ok := object.Key("AccessKeyId")
		ok.String(*v.AccessKeyId)
	}

	if v.AccountId != nil {
		ok := object.Key("AccountId")
		ok.String(*v.AccountId)
	}

	if v.CreatedAt != nil {
		ok := object.Key("CreatedAt")
		ok.String(*v.CreatedAt)
	}

	if v.PrincipalId != nil {
		ok := object.Key("PrincipalId")
		ok.String(*v.PrincipalId)
	}

	if v.PrincipalName != nil {
		ok := object.Key("PrincipalName")
		ok.String(*v.PrincipalName)
	}

	if v.PrincipalType != nil {
		ok := object.Key("PrincipalType")
		ok.String(*v.PrincipalType)
	}

	if v.SessionContext != nil {
		ok := object.Key("SessionContext")
		if err := awsRestjson1_serializeDocumentAwsIamAccessKeySessionContext(v.SessionContext, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if v.UserName != nil {
		ok := object.Key("UserName")
		ok.String(*v.UserName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamAccessKeySessionContext(v *types.AwsIamAccessKeySessionContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentAwsIamAccessKeySessionContextAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.SessionIssuer != nil {
		ok := object.Key("SessionIssuer")
		if err := awsRestjson1_serializeDocumentAwsIamAccessKeySessionContextSessionIssuer(v.SessionIssuer, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamAccessKeySessionContextAttributes(v *types.AwsIamAccessKeySessionContextAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CreationDate != nil {
		ok := object.Key("CreationDate")
		ok.String(*v.CreationDate)
	}

	if v.MfaAuthenticated {
		ok := object.Key("MfaAuthenticated")
		ok.Boolean(v.MfaAuthenticated)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamAccessKeySessionContextSessionIssuer(v *types.AwsIamAccessKeySessionContextSessionIssuer, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("AccountId")
		ok.String(*v.AccountId)
	}

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.PrincipalId != nil {
		ok := object.Key("PrincipalId")
		ok.String(*v.PrincipalId)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	if v.UserName != nil {
		ok := object.Key("UserName")
		ok.String(*v.UserName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamAttachedManagedPolicy(v *types.AwsIamAttachedManagedPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyArn != nil {
		ok := object.Key("PolicyArn")
		ok.String(*v.PolicyArn)
	}

	if v.PolicyName != nil {
		ok := object.Key("PolicyName")
		ok.String(*v.PolicyName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamAttachedManagedPolicyList(v []types.AwsIamAttachedManagedPolicy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsIamAttachedManagedPolicy(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsIamGroupDetails(v *types.AwsIamGroupDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttachedManagedPolicies != nil {
		ok := object.Key("AttachedManagedPolicies")
		if err := awsRestjson1_serializeDocumentAwsIamAttachedManagedPolicyList(v.AttachedManagedPolicies, ok); err != nil {
			return err
		}
	}

	if v.CreateDate != nil {
		ok := object.Key("CreateDate")
		ok.String(*v.CreateDate)
	}

	if v.GroupId != nil {
		ok := object.Key("GroupId")
		ok.String(*v.GroupId)
	}

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.GroupPolicyList != nil {
		ok := object.Key("GroupPolicyList")
		if err := awsRestjson1_serializeDocumentAwsIamGroupPolicyList(v.GroupPolicyList, ok); err != nil {
			return err
		}
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamGroupPolicy(v *types.AwsIamGroupPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyName != nil {
		ok := object.Key("PolicyName")
		ok.String(*v.PolicyName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamGroupPolicyList(v []types.AwsIamGroupPolicy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsIamGroupPolicy(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsIamInstanceProfile(v *types.AwsIamInstanceProfile, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.CreateDate != nil {
		ok := object.Key("CreateDate")
		ok.String(*v.CreateDate)
	}

	if v.InstanceProfileId != nil {
		ok := object.Key("InstanceProfileId")
		ok.String(*v.InstanceProfileId)
	}

	if v.InstanceProfileName != nil {
		ok := object.Key("InstanceProfileName")
		ok.String(*v.InstanceProfileName)
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.Roles != nil {
		ok := object.Key("Roles")
		if err := awsRestjson1_serializeDocumentAwsIamInstanceProfileRoles(v.Roles, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamInstanceProfileList(v []types.AwsIamInstanceProfile, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsIamInstanceProfile(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsIamInstanceProfileRole(v *types.AwsIamInstanceProfileRole, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.AssumeRolePolicyDocument != nil {
		ok := object.Key("AssumeRolePolicyDocument")
		ok.String(*v.AssumeRolePolicyDocument)
	}

	if v.CreateDate != nil {
		ok := object.Key("CreateDate")
		ok.String(*v.CreateDate)
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.RoleId != nil {
		ok := object.Key("RoleId")
		ok.String(*v.RoleId)
	}

	if v.RoleName != nil {
		ok := object.Key("RoleName")
		ok.String(*v.RoleName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamInstanceProfileRoles(v []types.AwsIamInstanceProfileRole, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsIamInstanceProfileRole(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsIamPermissionsBoundary(v *types.AwsIamPermissionsBoundary, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PermissionsBoundaryArn != nil {
		ok := object.Key("PermissionsBoundaryArn")
		ok.String(*v.PermissionsBoundaryArn)
	}

	if v.PermissionsBoundaryType != nil {
		ok := object.Key("PermissionsBoundaryType")
		ok.String(*v.PermissionsBoundaryType)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamPolicyDetails(v *types.AwsIamPolicyDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttachmentCount != 0 {
		ok := object.Key("AttachmentCount")
		ok.Integer(v.AttachmentCount)
	}

	if v.CreateDate != nil {
		ok := object.Key("CreateDate")
		ok.String(*v.CreateDate)
	}

	if v.DefaultVersionId != nil {
		ok := object.Key("DefaultVersionId")
		ok.String(*v.DefaultVersionId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.IsAttachable {
		ok := object.Key("IsAttachable")
		ok.Boolean(v.IsAttachable)
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.PermissionsBoundaryUsageCount != 0 {
		ok := object.Key("PermissionsBoundaryUsageCount")
		ok.Integer(v.PermissionsBoundaryUsageCount)
	}

	if v.PolicyId != nil {
		ok := object.Key("PolicyId")
		ok.String(*v.PolicyId)
	}

	if v.PolicyName != nil {
		ok := object.Key("PolicyName")
		ok.String(*v.PolicyName)
	}

	if v.PolicyVersionList != nil {
		ok := object.Key("PolicyVersionList")
		if err := awsRestjson1_serializeDocumentAwsIamPolicyVersionList(v.PolicyVersionList, ok); err != nil {
			return err
		}
	}

	if v.UpdateDate != nil {
		ok := object.Key("UpdateDate")
		ok.String(*v.UpdateDate)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamPolicyVersion(v *types.AwsIamPolicyVersion, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CreateDate != nil {
		ok := object.Key("CreateDate")
		ok.String(*v.CreateDate)
	}

	if v.IsDefaultVersion {
		ok := object.Key("IsDefaultVersion")
		ok.Boolean(v.IsDefaultVersion)
	}

	if v.VersionId != nil {
		ok := object.Key("VersionId")
		ok.String(*v.VersionId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamPolicyVersionList(v []types.AwsIamPolicyVersion, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsIamPolicyVersion(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsIamRoleDetails(v *types.AwsIamRoleDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssumeRolePolicyDocument != nil {
		ok := object.Key("AssumeRolePolicyDocument")
		ok.String(*v.AssumeRolePolicyDocument)
	}

	if v.AttachedManagedPolicies != nil {
		ok := object.Key("AttachedManagedPolicies")
		if err := awsRestjson1_serializeDocumentAwsIamAttachedManagedPolicyList(v.AttachedManagedPolicies, ok); err != nil {
			return err
		}
	}

	if v.CreateDate != nil {
		ok := object.Key("CreateDate")
		ok.String(*v.CreateDate)
	}

	if v.InstanceProfileList != nil {
		ok := object.Key("InstanceProfileList")
		if err := awsRestjson1_serializeDocumentAwsIamInstanceProfileList(v.InstanceProfileList, ok); err != nil {
			return err
		}
	}

	if v.MaxSessionDuration != 0 {
		ok := object.Key("MaxSessionDuration")
		ok.Integer(v.MaxSessionDuration)
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.PermissionsBoundary != nil {
		ok := object.Key("PermissionsBoundary")
		if err := awsRestjson1_serializeDocumentAwsIamPermissionsBoundary(v.PermissionsBoundary, ok); err != nil {
			return err
		}
	}

	if v.RoleId != nil {
		ok := object.Key("RoleId")
		ok.String(*v.RoleId)
	}

	if v.RoleName != nil {
		ok := object.Key("RoleName")
		ok.String(*v.RoleName)
	}

	if v.RolePolicyList != nil {
		ok := object.Key("RolePolicyList")
		if err := awsRestjson1_serializeDocumentAwsIamRolePolicyList(v.RolePolicyList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamRolePolicy(v *types.AwsIamRolePolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyName != nil {
		ok := object.Key("PolicyName")
		ok.String(*v.PolicyName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamRolePolicyList(v []types.AwsIamRolePolicy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsIamRolePolicy(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsIamUserDetails(v *types.AwsIamUserDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttachedManagedPolicies != nil {
		ok := object.Key("AttachedManagedPolicies")
		if err := awsRestjson1_serializeDocumentAwsIamAttachedManagedPolicyList(v.AttachedManagedPolicies, ok); err != nil {
			return err
		}
	}

	if v.CreateDate != nil {
		ok := object.Key("CreateDate")
		ok.String(*v.CreateDate)
	}

	if v.GroupList != nil {
		ok := object.Key("GroupList")
		if err := awsRestjson1_serializeDocumentStringList(v.GroupList, ok); err != nil {
			return err
		}
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.PermissionsBoundary != nil {
		ok := object.Key("PermissionsBoundary")
		if err := awsRestjson1_serializeDocumentAwsIamPermissionsBoundary(v.PermissionsBoundary, ok); err != nil {
			return err
		}
	}

	if v.UserId != nil {
		ok := object.Key("UserId")
		ok.String(*v.UserId)
	}

	if v.UserName != nil {
		ok := object.Key("UserName")
		ok.String(*v.UserName)
	}

	if v.UserPolicyList != nil {
		ok := object.Key("UserPolicyList")
		if err := awsRestjson1_serializeDocumentAwsIamUserPolicyList(v.UserPolicyList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamUserPolicy(v *types.AwsIamUserPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyName != nil {
		ok := object.Key("PolicyName")
		ok.String(*v.PolicyName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamUserPolicyList(v []types.AwsIamUserPolicy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsIamUserPolicy(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsKmsKeyDetails(v *types.AwsKmsKeyDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AWSAccountId != nil {
		ok := object.Key("AWSAccountId")
		ok.String(*v.AWSAccountId)
	}

	if v.CreationDate != 0 {
		ok := object.Key("CreationDate")
		switch {
		case math.IsNaN(v.CreationDate):
			ok.String("NaN")

		case math.IsInf(v.CreationDate, 1):
			ok.String("Infinity")

		case math.IsInf(v.CreationDate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.CreationDate)

		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.KeyId != nil {
		ok := object.Key("KeyId")
		ok.String(*v.KeyId)
	}

	if v.KeyManager != nil {
		ok := object.Key("KeyManager")
		ok.String(*v.KeyManager)
	}

	if v.KeyRotationStatus {
		ok := object.Key("KeyRotationStatus")
		ok.Boolean(v.KeyRotationStatus)
	}

	if v.KeyState != nil {
		ok := object.Key("KeyState")
		ok.String(*v.KeyState)
	}

	if v.Origin != nil {
		ok := object.Key("Origin")
		ok.String(*v.Origin)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsLambdaFunctionCode(v *types.AwsLambdaFunctionCode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Bucket != nil {
		ok := object.Key("S3Bucket")
		ok.String(*v.S3Bucket)
	}

	if v.S3Key != nil {
		ok := object.Key("S3Key")
		ok.String(*v.S3Key)
	}

	if v.S3ObjectVersion != nil {
		ok := object.Key("S3ObjectVersion")
		ok.String(*v.S3ObjectVersion)
	}

	if v.ZipFile != nil {
		ok := object.Key("ZipFile")
		ok.String(*v.ZipFile)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsLambdaFunctionDeadLetterConfig(v *types.AwsLambdaFunctionDeadLetterConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetArn != nil {
		ok := object.Key("TargetArn")
		ok.String(*v.TargetArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsLambdaFunctionDetails(v *types.AwsLambdaFunctionDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Code != nil {
		ok := object.Key("Code")
		if err := awsRestjson1_serializeDocumentAwsLambdaFunctionCode(v.Code, ok); err != nil {
			return err
		}
	}

	if v.CodeSha256 != nil {
		ok := object.Key("CodeSha256")
		ok.String(*v.CodeSha256)
	}

	if v.DeadLetterConfig != nil {
		ok := object.Key("DeadLetterConfig")
		if err := awsRestjson1_serializeDocumentAwsLambdaFunctionDeadLetterConfig(v.DeadLetterConfig, ok); err != nil {
			return err
		}
	}

	if v.Environment != nil {
		ok := object.Key("Environment")
		if err := awsRestjson1_serializeDocumentAwsLambdaFunctionEnvironment(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.FunctionName != nil {
		ok := object.Key("FunctionName")
		ok.String(*v.FunctionName)
	}

	if v.Handler != nil {
		ok := object.Key("Handler")
		ok.String(*v.Handler)
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("KmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.LastModified != nil {
		ok := object.Key("LastModified")
		ok.String(*v.LastModified)
	}

	if v.Layers != nil {
		ok := object.Key("Layers")
		if err := awsRestjson1_serializeDocumentAwsLambdaFunctionLayerList(v.Layers, ok); err != nil {
			return err
		}
	}

	if v.MasterArn != nil {
		ok := object.Key("MasterArn")
		ok.String(*v.MasterArn)
	}

	if v.MemorySize != 0 {
		ok := object.Key("MemorySize")
		ok.Integer(v.MemorySize)
	}

	if v.RevisionId != nil {
		ok := object.Key("RevisionId")
		ok.String(*v.RevisionId)
	}

	if v.Role != nil {
		ok := object.Key("Role")
		ok.String(*v.Role)
	}

	if v.Runtime != nil {
		ok := object.Key("Runtime")
		ok.String(*v.Runtime)
	}

	if v.Timeout != 0 {
		ok := object.Key("Timeout")
		ok.Integer(v.Timeout)
	}

	if v.TracingConfig != nil {
		ok := object.Key("TracingConfig")
		if err := awsRestjson1_serializeDocumentAwsLambdaFunctionTracingConfig(v.TracingConfig, ok); err != nil {
			return err
		}
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	if v.VpcConfig != nil {
		ok := object.Key("VpcConfig")
		if err := awsRestjson1_serializeDocumentAwsLambdaFunctionVpcConfig(v.VpcConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsLambdaFunctionEnvironment(v *types.AwsLambdaFunctionEnvironment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Error != nil {
		ok := object.Key("Error")
		if err := awsRestjson1_serializeDocumentAwsLambdaFunctionEnvironmentError(v.Error, ok); err != nil {
			return err
		}
	}

	if v.Variables != nil {
		ok := object.Key("Variables")
		if err := awsRestjson1_serializeDocumentFieldMap(v.Variables, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsLambdaFunctionEnvironmentError(v *types.AwsLambdaFunctionEnvironmentError, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ErrorCode != nil {
		ok := object.Key("ErrorCode")
		ok.String(*v.ErrorCode)
	}

	if v.Message != nil {
		ok := object.Key("Message")
		ok.String(*v.Message)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsLambdaFunctionLayer(v *types.AwsLambdaFunctionLayer, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.CodeSize != 0 {
		ok := object.Key("CodeSize")
		ok.Integer(v.CodeSize)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsLambdaFunctionLayerList(v []types.AwsLambdaFunctionLayer, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsLambdaFunctionLayer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsLambdaFunctionTracingConfig(v *types.AwsLambdaFunctionTracingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Mode != nil {
		ok := object.Key("Mode")
		ok.String(*v.Mode)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsLambdaFunctionVpcConfig(v *types.AwsLambdaFunctionVpcConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsLambdaLayerVersionDetails(v *types.AwsLambdaLayerVersionDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CompatibleRuntimes != nil {
		ok := object.Key("CompatibleRuntimes")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.CompatibleRuntimes, ok); err != nil {
			return err
		}
	}

	if v.CreatedDate != nil {
		ok := object.Key("CreatedDate")
		ok.String(*v.CreatedDate)
	}

	if v.Version != 0 {
		ok := object.Key("Version")
		ok.Long(v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbClusterAssociatedRole(v *types.AwsRdsDbClusterAssociatedRole, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbClusterAssociatedRoles(v []types.AwsRdsDbClusterAssociatedRole, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRdsDbClusterAssociatedRole(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbClusterDetails(v *types.AwsRdsDbClusterDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActivityStreamStatus != nil {
		ok := object.Key("ActivityStreamStatus")
		ok.String(*v.ActivityStreamStatus)
	}

	if v.AllocatedStorage != 0 {
		ok := object.Key("AllocatedStorage")
		ok.Integer(v.AllocatedStorage)
	}

	if v.AssociatedRoles != nil {
		ok := object.Key("AssociatedRoles")
		if err := awsRestjson1_serializeDocumentAwsRdsDbClusterAssociatedRoles(v.AssociatedRoles, ok); err != nil {
			return err
		}
	}

	if v.AvailabilityZones != nil {
		ok := object.Key("AvailabilityZones")
		if err := awsRestjson1_serializeDocumentStringList(v.AvailabilityZones, ok); err != nil {
			return err
		}
	}

	if v.BackupRetentionPeriod != 0 {
		ok := object.Key("BackupRetentionPeriod")
		ok.Integer(v.BackupRetentionPeriod)
	}

	if v.ClusterCreateTime != nil {
		ok := object.Key("ClusterCreateTime")
		ok.String(*v.ClusterCreateTime)
	}

	if v.CopyTagsToSnapshot {
		ok := object.Key("CopyTagsToSnapshot")
		ok.Boolean(v.CopyTagsToSnapshot)
	}

	if v.CrossAccountClone {
		ok := object.Key("CrossAccountClone")
		ok.Boolean(v.CrossAccountClone)
	}

	if v.CustomEndpoints != nil {
		ok := object.Key("CustomEndpoints")
		if err := awsRestjson1_serializeDocumentStringList(v.CustomEndpoints, ok); err != nil {
			return err
		}
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.DbClusterIdentifier != nil {
		ok := object.Key("DbClusterIdentifier")
		ok.String(*v.DbClusterIdentifier)
	}

	if v.DbClusterMembers != nil {
		ok := object.Key("DbClusterMembers")
		if err := awsRestjson1_serializeDocumentAwsRdsDbClusterMembers(v.DbClusterMembers, ok); err != nil {
			return err
		}
	}

	if v.DbClusterOptionGroupMemberships != nil {
		ok := object.Key("DbClusterOptionGroupMemberships")
		if err := awsRestjson1_serializeDocumentAwsRdsDbClusterOptionGroupMemberships(v.DbClusterOptionGroupMemberships, ok); err != nil {
			return err
		}
	}

	if v.DbClusterParameterGroup != nil {
		ok := object.Key("DbClusterParameterGroup")
		ok.String(*v.DbClusterParameterGroup)
	}

	if v.DbClusterResourceId != nil {
		ok := object.Key("DbClusterResourceId")
		ok.String(*v.DbClusterResourceId)
	}

	if v.DbSubnetGroup != nil {
		ok := object.Key("DbSubnetGroup")
		ok.String(*v.DbSubnetGroup)
	}

	if v.DeletionProtection {
		ok := object.Key("DeletionProtection")
		ok.Boolean(v.DeletionProtection)
	}

	if v.DomainMemberships != nil {
		ok := object.Key("DomainMemberships")
		if err := awsRestjson1_serializeDocumentAwsRdsDbDomainMemberships(v.DomainMemberships, ok); err != nil {
			return err
		}
	}

	if v.EnabledCloudWatchLogsExports != nil {
		ok := object.Key("EnabledCloudWatchLogsExports")
		if err := awsRestjson1_serializeDocumentStringList(v.EnabledCloudWatchLogsExports, ok); err != nil {
			return err
		}
	}

	if v.Endpoint != nil {
		ok := object.Key("Endpoint")
		ok.String(*v.Endpoint)
	}

	if v.Engine != nil {
		ok := object.Key("Engine")
		ok.String(*v.Engine)
	}

	if v.EngineMode != nil {
		ok := object.Key("EngineMode")
		ok.String(*v.EngineMode)
	}

	if v.EngineVersion != nil {
		ok := object.Key("EngineVersion")
		ok.String(*v.EngineVersion)
	}

	if v.HostedZoneId != nil {
		ok := object.Key("HostedZoneId")
		ok.String(*v.HostedZoneId)
	}

	if v.HttpEndpointEnabled {
		ok := object.Key("HttpEndpointEnabled")
		ok.Boolean(v.HttpEndpointEnabled)
	}

	if v.IamDatabaseAuthenticationEnabled {
		ok := object.Key("IamDatabaseAuthenticationEnabled")
		ok.Boolean(v.IamDatabaseAuthenticationEnabled)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.MasterUsername != nil {
		ok := object.Key("MasterUsername")
		ok.String(*v.MasterUsername)
	}

	if v.MultiAz {
		ok := object.Key("MultiAz")
		ok.Boolean(v.MultiAz)
	}

	if v.Port != 0 {
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	if v.PreferredBackupWindow != nil {
		ok := object.Key("PreferredBackupWindow")
		ok.String(*v.PreferredBackupWindow)
	}

	if v.PreferredMaintenanceWindow != nil {
		ok := object.Key("PreferredMaintenanceWindow")
		ok.String(*v.PreferredMaintenanceWindow)
	}

	if v.ReaderEndpoint != nil {
		ok := object.Key("ReaderEndpoint")
		ok.String(*v.ReaderEndpoint)
	}

	if v.ReadReplicaIdentifiers != nil {
		ok := object.Key("ReadReplicaIdentifiers")
		if err := awsRestjson1_serializeDocumentStringList(v.ReadReplicaIdentifiers, ok); err != nil {
			return err
		}
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.StorageEncrypted {
		ok := object.Key("StorageEncrypted")
		ok.Boolean(v.StorageEncrypted)
	}

	if v.VpcSecurityGroups != nil {
		ok := object.Key("VpcSecurityGroups")
		if err := awsRestjson1_serializeDocumentAwsRdsDbInstanceVpcSecurityGroups(v.VpcSecurityGroups, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbClusterMember(v *types.AwsRdsDbClusterMember, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DbClusterParameterGroupStatus != nil {
		ok := object.Key("DbClusterParameterGroupStatus")
		ok.String(*v.DbClusterParameterGroupStatus)
	}

	if v.DbInstanceIdentifier != nil {
		ok := object.Key("DbInstanceIdentifier")
		ok.String(*v.DbInstanceIdentifier)
	}

	if v.IsClusterWriter {
		ok := object.Key("IsClusterWriter")
		ok.Boolean(v.IsClusterWriter)
	}

	if v.PromotionTier != 0 {
		ok := object.Key("PromotionTier")
		ok.Integer(v.PromotionTier)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbClusterMembers(v []types.AwsRdsDbClusterMember, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRdsDbClusterMember(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbClusterOptionGroupMembership(v *types.AwsRdsDbClusterOptionGroupMembership, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DbClusterOptionGroupName != nil {
		ok := object.Key("DbClusterOptionGroupName")
		ok.String(*v.DbClusterOptionGroupName)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbClusterOptionGroupMemberships(v []types.AwsRdsDbClusterOptionGroupMembership, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRdsDbClusterOptionGroupMembership(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbClusterSnapshotDetails(v *types.AwsRdsDbClusterSnapshotDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllocatedStorage != 0 {
		ok := object.Key("AllocatedStorage")
		ok.Integer(v.AllocatedStorage)
	}

	if v.AvailabilityZones != nil {
		ok := object.Key("AvailabilityZones")
		if err := awsRestjson1_serializeDocumentStringList(v.AvailabilityZones, ok); err != nil {
			return err
		}
	}

	if v.ClusterCreateTime != nil {
		ok := object.Key("ClusterCreateTime")
		ok.String(*v.ClusterCreateTime)
	}

	if v.DbClusterIdentifier != nil {
		ok := object.Key("DbClusterIdentifier")
		ok.String(*v.DbClusterIdentifier)
	}

	if v.DbClusterSnapshotIdentifier != nil {
		ok := object.Key("DbClusterSnapshotIdentifier")
		ok.String(*v.DbClusterSnapshotIdentifier)
	}

	if v.Engine != nil {
		ok := object.Key("Engine")
		ok.String(*v.Engine)
	}

	if v.EngineVersion != nil {
		ok := object.Key("EngineVersion")
		ok.String(*v.EngineVersion)
	}

	if v.IamDatabaseAuthenticationEnabled {
		ok := object.Key("IamDatabaseAuthenticationEnabled")
		ok.Boolean(v.IamDatabaseAuthenticationEnabled)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.LicenseModel != nil {
		ok := object.Key("LicenseModel")
		ok.String(*v.LicenseModel)
	}

	if v.MasterUsername != nil {
		ok := object.Key("MasterUsername")
		ok.String(*v.MasterUsername)
	}

	if v.PercentProgress != 0 {
		ok := object.Key("PercentProgress")
		ok.Integer(v.PercentProgress)
	}

	if v.Port != 0 {
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	if v.SnapshotCreateTime != nil {
		ok := object.Key("SnapshotCreateTime")
		ok.String(*v.SnapshotCreateTime)
	}

	if v.SnapshotType != nil {
		ok := object.Key("SnapshotType")
		ok.String(*v.SnapshotType)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.StorageEncrypted {
		ok := object.Key("StorageEncrypted")
		ok.Boolean(v.StorageEncrypted)
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbDomainMembership(v *types.AwsRdsDbDomainMembership, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	if v.Fqdn != nil {
		ok := object.Key("Fqdn")
		ok.String(*v.Fqdn)
	}

	if v.IamRoleName != nil {
		ok := object.Key("IamRoleName")
		ok.String(*v.IamRoleName)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbDomainMemberships(v []types.AwsRdsDbDomainMembership, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRdsDbDomainMembership(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbInstanceAssociatedRole(v *types.AwsRdsDbInstanceAssociatedRole, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FeatureName != nil {
		ok := object.Key("FeatureName")
		ok.String(*v.FeatureName)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbInstanceAssociatedRoles(v []types.AwsRdsDbInstanceAssociatedRole, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRdsDbInstanceAssociatedRole(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbInstanceDetails(v *types.AwsRdsDbInstanceDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllocatedStorage != 0 {
		ok := object.Key("AllocatedStorage")
		ok.Integer(v.AllocatedStorage)
	}

	if v.AssociatedRoles != nil {
		ok := object.Key("AssociatedRoles")
		if err := awsRestjson1_serializeDocumentAwsRdsDbInstanceAssociatedRoles(v.AssociatedRoles, ok); err != nil {
			return err
		}
	}

	if v.AutoMinorVersionUpgrade {
		ok := object.Key("AutoMinorVersionUpgrade")
		ok.Boolean(v.AutoMinorVersionUpgrade)
	}

	if v.AvailabilityZone != nil {
		ok := object.Key("AvailabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.BackupRetentionPeriod != 0 {
		ok := object.Key("BackupRetentionPeriod")
		ok.Integer(v.BackupRetentionPeriod)
	}

	if v.CACertificateIdentifier != nil {
		ok := object.Key("CACertificateIdentifier")
		ok.String(*v.CACertificateIdentifier)
	}

	if v.CharacterSetName != nil {
		ok := object.Key("CharacterSetName")
		ok.String(*v.CharacterSetName)
	}

	if v.CopyTagsToSnapshot {
		ok := object.Key("CopyTagsToSnapshot")
		ok.Boolean(v.CopyTagsToSnapshot)
	}

	if v.DBClusterIdentifier != nil {
		ok := object.Key("DBClusterIdentifier")
		ok.String(*v.DBClusterIdentifier)
	}

	if v.DBInstanceClass != nil {
		ok := object.Key("DBInstanceClass")
		ok.String(*v.DBInstanceClass)
	}

	if v.DBInstanceIdentifier != nil {
		ok := object.Key("DBInstanceIdentifier")
		ok.String(*v.DBInstanceIdentifier)
	}

	if v.DbInstancePort != 0 {
		ok := object.Key("DbInstancePort")
		ok.Integer(v.DbInstancePort)
	}

	if v.DbInstanceStatus != nil {
		ok := object.Key("DbInstanceStatus")
		ok.String(*v.DbInstanceStatus)
	}

	if v.DbiResourceId != nil {
		ok := object.Key("DbiResourceId")
		ok.String(*v.DbiResourceId)
	}

	if v.DBName != nil {
		ok := object.Key("DBName")
		ok.String(*v.DBName)
	}

	if v.DbParameterGroups != nil {
		ok := object.Key("DbParameterGroups")
		if err := awsRestjson1_serializeDocumentAwsRdsDbParameterGroups(v.DbParameterGroups, ok); err != nil {
			return err
		}
	}

	if v.DbSecurityGroups != nil {
		ok := object.Key("DbSecurityGroups")
		if err := awsRestjson1_serializeDocumentStringList(v.DbSecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.DbSubnetGroup != nil {
		ok := object.Key("DbSubnetGroup")
		if err := awsRestjson1_serializeDocumentAwsRdsDbSubnetGroup(v.DbSubnetGroup, ok); err != nil {
			return err
		}
	}

	if v.DeletionProtection {
		ok := object.Key("DeletionProtection")
		ok.Boolean(v.DeletionProtection)
	}

	if v.DomainMemberships != nil {
		ok := object.Key("DomainMemberships")
		if err := awsRestjson1_serializeDocumentAwsRdsDbDomainMemberships(v.DomainMemberships, ok); err != nil {
			return err
		}
	}

	if v.EnabledCloudWatchLogsExports != nil {
		ok := object.Key("EnabledCloudWatchLogsExports")
		if err := awsRestjson1_serializeDocumentStringList(v.EnabledCloudWatchLogsExports, ok); err != nil {
			return err
		}
	}

	if v.Endpoint != nil {
		ok := object.Key("Endpoint")
		if err := awsRestjson1_serializeDocumentAwsRdsDbInstanceEndpoint(v.Endpoint, ok); err != nil {
			return err
		}
	}

	if v.Engine != nil {
		ok := object.Key("Engine")
		ok.String(*v.Engine)
	}

	if v.EngineVersion != nil {
		ok := object.Key("EngineVersion")
		ok.String(*v.EngineVersion)
	}

	if v.EnhancedMonitoringResourceArn != nil {
		ok := object.Key("EnhancedMonitoringResourceArn")
		ok.String(*v.EnhancedMonitoringResourceArn)
	}

	if v.IAMDatabaseAuthenticationEnabled {
		ok := object.Key("IAMDatabaseAuthenticationEnabled")
		ok.Boolean(v.IAMDatabaseAuthenticationEnabled)
	}

	if v.InstanceCreateTime != nil {
		ok := object.Key("InstanceCreateTime")
		ok.String(*v.InstanceCreateTime)
	}

	if v.Iops != 0 {
		ok := object.Key("Iops")
		ok.Integer(v.Iops)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.LatestRestorableTime != nil {
		ok := object.Key("LatestRestorableTime")
		ok.String(*v.LatestRestorableTime)
	}

	if v.LicenseModel != nil {
		ok := object.Key("LicenseModel")
		ok.String(*v.LicenseModel)
	}

	if v.ListenerEndpoint != nil {
		ok := object.Key("ListenerEndpoint")
		if err := awsRestjson1_serializeDocumentAwsRdsDbInstanceEndpoint(v.ListenerEndpoint, ok); err != nil {
			return err
		}
	}

	if v.MasterUsername != nil {
		ok := object.Key("MasterUsername")
		ok.String(*v.MasterUsername)
	}

	if v.MaxAllocatedStorage != 0 {
		ok := object.Key("MaxAllocatedStorage")
		ok.Integer(v.MaxAllocatedStorage)
	}

	if v.MonitoringInterval != 0 {
		ok := object.Key("MonitoringInterval")
		ok.Integer(v.MonitoringInterval)
	}

	if v.MonitoringRoleArn != nil {
		ok := object.Key("MonitoringRoleArn")
		ok.String(*v.MonitoringRoleArn)
	}

	if v.MultiAz {
		ok := object.Key("MultiAz")
		ok.Boolean(v.MultiAz)
	}

	if v.OptionGroupMemberships != nil {
		ok := object.Key("OptionGroupMemberships")
		if err := awsRestjson1_serializeDocumentAwsRdsDbOptionGroupMemberships(v.OptionGroupMemberships, ok); err != nil {
			return err
		}
	}

	if v.PendingModifiedValues != nil {
		ok := object.Key("PendingModifiedValues")
		if err := awsRestjson1_serializeDocumentAwsRdsDbPendingModifiedValues(v.PendingModifiedValues, ok); err != nil {
			return err
		}
	}

	if v.PerformanceInsightsEnabled {
		ok := object.Key("PerformanceInsightsEnabled")
		ok.Boolean(v.PerformanceInsightsEnabled)
	}

	if v.PerformanceInsightsKmsKeyId != nil {
		ok := object.Key("PerformanceInsightsKmsKeyId")
		ok.String(*v.PerformanceInsightsKmsKeyId)
	}

	if v.PerformanceInsightsRetentionPeriod != 0 {
		ok := object.Key("PerformanceInsightsRetentionPeriod")
		ok.Integer(v.PerformanceInsightsRetentionPeriod)
	}

	if v.PreferredBackupWindow != nil {
		ok := object.Key("PreferredBackupWindow")
		ok.String(*v.PreferredBackupWindow)
	}

	if v.PreferredMaintenanceWindow != nil {
		ok := object.Key("PreferredMaintenanceWindow")
		ok.String(*v.PreferredMaintenanceWindow)
	}

	if v.ProcessorFeatures != nil {
		ok := object.Key("ProcessorFeatures")
		if err := awsRestjson1_serializeDocumentAwsRdsDbProcessorFeatures(v.ProcessorFeatures, ok); err != nil {
			return err
		}
	}

	if v.PromotionTier != 0 {
		ok := object.Key("PromotionTier")
		ok.Integer(v.PromotionTier)
	}

	if v.PubliclyAccessible {
		ok := object.Key("PubliclyAccessible")
		ok.Boolean(v.PubliclyAccessible)
	}

	if v.ReadReplicaDBClusterIdentifiers != nil {
		ok := object.Key("ReadReplicaDBClusterIdentifiers")
		if err := awsRestjson1_serializeDocumentStringList(v.ReadReplicaDBClusterIdentifiers, ok); err != nil {
			return err
		}
	}

	if v.ReadReplicaDBInstanceIdentifiers != nil {
		ok := object.Key("ReadReplicaDBInstanceIdentifiers")
		if err := awsRestjson1_serializeDocumentStringList(v.ReadReplicaDBInstanceIdentifiers, ok); err != nil {
			return err
		}
	}

	if v.ReadReplicaSourceDBInstanceIdentifier != nil {
		ok := object.Key("ReadReplicaSourceDBInstanceIdentifier")
		ok.String(*v.ReadReplicaSourceDBInstanceIdentifier)
	}

	if v.SecondaryAvailabilityZone != nil {
		ok := object.Key("SecondaryAvailabilityZone")
		ok.String(*v.SecondaryAvailabilityZone)
	}

	if v.StatusInfos != nil {
		ok := object.Key("StatusInfos")
		if err := awsRestjson1_serializeDocumentAwsRdsDbStatusInfos(v.StatusInfos, ok); err != nil {
			return err
		}
	}

	if v.StorageEncrypted {
		ok := object.Key("StorageEncrypted")
		ok.Boolean(v.StorageEncrypted)
	}

	if v.StorageType != nil {
		ok := object.Key("StorageType")
		ok.String(*v.StorageType)
	}

	if v.TdeCredentialArn != nil {
		ok := object.Key("TdeCredentialArn")
		ok.String(*v.TdeCredentialArn)
	}

	if v.Timezone != nil {
		ok := object.Key("Timezone")
		ok.String(*v.Timezone)
	}

	if v.VpcSecurityGroups != nil {
		ok := object.Key("VpcSecurityGroups")
		if err := awsRestjson1_serializeDocumentAwsRdsDbInstanceVpcSecurityGroups(v.VpcSecurityGroups, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbInstanceEndpoint(v *types.AwsRdsDbInstanceEndpoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Address != nil {
		ok := object.Key("Address")
		ok.String(*v.Address)
	}

	if v.HostedZoneId != nil {
		ok := object.Key("HostedZoneId")
		ok.String(*v.HostedZoneId)
	}

	if v.Port != 0 {
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbInstanceVpcSecurityGroup(v *types.AwsRdsDbInstanceVpcSecurityGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.VpcSecurityGroupId != nil {
		ok := object.Key("VpcSecurityGroupId")
		ok.String(*v.VpcSecurityGroupId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbInstanceVpcSecurityGroups(v []types.AwsRdsDbInstanceVpcSecurityGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRdsDbInstanceVpcSecurityGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbOptionGroupMembership(v *types.AwsRdsDbOptionGroupMembership, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OptionGroupName != nil {
		ok := object.Key("OptionGroupName")
		ok.String(*v.OptionGroupName)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbOptionGroupMemberships(v []types.AwsRdsDbOptionGroupMembership, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRdsDbOptionGroupMembership(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbParameterGroup(v *types.AwsRdsDbParameterGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DbParameterGroupName != nil {
		ok := object.Key("DbParameterGroupName")
		ok.String(*v.DbParameterGroupName)
	}

	if v.ParameterApplyStatus != nil {
		ok := object.Key("ParameterApplyStatus")
		ok.String(*v.ParameterApplyStatus)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbParameterGroups(v []types.AwsRdsDbParameterGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRdsDbParameterGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbPendingModifiedValues(v *types.AwsRdsDbPendingModifiedValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllocatedStorage != 0 {
		ok := object.Key("AllocatedStorage")
		ok.Integer(v.AllocatedStorage)
	}

	if v.BackupRetentionPeriod != 0 {
		ok := object.Key("BackupRetentionPeriod")
		ok.Integer(v.BackupRetentionPeriod)
	}

	if v.CaCertificateIdentifier != nil {
		ok := object.Key("CaCertificateIdentifier")
		ok.String(*v.CaCertificateIdentifier)
	}

	if v.DbInstanceClass != nil {
		ok := object.Key("DbInstanceClass")
		ok.String(*v.DbInstanceClass)
	}

	if v.DbInstanceIdentifier != nil {
		ok := object.Key("DbInstanceIdentifier")
		ok.String(*v.DbInstanceIdentifier)
	}

	if v.DbSubnetGroupName != nil {
		ok := object.Key("DbSubnetGroupName")
		ok.String(*v.DbSubnetGroupName)
	}

	if v.EngineVersion != nil {
		ok := object.Key("EngineVersion")
		ok.String(*v.EngineVersion)
	}

	if v.Iops != 0 {
		ok := object.Key("Iops")
		ok.Integer(v.Iops)
	}

	if v.LicenseModel != nil {
		ok := object.Key("LicenseModel")
		ok.String(*v.LicenseModel)
	}

	if v.MasterUserPassword != nil {
		ok := object.Key("MasterUserPassword")
		ok.String(*v.MasterUserPassword)
	}

	if v.MultiAZ {
		ok := object.Key("MultiAZ")
		ok.Boolean(v.MultiAZ)
	}

	if v.PendingCloudWatchLogsExports != nil {
		ok := object.Key("PendingCloudWatchLogsExports")
		if err := awsRestjson1_serializeDocumentAwsRdsPendingCloudWatchLogsExports(v.PendingCloudWatchLogsExports, ok); err != nil {
			return err
		}
	}

	if v.Port != 0 {
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	if v.ProcessorFeatures != nil {
		ok := object.Key("ProcessorFeatures")
		if err := awsRestjson1_serializeDocumentAwsRdsDbProcessorFeatures(v.ProcessorFeatures, ok); err != nil {
			return err
		}
	}

	if v.StorageType != nil {
		ok := object.Key("StorageType")
		ok.String(*v.StorageType)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbProcessorFeature(v *types.AwsRdsDbProcessorFeature, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbProcessorFeatures(v []types.AwsRdsDbProcessorFeature, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRdsDbProcessorFeature(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbSnapshotDetails(v *types.AwsRdsDbSnapshotDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllocatedStorage != 0 {
		ok := object.Key("AllocatedStorage")
		ok.Integer(v.AllocatedStorage)
	}

	if v.AvailabilityZone != nil {
		ok := object.Key("AvailabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.DbInstanceIdentifier != nil {
		ok := object.Key("DbInstanceIdentifier")
		ok.String(*v.DbInstanceIdentifier)
	}

	if v.DbiResourceId != nil {
		ok := object.Key("DbiResourceId")
		ok.String(*v.DbiResourceId)
	}

	if v.DbSnapshotIdentifier != nil {
		ok := object.Key("DbSnapshotIdentifier")
		ok.String(*v.DbSnapshotIdentifier)
	}

	if v.Encrypted {
		ok := object.Key("Encrypted")
		ok.Boolean(v.Encrypted)
	}

	if v.Engine != nil {
		ok := object.Key("Engine")
		ok.String(*v.Engine)
	}

	if v.EngineVersion != nil {
		ok := object.Key("EngineVersion")
		ok.String(*v.EngineVersion)
	}

	if v.IamDatabaseAuthenticationEnabled {
		ok := object.Key("IamDatabaseAuthenticationEnabled")
		ok.Boolean(v.IamDatabaseAuthenticationEnabled)
	}

	if v.InstanceCreateTime != nil {
		ok := object.Key("InstanceCreateTime")
		ok.String(*v.InstanceCreateTime)
	}

	if v.Iops != 0 {
		ok := object.Key("Iops")
		ok.Integer(v.Iops)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.LicenseModel != nil {
		ok := object.Key("LicenseModel")
		ok.String(*v.LicenseModel)
	}

	if v.MasterUsername != nil {
		ok := object.Key("MasterUsername")
		ok.String(*v.MasterUsername)
	}

	if v.OptionGroupName != nil {
		ok := object.Key("OptionGroupName")
		ok.String(*v.OptionGroupName)
	}

	if v.PercentProgress != 0 {
		ok := object.Key("PercentProgress")
		ok.Integer(v.PercentProgress)
	}

	if v.Port != 0 {
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	if v.ProcessorFeatures != nil {
		ok := object.Key("ProcessorFeatures")
		if err := awsRestjson1_serializeDocumentAwsRdsDbProcessorFeatures(v.ProcessorFeatures, ok); err != nil {
			return err
		}
	}

	if v.SnapshotCreateTime != nil {
		ok := object.Key("SnapshotCreateTime")
		ok.String(*v.SnapshotCreateTime)
	}

	if v.SnapshotType != nil {
		ok := object.Key("SnapshotType")
		ok.String(*v.SnapshotType)
	}

	if v.SourceDbSnapshotIdentifier != nil {
		ok := object.Key("SourceDbSnapshotIdentifier")
		ok.String(*v.SourceDbSnapshotIdentifier)
	}

	if v.SourceRegion != nil {
		ok := object.Key("SourceRegion")
		ok.String(*v.SourceRegion)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.StorageType != nil {
		ok := object.Key("StorageType")
		ok.String(*v.StorageType)
	}

	if v.TdeCredentialArn != nil {
		ok := object.Key("TdeCredentialArn")
		ok.String(*v.TdeCredentialArn)
	}

	if v.Timezone != nil {
		ok := object.Key("Timezone")
		ok.String(*v.Timezone)
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbStatusInfo(v *types.AwsRdsDbStatusInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Message != nil {
		ok := object.Key("Message")
		ok.String(*v.Message)
	}

	if v.Normal {
		ok := object.Key("Normal")
		ok.Boolean(v.Normal)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.StatusType != nil {
		ok := object.Key("StatusType")
		ok.String(*v.StatusType)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbStatusInfos(v []types.AwsRdsDbStatusInfo, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRdsDbStatusInfo(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbSubnetGroup(v *types.AwsRdsDbSubnetGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DbSubnetGroupArn != nil {
		ok := object.Key("DbSubnetGroupArn")
		ok.String(*v.DbSubnetGroupArn)
	}

	if v.DbSubnetGroupDescription != nil {
		ok := object.Key("DbSubnetGroupDescription")
		ok.String(*v.DbSubnetGroupDescription)
	}

	if v.DbSubnetGroupName != nil {
		ok := object.Key("DbSubnetGroupName")
		ok.String(*v.DbSubnetGroupName)
	}

	if v.SubnetGroupStatus != nil {
		ok := object.Key("SubnetGroupStatus")
		ok.String(*v.SubnetGroupStatus)
	}

	if v.Subnets != nil {
		ok := object.Key("Subnets")
		if err := awsRestjson1_serializeDocumentAwsRdsDbSubnetGroupSubnets(v.Subnets, ok); err != nil {
			return err
		}
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbSubnetGroupSubnet(v *types.AwsRdsDbSubnetGroupSubnet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SubnetAvailabilityZone != nil {
		ok := object.Key("SubnetAvailabilityZone")
		if err := awsRestjson1_serializeDocumentAwsRdsDbSubnetGroupSubnetAvailabilityZone(v.SubnetAvailabilityZone, ok); err != nil {
			return err
		}
	}

	if v.SubnetIdentifier != nil {
		ok := object.Key("SubnetIdentifier")
		ok.String(*v.SubnetIdentifier)
	}

	if v.SubnetStatus != nil {
		ok := object.Key("SubnetStatus")
		ok.String(*v.SubnetStatus)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbSubnetGroupSubnetAvailabilityZone(v *types.AwsRdsDbSubnetGroupSubnetAvailabilityZone, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsDbSubnetGroupSubnets(v []types.AwsRdsDbSubnetGroupSubnet, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRdsDbSubnetGroupSubnet(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRdsEventSubscriptionDetails(v *types.AwsRdsEventSubscriptionDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomerAwsId != nil {
		ok := object.Key("CustomerAwsId")
		ok.String(*v.CustomerAwsId)
	}

	if v.CustSubscriptionId != nil {
		ok := object.Key("CustSubscriptionId")
		ok.String(*v.CustSubscriptionId)
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.EventCategoriesList != nil {
		ok := object.Key("EventCategoriesList")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.EventCategoriesList, ok); err != nil {
			return err
		}
	}

	if v.EventSubscriptionArn != nil {
		ok := object.Key("EventSubscriptionArn")
		ok.String(*v.EventSubscriptionArn)
	}

	if v.SnsTopicArn != nil {
		ok := object.Key("SnsTopicArn")
		ok.String(*v.SnsTopicArn)
	}

	if v.SourceIdsList != nil {
		ok := object.Key("SourceIdsList")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.SourceIdsList, ok); err != nil {
			return err
		}
	}

	if v.SourceType != nil {
		ok := object.Key("SourceType")
		ok.String(*v.SourceType)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.SubscriptionCreationTime != nil {
		ok := object.Key("SubscriptionCreationTime")
		ok.String(*v.SubscriptionCreationTime)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRdsPendingCloudWatchLogsExports(v *types.AwsRdsPendingCloudWatchLogsExports, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogTypesToDisable != nil {
		ok := object.Key("LogTypesToDisable")
		if err := awsRestjson1_serializeDocumentStringList(v.LogTypesToDisable, ok); err != nil {
			return err
		}
	}

	if v.LogTypesToEnable != nil {
		ok := object.Key("LogTypesToEnable")
		if err := awsRestjson1_serializeDocumentStringList(v.LogTypesToEnable, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterClusterNode(v *types.AwsRedshiftClusterClusterNode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NodeRole != nil {
		ok := object.Key("NodeRole")
		ok.String(*v.NodeRole)
	}

	if v.PrivateIpAddress != nil {
		ok := object.Key("PrivateIpAddress")
		ok.String(*v.PrivateIpAddress)
	}

	if v.PublicIpAddress != nil {
		ok := object.Key("PublicIpAddress")
		ok.String(*v.PublicIpAddress)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterClusterNodes(v []types.AwsRedshiftClusterClusterNode, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterClusterNode(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterClusterParameterGroup(v *types.AwsRedshiftClusterClusterParameterGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterParameterStatusList != nil {
		ok := object.Key("ClusterParameterStatusList")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterClusterParameterStatusList(v.ClusterParameterStatusList, ok); err != nil {
			return err
		}
	}

	if v.ParameterApplyStatus != nil {
		ok := object.Key("ParameterApplyStatus")
		ok.String(*v.ParameterApplyStatus)
	}

	if v.ParameterGroupName != nil {
		ok := object.Key("ParameterGroupName")
		ok.String(*v.ParameterGroupName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterClusterParameterGroups(v []types.AwsRedshiftClusterClusterParameterGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterClusterParameterGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterClusterParameterStatus(v *types.AwsRedshiftClusterClusterParameterStatus, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ParameterApplyErrorDescription != nil {
		ok := object.Key("ParameterApplyErrorDescription")
		ok.String(*v.ParameterApplyErrorDescription)
	}

	if v.ParameterApplyStatus != nil {
		ok := object.Key("ParameterApplyStatus")
		ok.String(*v.ParameterApplyStatus)
	}

	if v.ParameterName != nil {
		ok := object.Key("ParameterName")
		ok.String(*v.ParameterName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterClusterParameterStatusList(v []types.AwsRedshiftClusterClusterParameterStatus, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterClusterParameterStatus(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterClusterSecurityGroup(v *types.AwsRedshiftClusterClusterSecurityGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterSecurityGroupName != nil {
		ok := object.Key("ClusterSecurityGroupName")
		ok.String(*v.ClusterSecurityGroupName)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterClusterSecurityGroups(v []types.AwsRedshiftClusterClusterSecurityGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterClusterSecurityGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterClusterSnapshotCopyStatus(v *types.AwsRedshiftClusterClusterSnapshotCopyStatus, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationRegion != nil {
		ok := object.Key("DestinationRegion")
		ok.String(*v.DestinationRegion)
	}

	if v.ManualSnapshotRetentionPeriod != 0 {
		ok := object.Key("ManualSnapshotRetentionPeriod")
		ok.Integer(v.ManualSnapshotRetentionPeriod)
	}

	if v.RetentionPeriod != 0 {
		ok := object.Key("RetentionPeriod")
		ok.Integer(v.RetentionPeriod)
	}

	if v.SnapshotCopyGrantName != nil {
		ok := object.Key("SnapshotCopyGrantName")
		ok.String(*v.SnapshotCopyGrantName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterDeferredMaintenanceWindow(v *types.AwsRedshiftClusterDeferredMaintenanceWindow, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeferMaintenanceEndTime != nil {
		ok := object.Key("DeferMaintenanceEndTime")
		ok.String(*v.DeferMaintenanceEndTime)
	}

	if v.DeferMaintenanceIdentifier != nil {
		ok := object.Key("DeferMaintenanceIdentifier")
		ok.String(*v.DeferMaintenanceIdentifier)
	}

	if v.DeferMaintenanceStartTime != nil {
		ok := object.Key("DeferMaintenanceStartTime")
		ok.String(*v.DeferMaintenanceStartTime)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterDeferredMaintenanceWindows(v []types.AwsRedshiftClusterDeferredMaintenanceWindow, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterDeferredMaintenanceWindow(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterDetails(v *types.AwsRedshiftClusterDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowVersionUpgrade {
		ok := object.Key("AllowVersionUpgrade")
		ok.Boolean(v.AllowVersionUpgrade)
	}

	if v.AutomatedSnapshotRetentionPeriod != 0 {
		ok := object.Key("AutomatedSnapshotRetentionPeriod")
		ok.Integer(v.AutomatedSnapshotRetentionPeriod)
	}

	if v.AvailabilityZone != nil {
		ok := object.Key("AvailabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.ClusterAvailabilityStatus != nil {
		ok := object.Key("ClusterAvailabilityStatus")
		ok.String(*v.ClusterAvailabilityStatus)
	}

	if v.ClusterCreateTime != nil {
		ok := object.Key("ClusterCreateTime")
		ok.String(*v.ClusterCreateTime)
	}

	if v.ClusterIdentifier != nil {
		ok := object.Key("ClusterIdentifier")
		ok.String(*v.ClusterIdentifier)
	}

	if v.ClusterNodes != nil {
		ok := object.Key("ClusterNodes")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterClusterNodes(v.ClusterNodes, ok); err != nil {
			return err
		}
	}

	if v.ClusterParameterGroups != nil {
		ok := object.Key("ClusterParameterGroups")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterClusterParameterGroups(v.ClusterParameterGroups, ok); err != nil {
			return err
		}
	}

	if v.ClusterPublicKey != nil {
		ok := object.Key("ClusterPublicKey")
		ok.String(*v.ClusterPublicKey)
	}

	if v.ClusterRevisionNumber != nil {
		ok := object.Key("ClusterRevisionNumber")
		ok.String(*v.ClusterRevisionNumber)
	}

	if v.ClusterSecurityGroups != nil {
		ok := object.Key("ClusterSecurityGroups")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterClusterSecurityGroups(v.ClusterSecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.ClusterSnapshotCopyStatus != nil {
		ok := object.Key("ClusterSnapshotCopyStatus")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterClusterSnapshotCopyStatus(v.ClusterSnapshotCopyStatus, ok); err != nil {
			return err
		}
	}

	if v.ClusterStatus != nil {
		ok := object.Key("ClusterStatus")
		ok.String(*v.ClusterStatus)
	}

	if v.ClusterSubnetGroupName != nil {
		ok := object.Key("ClusterSubnetGroupName")
		ok.String(*v.ClusterSubnetGroupName)
	}

	if v.ClusterVersion != nil {
		ok := object.Key("ClusterVersion")
		ok.String(*v.ClusterVersion)
	}

	if v.DBName != nil {
		ok := object.Key("DBName")
		ok.String(*v.DBName)
	}

	if v.DeferredMaintenanceWindows != nil {
		ok := object.Key("DeferredMaintenanceWindows")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterDeferredMaintenanceWindows(v.DeferredMaintenanceWindows, ok); err != nil {
			return err
		}
	}

	if v.ElasticIpStatus != nil {
		ok := object.Key("ElasticIpStatus")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterElasticIpStatus(v.ElasticIpStatus, ok); err != nil {
			return err
		}
	}

	if v.ElasticResizeNumberOfNodeOptions != nil {
		ok := object.Key("ElasticResizeNumberOfNodeOptions")
		ok.String(*v.ElasticResizeNumberOfNodeOptions)
	}

	if v.Encrypted {
		ok := object.Key("Encrypted")
		ok.Boolean(v.Encrypted)
	}

	if v.Endpoint != nil {
		ok := object.Key("Endpoint")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterEndpoint(v.Endpoint, ok); err != nil {
			return err
		}
	}

	if v.EnhancedVpcRouting {
		ok := object.Key("EnhancedVpcRouting")
		ok.Boolean(v.EnhancedVpcRouting)
	}

	if v.ExpectedNextSnapshotScheduleTime != nil {
		ok := object.Key("ExpectedNextSnapshotScheduleTime")
		ok.String(*v.ExpectedNextSnapshotScheduleTime)
	}

	if v.ExpectedNextSnapshotScheduleTimeStatus != nil {
		ok := object.Key("ExpectedNextSnapshotScheduleTimeStatus")
		ok.String(*v.ExpectedNextSnapshotScheduleTimeStatus)
	}

	if v.HsmStatus != nil {
		ok := object.Key("HsmStatus")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterHsmStatus(v.HsmStatus, ok); err != nil {
			return err
		}
	}

	if v.IamRoles != nil {
		ok := object.Key("IamRoles")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterIamRoles(v.IamRoles, ok); err != nil {
			return err
		}
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.MaintenanceTrackName != nil {
		ok := object.Key("MaintenanceTrackName")
		ok.String(*v.MaintenanceTrackName)
	}

	if v.ManualSnapshotRetentionPeriod != 0 {
		ok := object.Key("ManualSnapshotRetentionPeriod")
		ok.Integer(v.ManualSnapshotRetentionPeriod)
	}

	if v.MasterUsername != nil {
		ok := object.Key("MasterUsername")
		ok.String(*v.MasterUsername)
	}

	if v.NextMaintenanceWindowStartTime != nil {
		ok := object.Key("NextMaintenanceWindowStartTime")
		ok.String(*v.NextMaintenanceWindowStartTime)
	}

	if v.NodeType != nil {
		ok := object.Key("NodeType")
		ok.String(*v.NodeType)
	}

	if v.NumberOfNodes != 0 {
		ok := object.Key("NumberOfNodes")
		ok.Integer(v.NumberOfNodes)
	}

	if v.PendingActions != nil {
		ok := object.Key("PendingActions")
		if err := awsRestjson1_serializeDocumentStringList(v.PendingActions, ok); err != nil {
			return err
		}
	}

	if v.PendingModifiedValues != nil {
		ok := object.Key("PendingModifiedValues")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterPendingModifiedValues(v.PendingModifiedValues, ok); err != nil {
			return err
		}
	}

	if v.PreferredMaintenanceWindow != nil {
		ok := object.Key("PreferredMaintenanceWindow")
		ok.String(*v.PreferredMaintenanceWindow)
	}

	if v.PubliclyAccessible {
		ok := object.Key("PubliclyAccessible")
		ok.Boolean(v.PubliclyAccessible)
	}

	if v.ResizeInfo != nil {
		ok := object.Key("ResizeInfo")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterResizeInfo(v.ResizeInfo, ok); err != nil {
			return err
		}
	}

	if v.RestoreStatus != nil {
		ok := object.Key("RestoreStatus")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterRestoreStatus(v.RestoreStatus, ok); err != nil {
			return err
		}
	}

	if v.SnapshotScheduleIdentifier != nil {
		ok := object.Key("SnapshotScheduleIdentifier")
		ok.String(*v.SnapshotScheduleIdentifier)
	}

	if v.SnapshotScheduleState != nil {
		ok := object.Key("SnapshotScheduleState")
		ok.String(*v.SnapshotScheduleState)
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	if v.VpcSecurityGroups != nil {
		ok := object.Key("VpcSecurityGroups")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterVpcSecurityGroups(v.VpcSecurityGroups, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterElasticIpStatus(v *types.AwsRedshiftClusterElasticIpStatus, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ElasticIp != nil {
		ok := object.Key("ElasticIp")
		ok.String(*v.ElasticIp)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterEndpoint(v *types.AwsRedshiftClusterEndpoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Address != nil {
		ok := object.Key("Address")
		ok.String(*v.Address)
	}

	if v.Port != 0 {
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterHsmStatus(v *types.AwsRedshiftClusterHsmStatus, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HsmClientCertificateIdentifier != nil {
		ok := object.Key("HsmClientCertificateIdentifier")
		ok.String(*v.HsmClientCertificateIdentifier)
	}

	if v.HsmConfigurationIdentifier != nil {
		ok := object.Key("HsmConfigurationIdentifier")
		ok.String(*v.HsmConfigurationIdentifier)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterIamRole(v *types.AwsRedshiftClusterIamRole, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplyStatus != nil {
		ok := object.Key("ApplyStatus")
		ok.String(*v.ApplyStatus)
	}

	if v.IamRoleArn != nil {
		ok := object.Key("IamRoleArn")
		ok.String(*v.IamRoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterIamRoles(v []types.AwsRedshiftClusterIamRole, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterIamRole(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterPendingModifiedValues(v *types.AwsRedshiftClusterPendingModifiedValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutomatedSnapshotRetentionPeriod != 0 {
		ok := object.Key("AutomatedSnapshotRetentionPeriod")
		ok.Integer(v.AutomatedSnapshotRetentionPeriod)
	}

	if v.ClusterIdentifier != nil {
		ok := object.Key("ClusterIdentifier")
		ok.String(*v.ClusterIdentifier)
	}

	if v.ClusterType != nil {
		ok := object.Key("ClusterType")
		ok.String(*v.ClusterType)
	}

	if v.ClusterVersion != nil {
		ok := object.Key("ClusterVersion")
		ok.String(*v.ClusterVersion)
	}

	if v.EncryptionType != nil {
		ok := object.Key("EncryptionType")
		ok.String(*v.EncryptionType)
	}

	if v.EnhancedVpcRouting {
		ok := object.Key("EnhancedVpcRouting")
		ok.Boolean(v.EnhancedVpcRouting)
	}

	if v.MaintenanceTrackName != nil {
		ok := object.Key("MaintenanceTrackName")
		ok.String(*v.MaintenanceTrackName)
	}

	if v.MasterUserPassword != nil {
		ok := object.Key("MasterUserPassword")
		ok.String(*v.MasterUserPassword)
	}

	if v.NodeType != nil {
		ok := object.Key("NodeType")
		ok.String(*v.NodeType)
	}

	if v.NumberOfNodes != 0 {
		ok := object.Key("NumberOfNodes")
		ok.Integer(v.NumberOfNodes)
	}

	if v.PubliclyAccessible {
		ok := object.Key("PubliclyAccessible")
		ok.Boolean(v.PubliclyAccessible)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterResizeInfo(v *types.AwsRedshiftClusterResizeInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowCancelResize {
		ok := object.Key("AllowCancelResize")
		ok.Boolean(v.AllowCancelResize)
	}

	if v.ResizeType != nil {
		ok := object.Key("ResizeType")
		ok.String(*v.ResizeType)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterRestoreStatus(v *types.AwsRedshiftClusterRestoreStatus, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CurrentRestoreRateInMegaBytesPerSecond != 0 {
		ok := object.Key("CurrentRestoreRateInMegaBytesPerSecond")
		switch {
		case math.IsNaN(v.CurrentRestoreRateInMegaBytesPerSecond):
			ok.String("NaN")

		case math.IsInf(v.CurrentRestoreRateInMegaBytesPerSecond, 1):
			ok.String("Infinity")

		case math.IsInf(v.CurrentRestoreRateInMegaBytesPerSecond, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.CurrentRestoreRateInMegaBytesPerSecond)

		}
	}

	if v.ElapsedTimeInSeconds != 0 {
		ok := object.Key("ElapsedTimeInSeconds")
		ok.Long(v.ElapsedTimeInSeconds)
	}

	if v.EstimatedTimeToCompletionInSeconds != 0 {
		ok := object.Key("EstimatedTimeToCompletionInSeconds")
		ok.Long(v.EstimatedTimeToCompletionInSeconds)
	}

	if v.ProgressInMegaBytes != 0 {
		ok := object.Key("ProgressInMegaBytes")
		ok.Long(v.ProgressInMegaBytes)
	}

	if v.SnapshotSizeInMegaBytes != 0 {
		ok := object.Key("SnapshotSizeInMegaBytes")
		ok.Long(v.SnapshotSizeInMegaBytes)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterVpcSecurityGroup(v *types.AwsRedshiftClusterVpcSecurityGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.VpcSecurityGroupId != nil {
		ok := object.Key("VpcSecurityGroupId")
		ok.String(*v.VpcSecurityGroupId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsRedshiftClusterVpcSecurityGroups(v []types.AwsRedshiftClusterVpcSecurityGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterVpcSecurityGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsS3AccountPublicAccessBlockDetails(v *types.AwsS3AccountPublicAccessBlockDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockPublicAcls {
		ok := object.Key("BlockPublicAcls")
		ok.Boolean(v.BlockPublicAcls)
	}

	if v.BlockPublicPolicy {
		ok := object.Key("BlockPublicPolicy")
		ok.Boolean(v.BlockPublicPolicy)
	}

	if v.IgnorePublicAcls {
		ok := object.Key("IgnorePublicAcls")
		ok.Boolean(v.IgnorePublicAcls)
	}

	if v.RestrictPublicBuckets {
		ok := object.Key("RestrictPublicBuckets")
		ok.Boolean(v.RestrictPublicBuckets)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationDetails(v *types.AwsS3BucketBucketLifecycleConfigurationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesList(v.Rules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails(v *types.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DaysAfterInitiation != 0 {
		ok := object.Key("DaysAfterInitiation")
		ok.Integer(v.DaysAfterInitiation)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesDetails(v *types.AwsS3BucketBucketLifecycleConfigurationRulesDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AbortIncompleteMultipartUpload != nil {
		ok := object.Key("AbortIncompleteMultipartUpload")
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails(v.AbortIncompleteMultipartUpload, ok); err != nil {
			return err
		}
	}

	if v.ExpirationDate != nil {
		ok := object.Key("ExpirationDate")
		ok.String(*v.ExpirationDate)
	}

	if v.ExpirationInDays != 0 {
		ok := object.Key("ExpirationInDays")
		ok.Integer(v.ExpirationInDays)
	}

	if v.ExpiredObjectDeleteMarker {
		ok := object.Key("ExpiredObjectDeleteMarker")
		ok.Boolean(v.ExpiredObjectDeleteMarker)
	}

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterDetails(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.ID != nil {
		ok := object.Key("ID")
		ok.String(*v.ID)
	}

	if v.NoncurrentVersionExpirationInDays != 0 {
		ok := object.Key("NoncurrentVersionExpirationInDays")
		ok.Integer(v.NoncurrentVersionExpirationInDays)
	}

	if v.NoncurrentVersionTransitions != nil {
		ok := object.Key("NoncurrentVersionTransitions")
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsList(v.NoncurrentVersionTransitions, ok); err != nil {
			return err
		}
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	if v.Transitions != nil {
		ok := object.Key("Transitions")
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesTransitionsList(v.Transitions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterDetails(v *types.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Predicate != nil {
		ok := object.Key("Predicate")
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails(v.Predicate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails(v *types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Operands != nil {
		ok := object.Key("Operands")
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsList(v.Operands, ok); err != nil {
			return err
		}
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.Tag != nil {
		ok := object.Key("Tag")
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails(v.Tag, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails(v *types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.Tag != nil {
		ok := object.Key("Tag")
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails(v.Tag, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsList(v []types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails(v *types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails(v *types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesList(v []types.AwsS3BucketBucketLifecycleConfigurationRulesDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails(v *types.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Days != 0 {
		ok := object.Key("Days")
		ok.Integer(v.Days)
	}

	if v.StorageClass != nil {
		ok := object.Key("StorageClass")
		ok.String(*v.StorageClass)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsList(v []types.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails(v *types.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Date != nil {
		ok := object.Key("Date")
		ok.String(*v.Date)
	}

	if v.Days != 0 {
		ok := object.Key("Days")
		ok.Integer(v.Days)
	}

	if v.StorageClass != nil {
		ok := object.Key("StorageClass")
		ok.String(*v.StorageClass)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesTransitionsList(v []types.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketDetails(v *types.AwsS3BucketDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessControlList != nil {
		ok := object.Key("AccessControlList")
		ok.String(*v.AccessControlList)
	}

	if v.BucketLifecycleConfiguration != nil {
		ok := object.Key("BucketLifecycleConfiguration")
		if err := awsRestjson1_serializeDocumentAwsS3BucketBucketLifecycleConfigurationDetails(v.BucketLifecycleConfiguration, ok); err != nil {
			return err
		}
	}

	if v.BucketLoggingConfiguration != nil {
		ok := object.Key("BucketLoggingConfiguration")
		if err := awsRestjson1_serializeDocumentAwsS3BucketLoggingConfiguration(v.BucketLoggingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.BucketNotificationConfiguration != nil {
		ok := object.Key("BucketNotificationConfiguration")
		if err := awsRestjson1_serializeDocumentAwsS3BucketNotificationConfiguration(v.BucketNotificationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.BucketWebsiteConfiguration != nil {
		ok := object.Key("BucketWebsiteConfiguration")
		if err := awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfiguration(v.BucketWebsiteConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CreatedAt != nil {
		ok := object.Key("CreatedAt")
		ok.String(*v.CreatedAt)
	}

	if v.OwnerId != nil {
		ok := object.Key("OwnerId")
		ok.String(*v.OwnerId)
	}

	if v.OwnerName != nil {
		ok := object.Key("OwnerName")
		ok.String(*v.OwnerName)
	}

	if v.PublicAccessBlockConfiguration != nil {
		ok := object.Key("PublicAccessBlockConfiguration")
		if err := awsRestjson1_serializeDocumentAwsS3AccountPublicAccessBlockDetails(v.PublicAccessBlockConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ServerSideEncryptionConfiguration != nil {
		ok := object.Key("ServerSideEncryptionConfiguration")
		if err := awsRestjson1_serializeDocumentAwsS3BucketServerSideEncryptionConfiguration(v.ServerSideEncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketLoggingConfiguration(v *types.AwsS3BucketLoggingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationBucketName != nil {
		ok := object.Key("DestinationBucketName")
		ok.String(*v.DestinationBucketName)
	}

	if v.LogFilePrefix != nil {
		ok := object.Key("LogFilePrefix")
		ok.String(*v.LogFilePrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketNotificationConfiguration(v *types.AwsS3BucketNotificationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configurations != nil {
		ok := object.Key("Configurations")
		if err := awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationDetails(v.Configurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationDetail(v *types.AwsS3BucketNotificationConfigurationDetail, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("Destination")
		ok.String(*v.Destination)
	}

	if v.Events != nil {
		ok := object.Key("Events")
		if err := awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationEvents(v.Events, ok); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationDetails(v []types.AwsS3BucketNotificationConfigurationDetail, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationDetail(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationEvents(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationFilter(v *types.AwsS3BucketNotificationConfigurationFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3KeyFilter != nil {
		ok := object.Key("S3KeyFilter")
		if err := awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilter(v.S3KeyFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilter(v *types.AwsS3BucketNotificationConfigurationS3KeyFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterRules != nil {
		ok := object.Key("FilterRules")
		if err := awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilterRules(v.FilterRules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilterRule(v *types.AwsS3BucketNotificationConfigurationS3KeyFilterRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilterRules(v []types.AwsS3BucketNotificationConfigurationS3KeyFilterRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilterRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketServerSideEncryptionByDefault(v *types.AwsS3BucketServerSideEncryptionByDefault, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KMSMasterKeyID != nil {
		ok := object.Key("KMSMasterKeyID")
		ok.String(*v.KMSMasterKeyID)
	}

	if v.SSEAlgorithm != nil {
		ok := object.Key("SSEAlgorithm")
		ok.String(*v.SSEAlgorithm)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketServerSideEncryptionConfiguration(v *types.AwsS3BucketServerSideEncryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsRestjson1_serializeDocumentAwsS3BucketServerSideEncryptionRules(v.Rules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketServerSideEncryptionRule(v *types.AwsS3BucketServerSideEncryptionRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplyServerSideEncryptionByDefault != nil {
		ok := object.Key("ApplyServerSideEncryptionByDefault")
		if err := awsRestjson1_serializeDocumentAwsS3BucketServerSideEncryptionByDefault(v.ApplyServerSideEncryptionByDefault, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketServerSideEncryptionRules(v []types.AwsS3BucketServerSideEncryptionRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsS3BucketServerSideEncryptionRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfiguration(v *types.AwsS3BucketWebsiteConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ErrorDocument != nil {
		ok := object.Key("ErrorDocument")
		ok.String(*v.ErrorDocument)
	}

	if v.IndexDocumentSuffix != nil {
		ok := object.Key("IndexDocumentSuffix")
		ok.String(*v.IndexDocumentSuffix)
	}

	if v.RedirectAllRequestsTo != nil {
		ok := object.Key("RedirectAllRequestsTo")
		if err := awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfigurationRedirectTo(v.RedirectAllRequestsTo, ok); err != nil {
			return err
		}
	}

	if v.RoutingRules != nil {
		ok := object.Key("RoutingRules")
		if err := awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfigurationRoutingRules(v.RoutingRules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfigurationRedirectTo(v *types.AwsS3BucketWebsiteConfigurationRedirectTo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hostname != nil {
		ok := object.Key("Hostname")
		ok.String(*v.Hostname)
	}

	if v.Protocol != nil {
		ok := object.Key("Protocol")
		ok.String(*v.Protocol)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfigurationRoutingRule(v *types.AwsS3BucketWebsiteConfigurationRoutingRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Condition != nil {
		ok := object.Key("Condition")
		if err := awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfigurationRoutingRuleCondition(v.Condition, ok); err != nil {
			return err
		}
	}

	if v.Redirect != nil {
		ok := object.Key("Redirect")
		if err := awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfigurationRoutingRuleRedirect(v.Redirect, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfigurationRoutingRuleCondition(v *types.AwsS3BucketWebsiteConfigurationRoutingRuleCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HttpErrorCodeReturnedEquals != nil {
		ok := object.Key("HttpErrorCodeReturnedEquals")
		ok.String(*v.HttpErrorCodeReturnedEquals)
	}

	if v.KeyPrefixEquals != nil {
		ok := object.Key("KeyPrefixEquals")
		ok.String(*v.KeyPrefixEquals)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfigurationRoutingRuleRedirect(v *types.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hostname != nil {
		ok := object.Key("Hostname")
		ok.String(*v.Hostname)
	}

	if v.HttpRedirectCode != nil {
		ok := object.Key("HttpRedirectCode")
		ok.String(*v.HttpRedirectCode)
	}

	if v.Protocol != nil {
		ok := object.Key("Protocol")
		ok.String(*v.Protocol)
	}

	if v.ReplaceKeyPrefixWith != nil {
		ok := object.Key("ReplaceKeyPrefixWith")
		ok.String(*v.ReplaceKeyPrefixWith)
	}

	if v.ReplaceKeyWith != nil {
		ok := object.Key("ReplaceKeyWith")
		ok.String(*v.ReplaceKeyWith)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfigurationRoutingRules(v []types.AwsS3BucketWebsiteConfigurationRoutingRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsS3BucketWebsiteConfigurationRoutingRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsS3ObjectDetails(v *types.AwsS3ObjectDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContentType != nil {
		ok := object.Key("ContentType")
		ok.String(*v.ContentType)
	}

	if v.ETag != nil {
		ok := object.Key("ETag")
		ok.String(*v.ETag)
	}

	if v.LastModified != nil {
		ok := object.Key("LastModified")
		ok.String(*v.LastModified)
	}

	if v.ServerSideEncryption != nil {
		ok := object.Key("ServerSideEncryption")
		ok.String(*v.ServerSideEncryption)
	}

	if v.SSEKMSKeyId != nil {
		ok := object.Key("SSEKMSKeyId")
		ok.String(*v.SSEKMSKeyId)
	}

	if v.VersionId != nil {
		ok := object.Key("VersionId")
		ok.String(*v.VersionId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsSecretsManagerSecretDetails(v *types.AwsSecretsManagerSecretDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Deleted {
		ok := object.Key("Deleted")
		ok.Boolean(v.Deleted)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RotationEnabled {
		ok := object.Key("RotationEnabled")
		ok.Boolean(v.RotationEnabled)
	}

	if v.RotationLambdaArn != nil {
		ok := object.Key("RotationLambdaArn")
		ok.String(*v.RotationLambdaArn)
	}

	if v.RotationOccurredWithinFrequency {
		ok := object.Key("RotationOccurredWithinFrequency")
		ok.Boolean(v.RotationOccurredWithinFrequency)
	}

	if v.RotationRules != nil {
		ok := object.Key("RotationRules")
		if err := awsRestjson1_serializeDocumentAwsSecretsManagerSecretRotationRules(v.RotationRules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsSecretsManagerSecretRotationRules(v *types.AwsSecretsManagerSecretRotationRules, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutomaticallyAfterDays != 0 {
		ok := object.Key("AutomaticallyAfterDays")
		ok.Integer(v.AutomaticallyAfterDays)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsSecurityFinding(v *types.AwsSecurityFinding, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("Action")
		if err := awsRestjson1_serializeDocumentAction(v.Action, ok); err != nil {
			return err
		}
	}

	if v.AwsAccountId != nil {
		ok := object.Key("AwsAccountId")
		ok.String(*v.AwsAccountId)
	}

	if v.CompanyName != nil {
		ok := object.Key("CompanyName")
		ok.String(*v.CompanyName)
	}

	if v.Compliance != nil {
		ok := object.Key("Compliance")
		if err := awsRestjson1_serializeDocumentCompliance(v.Compliance, ok); err != nil {
			return err
		}
	}

	if v.Confidence != 0 {
		ok := object.Key("Confidence")
		ok.Integer(v.Confidence)
	}

	if v.CreatedAt != nil {
		ok := object.Key("CreatedAt")
		ok.String(*v.CreatedAt)
	}

	if v.Criticality != 0 {
		ok := object.Key("Criticality")
		ok.Integer(v.Criticality)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.FindingProviderFields != nil {
		ok := object.Key("FindingProviderFields")
		if err := awsRestjson1_serializeDocumentFindingProviderFields(v.FindingProviderFields, ok); err != nil {
			return err
		}
	}

	if v.FirstObservedAt != nil {
		ok := object.Key("FirstObservedAt")
		ok.String(*v.FirstObservedAt)
	}

	if v.GeneratorId != nil {
		ok := object.Key("GeneratorId")
		ok.String(*v.GeneratorId)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LastObservedAt != nil {
		ok := object.Key("LastObservedAt")
		ok.String(*v.LastObservedAt)
	}

	if v.Malware != nil {
		ok := object.Key("Malware")
		if err := awsRestjson1_serializeDocumentMalwareList(v.Malware, ok); err != nil {
			return err
		}
	}

	if v.Network != nil {
		ok := object.Key("Network")
		if err := awsRestjson1_serializeDocumentNetwork(v.Network, ok); err != nil {
			return err
		}
	}

	if v.NetworkPath != nil {
		ok := object.Key("NetworkPath")
		if err := awsRestjson1_serializeDocumentNetworkPathList(v.NetworkPath, ok); err != nil {
			return err
		}
	}

	if v.Note != nil {
		ok := object.Key("Note")
		if err := awsRestjson1_serializeDocumentNote(v.Note, ok); err != nil {
			return err
		}
	}

	if v.PatchSummary != nil {
		ok := object.Key("PatchSummary")
		if err := awsRestjson1_serializeDocumentPatchSummary(v.PatchSummary, ok); err != nil {
			return err
		}
	}

	if v.Process != nil {
		ok := object.Key("Process")
		if err := awsRestjson1_serializeDocumentProcessDetails(v.Process, ok); err != nil {
			return err
		}
	}

	if v.ProductArn != nil {
		ok := object.Key("ProductArn")
		ok.String(*v.ProductArn)
	}

	if v.ProductFields != nil {
		ok := object.Key("ProductFields")
		if err := awsRestjson1_serializeDocumentFieldMap(v.ProductFields, ok); err != nil {
			return err
		}
	}

	if v.ProductName != nil {
		ok := object.Key("ProductName")
		ok.String(*v.ProductName)
	}

	if len(v.RecordState) > 0 {
		ok := object.Key("RecordState")
		ok.String(string(v.RecordState))
	}

	if v.Region != nil {
		ok := object.Key("Region")
		ok.String(*v.Region)
	}

	if v.RelatedFindings != nil {
		ok := object.Key("RelatedFindings")
		if err := awsRestjson1_serializeDocumentRelatedFindingList(v.RelatedFindings, ok); err != nil {
			return err
		}
	}

	if v.Remediation != nil {
		ok := object.Key("Remediation")
		if err := awsRestjson1_serializeDocumentRemediation(v.Remediation, ok); err != nil {
			return err
		}
	}

	if v.Resources != nil {
		ok := object.Key("Resources")
		if err := awsRestjson1_serializeDocumentResourceList(v.Resources, ok); err != nil {
			return err
		}
	}

	if v.SchemaVersion != nil {
		ok := object.Key("SchemaVersion")
		ok.String(*v.SchemaVersion)
	}

	if v.Severity != nil {
		ok := object.Key("Severity")
		if err := awsRestjson1_serializeDocumentSeverity(v.Severity, ok); err != nil {
			return err
		}
	}

	if v.SourceUrl != nil {
		ok := object.Key("SourceUrl")
		ok.String(*v.SourceUrl)
	}

	if v.ThreatIntelIndicators != nil {
		ok := object.Key("ThreatIntelIndicators")
		if err := awsRestjson1_serializeDocumentThreatIntelIndicatorList(v.ThreatIntelIndicators, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		ok.String(*v.Title)
	}

	if v.Types != nil {
		ok := object.Key("Types")
		if err := awsRestjson1_serializeDocumentTypeList(v.Types, ok); err != nil {
			return err
		}
	}

	if v.UpdatedAt != nil {
		ok := object.Key("UpdatedAt")
		ok.String(*v.UpdatedAt)
	}

	if v.UserDefinedFields != nil {
		ok := object.Key("UserDefinedFields")
		if err := awsRestjson1_serializeDocumentFieldMap(v.UserDefinedFields, ok); err != nil {
			return err
		}
	}

	if len(v.VerificationState) > 0 {
		ok := object.Key("VerificationState")
		ok.String(string(v.VerificationState))
	}

	if v.Vulnerabilities != nil {
		ok := object.Key("Vulnerabilities")
		if err := awsRestjson1_serializeDocumentVulnerabilityList(v.Vulnerabilities, ok); err != nil {
			return err
		}
	}

	if v.Workflow != nil {
		ok := object.Key("Workflow")
		if err := awsRestjson1_serializeDocumentWorkflow(v.Workflow, ok); err != nil {
			return err
		}
	}

	if len(v.WorkflowState) > 0 {
		ok := object.Key("WorkflowState")
		ok.String(string(v.WorkflowState))
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsSecurityFindingFilters(v *types.AwsSecurityFindingFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsAccountId != nil {
		ok := object.Key("AwsAccountId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.AwsAccountId, ok); err != nil {
			return err
		}
	}

	if v.CompanyName != nil {
		ok := object.Key("CompanyName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.CompanyName, ok); err != nil {
			return err
		}
	}

	if v.ComplianceStatus != nil {
		ok := object.Key("ComplianceStatus")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ComplianceStatus, ok); err != nil {
			return err
		}
	}

	if v.Confidence != nil {
		ok := object.Key("Confidence")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.Confidence, ok); err != nil {
			return err
		}
	}

	if v.CreatedAt != nil {
		ok := object.Key("CreatedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.CreatedAt, ok); err != nil {
			return err
		}
	}

	if v.Criticality != nil {
		ok := object.Key("Criticality")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.Criticality, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Description, ok); err != nil {
			return err
		}
	}

	if v.FindingProviderFieldsConfidence != nil {
		ok := object.Key("FindingProviderFieldsConfidence")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.FindingProviderFieldsConfidence, ok); err != nil {
			return err
		}
	}

	if v.FindingProviderFieldsCriticality != nil {
		ok := object.Key("FindingProviderFieldsCriticality")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.FindingProviderFieldsCriticality, ok); err != nil {
			return err
		}
	}

	if v.FindingProviderFieldsRelatedFindingsId != nil {
		ok := object.Key("FindingProviderFieldsRelatedFindingsId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.FindingProviderFieldsRelatedFindingsId, ok); err != nil {
			return err
		}
	}

	if v.FindingProviderFieldsRelatedFindingsProductArn != nil {
		ok := object.Key("FindingProviderFieldsRelatedFindingsProductArn")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.FindingProviderFieldsRelatedFindingsProductArn, ok); err != nil {
			return err
		}
	}

	if v.FindingProviderFieldsSeverityLabel != nil {
		ok := object.Key("FindingProviderFieldsSeverityLabel")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.FindingProviderFieldsSeverityLabel, ok); err != nil {
			return err
		}
	}

	if v.FindingProviderFieldsSeverityOriginal != nil {
		ok := object.Key("FindingProviderFieldsSeverityOriginal")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.FindingProviderFieldsSeverityOriginal, ok); err != nil {
			return err
		}
	}

	if v.FindingProviderFieldsTypes != nil {
		ok := object.Key("FindingProviderFieldsTypes")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.FindingProviderFieldsTypes, ok); err != nil {
			return err
		}
	}

	if v.FirstObservedAt != nil {
		ok := object.Key("FirstObservedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.FirstObservedAt, ok); err != nil {
			return err
		}
	}

	if v.GeneratorId != nil {
		ok := object.Key("GeneratorId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.GeneratorId, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("Id")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Id, ok); err != nil {
			return err
		}
	}

	if v.Keyword != nil {
		ok := object.Key("Keyword")
		if err := awsRestjson1_serializeDocumentKeywordFilterList(v.Keyword, ok); err != nil {
			return err
		}
	}

	if v.LastObservedAt != nil {
		ok := object.Key("LastObservedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.LastObservedAt, ok); err != nil {
			return err
		}
	}

	if v.MalwareName != nil {
		ok := object.Key("MalwareName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.MalwareName, ok); err != nil {
			return err
		}
	}

	if v.MalwarePath != nil {
		ok := object.Key("MalwarePath")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.MalwarePath, ok); err != nil {
			return err
		}
	}

	if v.MalwareState != nil {
		ok := object.Key("MalwareState")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.MalwareState, ok); err != nil {
			return err
		}
	}

	if v.MalwareType != nil {
		ok := object.Key("MalwareType")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.MalwareType, ok); err != nil {
			return err
		}
	}

	if v.NetworkDestinationDomain != nil {
		ok := object.Key("NetworkDestinationDomain")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.NetworkDestinationDomain, ok); err != nil {
			return err
		}
	}

	if v.NetworkDestinationIpV4 != nil {
		ok := object.Key("NetworkDestinationIpV4")
		if err := awsRestjson1_serializeDocumentIpFilterList(v.NetworkDestinationIpV4, ok); err != nil {
			return err
		}
	}

	if v.NetworkDestinationIpV6 != nil {
		ok := object.Key("NetworkDestinationIpV6")
		if err := awsRestjson1_serializeDocumentIpFilterList(v.NetworkDestinationIpV6, ok); err != nil {
			return err
		}
	}

	if v.NetworkDestinationPort != nil {
		ok := object.Key("NetworkDestinationPort")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.NetworkDestinationPort, ok); err != nil {
			return err
		}
	}

	if v.NetworkDirection != nil {
		ok := object.Key("NetworkDirection")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.NetworkDirection, ok); err != nil {
			return err
		}
	}

	if v.NetworkProtocol != nil {
		ok := object.Key("NetworkProtocol")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.NetworkProtocol, ok); err != nil {
			return err
		}
	}

	if v.NetworkSourceDomain != nil {
		ok := object.Key("NetworkSourceDomain")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.NetworkSourceDomain, ok); err != nil {
			return err
		}
	}

	if v.NetworkSourceIpV4 != nil {
		ok := object.Key("NetworkSourceIpV4")
		if err := awsRestjson1_serializeDocumentIpFilterList(v.NetworkSourceIpV4, ok); err != nil {
			return err
		}
	}

	if v.NetworkSourceIpV6 != nil {
		ok := object.Key("NetworkSourceIpV6")
		if err := awsRestjson1_serializeDocumentIpFilterList(v.NetworkSourceIpV6, ok); err != nil {
			return err
		}
	}

	if v.NetworkSourceMac != nil {
		ok := object.Key("NetworkSourceMac")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.NetworkSourceMac, ok); err != nil {
			return err
		}
	}

	if v.NetworkSourcePort != nil {
		ok := object.Key("NetworkSourcePort")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.NetworkSourcePort, ok); err != nil {
			return err
		}
	}

	if v.NoteText != nil {
		ok := object.Key("NoteText")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.NoteText, ok); err != nil {
			return err
		}
	}

	if v.NoteUpdatedAt != nil {
		ok := object.Key("NoteUpdatedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.NoteUpdatedAt, ok); err != nil {
			return err
		}
	}

	if v.NoteUpdatedBy != nil {
		ok := object.Key("NoteUpdatedBy")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.NoteUpdatedBy, ok); err != nil {
			return err
		}
	}

	if v.ProcessLaunchedAt != nil {
		ok := object.Key("ProcessLaunchedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.ProcessLaunchedAt, ok); err != nil {
			return err
		}
	}

	if v.ProcessName != nil {
		ok := object.Key("ProcessName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ProcessName, ok); err != nil {
			return err
		}
	}

	if v.ProcessParentPid != nil {
		ok := object.Key("ProcessParentPid")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.ProcessParentPid, ok); err != nil {
			return err
		}
	}

	if v.ProcessPath != nil {
		ok := object.Key("ProcessPath")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ProcessPath, ok); err != nil {
			return err
		}
	}

	if v.ProcessPid != nil {
		ok := object.Key("ProcessPid")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.ProcessPid, ok); err != nil {
			return err
		}
	}

	if v.ProcessTerminatedAt != nil {
		ok := object.Key("ProcessTerminatedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.ProcessTerminatedAt, ok); err != nil {
			return err
		}
	}

	if v.ProductArn != nil {
		ok := object.Key("ProductArn")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ProductArn, ok); err != nil {
			return err
		}
	}

	if v.ProductFields != nil {
		ok := object.Key("ProductFields")
		if err := awsRestjson1_serializeDocumentMapFilterList(v.ProductFields, ok); err != nil {
			return err
		}
	}

	if v.ProductName != nil {
		ok := object.Key("ProductName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ProductName, ok); err != nil {
			return err
		}
	}

	if v.RecommendationText != nil {
		ok := object.Key("RecommendationText")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.RecommendationText, ok); err != nil {
			return err
		}
	}

	if v.RecordState != nil {
		ok := object.Key("RecordState")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.RecordState, ok); err != nil {
			return err
		}
	}

	if v.Region != nil {
		ok := object.Key("Region")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Region, ok); err != nil {
			return err
		}
	}

	if v.RelatedFindingsId != nil {
		ok := object.Key("RelatedFindingsId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.RelatedFindingsId, ok); err != nil {
			return err
		}
	}

	if v.RelatedFindingsProductArn != nil {
		ok := object.Key("RelatedFindingsProductArn")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.RelatedFindingsProductArn, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsEc2InstanceIamInstanceProfileArn != nil {
		ok := object.Key("ResourceAwsEc2InstanceIamInstanceProfileArn")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsEc2InstanceIamInstanceProfileArn, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsEc2InstanceImageId != nil {
		ok := object.Key("ResourceAwsEc2InstanceImageId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsEc2InstanceImageId, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsEc2InstanceIpV4Addresses != nil {
		ok := object.Key("ResourceAwsEc2InstanceIpV4Addresses")
		if err := awsRestjson1_serializeDocumentIpFilterList(v.ResourceAwsEc2InstanceIpV4Addresses, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsEc2InstanceIpV6Addresses != nil {
		ok := object.Key("ResourceAwsEc2InstanceIpV6Addresses")
		if err := awsRestjson1_serializeDocumentIpFilterList(v.ResourceAwsEc2InstanceIpV6Addresses, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsEc2InstanceKeyName != nil {
		ok := object.Key("ResourceAwsEc2InstanceKeyName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsEc2InstanceKeyName, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsEc2InstanceLaunchedAt != nil {
		ok := object.Key("ResourceAwsEc2InstanceLaunchedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.ResourceAwsEc2InstanceLaunchedAt, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsEc2InstanceSubnetId != nil {
		ok := object.Key("ResourceAwsEc2InstanceSubnetId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsEc2InstanceSubnetId, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsEc2InstanceType != nil {
		ok := object.Key("ResourceAwsEc2InstanceType")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsEc2InstanceType, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsEc2InstanceVpcId != nil {
		ok := object.Key("ResourceAwsEc2InstanceVpcId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsEc2InstanceVpcId, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsIamAccessKeyCreatedAt != nil {
		ok := object.Key("ResourceAwsIamAccessKeyCreatedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.ResourceAwsIamAccessKeyCreatedAt, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsIamAccessKeyPrincipalName != nil {
		ok := object.Key("ResourceAwsIamAccessKeyPrincipalName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsIamAccessKeyPrincipalName, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsIamAccessKeyStatus != nil {
		ok := object.Key("ResourceAwsIamAccessKeyStatus")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsIamAccessKeyStatus, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsIamAccessKeyUserName != nil {
		ok := object.Key("ResourceAwsIamAccessKeyUserName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsIamAccessKeyUserName, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsIamUserUserName != nil {
		ok := object.Key("ResourceAwsIamUserUserName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsIamUserUserName, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsS3BucketOwnerId != nil {
		ok := object.Key("ResourceAwsS3BucketOwnerId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsS3BucketOwnerId, ok); err != nil {
			return err
		}
	}

	if v.ResourceAwsS3BucketOwnerName != nil {
		ok := object.Key("ResourceAwsS3BucketOwnerName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceAwsS3BucketOwnerName, ok); err != nil {
			return err
		}
	}

	if v.ResourceContainerImageId != nil {
		ok := object.Key("ResourceContainerImageId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceContainerImageId, ok); err != nil {
			return err
		}
	}

	if v.ResourceContainerImageName != nil {
		ok := object.Key("ResourceContainerImageName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceContainerImageName, ok); err != nil {
			return err
		}
	}

	if v.ResourceContainerLaunchedAt != nil {
		ok := object.Key("ResourceContainerLaunchedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.ResourceContainerLaunchedAt, ok); err != nil {
			return err
		}
	}

	if v.ResourceContainerName != nil {
		ok := object.Key("ResourceContainerName")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceContainerName, ok); err != nil {
			return err
		}
	}

	if v.ResourceDetailsOther != nil {
		ok := object.Key("ResourceDetailsOther")
		if err := awsRestjson1_serializeDocumentMapFilterList(v.ResourceDetailsOther, ok); err != nil {
			return err
		}
	}

	if v.ResourceId != nil {
		ok := object.Key("ResourceId")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceId, ok); err != nil {
			return err
		}
	}

	if v.ResourcePartition != nil {
		ok := object.Key("ResourcePartition")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourcePartition, ok); err != nil {
			return err
		}
	}

	if v.ResourceRegion != nil {
		ok := object.Key("ResourceRegion")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceRegion, ok); err != nil {
			return err
		}
	}

	if v.ResourceTags != nil {
		ok := object.Key("ResourceTags")
		if err := awsRestjson1_serializeDocumentMapFilterList(v.ResourceTags, ok); err != nil {
			return err
		}
	}

	if v.ResourceType != nil {
		ok := object.Key("ResourceType")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ResourceType, ok); err != nil {
			return err
		}
	}

	if v.SeverityLabel != nil {
		ok := object.Key("SeverityLabel")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.SeverityLabel, ok); err != nil {
			return err
		}
	}

	if v.SeverityNormalized != nil {
		ok := object.Key("SeverityNormalized")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.SeverityNormalized, ok); err != nil {
			return err
		}
	}

	if v.SeverityProduct != nil {
		ok := object.Key("SeverityProduct")
		if err := awsRestjson1_serializeDocumentNumberFilterList(v.SeverityProduct, ok); err != nil {
			return err
		}
	}

	if v.SourceUrl != nil {
		ok := object.Key("SourceUrl")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.SourceUrl, ok); err != nil {
			return err
		}
	}

	if v.ThreatIntelIndicatorCategory != nil {
		ok := object.Key("ThreatIntelIndicatorCategory")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ThreatIntelIndicatorCategory, ok); err != nil {
			return err
		}
	}

	if v.ThreatIntelIndicatorLastObservedAt != nil {
		ok := object.Key("ThreatIntelIndicatorLastObservedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.ThreatIntelIndicatorLastObservedAt, ok); err != nil {
			return err
		}
	}

	if v.ThreatIntelIndicatorSource != nil {
		ok := object.Key("ThreatIntelIndicatorSource")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ThreatIntelIndicatorSource, ok); err != nil {
			return err
		}
	}

	if v.ThreatIntelIndicatorSourceUrl != nil {
		ok := object.Key("ThreatIntelIndicatorSourceUrl")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ThreatIntelIndicatorSourceUrl, ok); err != nil {
			return err
		}
	}

	if v.ThreatIntelIndicatorType != nil {
		ok := object.Key("ThreatIntelIndicatorType")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ThreatIntelIndicatorType, ok); err != nil {
			return err
		}
	}

	if v.ThreatIntelIndicatorValue != nil {
		ok := object.Key("ThreatIntelIndicatorValue")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.ThreatIntelIndicatorValue, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("Title")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Title, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.Type, ok); err != nil {
			return err
		}
	}

	if v.UpdatedAt != nil {
		ok := object.Key("UpdatedAt")
		if err := awsRestjson1_serializeDocumentDateFilterList(v.UpdatedAt, ok); err != nil {
			return err
		}
	}

	if v.UserDefinedFields != nil {
		ok := object.Key("UserDefinedFields")
		if err := awsRestjson1_serializeDocumentMapFilterList(v.UserDefinedFields, ok); err != nil {
			return err
		}
	}

	if v.VerificationState != nil {
		ok := object.Key("VerificationState")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.VerificationState, ok); err != nil {
			return err
		}
	}

	if v.WorkflowState != nil {
		ok := object.Key("WorkflowState")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.WorkflowState, ok); err != nil {
			return err
		}
	}

	if v.WorkflowStatus != nil {
		ok := object.Key("WorkflowStatus")
		if err := awsRestjson1_serializeDocumentStringFilterList(v.WorkflowStatus, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsSecurityFindingIdentifier(v *types.AwsSecurityFindingIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.ProductArn != nil {
		ok := object.Key("ProductArn")
		ok.String(*v.ProductArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsSecurityFindingIdentifierList(v []types.AwsSecurityFindingIdentifier, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsSecurityFindingIdentifier(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsSnsTopicDetails(v *types.AwsSnsTopicDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsMasterKeyId != nil {
		ok := object.Key("KmsMasterKeyId")
		ok.String(*v.KmsMasterKeyId)
	}

	if v.Owner != nil {
		ok := object.Key("Owner")
		ok.String(*v.Owner)
	}

	if v.Subscription != nil {
		ok := object.Key("Subscription")
		if err := awsRestjson1_serializeDocumentAwsSnsTopicSubscriptionList(v.Subscription, ok); err != nil {
			return err
		}
	}

	if v.TopicName != nil {
		ok := object.Key("TopicName")
		ok.String(*v.TopicName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsSnsTopicSubscription(v *types.AwsSnsTopicSubscription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Endpoint != nil {
		ok := object.Key("Endpoint")
		ok.String(*v.Endpoint)
	}

	if v.Protocol != nil {
		ok := object.Key("Protocol")
		ok.String(*v.Protocol)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsSnsTopicSubscriptionList(v []types.AwsSnsTopicSubscription, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsSnsTopicSubscription(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAwsSqsQueueDetails(v *types.AwsSqsQueueDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeadLetterTargetArn != nil {
		ok := object.Key("DeadLetterTargetArn")
		ok.String(*v.DeadLetterTargetArn)
	}

	if v.KmsDataKeyReusePeriodSeconds != 0 {
		ok := object.Key("KmsDataKeyReusePeriodSeconds")
		ok.Integer(v.KmsDataKeyReusePeriodSeconds)
	}

	if v.KmsMasterKeyId != nil {
		ok := object.Key("KmsMasterKeyId")
		ok.String(*v.KmsMasterKeyId)
	}

	if v.QueueName != nil {
		ok := object.Key("QueueName")
		ok.String(*v.QueueName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsSsmComplianceSummary(v *types.AwsSsmComplianceSummary, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComplianceType != nil {
		ok := object.Key("ComplianceType")
		ok.String(*v.ComplianceType)
	}

	if v.CompliantCriticalCount != 0 {
		ok := object.Key("CompliantCriticalCount")
		ok.Integer(v.CompliantCriticalCount)
	}

	if v.CompliantHighCount != 0 {
		ok := object.Key("CompliantHighCount")
		ok.Integer(v.CompliantHighCount)
	}

	if v.CompliantInformationalCount != 0 {
		ok := object.Key("CompliantInformationalCount")
		ok.Integer(v.CompliantInformationalCount)
	}

	if v.CompliantLowCount != 0 {
		ok := object.Key("CompliantLowCount")
		ok.Integer(v.CompliantLowCount)
	}

	if v.CompliantMediumCount != 0 {
		ok := object.Key("CompliantMediumCount")
		ok.Integer(v.CompliantMediumCount)
	}

	if v.CompliantUnspecifiedCount != 0 {
		ok := object.Key("CompliantUnspecifiedCount")
		ok.Integer(v.CompliantUnspecifiedCount)
	}

	if v.ExecutionType != nil {
		ok := object.Key("ExecutionType")
		ok.String(*v.ExecutionType)
	}

	if v.NonCompliantCriticalCount != 0 {
		ok := object.Key("NonCompliantCriticalCount")
		ok.Integer(v.NonCompliantCriticalCount)
	}

	if v.NonCompliantHighCount != 0 {
		ok := object.Key("NonCompliantHighCount")
		ok.Integer(v.NonCompliantHighCount)
	}

	if v.NonCompliantInformationalCount != 0 {
		ok := object.Key("NonCompliantInformationalCount")
		ok.Integer(v.NonCompliantInformationalCount)
	}

	if v.NonCompliantLowCount != 0 {
		ok := object.Key("NonCompliantLowCount")
		ok.Integer(v.NonCompliantLowCount)
	}

	if v.NonCompliantMediumCount != 0 {
		ok := object.Key("NonCompliantMediumCount")
		ok.Integer(v.NonCompliantMediumCount)
	}

	if v.NonCompliantUnspecifiedCount != 0 {
		ok := object.Key("NonCompliantUnspecifiedCount")
		ok.Integer(v.NonCompliantUnspecifiedCount)
	}

	if v.OverallSeverity != nil {
		ok := object.Key("OverallSeverity")
		ok.String(*v.OverallSeverity)
	}

	if v.PatchBaselineId != nil {
		ok := object.Key("PatchBaselineId")
		ok.String(*v.PatchBaselineId)
	}

	if v.PatchGroup != nil {
		ok := object.Key("PatchGroup")
		ok.String(*v.PatchGroup)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		ok.String(*v.Status)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsSsmPatch(v *types.AwsSsmPatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComplianceSummary != nil {
		ok := object.Key("ComplianceSummary")
		if err := awsRestjson1_serializeDocumentAwsSsmComplianceSummary(v.ComplianceSummary, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsSsmPatchComplianceDetails(v *types.AwsSsmPatchComplianceDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Patch != nil {
		ok := object.Key("Patch")
		if err := awsRestjson1_serializeDocumentAwsSsmPatch(v.Patch, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsWafWebAclDetails(v *types.AwsWafWebAclDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultAction != nil {
		ok := object.Key("DefaultAction")
		ok.String(*v.DefaultAction)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsRestjson1_serializeDocumentAwsWafWebAclRuleList(v.Rules, ok); err != nil {
			return err
		}
	}

	if v.WebAclId != nil {
		ok := object.Key("WebAclId")
		ok.String(*v.WebAclId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsWafWebAclRule(v *types.AwsWafWebAclRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("Action")
		if err := awsRestjson1_serializeDocumentWafAction(v.Action, ok); err != nil {
			return err
		}
	}

	if v.ExcludedRules != nil {
		ok := object.Key("ExcludedRules")
		if err := awsRestjson1_serializeDocumentWafExcludedRuleList(v.ExcludedRules, ok); err != nil {
			return err
		}
	}

	if v.OverrideAction != nil {
		ok := object.Key("OverrideAction")
		if err := awsRestjson1_serializeDocumentWafOverrideAction(v.OverrideAction, ok); err != nil {
			return err
		}
	}

	if v.Priority != 0 {
		ok := object.Key("Priority")
		ok.Integer(v.Priority)
	}

	if v.RuleId != nil {
		ok := object.Key("RuleId")
		ok.String(*v.RuleId)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsWafWebAclRuleList(v []types.AwsWafWebAclRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsWafWebAclRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBatchImportFindingsRequestFindingList(v []types.AwsSecurityFinding, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAwsSecurityFinding(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCell(v *types.Cell, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CellReference != nil {
		ok := object.Key("CellReference")
		ok.String(*v.CellReference)
	}

	if v.Column != 0 {
		ok := object.Key("Column")
		ok.Long(v.Column)
	}

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.Row != 0 {
		ok := object.Key("Row")
		ok.Long(v.Row)
	}

	return nil
}

func awsRestjson1_serializeDocumentCells(v []types.Cell, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCell(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCidrBlockAssociation(v *types.CidrBlockAssociation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssociationId != nil {
		ok := object.Key("AssociationId")
		ok.String(*v.AssociationId)
	}

	if v.CidrBlock != nil {
		ok := object.Key("CidrBlock")
		ok.String(*v.CidrBlock)
	}

	if v.CidrBlockState != nil {
		ok := object.Key("CidrBlockState")
		ok.String(*v.CidrBlockState)
	}

	return nil
}

func awsRestjson1_serializeDocumentCidrBlockAssociationList(v []types.CidrBlockAssociation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCidrBlockAssociation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCity(v *types.City, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CityName != nil {
		ok := object.Key("CityName")
		ok.String(*v.CityName)
	}

	return nil
}

func awsRestjson1_serializeDocumentClassificationResult(v *types.ClassificationResult, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalOccurrences {
		ok := object.Key("AdditionalOccurrences")
		ok.Boolean(v.AdditionalOccurrences)
	}

	if v.CustomDataIdentifiers != nil {
		ok := object.Key("CustomDataIdentifiers")
		if err := awsRestjson1_serializeDocumentCustomDataIdentifiersResult(v.CustomDataIdentifiers, ok); err != nil {
			return err
		}
	}

	if v.MimeType != nil {
		ok := object.Key("MimeType")
		ok.String(*v.MimeType)
	}

	if v.SensitiveData != nil {
		ok := object.Key("SensitiveData")
		if err := awsRestjson1_serializeDocumentSensitiveDataResultList(v.SensitiveData, ok); err != nil {
			return err
		}
	}

	if v.SizeClassified != 0 {
		ok := object.Key("SizeClassified")
		ok.Long(v.SizeClassified)
	}

	if v.Status != nil {
		ok := object.Key("Status")
		if err := awsRestjson1_serializeDocumentClassificationStatus(v.Status, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentClassificationStatus(v *types.ClassificationStatus, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Code != nil {
		ok := object.Key("Code")
		ok.String(*v.Code)
	}

	if v.Reason != nil {
		ok := object.Key("Reason")
		ok.String(*v.Reason)
	}

	return nil
}

func awsRestjson1_serializeDocumentCompliance(v *types.Compliance, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RelatedRequirements != nil {
		ok := object.Key("RelatedRequirements")
		if err := awsRestjson1_serializeDocumentRelatedRequirementsList(v.RelatedRequirements, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if v.StatusReasons != nil {
		ok := object.Key("StatusReasons")
		if err := awsRestjson1_serializeDocumentStatusReasonsList(v.StatusReasons, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerDetails(v *types.ContainerDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ImageId != nil {
		ok := object.Key("ImageId")
		ok.String(*v.ImageId)
	}

	if v.ImageName != nil {
		ok := object.Key("ImageName")
		ok.String(*v.ImageName)
	}

	if v.LaunchedAt != nil {
		ok := object.Key("LaunchedAt")
		ok.String(*v.LaunchedAt)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentCountry(v *types.Country, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CountryCode != nil {
		ok := object.Key("CountryCode")
		ok.String(*v.CountryCode)
	}

	if v.CountryName != nil {
		ok := object.Key("CountryName")
		ok.String(*v.CountryName)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomDataIdentifiersDetections(v *types.CustomDataIdentifiersDetections, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.Count != 0 {
		ok := object.Key("Count")
		ok.Long(v.Count)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Occurrences != nil {
		ok := object.Key("Occurrences")
		if err := awsRestjson1_serializeDocumentOccurrences(v.Occurrences, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomDataIdentifiersDetectionsList(v []types.CustomDataIdentifiersDetections, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCustomDataIdentifiersDetections(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCustomDataIdentifiersResult(v *types.CustomDataIdentifiersResult, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Detections != nil {
		ok := object.Key("Detections")
		if err := awsRestjson1_serializeDocumentCustomDataIdentifiersDetectionsList(v.Detections, ok); err != nil {
			return err
		}
	}

	if v.TotalCount != 0 {
		ok := object.Key("TotalCount")
		ok.Long(v.TotalCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentCvss(v *types.Cvss, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Adjustments != nil {
		ok := object.Key("Adjustments")
		if err := awsRestjson1_serializeDocumentAdjustmentList(v.Adjustments, ok); err != nil {
			return err
		}
	}

	if v.BaseScore != 0 {
		ok := object.Key("BaseScore")
		switch {
		case math.IsNaN(v.BaseScore):
			ok.String("NaN")

		case math.IsInf(v.BaseScore, 1):
			ok.String("Infinity")

		case math.IsInf(v.BaseScore, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.BaseScore)

		}
	}

	if v.BaseVector != nil {
		ok := object.Key("BaseVector")
		ok.String(*v.BaseVector)
	}

	if v.Source != nil {
		ok := object.Key("Source")
		ok.String(*v.Source)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentCvssList(v []types.Cvss, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCvss(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataClassificationDetails(v *types.DataClassificationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DetailedResultsLocation != nil {
		ok := object.Key("DetailedResultsLocation")
		ok.String(*v.DetailedResultsLocation)
	}

	if v.Result != nil {
		ok := object.Key("Result")
		if err := awsRestjson1_serializeDocumentClassificationResult(v.Result, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateFilter(v *types.DateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	if v.End != nil {
		ok := object.Key("End")
		ok.String(*v.End)
	}

	if v.Start != nil {
		ok := object.Key("Start")
		ok.String(*v.Start)
	}

	return nil
}

func awsRestjson1_serializeDocumentDateFilterList(v []types.DateFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDateFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDateRange(v *types.DateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("Unit")
		ok.String(string(v.Unit))
	}

	if v.Value != 0 {
		ok := object.Key("Value")
		ok.Integer(v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentDnsRequestAction(v *types.DnsRequestAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Blocked {
		ok := object.Key("Blocked")
		ok.Boolean(v.Blocked)
	}

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	if v.Protocol != nil {
		ok := object.Key("Protocol")
		ok.String(*v.Protocol)
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentFindingProviderFields(v *types.FindingProviderFields, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Confidence != 0 {
		ok := object.Key("Confidence")
		ok.Integer(v.Confidence)
	}

	if v.Criticality != 0 {
		ok := object.Key("Criticality")
		ok.Integer(v.Criticality)
	}

	if v.RelatedFindings != nil {
		ok := object.Key("RelatedFindings")
		if err := awsRestjson1_serializeDocumentRelatedFindingList(v.RelatedFindings, ok); err != nil {
			return err
		}
	}

	if v.Severity != nil {
		ok := object.Key("Severity")
		if err := awsRestjson1_serializeDocumentFindingProviderSeverity(v.Severity, ok); err != nil {
			return err
		}
	}

	if v.Types != nil {
		ok := object.Key("Types")
		if err := awsRestjson1_serializeDocumentTypeList(v.Types, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFindingProviderSeverity(v *types.FindingProviderSeverity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Label) > 0 {
		ok := object.Key("Label")
		ok.String(string(v.Label))
	}

	if v.Original != nil {
		ok := object.Key("Original")
		ok.String(*v.Original)
	}

	return nil
}

func awsRestjson1_serializeDocumentGeoLocation(v *types.GeoLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Lat != 0 {
		ok := object.Key("Lat")
		switch {
		case math.IsNaN(v.Lat):
			ok.String("NaN")

		case math.IsInf(v.Lat, 1):
			ok.String("Infinity")

		case math.IsInf(v.Lat, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Lat)

		}
	}

	if v.Lon != 0 {
		ok := object.Key("Lon")
		switch {
		case math.IsNaN(v.Lon):
			ok.String("NaN")

		case math.IsInf(v.Lon, 1):
			ok.String("Infinity")

		case math.IsInf(v.Lon, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Lon)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIcmpTypeCode(v *types.IcmpTypeCode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Code != 0 {
		ok := object.Key("Code")
		ok.Integer(v.Code)
	}

	if v.Type != 0 {
		ok := object.Key("Type")
		ok.Integer(v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentIntegerList(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentIpFilter(v *types.IpFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cidr != nil {
		ok := object.Key("Cidr")
		ok.String(*v.Cidr)
	}

	return nil
}

func awsRestjson1_serializeDocumentIpFilterList(v []types.IpFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentIpFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIpOrganizationDetails(v *types.IpOrganizationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Asn != 0 {
		ok := object.Key("Asn")
		ok.Integer(v.Asn)
	}

	if v.AsnOrg != nil {
		ok := object.Key("AsnOrg")
		ok.String(*v.AsnOrg)
	}

	if v.Isp != nil {
		ok := object.Key("Isp")
		ok.String(*v.Isp)
	}

	if v.Org != nil {
		ok := object.Key("Org")
		ok.String(*v.Org)
	}

	return nil
}

func awsRestjson1_serializeDocumentIpv6CidrBlockAssociation(v *types.Ipv6CidrBlockAssociation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssociationId != nil {
		ok := object.Key("AssociationId")
		ok.String(*v.AssociationId)
	}

	if v.CidrBlockState != nil {
		ok := object.Key("CidrBlockState")
		ok.String(*v.CidrBlockState)
	}

	if v.Ipv6CidrBlock != nil {
		ok := object.Key("Ipv6CidrBlock")
		ok.String(*v.Ipv6CidrBlock)
	}

	return nil
}

func awsRestjson1_serializeDocumentIpv6CidrBlockAssociationList(v []types.Ipv6CidrBlockAssociation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentIpv6CidrBlockAssociation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentKeywordFilter(v *types.KeywordFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentKeywordFilterList(v []types.KeywordFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentKeywordFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLoadBalancerState(v *types.LoadBalancerState, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Code != nil {
		ok := object.Key("Code")
		ok.String(*v.Code)
	}

	if v.Reason != nil {
		ok := object.Key("Reason")
		ok.String(*v.Reason)
	}

	return nil
}

func awsRestjson1_serializeDocumentMalware(v *types.Malware, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if len(v.State) > 0 {
		ok := object.Key("State")
		ok.String(string(v.State))
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentMalwareList(v []types.Malware, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMalware(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapFilter(v *types.MapFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("Comparison")
		ok.String(string(v.Comparison))
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentMapFilterList(v []types.MapFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMapFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentNetwork(v *types.Network, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationDomain != nil {
		ok := object.Key("DestinationDomain")
		ok.String(*v.DestinationDomain)
	}

	if v.DestinationIpV4 != nil {
		ok := object.Key("DestinationIpV4")
		ok.String(*v.DestinationIpV4)
	}

	if v.DestinationIpV6 != nil {
		ok := object.Key("DestinationIpV6")
		ok.String(*v.DestinationIpV6)
	}

	if v.DestinationPort != 0 {
		ok := object.Key("DestinationPort")
		ok.Integer(v.DestinationPort)
	}

	if len(v.Direction) > 0 {
		ok := object.Key("Direction")
		ok.String(string(v.Direction))
	}

	if v.OpenPortRange != nil {
		ok := object.Key("OpenPortRange")
		if err := awsRestjson1_serializeDocumentPortRange(v.OpenPortRange, ok); err != nil {
			return err
		}
	}

	if v.Protocol != nil {
		ok := object.Key("Protocol")
		ok.String(*v.Protocol)
	}

	if v.SourceDomain != nil {
		ok := object.Key("SourceDomain")
		ok.String(*v.SourceDomain)
	}

	if v.SourceIpV4 != nil {
		ok := object.Key("SourceIpV4")
		ok.String(*v.SourceIpV4)
	}

	if v.SourceIpV6 != nil {
		ok := object.Key("SourceIpV6")
		ok.String(*v.SourceIpV6)
	}

	if v.SourceMac != nil {
		ok := object.Key("SourceMac")
		ok.String(*v.SourceMac)
	}

	if v.SourcePort != 0 {
		ok := object.Key("SourcePort")
		ok.Integer(v.SourcePort)
	}

	return nil
}

func awsRestjson1_serializeDocumentNetworkConnectionAction(v *types.NetworkConnectionAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Blocked {
		ok := object.Key("Blocked")
		ok.Boolean(v.Blocked)
	}

	if v.ConnectionDirection != nil {
		ok := object.Key("ConnectionDirection")
		ok.String(*v.ConnectionDirection)
	}

	if v.LocalPortDetails != nil {
		ok := object.Key("LocalPortDetails")
		if err := awsRestjson1_serializeDocumentActionLocalPortDetails(v.LocalPortDetails, ok); err != nil {
			return err
		}
	}

	if v.Protocol != nil {
		ok := object.Key("Protocol")
		ok.String(*v.Protocol)
	}

	if v.RemoteIpDetails != nil {
		ok := object.Key("RemoteIpDetails")
		if err := awsRestjson1_serializeDocumentActionRemoteIpDetails(v.RemoteIpDetails, ok); err != nil {
			return err
		}
	}

	if v.RemotePortDetails != nil {
		ok := object.Key("RemotePortDetails")
		if err := awsRestjson1_serializeDocumentActionRemotePortDetails(v.RemotePortDetails, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNetworkHeader(v *types.NetworkHeader, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("Destination")
		if err := awsRestjson1_serializeDocumentNetworkPathComponentDetails(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.Protocol != nil {
		ok := object.Key("Protocol")
		ok.String(*v.Protocol)
	}

	if v.Source != nil {
		ok := object.Key("Source")
		if err := awsRestjson1_serializeDocumentNetworkPathComponentDetails(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNetworkPathComponent(v *types.NetworkPathComponent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentId != nil {
		ok := object.Key("ComponentId")
		ok.String(*v.ComponentId)
	}

	if v.ComponentType != nil {
		ok := object.Key("ComponentType")
		ok.String(*v.ComponentType)
	}

	if v.Egress != nil {
		ok := object.Key("Egress")
		if err := awsRestjson1_serializeDocumentNetworkHeader(v.Egress, ok); err != nil {
			return err
		}
	}

	if v.Ingress != nil {
		ok := object.Key("Ingress")
		if err := awsRestjson1_serializeDocumentNetworkHeader(v.Ingress, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNetworkPathComponentDetails(v *types.NetworkPathComponentDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Address != nil {
		ok := object.Key("Address")
		if err := awsRestjson1_serializeDocumentStringList(v.Address, ok); err != nil {
			return err
		}
	}

	if v.PortRanges != nil {
		ok := object.Key("PortRanges")
		if err := awsRestjson1_serializeDocumentPortRangeList(v.PortRanges, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNetworkPathList(v []types.NetworkPathComponent, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentNetworkPathComponent(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentNonEmptyStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentNote(v *types.Note, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Text != nil {
		ok := object.Key("Text")
		ok.String(*v.Text)
	}

	if v.UpdatedAt != nil {
		ok := object.Key("UpdatedAt")
		ok.String(*v.UpdatedAt)
	}

	if v.UpdatedBy != nil {
		ok := object.Key("UpdatedBy")
		ok.String(*v.UpdatedBy)
	}

	return nil
}

func awsRestjson1_serializeDocumentNoteUpdate(v *types.NoteUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Text != nil {
		ok := object.Key("Text")
		ok.String(*v.Text)
	}

	if v.UpdatedBy != nil {
		ok := object.Key("UpdatedBy")
		ok.String(*v.UpdatedBy)
	}

	return nil
}

func awsRestjson1_serializeDocumentNumberFilter(v *types.NumberFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Eq != 0 {
		ok := object.Key("Eq")
		switch {
		case math.IsNaN(v.Eq):
			ok.String("NaN")

		case math.IsInf(v.Eq, 1):
			ok.String("Infinity")

		case math.IsInf(v.Eq, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Eq)

		}
	}

	if v.Gte != 0 {
		ok := object.Key("Gte")
		switch {
		case math.IsNaN(v.Gte):
			ok.String("NaN")

		case math.IsInf(v.Gte, 1):
			ok.String("Infinity")

		case math.IsInf(v.Gte, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Gte)

		}
	}

	if v.Lte != 0 {
		ok := object.Key("Lte")
		switch {
		case math.IsNaN(v.Lte):
			ok.String("NaN")

		case math.IsInf(v.Lte, 1):
			ok.String("Infinity")

		case math.IsInf(v.Lte, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Lte)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNumberFilterList(v []types.NumberFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentNumberFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentOccurrences(v *types.Occurrences, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cells != nil {
		ok := object.Key("Cells")
		if err := awsRestjson1_serializeDocumentCells(v.Cells, ok); err != nil {
			return err
		}
	}

	if v.LineRanges != nil {
		ok := object.Key("LineRanges")
		if err := awsRestjson1_serializeDocumentRanges(v.LineRanges, ok); err != nil {
			return err
		}
	}

	if v.OffsetRanges != nil {
		ok := object.Key("OffsetRanges")
		if err := awsRestjson1_serializeDocumentRanges(v.OffsetRanges, ok); err != nil {
			return err
		}
	}

	if v.Pages != nil {
		ok := object.Key("Pages")
		if err := awsRestjson1_serializeDocumentPages(v.Pages, ok); err != nil {
			return err
		}
	}

	if v.Records != nil {
		ok := object.Key("Records")
		if err := awsRestjson1_serializeDocumentRecords(v.Records, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPage(v *types.Page, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LineRange != nil {
		ok := object.Key("LineRange")
		if err := awsRestjson1_serializeDocumentRange(v.LineRange, ok); err != nil {
			return err
		}
	}

	if v.OffsetRange != nil {
		ok := object.Key("OffsetRange")
		if err := awsRestjson1_serializeDocumentRange(v.OffsetRange, ok); err != nil {
			return err
		}
	}

	if v.PageNumber != 0 {
		ok := object.Key("PageNumber")
		ok.Long(v.PageNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentPages(v []types.Page, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPatchSummary(v *types.PatchSummary, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FailedCount != 0 {
		ok := object.Key("FailedCount")
		ok.Integer(v.FailedCount)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.InstalledCount != 0 {
		ok := object.Key("InstalledCount")
		ok.Integer(v.InstalledCount)
	}

	if v.InstalledOtherCount != 0 {
		ok := object.Key("InstalledOtherCount")
		ok.Integer(v.InstalledOtherCount)
	}

	if v.InstalledPendingReboot != 0 {
		ok := object.Key("InstalledPendingReboot")
		ok.Integer(v.InstalledPendingReboot)
	}

	if v.InstalledRejectedCount != 0 {
		ok := object.Key("InstalledRejectedCount")
		ok.Integer(v.InstalledRejectedCount)
	}

	if v.MissingCount != 0 {
		ok := object.Key("MissingCount")
		ok.Integer(v.MissingCount)
	}

	if v.Operation != nil {
		ok := object.Key("Operation")
		ok.String(*v.Operation)
	}

	if v.OperationEndTime != nil {
		ok := object.Key("OperationEndTime")
		ok.String(*v.OperationEndTime)
	}

	if v.OperationStartTime != nil {
		ok := object.Key("OperationStartTime")
		ok.String(*v.OperationStartTime)
	}

	if v.RebootOption != nil {
		ok := object.Key("RebootOption")
		ok.String(*v.RebootOption)
	}

	return nil
}

func awsRestjson1_serializeDocumentPortProbeAction(v *types.PortProbeAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Blocked {
		ok := object.Key("Blocked")
		ok.Boolean(v.Blocked)
	}

	if v.PortProbeDetails != nil {
		ok := object.Key("PortProbeDetails")
		if err := awsRestjson1_serializeDocumentPortProbeDetailList(v.PortProbeDetails, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPortProbeDetail(v *types.PortProbeDetail, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LocalIpDetails != nil {
		ok := object.Key("LocalIpDetails")
		if err := awsRestjson1_serializeDocumentActionLocalIpDetails(v.LocalIpDetails, ok); err != nil {
			return err
		}
	}

	if v.LocalPortDetails != nil {
		ok := object.Key("LocalPortDetails")
		if err := awsRestjson1_serializeDocumentActionLocalPortDetails(v.LocalPortDetails, ok); err != nil {
			return err
		}
	}

	if v.RemoteIpDetails != nil {
		ok := object.Key("RemoteIpDetails")
		if err := awsRestjson1_serializeDocumentActionRemoteIpDetails(v.RemoteIpDetails, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPortProbeDetailList(v []types.PortProbeDetail, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPortProbeDetail(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPortRange(v *types.PortRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Begin != 0 {
		ok := object.Key("Begin")
		ok.Integer(v.Begin)
	}

	if v.End != 0 {
		ok := object.Key("End")
		ok.Integer(v.End)
	}

	return nil
}

func awsRestjson1_serializeDocumentPortRangeFromTo(v *types.PortRangeFromTo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.From != 0 {
		ok := object.Key("From")
		ok.Integer(v.From)
	}

	if v.To != 0 {
		ok := object.Key("To")
		ok.Integer(v.To)
	}

	return nil
}

func awsRestjson1_serializeDocumentPortRangeList(v []types.PortRange, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPortRange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentProcessDetails(v *types.ProcessDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LaunchedAt != nil {
		ok := object.Key("LaunchedAt")
		ok.String(*v.LaunchedAt)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ParentPid != 0 {
		ok := object.Key("ParentPid")
		ok.Integer(v.ParentPid)
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.Pid != 0 {
		ok := object.Key("Pid")
		ok.Integer(v.Pid)
	}

	if v.TerminatedAt != nil {
		ok := object.Key("TerminatedAt")
		ok.String(*v.TerminatedAt)
	}

	return nil
}

func awsRestjson1_serializeDocumentRange(v *types.Range, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.End != 0 {
		ok := object.Key("End")
		ok.Long(v.End)
	}

	if v.Start != 0 {
		ok := object.Key("Start")
		ok.Long(v.Start)
	}

	if v.StartColumn != 0 {
		ok := object.Key("StartColumn")
		ok.Long(v.StartColumn)
	}

	return nil
}

func awsRestjson1_serializeDocumentRanges(v []types.Range, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRecommendation(v *types.Recommendation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Text != nil {
		ok := object.Key("Text")
		ok.String(*v.Text)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentRecord(v *types.Record, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JsonPath != nil {
		ok := object.Key("JsonPath")
		ok.String(*v.JsonPath)
	}

	if v.RecordIndex != 0 {
		ok := object.Key("RecordIndex")
		ok.Long(v.RecordIndex)
	}

	return nil
}

func awsRestjson1_serializeDocumentRecords(v []types.Record, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRecord(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRelatedFinding(v *types.RelatedFinding, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.ProductArn != nil {
		ok := object.Key("ProductArn")
		ok.String(*v.ProductArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentRelatedFindingList(v []types.RelatedFinding, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRelatedFinding(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRelatedRequirementsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRemediation(v *types.Remediation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Recommendation != nil {
		ok := object.Key("Recommendation")
		if err := awsRestjson1_serializeDocumentRecommendation(v.Recommendation, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResource(v *types.Resource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataClassification != nil {
		ok := object.Key("DataClassification")
		if err := awsRestjson1_serializeDocumentDataClassificationDetails(v.DataClassification, ok); err != nil {
			return err
		}
	}

	if v.Details != nil {
		ok := object.Key("Details")
		if err := awsRestjson1_serializeDocumentResourceDetails(v.Details, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if len(v.Partition) > 0 {
		ok := object.Key("Partition")
		ok.String(string(v.Partition))
	}

	if v.Region != nil {
		ok := object.Key("Region")
		ok.String(*v.Region)
	}

	if v.ResourceRole != nil {
		ok := object.Key("ResourceRole")
		ok.String(*v.ResourceRole)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentFieldMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceDetails(v *types.ResourceDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsApiGatewayRestApi != nil {
		ok := object.Key("AwsApiGatewayRestApi")
		if err := awsRestjson1_serializeDocumentAwsApiGatewayRestApiDetails(v.AwsApiGatewayRestApi, ok); err != nil {
			return err
		}
	}

	if v.AwsApiGatewayStage != nil {
		ok := object.Key("AwsApiGatewayStage")
		if err := awsRestjson1_serializeDocumentAwsApiGatewayStageDetails(v.AwsApiGatewayStage, ok); err != nil {
			return err
		}
	}

	if v.AwsApiGatewayV2Api != nil {
		ok := object.Key("AwsApiGatewayV2Api")
		if err := awsRestjson1_serializeDocumentAwsApiGatewayV2ApiDetails(v.AwsApiGatewayV2Api, ok); err != nil {
			return err
		}
	}

	if v.AwsApiGatewayV2Stage != nil {
		ok := object.Key("AwsApiGatewayV2Stage")
		if err := awsRestjson1_serializeDocumentAwsApiGatewayV2StageDetails(v.AwsApiGatewayV2Stage, ok); err != nil {
			return err
		}
	}

	if v.AwsAutoScalingAutoScalingGroup != nil {
		ok := object.Key("AwsAutoScalingAutoScalingGroup")
		if err := awsRestjson1_serializeDocumentAwsAutoScalingAutoScalingGroupDetails(v.AwsAutoScalingAutoScalingGroup, ok); err != nil {
			return err
		}
	}

	if v.AwsAutoScalingLaunchConfiguration != nil {
		ok := object.Key("AwsAutoScalingLaunchConfiguration")
		if err := awsRestjson1_serializeDocumentAwsAutoScalingLaunchConfigurationDetails(v.AwsAutoScalingLaunchConfiguration, ok); err != nil {
			return err
		}
	}

	if v.AwsCertificateManagerCertificate != nil {
		ok := object.Key("AwsCertificateManagerCertificate")
		if err := awsRestjson1_serializeDocumentAwsCertificateManagerCertificateDetails(v.AwsCertificateManagerCertificate, ok); err != nil {
			return err
		}
	}

	if v.AwsCloudFrontDistribution != nil {
		ok := object.Key("AwsCloudFrontDistribution")
		if err := awsRestjson1_serializeDocumentAwsCloudFrontDistributionDetails(v.AwsCloudFrontDistribution, ok); err != nil {
			return err
		}
	}

	if v.AwsCloudTrailTrail != nil {
		ok := object.Key("AwsCloudTrailTrail")
		if err := awsRestjson1_serializeDocumentAwsCloudTrailTrailDetails(v.AwsCloudTrailTrail, ok); err != nil {
			return err
		}
	}

	if v.AwsCodeBuildProject != nil {
		ok := object.Key("AwsCodeBuildProject")
		if err := awsRestjson1_serializeDocumentAwsCodeBuildProjectDetails(v.AwsCodeBuildProject, ok); err != nil {
			return err
		}
	}

	if v.AwsDynamoDbTable != nil {
		ok := object.Key("AwsDynamoDbTable")
		if err := awsRestjson1_serializeDocumentAwsDynamoDbTableDetails(v.AwsDynamoDbTable, ok); err != nil {
			return err
		}
	}

	if v.AwsEc2Eip != nil {
		ok := object.Key("AwsEc2Eip")
		if err := awsRestjson1_serializeDocumentAwsEc2EipDetails(v.AwsEc2Eip, ok); err != nil {
			return err
		}
	}

	if v.AwsEc2Instance != nil {
		ok := object.Key("AwsEc2Instance")
		if err := awsRestjson1_serializeDocumentAwsEc2InstanceDetails(v.AwsEc2Instance, ok); err != nil {
			return err
		}
	}

	if v.AwsEc2NetworkAcl != nil {
		ok := object.Key("AwsEc2NetworkAcl")
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkAclDetails(v.AwsEc2NetworkAcl, ok); err != nil {
			return err
		}
	}

	if v.AwsEc2NetworkInterface != nil {
		ok := object.Key("AwsEc2NetworkInterface")
		if err := awsRestjson1_serializeDocumentAwsEc2NetworkInterfaceDetails(v.AwsEc2NetworkInterface, ok); err != nil {
			return err
		}
	}

	if v.AwsEc2SecurityGroup != nil {
		ok := object.Key("AwsEc2SecurityGroup")
		if err := awsRestjson1_serializeDocumentAwsEc2SecurityGroupDetails(v.AwsEc2SecurityGroup, ok); err != nil {
			return err
		}
	}

	if v.AwsEc2Subnet != nil {
		ok := object.Key("AwsEc2Subnet")
		if err := awsRestjson1_serializeDocumentAwsEc2SubnetDetails(v.AwsEc2Subnet, ok); err != nil {
			return err
		}
	}

	if v.AwsEc2Volume != nil {
		ok := object.Key("AwsEc2Volume")
		if err := awsRestjson1_serializeDocumentAwsEc2VolumeDetails(v.AwsEc2Volume, ok); err != nil {
			return err
		}
	}

	if v.AwsEc2Vpc != nil {
		ok := object.Key("AwsEc2Vpc")
		if err := awsRestjson1_serializeDocumentAwsEc2VpcDetails(v.AwsEc2Vpc, ok); err != nil {
			return err
		}
	}

	if v.AwsEc2VpnConnection != nil {
		ok := object.Key("AwsEc2VpnConnection")
		if err := awsRestjson1_serializeDocumentAwsEc2VpnConnectionDetails(v.AwsEc2VpnConnection, ok); err != nil {
			return err
		}
	}

	if v.AwsEcrContainerImage != nil {
		ok := object.Key("AwsEcrContainerImage")
		if err := awsRestjson1_serializeDocumentAwsEcrContainerImageDetails(v.AwsEcrContainerImage, ok); err != nil {
			return err
		}
	}

	if v.AwsEcsCluster != nil {
		ok := object.Key("AwsEcsCluster")
		if err := awsRestjson1_serializeDocumentAwsEcsClusterDetails(v.AwsEcsCluster, ok); err != nil {
			return err
		}
	}

	if v.AwsEcsService != nil {
		ok := object.Key("AwsEcsService")
		if err := awsRestjson1_serializeDocumentAwsEcsServiceDetails(v.AwsEcsService, ok); err != nil {
			return err
		}
	}

	if v.AwsEcsTaskDefinition != nil {
		ok := object.Key("AwsEcsTaskDefinition")
		if err := awsRestjson1_serializeDocumentAwsEcsTaskDefinitionDetails(v.AwsEcsTaskDefinition, ok); err != nil {
			return err
		}
	}

	if v.AwsElasticBeanstalkEnvironment != nil {
		ok := object.Key("AwsElasticBeanstalkEnvironment")
		if err := awsRestjson1_serializeDocumentAwsElasticBeanstalkEnvironmentDetails(v.AwsElasticBeanstalkEnvironment, ok); err != nil {
			return err
		}
	}

	if v.AwsElasticsearchDomain != nil {
		ok := object.Key("AwsElasticsearchDomain")
		if err := awsRestjson1_serializeDocumentAwsElasticsearchDomainDetails(v.AwsElasticsearchDomain, ok); err != nil {
			return err
		}
	}

	if v.AwsElbLoadBalancer != nil {
		ok := object.Key("AwsElbLoadBalancer")
		if err := awsRestjson1_serializeDocumentAwsElbLoadBalancerDetails(v.AwsElbLoadBalancer, ok); err != nil {
			return err
		}
	}

	if v.AwsElbv2LoadBalancer != nil {
		ok := object.Key("AwsElbv2LoadBalancer")
		if err := awsRestjson1_serializeDocumentAwsElbv2LoadBalancerDetails(v.AwsElbv2LoadBalancer, ok); err != nil {
			return err
		}
	}

	if v.AwsIamAccessKey != nil {
		ok := object.Key("AwsIamAccessKey")
		if err := awsRestjson1_serializeDocumentAwsIamAccessKeyDetails(v.AwsIamAccessKey, ok); err != nil {
			return err
		}
	}

	if v.AwsIamGroup != nil {
		ok := object.Key("AwsIamGroup")
		if err := awsRestjson1_serializeDocumentAwsIamGroupDetails(v.AwsIamGroup, ok); err != nil {
			return err
		}
	}

	if v.AwsIamPolicy != nil {
		ok := object.Key("AwsIamPolicy")
		if err := awsRestjson1_serializeDocumentAwsIamPolicyDetails(v.AwsIamPolicy, ok); err != nil {
			return err
		}
	}

	if v.AwsIamRole != nil {
		ok := object.Key("AwsIamRole")
		if err := awsRestjson1_serializeDocumentAwsIamRoleDetails(v.AwsIamRole, ok); err != nil {
			return err
		}
	}

	if v.AwsIamUser != nil {
		ok := object.Key("AwsIamUser")
		if err := awsRestjson1_serializeDocumentAwsIamUserDetails(v.AwsIamUser, ok); err != nil {
			return err
		}
	}

	if v.AwsKmsKey != nil {
		ok := object.Key("AwsKmsKey")
		if err := awsRestjson1_serializeDocumentAwsKmsKeyDetails(v.AwsKmsKey, ok); err != nil {
			return err
		}
	}

	if v.AwsLambdaFunction != nil {
		ok := object.Key("AwsLambdaFunction")
		if err := awsRestjson1_serializeDocumentAwsLambdaFunctionDetails(v.AwsLambdaFunction, ok); err != nil {
			return err
		}
	}

	if v.AwsLambdaLayerVersion != nil {
		ok := object.Key("AwsLambdaLayerVersion")
		if err := awsRestjson1_serializeDocumentAwsLambdaLayerVersionDetails(v.AwsLambdaLayerVersion, ok); err != nil {
			return err
		}
	}

	if v.AwsRdsDbCluster != nil {
		ok := object.Key("AwsRdsDbCluster")
		if err := awsRestjson1_serializeDocumentAwsRdsDbClusterDetails(v.AwsRdsDbCluster, ok); err != nil {
			return err
		}
	}

	if v.AwsRdsDbClusterSnapshot != nil {
		ok := object.Key("AwsRdsDbClusterSnapshot")
		if err := awsRestjson1_serializeDocumentAwsRdsDbClusterSnapshotDetails(v.AwsRdsDbClusterSnapshot, ok); err != nil {
			return err
		}
	}

	if v.AwsRdsDbInstance != nil {
		ok := object.Key("AwsRdsDbInstance")
		if err := awsRestjson1_serializeDocumentAwsRdsDbInstanceDetails(v.AwsRdsDbInstance, ok); err != nil {
			return err
		}
	}

	if v.AwsRdsDbSnapshot != nil {
		ok := object.Key("AwsRdsDbSnapshot")
		if err := awsRestjson1_serializeDocumentAwsRdsDbSnapshotDetails(v.AwsRdsDbSnapshot, ok); err != nil {
			return err
		}
	}

	if v.AwsRdsEventSubscription != nil {
		ok := object.Key("AwsRdsEventSubscription")
		if err := awsRestjson1_serializeDocumentAwsRdsEventSubscriptionDetails(v.AwsRdsEventSubscription, ok); err != nil {
			return err
		}
	}

	if v.AwsRedshiftCluster != nil {
		ok := object.Key("AwsRedshiftCluster")
		if err := awsRestjson1_serializeDocumentAwsRedshiftClusterDetails(v.AwsRedshiftCluster, ok); err != nil {
			return err
		}
	}

	if v.AwsS3AccountPublicAccessBlock != nil {
		ok := object.Key("AwsS3AccountPublicAccessBlock")
		if err := awsRestjson1_serializeDocumentAwsS3AccountPublicAccessBlockDetails(v.AwsS3AccountPublicAccessBlock, ok); err != nil {
			return err
		}
	}

	if v.AwsS3Bucket != nil {
		ok := object.Key("AwsS3Bucket")
		if err := awsRestjson1_serializeDocumentAwsS3BucketDetails(v.AwsS3Bucket, ok); err != nil {
			return err
		}
	}

	if v.AwsS3Object != nil {
		ok := object.Key("AwsS3Object")
		if err := awsRestjson1_serializeDocumentAwsS3ObjectDetails(v.AwsS3Object, ok); err != nil {
			return err
		}
	}

	if v.AwsSecretsManagerSecret != nil {
		ok := object.Key("AwsSecretsManagerSecret")
		if err := awsRestjson1_serializeDocumentAwsSecretsManagerSecretDetails(v.AwsSecretsManagerSecret, ok); err != nil {
			return err
		}
	}

	if v.AwsSnsTopic != nil {
		ok := object.Key("AwsSnsTopic")
		if err := awsRestjson1_serializeDocumentAwsSnsTopicDetails(v.AwsSnsTopic, ok); err != nil {
			return err
		}
	}

	if v.AwsSqsQueue != nil {
		ok := object.Key("AwsSqsQueue")
		if err := awsRestjson1_serializeDocumentAwsSqsQueueDetails(v.AwsSqsQueue, ok); err != nil {
			return err
		}
	}

	if v.AwsSsmPatchCompliance != nil {
		ok := object.Key("AwsSsmPatchCompliance")
		if err := awsRestjson1_serializeDocumentAwsSsmPatchComplianceDetails(v.AwsSsmPatchCompliance, ok); err != nil {
			return err
		}
	}

	if v.AwsWafWebAcl != nil {
		ok := object.Key("AwsWafWebAcl")
		if err := awsRestjson1_serializeDocumentAwsWafWebAclDetails(v.AwsWafWebAcl, ok); err != nil {
			return err
		}
	}

	if v.Container != nil {
		ok := object.Key("Container")
		if err := awsRestjson1_serializeDocumentContainerDetails(v.Container, ok); err != nil {
			return err
		}
	}

	if v.Other != nil {
		ok := object.Key("Other")
		if err := awsRestjson1_serializeDocumentFieldMap(v.Other, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceList(v []types.Resource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentResource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSecurityGroups(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSensitiveDataDetections(v *types.SensitiveDataDetections, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Count != 0 {
		ok := object.Key("Count")
		ok.Long(v.Count)
	}

	if v.Occurrences != nil {
		ok := object.Key("Occurrences")
		if err := awsRestjson1_serializeDocumentOccurrences(v.Occurrences, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentSensitiveDataDetectionsList(v []types.SensitiveDataDetections, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSensitiveDataDetections(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSensitiveDataResult(v *types.SensitiveDataResult, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("Category")
		ok.String(*v.Category)
	}

	if v.Detections != nil {
		ok := object.Key("Detections")
		if err := awsRestjson1_serializeDocumentSensitiveDataDetectionsList(v.Detections, ok); err != nil {
			return err
		}
	}

	if v.TotalCount != 0 {
		ok := object.Key("TotalCount")
		ok.Long(v.TotalCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentSensitiveDataResultList(v []types.SensitiveDataResult, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSensitiveDataResult(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSeverity(v *types.Severity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Label) > 0 {
		ok := object.Key("Label")
		ok.String(string(v.Label))
	}

	if v.Normalized != 0 {
		ok := object.Key("Normalized")
		ok.Integer(v.Normalized)
	}

	if v.Original != nil {
		ok := object.Key("Original")
		ok.String(*v.Original)
	}

	if v.Product != 0 {
		ok := object.Key("Product")
		switch {
		case math.IsNaN(v.Product):
			ok.String("NaN")

		case math.IsInf(v.Product, 1):
			ok.String("Infinity")

		case math.IsInf(v.Product, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Product)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSeverityUpdate(v *types.SeverityUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Label) > 0 {
		ok := object.Key("Label")
		ok.String(string(v.Label))
	}

	if v.Normalized != 0 {
		ok := object.Key("Normalized")
		ok.Integer(v.Normalized)
	}

	if v.Product != 0 {
		ok := object.Key("Product")
		switch {
		case math.IsNaN(v.Product):
			ok.String("NaN")

		case math.IsInf(v.Product, 1):
			ok.String("Infinity")

		case math.IsInf(v.Product, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Product)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSoftwarePackage(v *types.SoftwarePackage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Architecture != nil {
		ok := object.Key("Architecture")
		ok.String(*v.Architecture)
	}

	if v.Epoch != nil {
		ok := object.Key("Epoch")
		ok.String(*v.Epoch)
	}

	if v.FilePath != nil {
		ok := object.Key("FilePath")
		ok.String(*v.FilePath)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PackageManager != nil {
		ok := object.Key("PackageManager")
		ok.String(*v.PackageManager)
	}

	if v.Release != nil {
		ok := object.Key("Release")
		ok.String(*v.Release)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentSoftwarePackageList(v []types.SoftwarePackage, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSoftwarePackage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSortCriteria(v []types.SortCriterion, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSortCriterion(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSortCriterion(v *types.SortCriterion, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Field != nil {
		ok := object.Key("Field")
		ok.String(*v.Field)
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentStandardsInputParameterMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentStandardsSubscriptionArns(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStandardsSubscriptionRequest(v *types.StandardsSubscriptionRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StandardsArn != nil {
		ok := object.Key("StandardsArn")
		ok.String(*v.StandardsArn)
	}

	if v.StandardsInput != nil {
		ok := object.Key("StandardsInput")
		if err := awsRestjson1_serializeDocumentStandardsInputParameterMap(v.StandardsInput, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStandardsSubscriptionRequests(v []types.StandardsSubscriptionRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentStandardsSubscriptionRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStatusReason(v *types.StatusReason, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.ReasonCode != nil {
		ok := object.Key("ReasonCode")
		ok.String(*v.ReasonCode)
	}

	return nil
}

func awsRestjson1_serializeDocumentStatusReasonsList(v []types.StatusReason, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentStatusReason(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStringFilter(v *types.StringFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Comparison) > 0 {
		ok := object.Key("Comparison")
		ok.String(string(v.Comparison))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentStringFilterList(v []types.StringFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentStringFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentThreatIntelIndicator(v *types.ThreatIntelIndicator, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Category) > 0 {
		ok := object.Key("Category")
		ok.String(string(v.Category))
	}

	if v.LastObservedAt != nil {
		ok := object.Key("LastObservedAt")
		ok.String(*v.LastObservedAt)
	}

	if v.Source != nil {
		ok := object.Key("Source")
		ok.String(*v.Source)
	}

	if v.SourceUrl != nil {
		ok := object.Key("SourceUrl")
		ok.String(*v.SourceUrl)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentThreatIntelIndicatorList(v []types.ThreatIntelIndicator, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentThreatIntelIndicator(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTypeList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentVulnerability(v *types.Vulnerability, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cvss != nil {
		ok := object.Key("Cvss")
		if err := awsRestjson1_serializeDocumentCvssList(v.Cvss, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.ReferenceUrls != nil {
		ok := object.Key("ReferenceUrls")
		if err := awsRestjson1_serializeDocumentStringList(v.ReferenceUrls, ok); err != nil {
			return err
		}
	}

	if v.RelatedVulnerabilities != nil {
		ok := object.Key("RelatedVulnerabilities")
		if err := awsRestjson1_serializeDocumentStringList(v.RelatedVulnerabilities, ok); err != nil {
			return err
		}
	}

	if v.Vendor != nil {
		ok := object.Key("Vendor")
		if err := awsRestjson1_serializeDocumentVulnerabilityVendor(v.Vendor, ok); err != nil {
			return err
		}
	}

	if v.VulnerablePackages != nil {
		ok := object.Key("VulnerablePackages")
		if err := awsRestjson1_serializeDocumentSoftwarePackageList(v.VulnerablePackages, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVulnerabilityList(v []types.Vulnerability, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVulnerability(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentVulnerabilityVendor(v *types.VulnerabilityVendor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	if v.VendorCreatedAt != nil {
		ok := object.Key("VendorCreatedAt")
		ok.String(*v.VendorCreatedAt)
	}

	if v.VendorSeverity != nil {
		ok := object.Key("VendorSeverity")
		ok.String(*v.VendorSeverity)
	}

	if v.VendorUpdatedAt != nil {
		ok := object.Key("VendorUpdatedAt")
		ok.String(*v.VendorUpdatedAt)
	}

	return nil
}

func awsRestjson1_serializeDocumentWafAction(v *types.WafAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentWafExcludedRule(v *types.WafExcludedRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RuleId != nil {
		ok := object.Key("RuleId")
		ok.String(*v.RuleId)
	}

	return nil
}

func awsRestjson1_serializeDocumentWafExcludedRuleList(v []types.WafExcludedRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentWafExcludedRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentWafOverrideAction(v *types.WafOverrideAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentWorkflow(v *types.Workflow, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentWorkflowUpdate(v *types.WorkflowUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}
