// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAssociateFirewallPolicy struct {
}

func (*validateOpAssociateFirewallPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateFirewallPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateFirewallPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateFirewallPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAssociateSubnets struct {
}

func (*validateOpAssociateSubnets) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateSubnets) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateSubnetsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateSubnetsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateFirewall struct {
}

func (*validateOpCreateFirewall) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateFirewall) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateFirewallInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateFirewallInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateFirewallPolicy struct {
}

func (*validateOpCreateFirewallPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateFirewallPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateFirewallPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateFirewallPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateRuleGroup struct {
}

func (*validateOpCreateRuleGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateRuleGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateRuleGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateRuleGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteResourcePolicy struct {
}

func (*validateOpDeleteResourcePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteResourcePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteResourcePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteResourcePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeResourcePolicy struct {
}

func (*validateOpDescribeResourcePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeResourcePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeResourcePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeResourcePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateSubnets struct {
}

func (*validateOpDisassociateSubnets) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateSubnets) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateSubnetsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateSubnetsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutResourcePolicy struct {
}

func (*validateOpPutResourcePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutResourcePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutResourcePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutResourcePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateFirewallDeleteProtection struct {
}

func (*validateOpUpdateFirewallDeleteProtection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateFirewallDeleteProtection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateFirewallDeleteProtectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateFirewallDeleteProtectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateFirewallPolicyChangeProtection struct {
}

func (*validateOpUpdateFirewallPolicyChangeProtection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateFirewallPolicyChangeProtection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateFirewallPolicyChangeProtectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateFirewallPolicyChangeProtectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateFirewallPolicy struct {
}

func (*validateOpUpdateFirewallPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateFirewallPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateFirewallPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateFirewallPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateLoggingConfiguration struct {
}

func (*validateOpUpdateLoggingConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateLoggingConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateLoggingConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateLoggingConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateRuleGroup struct {
}

func (*validateOpUpdateRuleGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateRuleGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateRuleGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateRuleGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateSubnetChangeProtection struct {
}

func (*validateOpUpdateSubnetChangeProtection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateSubnetChangeProtection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateSubnetChangeProtectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateSubnetChangeProtectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAssociateFirewallPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateFirewallPolicy{}, middleware.After)
}

func addOpAssociateSubnetsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateSubnets{}, middleware.After)
}

func addOpCreateFirewallValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateFirewall{}, middleware.After)
}

func addOpCreateFirewallPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateFirewallPolicy{}, middleware.After)
}

func addOpCreateRuleGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateRuleGroup{}, middleware.After)
}

func addOpDeleteResourcePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteResourcePolicy{}, middleware.After)
}

func addOpDescribeResourcePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeResourcePolicy{}, middleware.After)
}

func addOpDisassociateSubnetsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateSubnets{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpPutResourcePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutResourcePolicy{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateFirewallDeleteProtectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateFirewallDeleteProtection{}, middleware.After)
}

func addOpUpdateFirewallPolicyChangeProtectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateFirewallPolicyChangeProtection{}, middleware.After)
}

func addOpUpdateFirewallPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateFirewallPolicy{}, middleware.After)
}

func addOpUpdateLoggingConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateLoggingConfiguration{}, middleware.After)
}

func addOpUpdateRuleGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateRuleGroup{}, middleware.After)
}

func addOpUpdateSubnetChangeProtectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateSubnetChangeProtection{}, middleware.After)
}

func validateActionDefinition(v *types.ActionDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionDefinition"}
	if v.PublishMetricAction != nil {
		if err := validatePublishMetricAction(v.PublishMetricAction); err != nil {
			invalidParams.AddNested("PublishMetricAction", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAddress(v *types.Address) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Address"}
	if v.AddressDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AddressDefinition"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAddresses(v []types.Address) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Addresses"}
	for i := range v {
		if err := validateAddress(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomAction(v *types.CustomAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomAction"}
	if v.ActionName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionName"))
	}
	if v.ActionDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionDefinition"))
	} else if v.ActionDefinition != nil {
		if err := validateActionDefinition(v.ActionDefinition); err != nil {
			invalidParams.AddNested("ActionDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomActions(v []types.CustomAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomActions"}
	for i := range v {
		if err := validateCustomAction(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDimension(v *types.Dimension) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Dimension"}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDimensions(v []types.Dimension) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Dimensions"}
	for i := range v {
		if err := validateDimension(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFirewallPolicy(v *types.FirewallPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FirewallPolicy"}
	if v.StatelessRuleGroupReferences != nil {
		if err := validateStatelessRuleGroupReferences(v.StatelessRuleGroupReferences); err != nil {
			invalidParams.AddNested("StatelessRuleGroupReferences", err.(smithy.InvalidParamsError))
		}
	}
	if v.StatelessDefaultActions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StatelessDefaultActions"))
	}
	if v.StatelessFragmentDefaultActions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StatelessFragmentDefaultActions"))
	}
	if v.StatelessCustomActions != nil {
		if err := validateCustomActions(v.StatelessCustomActions); err != nil {
			invalidParams.AddNested("StatelessCustomActions", err.(smithy.InvalidParamsError))
		}
	}
	if v.StatefulRuleGroupReferences != nil {
		if err := validateStatefulRuleGroupReferences(v.StatefulRuleGroupReferences); err != nil {
			invalidParams.AddNested("StatefulRuleGroupReferences", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHeader(v *types.Header) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Header"}
	if len(v.Protocol) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Protocol"))
	}
	if v.Source == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Source"))
	}
	if v.SourcePort == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourcePort"))
	}
	if len(v.Direction) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Direction"))
	}
	if v.Destination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Destination"))
	}
	if v.DestinationPort == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationPort"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIPSet(v *types.IPSet) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IPSet"}
	if v.Definition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Definition"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIPSets(v map[string]types.IPSet) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IPSets"}
	for key := range v {
		value := v[key]
		if err := validateIPSet(&value); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLogDestinationConfig(v *types.LogDestinationConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LogDestinationConfig"}
	if len(v.LogType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("LogType"))
	}
	if len(v.LogDestinationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("LogDestinationType"))
	}
	if v.LogDestination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogDestination"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLogDestinationConfigs(v []types.LogDestinationConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LogDestinationConfigs"}
	for i := range v {
		if err := validateLogDestinationConfig(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLoggingConfiguration(v *types.LoggingConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LoggingConfiguration"}
	if v.LogDestinationConfigs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogDestinationConfigs"))
	} else if v.LogDestinationConfigs != nil {
		if err := validateLogDestinationConfigs(v.LogDestinationConfigs); err != nil {
			invalidParams.AddNested("LogDestinationConfigs", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMatchAttributes(v *types.MatchAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MatchAttributes"}
	if v.Sources != nil {
		if err := validateAddresses(v.Sources); err != nil {
			invalidParams.AddNested("Sources", err.(smithy.InvalidParamsError))
		}
	}
	if v.Destinations != nil {
		if err := validateAddresses(v.Destinations); err != nil {
			invalidParams.AddNested("Destinations", err.(smithy.InvalidParamsError))
		}
	}
	if v.SourcePorts != nil {
		if err := validatePortRanges(v.SourcePorts); err != nil {
			invalidParams.AddNested("SourcePorts", err.(smithy.InvalidParamsError))
		}
	}
	if v.DestinationPorts != nil {
		if err := validatePortRanges(v.DestinationPorts); err != nil {
			invalidParams.AddNested("DestinationPorts", err.(smithy.InvalidParamsError))
		}
	}
	if v.TCPFlags != nil {
		if err := validateTCPFlags(v.TCPFlags); err != nil {
			invalidParams.AddNested("TCPFlags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePortRange(v *types.PortRange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PortRange"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePortRanges(v []types.PortRange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PortRanges"}
	for i := range v {
		if err := validatePortRange(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePublishMetricAction(v *types.PublishMetricAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PublishMetricAction"}
	if v.Dimensions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Dimensions"))
	} else if v.Dimensions != nil {
		if err := validateDimensions(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRuleDefinition(v *types.RuleDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RuleDefinition"}
	if v.MatchAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MatchAttributes"))
	} else if v.MatchAttributes != nil {
		if err := validateMatchAttributes(v.MatchAttributes); err != nil {
			invalidParams.AddNested("MatchAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.Actions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Actions"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRuleGroup(v *types.RuleGroup) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RuleGroup"}
	if v.RuleVariables != nil {
		if err := validateRuleVariables(v.RuleVariables); err != nil {
			invalidParams.AddNested("RuleVariables", err.(smithy.InvalidParamsError))
		}
	}
	if v.RulesSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RulesSource"))
	} else if v.RulesSource != nil {
		if err := validateRulesSource(v.RulesSource); err != nil {
			invalidParams.AddNested("RulesSource", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRuleOption(v *types.RuleOption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RuleOption"}
	if v.Keyword == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Keyword"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRuleOptions(v []types.RuleOption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RuleOptions"}
	for i := range v {
		if err := validateRuleOption(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRulesSource(v *types.RulesSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RulesSource"}
	if v.RulesSourceList != nil {
		if err := validateRulesSourceList(v.RulesSourceList); err != nil {
			invalidParams.AddNested("RulesSourceList", err.(smithy.InvalidParamsError))
		}
	}
	if v.StatefulRules != nil {
		if err := validateStatefulRules(v.StatefulRules); err != nil {
			invalidParams.AddNested("StatefulRules", err.(smithy.InvalidParamsError))
		}
	}
	if v.StatelessRulesAndCustomActions != nil {
		if err := validateStatelessRulesAndCustomActions(v.StatelessRulesAndCustomActions); err != nil {
			invalidParams.AddNested("StatelessRulesAndCustomActions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRulesSourceList(v *types.RulesSourceList) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RulesSourceList"}
	if v.Targets == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Targets"))
	}
	if v.TargetTypes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetTypes"))
	}
	if len(v.GeneratedRulesType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("GeneratedRulesType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRuleVariables(v *types.RuleVariables) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RuleVariables"}
	if v.IPSets != nil {
		if err := validateIPSets(v.IPSets); err != nil {
			invalidParams.AddNested("IPSets", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatefulRule(v *types.StatefulRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatefulRule"}
	if len(v.Action) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	}
	if v.Header == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Header"))
	} else if v.Header != nil {
		if err := validateHeader(v.Header); err != nil {
			invalidParams.AddNested("Header", err.(smithy.InvalidParamsError))
		}
	}
	if v.RuleOptions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleOptions"))
	} else if v.RuleOptions != nil {
		if err := validateRuleOptions(v.RuleOptions); err != nil {
			invalidParams.AddNested("RuleOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatefulRuleGroupReference(v *types.StatefulRuleGroupReference) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatefulRuleGroupReference"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatefulRuleGroupReferences(v []types.StatefulRuleGroupReference) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatefulRuleGroupReferences"}
	for i := range v {
		if err := validateStatefulRuleGroupReference(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatefulRules(v []types.StatefulRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatefulRules"}
	for i := range v {
		if err := validateStatefulRule(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatelessRule(v *types.StatelessRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatelessRule"}
	if v.RuleDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleDefinition"))
	} else if v.RuleDefinition != nil {
		if err := validateRuleDefinition(v.RuleDefinition); err != nil {
			invalidParams.AddNested("RuleDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatelessRuleGroupReference(v *types.StatelessRuleGroupReference) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatelessRuleGroupReference"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatelessRuleGroupReferences(v []types.StatelessRuleGroupReference) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatelessRuleGroupReferences"}
	for i := range v {
		if err := validateStatelessRuleGroupReference(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatelessRules(v []types.StatelessRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatelessRules"}
	for i := range v {
		if err := validateStatelessRule(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatelessRulesAndCustomActions(v *types.StatelessRulesAndCustomActions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatelessRulesAndCustomActions"}
	if v.StatelessRules == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StatelessRules"))
	} else if v.StatelessRules != nil {
		if err := validateStatelessRules(v.StatelessRules); err != nil {
			invalidParams.AddNested("StatelessRules", err.(smithy.InvalidParamsError))
		}
	}
	if v.CustomActions != nil {
		if err := validateCustomActions(v.CustomActions); err != nil {
			invalidParams.AddNested("CustomActions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSubnetMapping(v *types.SubnetMapping) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SubnetMapping"}
	if v.SubnetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSubnetMappings(v []types.SubnetMapping) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SubnetMappings"}
	for i := range v {
		if err := validateSubnetMapping(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTCPFlagField(v *types.TCPFlagField) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TCPFlagField"}
	if v.Flags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Flags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTCPFlags(v []types.TCPFlagField) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TCPFlags"}
	for i := range v {
		if err := validateTCPFlagField(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateFirewallPolicyInput(v *AssociateFirewallPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateFirewallPolicyInput"}
	if v.FirewallPolicyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FirewallPolicyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateSubnetsInput(v *AssociateSubnetsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateSubnetsInput"}
	if v.SubnetMappings == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetMappings"))
	} else if v.SubnetMappings != nil {
		if err := validateSubnetMappings(v.SubnetMappings); err != nil {
			invalidParams.AddNested("SubnetMappings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateFirewallInput(v *CreateFirewallInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFirewallInput"}
	if v.FirewallName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FirewallName"))
	}
	if v.FirewallPolicyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FirewallPolicyArn"))
	}
	if v.VpcId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcId"))
	}
	if v.SubnetMappings == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetMappings"))
	} else if v.SubnetMappings != nil {
		if err := validateSubnetMappings(v.SubnetMappings); err != nil {
			invalidParams.AddNested("SubnetMappings", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateFirewallPolicyInput(v *CreateFirewallPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFirewallPolicyInput"}
	if v.FirewallPolicyName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FirewallPolicyName"))
	}
	if v.FirewallPolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FirewallPolicy"))
	} else if v.FirewallPolicy != nil {
		if err := validateFirewallPolicy(v.FirewallPolicy); err != nil {
			invalidParams.AddNested("FirewallPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateRuleGroupInput(v *CreateRuleGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateRuleGroupInput"}
	if v.RuleGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleGroupName"))
	}
	if v.RuleGroup != nil {
		if err := validateRuleGroup(v.RuleGroup); err != nil {
			invalidParams.AddNested("RuleGroup", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Capacity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Capacity"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteResourcePolicyInput(v *DeleteResourcePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteResourcePolicyInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeResourcePolicyInput(v *DescribeResourcePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeResourcePolicyInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateSubnetsInput(v *DisassociateSubnetsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateSubnetsInput"}
	if v.SubnetIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutResourcePolicyInput(v *PutResourcePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutResourcePolicyInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Policy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Policy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateFirewallDeleteProtectionInput(v *UpdateFirewallDeleteProtectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFirewallDeleteProtectionInput"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateFirewallPolicyChangeProtectionInput(v *UpdateFirewallPolicyChangeProtectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFirewallPolicyChangeProtectionInput"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateFirewallPolicyInput(v *UpdateFirewallPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFirewallPolicyInput"}
	if v.UpdateToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpdateToken"))
	}
	if v.FirewallPolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FirewallPolicy"))
	} else if v.FirewallPolicy != nil {
		if err := validateFirewallPolicy(v.FirewallPolicy); err != nil {
			invalidParams.AddNested("FirewallPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateLoggingConfigurationInput(v *UpdateLoggingConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateLoggingConfigurationInput"}
	if v.LoggingConfiguration != nil {
		if err := validateLoggingConfiguration(v.LoggingConfiguration); err != nil {
			invalidParams.AddNested("LoggingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateRuleGroupInput(v *UpdateRuleGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateRuleGroupInput"}
	if v.UpdateToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpdateToken"))
	}
	if v.RuleGroup != nil {
		if err := validateRuleGroup(v.RuleGroup); err != nil {
			invalidParams.AddNested("RuleGroup", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateSubnetChangeProtectionInput(v *UpdateSubnetChangeProtectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateSubnetChangeProtectionInput"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
