// Code generated by smithy-go-codegen DO NOT EDIT.

package mediapackagevod

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/mediapackagevod/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpConfigureLogs struct {
}

func (*awsRestjson1_serializeOpConfigureLogs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpConfigureLogs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConfigureLogsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/packaging_groups/{Id}/configure_logs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsConfigureLogsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentConfigureLogsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsConfigureLogsInput(v *ConfigureLogsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentConfigureLogsInput(v *ConfigureLogsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EgressAccessLogs != nil {
		ok := object.Key("egressAccessLogs")
		if err := awsRestjson1_serializeDocumentEgressAccessLogs(v.EgressAccessLogs, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateAsset struct {
}

func (*awsRestjson1_serializeOpCreateAsset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAsset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAssetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/assets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAssetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAssetInput(v *CreateAssetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAssetInput(v *CreateAssetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.PackagingGroupId != nil {
		ok := object.Key("packagingGroupId")
		ok.String(*v.PackagingGroupId)
	}

	if v.ResourceId != nil {
		ok := object.Key("resourceId")
		ok.String(*v.ResourceId)
	}

	if v.SourceArn != nil {
		ok := object.Key("sourceArn")
		ok.String(*v.SourceArn)
	}

	if v.SourceRoleArn != nil {
		ok := object.Key("sourceRoleArn")
		ok.String(*v.SourceRoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePackagingConfiguration struct {
}

func (*awsRestjson1_serializeOpCreatePackagingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePackagingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePackagingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/packaging_configurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePackagingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePackagingConfigurationInput(v *CreatePackagingConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePackagingConfigurationInput(v *CreatePackagingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CmafPackage != nil {
		ok := object.Key("cmafPackage")
		if err := awsRestjson1_serializeDocumentCmafPackage(v.CmafPackage, ok); err != nil {
			return err
		}
	}

	if v.DashPackage != nil {
		ok := object.Key("dashPackage")
		if err := awsRestjson1_serializeDocumentDashPackage(v.DashPackage, ok); err != nil {
			return err
		}
	}

	if v.HlsPackage != nil {
		ok := object.Key("hlsPackage")
		if err := awsRestjson1_serializeDocumentHlsPackage(v.HlsPackage, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.MssPackage != nil {
		ok := object.Key("mssPackage")
		if err := awsRestjson1_serializeDocumentMssPackage(v.MssPackage, ok); err != nil {
			return err
		}
	}

	if v.PackagingGroupId != nil {
		ok := object.Key("packagingGroupId")
		ok.String(*v.PackagingGroupId)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePackagingGroup struct {
}

func (*awsRestjson1_serializeOpCreatePackagingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePackagingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePackagingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/packaging_groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePackagingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePackagingGroupInput(v *CreatePackagingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePackagingGroupInput(v *CreatePackagingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Authorization != nil {
		ok := object.Key("authorization")
		if err := awsRestjson1_serializeDocumentAuthorization(v.Authorization, ok); err != nil {
			return err
		}
	}

	if v.EgressAccessLogs != nil {
		ok := object.Key("egressAccessLogs")
		if err := awsRestjson1_serializeDocumentEgressAccessLogs(v.EgressAccessLogs, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAsset struct {
}

func (*awsRestjson1_serializeOpDeleteAsset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAsset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAssetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/assets/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAssetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAssetInput(v *DeleteAssetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePackagingConfiguration struct {
}

func (*awsRestjson1_serializeOpDeletePackagingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePackagingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePackagingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/packaging_configurations/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePackagingConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePackagingConfigurationInput(v *DeletePackagingConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePackagingGroup struct {
}

func (*awsRestjson1_serializeOpDeletePackagingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePackagingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePackagingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/packaging_groups/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePackagingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePackagingGroupInput(v *DeletePackagingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAsset struct {
}

func (*awsRestjson1_serializeOpDescribeAsset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAsset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAssetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/assets/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAssetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAssetInput(v *DescribeAssetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribePackagingConfiguration struct {
}

func (*awsRestjson1_serializeOpDescribePackagingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribePackagingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePackagingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/packaging_configurations/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribePackagingConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribePackagingConfigurationInput(v *DescribePackagingConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribePackagingGroup struct {
}

func (*awsRestjson1_serializeOpDescribePackagingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribePackagingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePackagingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/packaging_groups/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribePackagingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribePackagingGroupInput(v *DescribePackagingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAssets struct {
}

func (*awsRestjson1_serializeOpListAssets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAssets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAssetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/assets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAssetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAssetsInput(v *ListAssetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.PackagingGroupId != nil {
		encoder.SetQuery("packagingGroupId").String(*v.PackagingGroupId)
	}

	return nil
}

type awsRestjson1_serializeOpListPackagingConfigurations struct {
}

func (*awsRestjson1_serializeOpListPackagingConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPackagingConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPackagingConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/packaging_configurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPackagingConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPackagingConfigurationsInput(v *ListPackagingConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.PackagingGroupId != nil {
		encoder.SetQuery("packagingGroupId").String(*v.PackagingGroupId)
	}

	return nil
}

type awsRestjson1_serializeOpListPackagingGroups struct {
}

func (*awsRestjson1_serializeOpListPackagingGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPackagingGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPackagingGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/packaging_groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPackagingGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPackagingGroupsInput(v *ListPackagingGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePackagingGroup struct {
}

func (*awsRestjson1_serializeOpUpdatePackagingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePackagingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePackagingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/packaging_groups/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePackagingGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePackagingGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePackagingGroupInput(v *UpdatePackagingGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePackagingGroupInput(v *UpdatePackagingGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Authorization != nil {
		ok := object.Key("authorization")
		if err := awsRestjson1_serializeDocumentAuthorization(v.Authorization, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocument__listOf__PeriodTriggersElement(v []types.PeriodTriggersElement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocument__listOf__string(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfDashManifest(v []types.DashManifest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDashManifest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfHlsManifest(v []types.HlsManifest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHlsManifest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfMssManifest(v []types.MssManifest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMssManifest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__mapOf__string(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentAuthorization(v *types.Authorization, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CdnIdentifierSecret != nil {
		ok := object.Key("cdnIdentifierSecret")
		ok.String(*v.CdnIdentifierSecret)
	}

	if v.SecretsRoleArn != nil {
		ok := object.Key("secretsRoleArn")
		ok.String(*v.SecretsRoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentCmafEncryption(v *types.CmafEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConstantInitializationVector != nil {
		ok := object.Key("constantInitializationVector")
		ok.String(*v.ConstantInitializationVector)
	}

	if v.SpekeKeyProvider != nil {
		ok := object.Key("spekeKeyProvider")
		if err := awsRestjson1_serializeDocumentSpekeKeyProvider(v.SpekeKeyProvider, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCmafPackage(v *types.CmafPackage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentCmafEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.HlsManifests != nil {
		ok := object.Key("hlsManifests")
		if err := awsRestjson1_serializeDocument__listOfHlsManifest(v.HlsManifests, ok); err != nil {
			return err
		}
	}

	if v.IncludeEncoderConfigurationInSegments {
		ok := object.Key("includeEncoderConfigurationInSegments")
		ok.Boolean(v.IncludeEncoderConfigurationInSegments)
	}

	if v.SegmentDurationSeconds != 0 {
		ok := object.Key("segmentDurationSeconds")
		ok.Integer(v.SegmentDurationSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentDashEncryption(v *types.DashEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SpekeKeyProvider != nil {
		ok := object.Key("spekeKeyProvider")
		if err := awsRestjson1_serializeDocumentSpekeKeyProvider(v.SpekeKeyProvider, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashManifest(v *types.DashManifest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ManifestLayout) > 0 {
		ok := object.Key("manifestLayout")
		ok.String(string(v.ManifestLayout))
	}

	if v.ManifestName != nil {
		ok := object.Key("manifestName")
		ok.String(*v.ManifestName)
	}

	if v.MinBufferTimeSeconds != 0 {
		ok := object.Key("minBufferTimeSeconds")
		ok.Integer(v.MinBufferTimeSeconds)
	}

	if len(v.Profile) > 0 {
		ok := object.Key("profile")
		ok.String(string(v.Profile))
	}

	if v.StreamSelection != nil {
		ok := object.Key("streamSelection")
		if err := awsRestjson1_serializeDocumentStreamSelection(v.StreamSelection, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashPackage(v *types.DashPackage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DashManifests != nil {
		ok := object.Key("dashManifests")
		if err := awsRestjson1_serializeDocument__listOfDashManifest(v.DashManifests, ok); err != nil {
			return err
		}
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentDashEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.IncludeEncoderConfigurationInSegments {
		ok := object.Key("includeEncoderConfigurationInSegments")
		ok.Boolean(v.IncludeEncoderConfigurationInSegments)
	}

	if v.PeriodTriggers != nil {
		ok := object.Key("periodTriggers")
		if err := awsRestjson1_serializeDocument__listOf__PeriodTriggersElement(v.PeriodTriggers, ok); err != nil {
			return err
		}
	}

	if v.SegmentDurationSeconds != 0 {
		ok := object.Key("segmentDurationSeconds")
		ok.Integer(v.SegmentDurationSeconds)
	}

	if len(v.SegmentTemplateFormat) > 0 {
		ok := object.Key("segmentTemplateFormat")
		ok.String(string(v.SegmentTemplateFormat))
	}

	return nil
}

func awsRestjson1_serializeDocumentEgressAccessLogs(v *types.EgressAccessLogs, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogGroupName != nil {
		ok := object.Key("logGroupName")
		ok.String(*v.LogGroupName)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsEncryption(v *types.HlsEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConstantInitializationVector != nil {
		ok := object.Key("constantInitializationVector")
		ok.String(*v.ConstantInitializationVector)
	}

	if len(v.EncryptionMethod) > 0 {
		ok := object.Key("encryptionMethod")
		ok.String(string(v.EncryptionMethod))
	}

	if v.SpekeKeyProvider != nil {
		ok := object.Key("spekeKeyProvider")
		if err := awsRestjson1_serializeDocumentSpekeKeyProvider(v.SpekeKeyProvider, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsManifest(v *types.HlsManifest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdMarkers) > 0 {
		ok := object.Key("adMarkers")
		ok.String(string(v.AdMarkers))
	}

	if v.IncludeIframeOnlyStream {
		ok := object.Key("includeIframeOnlyStream")
		ok.Boolean(v.IncludeIframeOnlyStream)
	}

	if v.ManifestName != nil {
		ok := object.Key("manifestName")
		ok.String(*v.ManifestName)
	}

	if v.ProgramDateTimeIntervalSeconds != 0 {
		ok := object.Key("programDateTimeIntervalSeconds")
		ok.Integer(v.ProgramDateTimeIntervalSeconds)
	}

	if v.RepeatExtXKey {
		ok := object.Key("repeatExtXKey")
		ok.Boolean(v.RepeatExtXKey)
	}

	if v.StreamSelection != nil {
		ok := object.Key("streamSelection")
		if err := awsRestjson1_serializeDocumentStreamSelection(v.StreamSelection, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsPackage(v *types.HlsPackage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentHlsEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.HlsManifests != nil {
		ok := object.Key("hlsManifests")
		if err := awsRestjson1_serializeDocument__listOfHlsManifest(v.HlsManifests, ok); err != nil {
			return err
		}
	}

	if v.SegmentDurationSeconds != 0 {
		ok := object.Key("segmentDurationSeconds")
		ok.Integer(v.SegmentDurationSeconds)
	}

	if v.UseAudioRenditionGroup {
		ok := object.Key("useAudioRenditionGroup")
		ok.Boolean(v.UseAudioRenditionGroup)
	}

	return nil
}

func awsRestjson1_serializeDocumentMssEncryption(v *types.MssEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SpekeKeyProvider != nil {
		ok := object.Key("spekeKeyProvider")
		if err := awsRestjson1_serializeDocumentSpekeKeyProvider(v.SpekeKeyProvider, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMssManifest(v *types.MssManifest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManifestName != nil {
		ok := object.Key("manifestName")
		ok.String(*v.ManifestName)
	}

	if v.StreamSelection != nil {
		ok := object.Key("streamSelection")
		if err := awsRestjson1_serializeDocumentStreamSelection(v.StreamSelection, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMssPackage(v *types.MssPackage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentMssEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.MssManifests != nil {
		ok := object.Key("mssManifests")
		if err := awsRestjson1_serializeDocument__listOfMssManifest(v.MssManifests, ok); err != nil {
			return err
		}
	}

	if v.SegmentDurationSeconds != 0 {
		ok := object.Key("segmentDurationSeconds")
		ok.Integer(v.SegmentDurationSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentSpekeKeyProvider(v *types.SpekeKeyProvider, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SystemIds != nil {
		ok := object.Key("systemIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SystemIds, ok); err != nil {
			return err
		}
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentStreamSelection(v *types.StreamSelection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxVideoBitsPerSecond != 0 {
		ok := object.Key("maxVideoBitsPerSecond")
		ok.Integer(v.MaxVideoBitsPerSecond)
	}

	if v.MinVideoBitsPerSecond != 0 {
		ok := object.Key("minVideoBitsPerSecond")
		ok.Integer(v.MinVideoBitsPerSecond)
	}

	if len(v.StreamOrder) > 0 {
		ok := object.Key("streamOrder")
		ok.String(string(v.StreamOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentTags(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}
