// Code generated by smithy-go-codegen DO NOT EDIT.

package macie2

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/macie2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sends an Amazon Macie membership invitation to one or more accounts.
func (c *Client) CreateInvitations(ctx context.Context, params *CreateInvitationsInput, optFns ...func(*Options)) (*CreateInvitationsOutput, error) {
	if params == nil {
		params = &CreateInvitationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateInvitations", params, optFns, c.addOperationCreateInvitationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateInvitationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateInvitationsInput struct {

	// An array that lists Amazon Web Services account IDs, one for each account to
	// send the invitation to.
	//
	// This member is required.
	AccountIds []string

	// Specifies whether to send an email notification to the root user of each account
	// that the invitation will be sent to. This notification is in addition to an
	// alert that the root user receives in Personal Health Dashboard. To send an email
	// notification to the root user of each account, set this value to true.
	DisableEmailNotification bool

	// A custom message to include in the invitation. Amazon Macie adds this message to
	// the standard content that it sends for an invitation.
	Message *string

	noSmithyDocumentSerde
}

type CreateInvitationsOutput struct {

	// An array of objects, one for each account whose invitation hasn't been
	// processed. Each object identifies the account and explains why the invitation
	// hasn't been processed for the account.
	UnprocessedAccounts []types.UnprocessedAccount

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateInvitationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateInvitations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateInvitations{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateInvitationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateInvitations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateInvitations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "macie2",
		OperationName: "CreateInvitations",
	}
}
