// Code generated by smithy-go-codegen DO NOT EDIT.

package macie

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/macie/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Associates specified S3 resources with Amazon Macie Classic for monitoring and
// data classification. If memberAccountId isn't specified, the action associates
// specified S3 resources with Macie Classic for the current Macie Classic
// administrator account. If memberAccountId is specified, the action associates
// specified S3 resources with Macie Classic for the specified member account.
func (c *Client) AssociateS3Resources(ctx context.Context, params *AssociateS3ResourcesInput, optFns ...func(*Options)) (*AssociateS3ResourcesOutput, error) {
	if params == nil {
		params = &AssociateS3ResourcesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssociateS3Resources", params, optFns, c.addOperationAssociateS3ResourcesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssociateS3ResourcesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssociateS3ResourcesInput struct {

	// The S3 resources that you want to associate with Amazon Macie Classic for
	// monitoring and data classification.
	//
	// This member is required.
	S3Resources []types.S3ResourceClassification

	// The ID of the Amazon Macie Classic member account whose resources you want to
	// associate with Macie Classic.
	MemberAccountId *string

	noSmithyDocumentSerde
}

type AssociateS3ResourcesOutput struct {

	// S3 resources that couldn't be associated with Amazon Macie Classic. An error
	// code and an error message are provided for each failed item.
	FailedS3Resources []types.FailedS3Resource

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssociateS3ResourcesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpAssociateS3Resources{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpAssociateS3Resources{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpAssociateS3ResourcesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssociateS3Resources(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAssociateS3Resources(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "macie",
		OperationName: "AssociateS3Resources",
	}
}
