// Code generated by smithy-go-codegen DO NOT EDIT.

package lookoutmetrics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lookoutmetrics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the datasets in the current AWS Region. Amazon Lookout for Metrics API
// actions are eventually consistent. If you do a read operation on a resource
// immediately after creating or modifying it, use retries to allow time for the
// write operation to complete.
func (c *Client) ListMetricSets(ctx context.Context, params *ListMetricSetsInput, optFns ...func(*Options)) (*ListMetricSetsOutput, error) {
	if params == nil {
		params = &ListMetricSetsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMetricSets", params, optFns, c.addOperationListMetricSetsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMetricSetsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMetricSetsInput struct {

	// The ARN of the anomaly detector containing the metrics sets to list.
	AnomalyDetectorArn *string

	// The maximum number of results to return.
	MaxResults int32

	// If the result of the previous request was truncated, the response includes a
	// NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string

	noSmithyDocumentSerde
}

type ListMetricSetsOutput struct {

	// A list of the datasets in the AWS Region, with configuration details for each.
	MetricSetSummaryList []types.MetricSetSummary

	// If the response is truncated, the list call returns this token. To retrieve the
	// next set of results, use the token in the next list request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMetricSetsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListMetricSets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListMetricSets{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMetricSets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMetricSetsAPIClient is a client that implements the ListMetricSets
// operation.
type ListMetricSetsAPIClient interface {
	ListMetricSets(context.Context, *ListMetricSetsInput, ...func(*Options)) (*ListMetricSetsOutput, error)
}

var _ ListMetricSetsAPIClient = (*Client)(nil)

// ListMetricSetsPaginatorOptions is the paginator options for ListMetricSets
type ListMetricSetsPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMetricSetsPaginator is a paginator for ListMetricSets
type ListMetricSetsPaginator struct {
	options   ListMetricSetsPaginatorOptions
	client    ListMetricSetsAPIClient
	params    *ListMetricSetsInput
	nextToken *string
	firstPage bool
}

// NewListMetricSetsPaginator returns a new ListMetricSetsPaginator
func NewListMetricSetsPaginator(client ListMetricSetsAPIClient, params *ListMetricSetsInput, optFns ...func(*ListMetricSetsPaginatorOptions)) *ListMetricSetsPaginator {
	if params == nil {
		params = &ListMetricSetsInput{}
	}

	options := ListMetricSetsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMetricSetsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMetricSetsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListMetricSets page.
func (p *ListMetricSetsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMetricSetsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.ListMetricSets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListMetricSets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "lookoutmetrics",
		OperationName: "ListMetricSets",
	}
}
