// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The criteria that determine when and how a job abort takes place.
type AbortConfig struct {

	// The list of criteria that determine when and how to abort the job.
	//
	// This member is required.
	CriteriaList []AbortCriteria

	noSmithyDocumentSerde
}

// The criteria that determine when and how a job abort takes place.
type AbortCriteria struct {

	// The type of job action to take to initiate the job abort.
	//
	// This member is required.
	Action AbortAction

	// The type of job execution failures that can initiate a job abort.
	//
	// This member is required.
	FailureType JobExecutionFailureType

	// The minimum number of things which must receive job execution notifications
	// before the job can be aborted.
	//
	// This member is required.
	MinNumberOfExecutedThings *int32

	// The minimum percentage of job execution failures that must occur to initiate the
	// job abort. Amazon Web Services IoT Core supports up to two digits after the
	// decimal (for example, 10.9 and 10.99, but not 10.999).
	//
	// This member is required.
	ThresholdPercentage *float64

	noSmithyDocumentSerde
}

// Describes the actions associated with a rule.
type Action struct {

	// Change the state of a CloudWatch alarm.
	CloudwatchAlarm *CloudwatchAlarmAction

	// Send data to CloudWatch Logs.
	CloudwatchLogs *CloudwatchLogsAction

	// Capture a CloudWatch metric.
	CloudwatchMetric *CloudwatchMetricAction

	// Write to a DynamoDB table.
	DynamoDB *DynamoDBAction

	// Write to a DynamoDB table. This is a new version of the DynamoDB action. It
	// allows you to write each attribute in an MQTT message payload into a separate
	// DynamoDB column.
	DynamoDBv2 *DynamoDBv2Action

	// Write data to an Amazon Elasticsearch Service domain. This action is deprecated.
	// Use the OpenSearch action
	// (https://docs.aws.amazon.com/iot/latest/apireference/API_OpenSearchAction.html)
	// instead.
	Elasticsearch *ElasticsearchAction

	// Write to an Amazon Kinesis Firehose stream.
	Firehose *FirehoseAction

	// Send data to an HTTPS endpoint.
	Http *HttpAction

	// Sends message data to an IoT Analytics channel.
	IotAnalytics *IotAnalyticsAction

	// Sends an input to an IoT Events detector.
	IotEvents *IotEventsAction

	// Sends data from the MQTT message that triggered the rule to IoT SiteWise asset
	// properties.
	IotSiteWise *IotSiteWiseAction

	// Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or
	// self-managed Apache Kafka cluster.
	Kafka *KafkaAction

	// Write data to an Amazon Kinesis stream.
	Kinesis *KinesisAction

	// Invoke a Lambda function.
	Lambda *LambdaAction

	// Write data to an Amazon OpenSearch Service domain.
	OpenSearch *OpenSearchAction

	// Publish to another MQTT topic.
	Republish *RepublishAction

	// Write to an Amazon S3 bucket.
	S3 *S3Action

	// Send a message to a Salesforce IoT Cloud Input Stream.
	Salesforce *SalesforceAction

	// Publish to an Amazon SNS topic.
	Sns *SnsAction

	// Publish to an Amazon SQS queue.
	Sqs *SqsAction

	// Starts execution of a Step Functions state machine.
	StepFunctions *StepFunctionsAction

	// The Timestream rule action writes attributes (measures) from an MQTT message
	// into an Amazon Timestream table. For more information, see the Timestream
	// (https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html)
	// topic rule action documentation.
	Timestream *TimestreamAction

	noSmithyDocumentSerde
}

// Information about an active Device Defender security profile behavior violation.
type ActiveViolation struct {

	// The behavior that is being violated.
	Behavior *Behavior

	// The time the most recent violation occurred.
	LastViolationTime *time.Time

	// The value of the metric (the measurement) that caused the most recent violation.
	LastViolationValue *MetricValue

	// The security profile with the behavior is in violation.
	SecurityProfileName *string

	// The name of the thing responsible for the active violation.
	ThingName *string

	// The details of a violation event.
	ViolationEventAdditionalInfo *ViolationEventAdditionalInfo

	// The ID of the active violation.
	ViolationId *string

	// The time the violation started.
	ViolationStartTime *time.Time

	noSmithyDocumentSerde
}

// Parameters used when defining a mitigation action that move a set of things to a
// thing group.
type AddThingsToThingGroupParams struct {

	// The list of groups to which you want to add the things that triggered the
	// mitigation action. You can add a thing to a maximum of 10 groups, but you can't
	// add a thing to more than one group in the same hierarchy.
	//
	// This member is required.
	ThingGroupNames []string

	// Specifies if this mitigation action can move the things that triggered the
	// mitigation action even if they are part of one or more dynamic thing groups.
	OverrideDynamicGroups bool

	noSmithyDocumentSerde
}

// The type of aggregation queries.
type AggregationType struct {

	// The name of the aggregation type.
	//
	// This member is required.
	Name AggregationTypeName

	// A list of the values of aggregation types.
	Values []string

	noSmithyDocumentSerde
}

// A structure containing the alert target ARN and the role ARN.
type AlertTarget struct {

	// The Amazon Resource Name (ARN) of the notification target to which alerts are
	// sent.
	//
	// This member is required.
	AlertTargetArn *string

	// The ARN of the role that grants permission to send alerts to the notification
	// target.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// Contains information that allowed the authorization.
type Allowed struct {

	// A list of policies that allowed the authentication.
	Policies []Policy

	noSmithyDocumentSerde
}

// An asset property timestamp entry containing the following information.
type AssetPropertyTimestamp struct {

	// A string that contains the time in seconds since epoch. Accepts substitution
	// templates.
	//
	// This member is required.
	TimeInSeconds *string

	// Optional. A string that contains the nanosecond time offset. Accepts
	// substitution templates.
	OffsetInNanos *string

	noSmithyDocumentSerde
}

// An asset property value entry containing the following information.
type AssetPropertyValue struct {

	// The asset property value timestamp.
	//
	// This member is required.
	Timestamp *AssetPropertyTimestamp

	// The value of the asset property.
	//
	// This member is required.
	Value AssetPropertyVariant

	// Optional. A string that describes the quality of the value. Accepts substitution
	// templates. Must be GOOD, BAD, or UNCERTAIN.
	Quality *string

	noSmithyDocumentSerde
}

// Contains an asset property value (of a single type).
//
// The following types satisfy this interface:
//  AssetPropertyVariantMemberStringValue
//  AssetPropertyVariantMemberIntegerValue
//  AssetPropertyVariantMemberDoubleValue
//  AssetPropertyVariantMemberBooleanValue
type AssetPropertyVariant interface {
	isAssetPropertyVariant()
}

// Optional. The string value of the value entry. Accepts substitution templates.
type AssetPropertyVariantMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*AssetPropertyVariantMemberStringValue) isAssetPropertyVariant() {}

// Optional. A string that contains the integer value of the value entry. Accepts
// substitution templates.
type AssetPropertyVariantMemberIntegerValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*AssetPropertyVariantMemberIntegerValue) isAssetPropertyVariant() {}

// Optional. A string that contains the double value of the value entry. Accepts
// substitution templates.
type AssetPropertyVariantMemberDoubleValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*AssetPropertyVariantMemberDoubleValue) isAssetPropertyVariant() {}

// Optional. A string that contains the boolean value (true or false) of the value
// entry. Accepts substitution templates.
type AssetPropertyVariantMemberBooleanValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*AssetPropertyVariantMemberBooleanValue) isAssetPropertyVariant() {}

// The attribute payload.
type AttributePayload struct {

	// A JSON string containing up to three key-value pair in JSON format. For example:
	// {\"attributes\":{\"string1\":\"string2\"}}
	Attributes map[string]string

	// Specifies whether the list of attributes provided in the AttributePayload is
	// merged with the attributes stored in the registry, instead of overwriting them.
	// To remove an attribute, call UpdateThing with an empty attribute value. The
	// merge attribute is only valid when calling UpdateThing or UpdateThingGroup.
	Merge bool

	noSmithyDocumentSerde
}

// Which audit checks are enabled and disabled for this account.
type AuditCheckConfiguration struct {

	// True if this audit check is enabled for this account.
	Enabled bool

	noSmithyDocumentSerde
}

// Information about the audit check.
type AuditCheckDetails struct {

	// True if the check is complete and found all resources compliant.
	CheckCompliant *bool

	// The completion status of this check. One of "IN_PROGRESS",
	// "WAITING_FOR_DATA_COLLECTION", "CANCELED", "COMPLETED_COMPLIANT",
	// "COMPLETED_NON_COMPLIANT", or "FAILED".
	CheckRunStatus AuditCheckRunStatus

	// The code of any error encountered when this check is performed during this
	// audit. One of "INSUFFICIENT_PERMISSIONS" or "AUDIT_CHECK_DISABLED".
	ErrorCode *string

	// The message associated with any error encountered when this check is performed
	// during this audit.
	Message *string

	// The number of resources that were found noncompliant during the check.
	NonCompliantResourcesCount *int64

	// Describes how many of the non-compliant resources created during the evaluation
	// of an audit check were marked as suppressed.
	SuppressedNonCompliantResourcesCount *int64

	// The number of resources on which the check was performed.
	TotalResourcesCount *int64

	noSmithyDocumentSerde
}

// The findings (results) of the audit.
type AuditFinding struct {

	// The audit check that generated this result.
	CheckName *string

	// A unique identifier for this set of audit findings. This identifier is used to
	// apply mitigation tasks to one or more sets of findings.
	FindingId *string

	// The time the result (finding) was discovered.
	FindingTime *time.Time

	// Indicates whether the audit finding was suppressed or not during reporting.
	IsSuppressed *bool

	// The resource that was found to be noncompliant with the audit check.
	NonCompliantResource *NonCompliantResource

	// The reason the resource was noncompliant.
	ReasonForNonCompliance *string

	// A code that indicates the reason that the resource was noncompliant.
	ReasonForNonComplianceCode *string

	// The list of related resources.
	RelatedResources []RelatedResource

	// The severity of the result (finding).
	Severity AuditFindingSeverity

	// The ID of the audit that generated this result (finding).
	TaskId *string

	// The time the audit started.
	TaskStartTime *time.Time

	noSmithyDocumentSerde
}

// Returned by ListAuditMitigationActionsTask, this object contains information
// that describes a mitigation action that has been started.
type AuditMitigationActionExecutionMetadata struct {

	// The unique identifier for the mitigation action being applied by the task.
	ActionId *string

	// The friendly name of the mitigation action being applied by the task.
	ActionName *string

	// The date and time when the task was completed or canceled. Blank if the task is
	// still running.
	EndTime *time.Time

	// If an error occurred, the code that indicates which type of error occurred.
	ErrorCode *string

	// The unique identifier for the findings to which the task and associated
	// mitigation action are applied.
	FindingId *string

	// If an error occurred, a message that describes the error.
	Message *string

	// The date and time when the task was started.
	StartTime *time.Time

	// The current status of the task being executed.
	Status AuditMitigationActionsExecutionStatus

	// The unique identifier for the task that applies the mitigation action.
	TaskId *string

	noSmithyDocumentSerde
}

// Information about an audit mitigation actions task that is returned by
// ListAuditMitigationActionsTasks.
type AuditMitigationActionsTaskMetadata struct {

	// The time at which the audit mitigation actions task was started.
	StartTime *time.Time

	// The unique identifier for the task.
	TaskId *string

	// The current state of the audit mitigation actions task.
	TaskStatus AuditMitigationActionsTaskStatus

	noSmithyDocumentSerde
}

// Used in MitigationActionParams, this information identifies the target findings
// to which the mitigation actions are applied. Only one entry appears.
type AuditMitigationActionsTaskTarget struct {

	// Specifies a filter in the form of an audit check and set of reason codes that
	// identify the findings from the audit to which the audit mitigation actions task
	// apply.
	AuditCheckToReasonCodeFilter map[string][]string

	// If the task will apply a mitigation action to findings from a specific audit,
	// this value uniquely identifies the audit.
	AuditTaskId *string

	// If the task will apply a mitigation action to one or more listed findings, this
	// value uniquely identifies those findings.
	FindingIds []string

	noSmithyDocumentSerde
}

// Information about the targets to which audit notifications are sent.
type AuditNotificationTarget struct {

	// True if notifications to the target are enabled.
	Enabled bool

	// The ARN of the role that grants permission to send notifications to the target.
	RoleArn *string

	// The ARN of the target (SNS topic) to which audit notifications are sent.
	TargetArn *string

	noSmithyDocumentSerde
}

// Filters out specific findings of a Device Defender audit.
type AuditSuppression struct {

	// An audit check name. Checks must be enabled for your account. (Use
	// DescribeAccountAuditConfiguration to see the list of all checks, including those
	// that are enabled or use UpdateAccountAuditConfiguration to select which checks
	// are enabled.)
	//
	// This member is required.
	CheckName *string

	// Information that identifies the noncompliant resource.
	//
	// This member is required.
	ResourceIdentifier *ResourceIdentifier

	// The description of the audit suppression.
	Description *string

	// The expiration date (epoch timestamp in seconds) that you want the suppression
	// to adhere to.
	ExpirationDate *time.Time

	// Indicates whether a suppression should exist indefinitely or not.
	SuppressIndefinitely *bool

	noSmithyDocumentSerde
}

// The audits that were performed.
type AuditTaskMetadata struct {

	// The ID of this audit.
	TaskId *string

	// The status of this audit. One of "IN_PROGRESS", "COMPLETED", "FAILED", or
	// "CANCELED".
	TaskStatus AuditTaskStatus

	// The type of this audit. One of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
	TaskType AuditTaskType

	noSmithyDocumentSerde
}

// A collection of authorization information.
type AuthInfo struct {

	// The resources for which the principal is being authorized to perform the
	// specified action.
	//
	// This member is required.
	Resources []string

	// The type of action for which the principal is being authorized.
	ActionType ActionType

	noSmithyDocumentSerde
}

// An object that specifies the authorization service for a domain.
type AuthorizerConfig struct {

	// A Boolean that specifies whether the domain configuration's authorization
	// service can be overridden.
	AllowAuthorizerOverride bool

	// The name of the authorization service for a domain configuration.
	DefaultAuthorizerName *string

	noSmithyDocumentSerde
}

// The authorizer description.
type AuthorizerDescription struct {

	// The authorizer ARN.
	AuthorizerArn *string

	// The authorizer's Lambda function ARN.
	AuthorizerFunctionArn *string

	// The authorizer name.
	AuthorizerName *string

	// The UNIX timestamp of when the authorizer was created.
	CreationDate *time.Time

	// The UNIX timestamp of when the authorizer was last updated.
	LastModifiedDate *time.Time

	// Specifies whether IoT validates the token signature in an authorization request.
	SigningDisabled *bool

	// The status of the authorizer.
	Status AuthorizerStatus

	// The key used to extract the token from the HTTP headers.
	TokenKeyName *string

	// The public keys used to validate the token signature returned by your custom
	// authentication service.
	TokenSigningPublicKeys map[string]string

	noSmithyDocumentSerde
}

// The authorizer summary.
type AuthorizerSummary struct {

	// The authorizer ARN.
	AuthorizerArn *string

	// The authorizer name.
	AuthorizerName *string

	noSmithyDocumentSerde
}

// The authorizer result.
type AuthResult struct {

	// The policies and statements that allowed the specified action.
	Allowed *Allowed

	// The final authorization decision of this scenario. Multiple statements are taken
	// into account when determining the authorization decision. An explicit deny
	// statement can override multiple allow statements.
	AuthDecision AuthDecision

	// Authorization information.
	AuthInfo *AuthInfo

	// The policies and statements that denied the specified action.
	Denied *Denied

	// Contains any missing context values found while evaluating policy.
	MissingContextValues []string

	noSmithyDocumentSerde
}

// The criteria that determine when and how a job abort takes place.
type AwsJobAbortConfig struct {

	// The list of criteria that determine when and how to abort the job.
	//
	// This member is required.
	AbortCriteriaList []AwsJobAbortCriteria

	noSmithyDocumentSerde
}

// The criteria that determine when and how a job abort takes place.
type AwsJobAbortCriteria struct {

	// The type of job action to take to initiate the job abort.
	//
	// This member is required.
	Action AwsJobAbortCriteriaAbortAction

	// The type of job execution failures that can initiate a job abort.
	//
	// This member is required.
	FailureType AwsJobAbortCriteriaFailureType

	// The minimum number of things which must receive job execution notifications
	// before the job can be aborted.
	//
	// This member is required.
	MinNumberOfExecutedThings *int32

	// The minimum percentage of job execution failures that must occur to initiate the
	// job abort. Amazon Web Services IoT Core supports up to two digits after the
	// decimal (for example, 10.9 and 10.99, but not 10.999).
	//
	// This member is required.
	ThresholdPercentage *float64

	noSmithyDocumentSerde
}

// Configuration for the rollout of OTA updates.
type AwsJobExecutionsRolloutConfig struct {

	// The rate of increase for a job rollout. This parameter allows you to define an
	// exponential rate increase for a job rollout.
	ExponentialRate *AwsJobExponentialRolloutRate

	// The maximum number of OTA update job executions started per minute.
	MaximumPerMinute *int32

	noSmithyDocumentSerde
}

// The rate of increase for a job rollout. This parameter allows you to define an
// exponential rate increase for a job rollout.
type AwsJobExponentialRolloutRate struct {

	// The minimum number of things that will be notified of a pending job, per minute,
	// at the start of the job rollout. This is the initial rate of the rollout.
	//
	// This member is required.
	BaseRatePerMinute *int32

	// The rate of increase for a job rollout. The number of things notified is
	// multiplied by this factor.
	//
	// This member is required.
	IncrementFactor float64

	// The criteria to initiate the increase in rate of rollout for a job. Amazon Web
	// Services IoT Core supports up to one digit after the decimal (for example, 1.5,
	// but not 1.55).
	//
	// This member is required.
	RateIncreaseCriteria *AwsJobRateIncreaseCriteria

	noSmithyDocumentSerde
}

// Configuration information for pre-signed URLs. Valid when protocols contains
// HTTP.
type AwsJobPresignedUrlConfig struct {

	// How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the
	// default value is 1800 seconds. Pre-signed URLs are generated when a request for
	// the job document is received.
	ExpiresInSec *int64

	noSmithyDocumentSerde
}

// The criteria to initiate the increase in rate of rollout for a job.
type AwsJobRateIncreaseCriteria struct {

	// When this number of things have been notified, it will initiate an increase in
	// the rollout rate.
	NumberOfNotifiedThings *int32

	// When this number of things have succeeded in their job execution, it will
	// initiate an increase in the rollout rate.
	NumberOfSucceededThings *int32

	noSmithyDocumentSerde
}

// Specifies the amount of time each device has to finish its execution of the job.
// A timer is started when the job execution status is set to IN_PROGRESS. If the
// job execution status is not set to another terminal state before the timer
// expires, it will be automatically set to TIMED_OUT.
type AwsJobTimeoutConfig struct {

	// Specifies the amount of time, in minutes, this device has to finish execution of
	// this job. The timeout interval can be anywhere between 1 minute and 7 days (1 to
	// 10080 minutes). The in progress timer can't be updated and will apply to all job
	// executions for the job. Whenever a job execution remains in the IN_PROGRESS
	// status for longer than this interval, the job execution will fail and switch to
	// the terminal TIMED_OUT status.
	InProgressTimeoutInMinutes *int64

	noSmithyDocumentSerde
}

// A Device Defender security profile behavior.
type Behavior struct {

	// The name you've given to the behavior.
	//
	// This member is required.
	Name *string

	// The criteria that determine if a device is behaving normally in regard to the
	// metric.
	Criteria *BehaviorCriteria

	// What is measured by the behavior.
	Metric *string

	// The dimension for a metric in your behavior. For example, using a TOPIC_FILTER
	// dimension, you can narrow down the scope of the metric to only MQTT topics where
	// the name matches the pattern specified in the dimension. This can't be used with
	// custom metrics.
	MetricDimension *MetricDimension

	// Suppresses alerts.
	SuppressAlerts *bool

	noSmithyDocumentSerde
}

// The criteria by which the behavior is determined to be normal.
type BehaviorCriteria struct {

	// The operator that relates the thing measured (metric) to the criteria
	// (containing a value or statisticalThreshold). Valid operators include:
	//
	// *
	// string-list: in-set and not-in-set
	//
	// * number-list: in-set and not-in-set
	//
	// *
	// ip-address-list: in-cidr-set and not-in-cidr-set
	//
	// * number: less-than,
	// less-than-equals, greater-than, and greater-than-equals
	ComparisonOperator ComparisonOperator

	// If a device is in violation of the behavior for the specified number of
	// consecutive datapoints, an alarm occurs. If not specified, the default is 1.
	ConsecutiveDatapointsToAlarm *int32

	// If an alarm has occurred and the offending device is no longer in violation of
	// the behavior for the specified number of consecutive datapoints, the alarm is
	// cleared. If not specified, the default is 1.
	ConsecutiveDatapointsToClear *int32

	// Use this to specify the time duration over which the behavior is evaluated, for
	// those criteria that have a time dimension (for example, NUM_MESSAGES_SENT). For
	// a statisticalThreshhold metric comparison, measurements from all devices are
	// accumulated over this time duration before being used to calculate percentiles,
	// and later, measurements from an individual device are also accumulated over this
	// time duration before being given a percentile rank. Cannot be used with
	// list-based metric datatypes.
	DurationSeconds *int32

	// The configuration of an ML Detect
	MlDetectionConfig *MachineLearningDetectionConfig

	// A statistical ranking (percentile)that indicates a threshold value by which a
	// behavior is determined to be in compliance or in violation of the behavior.
	StatisticalThreshold *StatisticalThreshold

	// The value to be compared with the metric.
	Value *MetricValue

	noSmithyDocumentSerde
}

// The summary of an ML Detect behavior model.
type BehaviorModelTrainingSummary struct {

	// The name of the behavior.
	BehaviorName *string

	// The percentage of datapoints collected.
	DatapointsCollectionPercentage *float64

	// The date the model was last refreshed.
	LastModelRefreshDate *time.Time

	// The status of the behavior model.
	ModelStatus ModelStatus

	// The name of the security profile.
	SecurityProfileName *string

	// The date a training model started collecting data.
	TrainingDataCollectionStartDate *time.Time

	noSmithyDocumentSerde
}

// Additional information about the billing group.
type BillingGroupMetadata struct {

	// The date the billing group was created.
	CreationDate *time.Time

	noSmithyDocumentSerde
}

// The properties of a billing group.
type BillingGroupProperties struct {

	// The description of the billing group.
	BillingGroupDescription *string

	noSmithyDocumentSerde
}

// A count of documents that meets a specific aggregation criteria.
type Bucket struct {

	// The number of documents that have the value counted for the particular bucket.
	Count int32

	// The value counted for the particular bucket.
	KeyValue *string

	noSmithyDocumentSerde
}

// The type of bucketed aggregation performed.
type BucketsAggregationType struct {

	// Performs an aggregation that will return a list of buckets. The list of buckets
	// is a ranked list of the number of occurrences of an aggregation field value.
	TermsAggregation *TermsAggregation

	noSmithyDocumentSerde
}

// A CA certificate.
type CACertificate struct {

	// The ARN of the CA certificate.
	CertificateArn *string

	// The ID of the CA certificate.
	CertificateId *string

	// The date the CA certificate was created.
	CreationDate *time.Time

	// The status of the CA certificate. The status value REGISTER_INACTIVE is
	// deprecated and should not be used.
	Status CACertificateStatus

	noSmithyDocumentSerde
}

// Describes a CA certificate.
type CACertificateDescription struct {

	// Whether the CA certificate configured for auto registration of device
	// certificates. Valid values are "ENABLE" and "DISABLE"
	AutoRegistrationStatus AutoRegistrationStatus

	// The CA certificate ARN.
	CertificateArn *string

	// The CA certificate ID.
	CertificateId *string

	// The CA certificate data, in PEM format.
	CertificatePem *string

	// The date the CA certificate was created.
	CreationDate *time.Time

	// The customer version of the CA certificate.
	CustomerVersion *int32

	// The generation ID of the CA certificate.
	GenerationId *string

	// The date the CA certificate was last modified.
	LastModifiedDate *time.Time

	// The owner of the CA certificate.
	OwnedBy *string

	// The status of a CA certificate.
	Status CACertificateStatus

	// When the CA certificate is valid.
	Validity *CertificateValidity

	noSmithyDocumentSerde
}

// Information about a certificate.
type Certificate struct {

	// The ARN of the certificate.
	CertificateArn *string

	// The ID of the certificate. (The last part of the certificate ARN contains the
	// certificate ID.)
	CertificateId *string

	// The mode of the certificate.
	CertificateMode CertificateMode

	// The date and time the certificate was created.
	CreationDate *time.Time

	// The status of the certificate. The status value REGISTER_INACTIVE is deprecated
	// and should not be used.
	Status CertificateStatus

	noSmithyDocumentSerde
}

// Describes a certificate.
type CertificateDescription struct {

	// The certificate ID of the CA certificate used to sign this certificate.
	CaCertificateId *string

	// The ARN of the certificate.
	CertificateArn *string

	// The ID of the certificate.
	CertificateId *string

	// The mode of the certificate.
	CertificateMode CertificateMode

	// The certificate data, in PEM format.
	CertificatePem *string

	// The date and time the certificate was created.
	CreationDate *time.Time

	// The customer version of the certificate.
	CustomerVersion *int32

	// The generation ID of the certificate.
	GenerationId *string

	// The date and time the certificate was last modified.
	LastModifiedDate *time.Time

	// The ID of the Amazon Web Services account that owns the certificate.
	OwnedBy *string

	// The ID of the Amazon Web Services account of the previous owner of the
	// certificate.
	PreviousOwnedBy *string

	// The status of the certificate.
	Status CertificateStatus

	// The transfer data.
	TransferData *TransferData

	// When the certificate is valid.
	Validity *CertificateValidity

	noSmithyDocumentSerde
}

// When the certificate is valid.
type CertificateValidity struct {

	// The certificate is not valid after this date.
	NotAfter *time.Time

	// The certificate is not valid before this date.
	NotBefore *time.Time

	noSmithyDocumentSerde
}

// Describes an action that updates a CloudWatch alarm.
type CloudwatchAlarmAction struct {

	// The CloudWatch alarm name.
	//
	// This member is required.
	AlarmName *string

	// The IAM role that allows access to the CloudWatch alarm.
	//
	// This member is required.
	RoleArn *string

	// The reason for the alarm change.
	//
	// This member is required.
	StateReason *string

	// The value of the alarm state. Acceptable values are: OK, ALARM,
	// INSUFFICIENT_DATA.
	//
	// This member is required.
	StateValue *string

	noSmithyDocumentSerde
}

// Describes an action that sends data to CloudWatch Logs.
type CloudwatchLogsAction struct {

	// The CloudWatch log group to which the action sends data.
	//
	// This member is required.
	LogGroupName *string

	// The IAM role that allows access to the CloudWatch log.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// Describes an action that captures a CloudWatch metric.
type CloudwatchMetricAction struct {

	// The CloudWatch metric name.
	//
	// This member is required.
	MetricName *string

	// The CloudWatch metric namespace name.
	//
	// This member is required.
	MetricNamespace *string

	// The metric unit
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit)
	// supported by CloudWatch.
	//
	// This member is required.
	MetricUnit *string

	// The CloudWatch metric value.
	//
	// This member is required.
	MetricValue *string

	// The IAM role that allows access to the CloudWatch metric.
	//
	// This member is required.
	RoleArn *string

	// An optional Unix timestamp
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp).
	MetricTimestamp *string

	noSmithyDocumentSerde
}

// Describes the method to use when code signing a file.
type CodeSigning struct {

	// The ID of the AWSSignerJob which was created to sign the file.
	AwsSignerJobId *string

	// A custom method for code signing a file.
	CustomCodeSigning *CustomCodeSigning

	// Describes the code-signing job.
	StartSigningJobParameter *StartSigningJobParameter

	noSmithyDocumentSerde
}

// Describes the certificate chain being used when code signing a file.
type CodeSigningCertificateChain struct {

	// The name of the certificate.
	CertificateName *string

	// A base64 encoded binary representation of the code signing certificate chain.
	InlineDocument *string

	noSmithyDocumentSerde
}

// Describes the signature for a file.
type CodeSigningSignature struct {

	// A base64 encoded binary representation of the code signing signature.
	InlineDocument []byte

	noSmithyDocumentSerde
}

// Configuration.
type Configuration struct {

	// True to enable the configuration.
	Enabled bool

	noSmithyDocumentSerde
}

// Describes a custom method used to code sign a file.
type CustomCodeSigning struct {

	// The certificate chain.
	CertificateChain *CodeSigningCertificateChain

	// The hash algorithm used to code sign the file.
	HashAlgorithm *string

	// The signature for the file.
	Signature *CodeSigningSignature

	// The signature algorithm used to code sign the file.
	SignatureAlgorithm *string

	noSmithyDocumentSerde
}

// Contains information that denied the authorization.
type Denied struct {

	// Information that explicitly denies the authorization.
	ExplicitDeny *ExplicitDeny

	// Information that implicitly denies the authorization. When a policy doesn't
	// explicitly deny or allow an action on a resource it is considered an implicit
	// deny.
	ImplicitDeny *ImplicitDeny

	noSmithyDocumentSerde
}

// Describes the location of the updated firmware.
type Destination struct {

	// Describes the location in S3 of the updated firmware.
	S3Destination *S3Destination

	noSmithyDocumentSerde
}

// Describes which mitigation actions should be executed.
type DetectMitigationActionExecution struct {

	// The friendly name that uniquely identifies the mitigation action.
	ActionName *string

	// The error code of a mitigation action.
	ErrorCode *string

	// The date a mitigation action ended.
	ExecutionEndDate *time.Time

	// The date a mitigation action was started.
	ExecutionStartDate *time.Time

	// The message of a mitigation action.
	Message *string

	// The status of a mitigation action.
	Status DetectMitigationActionExecutionStatus

	// The unique identifier of the task.
	TaskId *string

	// The name of the thing.
	ThingName *string

	// The unique identifier of the violation.
	ViolationId *string

	noSmithyDocumentSerde
}

// The statistics of a mitigation action task.
type DetectMitigationActionsTaskStatistics struct {

	// The actions that were performed.
	ActionsExecuted *int64

	// The actions that failed.
	ActionsFailed *int64

	// The actions that were skipped.
	ActionsSkipped *int64

	noSmithyDocumentSerde
}

// The summary of the mitigation action tasks.
type DetectMitigationActionsTaskSummary struct {

	// The definition of the actions.
	ActionsDefinition []MitigationAction

	// Includes only active violations.
	OnlyActiveViolationsIncluded bool

	// Includes suppressed alerts.
	SuppressedAlertsIncluded bool

	// Specifies the ML Detect findings to which the mitigation actions are applied.
	Target *DetectMitigationActionsTaskTarget

	// The date the task ended.
	TaskEndTime *time.Time

	// The unique identifier of the task.
	TaskId *string

	// The date the task started.
	TaskStartTime *time.Time

	// The statistics of a mitigation action task.
	TaskStatistics *DetectMitigationActionsTaskStatistics

	// The status of the task.
	TaskStatus DetectMitigationActionsTaskStatus

	// Specifies the time period of which violation events occurred between.
	ViolationEventOccurrenceRange *ViolationEventOccurrenceRange

	noSmithyDocumentSerde
}

// The target of a mitigation action task.
type DetectMitigationActionsTaskTarget struct {

	// The name of the behavior.
	BehaviorName *string

	// The name of the security profile.
	SecurityProfileName *string

	// The unique identifiers of the violations.
	ViolationIds []string

	noSmithyDocumentSerde
}

// The summary of a domain configuration. A domain configuration specifies custom
// IoT-specific information about a domain. A domain configuration can be
// associated with an Amazon Web Services-managed domain (for example,
// dbc123defghijk.iot.us-west-2.amazonaws.com), a customer managed domain, or a
// default endpoint.
//
// * Data
//
// * Jobs
//
// * CredentialProvider
type DomainConfigurationSummary struct {

	// The ARN of the domain configuration.
	DomainConfigurationArn *string

	// The name of the domain configuration. This value must be unique to a region.
	DomainConfigurationName *string

	// The type of service delivered by the endpoint.
	ServiceType ServiceType

	noSmithyDocumentSerde
}

// Describes an action to write to a DynamoDB table. The tableName, hashKeyField,
// and rangeKeyField values must match the values used when you created the table.
// The hashKeyValue and rangeKeyvalue fields use a substitution template syntax.
// These templates provide data at runtime. The syntax is as follows:
// ${sql-expression}. You can specify any valid expression in a WHERE or SELECT
// clause, including JSON properties, comparisons, calculations, and functions. For
// example, the following field uses the third level of the topic: "hashKeyValue":
// "${topic(3)}" The following field uses the timestamp: "rangeKeyValue":
// "${timestamp()}"
type DynamoDBAction struct {

	// The hash key name.
	//
	// This member is required.
	HashKeyField *string

	// The hash key value.
	//
	// This member is required.
	HashKeyValue *string

	// The ARN of the IAM role that grants access to the DynamoDB table.
	//
	// This member is required.
	RoleArn *string

	// The name of the DynamoDB table.
	//
	// This member is required.
	TableName *string

	// The hash key type. Valid values are "STRING" or "NUMBER"
	HashKeyType DynamoKeyType

	// The type of operation to be performed. This follows the substitution template,
	// so it can be ${operation}, but the substitution must result in one of the
	// following: INSERT, UPDATE, or DELETE.
	Operation *string

	// The action payload. This name can be customized.
	PayloadField *string

	// The range key name.
	RangeKeyField *string

	// The range key type. Valid values are "STRING" or "NUMBER"
	RangeKeyType DynamoKeyType

	// The range key value.
	RangeKeyValue *string

	noSmithyDocumentSerde
}

// Describes an action to write to a DynamoDB table. This DynamoDB action writes
// each attribute in the message payload into it's own column in the DynamoDB
// table.
type DynamoDBv2Action struct {

	// Specifies the DynamoDB table to which the message data will be written. For
	// example: { "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": {
	// "tableName": "my-table" } } } Each attribute in the message payload will be
	// written to a separate column in the DynamoDB database.
	//
	// This member is required.
	PutItem *PutItemInput

	// The ARN of the IAM role that grants access to the DynamoDB table.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// The policy that has the effect on the authorization results.
type EffectivePolicy struct {

	// The policy ARN.
	PolicyArn *string

	// The IAM policy document.
	PolicyDocument *string

	// The policy name.
	PolicyName *string

	noSmithyDocumentSerde
}

// Describes an action that writes data to an Amazon Elasticsearch Service domain.
// This action is deprecated. Use the OpenSearch action
// (https://docs.aws.amazon.com/iot/latest/apireference/API_OpenSearchAction.html)
// instead.
type ElasticsearchAction struct {

	// The endpoint of your Elasticsearch domain.
	//
	// This member is required.
	Endpoint *string

	// The unique identifier for the document you are storing.
	//
	// This member is required.
	Id *string

	// The Elasticsearch index where you want to store your data.
	//
	// This member is required.
	Index *string

	// The IAM role ARN that has access to Elasticsearch.
	//
	// This member is required.
	RoleArn *string

	// The type of document you are storing.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// Parameters used when defining a mitigation action that enable Amazon Web
// Services IoT Core logging.
type EnableIoTLoggingParams struct {

	// Specifies the type of information to be logged.
	//
	// This member is required.
	LogLevel LogLevel

	// The Amazon Resource Name (ARN) of the IAM role used for logging.
	//
	// This member is required.
	RoleArnForLogging *string

	noSmithyDocumentSerde
}

// Error information.
type ErrorInfo struct {

	// The error code.
	Code *string

	// The error message.
	Message *string

	noSmithyDocumentSerde
}

// Information that explicitly denies authorization.
type ExplicitDeny struct {

	// The policies that denied the authorization.
	Policies []Policy

	noSmithyDocumentSerde
}

// Allows you to create an exponential rate of rollout for a job.
type ExponentialRolloutRate struct {

	// The minimum number of things that will be notified of a pending job, per minute
	// at the start of job rollout. This parameter allows you to define the initial
	// rate of rollout.
	//
	// This member is required.
	BaseRatePerMinute *int32

	// The exponential factor to increase the rate of rollout for a job. Amazon Web
	// Services IoT Core supports up to one digit after the decimal (for example, 1.5,
	// but not 1.55).
	//
	// This member is required.
	IncrementFactor float64

	// The criteria to initiate the increase in rate of rollout for a job.
	//
	// This member is required.
	RateIncreaseCriteria *RateIncreaseCriteria

	noSmithyDocumentSerde
}

// Describes the name and data type at a field.
type Field struct {

	// The name of the field.
	Name *string

	// The data type of the field.
	Type FieldType

	noSmithyDocumentSerde
}

// The location of the OTA update.
type FileLocation struct {

	// The location of the updated firmware in S3.
	S3Location *S3Location

	// The stream that contains the OTA update.
	Stream *Stream

	noSmithyDocumentSerde
}

// Describes an action that writes data to an Amazon Kinesis Firehose stream.
type FirehoseAction struct {

	// The delivery stream name.
	//
	// This member is required.
	DeliveryStreamName *string

	// The IAM role that grants access to the Amazon Kinesis Firehose stream.
	//
	// This member is required.
	RoleArn *string

	// Whether to deliver the Kinesis Data Firehose stream as a batch by using
	// PutRecordBatch
	// (https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html).
	// The default value is false. When batchMode is true and the rule's SQL statement
	// evaluates to an Array, each Array element forms one record in the PutRecordBatch
	// (https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html)
	// request. The resulting array can't have more than 500 records.
	BatchMode *bool

	// A character separator that will be used to separate records written to the
	// Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows
	// newline), ',' (comma).
	Separator *string

	noSmithyDocumentSerde
}

// The name and ARN of a fleet metric.
type FleetMetricNameAndArn struct {

	// The fleet metric ARN.
	MetricArn *string

	// The fleet metric name.
	MetricName *string

	noSmithyDocumentSerde
}

// The name and ARN of a group.
type GroupNameAndArn struct {

	// The group ARN.
	GroupArn *string

	// The group name.
	GroupName *string

	noSmithyDocumentSerde
}

// Send data to an HTTPS endpoint.
type HttpAction struct {

	// The endpoint URL. If substitution templates are used in the URL, you must also
	// specify a confirmationUrl. If this is a new destination, a new
	// TopicRuleDestination is created if possible.
	//
	// This member is required.
	Url *string

	// The authentication method to use when sending data to an HTTPS endpoint.
	Auth *HttpAuthorization

	// The URL to which IoT sends a confirmation message. The value of the confirmation
	// URL must be a prefix of the endpoint URL. If you do not specify a confirmation
	// URL IoT uses the endpoint URL as the confirmation URL. If you use substitution
	// templates in the confirmationUrl, you must create and enable topic rule
	// destinations that match each possible value of the substitution template before
	// traffic is allowed to your endpoint URL.
	ConfirmationUrl *string

	// The HTTP headers to send with the message data.
	Headers []HttpActionHeader

	noSmithyDocumentSerde
}

// The HTTP action header.
type HttpActionHeader struct {

	// The HTTP header key.
	//
	// This member is required.
	Key *string

	// The HTTP header value. Substitution templates are supported.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The authorization method used to send messages.
type HttpAuthorization struct {

	// Use Sig V4 authorization. For more information, see Signature Version 4 Signing
	// Process
	// (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	Sigv4 *SigV4Authorization

	noSmithyDocumentSerde
}

// Specifies the HTTP context to use for the test authorizer request.
type HttpContext struct {

	// The header keys and values in an HTTP authorization request.
	Headers map[string]string

	// The query string keys and values in an HTTP authorization request.
	QueryString *string

	noSmithyDocumentSerde
}

// HTTP URL destination configuration used by the topic rule's HTTP action.
type HttpUrlDestinationConfiguration struct {

	// The URL IoT uses to confirm ownership of or access to the topic rule destination
	// URL.
	//
	// This member is required.
	ConfirmationUrl *string

	noSmithyDocumentSerde
}

// HTTP URL destination properties.
type HttpUrlDestinationProperties struct {

	// The URL used to confirm the HTTP topic rule destination URL.
	ConfirmationUrl *string

	noSmithyDocumentSerde
}

// Information about an HTTP URL destination.
type HttpUrlDestinationSummary struct {

	// The URL used to confirm ownership of or access to the HTTP topic rule
	// destination URL.
	ConfirmationUrl *string

	noSmithyDocumentSerde
}

// Information that implicitly denies authorization. When policy doesn't explicitly
// deny or allow an action on a resource it is considered an implicit deny.
type ImplicitDeny struct {

	// Policies that don't contain a matching allow or deny statement for the specified
	// action on the specified resource.
	Policies []Policy

	noSmithyDocumentSerde
}

// Sends message data to an IoT Analytics channel.
type IotAnalyticsAction struct {

	// Whether to process the action as a batch. The default value is false. When
	// batchMode is true and the rule SQL statement evaluates to an Array, each Array
	// element is delivered as a separate message when passed by BatchPutMessage
	// (https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html)
	// to the IoT Analytics channel. The resulting array can't have more than 100
	// messages.
	BatchMode *bool

	// (deprecated) The ARN of the IoT Analytics channel to which message data will be
	// sent.
	ChannelArn *string

	// The name of the IoT Analytics channel to which message data will be sent.
	ChannelName *string

	// The ARN of the role which has a policy that grants IoT Analytics permission to
	// send message data via IoT Analytics (iotanalytics:BatchPutMessage).
	RoleArn *string

	noSmithyDocumentSerde
}

// Sends an input to an IoT Events detector.
type IotEventsAction struct {

	// The name of the IoT Events input.
	//
	// This member is required.
	InputName *string

	// The ARN of the role that grants IoT permission to send an input to an IoT Events
	// detector. ("Action":"iotevents:BatchPutMessage").
	//
	// This member is required.
	RoleArn *string

	// Whether to process the event actions as a batch. The default value is false.
	// When batchMode is true, you can't specify a messageId. When batchMode is true
	// and the rule SQL statement evaluates to an Array, each Array element is treated
	// as a separate message when it's sent to IoT Events by calling BatchPutMessage
	// (https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html).
	// The resulting array can't have more than 10 messages.
	BatchMode *bool

	// The ID of the message. The default messageId is a new UUID value. When batchMode
	// is true, you can't specify a messageId--a new UUID value will be assigned.
	// Assign a value to this property to ensure that only one input (message) with a
	// given messageId will be processed by an IoT Events detector.
	MessageId *string

	noSmithyDocumentSerde
}

// Describes an action to send data from an MQTT message that triggered the rule to
// IoT SiteWise asset properties.
type IotSiteWiseAction struct {

	// A list of asset property value entries.
	//
	// This member is required.
	PutAssetPropertyValueEntries []PutAssetPropertyValueEntry

	// The ARN of the role that grants IoT permission to send an asset property value
	// to IoT SiteWise. ("Action": "iotsitewise:BatchPutAssetPropertyValue"). The trust
	// policy can restrict access to specific asset hierarchy paths.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// The Job object contains details about a job.
type Job struct {

	// Configuration for criteria to abort the job.
	AbortConfig *AbortConfig

	// If the job was updated, describes the reason for the update.
	Comment *string

	// The time, in seconds since the epoch, when the job was completed.
	CompletedAt *time.Time

	// The time, in seconds since the epoch, when the job was created.
	CreatedAt *time.Time

	// A short text description of the job.
	Description *string

	// Will be true if the job was canceled with the optional force parameter set to
	// true.
	ForceCanceled *bool

	// An ARN identifying the job with format "arn:aws:iot:region:account:job/jobId".
	JobArn *string

	// Allows you to create a staged rollout of a job.
	JobExecutionsRolloutConfig *JobExecutionsRolloutConfig

	// The unique identifier you assigned to this job when it was created.
	JobId *string

	// Details about the job process.
	JobProcessDetails *JobProcessDetails

	// The ARN of the job template used to create the job.
	JobTemplateArn *string

	// The time, in seconds since the epoch, when the job was last updated.
	LastUpdatedAt *time.Time

	// The namespace used to indicate that a job is a customer-managed job. When you
	// specify a value for this parameter, Amazon Web Services IoT Core sends jobs
	// notifications to MQTT topics that contain the value in the following format.
	// $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/ The
	// namespaceId feature is in public preview.
	NamespaceId *string

	// Configuration for pre-signed S3 URLs.
	PresignedUrlConfig *PresignedUrlConfig

	// If the job was updated, provides the reason code for the update.
	ReasonCode *string

	// The status of the job, one of IN_PROGRESS, CANCELED, DELETION_IN_PROGRESS or
	// COMPLETED.
	Status JobStatus

	// Specifies whether the job will continue to run (CONTINUOUS), or will be complete
	// after all those things specified as targets have completed the job (SNAPSHOT).
	// If continuous, the job may also be run on a thing when a change is detected in a
	// target. For example, a job will run on a device when the thing representing the
	// device is added to a target group, even after the job was completed by all
	// things originally in the group.
	TargetSelection TargetSelection

	// A list of IoT things and thing groups to which the job should be sent.
	Targets []string

	// Specifies the amount of time each device has to finish its execution of the job.
	// A timer is started when the job execution status is set to IN_PROGRESS. If the
	// job execution status is not set to another terminal state before the timer
	// expires, it will be automatically set to TIMED_OUT.
	TimeoutConfig *TimeoutConfig

	noSmithyDocumentSerde
}

// The job execution object represents the execution of a job on a particular
// device.
type JobExecution struct {

	// The estimated number of seconds that remain before the job execution status will
	// be changed to TIMED_OUT. The timeout interval can be anywhere between 1 minute
	// and 7 days (1 to 10080 minutes). The actual job execution timeout can occur up
	// to 60 seconds later than the estimated duration. This value will not be included
	// if the job execution has reached a terminal status.
	ApproximateSecondsBeforeTimedOut *int64

	// A string (consisting of the digits "0" through "9") which identifies this
	// particular job execution on this particular device. It can be used in commands
	// which return or update job execution information.
	ExecutionNumber *int64

	// Will be true if the job execution was canceled with the optional force parameter
	// set to true.
	ForceCanceled *bool

	// The unique identifier you assigned to the job when it was created.
	JobId *string

	// The time, in seconds since the epoch, when the job execution was last updated.
	LastUpdatedAt *time.Time

	// The time, in seconds since the epoch, when the job execution was queued.
	QueuedAt *time.Time

	// The time, in seconds since the epoch, when the job execution started.
	StartedAt *time.Time

	// The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED,
	// TIMED_OUT, CANCELED, or REJECTED).
	Status JobExecutionStatus

	// A collection of name/value pairs that describe the status of the job execution.
	StatusDetails *JobExecutionStatusDetails

	// The ARN of the thing on which the job execution is running.
	ThingArn *string

	// The version of the job execution. Job execution versions are incremented each
	// time they are updated by a device.
	VersionNumber int64

	noSmithyDocumentSerde
}

// Allows you to create a staged rollout of a job.
type JobExecutionsRolloutConfig struct {

	// The rate of increase for a job rollout. This parameter allows you to define an
	// exponential rate for a job rollout.
	ExponentialRate *ExponentialRolloutRate

	// The maximum number of things that will be notified of a pending job, per minute.
	// This parameter allows you to create a staged rollout.
	MaximumPerMinute *int32

	noSmithyDocumentSerde
}

// Details of the job execution status.
type JobExecutionStatusDetails struct {

	// The job execution status.
	DetailsMap map[string]string

	noSmithyDocumentSerde
}

// The job execution summary.
type JobExecutionSummary struct {

	// A string (consisting of the digits "0" through "9") which identifies this
	// particular job execution on this particular device. It can be used later in
	// commands which return or update job execution information.
	ExecutionNumber *int64

	// The time, in seconds since the epoch, when the job execution was last updated.
	LastUpdatedAt *time.Time

	// The time, in seconds since the epoch, when the job execution was queued.
	QueuedAt *time.Time

	// The time, in seconds since the epoch, when the job execution started.
	StartedAt *time.Time

	// The status of the job execution.
	Status JobExecutionStatus

	noSmithyDocumentSerde
}

// Contains a summary of information about job executions for a specific job.
type JobExecutionSummaryForJob struct {

	// Contains a subset of information about a job execution.
	JobExecutionSummary *JobExecutionSummary

	// The ARN of the thing on which the job execution is running.
	ThingArn *string

	noSmithyDocumentSerde
}

// The job execution summary for a thing.
type JobExecutionSummaryForThing struct {

	// Contains a subset of information about a job execution.
	JobExecutionSummary *JobExecutionSummary

	// The unique identifier you assigned to this job when it was created.
	JobId *string

	noSmithyDocumentSerde
}

// The job process details.
type JobProcessDetails struct {

	// The number of things that cancelled the job.
	NumberOfCanceledThings *int32

	// The number of things that failed executing the job.
	NumberOfFailedThings *int32

	// The number of things currently executing the job.
	NumberOfInProgressThings *int32

	// The number of things that are awaiting execution of the job.
	NumberOfQueuedThings *int32

	// The number of things that rejected the job.
	NumberOfRejectedThings *int32

	// The number of things that are no longer scheduled to execute the job because
	// they have been deleted or have been removed from the group that was a target of
	// the job.
	NumberOfRemovedThings *int32

	// The number of things which successfully completed the job.
	NumberOfSucceededThings *int32

	// The number of things whose job execution status is TIMED_OUT.
	NumberOfTimedOutThings *int32

	// The target devices to which the job execution is being rolled out. This value
	// will be null after the job execution has finished rolling out to all the target
	// devices.
	ProcessingTargets []string

	noSmithyDocumentSerde
}

// The job summary.
type JobSummary struct {

	// The time, in seconds since the epoch, when the job completed.
	CompletedAt *time.Time

	// The time, in seconds since the epoch, when the job was created.
	CreatedAt *time.Time

	// The job ARN.
	JobArn *string

	// The unique identifier you assigned to this job when it was created.
	JobId *string

	// The time, in seconds since the epoch, when the job was last updated.
	LastUpdatedAt *time.Time

	// The job summary status.
	Status JobStatus

	// Specifies whether the job will continue to run (CONTINUOUS), or will be complete
	// after all those things specified as targets have completed the job (SNAPSHOT).
	// If continuous, the job may also be run on a thing when a change is detected in a
	// target. For example, a job will run on a thing when the thing is added to a
	// target group, even after the job was completed by all things originally in the
	// group.
	TargetSelection TargetSelection

	// The ID of the thing group.
	ThingGroupId *string

	noSmithyDocumentSerde
}

// An object that contains information about the job template.
type JobTemplateSummary struct {

	// The time, in seconds since the epoch, when the job template was created.
	CreatedAt *time.Time

	// A description of the job template.
	Description *string

	// The ARN of the job template.
	JobTemplateArn *string

	// The unique identifier of the job template.
	JobTemplateId *string

	noSmithyDocumentSerde
}

// Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or
// self-managed Apache Kafka cluster.
type KafkaAction struct {

	// Properties of the Apache Kafka producer client.
	//
	// This member is required.
	ClientProperties map[string]string

	// The ARN of Kafka action's VPC TopicRuleDestination.
	//
	// This member is required.
	DestinationArn *string

	// The Kafka topic for messages to be sent to the Kafka broker.
	//
	// This member is required.
	Topic *string

	// The Kafka message key.
	Key *string

	// The Kafka message partition.
	Partition *string

	noSmithyDocumentSerde
}

// Describes a key pair.
type KeyPair struct {

	// The private key.
	PrivateKey *string

	// The public key.
	PublicKey *string

	noSmithyDocumentSerde
}

// Describes an action to write data to an Amazon Kinesis stream.
type KinesisAction struct {

	// The ARN of the IAM role that grants access to the Amazon Kinesis stream.
	//
	// This member is required.
	RoleArn *string

	// The name of the Amazon Kinesis stream.
	//
	// This member is required.
	StreamName *string

	// The partition key.
	PartitionKey *string

	noSmithyDocumentSerde
}

// Describes an action to invoke a Lambda function.
type LambdaAction struct {

	// The ARN of the Lambda function.
	//
	// This member is required.
	FunctionArn *string

	noSmithyDocumentSerde
}

// Describes the logging options payload.
type LoggingOptionsPayload struct {

	// The ARN of the IAM role that grants access.
	//
	// This member is required.
	RoleArn *string

	// The log level.
	LogLevel LogLevel

	noSmithyDocumentSerde
}

// A log target.
type LogTarget struct {

	// The target type.
	//
	// This member is required.
	TargetType LogTargetType

	// The target name.
	TargetName *string

	noSmithyDocumentSerde
}

// The target configuration.
type LogTargetConfiguration struct {

	// The logging level.
	LogLevel LogLevel

	// A log target
	LogTarget *LogTarget

	noSmithyDocumentSerde
}

// The configuration of an ML Detect Security Profile.
type MachineLearningDetectionConfig struct {

	// The sensitivity of anomalous behavior evaluation. Can be Low, Medium, or High.
	//
	// This member is required.
	ConfidenceLevel ConfidenceLevel

	noSmithyDocumentSerde
}

// The dimension of a metric.
type MetricDimension struct {

	// A unique identifier for the dimension.
	//
	// This member is required.
	DimensionName *string

	// Defines how the dimensionValues of a dimension are interpreted. For example, for
	// dimension type TOPIC_FILTER, the IN operator, a message will be counted only if
	// its topic matches one of the topic filters. With NOT_IN operator, a message will
	// be counted only if it doesn't match any of the topic filters. The operator is
	// optional: if it's not provided (is null), it will be interpreted as IN.
	Operator DimensionValueOperator

	noSmithyDocumentSerde
}

// The metric you want to retain. Dimensions are optional.
type MetricToRetain struct {

	// What is measured by the behavior.
	//
	// This member is required.
	Metric *string

	// The dimension of a metric. This can't be used with custom metrics.
	MetricDimension *MetricDimension

	noSmithyDocumentSerde
}

// The value to be compared with the metric.
type MetricValue struct {

	// If the comparisonOperator calls for a set of CIDRs, use this to specify that set
	// to be compared with the metric.
	Cidrs []string

	// If the comparisonOperator calls for a numeric value, use this to specify that
	// numeric value to be compared with the metric.
	Count *int64

	// The numeral value of a metric.
	Number *float64

	// The numeral values of a metric.
	Numbers []float64

	// If the comparisonOperator calls for a set of ports, use this to specify that set
	// to be compared with the metric.
	Ports []int32

	// The string values of a metric.
	Strings []string

	noSmithyDocumentSerde
}

// Describes which changes should be applied as part of a mitigation action.
type MitigationAction struct {

	// The set of parameters for this mitigation action. The parameters vary, depending
	// on the kind of action you apply.
	ActionParams *MitigationActionParams

	// A unique identifier for the mitigation action.
	Id *string

	// A user-friendly name for the mitigation action.
	Name *string

	// The IAM role ARN used to apply this mitigation action.
	RoleArn *string

	noSmithyDocumentSerde
}

// Information that identifies a mitigation action. This information is returned by
// ListMitigationActions.
type MitigationActionIdentifier struct {

	// The IAM role ARN used to apply this mitigation action.
	ActionArn *string

	// The friendly name of the mitigation action.
	ActionName *string

	// The date when this mitigation action was created.
	CreationDate *time.Time

	noSmithyDocumentSerde
}

// The set of parameters for this mitigation action. You can specify only one type
// of parameter (in other words, you can apply only one action for each defined
// mitigation action).
type MitigationActionParams struct {

	// Parameters to define a mitigation action that moves devices associated with a
	// certificate to one or more specified thing groups, typically for quarantine.
	AddThingsToThingGroupParams *AddThingsToThingGroupParams

	// Parameters to define a mitigation action that enables Amazon Web Services IoT
	// Core logging at a specified level of detail.
	EnableIoTLoggingParams *EnableIoTLoggingParams

	// Parameters to define a mitigation action that publishes findings to Amazon
	// Simple Notification Service (Amazon SNS. You can implement your own custom
	// actions in response to the Amazon SNS messages.
	PublishFindingToSnsParams *PublishFindingToSnsParams

	// Parameters to define a mitigation action that adds a blank policy to restrict
	// permissions.
	ReplaceDefaultPolicyVersionParams *ReplaceDefaultPolicyVersionParams

	// Parameters to define a mitigation action that changes the state of the CA
	// certificate to inactive.
	UpdateCACertificateParams *UpdateCACertificateParams

	// Parameters to define a mitigation action that changes the state of the device
	// certificate to inactive.
	UpdateDeviceCertificateParams *UpdateDeviceCertificateParams

	noSmithyDocumentSerde
}

// Specifies the MQTT context to use for the test authorizer request
type MqttContext struct {

	// The value of the clientId key in an MQTT authorization request.
	ClientId *string

	// The value of the password key in an MQTT authorization request.
	Password []byte

	// The value of the username key in an MQTT authorization request.
	Username *string

	noSmithyDocumentSerde
}

// Information about the resource that was noncompliant with the audit check.
type NonCompliantResource struct {

	// Other information about the noncompliant resource.
	AdditionalInfo map[string]string

	// Information that identifies the noncompliant resource.
	ResourceIdentifier *ResourceIdentifier

	// The type of the noncompliant resource.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Describes an action that writes data to an Amazon OpenSearch Service domain.
type OpenSearchAction struct {

	// The endpoint of your OpenSearch domain.
	//
	// This member is required.
	Endpoint *string

	// The unique identifier for the document you are storing.
	//
	// This member is required.
	Id *string

	// The OpenSearch index where you want to store your data.
	//
	// This member is required.
	Index *string

	// The IAM role ARN that has access to OpenSearch.
	//
	// This member is required.
	RoleArn *string

	// The type of document you are storing.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// Describes a file to be associated with an OTA update.
type OTAUpdateFile struct {

	// A list of name/attribute pairs.
	Attributes map[string]string

	// The code signing method of the file.
	CodeSigning *CodeSigning

	// The location of the updated firmware.
	FileLocation *FileLocation

	// The name of the file.
	FileName *string

	// An integer value you can include in the job document to allow your devices to
	// identify the type of file received from the cloud.
	FileType *int32

	// The file version.
	FileVersion *string

	noSmithyDocumentSerde
}

// Information about an OTA update.
type OTAUpdateInfo struct {

	// A collection of name/value pairs
	AdditionalParameters map[string]string

	// The IoT job ARN associated with the OTA update.
	AwsIotJobArn *string

	// The IoT job ID associated with the OTA update.
	AwsIotJobId *string

	// Configuration for the rollout of OTA updates.
	AwsJobExecutionsRolloutConfig *AwsJobExecutionsRolloutConfig

	// Configuration information for pre-signed URLs. Valid when protocols contains
	// HTTP.
	AwsJobPresignedUrlConfig *AwsJobPresignedUrlConfig

	// The date when the OTA update was created.
	CreationDate *time.Time

	// A description of the OTA update.
	Description *string

	// Error information associated with the OTA update.
	ErrorInfo *ErrorInfo

	// The date when the OTA update was last updated.
	LastModifiedDate *time.Time

	// The OTA update ARN.
	OtaUpdateArn *string

	// A list of files associated with the OTA update.
	OtaUpdateFiles []OTAUpdateFile

	// The OTA update ID.
	OtaUpdateId *string

	// The status of the OTA update.
	OtaUpdateStatus OTAUpdateStatus

	// The protocol used to transfer the OTA update image. Valid values are [HTTP],
	// [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device
	// can choose the protocol.
	Protocols []Protocol

	// Specifies whether the OTA update will continue to run (CONTINUOUS), or will be
	// complete after all those things specified as targets have completed the OTA
	// update (SNAPSHOT). If continuous, the OTA update may also be run on a thing when
	// a change is detected in a target. For example, an OTA update will run on a thing
	// when the thing is added to a target group, even after the OTA update was
	// completed by all things originally in the group.
	TargetSelection TargetSelection

	// The targets of the OTA update.
	Targets []string

	noSmithyDocumentSerde
}

// An OTA update summary.
type OTAUpdateSummary struct {

	// The date when the OTA update was created.
	CreationDate *time.Time

	// The OTA update ARN.
	OtaUpdateArn *string

	// The OTA update ID.
	OtaUpdateId *string

	noSmithyDocumentSerde
}

// A certificate that has been transferred but not yet accepted.
type OutgoingCertificate struct {

	// The certificate ARN.
	CertificateArn *string

	// The certificate ID.
	CertificateId *string

	// The certificate creation date.
	CreationDate *time.Time

	// The date the transfer was initiated.
	TransferDate *time.Time

	// The transfer message.
	TransferMessage *string

	// The Amazon Web Services account to which the transfer was made.
	TransferredTo *string

	noSmithyDocumentSerde
}

// Describes the percentile and percentile value.
type PercentPair struct {

	// The percentile.
	Percent float64

	// The value of the percentile.
	Value float64

	noSmithyDocumentSerde
}

// Describes an IoT policy.
type Policy struct {

	// The policy ARN.
	PolicyArn *string

	// The policy name.
	PolicyName *string

	noSmithyDocumentSerde
}

// Describes a policy version.
type PolicyVersion struct {

	// The date and time the policy was created.
	CreateDate *time.Time

	// Specifies whether the policy version is the default.
	IsDefaultVersion bool

	// The policy version ID.
	VersionId *string

	noSmithyDocumentSerde
}

// Information about the version of the policy associated with the resource.
type PolicyVersionIdentifier struct {

	// The name of the policy.
	PolicyName *string

	// The ID of the version of the policy associated with the resource.
	PolicyVersionId *string

	noSmithyDocumentSerde
}

// Configuration for pre-signed S3 URLs.
type PresignedUrlConfig struct {

	// How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the
	// default value is 3600 seconds. Pre-signed URLs are generated when Jobs receives
	// an MQTT request for the job document.
	ExpiresInSec *int64

	// The ARN of an IAM role that grants grants permission to download files from the
	// S3 bucket where the job data/updates are stored. The role must also grant
	// permission for IoT to download the files.
	RoleArn *string

	noSmithyDocumentSerde
}

// Structure that contains payloadVersion and targetArn.
type ProvisioningHook struct {

	// The ARN of the target function. Note: Only Lambda functions are currently
	// supported.
	//
	// This member is required.
	TargetArn *string

	// The payload that was sent to the target function. Note: Only Lambda functions
	// are currently supported.
	PayloadVersion *string

	noSmithyDocumentSerde
}

// A summary of information about a fleet provisioning template.
type ProvisioningTemplateSummary struct {

	// The date when the fleet provisioning template summary was created.
	CreationDate *time.Time

	// The description of the fleet provisioning template.
	Description *string

	// True if the fleet provision template is enabled, otherwise false.
	Enabled bool

	// The date when the fleet provisioning template summary was last modified.
	LastModifiedDate *time.Time

	// The ARN of the fleet provisioning template.
	TemplateArn *string

	// The name of the fleet provisioning template.
	TemplateName *string

	noSmithyDocumentSerde
}

// A summary of information about a fleet provision template version.
type ProvisioningTemplateVersionSummary struct {

	// The date when the fleet provisioning template version was created
	CreationDate *time.Time

	// True if the fleet provisioning template version is the default version,
	// otherwise false.
	IsDefaultVersion bool

	// The ID of the fleet privisioning template version.
	VersionId *int32

	noSmithyDocumentSerde
}

// Parameters to define a mitigation action that publishes findings to Amazon SNS.
// You can implement your own custom actions in response to the Amazon SNS
// messages.
type PublishFindingToSnsParams struct {

	// The ARN of the topic to which you want to publish the findings.
	//
	// This member is required.
	TopicArn *string

	noSmithyDocumentSerde
}

// An asset property value entry containing the following information.
type PutAssetPropertyValueEntry struct {

	// A list of property values to insert that each contain timestamp, quality, and
	// value (TQV) information.
	//
	// This member is required.
	PropertyValues []AssetPropertyValue

	// The ID of the IoT SiteWise asset. You must specify either a propertyAlias or
	// both an aliasId and a propertyId. Accepts substitution templates.
	AssetId *string

	// Optional. A unique identifier for this entry that you can define to better track
	// which message caused an error in case of failure. Accepts substitution
	// templates. Defaults to a new UUID.
	EntryId *string

	// The name of the property alias associated with your asset property. You must
	// specify either a propertyAlias or both an aliasId and a propertyId. Accepts
	// substitution templates.
	PropertyAlias *string

	// The ID of the asset's property. You must specify either a propertyAlias or both
	// an aliasId and a propertyId. Accepts substitution templates.
	PropertyId *string

	noSmithyDocumentSerde
}

// The input for the DynamoActionVS action that specifies the DynamoDB table to
// which the message data will be written.
type PutItemInput struct {

	// The table where the message data will be written.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// Allows you to define a criteria to initiate the increase in rate of rollout for
// a job.
type RateIncreaseCriteria struct {

	// The threshold for number of notified things that will initiate the increase in
	// rate of rollout.
	NumberOfNotifiedThings *int32

	// The threshold for number of succeeded things that will initiate the increase in
	// rate of rollout.
	NumberOfSucceededThings *int32

	noSmithyDocumentSerde
}

// The registration configuration.
type RegistrationConfig struct {

	// The ARN of the role.
	RoleArn *string

	// The template body.
	TemplateBody *string

	noSmithyDocumentSerde
}

// Information about a related resource.
type RelatedResource struct {

	// Other information about the resource.
	AdditionalInfo map[string]string

	// Information that identifies the resource.
	ResourceIdentifier *ResourceIdentifier

	// The type of resource.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Parameters to define a mitigation action that adds a blank policy to restrict
// permissions.
type ReplaceDefaultPolicyVersionParams struct {

	// The name of the template to be applied. The only supported value is
	// BLANK_POLICY.
	//
	// This member is required.
	TemplateName PolicyTemplateName

	noSmithyDocumentSerde
}

// Describes an action to republish to another topic.
type RepublishAction struct {

	// The ARN of the IAM role that grants access.
	//
	// This member is required.
	RoleArn *string

	// The name of the MQTT topic.
	//
	// This member is required.
	Topic *string

	// The Quality of Service (QoS) level to use when republishing messages. The
	// default value is 0.
	Qos *int32

	noSmithyDocumentSerde
}

// Information that identifies the noncompliant resource.
type ResourceIdentifier struct {

	// The account with which the resource is associated.
	Account *string

	// The ID of the CA certificate used to authorize the certificate.
	CaCertificateId *string

	// The client ID.
	ClientId *string

	// The ID of the Amazon Cognito identity pool.
	CognitoIdentityPoolId *string

	// The ID of the certificate attached to the resource.
	DeviceCertificateId *string

	// The ARN of the IAM role that has overly permissive actions.
	IamRoleArn *string

	// The version of the policy associated with the resource.
	PolicyVersionIdentifier *PolicyVersionIdentifier

	// The ARN of the role alias that has overly permissive actions.
	RoleAliasArn *string

	noSmithyDocumentSerde
}

// Role alias description.
type RoleAliasDescription struct {

	// The UNIX timestamp of when the role alias was created.
	CreationDate *time.Time

	// The number of seconds for which the credential is valid.
	CredentialDurationSeconds *int32

	// The UNIX timestamp of when the role alias was last modified.
	LastModifiedDate *time.Time

	// The role alias owner.
	Owner *string

	// The role alias.
	RoleAlias *string

	// The ARN of the role alias.
	RoleAliasArn *string

	// The role ARN.
	RoleArn *string

	noSmithyDocumentSerde
}

// Describes an action to write data to an Amazon S3 bucket.
type S3Action struct {

	// The Amazon S3 bucket.
	//
	// This member is required.
	BucketName *string

	// The object key. For more information, see Actions, resources, and condition keys
	// for Amazon S3
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html).
	//
	// This member is required.
	Key *string

	// The ARN of the IAM role that grants access.
	//
	// This member is required.
	RoleArn *string

	// The Amazon S3 canned ACL that controls access to the object identified by the
	// object key. For more information, see S3 canned ACLs
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl).
	CannedAcl CannedAccessControlList

	noSmithyDocumentSerde
}

// Describes the location of updated firmware in S3.
type S3Destination struct {

	// The S3 bucket that contains the updated firmware.
	Bucket *string

	// The S3 prefix.
	Prefix *string

	noSmithyDocumentSerde
}

// The S3 location.
type S3Location struct {

	// The S3 bucket.
	Bucket *string

	// The S3 key.
	Key *string

	// The S3 bucket version.
	Version *string

	noSmithyDocumentSerde
}

// Describes an action to write a message to a Salesforce IoT Cloud Input Stream.
type SalesforceAction struct {

	// The token used to authenticate access to the Salesforce IoT Cloud Input Stream.
	// The token is available from the Salesforce IoT Cloud platform after creation of
	// the Input Stream.
	//
	// This member is required.
	Token *string

	// The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available
	// from the Salesforce IoT Cloud platform after creation of the Input Stream.
	//
	// This member is required.
	Url *string

	noSmithyDocumentSerde
}

// Information about the scheduled audit.
type ScheduledAuditMetadata struct {

	// The day of the month on which the scheduled audit is run (if the frequency is
	// "MONTHLY"). If days 29-31 are specified, and the month does not have that many
	// days, the audit takes place on the "LAST" day of the month.
	DayOfMonth *string

	// The day of the week on which the scheduled audit is run (if the frequency is
	// "WEEKLY" or "BIWEEKLY").
	DayOfWeek DayOfWeek

	// How often the scheduled audit occurs.
	Frequency AuditFrequency

	// The ARN of the scheduled audit.
	ScheduledAuditArn *string

	// The name of the scheduled audit.
	ScheduledAuditName *string

	noSmithyDocumentSerde
}

// Identifying information for a Device Defender security profile.
type SecurityProfileIdentifier struct {

	// The ARN of the security profile.
	//
	// This member is required.
	Arn *string

	// The name you've given to the security profile.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A target to which an alert is sent when a security profile behavior is violated.
type SecurityProfileTarget struct {

	// The ARN of the security profile.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// Information about a security profile and the target associated with it.
type SecurityProfileTargetMapping struct {

	// Information that identifies the security profile.
	SecurityProfileIdentifier *SecurityProfileIdentifier

	// Information about the target (thing group) associated with the security profile.
	Target *SecurityProfileTarget

	noSmithyDocumentSerde
}

// An object that contains information about a server certificate.
type ServerCertificateSummary struct {

	// The ARN of the server certificate.
	ServerCertificateArn *string

	// The status of the server certificate.
	ServerCertificateStatus ServerCertificateStatus

	// Details that explain the status of the server certificate.
	ServerCertificateStatusDetail *string

	noSmithyDocumentSerde
}

// Describes the code-signing profile.
type SigningProfileParameter struct {

	// Certificate ARN.
	CertificateArn *string

	// The location of the code-signing certificate on your device.
	CertificatePathOnDevice *string

	// The hardware platform of your device.
	Platform *string

	noSmithyDocumentSerde
}

// For more information, see Signature Version 4 signing process
// (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
type SigV4Authorization struct {

	// The ARN of the signing role.
	//
	// This member is required.
	RoleArn *string

	// The service name to use while signing with Sig V4.
	//
	// This member is required.
	ServiceName *string

	// The signing region.
	//
	// This member is required.
	SigningRegion *string

	noSmithyDocumentSerde
}

// Describes an action to publish to an Amazon SNS topic.
type SnsAction struct {

	// The ARN of the IAM role that grants access.
	//
	// This member is required.
	RoleArn *string

	// The ARN of the SNS topic.
	//
	// This member is required.
	TargetArn *string

	// (Optional) The message format of the message to publish. Accepted values are
	// "JSON" and "RAW". The default value of the attribute is "RAW". SNS uses this
	// setting to determine if the payload should be parsed and relevant
	// platform-specific bits of the payload should be extracted. To read more about
	// SNS message formats, see
	// https://docs.aws.amazon.com/sns/latest/dg/json-formats.html
	// (https://docs.aws.amazon.com/sns/latest/dg/json-formats.html) refer to their
	// official documentation.
	MessageFormat MessageFormat

	noSmithyDocumentSerde
}

// Describes an action to publish data to an Amazon SQS queue.
type SqsAction struct {

	// The URL of the Amazon SQS queue.
	//
	// This member is required.
	QueueUrl *string

	// The ARN of the IAM role that grants access.
	//
	// This member is required.
	RoleArn *string

	// Specifies whether to use Base64 encoding.
	UseBase64 *bool

	noSmithyDocumentSerde
}

// Information required to start a signing job.
type StartSigningJobParameter struct {

	// The location to write the code-signed file.
	Destination *Destination

	// The code-signing profile name.
	SigningProfileName *string

	// Describes the code-signing profile.
	SigningProfileParameter *SigningProfileParameter

	noSmithyDocumentSerde
}

// A statistical ranking (percentile) that indicates a threshold value by which a
// behavior is determined to be in compliance or in violation of the behavior.
type StatisticalThreshold struct {

	// The percentile that resolves to a threshold value by which compliance with a
	// behavior is determined. Metrics are collected over the specified period
	// (durationSeconds) from all reporting devices in your account and statistical
	// ranks are calculated. Then, the measurements from a device are collected over
	// the same period. If the accumulated measurements from the device fall above or
	// below (comparisonOperator) the value associated with the percentile specified,
	// then the device is considered to be in compliance with the behavior, otherwise a
	// violation occurs.
	Statistic *string

	noSmithyDocumentSerde
}

// A map of key-value pairs for all supported statistics. Currently, only count is
// supported.
type Statistics struct {

	// The average of the aggregated field values.
	Average float64

	// The count of things that match the query.
	Count int32

	// The maximum aggregated field value.
	Maximum float64

	// The minimum aggregated field value.
	Minimum float64

	// The standard deviation of the aggregated field values.
	StdDeviation float64

	// The sum of the aggregated field values.
	Sum float64

	// The sum of the squares of the aggregated field values.
	SumOfSquares float64

	// The variance of the aggregated field values.
	Variance float64

	noSmithyDocumentSerde
}

// Starts execution of a Step Functions state machine.
type StepFunctionsAction struct {

	// The ARN of the role that grants IoT permission to start execution of a state
	// machine ("Action":"states:StartExecution").
	//
	// This member is required.
	RoleArn *string

	// The name of the Step Functions state machine whose execution will be started.
	//
	// This member is required.
	StateMachineName *string

	// (Optional) A name will be given to the state machine execution consisting of
	// this prefix followed by a UUID. Step Functions automatically creates a unique
	// name for each state machine execution if one is not provided.
	ExecutionNamePrefix *string

	noSmithyDocumentSerde
}

// Describes a group of files that can be streamed.
type Stream struct {

	// The ID of a file associated with a stream.
	FileId *int32

	// The stream ID.
	StreamId *string

	noSmithyDocumentSerde
}

// Represents a file to stream.
type StreamFile struct {

	// The file ID.
	FileId *int32

	// The location of the file in S3.
	S3Location *S3Location

	noSmithyDocumentSerde
}

// Information about a stream.
type StreamInfo struct {

	// The date when the stream was created.
	CreatedAt *time.Time

	// The description of the stream.
	Description *string

	// The files to stream.
	Files []StreamFile

	// The date when the stream was last updated.
	LastUpdatedAt *time.Time

	// An IAM role IoT assumes to access your S3 files.
	RoleArn *string

	// The stream ARN.
	StreamArn *string

	// The stream ID.
	StreamId *string

	// The stream version.
	StreamVersion *int32

	noSmithyDocumentSerde
}

// A summary of a stream.
type StreamSummary struct {

	// A description of the stream.
	Description *string

	// The stream ARN.
	StreamArn *string

	// The stream ID.
	StreamId *string

	// The stream version.
	StreamVersion *int32

	noSmithyDocumentSerde
}

// A set of key/value pairs that are used to manage the resource.
type Tag struct {

	// The tag's key.
	//
	// This member is required.
	Key *string

	// The tag's value.
	Value *string

	noSmithyDocumentSerde
}

// Statistics for the checks performed during the audit.
type TaskStatistics struct {

	// The number of checks that did not run because the audit was canceled.
	CanceledChecks *int32

	// The number of checks that found compliant resources.
	CompliantChecks *int32

	// The number of checks.
	FailedChecks *int32

	// The number of checks in progress.
	InProgressChecks *int32

	// The number of checks that found noncompliant resources.
	NonCompliantChecks *int32

	// The number of checks in this audit.
	TotalChecks *int32

	// The number of checks waiting for data collection.
	WaitingForDataCollectionChecks *int32

	noSmithyDocumentSerde
}

// Provides summary counts of how many tasks for findings are in a particular
// state. This information is included in the response from
// DescribeAuditMitigationActionsTask.
type TaskStatisticsForAuditCheck struct {

	// The number of findings to which the mitigation action task was canceled when
	// applied.
	CanceledFindingsCount *int64

	// The number of findings for which at least one of the actions failed when
	// applied.
	FailedFindingsCount *int64

	// The number of findings skipped because of filter conditions provided in the
	// parameters to the command.
	SkippedFindingsCount *int64

	// The number of findings for which all mitigation actions succeeded when applied.
	SucceededFindingsCount *int64

	// The total number of findings to which a task is being applied.
	TotalFindingsCount *int64

	noSmithyDocumentSerde
}

// Performs an aggregation that will return a list of buckets. The list of buckets
// is a ranked list of the number of occurrences of an aggregation field value.
type TermsAggregation struct {

	// The number of buckets to return in the response. Default to 10.
	MaxBuckets int32

	noSmithyDocumentSerde
}

// The properties of the thing, including thing name, thing type name, and a list
// of thing attributes.
type ThingAttribute struct {

	// A list of thing attributes which are name-value pairs.
	Attributes map[string]string

	// The thing ARN.
	ThingArn *string

	// The name of the thing.
	ThingName *string

	// The name of the thing type, if the thing has been associated with a type.
	ThingTypeName *string

	// The version of the thing record in the registry.
	Version int64

	noSmithyDocumentSerde
}

// The connectivity status of the thing.
type ThingConnectivity struct {

	// True if the thing is connected to the Amazon Web Services IoT Core service;
	// false if it is not connected.
	Connected bool

	// The reason why the client is disconnected. If the thing has been disconnected
	// for approximately an hour, the disconnectReason value might be missing.
	DisconnectReason *string

	// The epoch time (in milliseconds) when the thing last connected or disconnected.
	// If the thing has been disconnected for approximately an hour, the time value
	// might be missing.
	Timestamp *int64

	noSmithyDocumentSerde
}

// The thing search index document.
type ThingDocument struct {

	// The attributes.
	Attributes map[string]string

	// Indicates whether the thing is connected to the Amazon Web Services IoT Core
	// service.
	Connectivity *ThingConnectivity

	// The shadow.
	Shadow *string

	// Thing group names.
	ThingGroupNames []string

	// The thing ID.
	ThingId *string

	// The thing name.
	ThingName *string

	// The thing type name.
	ThingTypeName *string

	noSmithyDocumentSerde
}

// The thing group search index document.
type ThingGroupDocument struct {

	// The thing group attributes.
	Attributes map[string]string

	// Parent group names.
	ParentGroupNames []string

	// The thing group description.
	ThingGroupDescription *string

	// The thing group ID.
	ThingGroupId *string

	// The thing group name.
	ThingGroupName *string

	noSmithyDocumentSerde
}

// Thing group indexing configuration.
type ThingGroupIndexingConfiguration struct {

	// Thing group indexing mode.
	//
	// This member is required.
	ThingGroupIndexingMode ThingGroupIndexingMode

	// A list of thing group fields to index. This list cannot contain any managed
	// fields. Use the GetIndexingConfiguration API to get a list of managed fields.
	// Contains custom field names and their data type.
	CustomFields []Field

	// Contains fields that are indexed and whose types are already known by the Fleet
	// Indexing service.
	ManagedFields []Field

	noSmithyDocumentSerde
}

// Thing group metadata.
type ThingGroupMetadata struct {

	// The UNIX timestamp of when the thing group was created.
	CreationDate *time.Time

	// The parent thing group name.
	ParentGroupName *string

	// The root parent thing group.
	RootToParentThingGroups []GroupNameAndArn

	noSmithyDocumentSerde
}

// Thing group properties.
type ThingGroupProperties struct {

	// The thing group attributes in JSON format.
	AttributePayload *AttributePayload

	// The thing group description.
	ThingGroupDescription *string

	noSmithyDocumentSerde
}

// The thing indexing configuration. For more information, see Managing Thing
// Indexing
// (https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html).
type ThingIndexingConfiguration struct {

	// Thing indexing mode. Valid values are:
	//
	// * REGISTRY – Your thing index contains
	// registry data only.
	//
	// * REGISTRY_AND_SHADOW - Your thing index contains registry
	// and shadow data.
	//
	// * OFF - Thing indexing is disabled.
	//
	// This member is required.
	ThingIndexingMode ThingIndexingMode

	// Contains custom field names and their data type.
	CustomFields []Field

	// Contains fields that are indexed and whose types are already known by the Fleet
	// Indexing service.
	ManagedFields []Field

	// Thing connectivity indexing mode. Valid values are:
	//
	// * STATUS – Your thing index
	// contains connectivity status. To enable thing connectivity indexing,
	// thingIndexMode must not be set to OFF.
	//
	// * OFF - Thing connectivity status
	// indexing is disabled.
	ThingConnectivityIndexingMode ThingConnectivityIndexingMode

	noSmithyDocumentSerde
}

// The definition of the thing type, including thing type name and description.
type ThingTypeDefinition struct {

	// The thing type ARN.
	ThingTypeArn *string

	// The ThingTypeMetadata contains additional information about the thing type
	// including: creation date and time, a value indicating whether the thing type is
	// deprecated, and a date and time when it was deprecated.
	ThingTypeMetadata *ThingTypeMetadata

	// The name of the thing type.
	ThingTypeName *string

	// The ThingTypeProperties for the thing type.
	ThingTypeProperties *ThingTypeProperties

	noSmithyDocumentSerde
}

// The ThingTypeMetadata contains additional information about the thing type
// including: creation date and time, a value indicating whether the thing type is
// deprecated, and a date and time when time was deprecated.
type ThingTypeMetadata struct {

	// The date and time when the thing type was created.
	CreationDate *time.Time

	// Whether the thing type is deprecated. If true, no new things could be associated
	// with this type.
	Deprecated bool

	// The date and time when the thing type was deprecated.
	DeprecationDate *time.Time

	noSmithyDocumentSerde
}

// The ThingTypeProperties contains information about the thing type including: a
// thing type description, and a list of searchable thing attribute names.
type ThingTypeProperties struct {

	// A list of searchable thing attribute names.
	SearchableAttributes []string

	// The description of the thing type.
	ThingTypeDescription *string

	noSmithyDocumentSerde
}

// Specifies the amount of time each device has to finish its execution of the job.
// A timer is started when the job execution status is set to IN_PROGRESS. If the
// job execution status is not set to another terminal state before the timer
// expires, it will be automatically set to TIMED_OUT.
type TimeoutConfig struct {

	// Specifies the amount of time, in minutes, this device has to finish execution of
	// this job. The timeout interval can be anywhere between 1 minute and 7 days (1 to
	// 10080 minutes). The in progress timer can't be updated and will apply to all job
	// executions for the job. Whenever a job execution remains in the IN_PROGRESS
	// status for longer than this interval, the job execution will fail and switch to
	// the terminal TIMED_OUT status.
	InProgressTimeoutInMinutes *int64

	noSmithyDocumentSerde
}

// The Timestream rule action writes attributes (measures) from an MQTT message
// into an Amazon Timestream table. For more information, see the Timestream
// (https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html)
// topic rule action documentation.
type TimestreamAction struct {

	// The name of an Amazon Timestream database.
	//
	// This member is required.
	DatabaseName *string

	// Metadata attributes of the time series that are written in each measure record.
	//
	// This member is required.
	Dimensions []TimestreamDimension

	// The ARN of the role that grants permission to write to the Amazon Timestream
	// database table.
	//
	// This member is required.
	RoleArn *string

	// The name of the database table into which to write the measure records.
	//
	// This member is required.
	TableName *string

	// Specifies an application-defined value to replace the default value assigned to
	// the Timestream record's timestamp in the time column. You can use this property
	// to specify the value and the precision of the Timestream record's timestamp. You
	// can specify a value from the message payload or a value computed by a
	// substitution template. If omitted, the topic rule action assigns the timestamp,
	// in milliseconds, at the time it processed the rule.
	Timestamp *TimestreamTimestamp

	noSmithyDocumentSerde
}

// Metadata attributes of the time series that are written in each measure record.
type TimestreamDimension struct {

	// The metadata dimension name. This is the name of the column in the Amazon
	// Timestream database table record. Dimensions cannot be named: measure_name,
	// measure_value, or time. These names are reserved. Dimension names cannot start
	// with ts_ or measure_value and they cannot contain the colon (:) character.
	//
	// This member is required.
	Name *string

	// The value to write in this column of the database record.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Describes how to interpret an application-defined timestamp value from an MQTT
// message payload and the precision of that value.
type TimestreamTimestamp struct {

	// The precision of the timestamp value that results from the expression described
	// in value. Valid values: SECONDS | MILLISECONDS | MICROSECONDS | NANOSECONDS. The
	// default is MILLISECONDS.
	//
	// This member is required.
	Unit *string

	// An expression that returns a long epoch time value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Specifies the TLS context to use for the test authorizer request.
type TlsContext struct {

	// The value of the serverName key in a TLS authorization request.
	ServerName *string

	noSmithyDocumentSerde
}

// Describes a rule.
type TopicRule struct {

	// The actions associated with the rule.
	Actions []Action

	// The version of the SQL rules engine to use when evaluating the rule.
	AwsIotSqlVersion *string

	// The date and time the rule was created.
	CreatedAt *time.Time

	// The description of the rule.
	Description *string

	// The action to perform when an error occurs.
	ErrorAction *Action

	// Specifies whether the rule is disabled.
	RuleDisabled *bool

	// The name of the rule.
	RuleName *string

	// The SQL statement used to query the topic. When using a SQL query with multiple
	// lines, be sure to escape the newline characters.
	Sql *string

	noSmithyDocumentSerde
}

// A topic rule destination.
type TopicRuleDestination struct {

	// The topic rule destination URL.
	Arn *string

	// The date and time when the topic rule destination was created.
	CreatedAt *time.Time

	// Properties of the HTTP URL.
	HttpUrlProperties *HttpUrlDestinationProperties

	// The date and time when the topic rule destination was last updated.
	LastUpdatedAt *time.Time

	// The status of the topic rule destination. Valid values are: IN_PROGRESS A topic
	// rule destination was created but has not been confirmed. You can set status to
	// IN_PROGRESS by calling UpdateTopicRuleDestination. Calling
	// UpdateTopicRuleDestination causes a new confirmation challenge to be sent to
	// your confirmation endpoint. ENABLED Confirmation was completed, and traffic to
	// this destination is allowed. You can set status to DISABLED by calling
	// UpdateTopicRuleDestination. DISABLED Confirmation was completed, and traffic to
	// this destination is not allowed. You can set status to ENABLED by calling
	// UpdateTopicRuleDestination. ERROR Confirmation could not be completed, for
	// example if the confirmation timed out. You can call GetTopicRuleDestination for
	// details about the error. You can set status to IN_PROGRESS by calling
	// UpdateTopicRuleDestination. Calling UpdateTopicRuleDestination causes a new
	// confirmation challenge to be sent to your confirmation endpoint.
	Status TopicRuleDestinationStatus

	// Additional details or reason why the topic rule destination is in the current
	// status.
	StatusReason *string

	// Properties of the virtual private cloud (VPC) connection.
	VpcProperties *VpcDestinationProperties

	noSmithyDocumentSerde
}

// Configuration of the topic rule destination.
type TopicRuleDestinationConfiguration struct {

	// Configuration of the HTTP URL.
	HttpUrlConfiguration *HttpUrlDestinationConfiguration

	// Configuration of the virtual private cloud (VPC) connection.
	VpcConfiguration *VpcDestinationConfiguration

	noSmithyDocumentSerde
}

// Information about the topic rule destination.
type TopicRuleDestinationSummary struct {

	// The topic rule destination ARN.
	Arn *string

	// The date and time when the topic rule destination was created.
	CreatedAt *time.Time

	// Information about the HTTP URL.
	HttpUrlSummary *HttpUrlDestinationSummary

	// The date and time when the topic rule destination was last updated.
	LastUpdatedAt *time.Time

	// The status of the topic rule destination. Valid values are: IN_PROGRESS A topic
	// rule destination was created but has not been confirmed. You can set status to
	// IN_PROGRESS by calling UpdateTopicRuleDestination. Calling
	// UpdateTopicRuleDestination causes a new confirmation challenge to be sent to
	// your confirmation endpoint. ENABLED Confirmation was completed, and traffic to
	// this destination is allowed. You can set status to DISABLED by calling
	// UpdateTopicRuleDestination. DISABLED Confirmation was completed, and traffic to
	// this destination is not allowed. You can set status to ENABLED by calling
	// UpdateTopicRuleDestination. ERROR Confirmation could not be completed, for
	// example if the confirmation timed out. You can call GetTopicRuleDestination for
	// details about the error. You can set status to IN_PROGRESS by calling
	// UpdateTopicRuleDestination. Calling UpdateTopicRuleDestination causes a new
	// confirmation challenge to be sent to your confirmation endpoint.
	Status TopicRuleDestinationStatus

	// The reason the topic rule destination is in the current status.
	StatusReason *string

	// Information about the virtual private cloud (VPC) connection.
	VpcDestinationSummary *VpcDestinationSummary

	noSmithyDocumentSerde
}

// Describes a rule.
type TopicRuleListItem struct {

	// The date and time the rule was created.
	CreatedAt *time.Time

	// The rule ARN.
	RuleArn *string

	// Specifies whether the rule is disabled.
	RuleDisabled *bool

	// The name of the rule.
	RuleName *string

	// The pattern for the topic names that apply.
	TopicPattern *string

	noSmithyDocumentSerde
}

// Describes a rule.
type TopicRulePayload struct {

	// The actions associated with the rule.
	//
	// This member is required.
	Actions []Action

	// The SQL statement used to query the topic. For more information, see IoT SQL
	// Reference
	// (https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html)
	// in the IoT Developer Guide.
	//
	// This member is required.
	Sql *string

	// The version of the SQL rules engine to use when evaluating the rule.
	AwsIotSqlVersion *string

	// The description of the rule.
	Description *string

	// The action to take when an error occurs.
	ErrorAction *Action

	// Specifies whether the rule is disabled.
	RuleDisabled *bool

	noSmithyDocumentSerde
}

// Data used to transfer a certificate to an Amazon Web Services account.
type TransferData struct {

	// The date the transfer was accepted.
	AcceptDate *time.Time

	// The date the transfer was rejected.
	RejectDate *time.Time

	// The reason why the transfer was rejected.
	RejectReason *string

	// The date the transfer took place.
	TransferDate *time.Time

	// The transfer message.
	TransferMessage *string

	noSmithyDocumentSerde
}

// Parameters to define a mitigation action that changes the state of the CA
// certificate to inactive.
type UpdateCACertificateParams struct {

	// The action that you want to apply to the CA certificate. The only supported
	// value is DEACTIVATE.
	//
	// This member is required.
	Action CACertificateUpdateAction

	noSmithyDocumentSerde
}

// Parameters to define a mitigation action that changes the state of the device
// certificate to inactive.
type UpdateDeviceCertificateParams struct {

	// The action that you want to apply to the device certificate. The only supported
	// value is DEACTIVATE.
	//
	// This member is required.
	Action DeviceCertificateUpdateAction

	noSmithyDocumentSerde
}

// Information about an error found in a behavior specification.
type ValidationError struct {

	// The description of an error found in the behaviors.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Information about a Device Defender security profile behavior violation.
type ViolationEvent struct {

	// The behavior that was violated.
	Behavior *Behavior

	// The value of the metric (the measurement).
	MetricValue *MetricValue

	// The name of the security profile whose behavior was violated.
	SecurityProfileName *string

	// The name of the thing responsible for the violation event.
	ThingName *string

	// The details of a violation event.
	ViolationEventAdditionalInfo *ViolationEventAdditionalInfo

	// The time the violation event occurred.
	ViolationEventTime *time.Time

	// The type of violation event.
	ViolationEventType ViolationEventType

	// The ID of the violation event.
	ViolationId *string

	noSmithyDocumentSerde
}

// The details of a violation event.
type ViolationEventAdditionalInfo struct {

	// The sensitivity of anomalous behavior evaluation. Can be Low, Medium, or High.
	ConfidenceLevel ConfidenceLevel

	noSmithyDocumentSerde
}

// Specifies the time period of which violation events occurred between.
type ViolationEventOccurrenceRange struct {

	// The end date and time of a time period in which violation events occurred.
	//
	// This member is required.
	EndTime *time.Time

	// The start date and time of a time period in which violation events occurred.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// The configuration information for a virtual private cloud (VPC) destination.
type VpcDestinationConfiguration struct {

	// The ARN of a role that has permission to create and attach to elastic network
	// interfaces (ENIs).
	//
	// This member is required.
	RoleArn *string

	// The subnet IDs of the VPC destination.
	//
	// This member is required.
	SubnetIds []string

	// The ID of the VPC.
	//
	// This member is required.
	VpcId *string

	// The security groups of the VPC destination.
	SecurityGroups []string

	noSmithyDocumentSerde
}

// The properties of a virtual private cloud (VPC) destination.
type VpcDestinationProperties struct {

	// The ARN of a role that has permission to create and attach to elastic network
	// interfaces (ENIs).
	RoleArn *string

	// The security groups of the VPC destination.
	SecurityGroups []string

	// The subnet IDs of the VPC destination.
	SubnetIds []string

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

// The summary of a virtual private cloud (VPC) destination.
type VpcDestinationSummary struct {

	// The ARN of a role that has permission to create and attach to elastic network
	// interfaces (ENIs).
	RoleArn *string

	// The security groups of the VPC destination.
	SecurityGroups []string

	// The subnet IDs of the VPC destination.
	SubnetIds []string

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAssetPropertyVariant() {}
