// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticloadbalancingv2

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/query"
	"github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"sort"
)

type awsAwsquery_serializeOpAddListenerCertificates struct {
}

func (*awsAwsquery_serializeOpAddListenerCertificates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAddListenerCertificates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddListenerCertificatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AddListenerCertificates")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentAddListenerCertificatesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpAddTags struct {
}

func (*awsAwsquery_serializeOpAddTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAddTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AddTags")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentAddTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateListener struct {
}

func (*awsAwsquery_serializeOpCreateListener) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateListener) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateListenerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateListener")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateListenerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateLoadBalancer struct {
}

func (*awsAwsquery_serializeOpCreateLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateLoadBalancer")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateRule struct {
}

func (*awsAwsquery_serializeOpCreateRule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateRule")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateTargetGroup struct {
}

func (*awsAwsquery_serializeOpCreateTargetGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateTargetGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTargetGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTargetGroup")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentCreateTargetGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteListener struct {
}

func (*awsAwsquery_serializeOpDeleteListener) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteListener) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteListenerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteListener")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteListenerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteLoadBalancer struct {
}

func (*awsAwsquery_serializeOpDeleteLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteLoadBalancer")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteRule struct {
}

func (*awsAwsquery_serializeOpDeleteRule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteRule")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteTargetGroup struct {
}

func (*awsAwsquery_serializeOpDeleteTargetGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteTargetGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTargetGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTargetGroup")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDeleteTargetGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeregisterTargets struct {
}

func (*awsAwsquery_serializeOpDeregisterTargets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeregisterTargets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterTargetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeregisterTargets")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDeregisterTargetsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAccountLimits struct {
}

func (*awsAwsquery_serializeOpDescribeAccountLimits) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAccountLimits) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountLimitsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAccountLimits")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAccountLimitsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeListenerCertificates struct {
}

func (*awsAwsquery_serializeOpDescribeListenerCertificates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeListenerCertificates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeListenerCertificatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeListenerCertificates")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeListenerCertificatesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeListeners struct {
}

func (*awsAwsquery_serializeOpDescribeListeners) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeListeners) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeListenersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeListeners")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeListenersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLoadBalancerAttributes struct {
}

func (*awsAwsquery_serializeOpDescribeLoadBalancerAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLoadBalancerAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoadBalancerAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLoadBalancerAttributes")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeLoadBalancerAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLoadBalancers struct {
}

func (*awsAwsquery_serializeOpDescribeLoadBalancers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLoadBalancers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoadBalancersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLoadBalancers")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeLoadBalancersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeRules struct {
}

func (*awsAwsquery_serializeOpDescribeRules) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeRules")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeRulesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeSSLPolicies struct {
}

func (*awsAwsquery_serializeOpDescribeSSLPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeSSLPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSSLPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSSLPolicies")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeSSLPoliciesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeTags struct {
}

func (*awsAwsquery_serializeOpDescribeTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTags")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeTargetGroupAttributes struct {
}

func (*awsAwsquery_serializeOpDescribeTargetGroupAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeTargetGroupAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTargetGroupAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTargetGroupAttributes")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeTargetGroupAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeTargetGroups struct {
}

func (*awsAwsquery_serializeOpDescribeTargetGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeTargetGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTargetGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTargetGroups")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeTargetGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeTargetHealth struct {
}

func (*awsAwsquery_serializeOpDescribeTargetHealth) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeTargetHealth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTargetHealthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTargetHealth")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentDescribeTargetHealthInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyListener struct {
}

func (*awsAwsquery_serializeOpModifyListener) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyListener) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyListenerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyListener")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyListenerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyLoadBalancerAttributes struct {
}

func (*awsAwsquery_serializeOpModifyLoadBalancerAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyLoadBalancerAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyLoadBalancerAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyLoadBalancerAttributes")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyLoadBalancerAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyRule struct {
}

func (*awsAwsquery_serializeOpModifyRule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyRule")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyTargetGroup struct {
}

func (*awsAwsquery_serializeOpModifyTargetGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyTargetGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyTargetGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyTargetGroup")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyTargetGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyTargetGroupAttributes struct {
}

func (*awsAwsquery_serializeOpModifyTargetGroupAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyTargetGroupAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyTargetGroupAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyTargetGroupAttributes")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentModifyTargetGroupAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRegisterTargets struct {
}

func (*awsAwsquery_serializeOpRegisterTargets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRegisterTargets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterTargetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RegisterTargets")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentRegisterTargetsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRemoveListenerCertificates struct {
}

func (*awsAwsquery_serializeOpRemoveListenerCertificates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRemoveListenerCertificates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveListenerCertificatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RemoveListenerCertificates")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentRemoveListenerCertificatesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRemoveTags struct {
}

func (*awsAwsquery_serializeOpRemoveTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRemoveTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RemoveTags")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentRemoveTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetIpAddressType struct {
}

func (*awsAwsquery_serializeOpSetIpAddressType) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetIpAddressType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetIpAddressTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetIpAddressType")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentSetIpAddressTypeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetRulePriorities struct {
}

func (*awsAwsquery_serializeOpSetRulePriorities) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetRulePriorities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetRulePrioritiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetRulePriorities")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentSetRulePrioritiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetSecurityGroups struct {
}

func (*awsAwsquery_serializeOpSetSecurityGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetSecurityGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetSecurityGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetSecurityGroups")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentSetSecurityGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetSubnets struct {
}

func (*awsAwsquery_serializeOpSetSubnets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetSubnets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetSubnetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetSubnets")
	body.Key("Version").String("2015-12-01")

	if err := awsAwsquery_serializeOpDocumentSetSubnetsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsquery_serializeDocumentAction(v *types.Action, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AuthenticateCognitoConfig != nil {
		objectKey := object.Key("AuthenticateCognitoConfig")
		if err := awsAwsquery_serializeDocumentAuthenticateCognitoActionConfig(v.AuthenticateCognitoConfig, objectKey); err != nil {
			return err
		}
	}

	if v.AuthenticateOidcConfig != nil {
		objectKey := object.Key("AuthenticateOidcConfig")
		if err := awsAwsquery_serializeDocumentAuthenticateOidcActionConfig(v.AuthenticateOidcConfig, objectKey); err != nil {
			return err
		}
	}

	if v.FixedResponseConfig != nil {
		objectKey := object.Key("FixedResponseConfig")
		if err := awsAwsquery_serializeDocumentFixedResponseActionConfig(v.FixedResponseConfig, objectKey); err != nil {
			return err
		}
	}

	if v.ForwardConfig != nil {
		objectKey := object.Key("ForwardConfig")
		if err := awsAwsquery_serializeDocumentForwardActionConfig(v.ForwardConfig, objectKey); err != nil {
			return err
		}
	}

	if v.Order != nil {
		objectKey := object.Key("Order")
		objectKey.Integer(*v.Order)
	}

	if v.RedirectConfig != nil {
		objectKey := object.Key("RedirectConfig")
		if err := awsAwsquery_serializeDocumentRedirectActionConfig(v.RedirectConfig, objectKey); err != nil {
			return err
		}
	}

	if v.TargetGroupArn != nil {
		objectKey := object.Key("TargetGroupArn")
		objectKey.String(*v.TargetGroupArn)
	}

	if len(v.Type) > 0 {
		objectKey := object.Key("Type")
		objectKey.String(string(v.Type))
	}

	return nil
}

func awsAwsquery_serializeDocumentActions(v []types.Action, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentAction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentAlpnPolicyName(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentAuthenticateCognitoActionAuthenticationRequestExtraParams(v map[string]string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	object := value.Map("key", "value")

	keys := make([]string, 0, len(v))
	for key := range v {
		keys = append(keys, key)
	}
	sort.Strings(keys)

	for _, key := range keys {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsquery_serializeDocumentAuthenticateCognitoActionConfig(v *types.AuthenticateCognitoActionConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AuthenticationRequestExtraParams != nil {
		objectKey := object.Key("AuthenticationRequestExtraParams")
		if err := awsAwsquery_serializeDocumentAuthenticateCognitoActionAuthenticationRequestExtraParams(v.AuthenticationRequestExtraParams, objectKey); err != nil {
			return err
		}
	}

	if len(v.OnUnauthenticatedRequest) > 0 {
		objectKey := object.Key("OnUnauthenticatedRequest")
		objectKey.String(string(v.OnUnauthenticatedRequest))
	}

	if v.Scope != nil {
		objectKey := object.Key("Scope")
		objectKey.String(*v.Scope)
	}

	if v.SessionCookieName != nil {
		objectKey := object.Key("SessionCookieName")
		objectKey.String(*v.SessionCookieName)
	}

	if v.SessionTimeout != nil {
		objectKey := object.Key("SessionTimeout")
		objectKey.Long(*v.SessionTimeout)
	}

	if v.UserPoolArn != nil {
		objectKey := object.Key("UserPoolArn")
		objectKey.String(*v.UserPoolArn)
	}

	if v.UserPoolClientId != nil {
		objectKey := object.Key("UserPoolClientId")
		objectKey.String(*v.UserPoolClientId)
	}

	if v.UserPoolDomain != nil {
		objectKey := object.Key("UserPoolDomain")
		objectKey.String(*v.UserPoolDomain)
	}

	return nil
}

func awsAwsquery_serializeDocumentAuthenticateOidcActionAuthenticationRequestExtraParams(v map[string]string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	object := value.Map("key", "value")

	keys := make([]string, 0, len(v))
	for key := range v {
		keys = append(keys, key)
	}
	sort.Strings(keys)

	for _, key := range keys {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsquery_serializeDocumentAuthenticateOidcActionConfig(v *types.AuthenticateOidcActionConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AuthenticationRequestExtraParams != nil {
		objectKey := object.Key("AuthenticationRequestExtraParams")
		if err := awsAwsquery_serializeDocumentAuthenticateOidcActionAuthenticationRequestExtraParams(v.AuthenticationRequestExtraParams, objectKey); err != nil {
			return err
		}
	}

	if v.AuthorizationEndpoint != nil {
		objectKey := object.Key("AuthorizationEndpoint")
		objectKey.String(*v.AuthorizationEndpoint)
	}

	if v.ClientId != nil {
		objectKey := object.Key("ClientId")
		objectKey.String(*v.ClientId)
	}

	if v.ClientSecret != nil {
		objectKey := object.Key("ClientSecret")
		objectKey.String(*v.ClientSecret)
	}

	if v.Issuer != nil {
		objectKey := object.Key("Issuer")
		objectKey.String(*v.Issuer)
	}

	if len(v.OnUnauthenticatedRequest) > 0 {
		objectKey := object.Key("OnUnauthenticatedRequest")
		objectKey.String(string(v.OnUnauthenticatedRequest))
	}

	if v.Scope != nil {
		objectKey := object.Key("Scope")
		objectKey.String(*v.Scope)
	}

	if v.SessionCookieName != nil {
		objectKey := object.Key("SessionCookieName")
		objectKey.String(*v.SessionCookieName)
	}

	if v.SessionTimeout != nil {
		objectKey := object.Key("SessionTimeout")
		objectKey.Long(*v.SessionTimeout)
	}

	if v.TokenEndpoint != nil {
		objectKey := object.Key("TokenEndpoint")
		objectKey.String(*v.TokenEndpoint)
	}

	if v.UseExistingClientSecret != nil {
		objectKey := object.Key("UseExistingClientSecret")
		objectKey.Boolean(*v.UseExistingClientSecret)
	}

	if v.UserInfoEndpoint != nil {
		objectKey := object.Key("UserInfoEndpoint")
		objectKey.String(*v.UserInfoEndpoint)
	}

	return nil
}

func awsAwsquery_serializeDocumentCertificate(v *types.Certificate, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CertificateArn != nil {
		objectKey := object.Key("CertificateArn")
		objectKey.String(*v.CertificateArn)
	}

	if v.IsDefault != nil {
		objectKey := object.Key("IsDefault")
		objectKey.Boolean(*v.IsDefault)
	}

	return nil
}

func awsAwsquery_serializeDocumentCertificateList(v []types.Certificate, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentCertificate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentFixedResponseActionConfig(v *types.FixedResponseActionConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ContentType != nil {
		objectKey := object.Key("ContentType")
		objectKey.String(*v.ContentType)
	}

	if v.MessageBody != nil {
		objectKey := object.Key("MessageBody")
		objectKey.String(*v.MessageBody)
	}

	if v.StatusCode != nil {
		objectKey := object.Key("StatusCode")
		objectKey.String(*v.StatusCode)
	}

	return nil
}

func awsAwsquery_serializeDocumentForwardActionConfig(v *types.ForwardActionConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TargetGroups != nil {
		objectKey := object.Key("TargetGroups")
		if err := awsAwsquery_serializeDocumentTargetGroupList(v.TargetGroups, objectKey); err != nil {
			return err
		}
	}

	if v.TargetGroupStickinessConfig != nil {
		objectKey := object.Key("TargetGroupStickinessConfig")
		if err := awsAwsquery_serializeDocumentTargetGroupStickinessConfig(v.TargetGroupStickinessConfig, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentHostHeaderConditionConfig(v *types.HostHeaderConditionConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Values != nil {
		objectKey := object.Key("Values")
		if err := awsAwsquery_serializeDocumentListOfString(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentHttpHeaderConditionConfig(v *types.HttpHeaderConditionConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HttpHeaderName != nil {
		objectKey := object.Key("HttpHeaderName")
		objectKey.String(*v.HttpHeaderName)
	}

	if v.Values != nil {
		objectKey := object.Key("Values")
		if err := awsAwsquery_serializeDocumentListOfString(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentHttpRequestMethodConditionConfig(v *types.HttpRequestMethodConditionConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Values != nil {
		objectKey := object.Key("Values")
		if err := awsAwsquery_serializeDocumentListOfString(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentListenerArns(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentListOfString(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentLoadBalancerArns(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentLoadBalancerAttribute(v *types.LoadBalancerAttribute, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentLoadBalancerAttributes(v []types.LoadBalancerAttribute, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentLoadBalancerAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentLoadBalancerNames(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentMatcher(v *types.Matcher, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GrpcCode != nil {
		objectKey := object.Key("GrpcCode")
		objectKey.String(*v.GrpcCode)
	}

	if v.HttpCode != nil {
		objectKey := object.Key("HttpCode")
		objectKey.String(*v.HttpCode)
	}

	return nil
}

func awsAwsquery_serializeDocumentPathPatternConditionConfig(v *types.PathPatternConditionConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Values != nil {
		objectKey := object.Key("Values")
		if err := awsAwsquery_serializeDocumentListOfString(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentQueryStringConditionConfig(v *types.QueryStringConditionConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Values != nil {
		objectKey := object.Key("Values")
		if err := awsAwsquery_serializeDocumentQueryStringKeyValuePairList(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentQueryStringKeyValuePair(v *types.QueryStringKeyValuePair, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentQueryStringKeyValuePairList(v []types.QueryStringKeyValuePair, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentQueryStringKeyValuePair(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentRedirectActionConfig(v *types.RedirectActionConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Host != nil {
		objectKey := object.Key("Host")
		objectKey.String(*v.Host)
	}

	if v.Path != nil {
		objectKey := object.Key("Path")
		objectKey.String(*v.Path)
	}

	if v.Port != nil {
		objectKey := object.Key("Port")
		objectKey.String(*v.Port)
	}

	if v.Protocol != nil {
		objectKey := object.Key("Protocol")
		objectKey.String(*v.Protocol)
	}

	if v.Query != nil {
		objectKey := object.Key("Query")
		objectKey.String(*v.Query)
	}

	if len(v.StatusCode) > 0 {
		objectKey := object.Key("StatusCode")
		objectKey.String(string(v.StatusCode))
	}

	return nil
}

func awsAwsquery_serializeDocumentResourceArns(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentRuleArns(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentRuleCondition(v *types.RuleCondition, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Field != nil {
		objectKey := object.Key("Field")
		objectKey.String(*v.Field)
	}

	if v.HostHeaderConfig != nil {
		objectKey := object.Key("HostHeaderConfig")
		if err := awsAwsquery_serializeDocumentHostHeaderConditionConfig(v.HostHeaderConfig, objectKey); err != nil {
			return err
		}
	}

	if v.HttpHeaderConfig != nil {
		objectKey := object.Key("HttpHeaderConfig")
		if err := awsAwsquery_serializeDocumentHttpHeaderConditionConfig(v.HttpHeaderConfig, objectKey); err != nil {
			return err
		}
	}

	if v.HttpRequestMethodConfig != nil {
		objectKey := object.Key("HttpRequestMethodConfig")
		if err := awsAwsquery_serializeDocumentHttpRequestMethodConditionConfig(v.HttpRequestMethodConfig, objectKey); err != nil {
			return err
		}
	}

	if v.PathPatternConfig != nil {
		objectKey := object.Key("PathPatternConfig")
		if err := awsAwsquery_serializeDocumentPathPatternConditionConfig(v.PathPatternConfig, objectKey); err != nil {
			return err
		}
	}

	if v.QueryStringConfig != nil {
		objectKey := object.Key("QueryStringConfig")
		if err := awsAwsquery_serializeDocumentQueryStringConditionConfig(v.QueryStringConfig, objectKey); err != nil {
			return err
		}
	}

	if v.SourceIpConfig != nil {
		objectKey := object.Key("SourceIpConfig")
		if err := awsAwsquery_serializeDocumentSourceIpConditionConfig(v.SourceIpConfig, objectKey); err != nil {
			return err
		}
	}

	if v.Values != nil {
		objectKey := object.Key("Values")
		if err := awsAwsquery_serializeDocumentListOfString(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentRuleConditionList(v []types.RuleCondition, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentRuleCondition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentRulePriorityList(v []types.RulePriorityPair, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentRulePriorityPair(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentRulePriorityPair(v *types.RulePriorityPair, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Priority != nil {
		objectKey := object.Key("Priority")
		objectKey.Integer(*v.Priority)
	}

	if v.RuleArn != nil {
		objectKey := object.Key("RuleArn")
		objectKey.String(*v.RuleArn)
	}

	return nil
}

func awsAwsquery_serializeDocumentSecurityGroups(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentSourceIpConditionConfig(v *types.SourceIpConditionConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Values != nil {
		objectKey := object.Key("Values")
		if err := awsAwsquery_serializeDocumentListOfString(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentSslPolicyNames(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentSubnetMapping(v *types.SubnetMapping, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AllocationId != nil {
		objectKey := object.Key("AllocationId")
		objectKey.String(*v.AllocationId)
	}

	if v.IPv6Address != nil {
		objectKey := object.Key("IPv6Address")
		objectKey.String(*v.IPv6Address)
	}

	if v.PrivateIPv4Address != nil {
		objectKey := object.Key("PrivateIPv4Address")
		objectKey.String(*v.PrivateIPv4Address)
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	return nil
}

func awsAwsquery_serializeDocumentSubnetMappings(v []types.SubnetMapping, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentSubnetMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentSubnets(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTag(v *types.Tag, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentTagKeys(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTagList(v []types.Tag, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentTargetDescription(v *types.TargetDescription, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.Id != nil {
		objectKey := object.Key("Id")
		objectKey.String(*v.Id)
	}

	if v.Port != nil {
		objectKey := object.Key("Port")
		objectKey.Integer(*v.Port)
	}

	return nil
}

func awsAwsquery_serializeDocumentTargetDescriptions(v []types.TargetDescription, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentTargetDescription(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentTargetGroupArns(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTargetGroupAttribute(v *types.TargetGroupAttribute, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentTargetGroupAttributes(v []types.TargetGroupAttribute, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentTargetGroupAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentTargetGroupList(v []types.TargetGroupTuple, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentTargetGroupTuple(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentTargetGroupNames(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTargetGroupStickinessConfig(v *types.TargetGroupStickinessConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DurationSeconds != nil {
		objectKey := object.Key("DurationSeconds")
		objectKey.Integer(*v.DurationSeconds)
	}

	if v.Enabled != nil {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(*v.Enabled)
	}

	return nil
}

func awsAwsquery_serializeDocumentTargetGroupTuple(v *types.TargetGroupTuple, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TargetGroupArn != nil {
		objectKey := object.Key("TargetGroupArn")
		objectKey.String(*v.TargetGroupArn)
	}

	if v.Weight != nil {
		objectKey := object.Key("Weight")
		objectKey.Integer(*v.Weight)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAddListenerCertificatesInput(v *AddListenerCertificatesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Certificates != nil {
		objectKey := object.Key("Certificates")
		if err := awsAwsquery_serializeDocumentCertificateList(v.Certificates, objectKey); err != nil {
			return err
		}
	}

	if v.ListenerArn != nil {
		objectKey := object.Key("ListenerArn")
		objectKey.String(*v.ListenerArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAddTagsInput(v *AddTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ResourceArns != nil {
		objectKey := object.Key("ResourceArns")
		if err := awsAwsquery_serializeDocumentResourceArns(v.ResourceArns, objectKey); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateListenerInput(v *CreateListenerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AlpnPolicy != nil {
		objectKey := object.Key("AlpnPolicy")
		if err := awsAwsquery_serializeDocumentAlpnPolicyName(v.AlpnPolicy, objectKey); err != nil {
			return err
		}
	}

	if v.Certificates != nil {
		objectKey := object.Key("Certificates")
		if err := awsAwsquery_serializeDocumentCertificateList(v.Certificates, objectKey); err != nil {
			return err
		}
	}

	if v.DefaultActions != nil {
		objectKey := object.Key("DefaultActions")
		if err := awsAwsquery_serializeDocumentActions(v.DefaultActions, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerArn != nil {
		objectKey := object.Key("LoadBalancerArn")
		objectKey.String(*v.LoadBalancerArn)
	}

	if v.Port != nil {
		objectKey := object.Key("Port")
		objectKey.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	if v.SslPolicy != nil {
		objectKey := object.Key("SslPolicy")
		objectKey.String(*v.SslPolicy)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateLoadBalancerInput(v *CreateLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CustomerOwnedIpv4Pool != nil {
		objectKey := object.Key("CustomerOwnedIpv4Pool")
		objectKey.String(*v.CustomerOwnedIpv4Pool)
	}

	if len(v.IpAddressType) > 0 {
		objectKey := object.Key("IpAddressType")
		objectKey.String(string(v.IpAddressType))
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if len(v.Scheme) > 0 {
		objectKey := object.Key("Scheme")
		objectKey.String(string(v.Scheme))
	}

	if v.SecurityGroups != nil {
		objectKey := object.Key("SecurityGroups")
		if err := awsAwsquery_serializeDocumentSecurityGroups(v.SecurityGroups, objectKey); err != nil {
			return err
		}
	}

	if v.SubnetMappings != nil {
		objectKey := object.Key("SubnetMappings")
		if err := awsAwsquery_serializeDocumentSubnetMappings(v.SubnetMappings, objectKey); err != nil {
			return err
		}
	}

	if v.Subnets != nil {
		objectKey := object.Key("Subnets")
		if err := awsAwsquery_serializeDocumentSubnets(v.Subnets, objectKey); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		objectKey := object.Key("Type")
		objectKey.String(string(v.Type))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateRuleInput(v *CreateRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Actions != nil {
		objectKey := object.Key("Actions")
		if err := awsAwsquery_serializeDocumentActions(v.Actions, objectKey); err != nil {
			return err
		}
	}

	if v.Conditions != nil {
		objectKey := object.Key("Conditions")
		if err := awsAwsquery_serializeDocumentRuleConditionList(v.Conditions, objectKey); err != nil {
			return err
		}
	}

	if v.ListenerArn != nil {
		objectKey := object.Key("ListenerArn")
		objectKey.String(*v.ListenerArn)
	}

	if v.Priority != nil {
		objectKey := object.Key("Priority")
		objectKey.Integer(*v.Priority)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateTargetGroupInput(v *CreateTargetGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HealthCheckEnabled != nil {
		objectKey := object.Key("HealthCheckEnabled")
		objectKey.Boolean(*v.HealthCheckEnabled)
	}

	if v.HealthCheckIntervalSeconds != nil {
		objectKey := object.Key("HealthCheckIntervalSeconds")
		objectKey.Integer(*v.HealthCheckIntervalSeconds)
	}

	if v.HealthCheckPath != nil {
		objectKey := object.Key("HealthCheckPath")
		objectKey.String(*v.HealthCheckPath)
	}

	if v.HealthCheckPort != nil {
		objectKey := object.Key("HealthCheckPort")
		objectKey.String(*v.HealthCheckPort)
	}

	if len(v.HealthCheckProtocol) > 0 {
		objectKey := object.Key("HealthCheckProtocol")
		objectKey.String(string(v.HealthCheckProtocol))
	}

	if v.HealthCheckTimeoutSeconds != nil {
		objectKey := object.Key("HealthCheckTimeoutSeconds")
		objectKey.Integer(*v.HealthCheckTimeoutSeconds)
	}

	if v.HealthyThresholdCount != nil {
		objectKey := object.Key("HealthyThresholdCount")
		objectKey.Integer(*v.HealthyThresholdCount)
	}

	if v.Matcher != nil {
		objectKey := object.Key("Matcher")
		if err := awsAwsquery_serializeDocumentMatcher(v.Matcher, objectKey); err != nil {
			return err
		}
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if v.Port != nil {
		objectKey := object.Key("Port")
		objectKey.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	if v.ProtocolVersion != nil {
		objectKey := object.Key("ProtocolVersion")
		objectKey.String(*v.ProtocolVersion)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	if len(v.TargetType) > 0 {
		objectKey := object.Key("TargetType")
		objectKey.String(string(v.TargetType))
	}

	if v.UnhealthyThresholdCount != nil {
		objectKey := object.Key("UnhealthyThresholdCount")
		objectKey.Integer(*v.UnhealthyThresholdCount)
	}

	if v.VpcId != nil {
		objectKey := object.Key("VpcId")
		objectKey.String(*v.VpcId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteListenerInput(v *DeleteListenerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListenerArn != nil {
		objectKey := object.Key("ListenerArn")
		objectKey.String(*v.ListenerArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteLoadBalancerInput(v *DeleteLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerArn != nil {
		objectKey := object.Key("LoadBalancerArn")
		objectKey.String(*v.LoadBalancerArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteRuleInput(v *DeleteRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RuleArn != nil {
		objectKey := object.Key("RuleArn")
		objectKey.String(*v.RuleArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteTargetGroupInput(v *DeleteTargetGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TargetGroupArn != nil {
		objectKey := object.Key("TargetGroupArn")
		objectKey.String(*v.TargetGroupArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeregisterTargetsInput(v *DeregisterTargetsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TargetGroupArn != nil {
		objectKey := object.Key("TargetGroupArn")
		objectKey.String(*v.TargetGroupArn)
	}

	if v.Targets != nil {
		objectKey := object.Key("Targets")
		if err := awsAwsquery_serializeDocumentTargetDescriptions(v.Targets, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAccountLimitsInput(v *DescribeAccountLimitsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.PageSize != nil {
		objectKey := object.Key("PageSize")
		objectKey.Integer(*v.PageSize)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeListenerCertificatesInput(v *DescribeListenerCertificatesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListenerArn != nil {
		objectKey := object.Key("ListenerArn")
		objectKey.String(*v.ListenerArn)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.PageSize != nil {
		objectKey := object.Key("PageSize")
		objectKey.Integer(*v.PageSize)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeListenersInput(v *DescribeListenersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListenerArns != nil {
		objectKey := object.Key("ListenerArns")
		if err := awsAwsquery_serializeDocumentListenerArns(v.ListenerArns, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerArn != nil {
		objectKey := object.Key("LoadBalancerArn")
		objectKey.String(*v.LoadBalancerArn)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.PageSize != nil {
		objectKey := object.Key("PageSize")
		objectKey.Integer(*v.PageSize)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeLoadBalancerAttributesInput(v *DescribeLoadBalancerAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerArn != nil {
		objectKey := object.Key("LoadBalancerArn")
		objectKey.String(*v.LoadBalancerArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeLoadBalancersInput(v *DescribeLoadBalancersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerArns != nil {
		objectKey := object.Key("LoadBalancerArns")
		if err := awsAwsquery_serializeDocumentLoadBalancerArns(v.LoadBalancerArns, objectKey); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.Names != nil {
		objectKey := object.Key("Names")
		if err := awsAwsquery_serializeDocumentLoadBalancerNames(v.Names, objectKey); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		objectKey := object.Key("PageSize")
		objectKey.Integer(*v.PageSize)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeRulesInput(v *DescribeRulesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListenerArn != nil {
		objectKey := object.Key("ListenerArn")
		objectKey.String(*v.ListenerArn)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.PageSize != nil {
		objectKey := object.Key("PageSize")
		objectKey.Integer(*v.PageSize)
	}

	if v.RuleArns != nil {
		objectKey := object.Key("RuleArns")
		if err := awsAwsquery_serializeDocumentRuleArns(v.RuleArns, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeSSLPoliciesInput(v *DescribeSSLPoliciesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.Names != nil {
		objectKey := object.Key("Names")
		if err := awsAwsquery_serializeDocumentSslPolicyNames(v.Names, objectKey); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		objectKey := object.Key("PageSize")
		objectKey.Integer(*v.PageSize)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeTagsInput(v *DescribeTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ResourceArns != nil {
		objectKey := object.Key("ResourceArns")
		if err := awsAwsquery_serializeDocumentResourceArns(v.ResourceArns, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeTargetGroupAttributesInput(v *DescribeTargetGroupAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TargetGroupArn != nil {
		objectKey := object.Key("TargetGroupArn")
		objectKey.String(*v.TargetGroupArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeTargetGroupsInput(v *DescribeTargetGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerArn != nil {
		objectKey := object.Key("LoadBalancerArn")
		objectKey.String(*v.LoadBalancerArn)
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.Names != nil {
		objectKey := object.Key("Names")
		if err := awsAwsquery_serializeDocumentTargetGroupNames(v.Names, objectKey); err != nil {
			return err
		}
	}

	if v.PageSize != nil {
		objectKey := object.Key("PageSize")
		objectKey.Integer(*v.PageSize)
	}

	if v.TargetGroupArns != nil {
		objectKey := object.Key("TargetGroupArns")
		if err := awsAwsquery_serializeDocumentTargetGroupArns(v.TargetGroupArns, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeTargetHealthInput(v *DescribeTargetHealthInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TargetGroupArn != nil {
		objectKey := object.Key("TargetGroupArn")
		objectKey.String(*v.TargetGroupArn)
	}

	if v.Targets != nil {
		objectKey := object.Key("Targets")
		if err := awsAwsquery_serializeDocumentTargetDescriptions(v.Targets, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyListenerInput(v *ModifyListenerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AlpnPolicy != nil {
		objectKey := object.Key("AlpnPolicy")
		if err := awsAwsquery_serializeDocumentAlpnPolicyName(v.AlpnPolicy, objectKey); err != nil {
			return err
		}
	}

	if v.Certificates != nil {
		objectKey := object.Key("Certificates")
		if err := awsAwsquery_serializeDocumentCertificateList(v.Certificates, objectKey); err != nil {
			return err
		}
	}

	if v.DefaultActions != nil {
		objectKey := object.Key("DefaultActions")
		if err := awsAwsquery_serializeDocumentActions(v.DefaultActions, objectKey); err != nil {
			return err
		}
	}

	if v.ListenerArn != nil {
		objectKey := object.Key("ListenerArn")
		objectKey.String(*v.ListenerArn)
	}

	if v.Port != nil {
		objectKey := object.Key("Port")
		objectKey.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	if v.SslPolicy != nil {
		objectKey := object.Key("SslPolicy")
		objectKey.String(*v.SslPolicy)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyLoadBalancerAttributesInput(v *ModifyLoadBalancerAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Attributes != nil {
		objectKey := object.Key("Attributes")
		if err := awsAwsquery_serializeDocumentLoadBalancerAttributes(v.Attributes, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerArn != nil {
		objectKey := object.Key("LoadBalancerArn")
		objectKey.String(*v.LoadBalancerArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyRuleInput(v *ModifyRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Actions != nil {
		objectKey := object.Key("Actions")
		if err := awsAwsquery_serializeDocumentActions(v.Actions, objectKey); err != nil {
			return err
		}
	}

	if v.Conditions != nil {
		objectKey := object.Key("Conditions")
		if err := awsAwsquery_serializeDocumentRuleConditionList(v.Conditions, objectKey); err != nil {
			return err
		}
	}

	if v.RuleArn != nil {
		objectKey := object.Key("RuleArn")
		objectKey.String(*v.RuleArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyTargetGroupAttributesInput(v *ModifyTargetGroupAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Attributes != nil {
		objectKey := object.Key("Attributes")
		if err := awsAwsquery_serializeDocumentTargetGroupAttributes(v.Attributes, objectKey); err != nil {
			return err
		}
	}

	if v.TargetGroupArn != nil {
		objectKey := object.Key("TargetGroupArn")
		objectKey.String(*v.TargetGroupArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyTargetGroupInput(v *ModifyTargetGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HealthCheckEnabled != nil {
		objectKey := object.Key("HealthCheckEnabled")
		objectKey.Boolean(*v.HealthCheckEnabled)
	}

	if v.HealthCheckIntervalSeconds != nil {
		objectKey := object.Key("HealthCheckIntervalSeconds")
		objectKey.Integer(*v.HealthCheckIntervalSeconds)
	}

	if v.HealthCheckPath != nil {
		objectKey := object.Key("HealthCheckPath")
		objectKey.String(*v.HealthCheckPath)
	}

	if v.HealthCheckPort != nil {
		objectKey := object.Key("HealthCheckPort")
		objectKey.String(*v.HealthCheckPort)
	}

	if len(v.HealthCheckProtocol) > 0 {
		objectKey := object.Key("HealthCheckProtocol")
		objectKey.String(string(v.HealthCheckProtocol))
	}

	if v.HealthCheckTimeoutSeconds != nil {
		objectKey := object.Key("HealthCheckTimeoutSeconds")
		objectKey.Integer(*v.HealthCheckTimeoutSeconds)
	}

	if v.HealthyThresholdCount != nil {
		objectKey := object.Key("HealthyThresholdCount")
		objectKey.Integer(*v.HealthyThresholdCount)
	}

	if v.Matcher != nil {
		objectKey := object.Key("Matcher")
		if err := awsAwsquery_serializeDocumentMatcher(v.Matcher, objectKey); err != nil {
			return err
		}
	}

	if v.TargetGroupArn != nil {
		objectKey := object.Key("TargetGroupArn")
		objectKey.String(*v.TargetGroupArn)
	}

	if v.UnhealthyThresholdCount != nil {
		objectKey := object.Key("UnhealthyThresholdCount")
		objectKey.Integer(*v.UnhealthyThresholdCount)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRegisterTargetsInput(v *RegisterTargetsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.TargetGroupArn != nil {
		objectKey := object.Key("TargetGroupArn")
		objectKey.String(*v.TargetGroupArn)
	}

	if v.Targets != nil {
		objectKey := object.Key("Targets")
		if err := awsAwsquery_serializeDocumentTargetDescriptions(v.Targets, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRemoveListenerCertificatesInput(v *RemoveListenerCertificatesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Certificates != nil {
		objectKey := object.Key("Certificates")
		if err := awsAwsquery_serializeDocumentCertificateList(v.Certificates, objectKey); err != nil {
			return err
		}
	}

	if v.ListenerArn != nil {
		objectKey := object.Key("ListenerArn")
		objectKey.String(*v.ListenerArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRemoveTagsInput(v *RemoveTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ResourceArns != nil {
		objectKey := object.Key("ResourceArns")
		if err := awsAwsquery_serializeDocumentResourceArns(v.ResourceArns, objectKey); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeys(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetIpAddressTypeInput(v *SetIpAddressTypeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.IpAddressType) > 0 {
		objectKey := object.Key("IpAddressType")
		objectKey.String(string(v.IpAddressType))
	}

	if v.LoadBalancerArn != nil {
		objectKey := object.Key("LoadBalancerArn")
		objectKey.String(*v.LoadBalancerArn)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetRulePrioritiesInput(v *SetRulePrioritiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RulePriorities != nil {
		objectKey := object.Key("RulePriorities")
		if err := awsAwsquery_serializeDocumentRulePriorityList(v.RulePriorities, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetSecurityGroupsInput(v *SetSecurityGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerArn != nil {
		objectKey := object.Key("LoadBalancerArn")
		objectKey.String(*v.LoadBalancerArn)
	}

	if v.SecurityGroups != nil {
		objectKey := object.Key("SecurityGroups")
		if err := awsAwsquery_serializeDocumentSecurityGroups(v.SecurityGroups, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetSubnetsInput(v *SetSubnetsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.IpAddressType) > 0 {
		objectKey := object.Key("IpAddressType")
		objectKey.String(string(v.IpAddressType))
	}

	if v.LoadBalancerArn != nil {
		objectKey := object.Key("LoadBalancerArn")
		objectKey.String(*v.LoadBalancerArn)
	}

	if v.SubnetMappings != nil {
		objectKey := object.Key("SubnetMappings")
		if err := awsAwsquery_serializeDocumentSubnetMappings(v.SubnetMappings, objectKey); err != nil {
			return err
		}
	}

	if v.Subnets != nil {
		objectKey := object.Key("Subnets")
		if err := awsAwsquery_serializeDocumentSubnets(v.Subnets, objectKey); err != nil {
			return err
		}
	}

	return nil
}
