// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribe

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/transcribe/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates a vocabulary with new values that you provide in a different text file
// from the one you used to create the vocabulary. The UpdateMedicalVocabulary
// operation overwrites all of the existing information with the values that you
// provide in the request.
func (c *Client) UpdateMedicalVocabulary(ctx context.Context, params *UpdateMedicalVocabularyInput, optFns ...func(*Options)) (*UpdateMedicalVocabularyOutput, error) {
	if params == nil {
		params = &UpdateMedicalVocabularyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateMedicalVocabulary", params, optFns, c.addOperationUpdateMedicalVocabularyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateMedicalVocabularyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateMedicalVocabularyInput struct {

	// The language code of the language used for the entries in the updated
	// vocabulary. US English (en-US) is the only valid language code in Amazon
	// Transcribe Medical.
	//
	// This member is required.
	LanguageCode types.LanguageCode

	// The name of the vocabulary to update. The name is case sensitive. If you try to
	// update a vocabulary with the same name as a vocabulary you've already made, you
	// get a ConflictException error.
	//
	// This member is required.
	VocabularyName *string

	// The location in Amazon S3 of the text file that contains your custom vocabulary.
	// The URI must be in the same Amazon Web Services Region as the resource that you
	// are calling. The following is the format for a URI:
	// https://s3..amazonaws.com///  For example:
	// https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt For more
	// information about Amazon S3 object names, see Object Keys
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide. For more information about custom vocabularies
	// in Amazon Transcribe Medical, see Medical Custom Vocabularies
	// (https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary).
	VocabularyFileUri *string

	noSmithyDocumentSerde
}

type UpdateMedicalVocabularyOutput struct {

	// The language code for the language of the text file used to update the custom
	// vocabulary. US English (en-US) is the only language supported in Amazon
	// Transcribe Medical.
	LanguageCode types.LanguageCode

	// The date and time that the vocabulary was updated.
	LastModifiedTime *time.Time

	// The name of the updated vocabulary.
	VocabularyName *string

	// The processing state of the update to the vocabulary. When the VocabularyState
	// field is READY, the vocabulary is ready to be used in a
	// StartMedicalTranscriptionJob request.
	VocabularyState types.VocabularyState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateMedicalVocabularyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateMedicalVocabulary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateMedicalVocabulary{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateMedicalVocabularyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateMedicalVocabulary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateMedicalVocabulary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "transcribe",
		OperationName: "UpdateMedicalVocabulary",
	}
}
