// Code generated by smithy-go-codegen DO NOT EDIT.

package synthetics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/synthetics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This operation returns a list of the canaries in your account, along with full
// details about each canary. This operation does not have resource-level
// authorization, so if a user is able to use DescribeCanaries, the user can see
// all of the canaries in the account. A deny policy can only be used to restrict
// access to all canaries. It cannot be used on specific resources.
func (c *Client) DescribeCanaries(ctx context.Context, params *DescribeCanariesInput, optFns ...func(*Options)) (*DescribeCanariesOutput, error) {
	if params == nil {
		params = &DescribeCanariesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeCanaries", params, optFns, c.addOperationDescribeCanariesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeCanariesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeCanariesInput struct {

	// Specify this parameter to limit how many canaries are returned each time you use
	// the DescribeCanaries operation. If you omit this parameter, the default of 100
	// is used.
	MaxResults *int32

	// A token that indicates that there is more data available. You can use this token
	// in a subsequent operation to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeCanariesOutput struct {

	// Returns an array. Each item in the array contains the full information about one
	// canary.
	Canaries []types.Canary

	// A token that indicates that there is more data available. You can use this token
	// in a subsequent DescribeCanaries operation to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeCanariesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeCanaries{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeCanaries{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeCanaries(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeCanariesAPIClient is a client that implements the DescribeCanaries
// operation.
type DescribeCanariesAPIClient interface {
	DescribeCanaries(context.Context, *DescribeCanariesInput, ...func(*Options)) (*DescribeCanariesOutput, error)
}

var _ DescribeCanariesAPIClient = (*Client)(nil)

// DescribeCanariesPaginatorOptions is the paginator options for DescribeCanaries
type DescribeCanariesPaginatorOptions struct {
	// Specify this parameter to limit how many canaries are returned each time you use
	// the DescribeCanaries operation. If you omit this parameter, the default of 100
	// is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeCanariesPaginator is a paginator for DescribeCanaries
type DescribeCanariesPaginator struct {
	options   DescribeCanariesPaginatorOptions
	client    DescribeCanariesAPIClient
	params    *DescribeCanariesInput
	nextToken *string
	firstPage bool
}

// NewDescribeCanariesPaginator returns a new DescribeCanariesPaginator
func NewDescribeCanariesPaginator(client DescribeCanariesAPIClient, params *DescribeCanariesInput, optFns ...func(*DescribeCanariesPaginatorOptions)) *DescribeCanariesPaginator {
	if params == nil {
		params = &DescribeCanariesInput{}
	}

	options := DescribeCanariesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeCanariesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeCanariesPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next DescribeCanaries page.
func (p *DescribeCanariesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeCanariesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeCanaries(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeCanaries(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "synthetics",
		OperationName: "DescribeCanaries",
	}
}
