// Code generated by smithy-go-codegen DO NOT EDIT.

package storagegateway

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sends you notification through CloudWatch Events when all files written to your
// file share have been uploaded to Amazon S3. Storage Gateway can send a
// notification through Amazon CloudWatch Events when all files written to your
// file share up to that point in time have been uploaded to Amazon S3. These files
// include files written to the file share up to the time that you make a request
// for notification. When the upload is done, Storage Gateway sends you
// notification through an Amazon CloudWatch Event. You can configure CloudWatch
// Events to send the notification through event targets such as Amazon SNS or
// Lambda function. This operation is only supported for S3 File Gateways. For more
// information, see Getting file upload notification
// (https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-upload-notification)
// in the Storage Gateway User Guide.
func (c *Client) NotifyWhenUploaded(ctx context.Context, params *NotifyWhenUploadedInput, optFns ...func(*Options)) (*NotifyWhenUploadedOutput, error) {
	if params == nil {
		params = &NotifyWhenUploadedInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "NotifyWhenUploaded", params, optFns, c.addOperationNotifyWhenUploadedMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*NotifyWhenUploadedOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type NotifyWhenUploadedInput struct {

	// The Amazon Resource Name (ARN) of the file share.
	//
	// This member is required.
	FileShareARN *string

	noSmithyDocumentSerde
}

type NotifyWhenUploadedOutput struct {

	// The Amazon Resource Name (ARN) of the file share.
	FileShareARN *string

	// The randomly generated ID of the notification that was sent. This ID is in UUID
	// format.
	NotificationId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationNotifyWhenUploadedMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpNotifyWhenUploaded{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpNotifyWhenUploaded{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpNotifyWhenUploadedValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opNotifyWhenUploaded(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opNotifyWhenUploaded(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "storagegateway",
		OperationName: "NotifyWhenUploaded",
	}
}
