// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information about the contact channel that Incident Manager uses to engage the
// contact.
type ChannelTargetInfo struct {

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// This member is required.
	ContactChannelId *string

	// The number of minutes to wait to retry sending engagement in the case the
	// engagement initially fails.
	RetryIntervalInMinutes *int32

	noSmithyDocumentSerde
}

// A personal contact or escalation plan that Incident Manager engages during an
// incident.
type Contact struct {

	// The unique and identifiable alias of the contact or escalation plan.
	//
	// This member is required.
	Alias *string

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// This member is required.
	ContactArn *string

	// Refers to the type of contact. A single contact is type PERSONAL and an
	// escalation plan is type ESCALATION.
	//
	// This member is required.
	Type ContactType

	// The full name of the contact or escalation plan.
	DisplayName *string

	noSmithyDocumentSerde
}

// The method that Incident Manager uses to engage a contact.
type ContactChannel struct {

	// A Boolean value describing if the contact channel has been activated or not. If
	// the contact channel isn't activated, Incident Manager can't engage the contact
	// through it.
	//
	// This member is required.
	ActivationStatus ActivationStatus

	// The ARN of the contact that contains the contact channel.
	//
	// This member is required.
	ContactArn *string

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// This member is required.
	ContactChannelArn *string

	// The details that Incident Manager uses when trying to engage the contact
	// channel.
	//
	// This member is required.
	DeliveryAddress *ContactChannelAddress

	// The name of the contact channel.
	//
	// This member is required.
	Name *string

	// The type of the contact channel. Incident Manager supports three contact
	// methods:
	//
	// * SMS
	//
	// * VOICE
	//
	// * EMAIL
	Type ChannelType

	noSmithyDocumentSerde
}

// The details that Incident Manager uses when trying to engage the contact
// channel.
type ContactChannelAddress struct {

	// The format is dependent on the type of the contact channel. The following are
	// the expected formats:
	//
	// * SMS - '+' followed by the country code and phone
	// number
	//
	// * VOICE - '+' followed by the country code and phone number
	//
	// * EMAIL -
	// any standard email format
	SimpleAddress *string

	noSmithyDocumentSerde
}

// The contact that Incident Manager is engaging during an incident.
type ContactTargetInfo struct {

	// A Boolean value determining if the contact's acknowledgement stops the progress
	// of stages in the plan.
	//
	// This member is required.
	IsEssential *bool

	// The Amazon Resource Name (ARN) of the contact.
	ContactId *string

	noSmithyDocumentSerde
}

// Incident Manager reaching out to a contact or escalation plan to engage contact
// during an incident.
type Engagement struct {

	// The ARN of the escalation plan or contact that Incident Manager is engaging.
	//
	// This member is required.
	ContactArn *string

	// The Amazon Resource Name (ARN) of the engagement.
	//
	// This member is required.
	EngagementArn *string

	// The user that started the engagement.
	//
	// This member is required.
	Sender *string

	// The ARN of the incident that's engaging the contact.
	IncidentId *string

	// The time that the engagement began.
	StartTime *time.Time

	// The time that the engagement ended.
	StopTime *time.Time

	noSmithyDocumentSerde
}

// Incident Manager engaging a contact's contact channel.
type Page struct {

	// The ARN of the contact that Incident Manager is engaging.
	//
	// This member is required.
	ContactArn *string

	// The ARN of the engagement that this page is part of.
	//
	// This member is required.
	EngagementArn *string

	// The Amazon Resource Name (ARN) of the page to the contact channel.
	//
	// This member is required.
	PageArn *string

	// The user that started the engagement.
	//
	// This member is required.
	Sender *string

	// The time the message was delivered to the contact channel.
	DeliveryTime *time.Time

	// The ARN of the incident that's engaging the contact channel.
	IncidentId *string

	// The time that the contact channel acknowledged engagement.
	ReadTime *time.Time

	// The time that Incident Manager engaged the contact channel.
	SentTime *time.Time

	noSmithyDocumentSerde
}

// The stages that an escalation plan or engagement plan engages contacts and
// contact methods in.
type Plan struct {

	// A list of stages that the escalation plan or engagement plan uses to engage
	// contacts and contact methods.
	//
	// This member is required.
	Stages []Stage

	noSmithyDocumentSerde
}

// Records events during an engagement.
type Receipt struct {

	// The time receipt was SENT, DELIVERED, or READ.
	//
	// This member is required.
	ReceiptTime *time.Time

	// The type follows the engagement cycle, SENT, DELIVERED, and READ.
	//
	// This member is required.
	ReceiptType ReceiptType

	// The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
	ContactChannelArn *string

	// Information provided during the page acknowledgement.
	ReceiptInfo *string

	noSmithyDocumentSerde
}

// A set amount of time that an escalation plan or engagement plan engages the
// specified contacts or contact methods.
type Stage struct {

	// The time to wait until beginning the next stage. The duration can only be set to
	// 0 if a target is specified.
	//
	// This member is required.
	DurationInMinutes *int32

	// The contacts or contact methods that the escalation plan or engagement plan is
	// engaging.
	//
	// This member is required.
	Targets []Target

	noSmithyDocumentSerde
}

// A container of a key-value name pair.
type Tag struct {

	// Name of the object key.
	Key *string

	// Value of the tag.
	Value *string

	noSmithyDocumentSerde
}

// The contact or contact channel that is being engaged.
type Target struct {

	// Information about the contact channel Incident Manager is engaging.
	ChannelTargetInfo *ChannelTargetInfo

	// Information about the contact that Incident Manager is engaging.
	ContactTargetInfo *ContactTargetInfo

	noSmithyDocumentSerde
}

// A range of between two set times
type TimeRange struct {

	// The end of the time range.
	EndTime *time.Time

	// The start of the time range.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Provides information about which field caused the exception.
type ValidationExceptionField struct {

	// Information about what caused the field to cause an exception.
	//
	// This member is required.
	Message *string

	// The name of the field that caused the exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
