// Code generated by smithy-go-codegen DO NOT EDIT.

package s3

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	s3cust "github.com/aws/aws-sdk-go-v2/service/s3/internal/customizations"
	"github.com/aws/aws-sdk-go-v2/service/s3/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Puts a S3 Intelligent-Tiering configuration to the specified bucket. You can
// have up to 1,000 S3 Intelligent-Tiering configurations per bucket. The S3
// Intelligent-Tiering storage class is designed to optimize storage costs by
// automatically moving data to the most cost-effective storage access tier,
// without additional operational overhead. S3 Intelligent-Tiering delivers
// automatic cost savings by moving data between access tiers, when access patterns
// change. The S3 Intelligent-Tiering storage class is suitable for objects larger
// than 128 KB that you plan to store for at least 30 days. If the size of an
// object is less than 128 KB, it is not eligible for auto-tiering. Smaller objects
// can be stored, but they are always charged at the frequent access tier rates in
// the S3 Intelligent-Tiering storage class. If you delete an object before the end
// of the 30-day minimum storage duration period, you are charged for 30 days. For
// more information, see Storage class for automatically optimizing frequently and
// infrequently accessed objects
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access).
// Operations related to PutBucketIntelligentTieringConfiguration include:
//
// *
// DeleteBucketIntelligentTieringConfiguration
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html)
//
// *
// GetBucketIntelligentTieringConfiguration
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html)
//
// *
// ListBucketIntelligentTieringConfigurations
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html)
//
// You
// only need S3 Intelligent-Tiering enabled on a bucket if you want to
// automatically move objects stored in the S3 Intelligent-Tiering storage class to
// the Archive Access or Deep Archive Access tier. Special Errors
//
// * HTTP 400 Bad
// Request Error
//
// * Code: InvalidArgument
//
// * Cause: Invalid Argument
//
// * HTTP 400
// Bad Request Error
//
// * Code: TooManyConfigurations
//
// * Cause: You are attempting to
// create a new configuration but have already reached the 1,000-configuration
// limit.
//
// * HTTP 403 Forbidden Error
//
// * Code: AccessDenied
//
// * Cause: You are not
// the owner of the specified bucket, or you do not have the
// s3:PutIntelligentTieringConfiguration bucket permission to set the configuration
// on the bucket.
func (c *Client) PutBucketIntelligentTieringConfiguration(ctx context.Context, params *PutBucketIntelligentTieringConfigurationInput, optFns ...func(*Options)) (*PutBucketIntelligentTieringConfigurationOutput, error) {
	if params == nil {
		params = &PutBucketIntelligentTieringConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutBucketIntelligentTieringConfiguration", params, optFns, c.addOperationPutBucketIntelligentTieringConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutBucketIntelligentTieringConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutBucketIntelligentTieringConfigurationInput struct {

	// The name of the Amazon S3 bucket whose configuration you want to modify or
	// retrieve.
	//
	// This member is required.
	Bucket *string

	// The ID used to identify the S3 Intelligent-Tiering configuration.
	//
	// This member is required.
	Id *string

	// Container for S3 Intelligent-Tiering configuration.
	//
	// This member is required.
	IntelligentTieringConfiguration *types.IntelligentTieringConfiguration

	noSmithyDocumentSerde
}

type PutBucketIntelligentTieringConfigurationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutBucketIntelligentTieringConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestxml_serializeOpPutBucketIntelligentTieringConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpPutBucketIntelligentTieringConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutBucketIntelligentTieringConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutBucketIntelligentTieringConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addMetadataRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addPutBucketIntelligentTieringConfigurationUpdateEndpoint(stack, options); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = v4.AddContentSHA256HeaderMiddleware(stack); err != nil {
		return err
	}
	if err = disableAcceptEncodingGzip(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutBucketIntelligentTieringConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "s3",
		OperationName: "PutBucketIntelligentTieringConfiguration",
	}
}

// getPutBucketIntelligentTieringConfigurationBucketMember returns a pointer to
// string denoting a provided bucket member valueand a boolean indicating if the
// input has a modeled bucket name,
func getPutBucketIntelligentTieringConfigurationBucketMember(input interface{}) (*string, bool) {
	in := input.(*PutBucketIntelligentTieringConfigurationInput)
	if in.Bucket == nil {
		return nil, false
	}
	return in.Bucket, true
}
func addPutBucketIntelligentTieringConfigurationUpdateEndpoint(stack *middleware.Stack, options Options) error {
	return s3cust.UpdateEndpoint(stack, s3cust.UpdateEndpointOptions{
		Accessor: s3cust.UpdateEndpointParameterAccessor{
			GetBucketFromInput: getPutBucketIntelligentTieringConfigurationBucketMember,
		},
		UsePathStyle:            options.UsePathStyle,
		UseAccelerate:           options.UseAccelerate,
		SupportsAccelerate:      true,
		TargetS3ObjectLambda:    false,
		EndpointResolver:        options.EndpointResolver,
		EndpointResolverOptions: options.EndpointOptions,
		UseDualstack:            options.UseDualstack,
		UseARNRegion:            options.UseARNRegion,
	})
}
