// Code generated by smithy-go-codegen DO NOT EDIT.

package rds

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a custom Availability Zone (AZ). A custom AZ is an on-premises AZ that
// is integrated with a VMware vSphere cluster. For more information about RDS on
// VMware, see the  RDS on VMware User Guide.
// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
func (c *Client) CreateCustomAvailabilityZone(ctx context.Context, params *CreateCustomAvailabilityZoneInput, optFns ...func(*Options)) (*CreateCustomAvailabilityZoneOutput, error) {
	if params == nil {
		params = &CreateCustomAvailabilityZoneInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCustomAvailabilityZone", params, optFns, c.addOperationCreateCustomAvailabilityZoneMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateCustomAvailabilityZoneOutput)
	out.ResultMetadata = metadata
	return out, nil
}

//
type CreateCustomAvailabilityZoneInput struct {

	// The name of the custom Availability Zone (AZ).
	//
	// This member is required.
	CustomAvailabilityZoneName *string

	// The ID of an existing virtual private network (VPN) between the Amazon RDS
	// website and the VMware vSphere cluster.
	ExistingVpnId *string

	// The name of a new VPN tunnel between the Amazon RDS website and the VMware
	// vSphere cluster. Specify this parameter only if ExistingVpnId isn't specified.
	NewVpnTunnelName *string

	// The IP address of network traffic from your on-premises data center. A custom AZ
	// receives the network traffic. Specify this parameter only if ExistingVpnId isn't
	// specified.
	VpnTunnelOriginatorIP *string

	noSmithyDocumentSerde
}

type CreateCustomAvailabilityZoneOutput struct {

	// A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a
	// VMware vSphere cluster. For more information about RDS on VMware, see the  RDS
	// on VMware User Guide.
	// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
	CustomAvailabilityZone *types.CustomAvailabilityZone

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateCustomAvailabilityZoneMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateCustomAvailabilityZone{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateCustomAvailabilityZone{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateCustomAvailabilityZoneValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCustomAvailabilityZone(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateCustomAvailabilityZone(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "rds",
		OperationName: "CreateCustomAvailabilityZone",
	}
}
