// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The AWS Proton pipeline service role data.
type AccountSettings struct {

	// The Amazon Resource Name (ARN) of the AWS Proton pipeline service role.
	PipelineServiceRoleArn *string

	noSmithyDocumentSerde
}

// Compatible environment template data.
type CompatibleEnvironmentTemplate struct {

	// The major version of the compatible environment template.
	//
	// This member is required.
	MajorVersion *string

	// The compatible environment template name.
	//
	// This member is required.
	TemplateName *string

	noSmithyDocumentSerde
}

// Compatible environment template data.
type CompatibleEnvironmentTemplateInput struct {

	// The major version of the compatible environment template.
	//
	// This member is required.
	MajorVersion *string

	// The compatible environment template name.
	//
	// This member is required.
	TemplateName *string

	noSmithyDocumentSerde
}

// The environment detail data. An AWS Proton environment is a set resources shared
// across an AWS Proton service.
type Environment struct {

	// The Amazon Resource Name (ARN) of the environment.
	//
	// This member is required.
	Arn *string

	// The time when the environment was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The environment deployment status.
	//
	// This member is required.
	DeploymentStatus DeploymentStatus

	// The time when a deployment of the environment was last attempted.
	//
	// This member is required.
	LastDeploymentAttemptedAt *time.Time

	// The time when the environment was last deployed successfully.
	//
	// This member is required.
	LastDeploymentSucceededAt *time.Time

	// The name of the environment.
	//
	// This member is required.
	Name *string

	// The ID of the major version of the environment template.
	//
	// This member is required.
	TemplateMajorVersion *string

	// The ID of the minor version of the environment template.
	//
	// This member is required.
	TemplateMinorVersion *string

	// The Amazon Resource Name (ARN) of the environment template.
	//
	// This member is required.
	TemplateName *string

	// An environment deployment status message.
	DeploymentStatusMessage *string

	// The description of the environment.
	Description *string

	// The ID of the environment account connection that's used to provision
	// infrastructure resources in an environment account.
	EnvironmentAccountConnectionId *string

	// The ID of the environment account that the environment infrastructure resources
	// are provisioned in.
	EnvironmentAccountId *string

	// The Amazon Resource Name (ARN) of the AWS Proton service role that allows AWS
	// Proton to make calls to other services on your behalf.
	ProtonServiceRoleArn *string

	// When included, indicates that the environment template is for customer
	// provisioned and managed infrastructure.
	Provisioning Provisioning

	// The environment spec.
	//
	// This value conforms to the media type: application/yaml
	Spec *string

	noSmithyDocumentSerde
}

// The environment account connection detail data.
type EnvironmentAccountConnection struct {

	// The Amazon Resource Name (ARN) of the environment account connection.
	//
	// This member is required.
	Arn *string

	// The environment account that's connected to the environment account connection.
	//
	// This member is required.
	EnvironmentAccountId *string

	// The name of the environment that's associated with the environment account
	// connection.
	//
	// This member is required.
	EnvironmentName *string

	// The ID of the environment account connection.
	//
	// This member is required.
	Id *string

	// The time when the environment account connection was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The ID of the management account that's connected to the environment account
	// connection.
	//
	// This member is required.
	ManagementAccountId *string

	// The time when the environment account connection request was made.
	//
	// This member is required.
	RequestedAt *time.Time

	// The IAM service role that's associated with the environment account connection.
	//
	// This member is required.
	RoleArn *string

	// The status of the environment account connection.
	//
	// This member is required.
	Status EnvironmentAccountConnectionStatus

	noSmithyDocumentSerde
}

// A summary of the environment account connection detail data.
type EnvironmentAccountConnectionSummary struct {

	// The Amazon Resource Name (ARN) of the environment account connection.
	//
	// This member is required.
	Arn *string

	// The ID of the environment account that's connected to the environment account
	// connection.
	//
	// This member is required.
	EnvironmentAccountId *string

	// The name of the environment that's associated with the environment account
	// connection.
	//
	// This member is required.
	EnvironmentName *string

	// The ID of the environment account connection.
	//
	// This member is required.
	Id *string

	// The time when the environment account connection was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The ID of the management account that's connected to the environment account
	// connection.
	//
	// This member is required.
	ManagementAccountId *string

	// The time when the environment account connection request was made.
	//
	// This member is required.
	RequestedAt *time.Time

	// The IAM service role that's associated with the environment account connection.
	//
	// This member is required.
	RoleArn *string

	// The status of the environment account connection.
	//
	// This member is required.
	Status EnvironmentAccountConnectionStatus

	noSmithyDocumentSerde
}

// A summary of the environment detail data.
type EnvironmentSummary struct {

	// The Amazon Resource Name (ARN) of the environment.
	//
	// This member is required.
	Arn *string

	// The time when the environment was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The environment deployment status.
	//
	// This member is required.
	DeploymentStatus DeploymentStatus

	// The time when a deployment of the environment was last attempted.
	//
	// This member is required.
	LastDeploymentAttemptedAt *time.Time

	// The time when the environment was last deployed successfully.
	//
	// This member is required.
	LastDeploymentSucceededAt *time.Time

	// The name of the environment.
	//
	// This member is required.
	Name *string

	// The ID of the major version of the environment template.
	//
	// This member is required.
	TemplateMajorVersion *string

	// The ID of the minor version of the environment template.
	//
	// This member is required.
	TemplateMinorVersion *string

	// The name of the environment template.
	//
	// This member is required.
	TemplateName *string

	// An environment deployment status message.
	DeploymentStatusMessage *string

	// The description of the environment.
	Description *string

	// The ID of the environment account connection that the environment is associated
	// with.
	EnvironmentAccountConnectionId *string

	// The ID of the environment account that the environment infrastructure resources
	// are provisioned in.
	EnvironmentAccountId *string

	// The Amazon Resource Name (ARN) of the AWS Proton service role that allows AWS
	// Proton to make calls to other services on your behalf.
	ProtonServiceRoleArn *string

	// When included, indicates that the environment template is for customer
	// provisioned and managed infrastructure.
	Provisioning Provisioning

	noSmithyDocumentSerde
}

// The environment template data.
type EnvironmentTemplate struct {

	// The Amazon Resource Name (ARN) of the environment template.
	//
	// This member is required.
	Arn *string

	// The time when the environment template was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time when the environment template was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The name of the environment template.
	//
	// This member is required.
	Name *string

	// A description of the environment template.
	Description *string

	// The name of the environment template as displayed in the developer interface.
	DisplayName *string

	// The customer provided encryption key for the environment template.
	EncryptionKey *string

	// When included, indicates that the environment template is for customer
	// provisioned and managed infrastructure.
	Provisioning Provisioning

	// The ID of the recommended version of the environment template.
	RecommendedVersion *string

	noSmithyDocumentSerde
}

// A search filter for environment templates.
type EnvironmentTemplateFilter struct {

	// Include majorVersion to filter search for a major version.
	//
	// This member is required.
	MajorVersion *string

	// Include templateName to filter search for a template name.
	//
	// This member is required.
	TemplateName *string

	noSmithyDocumentSerde
}

// The environment template data.
type EnvironmentTemplateSummary struct {

	// The Amazon Resource Name (ARN) of the environment template.
	//
	// This member is required.
	Arn *string

	// The time when the environment template was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time when the environment template was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The name of the environment template.
	//
	// This member is required.
	Name *string

	// A description of the environment template.
	Description *string

	// The name of the environment template as displayed in the developer interface.
	DisplayName *string

	// When included, indicates that the environment template is for customer
	// provisioned and managed infrastructure.
	Provisioning Provisioning

	// The ID of the recommended version of the environment template.
	RecommendedVersion *string

	noSmithyDocumentSerde
}

// The environment template version data.
type EnvironmentTemplateVersion struct {

	// The Amazon Resource Name (ARN) of the version of an environment template.
	//
	// This member is required.
	Arn *string

	// The time when the version of an environment template was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time when the version of an environment template was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The ID of the latest major version that's associated with the version of an
	// environment template.
	//
	// This member is required.
	MajorVersion *string

	// The ID of the minor version of an environment template.
	//
	// This member is required.
	MinorVersion *string

	// The status of the version of an environment template.
	//
	// This member is required.
	Status TemplateVersionStatus

	// The name of the version of an environment template.
	//
	// This member is required.
	TemplateName *string

	// A description of the minor version of an environment template.
	Description *string

	// The ID of the recommended minor version of the environment template.
	RecommendedMinorVersion *string

	// The schema of the version of an environment template.
	//
	// This value conforms to the media type: application/yaml
	Schema *string

	// The status message of the version of an environment template.
	StatusMessage *string

	noSmithyDocumentSerde
}

// A summary of the version of an environment template detail data.
type EnvironmentTemplateVersionSummary struct {

	// The Amazon Resource Name (ARN) of the version of an environment template.
	//
	// This member is required.
	Arn *string

	// The time when the version of an environment template was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time when the version of an environment template was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The ID of the latest major version that's associated with the version of an
	// environment template.
	//
	// This member is required.
	MajorVersion *string

	// The ID of the version of an environment template.
	//
	// This member is required.
	MinorVersion *string

	// The status of the version of an environment template.
	//
	// This member is required.
	Status TemplateVersionStatus

	// The name of the version of an environment template.
	//
	// This member is required.
	TemplateName *string

	// A description of the version of an environment template.
	Description *string

	// The ID of the recommended minor version of the environment template.
	RecommendedMinorVersion *string

	// The status message of the version of an environment template.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Template bundle S3 bucket data.
type S3ObjectSource struct {

	// The name of the S3 bucket that contains a template bundle.
	//
	// This member is required.
	Bucket *string

	// The path to the S3 bucket that contains a template bundle.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// The service detail data.
type Service struct {

	// The Amazon Resource Name (ARN) of the service.
	//
	// This member is required.
	Arn *string

	// The time when the service was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time when the service was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The name of the service.
	//
	// This member is required.
	Name *string

	// The formatted specification that defines the service.
	//
	// This value conforms to the media type: application/yaml
	//
	// This member is required.
	Spec *string

	// The status of the service.
	//
	// This member is required.
	Status ServiceStatus

	// The name of the service template.
	//
	// This member is required.
	TemplateName *string

	// The name of the code repository branch that holds the code that's deployed in
	// AWS Proton.
	BranchName *string

	// A description of a service.
	Description *string

	// The service pipeline detail data.
	Pipeline *ServicePipeline

	// The Amazon Resource Name (ARN) of the repository connection. For more
	// information, see Set up a repository connection
	// (https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol)
	// in the AWS Proton Administrator Guide and Setting up with AWS Proton
	// (https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection)
	// in the AWS Proton User Guide.
	RepositoryConnectionArn *string

	// The ID of the code repository.
	RepositoryId *string

	// A service status message.
	StatusMessage *string

	noSmithyDocumentSerde
}

// The service instance detail data.
type ServiceInstance struct {

	// The Amazon Resource Name (ARN) of the service instance.
	//
	// This member is required.
	Arn *string

	// The time when the service instance was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The service instance deployment status.
	//
	// This member is required.
	DeploymentStatus DeploymentStatus

	// The name of the environment that the service instance was deployed into.
	//
	// This member is required.
	EnvironmentName *string

	// The time when a deployment of the service instance was last attempted.
	//
	// This member is required.
	LastDeploymentAttemptedAt *time.Time

	// The time when the service instance was last deployed successfully.
	//
	// This member is required.
	LastDeploymentSucceededAt *time.Time

	// The name of the service instance.
	//
	// This member is required.
	Name *string

	// The name of the service that the service instance belongs to.
	//
	// This member is required.
	ServiceName *string

	// The ID of the major version of the service template that was used to create the
	// service instance.
	//
	// This member is required.
	TemplateMajorVersion *string

	// The ID of the minor version of the service template that was used to create the
	// service instance.
	//
	// This member is required.
	TemplateMinorVersion *string

	// The name of the service template that was used to create the service instance.
	//
	// This member is required.
	TemplateName *string

	// A service instance deployment status message.
	DeploymentStatusMessage *string

	// The service spec that was used to create the service instance.
	//
	// This value conforms to the media type: application/yaml
	Spec *string

	noSmithyDocumentSerde
}

// A summary of the service instance detail data.
type ServiceInstanceSummary struct {

	// The Amazon Resource Name (ARN) of the service instance.
	//
	// This member is required.
	Arn *string

	// The time when the service instance was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The service instance deployment status.
	//
	// This member is required.
	DeploymentStatus DeploymentStatus

	// The name of the environment that the service instance was deployed into.
	//
	// This member is required.
	EnvironmentName *string

	// The time when a deployment of the service was last attempted.
	//
	// This member is required.
	LastDeploymentAttemptedAt *time.Time

	// The time when the service was last deployed successfully.
	//
	// This member is required.
	LastDeploymentSucceededAt *time.Time

	// The name of the service instance.
	//
	// This member is required.
	Name *string

	// The name of the service that the service instance belongs to.
	//
	// This member is required.
	ServiceName *string

	// The ID of the major version of a service template.
	//
	// This member is required.
	TemplateMajorVersion *string

	// The ID of the minor version of a service template.
	//
	// This member is required.
	TemplateMinorVersion *string

	// The name of the service template.
	//
	// This member is required.
	TemplateName *string

	// A service instance deployment status message.
	DeploymentStatusMessage *string

	noSmithyDocumentSerde
}

// The service pipeline detail data.
type ServicePipeline struct {

	// The Amazon Resource Name (ARN) of the service pipeline.
	//
	// This member is required.
	Arn *string

	// The time when the service pipeline was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The deployment status of the service pipeline.
	//
	// This member is required.
	DeploymentStatus DeploymentStatus

	// The time when a deployment of the service pipeline was last attempted.
	//
	// This member is required.
	LastDeploymentAttemptedAt *time.Time

	// The time when the service pipeline was last deployed successfully.
	//
	// This member is required.
	LastDeploymentSucceededAt *time.Time

	// The ID of the major version of the service template that was used to create the
	// service pipeline.
	//
	// This member is required.
	TemplateMajorVersion *string

	// The ID of the minor version of the service template that was used to create the
	// service pipeline.
	//
	// This member is required.
	TemplateMinorVersion *string

	// The name of the service template that was used to create the service pipeline.
	//
	// This member is required.
	TemplateName *string

	// A service pipeline deployment status message.
	DeploymentStatusMessage *string

	// The service spec that was used to create the service pipeline.
	//
	// This value conforms to the media type: application/yaml
	Spec *string

	noSmithyDocumentSerde
}

// A summary of the service detail data.
type ServiceSummary struct {

	// The Amazon Resource Name (ARN) of the service.
	//
	// This member is required.
	Arn *string

	// The time when the service was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time when the service was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The name of the service.
	//
	// This member is required.
	Name *string

	// The status of the service.
	//
	// This member is required.
	Status ServiceStatus

	// The name of the service template.
	//
	// This member is required.
	TemplateName *string

	// A description of the service.
	Description *string

	// A service status message.
	StatusMessage *string

	noSmithyDocumentSerde
}

// The service template detail data.
type ServiceTemplate struct {

	// The Amazon Resource Name (ARN) of the service template.
	//
	// This member is required.
	Arn *string

	// The time when the service template was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time when the service template was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The name of the service template.
	//
	// This member is required.
	Name *string

	// A description of the service template.
	Description *string

	// The service template name as displayed in the developer interface.
	DisplayName *string

	// The customer provided service template encryption key that's used to encrypt
	// data.
	EncryptionKey *string

	// If pipelineProvisioning is true, a service pipeline is included in the service
	// template. Otherwise, a service pipeline isn't included in the service template.
	PipelineProvisioning Provisioning

	// The ID of the recommended version of the service template.
	RecommendedVersion *string

	noSmithyDocumentSerde
}

// The service template summary data.
type ServiceTemplateSummary struct {

	// The Amazon Resource Name (ARN) of the service template.
	//
	// This member is required.
	Arn *string

	// The time when the service template was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time when the service template was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The name of the service template.
	//
	// This member is required.
	Name *string

	// A description of the service template.
	Description *string

	// The service template name as displayed in the developer interface.
	DisplayName *string

	// If pipelineProvisioning is true, a service pipeline is included in the service
	// template, otherwise a service pipeline isn't included in the service template.
	PipelineProvisioning Provisioning

	// The ID of the recommended version of the service template.
	RecommendedVersion *string

	noSmithyDocumentSerde
}

// The version of a service template detail data.
type ServiceTemplateVersion struct {

	// The Amazon Resource Name (ARN) of the version of a service template.
	//
	// This member is required.
	Arn *string

	// An array of compatible environment template names for the major version of a
	// service template.
	//
	// This member is required.
	CompatibleEnvironmentTemplates []CompatibleEnvironmentTemplate

	// The time when the version of a service template was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time when the version of a service template was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The ID of the latest major version that's associated with the version of a
	// service template.
	//
	// This member is required.
	MajorVersion *string

	// The ID of the minor version of a service template.
	//
	// This member is required.
	MinorVersion *string

	// The service template version status.
	//
	// This member is required.
	Status TemplateVersionStatus

	// The name of the version of a service template.
	//
	// This member is required.
	TemplateName *string

	// A description of the version of a service template.
	Description *string

	// The ID of the recommended minor version of the service template.
	RecommendedMinorVersion *string

	// The schema of the version of a service template.
	//
	// This value conforms to the media type: application/yaml
	Schema *string

	// A service template version status message.
	StatusMessage *string

	noSmithyDocumentSerde
}

// A summary of the service template version detail data.
type ServiceTemplateVersionSummary struct {

	// The Amazon Resource Name (ARN) of the version of a service template.
	//
	// This member is required.
	Arn *string

	// The time when the version of a service template was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time when the version of a service template was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The ID of the latest major version that's associated with the version of a
	// service template.
	//
	// This member is required.
	MajorVersion *string

	// The ID of the minor version of a service template.
	//
	// This member is required.
	MinorVersion *string

	// The service template minor version status.
	//
	// This member is required.
	Status TemplateVersionStatus

	// The name of the service template.
	//
	// This member is required.
	TemplateName *string

	// A description of the version of a service template.
	Description *string

	// The ID of the recommended minor version of the service template.
	RecommendedMinorVersion *string

	// A service template minor version status message.
	StatusMessage *string

	noSmithyDocumentSerde
}

// A description of a resource tag.
type Tag struct {

	// The key of the resource tag.
	//
	// This member is required.
	Key *string

	// The value of the resource tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Template version source data.
//
// The following types satisfy this interface:
//  TemplateVersionSourceInputMemberS3
type TemplateVersionSourceInput interface {
	isTemplateVersionSourceInput()
}

// An S3 source object that includes the template bundle S3 path and name for a
// template minor version.
type TemplateVersionSourceInputMemberS3 struct {
	Value S3ObjectSource

	noSmithyDocumentSerde
}

func (*TemplateVersionSourceInputMemberS3) isTemplateVersionSourceInput() {}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isTemplateVersionSourceInput() {}
