// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Specifies a location in AWS.
type AWSLocation struct {

	// The Amazon Resource Name (ARN) of the subnet the device is located in.
	SubnetArn *string

	// The Zone the device is located in. This can be the ID of an Availability Zone,
	// Local Zone, Wavelength Zone, or an Outpost.
	Zone *string

	noSmithyDocumentSerde
}

// Describes bandwidth information.
type Bandwidth struct {

	// Download speed in Mbps.
	DownloadSpeed *int32

	// Upload speed in Mbps.
	UploadSpeed *int32

	noSmithyDocumentSerde
}

// Describes a connection.
type Connection struct {

	// The ID of the second device in the connection.
	ConnectedDeviceId *string

	// The ID of the link for the second device in the connection.
	ConnectedLinkId *string

	// The Amazon Resource Name (ARN) of the connection.
	ConnectionArn *string

	// The ID of the connection.
	ConnectionId *string

	// The date and time that the connection was created.
	CreatedAt *time.Time

	// The description of the connection.
	Description *string

	// The ID of the first device in the connection.
	DeviceId *string

	// The ID of the global network.
	GlobalNetworkId *string

	// The ID of the link for the first device in the connection.
	LinkId *string

	// The state of the connection.
	State ConnectionState

	// The tags for the connection.
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes the association between a customer gateway, a device, and a link.
type CustomerGatewayAssociation struct {

	// The Amazon Resource Name (ARN) of the customer gateway.
	CustomerGatewayArn *string

	// The ID of the device.
	DeviceId *string

	// The ID of the global network.
	GlobalNetworkId *string

	// The ID of the link.
	LinkId *string

	// The association state.
	State CustomerGatewayAssociationState

	noSmithyDocumentSerde
}

// Describes a device.
type Device struct {

	// The AWS location of the device.
	AWSLocation *AWSLocation

	// The date and time that the site was created.
	CreatedAt *time.Time

	// The description of the device.
	Description *string

	// The Amazon Resource Name (ARN) of the device.
	DeviceArn *string

	// The ID of the device.
	DeviceId *string

	// The ID of the global network.
	GlobalNetworkId *string

	// The site location.
	Location *Location

	// The device model.
	Model *string

	// The device serial number.
	SerialNumber *string

	// The site ID.
	SiteId *string

	// The device state.
	State DeviceState

	// The tags for the device.
	Tags []Tag

	// The device type.
	Type *string

	// The device vendor.
	Vendor *string

	noSmithyDocumentSerde
}

// Describes a global network.
type GlobalNetwork struct {

	// The date and time that the global network was created.
	CreatedAt *time.Time

	// The description of the global network.
	Description *string

	// The Amazon Resource Name (ARN) of the global network.
	GlobalNetworkArn *string

	// The ID of the global network.
	GlobalNetworkId *string

	// The state of the global network.
	State GlobalNetworkState

	// The tags for the global network.
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes a link.
type Link struct {

	// The bandwidth for the link.
	Bandwidth *Bandwidth

	// The date and time that the link was created.
	CreatedAt *time.Time

	// The description of the link.
	Description *string

	// The ID of the global network.
	GlobalNetworkId *string

	// The Amazon Resource Name (ARN) of the link.
	LinkArn *string

	// The ID of the link.
	LinkId *string

	// The provider of the link.
	Provider *string

	// The ID of the site.
	SiteId *string

	// The state of the link.
	State LinkState

	// The tags for the link.
	Tags []Tag

	// The type of the link.
	Type *string

	noSmithyDocumentSerde
}

// Describes the association between a device and a link.
type LinkAssociation struct {

	// The device ID for the link association.
	DeviceId *string

	// The ID of the global network.
	GlobalNetworkId *string

	// The state of the association.
	LinkAssociationState LinkAssociationState

	// The ID of the link.
	LinkId *string

	noSmithyDocumentSerde
}

// Describes a location.
type Location struct {

	// The physical address.
	Address *string

	// The latitude.
	Latitude *string

	// The longitude.
	Longitude *string

	noSmithyDocumentSerde
}

// Describes a site.
type Site struct {

	// The date and time that the site was created.
	CreatedAt *time.Time

	// The description of the site.
	Description *string

	// The ID of the global network.
	GlobalNetworkId *string

	// The location of the site.
	Location *Location

	// The Amazon Resource Name (ARN) of the site.
	SiteArn *string

	// The ID of the site.
	SiteId *string

	// The state of the site.
	State SiteState

	// The tags for the site.
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes a tag.
type Tag struct {

	// The tag key. Length Constraints: Maximum length of 128 characters.
	Key *string

	// The tag value. Length Constraints: Maximum length of 256 characters.
	Value *string

	noSmithyDocumentSerde
}

// Describes a transit gateway Connect peer association.
type TransitGatewayConnectPeerAssociation struct {

	// The ID of the device.
	DeviceId *string

	// The ID of the global network.
	GlobalNetworkId *string

	// The ID of the link.
	LinkId *string

	// The state of the association.
	State TransitGatewayConnectPeerAssociationState

	// The Amazon Resource Name (ARN) of the transit gateway Connect peer.
	TransitGatewayConnectPeerArn *string

	noSmithyDocumentSerde
}

// Describes the registration of a transit gateway to a global network.
type TransitGatewayRegistration struct {

	// The ID of the global network.
	GlobalNetworkId *string

	// The state of the transit gateway registration.
	State *TransitGatewayRegistrationStateReason

	// The Amazon Resource Name (ARN) of the transit gateway.
	TransitGatewayArn *string

	noSmithyDocumentSerde
}

// Describes the status of a transit gateway registration.
type TransitGatewayRegistrationStateReason struct {

	// The code for the state reason.
	Code TransitGatewayRegistrationState

	// The message for the state reason.
	Message *string

	noSmithyDocumentSerde
}

// Describes a validation exception for a field.
type ValidationExceptionField struct {

	// The message for the field.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
