// Code generated by smithy-go-codegen DO NOT EDIT.

package mediatailor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/mediatailor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all the VOD sources in a source location.
func (c *Client) ListVodSources(ctx context.Context, params *ListVodSourcesInput, optFns ...func(*Options)) (*ListVodSourcesOutput, error) {
	if params == nil {
		params = &ListVodSourcesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListVodSources", params, optFns, c.addOperationListVodSourcesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListVodSourcesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListVodSourcesInput struct {

	// The identifier for the source location you are working on.
	//
	// This member is required.
	SourceLocationName *string

	// Upper bound on number of records to return. The maximum number of results is
	// 100.
	MaxResults int32

	// Pagination token from the GET list request. Use the token to fetch the next page
	// of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListVodSourcesOutput struct {

	// Lists the VOD sources.
	Items []types.VodSource

	// Pagination token from the list request. Use the token to fetch the next page of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListVodSourcesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListVodSources{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListVodSources{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListVodSourcesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListVodSources(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListVodSourcesAPIClient is a client that implements the ListVodSources
// operation.
type ListVodSourcesAPIClient interface {
	ListVodSources(context.Context, *ListVodSourcesInput, ...func(*Options)) (*ListVodSourcesOutput, error)
}

var _ ListVodSourcesAPIClient = (*Client)(nil)

// ListVodSourcesPaginatorOptions is the paginator options for ListVodSources
type ListVodSourcesPaginatorOptions struct {
	// Upper bound on number of records to return. The maximum number of results is
	// 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListVodSourcesPaginator is a paginator for ListVodSources
type ListVodSourcesPaginator struct {
	options   ListVodSourcesPaginatorOptions
	client    ListVodSourcesAPIClient
	params    *ListVodSourcesInput
	nextToken *string
	firstPage bool
}

// NewListVodSourcesPaginator returns a new ListVodSourcesPaginator
func NewListVodSourcesPaginator(client ListVodSourcesAPIClient, params *ListVodSourcesInput, optFns ...func(*ListVodSourcesPaginatorOptions)) *ListVodSourcesPaginator {
	if params == nil {
		params = &ListVodSourcesInput{}
	}

	options := ListVodSourcesPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListVodSourcesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListVodSourcesPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListVodSources page.
func (p *ListVodSourcesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListVodSourcesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.ListVodSources(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListVodSources(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "mediatailor",
		OperationName: "ListVodSources",
	}
}
