// Code generated by smithy-go-codegen DO NOT EDIT.

package macie

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/macie/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all the S3 resources associated with Amazon Macie Classic. If
// memberAccountId isn't specified, the action lists the S3 resources associated
// with Macie Classic for the current Macie Classic administrator account. If
// memberAccountId is specified, the action lists the S3 resources associated with
// Macie Classic for the specified member account.
func (c *Client) ListS3Resources(ctx context.Context, params *ListS3ResourcesInput, optFns ...func(*Options)) (*ListS3ResourcesOutput, error) {
	if params == nil {
		params = &ListS3ResourcesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListS3Resources", params, optFns, c.addOperationListS3ResourcesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListS3ResourcesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListS3ResourcesInput struct {

	// Use this parameter to indicate the maximum number of items that you want in the
	// response. The default value is 250.
	MaxResults *int32

	// The Amazon Macie Classic member account ID whose associated S3 resources you
	// want to list.
	MemberAccountId *string

	// Use this parameter when paginating results. Set its value to null on your first
	// call to the ListS3Resources action. Subsequent calls to the action fill
	// nextToken in the request with the value of nextToken from the previous response
	// to continue listing data.
	NextToken *string

	noSmithyDocumentSerde
}

type ListS3ResourcesOutput struct {

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to be
	// listed, this parameter is set to null.
	NextToken *string

	// A list of the associated S3 resources returned by the action.
	S3Resources []types.S3ResourceClassification

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListS3ResourcesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListS3Resources{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListS3Resources{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListS3Resources(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListS3ResourcesAPIClient is a client that implements the ListS3Resources
// operation.
type ListS3ResourcesAPIClient interface {
	ListS3Resources(context.Context, *ListS3ResourcesInput, ...func(*Options)) (*ListS3ResourcesOutput, error)
}

var _ ListS3ResourcesAPIClient = (*Client)(nil)

// ListS3ResourcesPaginatorOptions is the paginator options for ListS3Resources
type ListS3ResourcesPaginatorOptions struct {
	// Use this parameter to indicate the maximum number of items that you want in the
	// response. The default value is 250.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListS3ResourcesPaginator is a paginator for ListS3Resources
type ListS3ResourcesPaginator struct {
	options   ListS3ResourcesPaginatorOptions
	client    ListS3ResourcesAPIClient
	params    *ListS3ResourcesInput
	nextToken *string
	firstPage bool
}

// NewListS3ResourcesPaginator returns a new ListS3ResourcesPaginator
func NewListS3ResourcesPaginator(client ListS3ResourcesAPIClient, params *ListS3ResourcesInput, optFns ...func(*ListS3ResourcesPaginatorOptions)) *ListS3ResourcesPaginator {
	if params == nil {
		params = &ListS3ResourcesInput{}
	}

	options := ListS3ResourcesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListS3ResourcesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListS3ResourcesPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListS3Resources page.
func (p *ListS3ResourcesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListS3ResourcesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListS3Resources(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListS3Resources(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "macie",
		OperationName: "ListS3Resources",
	}
}
