// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains the tracker resource details.
type BatchDeleteDevicePositionHistoryError struct {

	// The ID of the device for this position.
	//
	// This member is required.
	DeviceId *string

	// Contains the batch request error details associated with the request.
	//
	// This member is required.
	Error *BatchItemError

	noSmithyDocumentSerde
}

// Contains error details for each geofence that failed to delete from the geofence
// collection.
type BatchDeleteGeofenceError struct {

	// Contains details associated to the batch error.
	//
	// This member is required.
	Error *BatchItemError

	// The geofence associated with the error message.
	//
	// This member is required.
	GeofenceId *string

	noSmithyDocumentSerde
}

// Contains error details for each device that failed to evaluate its position
// against the geofences in a given geofence collection.
type BatchEvaluateGeofencesError struct {

	// The device associated with the position evaluation error.
	//
	// This member is required.
	DeviceId *string

	// Contains details associated to the batch error.
	//
	// This member is required.
	Error *BatchItemError

	// Specifies a timestamp for when the error occurred in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	SampleTime *time.Time

	noSmithyDocumentSerde
}

// Contains error details for each device that didn't return a position.
type BatchGetDevicePositionError struct {

	// The ID of the device that didn't return a position.
	//
	// This member is required.
	DeviceId *string

	// Contains details related to the error code.
	//
	// This member is required.
	Error *BatchItemError

	noSmithyDocumentSerde
}

// Contains the batch request error details associated with the request.
type BatchItemError struct {

	// The error code associated with the batch request error.
	Code BatchItemErrorCode

	// A message with the reason for the batch request error.
	Message *string

	noSmithyDocumentSerde
}

// Contains error details for each geofence that failed to be stored in a given
// geofence collection.
type BatchPutGeofenceError struct {

	// Contains details associated to the batch error.
	//
	// This member is required.
	Error *BatchItemError

	// The geofence associated with the error message.
	//
	// This member is required.
	GeofenceId *string

	noSmithyDocumentSerde
}

// Contains geofence geometry details.
type BatchPutGeofenceRequestEntry struct {

	// The identifier for the geofence to be stored in a given geofence collection.
	//
	// This member is required.
	GeofenceId *string

	// Contains the polygon details to specify the position of the geofence. Each
	// geofence polygon
	// (https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html)
	// can have a maximum of 1,000 vertices.
	//
	// This member is required.
	Geometry *GeofenceGeometry

	noSmithyDocumentSerde
}

// Contains a summary of each geofence that was successfully stored in a given
// geofence collection.
type BatchPutGeofenceSuccess struct {

	// The timestamp for when the geofence was stored in a geofence collection in ISO
	// 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	CreateTime *time.Time

	// The geofence successfully stored in a geofence collection.
	//
	// This member is required.
	GeofenceId *string

	// The timestamp for when the geofence was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Contains error details for each device that failed to update its position.
type BatchUpdateDevicePositionError struct {

	// The device associated with the failed location update.
	//
	// This member is required.
	DeviceId *string

	// Contains details related to the error code such as the error code and error
	// message.
	//
	// This member is required.
	Error *BatchItemError

	// The timestamp at which the device position was determined. Uses  ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	SampleTime *time.Time

	noSmithyDocumentSerde
}

// Contains details about additional route preferences for requests that specify
// TravelMode as Car.
type CalculateRouteCarModeOptions struct {

	// Avoids ferries when calculating routes. Default Value: false Valid Values: false
	// | true
	AvoidFerries *bool

	// Avoids tolls when calculating routes. Default Value: false Valid Values: false |
	// true
	AvoidTolls *bool

	noSmithyDocumentSerde
}

// A summary of the calculated route.
type CalculateRouteSummary struct {

	// The data provider of traffic and road network data used to calculate the route.
	// Indicates one of the available providers:
	//
	// * Esri
	//
	// * Here
	//
	// For more information
	// about data providers, see Amazon Location Service data providers
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The total distance covered by the route. The sum of the distance travelled
	// between every stop on the route. The route distance can't be greater than 250
	// km. If the route exceeds 250 km, the response returns a 400
	// RoutesValidationException error.
	//
	// This member is required.
	Distance *float64

	// The unit of measurement for the distance.
	//
	// This member is required.
	DistanceUnit DistanceUnit

	// The total travel time for the route measured in seconds. The sum of the travel
	// time between every stop on the route.
	//
	// This member is required.
	DurationSeconds *float64

	// Specifies a geographical box surrounding a route. Used to zoom into a route when
	// displaying it in a map. For example, [min x, min y, max x, max y]. The first 2
	// bbox parameters describe the lower southwest corner:
	//
	// * The first bbox position
	// is the X coordinate or longitude of the lower southwest corner.
	//
	// * The second
	// bbox position is the Y coordinate or latitude of the lower southwest
	// corner.
	//
	// The next 2 bbox parameters describe the upper northeast corner:
	//
	// * The
	// third bbox position is the X coordinate, or longitude of the upper northeast
	// corner.
	//
	// * The fourth bbox position is the Y coordinate, or longitude of the
	// upper northeast corner.
	//
	// This member is required.
	RouteBBox []float64

	noSmithyDocumentSerde
}

// Contains details about additional route preferences for requests that specify
// TravelMode as Truck.
type CalculateRouteTruckModeOptions struct {

	// Avoids ferries when calculating routes. Default Value: false Valid Values: false
	// | true
	AvoidFerries *bool

	// Avoids ferries when calculating routes. Default Value: false Valid Values: false
	// | true
	AvoidTolls *bool

	// Specifies the truck's dimension specifications including length, height, width,
	// and unit of measurement. Used to avoid roads that can't support the truck's
	// dimensions.
	Dimensions *TruckDimensions

	// Specifies the truck's weight specifications including total weight and unit of
	// measurement. Used to avoid roads that can't support the truck's weight.
	Weight *TruckWeight

	noSmithyDocumentSerde
}

// Specifies the data storage option chosen for requesting Places. When using
// Amazon Location Places:
//
// * If using HERE Technologies as a data provider, you
// can't store results for locations in Japan by setting IntendedUse to Storage.
// parameter.
//
// * Under the MobileAssetTracking or MobilAssetManagement pricing
// plan, you can't store results from your place index resources by setting
// IntendedUse to Storage. This returns a validation exception error.
//
// For more
// information, see the AWS Service Terms (https://aws.amazon.com/service-terms/)
// for Amazon Location Service.
type DataSourceConfiguration struct {

	// Specifies how the results of an operation will be stored by the caller. Valid
	// values include:
	//
	// * SingleUse specifies that the results won't be stored.
	//
	// *
	// Storage specifies that the result can be cached or stored in a
	// database.
	//
	// Default value: SingleUse
	IntendedUse IntendedUse

	noSmithyDocumentSerde
}

// Contains the device position details.
type DevicePosition struct {

	// The last known device position.
	//
	// This member is required.
	Position []float64

	// The timestamp for when the tracker resource received the device position in  ISO
	// 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	ReceivedTime *time.Time

	// The timestamp at which the device's position was determined. Uses  ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	SampleTime *time.Time

	// The device whose position you retrieved.
	DeviceId *string

	noSmithyDocumentSerde
}

// Contains the position update details for a device.
type DevicePositionUpdate struct {

	// The device associated to the position update.
	//
	// This member is required.
	DeviceId *string

	// The latest device position defined in WGS 84
	// (https://earth-info.nga.mil/GandG/wgs84/index.html) format: [X or longitude, Y
	// or latitude].
	//
	// This member is required.
	Position []float64

	// The timestamp at which the device's position was determined. Uses ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	SampleTime *time.Time

	noSmithyDocumentSerde
}

// Contains the geofence geometry details. Amazon Location doesn't currently
// support polygons with holes, multipolygons, polygons that are wound clockwise,
// or that cross the antimeridian.
type GeofenceGeometry struct {

	// An array of 1 or more linear rings. A linear ring is an array of 4 or more
	// vertices, where the first and last vertex are the same to form a closed
	// boundary. Each vertex is a 2-dimensional point of the form: [longitude,
	// latitude]. The first linear ring is an outer ring, describing the polygon's
	// boundary. Subsequent linear rings may be inner or outer rings to describe holes
	// and islands. Outer rings must list their vertices in counter-clockwise order
	// around the ring's center, where the left side is the polygon's exterior. Inner
	// rings must list their vertices in clockwise order, where the left side is the
	// polygon's interior.
	Polygon [][][]float64

	noSmithyDocumentSerde
}

// Contains the calculated route's details for each path between a pair of
// positions. The number of legs returned corresponds to one fewer than the total
// number of positions in the request. For example, a route with a departure
// position and destination position returns one leg with the positions snapped to
// a nearby road
// (https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#snap-to-nearby-road):
//
// *
// The StartPosition is the departure position.
//
// * The EndPosition is the
// destination position.
//
// A route with a waypoint between the departure and
// destination position returns two legs with the positions snapped to a nearby
// road:
//
// * Leg 1: The StartPosition is the departure position . The EndPosition is
// the waypoint positon.
//
// * Leg 2: The StartPosition is the waypoint position. The
// EndPosition is the destination position.
type Leg struct {

	// The distance between the leg's StartPosition and EndPosition along a calculated
	// route.
	//
	// * The default measurement is Kilometers unless the request specifies a
	// DistanceUnit of Miles.
	//
	// This member is required.
	Distance *float64

	// The estimated travel time between the leg's StartPosition and EndPosition. The
	// travel mode and departure time that you specify in the request determines the
	// calculated time.
	//
	// This member is required.
	DurationSeconds *float64

	// The terminating position of the leg. Follows the format [longitude,latitude]. If
	// the EndPosition isn't located on a road, it's snapped to a nearby road
	// (https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#snap-to-nearby-road).
	//
	// This member is required.
	EndPosition []float64

	// The starting position of the leg. Follows the format [longitude,latitude]. If
	// the StartPosition isn't located on a road, it's snapped to a nearby road
	// (https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#snap-to-nearby-road).
	//
	// This member is required.
	StartPosition []float64

	// Contains a list of steps, which represent subsections of a leg. Each step
	// provides instructions for how to move to the next step in the leg such as the
	// step's start position, end position, travel distance, travel duration, and
	// geometry offset.
	//
	// This member is required.
	Steps []Step

	// Contains the calculated route's path as a linestring geometry.
	Geometry *LegGeometry

	noSmithyDocumentSerde
}

// Contains the geometry details for each path between a pair of positions. Used in
// plotting a route leg on a map.
type LegGeometry struct {

	// An ordered list of positions used to plot a route on a map. The first position
	// is closest to the start position for the leg, and the last position is the
	// closest to the end position for the leg.
	//
	// * For example, [[-123.117,
	// 49.284],[-123.115, 49.285],[-123.115, 49.285]]
	LineString [][]float64

	noSmithyDocumentSerde
}

// Contains the tracker resource details.
type ListDevicePositionsResponseEntry struct {

	// The ID of the device for this position.
	//
	// This member is required.
	DeviceId *string

	// The last known device position. Empty if no positions currently stored.
	//
	// This member is required.
	Position []float64

	// The timestamp at which the device position was determined. Uses  ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	SampleTime *time.Time

	noSmithyDocumentSerde
}

// Contains the geofence collection details.
type ListGeofenceCollectionsResponseEntry struct {

	// The name of the geofence collection.
	//
	// This member is required.
	CollectionName *string

	// The timestamp for when the geofence collection was created in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	CreateTime *time.Time

	// The description for the geofence collection
	//
	// This member is required.
	Description *string

	// The pricing plan for the specified geofence collection. For additional details
	// and restrictions on each pricing plan option, see the Amazon Location Service
	// pricing page (https://aws.amazon.com/location/pricing/).
	//
	// This member is required.
	PricingPlan PricingPlan

	// Specifies a timestamp for when the resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	UpdateTime *time.Time

	// The specified data provider for the geofence collection.
	PricingPlanDataSource *string

	noSmithyDocumentSerde
}

// Contains a list of geofences stored in a given geofence collection.
type ListGeofenceResponseEntry struct {

	// The timestamp for when the geofence was stored in a geofence collection in ISO
	// 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	CreateTime *time.Time

	// The geofence identifier.
	//
	// This member is required.
	GeofenceId *string

	// Contains the geofence geometry details describing a polygon.
	//
	// This member is required.
	Geometry *GeofenceGeometry

	// Identifies the state of the geofence. A geofence will hold one of the following
	// states:
	//
	// * ACTIVE — The geofence has been indexed by the system.
	//
	// * PENDING —
	// The geofence is being processed by the system.
	//
	// * FAILED — The geofence failed
	// to be indexed by the system.
	//
	// * DELETED — The geofence has been deleted from the
	// system index.
	//
	// * DELETING — The geofence is being deleted from the system index.
	//
	// This member is required.
	Status *string

	// The timestamp for when the geofence was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Contains details of an existing map resource in your AWS account.
type ListMapsResponseEntry struct {

	// The timestamp for when the map resource was created in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	CreateTime *time.Time

	// Specifies the data provider for the associated map tiles.
	//
	// This member is required.
	DataSource *string

	// The description for the map resource.
	//
	// This member is required.
	Description *string

	// The name of the associated map resource.
	//
	// This member is required.
	MapName *string

	// The pricing plan for the specified map resource. For additional details and
	// restrictions on each pricing plan option, see the Amazon Location Service
	// pricing page (https://aws.amazon.com/location/pricing/).
	//
	// This member is required.
	PricingPlan PricingPlan

	// The timestamp for when the map resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// A place index resource listed in your AWS account.
type ListPlaceIndexesResponseEntry struct {

	// The timestamp for when the place index resource was created in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	CreateTime *time.Time

	// The data provider of geospatial data. Indicates one of the available
	// providers:
	//
	// * Esri
	//
	// * Here
	//
	// For additional details on data providers, see the
	// Amazon Location Service data providers page
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The optional description for the place index resource.
	//
	// This member is required.
	Description *string

	// The name of the place index resource.
	//
	// This member is required.
	IndexName *string

	// The pricing plan for the specified place index resource. For additional details
	// and restrictions on each pricing plan option, see the Amazon Location Service
	// pricing page (https://aws.amazon.com/location/pricing/).
	//
	// This member is required.
	PricingPlan PricingPlan

	// The timestamp for when the place index resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// A route calculator resource listed in your AWS account.
type ListRouteCalculatorsResponseEntry struct {

	// The name of the route calculator resource.
	//
	// This member is required.
	CalculatorName *string

	// The timestamp when the route calculator resource was created in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// * For example, 2020–07-2T12:15:20.000Z+01:00
	//
	// This member is required.
	CreateTime *time.Time

	// The data provider of traffic and road network data. Indicates one of the
	// available providers:
	//
	// * Esri
	//
	// * Here
	//
	// For more information about data providers,
	// see Amazon Location Service data providers
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The optional description of the route calculator resource.
	//
	// This member is required.
	Description *string

	// The pricing plan for the specified route calculator resource. For additional
	// details and restrictions on each pricing plan option, see Amazon Location
	// Service pricing (https://aws.amazon.com/location/pricing/).
	//
	// This member is required.
	PricingPlan PricingPlan

	// The timestamp when the route calculator resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// * For example, 2020–07-2T12:15:20.000Z+01:00
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Contains the tracker resource details.
type ListTrackersResponseEntry struct {

	// The timestamp for when the tracker resource was created in  ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	CreateTime *time.Time

	// The description for the tracker resource.
	//
	// This member is required.
	Description *string

	// The pricing plan for the specified tracker resource. For additional details and
	// restrictions on each pricing plan option, see the Amazon Location Service
	// pricing page (https://aws.amazon.com/location/pricing/).
	//
	// This member is required.
	PricingPlan PricingPlan

	// The name of the tracker resource.
	//
	// This member is required.
	TrackerName *string

	// The timestamp at which the device's position was determined. Uses  ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	UpdateTime *time.Time

	// The specified data provider for the tracker resource.
	PricingPlanDataSource *string

	noSmithyDocumentSerde
}

// Specifies the map tile style selected from an available provider.
type MapConfiguration struct {

	// Specifies the map style selected from an available data provider. For additional
	// information on each map style and to preview each map style, see Esri map styles
	// and HERE map styles. Valid Esri
	// (https://docs.aws.amazon.com/location/latest/developerguide/esri.html)
	// styles:
	//
	// * VectorEsriDarkGrayCanvas – The Esri Dark Gray Canvas map style. A
	// vector basemap with a dark gray, neutral background with minimal colors, labels,
	// and features that's designed to draw attention to your thematic content.
	//
	// *
	// RasterEsriImagery – The Esri Imagery map style. A raster basemap that provides
	// one meter or better satellite and aerial imagery in many parts of the world and
	// lower resolution satellite imagery worldwide.
	//
	// * VectorEsriLightGrayCanvas – The
	// Esri Light Gray Canvas map style, which provides a detailed vector basemap with
	// a light gray, neutral background style with minimal colors, labels, and features
	// that's designed to draw attention to your thematic content.
	//
	// *
	// VectorEsriTopographic – The Esri Light map style, which provides a detailed
	// vector basemap with a classic Esri map style.
	//
	// * VectorEsriStreets – The Esri
	// World Streets map style, which provides a detailed vector basemap for the world
	// symbolized with a classic Esri street map style. The vector tile layer is
	// similar in content and style to the World Street Map raster map.
	//
	// *
	// VectorEsriNavigation – The Esri World Navigation map style, which provides a
	// detailed basemap for the world symbolized with a custom navigation map style
	// that's designed for use during the day in mobile devices.
	//
	// Valid HERE
	// Technologies
	// (https://docs.aws.amazon.com/location/latest/developerguide/HERE.html)
	// styles:
	//
	// * VectorHereBerlin – The HERE Berlin map style is a high contrast
	// detailed base map of the world that blends 3D and 2D rendering. When using HERE
	// as your data provider, and selecting the Style VectorHereBerlin, you may not use
	// HERE Technologies maps for Asset Management. See the AWS Service Terms
	// (https://aws.amazon.com/service-terms/) for Amazon Location Service.
	//
	// This member is required.
	Style *string

	noSmithyDocumentSerde
}

// Contains details about addresses or points of interest that match the search
// criteria.
type Place struct {

	// Places uses a point geometry to specify a location or a Place.
	//
	// This member is required.
	Geometry *PlaceGeometry

	// The numerical portion of an address, such as a building number.
	AddressNumber *string

	// A country/region specified using ISO 3166
	// (https://www.iso.org/iso-3166-country-codes.html) 3-digit country/region code.
	// For example, CAN.
	Country *string

	// The full name and address of the point of interest such as a city, region, or
	// country. For example, 123 Any Street, Any Town, USA.
	Label *string

	// A name for a local area, such as a city or town name. For example, Toronto.
	Municipality *string

	// The name of a community district. For example, Downtown.
	Neighborhood *string

	// A group of numbers and letters in a country-specific format, which accompanies
	// the address for the purpose of identifying a location.
	PostalCode *string

	// A name for an area or geographical division, such as a province or state name.
	// For example, British Columbia.
	Region *string

	// The name for a street or a road to identify a location. For example, Main
	// Street.
	Street *string

	// A country, or an area that's part of a larger region . For example, Metro
	// Vancouver.
	SubRegion *string

	noSmithyDocumentSerde
}

// Places uses a point geometry to specify a location or a Place.
type PlaceGeometry struct {

	// A single point geometry specifies a location for a Place using WGS 84
	// (https://gisgeography.com/wgs84-world-geodetic-system/) coordinates:
	//
	// * x —
	// Specifies the x coordinate or longitude.
	//
	// * y — Specifies the y coordinate or
	// latitude.
	Point []float64

	noSmithyDocumentSerde
}

// Specifies a single point of interest, or Place as a result of a search query
// obtained from a dataset configured in the place index resource.
type SearchForPositionResult struct {

	// Contains details about the relevant point of interest.
	//
	// This member is required.
	Place *Place

	noSmithyDocumentSerde
}

// Contains relevant Places returned by calling SearchPlaceIndexForText.
type SearchForTextResult struct {

	// Contains details about the relevant point of interest.
	//
	// This member is required.
	Place *Place

	noSmithyDocumentSerde
}

// A summary of the reverse geocoding request sent using
// SearchPlaceIndexForPosition.
type SearchPlaceIndexForPositionSummary struct {

	// The data provider of geospatial data. Indicates one of the available
	// providers:
	//
	// * Esri
	//
	// * HERE
	//
	// For additional details on data providers, see the
	// Amazon Location Service data providers page
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The position given in the reverse geocoding request.
	//
	// This member is required.
	Position []float64

	// An optional parameter. The maximum number of results returned per request.
	// Default value: 50
	MaxResults int32

	noSmithyDocumentSerde
}

// A summary of the geocoding request sent using SearchPlaceIndexForText.
type SearchPlaceIndexForTextSummary struct {

	// The data provider of geospatial data. Indicates one of the available
	// providers:
	//
	// * Esri
	//
	// * HERE
	//
	// For additional details on data providers, see the
	// Amazon Location Service data providers page
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The address, name, city or region to be used in the geocoding request. In
	// free-form text format. For example, Vancouver.
	//
	// This member is required.
	Text *string

	// Contains the coordinates for the bias position entered in the geocoding request.
	BiasPosition []float64

	// Contains the coordinates for the optional bounding box coordinated entered in
	// the geocoding request.
	FilterBBox []float64

	// Contains the country filter entered in the geocoding request.
	FilterCountries []string

	// Contains the maximum number of results indicated for the request.
	MaxResults int32

	// A bounding box that contains the search results within the specified area
	// indicated by FilterBBox. A subset of bounding box specified using FilterBBox.
	ResultBBox []float64

	noSmithyDocumentSerde
}

// Represents an element of a leg within a route. A step contains instructions for
// how to move to the next step in the leg.
type Step struct {

	// The travel distance between the step's StartPosition and EndPosition.
	//
	// This member is required.
	Distance *float64

	// The estimated travel time, in seconds, from the step's StartPosition to the
	// EndPosition. . The travel mode and departure time that you specify in the
	// request determines the calculated time.
	//
	// This member is required.
	DurationSeconds *float64

	// The end position of a step. If the position the last step in the leg, this
	// position is the same as the end position of the leg.
	//
	// This member is required.
	EndPosition []float64

	// The starting position of a step. If the position is the first step in the leg,
	// this position is the same as the start position of the leg.
	//
	// This member is required.
	StartPosition []float64

	// Represents the start position, or index, in a sequence of steps within the leg's
	// line string geometry. For example, the index of the first step in a leg geometry
	// is 0. Included in the response for queries that set IncludeLegGeometry to True.
	GeometryOffset *int32

	noSmithyDocumentSerde
}

// Contains details about the truck dimensions in the unit of measurement that you
// specify. Used to filter out roads that can't support or allow the specified
// dimensions for requests that specify TravelMode as Truck.
type TruckDimensions struct {

	// The height of the truck.
	//
	// * For example, 4.5.
	Height *float64

	// The length of the truck.
	//
	// * For example, 15.5.
	Length *float64

	// Specifies the unit of measurement for the truck dimensions. Default Value:
	// Meters
	Unit DimensionUnit

	// The width of the truck.
	//
	// * For example, 4.5.
	Width *float64

	noSmithyDocumentSerde
}

// Contains details about the truck's weight specifications. Used to avoid roads
// that can't support or allow the total weight for requests that specify
// TravelMode as Truck.
type TruckWeight struct {

	// The total weight of the truck.
	//
	// * For example, 3500.
	Total *float64

	// The unit of measurement to use for the truck weight. Default Value: Kilograms
	Unit VehicleWeightUnit

	noSmithyDocumentSerde
}

// The input failed to meet the constraints specified by the AWS service in a
// specified field.
type ValidationExceptionField struct {

	// A message with the reason for the validation exception error.
	//
	// This member is required.
	Message *string

	// The field name where the invalid entry was detected.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
