// Code generated by smithy-go-codegen DO NOT EDIT.

package location

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/location/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a tracker resource in your AWS account, which lets you retrieve current
// and historical location of devices.
func (c *Client) CreateTracker(ctx context.Context, params *CreateTrackerInput, optFns ...func(*Options)) (*CreateTrackerOutput, error) {
	if params == nil {
		params = &CreateTrackerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateTracker", params, optFns, c.addOperationCreateTrackerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateTrackerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateTrackerInput struct {

	// Specifies the pricing plan for the tracker resource. For additional details and
	// restrictions on each pricing plan option, see the Amazon Location Service
	// pricing page (https://aws.amazon.com/location/pricing/).
	//
	// This member is required.
	PricingPlan types.PricingPlan

	// The name for the tracker resource. Requirements:
	//
	// * Contain only alphanumeric
	// characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
	//
	// *
	// Must be a unique tracker resource name.
	//
	// * No spaces allowed. For example,
	// ExampleTracker.
	//
	// This member is required.
	TrackerName *string

	// An optional description for the tracker resource.
	Description *string

	// A key identifier for an AWS KMS customer managed key
	// (https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html). Enter
	// a key ID, key ARN, alias name, or alias ARN.
	KmsKeyId *string

	// Specifies the data provider for the tracker resource.
	//
	// * Required value for the
	// following pricing plans: MobileAssetTracking | MobileAssetManagement
	//
	// For more
	// information about Data Providers
	// (https://aws.amazon.com/location/data-providers/), and Pricing plans
	// (https://aws.amazon.com/location/pricing/), see the Amazon Location Service
	// product page. Amazon Location Service only uses PricingPlanDataSource to
	// calculate billing for your tracker resource. Your data will not be shared with
	// the data provider, and will remain in your AWS account or Region unless you move
	// it. Valid Values: Esri | Here
	PricingPlanDataSource *string

	// Applies one or more tags to the tracker resource. A tag is a key-value pair
	// helps manage, identify, search, and filter your resources by labelling them.
	// Format: "key" : "value" Restrictions:
	//
	// * Maximum 50 tags per resource
	//
	// * Each
	// resource tag must be unique with a maximum of one value.
	//
	// * Maximum key length:
	// 128 Unicode characters in UTF-8
	//
	// * Maximum value length: 256 Unicode characters
	// in UTF-8
	//
	// * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
	// characters: + - = . _ : / @.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateTrackerOutput struct {

	// The timestamp for when the tracker resource was created in  ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	CreateTime *time.Time

	// The Amazon Resource Name (ARN) for the tracker resource. Used when you need to
	// specify a resource across all AWS.
	//
	// * Format example:
	// arn:aws:geo:region:account-id:tracker/ExampleTracker
	//
	// This member is required.
	TrackerArn *string

	// The name of the tracker resource.
	//
	// This member is required.
	TrackerName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateTrackerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateTracker{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateTracker{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateTrackerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateTracker(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateTracker(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "geo",
		OperationName: "CreateTracker",
	}
}
