// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Limits that are related to concurrency and storage. All file and storage sizes
// are in bytes.
type AccountLimit struct {

	// The maximum size of a function's deployment package and layers when they're
	// extracted.
	CodeSizeUnzipped int64

	// The maximum size of a deployment package when it's uploaded directly to Lambda.
	// Use Amazon S3 for larger files.
	CodeSizeZipped int64

	// The maximum number of simultaneous function executions.
	ConcurrentExecutions int32

	// The amount of storage space that you can use for all deployment packages and
	// layer archives.
	TotalCodeSize int64

	// The maximum number of simultaneous function executions, minus the capacity
	// that's reserved for individual functions with PutFunctionConcurrency.
	UnreservedConcurrentExecutions *int32

	noSmithyDocumentSerde
}

// The number of functions and amount of storage in use.
type AccountUsage struct {

	// The number of Lambda functions.
	FunctionCount int64

	// The amount of storage space, in bytes, that's being used by deployment packages
	// and layer archives.
	TotalCodeSize int64

	noSmithyDocumentSerde
}

// Provides configuration information about a Lambda function alias
// (https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
type AliasConfiguration struct {

	// The Amazon Resource Name (ARN) of the alias.
	AliasArn *string

	// A description of the alias.
	Description *string

	// The function version that the alias invokes.
	FunctionVersion *string

	// The name of the alias.
	Name *string

	// A unique identifier that changes when you update the alias.
	RevisionId *string

	// The routing configuration
	// (https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html)
	// of the alias.
	RoutingConfig *AliasRoutingConfiguration

	noSmithyDocumentSerde
}

// The traffic-shifting
// (https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html)
// configuration of a Lambda function alias.
type AliasRoutingConfiguration struct {

	// The second version, and the percentage of traffic that's routed to it.
	AdditionalVersionWeights map[string]float64

	noSmithyDocumentSerde
}

// List of signing profiles that can sign a code package.
type AllowedPublishers struct {

	// The Amazon Resource Name (ARN) for each of the signing profiles. A signing
	// profile defines a trusted user who can sign a code package.
	//
	// This member is required.
	SigningProfileVersionArns []string

	noSmithyDocumentSerde
}

// Details about a Code signing configuration
// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html).
type CodeSigningConfig struct {

	// List of allowed publishers.
	//
	// This member is required.
	AllowedPublishers *AllowedPublishers

	// The Amazon Resource Name (ARN) of the Code signing configuration.
	//
	// This member is required.
	CodeSigningConfigArn *string

	// Unique identifer for the Code signing configuration.
	//
	// This member is required.
	CodeSigningConfigId *string

	// The code signing policy controls the validation failure action for signature
	// mismatch or expiry.
	//
	// This member is required.
	CodeSigningPolicies *CodeSigningPolicies

	// The date and time that the Code signing configuration was last modified, in
	// ISO-8601 format (YYYY-MM-DDThh:mm:ss.sTZD).
	//
	// This member is required.
	LastModified *string

	// Code signing configuration description.
	Description *string

	noSmithyDocumentSerde
}

// Code signing configuration policies
// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html#config-codesigning-policies)
// specify the validation failure action for signature mismatch or expiry.
type CodeSigningPolicies struct {

	// Code signing configuration policy for deployment validation failure. If you set
	// the policy to Enforce, Lambda blocks the deployment request if signature
	// validation checks fail. If you set the policy to Warn, Lambda allows the
	// deployment and creates a CloudWatch log. Default value: Warn
	UntrustedArtifactOnDeployment CodeSigningPolicy

	noSmithyDocumentSerde
}

type Concurrency struct {

	// The number of concurrent executions that are reserved for this function. For
	// more information, see Managing Concurrency
	// (https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
	ReservedConcurrentExecutions *int32

	noSmithyDocumentSerde
}

// The dead-letter queue
// (https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq) for
// failed asynchronous invocations.
type DeadLetterConfig struct {

	// The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.
	TargetArn *string

	noSmithyDocumentSerde
}

// A configuration object that specifies the destination of an event after Lambda
// processes it.
type DestinationConfig struct {

	// The destination configuration for failed invocations.
	OnFailure *OnFailure

	// The destination configuration for successful invocations.
	OnSuccess *OnSuccess

	noSmithyDocumentSerde
}

// A function's environment variable settings. You can use environment variables to
// adjust your function's behavior without updating code. An environment variable
// is a pair of strings that are stored in a function's version-specific
// configuration.
type Environment struct {

	// Environment variable key-value pairs. For more information, see Using Lambda
	// environment variables
	// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html).
	Variables map[string]string

	noSmithyDocumentSerde
}

// Error messages for environment variables that couldn't be applied.
type EnvironmentError struct {

	// The error code.
	ErrorCode *string

	// The error message.
	Message *string

	noSmithyDocumentSerde
}

// The results of an operation to update or read environment variables. If the
// operation is successful, the response contains the environment variables. If it
// failed, the response contains details about the error.
type EnvironmentResponse struct {

	// Error messages for environment variables that couldn't be applied.
	Error *EnvironmentError

	// Environment variable key-value pairs.
	Variables map[string]string

	noSmithyDocumentSerde
}

// A mapping between an Amazon Web Services resource and a Lambda function. For
// details, see CreateEventSourceMapping.
type EventSourceMappingConfiguration struct {

	// The maximum number of items to retrieve in a single batch.
	BatchSize *int32

	// (Streams only) If the function returns an error, split the batch in two and
	// retry. The default value is false.
	BisectBatchOnFunctionError *bool

	// (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded
	// records.
	DestinationConfig *DestinationConfig

	// The Amazon Resource Name (ARN) of the event source.
	EventSourceArn *string

	// The ARN of the Lambda function.
	FunctionArn *string

	// (Streams only) A list of current response type enums applied to the event source
	// mapping.
	FunctionResponseTypes []FunctionResponseType

	// The date that the event source mapping was last updated or that its state
	// changed.
	LastModified *time.Time

	// The result of the last Lambda invocation of your function.
	LastProcessingResult *string

	// (Streams and Amazon SQS standard queues) The maximum amount of time to gather
	// records before invoking the function, in seconds. The default value is zero.
	MaximumBatchingWindowInSeconds *int32

	// (Streams only) Discard records older than the specified age. The default value
	// is -1, which sets the maximum age to infinite. When the value is set to
	// infinite, Lambda never discards old records.
	MaximumRecordAgeInSeconds *int32

	// (Streams only) Discard records after the specified number of retries. The
	// default value is -1, which sets the maximum number of retries to infinite. When
	// MaximumRetryAttempts is infinite, Lambda retries failed records until the record
	// expires in the event source.
	MaximumRetryAttempts *int32

	// (Streams only) The number of batches to process concurrently from each shard.
	// The default value is 1.
	ParallelizationFactor *int32

	// (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
	Queues []string

	// The self-managed Apache Kafka cluster for your event source.
	SelfManagedEventSource *SelfManagedEventSource

	// An array of the authentication protocol, VPC components, or virtual host to
	// secure and define your event source.
	SourceAccessConfigurations []SourceAccessConfiguration

	// The position in a stream from which to start reading. Required for Amazon
	// Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. AT_TIMESTAMP is
	// supported only for Amazon Kinesis streams.
	StartingPosition EventSourcePosition

	// With StartingPosition set to AT_TIMESTAMP, the time from which to start reading.
	StartingPositionTimestamp *time.Time

	// The state of the event source mapping. It can be one of the following: Creating,
	// Enabling, Enabled, Disabling, Disabled, Updating, or Deleting.
	State *string

	// Indicates whether a user or Lambda made the last change to the event source
	// mapping.
	StateTransitionReason *string

	// The name of the Kafka topic.
	Topics []string

	// (Streams only) The duration in seconds of a processing window. The range is
	// 1–900 seconds.
	TumblingWindowInSeconds *int32

	// The identifier of the event source mapping.
	UUID *string

	noSmithyDocumentSerde
}

// Details about the connection between a Lambda function and an Amazon EFS file
// system
// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html).
type FileSystemConfig struct {

	// The Amazon Resource Name (ARN) of the Amazon EFS access point that provides
	// access to the file system.
	//
	// This member is required.
	Arn *string

	// The path where the function can access the file system, starting with /mnt/.
	//
	// This member is required.
	LocalMountPath *string

	noSmithyDocumentSerde
}

// The code for the Lambda function. You can specify either an object in Amazon S3,
// upload a .zip file archive deployment package directly, or specify the URI of a
// container image.
type FunctionCode struct {

	// URI of a container image
	// (https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html) in the Amazon
	// ECR registry.
	ImageUri *string

	// An Amazon S3 bucket in the same Amazon Web Services Region as your function. The
	// bucket can be in a different Amazon Web Services account.
	S3Bucket *string

	// The Amazon S3 key of the deployment package.
	S3Key *string

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string

	// The base64-encoded contents of the deployment package. Amazon Web Services SDK
	// and Amazon Web Services CLI clients handle the encoding for you.
	ZipFile []byte

	noSmithyDocumentSerde
}

// Details about a function's deployment package.
type FunctionCodeLocation struct {

	// URI of a container image in the Amazon ECR registry.
	ImageUri *string

	// A presigned URL that you can use to download the deployment package.
	Location *string

	// The service that's hosting the file.
	RepositoryType *string

	// The resolved URI for the image.
	ResolvedImageUri *string

	noSmithyDocumentSerde
}

// Details about a function's configuration.
type FunctionConfiguration struct {

	// The SHA256 hash of the function's deployment package.
	CodeSha256 *string

	// The size of the function's deployment package, in bytes.
	CodeSize int64

	// The function's dead letter queue.
	DeadLetterConfig *DeadLetterConfig

	// The function's description.
	Description *string

	// The function's environment variables
	// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html).
	Environment *EnvironmentResponse

	// Connection settings for an Amazon EFS file system
	// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html).
	FileSystemConfigs []FileSystemConfig

	// The function's Amazon Resource Name (ARN).
	FunctionArn *string

	// The name of the function.
	FunctionName *string

	// The function that Lambda calls to begin executing your function.
	Handler *string

	// The function's image configuration values.
	ImageConfigResponse *ImageConfigResponse

	// The KMS key that's used to encrypt the function's environment variables. This
	// key is only returned if you've configured a customer managed CMK.
	KMSKeyArn *string

	// The date and time that the function was last updated, in ISO-8601 format
	// (https://www.w3.org/TR/NOTE-datetime) (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModified *string

	// The status of the last update that was performed on the function. This is first
	// set to Successful after function creation completes.
	LastUpdateStatus LastUpdateStatus

	// The reason for the last update that was performed on the function.
	LastUpdateStatusReason *string

	// The reason code for the last update that was performed on the function.
	LastUpdateStatusReasonCode LastUpdateStatusReasonCode

	// The function's  layers
	// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
	Layers []Layer

	// For Lambda@Edge functions, the ARN of the master function.
	MasterArn *string

	// The amount of memory available to the function at runtime.
	MemorySize *int32

	// The type of deployment package. Set to Image for container image and set Zip for
	// .zip file archive.
	PackageType PackageType

	// The latest updated revision of the function or alias.
	RevisionId *string

	// The function's execution role.
	Role *string

	// The runtime environment for the Lambda function.
	Runtime Runtime

	// The ARN of the signing job.
	SigningJobArn *string

	// The ARN of the signing profile version.
	SigningProfileVersionArn *string

	// The current state of the function. When the state is Inactive, you can
	// reactivate the function by invoking it.
	State State

	// The reason for the function's current state.
	StateReason *string

	// The reason code for the function's current state. When the code is Creating, you
	// can't invoke or modify the function.
	StateReasonCode StateReasonCode

	// The amount of time in seconds that Lambda allows a function to run before
	// stopping it.
	Timeout *int32

	// The function's X-Ray tracing configuration.
	TracingConfig *TracingConfigResponse

	// The version of the Lambda function.
	Version *string

	// The function's networking configuration.
	VpcConfig *VpcConfigResponse

	noSmithyDocumentSerde
}

type FunctionEventInvokeConfig struct {

	// A destination for events after they have been sent to a function for processing.
	// Destinations
	//
	// * Function - The Amazon Resource Name (ARN) of a Lambda
	// function.
	//
	// * Queue - The ARN of an SQS queue.
	//
	// * Topic - The ARN of an SNS
	// topic.
	//
	// * Event Bus - The ARN of an Amazon EventBridge event bus.
	DestinationConfig *DestinationConfig

	// The Amazon Resource Name (ARN) of the function.
	FunctionArn *string

	// The date and time that the configuration was last updated.
	LastModified *time.Time

	// The maximum age of a request that Lambda sends to a function for processing.
	MaximumEventAgeInSeconds *int32

	// The maximum number of times to retry when the function returns an error.
	MaximumRetryAttempts *int32

	noSmithyDocumentSerde
}

// Configuration values that override the container image Dockerfile settings. See
// Container settings
// (https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms).
type ImageConfig struct {

	// Specifies parameters that you want to pass in with ENTRYPOINT.
	Command []string

	// Specifies the entry point to their application, which is typically the location
	// of the runtime executable.
	EntryPoint []string

	// Specifies the working directory.
	WorkingDirectory *string

	noSmithyDocumentSerde
}

// Error response to GetFunctionConfiguration.
type ImageConfigError struct {

	// Error code.
	ErrorCode *string

	// Error message.
	Message *string

	noSmithyDocumentSerde
}

// Response to GetFunctionConfiguration request.
type ImageConfigResponse struct {

	// Error response to GetFunctionConfiguration.
	Error *ImageConfigError

	// Configuration values that override the container image Dockerfile.
	ImageConfig *ImageConfig

	noSmithyDocumentSerde
}

// An Lambda layer
// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
type Layer struct {

	// The Amazon Resource Name (ARN) of the function layer.
	Arn *string

	// The size of the layer archive in bytes.
	CodeSize int64

	// The Amazon Resource Name (ARN) of a signing job.
	SigningJobArn *string

	// The Amazon Resource Name (ARN) for a signing profile version.
	SigningProfileVersionArn *string

	noSmithyDocumentSerde
}

// Details about an Lambda layer
// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
type LayersListItem struct {

	// The newest version of the layer.
	LatestMatchingVersion *LayerVersionsListItem

	// The Amazon Resource Name (ARN) of the function layer.
	LayerArn *string

	// The name of the layer.
	LayerName *string

	noSmithyDocumentSerde
}

// A ZIP archive that contains the contents of an Lambda layer
// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). You
// can specify either an Amazon S3 location, or upload a layer archive directly.
type LayerVersionContentInput struct {

	// The Amazon S3 bucket of the layer archive.
	S3Bucket *string

	// The Amazon S3 key of the layer archive.
	S3Key *string

	// For versioned objects, the version of the layer archive object to use.
	S3ObjectVersion *string

	// The base64-encoded contents of the layer archive. Amazon Web Services SDK and
	// Amazon Web Services CLI clients handle the encoding for you.
	ZipFile []byte

	noSmithyDocumentSerde
}

// Details about a version of an Lambda layer
// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
type LayerVersionContentOutput struct {

	// The SHA-256 hash of the layer archive.
	CodeSha256 *string

	// The size of the layer archive in bytes.
	CodeSize int64

	// A link to the layer archive in Amazon S3 that is valid for 10 minutes.
	Location *string

	// The Amazon Resource Name (ARN) of a signing job.
	SigningJobArn *string

	// The Amazon Resource Name (ARN) for a signing profile version.
	SigningProfileVersionArn *string

	noSmithyDocumentSerde
}

// Details about a version of an Lambda layer
// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
type LayerVersionsListItem struct {

	// The layer's compatible runtimes.
	CompatibleRuntimes []Runtime

	// The date that the version was created, in ISO 8601 format. For example,
	// 2018-11-27T15:10:45.123+0000.
	CreatedDate *string

	// The description of the version.
	Description *string

	// The ARN of the layer version.
	LayerVersionArn *string

	// The layer's open-source license.
	LicenseInfo *string

	// The version number.
	Version int64

	noSmithyDocumentSerde
}

// A destination for events that failed processing.
type OnFailure struct {

	// The Amazon Resource Name (ARN) of the destination resource.
	Destination *string

	noSmithyDocumentSerde
}

// A destination for events that were processed successfully.
type OnSuccess struct {

	// The Amazon Resource Name (ARN) of the destination resource.
	Destination *string

	noSmithyDocumentSerde
}

// Details about the provisioned concurrency configuration for a function alias or
// version.
type ProvisionedConcurrencyConfigListItem struct {

	// The amount of provisioned concurrency allocated.
	AllocatedProvisionedConcurrentExecutions *int32

	// The amount of provisioned concurrency available.
	AvailableProvisionedConcurrentExecutions *int32

	// The Amazon Resource Name (ARN) of the alias or version.
	FunctionArn *string

	// The date and time that a user last updated the configuration, in ISO 8601 format
	// (https://www.iso.org/iso-8601-date-and-time-format.html).
	LastModified *string

	// The amount of provisioned concurrency requested.
	RequestedProvisionedConcurrentExecutions *int32

	// The status of the allocation process.
	Status ProvisionedConcurrencyStatusEnum

	// For failed allocations, the reason that provisioned concurrency could not be
	// allocated.
	StatusReason *string

	noSmithyDocumentSerde
}

// The self-managed Apache Kafka cluster for your event source.
type SelfManagedEventSource struct {

	// The list of bootstrap servers for your Kafka brokers in the following format:
	// "KAFKA_BOOTSTRAP_SERVERS": ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"].
	Endpoints map[string][]string

	noSmithyDocumentSerde
}

// To secure and define access to your event source, you can specify the
// authentication protocol, VPC components, or virtual host.
type SourceAccessConfiguration struct {

	// The type of authentication protocol, VPC components, or virtual host for your
	// event source. For example: "Type":"SASL_SCRAM_512_AUTH".
	//
	// * BASIC_AUTH - (Amazon
	// MQ) The Secrets Manager secret that stores your broker credentials.
	//
	// *
	// BASIC_AUTH - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret
	// key used for SASL/PLAIN authentication of your Apache Kafka brokers.
	//
	// *
	// VPC_SUBNET - The subnets associated with your VPC. Lambda connects to these
	// subnets to fetch data from your self-managed Apache Kafka cluster.
	//
	// *
	// VPC_SECURITY_GROUP - The VPC security group used to manage access to your
	// self-managed Apache Kafka brokers.
	//
	// * SASL_SCRAM_256_AUTH - The Secrets Manager
	// ARN of your secret key used for SASL SCRAM-256 authentication of your
	// self-managed Apache Kafka brokers.
	//
	// * SASL_SCRAM_512_AUTH - The Secrets Manager
	// ARN of your secret key used for SASL SCRAM-512 authentication of your
	// self-managed Apache Kafka brokers.
	//
	// * VIRTUAL_HOST - (Amazon MQ) The name of the
	// virtual host in your RabbitMQ broker. Lambda uses this RabbitMQ host as the
	// event source.
	Type SourceAccessType

	// The value for your chosen configuration in Type. For example: "URI":
	// "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName".
	URI *string

	noSmithyDocumentSerde
}

// The function's X-Ray
// (https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html) tracing
// configuration. To sample and record incoming requests, set Mode to Active.
type TracingConfig struct {

	// The tracing mode.
	Mode TracingMode

	noSmithyDocumentSerde
}

// The function's X-Ray tracing configuration.
type TracingConfigResponse struct {

	// The tracing mode.
	Mode TracingMode

	noSmithyDocumentSerde
}

// The VPC security groups and subnets that are attached to a Lambda function. For
// more information, see VPC Settings
// (https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
type VpcConfig struct {

	// A list of VPC security groups IDs.
	SecurityGroupIds []string

	// A list of VPC subnet IDs.
	SubnetIds []string

	noSmithyDocumentSerde
}

// The VPC security groups and subnets that are attached to a Lambda function.
type VpcConfigResponse struct {

	// A list of VPC security groups IDs.
	SecurityGroupIds []string

	// A list of VPC subnet IDs.
	SubnetIds []string

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
