// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Error related to a specific channel, specified by its ARN.
type BatchError struct {

	// Channel ARN.
	Arn *string

	// Error code.
	Code *string

	// Error message, determined by the application.
	Message *string

	noSmithyDocumentSerde
}

// Object specifying a channel.
type Channel struct {

	// Channel ARN.
	Arn *string

	// Whether the channel is private (enabled for playback authorization). Default:
	// false.
	Authorized bool

	// Channel ingest endpoint, part of the definition of an ingest server, used when
	// you set up streaming software.
	IngestEndpoint *string

	// Channel latency mode. Use NORMAL to broadcast and deliver live video up to Full
	// HD. Use LOW for near-real-time interaction with viewers. Default: LOW. (Note: In
	// the Amazon IVS console, LOW and NORMAL correspond to Ultra-low and Standard,
	// respectively.)
	LatencyMode ChannelLatencyMode

	// Channel name.
	Name *string

	// Channel playback URL.
	PlaybackUrl *string

	// Recording-configuration ARN. A value other than an empty string indicates that
	// recording is enabled. Default: "" (empty string, recording is disabled).
	RecordingConfigurationArn *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	// Channel type, which determines the allowable resolution and bitrate. If you
	// exceed the allowable resolution or bitrate, the stream probably will disconnect
	// immediately. Default: STANDARD. Valid values:
	//
	// * STANDARD: Multiple qualities
	// are generated from the original input, to automatically give viewers the best
	// experience for their devices and network conditions. Vertical resolution can be
	// up to 1080 and bitrate can be up to 8.5 Mbps.
	//
	// * BASIC: Amazon IVS delivers the
	// original input to viewers. The viewer’s video-quality choice is limited to the
	// original input. Vertical resolution can be up to 480 and bitrate can be up to
	// 1.5 Mbps.
	Type ChannelType

	noSmithyDocumentSerde
}

// Summary information about a channel.
type ChannelSummary struct {

	// Channel ARN.
	Arn *string

	// Whether the channel is private (enabled for playback authorization). Default:
	// false.
	Authorized bool

	// Channel latency mode. Use NORMAL to broadcast and deliver live video up to Full
	// HD. Use LOW for near-real-time interaction with viewers. Default: LOW. (Note: In
	// the Amazon IVS console, LOW and NORMAL correspond to Ultra-low and Standard,
	// respectively.)
	LatencyMode ChannelLatencyMode

	// Channel name.
	Name *string

	// Recording-configuration ARN. A value other than an empty string indicates that
	// recording is enabled. Default: "" (empty string, recording is disabled).
	RecordingConfigurationArn *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// A complex type that describes a location where recorded videos will be stored.
// Each member represents a type of destination configuration. For recording, you
// define one and only one type of destination configuration.
type DestinationConfiguration struct {

	// An S3 destination configuration where recorded videos will be stored.
	S3 *S3DestinationConfiguration

	noSmithyDocumentSerde
}

// A key pair used to sign and validate a playback authorization token.
type PlaybackKeyPair struct {

	// Key-pair ARN.
	Arn *string

	// Key-pair identifier.
	Fingerprint *string

	// An arbitrary string (a nickname) assigned to a playback key pair that helps the
	// customer identify that resource. The value does not need to be unique.
	Name *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// Summary information about a playback key pair.
type PlaybackKeyPairSummary struct {

	// Key-pair ARN.
	Arn *string

	// An arbitrary string (a nickname) assigned to a playback key pair that helps the
	// customer identify that resource. The value does not need to be unique.
	Name *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// An object representing a configuration to record a channel stream.
type RecordingConfiguration struct {

	// Recording-configuration ARN.
	//
	// This member is required.
	Arn *string

	// A complex type that contains information about where recorded video will be
	// stored.
	//
	// This member is required.
	DestinationConfiguration *DestinationConfiguration

	// Indicates the current state of the recording configuration. When the state is
	// ACTIVE, the configuration is ready for recording a channel stream.
	//
	// This member is required.
	State RecordingConfigurationState

	// An arbitrary string (a nickname) assigned to a recording configuration that
	// helps the customer identify that resource. The value does not need to be unique.
	Name *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// Summary information about a RecordingConfiguration.
type RecordingConfigurationSummary struct {

	// Recording-configuration ARN.
	//
	// This member is required.
	Arn *string

	// A complex type that contains information about where recorded video will be
	// stored.
	//
	// This member is required.
	DestinationConfiguration *DestinationConfiguration

	// Indicates the current state of the recording configuration. When the state is
	// ACTIVE, the configuration is ready for recording a channel stream.
	//
	// This member is required.
	State RecordingConfigurationState

	// An arbitrary string (a nickname) assigned to a recording configuration that
	// helps the customer identify that resource. The value does not need to be unique.
	Name *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// A complex type that describes an S3 location where recorded videos will be
// stored.
type S3DestinationConfiguration struct {

	// Location (S3 bucket name) where recorded videos will be stored.
	//
	// This member is required.
	BucketName *string

	noSmithyDocumentSerde
}

// Specifies a live video stream that has been ingested and distributed.
type Stream struct {

	// Channel ARN for the stream.
	ChannelArn *string

	// The stream’s health.
	Health StreamHealth

	// URL of the master playlist, required by the video player to play the HLS stream.
	PlaybackUrl *string

	// ISO-8601 formatted timestamp of the stream’s start.
	StartTime *time.Time

	// The stream’s state.
	State StreamState

	// Number of current viewers of the stream. A value of -1 indicates that the
	// request timed out; in this case, retry.
	ViewerCount int64

	noSmithyDocumentSerde
}

// Object specifying a stream key.
type StreamKey struct {

	// Stream-key ARN.
	Arn *string

	// Channel ARN for the stream.
	ChannelArn *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	// Stream-key value.
	Value *string

	noSmithyDocumentSerde
}

// Summary information about a stream key.
type StreamKeySummary struct {

	// Stream-key ARN.
	Arn *string

	// Channel ARN for the stream.
	ChannelArn *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// Summary information about a stream.
type StreamSummary struct {

	// Channel ARN for the stream.
	ChannelArn *string

	// The stream’s health.
	Health StreamHealth

	// ISO-8601 formatted timestamp of the stream’s start.
	StartTime *time.Time

	// The stream’s state.
	State StreamState

	// Number of current viewers of the stream. A value of -1 indicates that the
	// request timed out; in this case, retry.
	ViewerCount int64

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
