// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains an access policy that defines an identity's access to an IoT SiteWise
// Monitor resource.
type AccessPolicySummary struct {

	// The ID of the access policy.
	//
	// This member is required.
	Id *string

	// The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group,
	// or an IAM user).
	//
	// This member is required.
	Identity *Identity

	// The permissions for the access policy. Note that a project ADMINISTRATOR is also
	// known as a project owner.
	//
	// This member is required.
	Permission Permission

	// The IoT SiteWise Monitor resource (a portal or project).
	//
	// This member is required.
	Resource *Resource

	// The date the access policy was created, in Unix epoch time.
	CreationDate *time.Time

	// The date the access policy was last updated, in Unix epoch time.
	LastUpdateDate *time.Time

	noSmithyDocumentSerde
}

// Contains aggregated asset property values (for example, average, minimum, and
// maximum).
type AggregatedValue struct {

	// The date the aggregating computations occurred, in Unix epoch time.
	//
	// This member is required.
	Timestamp *time.Time

	// The value of the aggregates.
	//
	// This member is required.
	Value *Aggregates

	// The quality of the aggregated data.
	Quality Quality

	noSmithyDocumentSerde
}

// Contains the (pre-calculated) aggregate values for an asset property.
type Aggregates struct {

	// The average (mean) value of the time series over a time interval window.
	Average *float64

	// The count of data points in the time series over a time interval window.
	Count *float64

	// The maximum value of the time series over a time interval window.
	Maximum *float64

	// The minimum value of the time series over a time interval window.
	Minimum *float64

	// The standard deviation of the time series over a time interval window.
	StandardDeviation *float64

	// The sum of the time series over a time interval window.
	Sum *float64

	noSmithyDocumentSerde
}

// Contains the configuration information of an alarm created in an IoT SiteWise
// Monitor portal. You can use the alarm to monitor an asset property and get
// notified when the asset property value is outside a specified range. For more
// information, see Monitoring with alarms
// (https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html)
// in the IoT SiteWise Application Guide.
type Alarms struct {

	// The ARN
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of
	// the IAM role that allows the alarm to perform actions and access Amazon Web
	// Services resources and services, such as IoT Events.
	//
	// This member is required.
	AlarmRoleArn *string

	// The ARN
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of
	// the Lambda function that manages alarm notifications. For more information, see
	// Managing alarm notifications
	// (https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html)
	// in the IoT Events Developer Guide.
	NotificationLambdaArn *string

	noSmithyDocumentSerde
}

// Contains information about a composite model in an asset. This object contains
// the asset's properties that you define in the composite model.
type AssetCompositeModel struct {

	// The name of the composite model.
	//
	// This member is required.
	Name *string

	// The asset properties that this composite model defines.
	//
	// This member is required.
	Properties []AssetProperty

	// The type of the composite model. For alarm composite models, this type is
	// AWS/ALARM.
	//
	// This member is required.
	Type *string

	// The description of the composite model.
	Description *string

	noSmithyDocumentSerde
}

// Contains error details for the requested associate project asset action.
type AssetErrorDetails struct {

	// The ID of the asset.
	//
	// This member is required.
	AssetId *string

	// The error code.
	//
	// This member is required.
	Code AssetErrorCode

	// The error message.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Describes an asset hierarchy that contains a hierarchy's name and ID.
type AssetHierarchy struct {

	// The hierarchy name provided in the CreateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)
	// API operation.
	//
	// This member is required.
	Name *string

	// The ID of the hierarchy. This ID is a hierarchyId.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about a parent asset and a child asset that are related
// through an asset hierarchy.
type AssetHierarchyInfo struct {

	// The ID of the child asset in this asset relationship.
	ChildAssetId *string

	// The ID of the parent asset in this asset relationship.
	ParentAssetId *string

	noSmithyDocumentSerde
}

// Contains information about a composite model in an asset model. This object
// contains the asset property definitions that you define in the composite model.
type AssetModelCompositeModel struct {

	// The name of the composite model.
	//
	// This member is required.
	Name *string

	// The type of the composite model. For alarm composite models, this type is
	// AWS/ALARM.
	//
	// This member is required.
	Type *string

	// The description of the composite model.
	Description *string

	// The asset property definitions for this composite model.
	Properties []AssetModelProperty

	noSmithyDocumentSerde
}

// Contains a composite model definition in an asset model. This composite model
// definition is applied to all assets created from the asset model.
type AssetModelCompositeModelDefinition struct {

	// The name of the composite model.
	//
	// This member is required.
	Name *string

	// The type of the composite model. For alarm composite models, this type is
	// AWS/ALARM.
	//
	// This member is required.
	Type *string

	// The description of the composite model.
	Description *string

	// The asset property definitions for this composite model.
	Properties []AssetModelPropertyDefinition

	noSmithyDocumentSerde
}

// Describes an asset hierarchy that contains a hierarchy's name, ID, and child
// asset model ID that specifies the type of asset that can be in this hierarchy.
type AssetModelHierarchy struct {

	// The ID of the asset model. All assets in this hierarchy must be instances of the
	// childAssetModelId asset model.
	//
	// This member is required.
	ChildAssetModelId *string

	// The name of the asset model hierarchy that you specify by using the
	// CreateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)
	// API operation.
	//
	// This member is required.
	Name *string

	// The ID of the asset model hierarchy. This ID is a hierarchyId.
	Id *string

	noSmithyDocumentSerde
}

// Contains an asset model hierarchy used in asset model creation. An asset model
// hierarchy determines the kind (or type) of asset that can belong to a hierarchy.
type AssetModelHierarchyDefinition struct {

	// The ID of an asset model for this hierarchy.
	//
	// This member is required.
	ChildAssetModelId *string

	// The name of the asset model hierarchy definition (as specified in the
	// CreateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)
	// API operation).
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains information about an asset model property.
type AssetModelProperty struct {

	// The data type of the asset model property.
	//
	// This member is required.
	DataType PropertyDataType

	// The name of the asset model property.
	//
	// This member is required.
	Name *string

	// The property type (see PropertyType).
	//
	// This member is required.
	Type *PropertyType

	// The data type of the structure for this property. This parameter exists on
	// properties that have the STRUCT data type.
	DataTypeSpec *string

	// The ID of the asset model property.
	Id *string

	// The unit of the asset model property, such as Newtons or RPM.
	Unit *string

	noSmithyDocumentSerde
}

// Contains an asset model property definition. This property definition is applied
// to all assets created from the asset model.
type AssetModelPropertyDefinition struct {

	// The data type of the property definition. If you specify STRUCT, you must also
	// specify dataTypeSpec to identify the type of the structure for this property.
	//
	// This member is required.
	DataType PropertyDataType

	// The name of the property definition.
	//
	// This member is required.
	Name *string

	// The property definition type (see PropertyType). You can only specify one type
	// in a property definition.
	//
	// This member is required.
	Type *PropertyType

	// The data type of the structure for this property. This parameter is required on
	// properties that have the STRUCT data type. The options for this parameter depend
	// on the type of the composite model in which you define this property. Use
	// AWS/ALARM_STATE for alarm state in alarm composite models.
	DataTypeSpec *string

	// The unit of the property definition, such as Newtons or RPM.
	Unit *string

	noSmithyDocumentSerde
}

// Contains current status information for an asset model. For more information,
// see Asset and model states
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html)
// in the IoT SiteWise User Guide.
type AssetModelStatus struct {

	// The current state of the asset model.
	//
	// This member is required.
	State AssetModelState

	// Contains associated error information, if any.
	Error *ErrorDetails

	noSmithyDocumentSerde
}

// Contains a summary of an asset model.
type AssetModelSummary struct {

	// The ARN
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of
	// the asset model, which has the following format.
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// This member is required.
	Arn *string

	// The date the asset model was created, in Unix epoch time.
	//
	// This member is required.
	CreationDate *time.Time

	// The asset model description.
	//
	// This member is required.
	Description *string

	// The ID of the asset model (used with IoT SiteWise APIs).
	//
	// This member is required.
	Id *string

	// The date the asset model was last updated, in Unix epoch time.
	//
	// This member is required.
	LastUpdateDate *time.Time

	// The name of the asset model.
	//
	// This member is required.
	Name *string

	// The current status of the asset model.
	//
	// This member is required.
	Status *AssetModelStatus

	noSmithyDocumentSerde
}

// Contains asset property information.
type AssetProperty struct {

	// The data type of the asset property.
	//
	// This member is required.
	DataType PropertyDataType

	// The ID of the asset property.
	//
	// This member is required.
	Id *string

	// The name of the property.
	//
	// This member is required.
	Name *string

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more
	// information, see Mapping industrial data streams to asset properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	Alias *string

	// The data type of the structure for this property. This parameter exists on
	// properties that have the STRUCT data type.
	DataTypeSpec *string

	// The asset property's notification topic and state. For more information, see
	// UpdateAssetProperty
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
	Notification *PropertyNotification

	// The unit (such as Newtons or RPM) of the asset property.
	Unit *string

	noSmithyDocumentSerde
}

// Contains asset property value information.
type AssetPropertyValue struct {

	// The timestamp of the asset property value.
	//
	// This member is required.
	Timestamp *TimeInNanos

	// The value of the asset property (see Variant).
	//
	// This member is required.
	Value *Variant

	// The quality of the asset property value.
	Quality Quality

	noSmithyDocumentSerde
}

// Contains information about assets that are related to one another.
type AssetRelationshipSummary struct {

	// The relationship type of the assets in this relationship. This value is one of
	// the following:
	//
	// * HIERARCHY – The assets are related through an asset hierarchy.
	// If you specify this relationship type, this asset relationship includes the
	// hierarchyInfo object.
	//
	// This member is required.
	RelationshipType AssetRelationshipType

	// The assets that are related through an asset hierarchy. This object is present
	// if the relationshipType is HIERARCHY.
	HierarchyInfo *AssetHierarchyInfo

	noSmithyDocumentSerde
}

// Contains information about the current status of an asset. For more information,
// see Asset and model states
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html)
// in the IoT SiteWise User Guide.
type AssetStatus struct {

	// The current status of the asset.
	//
	// This member is required.
	State AssetState

	// Contains associated error information, if any.
	Error *ErrorDetails

	noSmithyDocumentSerde
}

// Contains a summary of an asset.
type AssetSummary struct {

	// The ARN
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of
	// the asset, which has the following format.
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// This member is required.
	Arn *string

	// The ID of the asset model used to create this asset.
	//
	// This member is required.
	AssetModelId *string

	// The date the asset was created, in Unix epoch time.
	//
	// This member is required.
	CreationDate *time.Time

	// A list of asset hierarchies that each contain a hierarchyId. A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// This member is required.
	Hierarchies []AssetHierarchy

	// The ID of the asset.
	//
	// This member is required.
	Id *string

	// The date the asset was last updated, in Unix epoch time.
	//
	// This member is required.
	LastUpdateDate *time.Time

	// The name of the asset.
	//
	// This member is required.
	Name *string

	// The current status of the asset.
	//
	// This member is required.
	Status *AssetStatus

	noSmithyDocumentSerde
}

// Contains a summary of an associated asset.
type AssociatedAssetsSummary struct {

	// The ARN
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of
	// the asset, which has the following format.
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// This member is required.
	Arn *string

	// The ID of the asset model used to create the asset.
	//
	// This member is required.
	AssetModelId *string

	// The date the asset was created, in Unix epoch time.
	//
	// This member is required.
	CreationDate *time.Time

	// A list of asset hierarchies that each contain a hierarchyId. A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// This member is required.
	Hierarchies []AssetHierarchy

	// The ID of the asset.
	//
	// This member is required.
	Id *string

	// The date the asset was last updated, in Unix epoch time.
	//
	// This member is required.
	LastUpdateDate *time.Time

	// The name of the asset.
	//
	// This member is required.
	Name *string

	// The current status of the asset.
	//
	// This member is required.
	Status *AssetStatus

	noSmithyDocumentSerde
}

// Contains an asset attribute property. For more information, see Attributes
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#attributes)
// in the IoT SiteWise User Guide.
type Attribute struct {

	// The default value of the asset model property attribute. All assets that you
	// create from the asset model contain this attribute value. You can update an
	// attribute's value after you create an asset. For more information, see Updating
	// attribute values
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html)
	// in the IoT SiteWise User Guide.
	DefaultValue *string

	noSmithyDocumentSerde
}

// Contains error information from updating a batch of asset property values.
type BatchPutAssetPropertyError struct {

	// The error code.
	//
	// This member is required.
	ErrorCode BatchPutAssetPropertyValueErrorCode

	// The associated error message.
	//
	// This member is required.
	ErrorMessage *string

	// A list of timestamps for each error, if any.
	//
	// This member is required.
	Timestamps []TimeInNanos

	noSmithyDocumentSerde
}

// Contains error information for asset property value entries that are associated
// with the BatchPutAssetPropertyValue
// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html)
// API.
type BatchPutAssetPropertyErrorEntry struct {

	// The ID of the failed entry.
	//
	// This member is required.
	EntryId *string

	// The list of update property value errors.
	//
	// This member is required.
	Errors []BatchPutAssetPropertyError

	noSmithyDocumentSerde
}

// Contains information about a composite model property on an asset.
type CompositeModelProperty struct {

	// Contains asset property information.
	//
	// This member is required.
	AssetProperty *Property

	// The name of the property.
	//
	// This member is required.
	Name *string

	// The type of the composite model that defines this property.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// Contains the details of an IoT SiteWise configuration error.
type ConfigurationErrorDetails struct {

	// The error code.
	//
	// This member is required.
	Code ErrorCode

	// The error message.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Contains current status information for the configuration.
type ConfigurationStatus struct {

	// The current state of the configuration.
	//
	// This member is required.
	State ConfigurationState

	// Contains associated error information, if any.
	Error *ConfigurationErrorDetails

	noSmithyDocumentSerde
}

// Contains information about a customer managed Amazon S3 bucket.
type CustomerManagedS3Storage struct {

	// The ARN
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of
	// the Identity and Access Management role that allows IoT SiteWise to send data to
	// Amazon S3.
	//
	// This member is required.
	RoleArn *string

	// The ARN
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of
	// the Amazon S3 object. For more information about how to find the ARN for an
	// Amazon S3 object, see Amazon S3 resources
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html) in
	// the Amazon Simple Storage Service User Guide.
	//
	// This member is required.
	S3ResourceArn *string

	noSmithyDocumentSerde
}

// Contains a dashboard summary.
type DashboardSummary struct {

	// The ID of the dashboard.
	//
	// This member is required.
	Id *string

	// The name of the dashboard
	//
	// This member is required.
	Name *string

	// The date the dashboard was created, in Unix epoch time.
	CreationDate *time.Time

	// The dashboard's description.
	Description *string

	// The date the dashboard was last updated, in Unix epoch time.
	LastUpdateDate *time.Time

	noSmithyDocumentSerde
}

// Contains detailed error information.
type DetailedError struct {

	// The error code.
	//
	// This member is required.
	Code DetailedErrorCode

	// The error message.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Contains the details of an IoT SiteWise error.
type ErrorDetails struct {

	// The error code.
	//
	// This member is required.
	Code ErrorCode

	// The error message.
	//
	// This member is required.
	Message *string

	// A list of detailed errors.
	Details []DetailedError

	noSmithyDocumentSerde
}

// Contains expression variable information.
type ExpressionVariable struct {

	// The friendly name of the variable to be used in the expression.
	//
	// This member is required.
	Name *string

	// The variable that identifies an asset property from which to use values.
	//
	// This member is required.
	Value *VariableValue

	noSmithyDocumentSerde
}

// The forwarding configuration for a given property.
type ForwardingConfig struct {

	// The forwarding state for the given property.
	//
	// This member is required.
	State ForwardingConfigState

	noSmithyDocumentSerde
}

// Contains a summary of a gateway capability configuration.
type GatewayCapabilitySummary struct {

	// The namespace of the capability configuration. For example, if you configure
	// OPC-UA sources from the IoT SiteWise console, your OPC-UA capability
	// configuration has the namespace iotsitewise:opcuacollector:version, where
	// version is a number such as 1.
	//
	// This member is required.
	CapabilityNamespace *string

	// The synchronization status of the capability configuration. The sync status can
	// be one of the following:
	//
	// * IN_SYNC – The gateway is running the capability
	// configuration.
	//
	// * OUT_OF_SYNC – The gateway hasn't received the capability
	// configuration.
	//
	// * SYNC_FAILED – The gateway rejected the capability
	// configuration.
	//
	// This member is required.
	CapabilitySyncStatus CapabilitySyncStatus

	noSmithyDocumentSerde
}

// Contains a gateway's platform information.
type GatewayPlatform struct {

	// A gateway that runs on IoT Greengrass.
	Greengrass *Greengrass

	// A gateway that runs on IoT Greengrass V2.
	GreengrassV2 *GreengrassV2

	noSmithyDocumentSerde
}

// Contains a summary of a gateway.
type GatewaySummary struct {

	// The date the gateway was created, in Unix epoch time.
	//
	// This member is required.
	CreationDate *time.Time

	// The ID of the gateway device.
	//
	// This member is required.
	GatewayId *string

	// The name of the asset.
	//
	// This member is required.
	GatewayName *string

	// The date the gateway was last updated, in Unix epoch time.
	//
	// This member is required.
	LastUpdateDate *time.Time

	// A list of gateway capability summaries that each contain a namespace and status.
	// Each gateway capability defines data sources for the gateway. To retrieve a
	// capability configuration's definition, use
	// DescribeGatewayCapabilityConfiguration
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html).
	GatewayCapabilitySummaries []GatewayCapabilitySummary

	// Contains a gateway's platform information.
	GatewayPlatform *GatewayPlatform

	noSmithyDocumentSerde
}

// Contains details for a gateway that runs on IoT Greengrass. To create a gateway
// that runs on IoT Greengrass, you must add the IoT SiteWise connector to a
// Greengrass group and deploy it. Your Greengrass group must also have permissions
// to upload data to IoT SiteWise. For more information, see Ingesting data using a
// gateway
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html)
// in the IoT SiteWise User Guide.
type Greengrass struct {

	// The ARN
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of
	// the Greengrass group. For more information about how to find a group's ARN, see
	// ListGroups
	// (https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html)
	// and GetGroup
	// (https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html)
	// in the IoT Greengrass API Reference.
	//
	// This member is required.
	GroupArn *string

	noSmithyDocumentSerde
}

// Contains details for a gateway that runs on IoT Greengrass V2. To create a
// gateway that runs on IoT Greengrass V2, you must deploy the IoT SiteWise Edge
// component to your gateway device. Your Greengrass device role
// (https://docs.aws.amazon.com/greengrass/v2/developerguide/device-service-role.html)
// must use the AWSIoTSiteWiseEdgeAccess policy. For more information, see Using
// IoT SiteWise at the edge
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/sw-gateways.html) in
// the IoT SiteWise User Guide.
type GreengrassV2 struct {

	// The name of the IoT thing for your IoT Greengrass V2 core device.
	//
	// This member is required.
	CoreDeviceThingName *string

	noSmithyDocumentSerde
}

// Contains information for a group identity in an access policy.
type GroupIdentity struct {

	// The Amazon Web Services SSO ID of the group.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about an Identity and Access Management role. For more
// information, see IAM roles
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the IAM User
// Guide.
type IAMRoleIdentity struct {

	// The ARN of the IAM role. For more information, see IAM ARNs
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in
	// the IAM User Guide.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// Contains information about an Identity and Access Management user.
type IAMUserIdentity struct {

	// The ARN of the IAM user. For more information, see IAM ARNs
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in
	// the IAM User Guide. If you delete the IAM user, access policies that contain
	// this identity include an empty arn. You can delete the access policy for the IAM
	// user that no longer exists.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// Contains an identity that can access an IoT SiteWise Monitor resource.
// Currently, you can't use Amazon Web Services APIs to retrieve Amazon Web
// Services SSO identity IDs. You can find the Amazon Web Services SSO identity IDs
// in the URL of user and group pages in the Amazon Web Services SSO console
// (https://console.aws.amazon.com/singlesignon).
type Identity struct {

	// An Amazon Web Services SSO group identity.
	Group *GroupIdentity

	// An IAM role identity.
	IamRole *IAMRoleIdentity

	// An IAM user identity.
	IamUser *IAMUserIdentity

	// An Amazon Web Services SSO user identity.
	User *UserIdentity

	noSmithyDocumentSerde
}

// Contains an image that is one of the following:
//
// * An image file. Choose this
// option to upload a new image.
//
// * The ID of an existing image. Choose this option
// to keep an existing image.
type Image struct {

	// Contains an image file.
	File *ImageFile

	// The ID of an existing image. Specify this parameter to keep an existing image.
	Id *string

	noSmithyDocumentSerde
}

// Contains an image file.
type ImageFile struct {

	// The image file contents, represented as a base64-encoded string. The file size
	// must be less than 1 MB.
	//
	// This member is required.
	Data []byte

	// The file type of the image.
	//
	// This member is required.
	Type ImageFileType

	noSmithyDocumentSerde
}

// Contains an image that is uploaded to IoT SiteWise and available at a URL.
type ImageLocation struct {

	// The ID of the image.
	//
	// This member is required.
	Id *string

	// The URL where the image is available. The URL is valid for 15 minutes so that
	// you can view and download the image
	//
	// This member is required.
	Url *string

	noSmithyDocumentSerde
}

// Contains information about an interpolated asset property value.
type InterpolatedAssetPropertyValue struct {

	// Contains a timestamp with optional nanosecond granularity.
	//
	// This member is required.
	Timestamp *TimeInNanos

	// Contains an asset property value (of a single type only).
	//
	// This member is required.
	Value *Variant

	noSmithyDocumentSerde
}

// Contains logging options.
type LoggingOptions struct {

	// The IoT SiteWise logging verbosity level.
	//
	// This member is required.
	Level LoggingLevel

	noSmithyDocumentSerde
}

// Contains an asset measurement property. For more information, see Measurements
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#measurements)
// in the IoT SiteWise User Guide.
type Measurement struct {

	// The processing configuration for the given measurement property. You can
	// configure measurements to be kept at the edge or forwarded to the Amazon Web
	// Services Cloud. By default, measurements are forwarded to the cloud.
	ProcessingConfig *MeasurementProcessingConfig

	noSmithyDocumentSerde
}

// The processing configuration for the given measurement property. You can
// configure measurements to be kept at the edge or forwarded to the Amazon Web
// Services Cloud. By default, measurements are forwarded to the cloud.
type MeasurementProcessingConfig struct {

	// The forwarding configuration for the given measurement property.
	//
	// This member is required.
	ForwardingConfig *ForwardingConfig

	noSmithyDocumentSerde
}

// Contains an asset metric property. With metrics, you can calculate aggregate
// functions, such as an average, maximum, or minimum, as specified through an
// expression. A metric maps several values to a single value (such as a sum). The
// maximum number of dependent/cascading variables used in any one metric
// calculation is 10. Therefore, a root metric can have up to 10 cascading metrics
// in its computational dependency tree. Additionally, a metric can only have a
// data type of DOUBLE and consume properties with data types of INTEGER or DOUBLE.
// For more information, see Metrics
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#metrics)
// in the IoT SiteWise User Guide.
type Metric struct {

	// The mathematical expression that defines the metric aggregation function. You
	// can specify up to 10 variables per expression. You can specify up to 10
	// functions per expression. For more information, see Quotas
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the
	// IoT SiteWise User Guide.
	//
	// This member is required.
	Expression *string

	// The list of variables used in the expression.
	//
	// This member is required.
	Variables []ExpressionVariable

	// The window (time interval) over which IoT SiteWise computes the metric's
	// aggregation expression. IoT SiteWise computes one data point per window.
	//
	// This member is required.
	Window *MetricWindow

	// The processing configuration for the given metric property. You can configure
	// metrics to be computed at the edge or in the Amazon Web Services Cloud. By
	// default, metrics are forwarded to the cloud.
	ProcessingConfig *MetricProcessingConfig

	noSmithyDocumentSerde
}

// The processing configuration for the given metric property. You can configure
// metrics to be computed at the edge or in the Amazon Web Services Cloud. By
// default, metrics are forwarded to the cloud.
type MetricProcessingConfig struct {

	// The compute location for the given metric property.
	//
	// This member is required.
	ComputeLocation ComputeLocation

	noSmithyDocumentSerde
}

// Contains a time interval window used for data aggregate computations (for
// example, average, sum, count, and so on).
type MetricWindow struct {

	// The tumbling time interval window.
	Tumbling *TumblingWindow

	noSmithyDocumentSerde
}

// Contains IoT SiteWise Monitor error details.
type MonitorErrorDetails struct {

	// The error code.
	Code MonitorErrorCode

	// The error message.
	Message *string

	noSmithyDocumentSerde
}

// Contains information about the storage destination.
type MultiLayerStorage struct {

	// Contains information about a customer managed Amazon S3 bucket.
	//
	// This member is required.
	CustomerManagedS3Storage *CustomerManagedS3Storage

	noSmithyDocumentSerde
}

// Identifies an IoT SiteWise Monitor portal.
type PortalResource struct {

	// The ID of the portal.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about the current status of a portal.
type PortalStatus struct {

	// The current state of the portal.
	//
	// This member is required.
	State PortalState

	// Contains associated error information, if any.
	Error *MonitorErrorDetails

	noSmithyDocumentSerde
}

// Contains a portal summary.
type PortalSummary struct {

	// The ID of the portal.
	//
	// This member is required.
	Id *string

	// The name of the portal.
	//
	// This member is required.
	Name *string

	// The URL for the IoT SiteWise Monitor portal. You can use this URL to access
	// portals that use Amazon Web Services SSO for authentication. For portals that
	// use IAM for authentication, you must use the IoT SiteWise console to get a URL
	// that you can use to access the portal.
	//
	// This member is required.
	StartUrl *string

	// Contains information about the current status of a portal.
	//
	// This member is required.
	Status *PortalStatus

	// The date the portal was created, in Unix epoch time.
	CreationDate *time.Time

	// The portal's description.
	Description *string

	// The date the portal was last updated, in Unix epoch time.
	LastUpdateDate *time.Time

	// The ARN
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of
	// the service role that allows the portal's users to access your IoT SiteWise
	// resources on your behalf. For more information, see Using service roles for IoT
	// SiteWise Monitor
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the IoT SiteWise User Guide.
	RoleArn *string

	noSmithyDocumentSerde
}

// Identifies a specific IoT SiteWise Monitor project.
type ProjectResource struct {

	// The ID of the project.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Contains project summary information.
type ProjectSummary struct {

	// The ID of the project.
	//
	// This member is required.
	Id *string

	// The name of the project.
	//
	// This member is required.
	Name *string

	// The date the project was created, in Unix epoch time.
	CreationDate *time.Time

	// The project's description.
	Description *string

	// The date the project was last updated, in Unix epoch time.
	LastUpdateDate *time.Time

	noSmithyDocumentSerde
}

// Contains asset property information.
type Property struct {

	// The property data type.
	//
	// This member is required.
	DataType PropertyDataType

	// The ID of the asset property.
	//
	// This member is required.
	Id *string

	// The name of the property.
	//
	// This member is required.
	Name *string

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more
	// information, see Mapping industrial data streams to asset properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	Alias *string

	// The asset property's notification topic and state. For more information, see
	// UpdateAssetProperty
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
	Notification *PropertyNotification

	// The property type (see PropertyType). A property contains one type.
	Type *PropertyType

	// The unit (such as Newtons or RPM) of the asset property.
	Unit *string

	noSmithyDocumentSerde
}

// Contains asset property value notification information. When the notification
// state is enabled, IoT SiteWise publishes property value updates to a unique MQTT
// topic. For more information, see Interacting with other services
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html)
// in the IoT SiteWise User Guide.
type PropertyNotification struct {

	// The current notification state.
	//
	// This member is required.
	State PropertyNotificationState

	// The MQTT topic to which IoT SiteWise publishes property value update
	// notifications.
	//
	// This member is required.
	Topic *string

	noSmithyDocumentSerde
}

// Contains a property type, which can be one of attribute, measurement, metric, or
// transform.
type PropertyType struct {

	// Specifies an asset attribute property. An attribute generally contains static
	// information, such as the serial number of an IIoT
	// (https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications) wind
	// turbine.
	Attribute *Attribute

	// Specifies an asset measurement property. A measurement represents a device's raw
	// sensor data stream, such as timestamped temperature values or timestamped power
	// values.
	Measurement *Measurement

	// Specifies an asset metric property. A metric contains a mathematical expression
	// that uses aggregate functions to process all input data points over a time
	// interval and output a single data point, such as to calculate the average hourly
	// temperature.
	Metric *Metric

	// Specifies an asset transform property. A transform contains a mathematical
	// expression that maps a property's data points from one form to another, such as
	// a unit conversion from Celsius to Fahrenheit.
	Transform *Transform

	noSmithyDocumentSerde
}

// Contains a list of value updates for an asset property in the list of asset
// entries consumed by the BatchPutAssetPropertyValue
// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html)
// API operation.
type PutAssetPropertyValueEntry struct {

	// The user specified ID for the entry. You can use this ID to identify which
	// entries failed.
	//
	// This member is required.
	EntryId *string

	// The list of property values to upload. You can specify up to 10 propertyValues
	// array elements.
	//
	// This member is required.
	PropertyValues []AssetPropertyValue

	// The ID of the asset to update.
	AssetId *string

	// The alias that identifies the property, such as an OPC-UA server data stream
	// path (for example, /company/windfarm/3/turbine/7/temperature). For more
	// information, see Mapping industrial data streams to asset properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the IoT SiteWise User Guide.
	PropertyAlias *string

	// The ID of the asset property for this entry.
	PropertyId *string

	noSmithyDocumentSerde
}

// Contains an IoT SiteWise Monitor resource ID for a portal or project.
type Resource struct {

	// A portal resource.
	Portal *PortalResource

	// A project resource.
	Project *ProjectResource

	noSmithyDocumentSerde
}

// Contains a timestamp with optional nanosecond granularity.
type TimeInNanos struct {

	// The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond
	// data is provided by offsetInNanos.
	//
	// This member is required.
	TimeInSeconds *int64

	// The nanosecond offset from timeInSeconds.
	OffsetInNanos *int32

	noSmithyDocumentSerde
}

// Contains an asset transform property. A transform is a one-to-one mapping of a
// property's data points from one form to another. For example, you can use a
// transform to convert a Celsius data stream to Fahrenheit by applying the
// transformation expression to each data point of the Celsius stream. A transform
// can only have a data type of DOUBLE and consume properties with data types of
// INTEGER or DOUBLE. For more information, see Transforms
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#transforms)
// in the IoT SiteWise User Guide.
type Transform struct {

	// The mathematical expression that defines the transformation function. You can
	// specify up to 10 variables per expression. You can specify up to 10 functions
	// per expression. For more information, see Quotas
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the
	// IoT SiteWise User Guide.
	//
	// This member is required.
	Expression *string

	// The list of variables used in the expression.
	//
	// This member is required.
	Variables []ExpressionVariable

	// The processing configuration for the given transform property. You can configure
	// transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud.
	// You can also configure transforms to be computed at the edge or in the cloud.
	ProcessingConfig *TransformProcessingConfig

	noSmithyDocumentSerde
}

// The processing configuration for the given transform property. You can configure
// transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud.
// You can also configure transforms to be computed at the edge or in the cloud.
type TransformProcessingConfig struct {

	// The compute location for the given transform property.
	//
	// This member is required.
	ComputeLocation ComputeLocation

	// The forwarding configuration for a given property.
	ForwardingConfig *ForwardingConfig

	noSmithyDocumentSerde
}

// Contains a tumbling window, which is a repeating fixed-sized, non-overlapping,
// and contiguous time window. You use this window in metrics to aggregate data
// from properties and other assets. You can use m, h, d, and w when you specify an
// interval or offset. Note that m represents minutes, and w represents weeks. You
// can also use s to represent seconds in offset. The interval and offset
// parameters support the ISO 8601 format (https://en.wikipedia.org/wiki/ISO_8601).
// For example, PT5S represents five seconds, PT5M represents five minutes, and
// PT5H represents five hours.
type TumblingWindow struct {

	// The time interval for the tumbling window. The interval time must be between 1
	// minute and 1 week. IoT SiteWise computes the 1w interval the end of Sunday at
	// midnight each week (UTC), the 1d interval at the end of each day at midnight
	// (UTC), the 1h interval at the end of each hour, and so on. When IoT SiteWise
	// aggregates data points for metric computations, the start of each interval is
	// exclusive and the end of each interval is inclusive. IoT SiteWise places the
	// computed data point at the end of the interval.
	//
	// This member is required.
	Interval *string

	// The offset for the tumbling window. The offset parameter accepts the
	// following:
	//
	// * The offset time. For example, if you specify 18h for offset and 1d
	// for interval, IoT SiteWise aggregates data in one of the following ways:
	//
	// * If
	// you create the metric before or at 6:00 PM (UTC), you get the first aggregation
	// result at 6 PM (UTC) on the day when you create the metric.
	//
	// * If you create the
	// metric after 6:00 PM (UTC), you get the first aggregation result at 6 PM (UTC)
	// the next day.
	//
	// * The ISO 8601 format. For example, if you specify PT18H for
	// offset and 1d for interval, IoT SiteWise aggregates data in one of the following
	// ways:
	//
	// * If you create the metric before or at 6:00 PM (UTC), you get the first
	// aggregation result at 6 PM (UTC) on the day when you create the metric.
	//
	// * If
	// you create the metric after 6:00 PM (UTC), you get the first aggregation result
	// at 6 PM (UTC) the next day.
	//
	// * The 24-hour clock. For example, if you specify
	// 00:03:00 for offset and 5m for interval, and you create the metric at 2 PM
	// (UTC), you get the first aggregation result at 2:03 PM (UTC). You get the second
	// aggregation result at 2:08 PM (UTC).
	//
	// * The offset time zone. For example, if
	// you specify 2021-07-23T18:00-08 for offset and 1d for interval, IoT SiteWise
	// aggregates data in one of the following ways:
	//
	// * If you create the metric before
	// or at 6:00 PM (PST), you get the first aggregation result at 6 PM (PST) on the
	// day when you create the metric.
	//
	// * If you create the metric after 6:00 PM (PST),
	// you get the first aggregation result at 6 PM (PST) the next day.
	Offset *string

	noSmithyDocumentSerde
}

// Contains information for a user identity in an access policy.
type UserIdentity struct {

	// The Amazon Web Services SSO ID of the user.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Identifies a property value used in an expression.
type VariableValue struct {

	// The ID of the property to use as the variable. You can use the property name if
	// it's from the same asset model.
	//
	// This member is required.
	PropertyId *string

	// The ID of the hierarchy to query for the property ID. You can use the
	// hierarchy's name instead of the hierarchy's ID. You use a hierarchy ID instead
	// of a model ID because you can have several hierarchies using the same model and
	// therefore the same propertyId. For example, you might have separately grouped
	// assets that come from the same asset model. For more information, see Asset
	// hierarchies
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the IoT SiteWise User Guide.
	HierarchyId *string

	noSmithyDocumentSerde
}

// Contains an asset property value (of a single type only).
type Variant struct {

	// Asset property data of type Boolean (true or false).
	BooleanValue *bool

	// Asset property data of type double (floating point number).
	DoubleValue *float64

	// Asset property data of type integer (whole number).
	IntegerValue *int32

	// Asset property data of type string (sequence of characters).
	StringValue *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
