// Code generated by smithy-go-codegen DO NOT EDIT.

package iotdeviceadvisor

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about a Device Advisor test suite run.
func (c *Client) GetSuiteRun(ctx context.Context, params *GetSuiteRunInput, optFns ...func(*Options)) (*GetSuiteRunOutput, error) {
	if params == nil {
		params = &GetSuiteRunInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSuiteRun", params, optFns, c.addOperationGetSuiteRunMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSuiteRunOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSuiteRunInput struct {

	// Suite definition Id for the test suite run.
	//
	// This member is required.
	SuiteDefinitionId *string

	// Suite run Id for the test suite run.
	//
	// This member is required.
	SuiteRunId *string

	noSmithyDocumentSerde
}

type GetSuiteRunOutput struct {

	// Date (in Unix epoch time) when the test suite run ended.
	EndTime *time.Time

	// Error reason for any test suite run failure.
	ErrorReason *string

	// Date (in Unix epoch time) when the test suite run was started.
	StartTime *time.Time

	// Status for the test suite run.
	Status types.SuiteRunStatus

	// Suite definition Id for the test suite run.
	SuiteDefinitionId *string

	// Suite definition version for the test suite run.
	SuiteDefinitionVersion *string

	// The ARN of the suite run.
	SuiteRunArn *string

	// Suite run configuration for the test suite run.
	SuiteRunConfiguration *types.SuiteRunConfiguration

	// Suite run Id for the test suite run.
	SuiteRunId *string

	// The tags attached to the suite run.
	Tags map[string]string

	// Test results for the test suite run.
	TestResult *types.TestResult

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSuiteRunMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSuiteRun{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSuiteRun{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetSuiteRunValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSuiteRun(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSuiteRun(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "iotdeviceadvisor",
		OperationName: "GetSuiteRun",
	}
}
