// Code generated by smithy-go-codegen DO NOT EDIT.

package iot

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the Device Defender security profiles attached to a target (thing group).
func (c *Client) ListSecurityProfilesForTarget(ctx context.Context, params *ListSecurityProfilesForTargetInput, optFns ...func(*Options)) (*ListSecurityProfilesForTargetOutput, error) {
	if params == nil {
		params = &ListSecurityProfilesForTargetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSecurityProfilesForTarget", params, optFns, c.addOperationListSecurityProfilesForTargetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSecurityProfilesForTargetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSecurityProfilesForTargetInput struct {

	// The ARN of the target (thing group) whose attached security profiles you want to
	// get.
	//
	// This member is required.
	SecurityProfileTargetArn *string

	// The maximum number of results to return at one time.
	MaxResults *int32

	// The token for the next set of results.
	NextToken *string

	// If true, return child groups too.
	Recursive bool

	noSmithyDocumentSerde
}

type ListSecurityProfilesForTargetOutput struct {

	// A token that can be used to retrieve the next set of results, or null if there
	// are no additional results.
	NextToken *string

	// A list of security profiles and their associated targets.
	SecurityProfileTargetMappings []types.SecurityProfileTargetMapping

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSecurityProfilesForTargetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSecurityProfilesForTarget{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSecurityProfilesForTarget{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListSecurityProfilesForTargetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSecurityProfilesForTarget(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSecurityProfilesForTargetAPIClient is a client that implements the
// ListSecurityProfilesForTarget operation.
type ListSecurityProfilesForTargetAPIClient interface {
	ListSecurityProfilesForTarget(context.Context, *ListSecurityProfilesForTargetInput, ...func(*Options)) (*ListSecurityProfilesForTargetOutput, error)
}

var _ ListSecurityProfilesForTargetAPIClient = (*Client)(nil)

// ListSecurityProfilesForTargetPaginatorOptions is the paginator options for
// ListSecurityProfilesForTarget
type ListSecurityProfilesForTargetPaginatorOptions struct {
	// The maximum number of results to return at one time.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSecurityProfilesForTargetPaginator is a paginator for
// ListSecurityProfilesForTarget
type ListSecurityProfilesForTargetPaginator struct {
	options   ListSecurityProfilesForTargetPaginatorOptions
	client    ListSecurityProfilesForTargetAPIClient
	params    *ListSecurityProfilesForTargetInput
	nextToken *string
	firstPage bool
}

// NewListSecurityProfilesForTargetPaginator returns a new
// ListSecurityProfilesForTargetPaginator
func NewListSecurityProfilesForTargetPaginator(client ListSecurityProfilesForTargetAPIClient, params *ListSecurityProfilesForTargetInput, optFns ...func(*ListSecurityProfilesForTargetPaginatorOptions)) *ListSecurityProfilesForTargetPaginator {
	if params == nil {
		params = &ListSecurityProfilesForTargetInput{}
	}

	options := ListSecurityProfilesForTargetPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSecurityProfilesForTargetPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSecurityProfilesForTargetPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListSecurityProfilesForTarget page.
func (p *ListSecurityProfilesForTargetPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSecurityProfilesForTargetOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListSecurityProfilesForTarget(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListSecurityProfilesForTarget(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "execute-api",
		OperationName: "ListSecurityProfilesForTarget",
	}
}
