// Code generated by smithy-go-codegen DO NOT EDIT.

package honeycode

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/honeycode/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The ListTableColumns API allows you to retrieve a list of all the columns in a
// table in a workbook.
func (c *Client) ListTableColumns(ctx context.Context, params *ListTableColumnsInput, optFns ...func(*Options)) (*ListTableColumnsOutput, error) {
	if params == nil {
		params = &ListTableColumnsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTableColumns", params, optFns, c.addOperationListTableColumnsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTableColumnsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTableColumnsInput struct {

	// The ID of the table whose columns are being retrieved. If a table with the
	// specified id could not be found, this API throws ResourceNotFoundException.
	//
	// This member is required.
	TableId *string

	// The ID of the workbook that contains the table whose columns are being
	// retrieved. If a workbook with the specified id could not be found, this API
	// throws ResourceNotFoundException.
	//
	// This member is required.
	WorkbookId *string

	// This parameter is optional. If a nextToken is not specified, the API returns the
	// first page of data. Pagination tokens expire after 1 hour. If you use a token
	// that was returned more than an hour back, the API will throw
	// ValidationException.
	NextToken *string

	noSmithyDocumentSerde
}

type ListTableColumnsOutput struct {

	// The list of columns in the table.
	//
	// This member is required.
	TableColumns []types.TableColumn

	// Provides the pagination token to load the next page if there are more results
	// matching the request. If a pagination token is not present in the response, it
	// means that all data matching the request has been loaded.
	NextToken *string

	// Indicates the cursor of the workbook at which the data returned by this request
	// is read. Workbook cursor keeps increasing with every update and the increments
	// are not sequential.
	WorkbookCursor int64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTableColumnsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTableColumns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTableColumns{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListTableColumnsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTableColumns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTableColumnsAPIClient is a client that implements the ListTableColumns
// operation.
type ListTableColumnsAPIClient interface {
	ListTableColumns(context.Context, *ListTableColumnsInput, ...func(*Options)) (*ListTableColumnsOutput, error)
}

var _ ListTableColumnsAPIClient = (*Client)(nil)

// ListTableColumnsPaginatorOptions is the paginator options for ListTableColumns
type ListTableColumnsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTableColumnsPaginator is a paginator for ListTableColumns
type ListTableColumnsPaginator struct {
	options   ListTableColumnsPaginatorOptions
	client    ListTableColumnsAPIClient
	params    *ListTableColumnsInput
	nextToken *string
	firstPage bool
}

// NewListTableColumnsPaginator returns a new ListTableColumnsPaginator
func NewListTableColumnsPaginator(client ListTableColumnsAPIClient, params *ListTableColumnsInput, optFns ...func(*ListTableColumnsPaginatorOptions)) *ListTableColumnsPaginator {
	if params == nil {
		params = &ListTableColumnsInput{}
	}

	options := ListTableColumnsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTableColumnsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTableColumnsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListTableColumns page.
func (p *ListTableColumnsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTableColumnsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	result, err := p.client.ListTableColumns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListTableColumns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "honeycode",
		OperationName: "ListTableColumns",
	}
}
