// Code generated by smithy-go-codegen DO NOT EDIT.

package health

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/health/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"strings"
)

type awsAwsjson11_serializeOpDescribeAffectedAccountsForOrganization struct {
}

func (*awsAwsjson11_serializeOpDescribeAffectedAccountsForOrganization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeAffectedAccountsForOrganization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAffectedAccountsForOrganizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DescribeAffectedAccountsForOrganization")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeAffectedAccountsForOrganizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeAffectedEntities struct {
}

func (*awsAwsjson11_serializeOpDescribeAffectedEntities) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeAffectedEntities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAffectedEntitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DescribeAffectedEntities")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeAffectedEntitiesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeAffectedEntitiesForOrganization struct {
}

func (*awsAwsjson11_serializeOpDescribeAffectedEntitiesForOrganization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeAffectedEntitiesForOrganization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAffectedEntitiesForOrganizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DescribeAffectedEntitiesForOrganization")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeAffectedEntitiesForOrganizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeEntityAggregates struct {
}

func (*awsAwsjson11_serializeOpDescribeEntityAggregates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeEntityAggregates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEntityAggregatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DescribeEntityAggregates")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeEntityAggregatesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeEventAggregates struct {
}

func (*awsAwsjson11_serializeOpDescribeEventAggregates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeEventAggregates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEventAggregatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DescribeEventAggregates")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeEventAggregatesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeEventDetails struct {
}

func (*awsAwsjson11_serializeOpDescribeEventDetails) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeEventDetails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEventDetailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DescribeEventDetails")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeEventDetailsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeEventDetailsForOrganization struct {
}

func (*awsAwsjson11_serializeOpDescribeEventDetailsForOrganization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeEventDetailsForOrganization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEventDetailsForOrganizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DescribeEventDetailsForOrganization")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeEventDetailsForOrganizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeEvents struct {
}

func (*awsAwsjson11_serializeOpDescribeEvents) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeEvents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEventsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DescribeEvents")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeEventsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeEventsForOrganization struct {
}

func (*awsAwsjson11_serializeOpDescribeEventsForOrganization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeEventsForOrganization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEventsForOrganizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DescribeEventsForOrganization")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeEventsForOrganizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeEventTypes struct {
}

func (*awsAwsjson11_serializeOpDescribeEventTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeEventTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEventTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DescribeEventTypes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeEventTypesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeHealthServiceStatusForOrganization struct {
}

func (*awsAwsjson11_serializeOpDescribeHealthServiceStatusForOrganization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeHealthServiceStatusForOrganization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeHealthServiceStatusForOrganizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DescribeHealthServiceStatusForOrganization")

	if request, err = request.SetStream(strings.NewReader(`{}`)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDisableHealthServiceAccessForOrganization struct {
}

func (*awsAwsjson11_serializeOpDisableHealthServiceAccessForOrganization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDisableHealthServiceAccessForOrganization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableHealthServiceAccessForOrganizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.DisableHealthServiceAccessForOrganization")

	if request, err = request.SetStream(strings.NewReader(`{}`)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpEnableHealthServiceAccessForOrganization struct {
}

func (*awsAwsjson11_serializeOpEnableHealthServiceAccessForOrganization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpEnableHealthServiceAccessForOrganization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableHealthServiceAccessForOrganizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSHealth_20160804.EnableHealthServiceAccessForOrganization")

	if request, err = request.SetStream(strings.NewReader(`{}`)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentAvailabilityZones(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAwsAccountIdsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDateTimeRange(v *types.DateTimeRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.From != nil {
		ok := object.Key("from")
		ok.Double(smithytime.FormatEpochSeconds(*v.From))
	}

	if v.To != nil {
		ok := object.Key("to")
		ok.Double(smithytime.FormatEpochSeconds(*v.To))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDateTimeRangeList(v []types.DateTimeRange, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentDateTimeRange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentEntityArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentEntityFilter(v *types.EntityFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityArns != nil {
		ok := object.Key("entityArns")
		if err := awsAwsjson11_serializeDocumentEntityArnList(v.EntityArns, ok); err != nil {
			return err
		}
	}

	if v.EntityValues != nil {
		ok := object.Key("entityValues")
		if err := awsAwsjson11_serializeDocumentEntityValueList(v.EntityValues, ok); err != nil {
			return err
		}
	}

	if v.EventArns != nil {
		ok := object.Key("eventArns")
		if err := awsAwsjson11_serializeDocumentEventArnList(v.EventArns, ok); err != nil {
			return err
		}
	}

	if v.LastUpdatedTimes != nil {
		ok := object.Key("lastUpdatedTimes")
		if err := awsAwsjson11_serializeDocumentDateTimeRangeList(v.LastUpdatedTimes, ok); err != nil {
			return err
		}
	}

	if v.StatusCodes != nil {
		ok := object.Key("statusCodes")
		if err := awsAwsjson11_serializeDocumentEntityStatusCodeList(v.StatusCodes, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTagFilter(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentEntityStatusCodeList(v []types.EntityStatusCode, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentEntityValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentEventAccountFilter(v *types.EventAccountFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsAccountId != nil {
		ok := object.Key("awsAccountId")
		ok.String(*v.AwsAccountId)
	}

	if v.EventArn != nil {
		ok := object.Key("eventArn")
		ok.String(*v.EventArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEventArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentEventArnsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentEventFilter(v *types.EventFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZones != nil {
		ok := object.Key("availabilityZones")
		if err := awsAwsjson11_serializeDocumentAvailabilityZones(v.AvailabilityZones, ok); err != nil {
			return err
		}
	}

	if v.EndTimes != nil {
		ok := object.Key("endTimes")
		if err := awsAwsjson11_serializeDocumentDateTimeRangeList(v.EndTimes, ok); err != nil {
			return err
		}
	}

	if v.EntityArns != nil {
		ok := object.Key("entityArns")
		if err := awsAwsjson11_serializeDocumentEntityArnList(v.EntityArns, ok); err != nil {
			return err
		}
	}

	if v.EntityValues != nil {
		ok := object.Key("entityValues")
		if err := awsAwsjson11_serializeDocumentEntityValueList(v.EntityValues, ok); err != nil {
			return err
		}
	}

	if v.EventArns != nil {
		ok := object.Key("eventArns")
		if err := awsAwsjson11_serializeDocumentEventArnList(v.EventArns, ok); err != nil {
			return err
		}
	}

	if v.EventStatusCodes != nil {
		ok := object.Key("eventStatusCodes")
		if err := awsAwsjson11_serializeDocumentEventStatusCodeList(v.EventStatusCodes, ok); err != nil {
			return err
		}
	}

	if v.EventTypeCategories != nil {
		ok := object.Key("eventTypeCategories")
		if err := awsAwsjson11_serializeDocumentEventTypeCategoryList2(v.EventTypeCategories, ok); err != nil {
			return err
		}
	}

	if v.EventTypeCodes != nil {
		ok := object.Key("eventTypeCodes")
		if err := awsAwsjson11_serializeDocumentEventTypeList2(v.EventTypeCodes, ok); err != nil {
			return err
		}
	}

	if v.LastUpdatedTimes != nil {
		ok := object.Key("lastUpdatedTimes")
		if err := awsAwsjson11_serializeDocumentDateTimeRangeList(v.LastUpdatedTimes, ok); err != nil {
			return err
		}
	}

	if v.Regions != nil {
		ok := object.Key("regions")
		if err := awsAwsjson11_serializeDocumentRegionList(v.Regions, ok); err != nil {
			return err
		}
	}

	if v.Services != nil {
		ok := object.Key("services")
		if err := awsAwsjson11_serializeDocumentServiceList(v.Services, ok); err != nil {
			return err
		}
	}

	if v.StartTimes != nil {
		ok := object.Key("startTimes")
		if err := awsAwsjson11_serializeDocumentDateTimeRangeList(v.StartTimes, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTagFilter(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentEventStatusCodeList(v []types.EventStatusCode, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentEventTypeCategoryList(v []types.EventTypeCategory, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentEventTypeCategoryList2(v []types.EventTypeCategory, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentEventTypeCodeList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentEventTypeFilter(v *types.EventTypeFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventTypeCategories != nil {
		ok := object.Key("eventTypeCategories")
		if err := awsAwsjson11_serializeDocumentEventTypeCategoryList(v.EventTypeCategories, ok); err != nil {
			return err
		}
	}

	if v.EventTypeCodes != nil {
		ok := object.Key("eventTypeCodes")
		if err := awsAwsjson11_serializeDocumentEventTypeCodeList(v.EventTypeCodes, ok); err != nil {
			return err
		}
	}

	if v.Services != nil {
		ok := object.Key("services")
		if err := awsAwsjson11_serializeDocumentServiceList(v.Services, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentEventTypeList2(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentOrganizationEntityFiltersList(v []types.EventAccountFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentEventAccountFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentOrganizationEventDetailFiltersList(v []types.EventAccountFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentEventAccountFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentOrganizationEventFilter(v *types.OrganizationEventFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsAccountIds != nil {
		ok := object.Key("awsAccountIds")
		if err := awsAwsjson11_serializeDocumentAwsAccountIdsList(v.AwsAccountIds, ok); err != nil {
			return err
		}
	}

	if v.EndTime != nil {
		ok := object.Key("endTime")
		if err := awsAwsjson11_serializeDocumentDateTimeRange(v.EndTime, ok); err != nil {
			return err
		}
	}

	if v.EntityArns != nil {
		ok := object.Key("entityArns")
		if err := awsAwsjson11_serializeDocumentEntityArnList(v.EntityArns, ok); err != nil {
			return err
		}
	}

	if v.EntityValues != nil {
		ok := object.Key("entityValues")
		if err := awsAwsjson11_serializeDocumentEntityValueList(v.EntityValues, ok); err != nil {
			return err
		}
	}

	if v.EventStatusCodes != nil {
		ok := object.Key("eventStatusCodes")
		if err := awsAwsjson11_serializeDocumentEventStatusCodeList(v.EventStatusCodes, ok); err != nil {
			return err
		}
	}

	if v.EventTypeCategories != nil {
		ok := object.Key("eventTypeCategories")
		if err := awsAwsjson11_serializeDocumentEventTypeCategoryList2(v.EventTypeCategories, ok); err != nil {
			return err
		}
	}

	if v.EventTypeCodes != nil {
		ok := object.Key("eventTypeCodes")
		if err := awsAwsjson11_serializeDocumentEventTypeList2(v.EventTypeCodes, ok); err != nil {
			return err
		}
	}

	if v.LastUpdatedTime != nil {
		ok := object.Key("lastUpdatedTime")
		if err := awsAwsjson11_serializeDocumentDateTimeRange(v.LastUpdatedTime, ok); err != nil {
			return err
		}
	}

	if v.Regions != nil {
		ok := object.Key("regions")
		if err := awsAwsjson11_serializeDocumentRegionList(v.Regions, ok); err != nil {
			return err
		}
	}

	if v.Services != nil {
		ok := object.Key("services")
		if err := awsAwsjson11_serializeDocumentServiceList(v.Services, ok); err != nil {
			return err
		}
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		if err := awsAwsjson11_serializeDocumentDateTimeRange(v.StartTime, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRegionList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentServiceList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTagFilter(v []map[string]string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsAwsjson11_serializeDocumentTagSet(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTagSet(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeAffectedAccountsForOrganizationInput(v *DescribeAffectedAccountsForOrganizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventArn != nil {
		ok := object.Key("eventArn")
		ok.String(*v.EventArn)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeAffectedEntitiesForOrganizationInput(v *DescribeAffectedEntitiesForOrganizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Locale != nil {
		ok := object.Key("locale")
		ok.String(*v.Locale)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.OrganizationEntityFilters != nil {
		ok := object.Key("organizationEntityFilters")
		if err := awsAwsjson11_serializeDocumentOrganizationEntityFiltersList(v.OrganizationEntityFilters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeAffectedEntitiesInput(v *DescribeAffectedEntitiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsAwsjson11_serializeDocumentEntityFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.Locale != nil {
		ok := object.Key("locale")
		ok.String(*v.Locale)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeEntityAggregatesInput(v *DescribeEntityAggregatesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventArns != nil {
		ok := object.Key("eventArns")
		if err := awsAwsjson11_serializeDocumentEventArnsList(v.EventArns, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeEventAggregatesInput(v *DescribeEventAggregatesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AggregateField) > 0 {
		ok := object.Key("aggregateField")
		ok.String(string(v.AggregateField))
	}

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsAwsjson11_serializeDocumentEventFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeEventDetailsForOrganizationInput(v *DescribeEventDetailsForOrganizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Locale != nil {
		ok := object.Key("locale")
		ok.String(*v.Locale)
	}

	if v.OrganizationEventDetailFilters != nil {
		ok := object.Key("organizationEventDetailFilters")
		if err := awsAwsjson11_serializeDocumentOrganizationEventDetailFiltersList(v.OrganizationEventDetailFilters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeEventDetailsInput(v *DescribeEventDetailsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventArns != nil {
		ok := object.Key("eventArns")
		if err := awsAwsjson11_serializeDocumentEventArnList(v.EventArns, ok); err != nil {
			return err
		}
	}

	if v.Locale != nil {
		ok := object.Key("locale")
		ok.String(*v.Locale)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeEventsForOrganizationInput(v *DescribeEventsForOrganizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsAwsjson11_serializeDocumentOrganizationEventFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.Locale != nil {
		ok := object.Key("locale")
		ok.String(*v.Locale)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeEventsInput(v *DescribeEventsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsAwsjson11_serializeDocumentEventFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.Locale != nil {
		ok := object.Key("locale")
		ok.String(*v.Locale)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeEventTypesInput(v *DescribeEventTypesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsAwsjson11_serializeDocumentEventTypeFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.Locale != nil {
		ok := object.Key("locale")
		ok.String(*v.Locale)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}
