// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Defines an action to be initiated by a trigger.
type Action struct {

	// The job arguments used when this trigger fires. For this job run, they replace
	// the default arguments set in the job definition itself. You can specify
	// arguments here that your own job-execution script consumes, as well as arguments
	// that Glue itself consumes. For information about how to specify and consume your
	// own Job arguments, see the Calling Glue APIs in Python
	// (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide. For information about the key-value pairs that
	// Glue consumes to set up your job, see the Special Parameters Used by Glue
	// (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	Arguments map[string]string

	// The name of the crawler to be used with this action.
	CrawlerName *string

	// The name of a job to be run.
	JobName *string

	// Specifies configuration properties of a job run notification.
	NotificationProperty *NotificationProperty

	// The name of the SecurityConfiguration structure to be used with this action.
	SecurityConfiguration *string

	// The JobRun timeout in minutes. This is the maximum time that a job run can
	// consume resources before it is terminated and enters TIMEOUT status. The default
	// is 2,880 minutes (48 hours). This overrides the timeout value set in the parent
	// job.
	Timeout *int32

	noSmithyDocumentSerde
}

// A list of errors that can occur when registering partition indexes for an
// existing table. These errors give the details about why an index registration
// failed and provide a limited number of partitions in the response, so that you
// can fix the partitions at fault and try registering the index again. The most
// common set of errors that can occur are categorized as follows:
//
// *
// EncryptedPartitionError: The partitions are encrypted.
//
// *
// InvalidPartitionTypeDataError: The partition value doesn't match the data type
// for that partition column.
//
// * MissingPartitionValueError: The partitions are
// encrypted.
//
// * UnsupportedPartitionCharacterError: Characters inside the
// partition value are not supported. For example: U+0000 , U+0001, U+0002.
//
// *
// InternalError: Any error which does not belong to other error codes.
type BackfillError struct {

	// The error code for an error that occurred when registering partition indexes for
	// an existing table.
	Code BackfillErrorCode

	// A list of a limited number of partitions in the response.
	Partitions []PartitionValueList

	noSmithyDocumentSerde
}

// Records an error that occurred when attempting to stop a specified job run.
type BatchStopJobRunError struct {

	// Specifies details about the error that was encountered.
	ErrorDetail *ErrorDetail

	// The name of the job definition that is used in the job run in question.
	JobName *string

	// The JobRunId of the job run in question.
	JobRunId *string

	noSmithyDocumentSerde
}

// Records a successful request to stop a specified JobRun.
type BatchStopJobRunSuccessfulSubmission struct {

	// The name of the job definition used in the job run that was stopped.
	JobName *string

	// The JobRunId of the job run that was stopped.
	JobRunId *string

	noSmithyDocumentSerde
}

// Contains information about a batch update partition error.
type BatchUpdatePartitionFailureEntry struct {

	// The details about the batch update partition error.
	ErrorDetail *ErrorDetail

	// A list of values defining the partitions.
	PartitionValueList []string

	noSmithyDocumentSerde
}

// A structure that contains the values and structure used to update a partition.
type BatchUpdatePartitionRequestEntry struct {

	// The structure used to update a partition.
	//
	// This member is required.
	PartitionInput *PartitionInput

	// A list of values defining the partitions.
	//
	// This member is required.
	PartitionValueList []string

	noSmithyDocumentSerde
}

// Defines column statistics supported for bit sequence data values.
type BinaryColumnStatisticsData struct {

	// The average bit sequence length in the column.
	//
	// This member is required.
	AverageLength float64

	// The size of the longest bit sequence in the column.
	//
	// This member is required.
	MaximumLength int64

	// The number of null values in the column.
	//
	// This member is required.
	NumberOfNulls int64

	noSmithyDocumentSerde
}

// The details of a blueprint.
type Blueprint struct {

	// Specifies the path in Amazon S3 where the blueprint is published.
	BlueprintLocation *string

	// Specifies a path in Amazon S3 where the blueprint is copied when you call
	// CreateBlueprint/UpdateBlueprint to register the blueprint in Glue.
	BlueprintServiceLocation *string

	// The date and time the blueprint was registered.
	CreatedOn *time.Time

	// The description of the blueprint.
	Description *string

	// An error message.
	ErrorMessage *string

	// When there are multiple versions of a blueprint and the latest version has some
	// errors, this attribute indicates the last successful blueprint definition that
	// is available with the service.
	LastActiveDefinition *LastActiveDefinition

	// The date and time the blueprint was last modified.
	LastModifiedOn *time.Time

	// The name of the blueprint.
	Name *string

	// A JSON string that indicates the list of parameter specifications for the
	// blueprint.
	ParameterSpec *string

	// The status of the blueprint registration.
	//
	// * Creating — The blueprint
	// registration is in progress.
	//
	// * Active — The blueprint has been successfully
	// registered.
	//
	// * Updating — An update to the blueprint registration is in
	// progress.
	//
	// * Failed — The blueprint registration failed.
	Status BlueprintStatus

	noSmithyDocumentSerde
}

// The details of a blueprint.
type BlueprintDetails struct {

	// The name of the blueprint.
	BlueprintName *string

	// The run ID for this blueprint.
	RunId *string

	noSmithyDocumentSerde
}

// The details of a blueprint run.
type BlueprintRun struct {

	// The name of the blueprint.
	BlueprintName *string

	// The date and time that the blueprint run completed.
	CompletedOn *time.Time

	// Indicates any errors that are seen while running the blueprint.
	ErrorMessage *string

	// The blueprint parameters as a string. You will have to provide a value for each
	// key that is required from the parameter spec that is defined in the
	// Blueprint$ParameterSpec.
	Parameters *string

	// The role ARN. This role will be assumed by the Glue service and will be used to
	// create the workflow and other entities of a workflow.
	RoleArn *string

	// If there are any errors while creating the entities of a workflow, we try to
	// roll back the created entities until that point and delete them. This attribute
	// indicates the errors seen while trying to delete the entities that are created.
	RollbackErrorMessage *string

	// The run ID for this blueprint run.
	RunId *string

	// The date and time that the blueprint run started.
	StartedOn *time.Time

	// The state of the blueprint run. Possible values are:
	//
	// * Running — The blueprint
	// run is in progress.
	//
	// * Succeeded — The blueprint run completed successfully.
	//
	// *
	// Failed — The blueprint run failed and rollback is complete.
	//
	// * Rolling Back —
	// The blueprint run failed and rollback is in progress.
	State BlueprintRunState

	// The name of a workflow that is created as a result of a successful blueprint
	// run. If a blueprint run has an error, there will not be a workflow created.
	WorkflowName *string

	noSmithyDocumentSerde
}

// Defines column statistics supported for Boolean data columns.
type BooleanColumnStatisticsData struct {

	// The number of false values in the column.
	//
	// This member is required.
	NumberOfFalses int64

	// The number of null values in the column.
	//
	// This member is required.
	NumberOfNulls int64

	// The number of true values in the column.
	//
	// This member is required.
	NumberOfTrues int64

	noSmithyDocumentSerde
}

// Specifies a table definition in the Glue Data Catalog.
type CatalogEntry struct {

	// The database in which the table metadata resides.
	//
	// This member is required.
	DatabaseName *string

	// The name of the table in question.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// A structure containing migration status information.
type CatalogImportStatus struct {

	// True if the migration has completed, or False otherwise.
	ImportCompleted bool

	// The time that the migration was started.
	ImportTime *time.Time

	// The name of the person who initiated the migration.
	ImportedBy *string

	noSmithyDocumentSerde
}

// Specifies an Glue Data Catalog target.
type CatalogTarget struct {

	// The name of the database to be synchronized.
	//
	// This member is required.
	DatabaseName *string

	// A list of the tables to be synchronized.
	//
	// This member is required.
	Tables []string

	noSmithyDocumentSerde
}

// Classifiers are triggered during a crawl task. A classifier checks whether a
// given file is in a format it can handle. If it is, the classifier creates a
// schema in the form of a StructType object that matches that data format. You can
// use the standard classifiers that Glue provides, or you can write your own
// classifiers to best categorize your data sources and specify the appropriate
// schemas to use for them. A classifier can be a grok classifier, an XML
// classifier, a JSON classifier, or a custom CSV classifier, as specified in one
// of the fields in the Classifier object.
type Classifier struct {

	// A classifier for comma-separated values (CSV).
	CsvClassifier *CsvClassifier

	// A classifier that uses grok.
	GrokClassifier *GrokClassifier

	// A classifier for JSON content.
	JsonClassifier *JsonClassifier

	// A classifier for XML content.
	XMLClassifier *XMLClassifier

	noSmithyDocumentSerde
}

// Specifies how Amazon CloudWatch data should be encrypted.
type CloudWatchEncryption struct {

	// The encryption mode to use for CloudWatch data.
	CloudWatchEncryptionMode CloudWatchEncryptionMode

	// The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Represents a directional edge in a directed acyclic graph (DAG).
type CodeGenEdge struct {

	// The ID of the node at which the edge starts.
	//
	// This member is required.
	Source *string

	// The ID of the node at which the edge ends.
	//
	// This member is required.
	Target *string

	// The target of the edge.
	TargetParameter *string

	noSmithyDocumentSerde
}

// Represents a node in a directed acyclic graph (DAG)
type CodeGenNode struct {

	// Properties of the node, in the form of name-value pairs.
	//
	// This member is required.
	Args []CodeGenNodeArg

	// A node identifier that is unique within the node's graph.
	//
	// This member is required.
	Id *string

	// The type of node that this is.
	//
	// This member is required.
	NodeType *string

	// The line number of the node.
	LineNumber int32

	noSmithyDocumentSerde
}

// An argument or property of a node.
type CodeGenNodeArg struct {

	// The name of the argument or property.
	//
	// This member is required.
	Name *string

	// The value of the argument or property.
	//
	// This member is required.
	Value *string

	// True if the value is used as a parameter.
	Param bool

	noSmithyDocumentSerde
}

// A column in a Table.
type Column struct {

	// The name of the Column.
	//
	// This member is required.
	Name *string

	// A free-form text comment.
	Comment *string

	// These key-value pairs define properties associated with the column.
	Parameters map[string]string

	// The data type of the Column.
	Type *string

	noSmithyDocumentSerde
}

// Encapsulates a column name that failed and the reason for failure.
type ColumnError struct {

	// The name of the column that failed.
	ColumnName *string

	// An error message with the reason for the failure of an operation.
	Error *ErrorDetail

	noSmithyDocumentSerde
}

// A structure containing the column name and column importance score for a column.
// Column importance helps you understand how columns contribute to your model, by
// identifying which columns in your records are more important than others.
type ColumnImportance struct {

	// The name of a column.
	ColumnName *string

	// The column importance score for the column, as a decimal.
	Importance *float64

	noSmithyDocumentSerde
}

// Represents the generated column-level statistics for a table or partition.
type ColumnStatistics struct {

	// The timestamp of when column statistics were generated.
	//
	// This member is required.
	AnalyzedTime *time.Time

	// Name of column which statistics belong to.
	//
	// This member is required.
	ColumnName *string

	// The data type of the column.
	//
	// This member is required.
	ColumnType *string

	// A ColumnStatisticData object that contains the statistics data values.
	//
	// This member is required.
	StatisticsData *ColumnStatisticsData

	noSmithyDocumentSerde
}

// Contains the individual types of column statistics data. Only one data object
// should be set and indicated by the Type attribute.
type ColumnStatisticsData struct {

	// The type of column statistics data.
	//
	// This member is required.
	Type ColumnStatisticsType

	// Binary column statistics data.
	BinaryColumnStatisticsData *BinaryColumnStatisticsData

	// Boolean column statistics data.
	BooleanColumnStatisticsData *BooleanColumnStatisticsData

	// Date column statistics data.
	DateColumnStatisticsData *DateColumnStatisticsData

	// Decimal column statistics data.
	DecimalColumnStatisticsData *DecimalColumnStatisticsData

	// Double column statistics data.
	DoubleColumnStatisticsData *DoubleColumnStatisticsData

	// Long column statistics data.
	LongColumnStatisticsData *LongColumnStatisticsData

	// String column statistics data.
	StringColumnStatisticsData *StringColumnStatisticsData

	noSmithyDocumentSerde
}

// Encapsulates a ColumnStatistics object that failed and the reason for failure.
type ColumnStatisticsError struct {

	// The ColumnStatistics of the column.
	ColumnStatistics *ColumnStatistics

	// An error message with the reason for the failure of an operation.
	Error *ErrorDetail

	noSmithyDocumentSerde
}

// Defines a condition under which a trigger fires.
type Condition struct {

	// The state of the crawler to which this condition applies.
	CrawlState CrawlState

	// The name of the crawler to which this condition applies.
	CrawlerName *string

	// The name of the job whose JobRuns this condition applies to, and on which this
	// trigger waits.
	JobName *string

	// A logical operator.
	LogicalOperator LogicalOperator

	// The condition state. Currently, the only job states that a trigger can listen
	// for are SUCCEEDED, STOPPED, FAILED, and TIMEOUT. The only crawler states that a
	// trigger can listen for are SUCCEEDED, FAILED, and CANCELLED.
	State JobRunState

	noSmithyDocumentSerde
}

// The confusion matrix shows you what your transform is predicting accurately and
// what types of errors it is making. For more information, see Confusion matrix
// (https://en.wikipedia.org/wiki/Confusion_matrix) in Wikipedia.
type ConfusionMatrix struct {

	// The number of matches in the data that the transform didn't find, in the
	// confusion matrix for your transform.
	NumFalseNegatives *int64

	// The number of nonmatches in the data that the transform incorrectly classified
	// as a match, in the confusion matrix for your transform.
	NumFalsePositives *int64

	// The number of nonmatches in the data that the transform correctly rejected, in
	// the confusion matrix for your transform.
	NumTrueNegatives *int64

	// The number of matches in the data that the transform correctly found, in the
	// confusion matrix for your transform.
	NumTruePositives *int64

	noSmithyDocumentSerde
}

// Defines a connection to a data source.
type Connection struct {

	// These key-value pairs define parameters for the connection:
	//
	// * HOST - The host
	// URI: either the fully qualified domain name (FQDN) or the IPv4 address of the
	// database host.
	//
	// * PORT - The port number, between 1024 and 65535, of the port on
	// which the database host is listening for database connections.
	//
	// * USER_NAME -
	// The name under which to log in to the database. The value string for USER_NAME
	// is "USERNAME".
	//
	// * PASSWORD - A password, if one is used, for the user name.
	//
	// *
	// ENCRYPTED_PASSWORD - When you enable connection password protection by setting
	// ConnectionPasswordEncryption in the Data Catalog encryption settings, this field
	// stores the encrypted password.
	//
	// * JDBC_DRIVER_JAR_URI - The Amazon Simple
	// Storage Service (Amazon S3) path of the JAR file that contains the JDBC driver
	// to use.
	//
	// * JDBC_DRIVER_CLASS_NAME - The class name of the JDBC driver to use.
	//
	// *
	// JDBC_ENGINE - The name of the JDBC engine to use.
	//
	// * JDBC_ENGINE_VERSION - The
	// version of the JDBC engine to use.
	//
	// * CONFIG_FILES - (Reserved for future
	// use.)
	//
	// * INSTANCE_ID - The instance ID to use.
	//
	// * JDBC_CONNECTION_URL - The URL
	// for connecting to a JDBC data source.
	//
	// * JDBC_ENFORCE_SSL - A Boolean string
	// (true, false) specifying whether Secure Sockets Layer (SSL) with hostname
	// matching is enforced for the JDBC connection on the client. The default is
	// false.
	//
	// * CUSTOM_JDBC_CERT - An Amazon S3 location specifying the customer's
	// root certificate. Glue uses this root certificate to validate the customer’s
	// certificate when connecting to the customer database. Glue only handles X.509
	// certificates. The certificate provided must be DER-encoded and supplied in
	// Base64 encoding PEM format.
	//
	// * SKIP_CUSTOM_JDBC_CERT_VALIDATION - By default,
	// this is false. Glue validates the Signature algorithm and Subject Public Key
	// Algorithm for the customer certificate. The only permitted algorithms for the
	// Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the
	// Subject Public Key Algorithm, the key length must be at least 2048. You can set
	// the value of this property to true to skip Glue’s validation of the customer
	// certificate.
	//
	// * CUSTOM_JDBC_CERT_STRING - A custom JDBC certificate string which
	// is used for domain match or distinguished name match to prevent a
	// man-in-the-middle attack. In Oracle database, this is used as the
	// SSL_SERVER_CERT_DN; in Microsoft SQL Server, this is used as the
	// hostNameInCertificate.
	//
	// * CONNECTION_URL - The URL for connecting to a general
	// (non-JDBC) data source.
	//
	// * KAFKA_BOOTSTRAP_SERVERS - A comma-separated list of
	// host and port pairs that are the addresses of the Apache Kafka brokers in a
	// Kafka cluster to which a Kafka client will connect to and bootstrap itself.
	//
	// *
	// KAFKA_SSL_ENABLED - Whether to enable or disable SSL on an Apache Kafka
	// connection. Default value is "true".
	//
	// * KAFKA_CUSTOM_CERT - The Amazon S3 URL
	// for the private CA cert file (.pem format). The default is an empty string.
	//
	// *
	// KAFKA_SKIP_CUSTOM_CERT_VALIDATION - Whether to skip the validation of the CA
	// cert file or not. Glue validates for three algorithms: SHA256withRSA,
	// SHA384withRSA and SHA512withRSA. Default value is "false".
	//
	// * SECRET_ID - The
	// secret ID used for the secret manager of credentials.
	//
	// * CONNECTOR_URL - The
	// connector URL for a MARKETPLACE or CUSTOM connection.
	//
	// * CONNECTOR_TYPE - The
	// connector type for a MARKETPLACE or CUSTOM connection.
	//
	// * CONNECTOR_CLASS_NAME -
	// The connector class name for a MARKETPLACE or CUSTOM connection.
	//
	// *
	// KAFKA_CLIENT_KEYSTORE - The Amazon S3 location of the client keystore file for
	// Kafka client side authentication (Optional).
	//
	// * KAFKA_CLIENT_KEYSTORE_PASSWORD -
	// The password to access the provided keystore (Optional).
	//
	// *
	// KAFKA_CLIENT_KEY_PASSWORD - A keystore can consist of multiple keys, so this is
	// the password to access the client key to be used with the Kafka server side key
	// (Optional).
	//
	// * ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD - The encrypted version
	// of the Kafka client keystore password (if the user has the Glue encrypt
	// passwords setting selected).
	//
	// * ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD - The
	// encrypted version of the Kafka client key password (if the user has the Glue
	// encrypt passwords setting selected).
	ConnectionProperties map[string]string

	// The type of the connection. Currently, SFTP is not supported.
	ConnectionType ConnectionType

	// The time that this connection definition was created.
	CreationTime *time.Time

	// The description of the connection.
	Description *string

	// The user, group, or role that last updated this connection definition.
	LastUpdatedBy *string

	// The last time that this connection definition was updated.
	LastUpdatedTime *time.Time

	// A list of criteria that can be used in selecting this connection.
	MatchCriteria []string

	// The name of the connection definition.
	Name *string

	// A map of physical connection requirements, such as virtual private cloud (VPC)
	// and SecurityGroup, that are needed to make this connection successfully.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements

	noSmithyDocumentSerde
}

// A structure that is used to specify a connection to create or update.
type ConnectionInput struct {

	// These key-value pairs define parameters for the connection.
	//
	// This member is required.
	ConnectionProperties map[string]string

	// The type of the connection. Currently, these types are supported:
	//
	// * JDBC -
	// Designates a connection to a database through Java Database Connectivity
	// (JDBC).
	//
	// * KAFKA - Designates a connection to an Apache Kafka streaming
	// platform.
	//
	// * MONGODB - Designates a connection to a MongoDB document
	// database.
	//
	// * NETWORK - Designates a network connection to a data source within
	// an Amazon Virtual Private Cloud environment (Amazon VPC).
	//
	// * MARKETPLACE - Uses
	// configuration settings contained in a connector purchased from Amazon Web
	// Services Marketplace to read from and write to data stores that are not natively
	// supported by Glue.
	//
	// * CUSTOM - Uses configuration settings contained in a custom
	// connector to read from and write to data stores that are not natively supported
	// by Glue.
	//
	// SFTP is not supported.
	//
	// This member is required.
	ConnectionType ConnectionType

	// The name of the connection.
	//
	// This member is required.
	Name *string

	// The description of the connection.
	Description *string

	// A list of criteria that can be used in selecting this connection.
	MatchCriteria []string

	// A map of physical connection requirements, such as virtual private cloud (VPC)
	// and SecurityGroup, that are needed to successfully make this connection.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements

	noSmithyDocumentSerde
}

// The data structure used by the Data Catalog to encrypt the password as part of
// CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD
// field in the connection properties. You can enable catalog encryption or only
// password encryption. When a CreationConnection request arrives containing a
// password, the Data Catalog first encrypts the password using your KMS key. It
// then encrypts the whole connection object again if catalog encryption is also
// enabled. This encryption requires that you set KMS key permissions to enable or
// restrict access on the password key according to your security requirements. For
// example, you might want only administrators to have decrypt permission on the
// password key.
type ConnectionPasswordEncryption struct {

	// When the ReturnConnectionPasswordEncrypted flag is set to "true", passwords
	// remain encrypted in the responses of GetConnection and GetConnections. This
	// encryption takes effect independently from catalog encryption.
	//
	// This member is required.
	ReturnConnectionPasswordEncrypted bool

	// An KMS key that is used to encrypt the connection password. If connection
	// password protection is enabled, the caller of CreateConnection and
	// UpdateConnection needs at least kms:Encrypt permission on the specified KMS key,
	// to encrypt passwords before storing them in the Data Catalog. You can set the
	// decrypt permission to enable or restrict access on the password key according to
	// your security requirements.
	AwsKmsKeyId *string

	noSmithyDocumentSerde
}

// Specifies the connections used by a job.
type ConnectionsList struct {

	// A list of connections used by the job.
	Connections []string

	noSmithyDocumentSerde
}

// The details of a crawl in the workflow.
type Crawl struct {

	// The date and time on which the crawl completed.
	CompletedOn *time.Time

	// The error message associated with the crawl.
	ErrorMessage *string

	// The log group associated with the crawl.
	LogGroup *string

	// The log stream associated with the crawl.
	LogStream *string

	// The date and time on which the crawl started.
	StartedOn *time.Time

	// The state of the crawler.
	State CrawlState

	noSmithyDocumentSerde
}

// Specifies a crawler program that examines a data source and uses classifiers to
// try to determine its schema. If successful, the crawler records metadata
// concerning the data source in the Glue Data Catalog.
type Crawler struct {

	// A list of UTF-8 strings that specify the custom classifiers that are associated
	// with the crawler.
	Classifiers []string

	// Crawler configuration information. This versioned JSON string allows users to
	// specify aspects of a crawler's behavior. For more information, see Include and
	// Exclude Patterns
	// (https://docs.aws.amazon.com/glue/latest/dg/define-crawler.html#crawler-data-stores-exclude).
	Configuration *string

	// If the crawler is running, contains the total time elapsed since the last crawl
	// began.
	CrawlElapsedTime int64

	// The name of the SecurityConfiguration structure to be used by this crawler.
	CrawlerSecurityConfiguration *string

	// The time that the crawler was created.
	CreationTime *time.Time

	// The name of the database in which the crawler's output is stored.
	DatabaseName *string

	// A description of the crawler.
	Description *string

	// The status of the last crawl, and potentially error information if an error
	// occurred.
	LastCrawl *LastCrawlInfo

	// The time that the crawler was last updated.
	LastUpdated *time.Time

	// A configuration that specifies whether data lineage is enabled for the crawler.
	LineageConfiguration *LineageConfiguration

	// The name of the crawler.
	Name *string

	// A policy that specifies whether to crawl the entire dataset again, or to crawl
	// only folders that were added since the last crawler run.
	RecrawlPolicy *RecrawlPolicy

	// The Amazon Resource Name (ARN) of an IAM role that's used to access customer
	// resources, such as Amazon Simple Storage Service (Amazon S3) data.
	Role *string

	// For scheduled crawlers, the schedule when the crawler runs.
	Schedule *Schedule

	// The policy that specifies update and delete behaviors for the crawler.
	SchemaChangePolicy *SchemaChangePolicy

	// Indicates whether the crawler is running, or whether a run is pending.
	State CrawlerState

	// The prefix added to the names of tables that are created.
	TablePrefix *string

	// A collection of targets to crawl.
	Targets *CrawlerTargets

	// The version of the crawler.
	Version int64

	noSmithyDocumentSerde
}

// Metrics for a specified crawler.
type CrawlerMetrics struct {

	// The name of the crawler.
	CrawlerName *string

	// The duration of the crawler's most recent run, in seconds.
	LastRuntimeSeconds float64

	// The median duration of this crawler's runs, in seconds.
	MedianRuntimeSeconds float64

	// True if the crawler is still estimating how long it will take to complete this
	// run.
	StillEstimating bool

	// The number of tables created by this crawler.
	TablesCreated int32

	// The number of tables deleted by this crawler.
	TablesDeleted int32

	// The number of tables updated by this crawler.
	TablesUpdated int32

	// The estimated time left to complete a running crawl.
	TimeLeftSeconds float64

	noSmithyDocumentSerde
}

// The details of a Crawler node present in the workflow.
type CrawlerNodeDetails struct {

	// A list of crawls represented by the crawl node.
	Crawls []Crawl

	noSmithyDocumentSerde
}

// Specifies data stores to crawl.
type CrawlerTargets struct {

	// Specifies Glue Data Catalog targets.
	CatalogTargets []CatalogTarget

	// Specifies Amazon DynamoDB targets.
	DynamoDBTargets []DynamoDBTarget

	// Specifies JDBC targets.
	JdbcTargets []JdbcTarget

	// Specifies Amazon DocumentDB or MongoDB targets.
	MongoDBTargets []MongoDBTarget

	// Specifies Amazon Simple Storage Service (Amazon S3) targets.
	S3Targets []S3Target

	noSmithyDocumentSerde
}

// Specifies a custom CSV classifier for CreateClassifier to create.
type CreateCsvClassifierRequest struct {

	// The name of the classifier.
	//
	// This member is required.
	Name *string

	// Enables the processing of files that contain only one column.
	AllowSingleColumn *bool

	// Indicates whether the CSV file contains a header.
	ContainsHeader CsvHeaderOption

	// A custom symbol to denote what separates each column entry in the row.
	Delimiter *string

	// Specifies not to trim values before identifying the type of column values. The
	// default value is true.
	DisableValueTrimming *bool

	// A list of strings representing column names.
	Header []string

	// A custom symbol to denote what combines content into a single column value. Must
	// be different from the column delimiter.
	QuoteSymbol *string

	noSmithyDocumentSerde
}

// Specifies a grok classifier for CreateClassifier to create.
type CreateGrokClassifierRequest struct {

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
	//
	// This member is required.
	Classification *string

	// The grok pattern used by this classifier.
	//
	// This member is required.
	GrokPattern *string

	// The name of the new classifier.
	//
	// This member is required.
	Name *string

	// Optional custom grok patterns used by this classifier.
	CustomPatterns *string

	noSmithyDocumentSerde
}

// Specifies a JSON classifier for CreateClassifier to create.
type CreateJsonClassifierRequest struct {

	// A JsonPath string defining the JSON data for the classifier to classify. Glue
	// supports a subset of JsonPath, as described in Writing JsonPath Custom
	// Classifiers
	// (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	//
	// This member is required.
	JsonPath *string

	// The name of the classifier.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Specifies an XML classifier for CreateClassifier to create.
type CreateXMLClassifierRequest struct {

	// An identifier of the data format that the classifier matches.
	//
	// This member is required.
	Classification *string

	// The name of the classifier.
	//
	// This member is required.
	Name *string

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. This can't identify a self-closing element (closed by />). An
	// empty row element that contains only attributes can be parsed as long as it ends
	// with a closing tag (for example,  is okay, but  is not).
	RowTag *string

	noSmithyDocumentSerde
}

// A classifier for custom CSV content.
type CsvClassifier struct {

	// The name of the classifier.
	//
	// This member is required.
	Name *string

	// Enables the processing of files that contain only one column.
	AllowSingleColumn *bool

	// Indicates whether the CSV file contains a header.
	ContainsHeader CsvHeaderOption

	// The time that this classifier was registered.
	CreationTime *time.Time

	// A custom symbol to denote what separates each column entry in the row.
	Delimiter *string

	// Specifies not to trim values before identifying the type of column values. The
	// default value is true.
	DisableValueTrimming *bool

	// A list of strings representing column names.
	Header []string

	// The time that this classifier was last updated.
	LastUpdated *time.Time

	// A custom symbol to denote what combines content into a single column value. It
	// must be different from the column delimiter.
	QuoteSymbol *string

	// The version of this classifier.
	Version int64

	noSmithyDocumentSerde
}

// The Database object represents a logical grouping of tables that might reside in
// a Hive metastore or an RDBMS.
type Database struct {

	// The name of the database. For Hive compatibility, this is folded to lowercase
	// when it is stored.
	//
	// This member is required.
	Name *string

	// The ID of the Data Catalog in which the database resides.
	CatalogId *string

	// Creates a set of default permissions on the table for principals.
	CreateTableDefaultPermissions []PrincipalPermissions

	// The time at which the metadata database was created in the catalog.
	CreateTime *time.Time

	// A description of the database.
	Description *string

	// The location of the database (for example, an HDFS path).
	LocationUri *string

	// These key-value pairs define parameters and properties of the database.
	Parameters map[string]string

	// A DatabaseIdentifier structure that describes a target database for resource
	// linking.
	TargetDatabase *DatabaseIdentifier

	noSmithyDocumentSerde
}

// A structure that describes a target database for resource linking.
type DatabaseIdentifier struct {

	// The ID of the Data Catalog in which the database resides.
	CatalogId *string

	// The name of the catalog database.
	DatabaseName *string

	noSmithyDocumentSerde
}

// The structure used to create or update a database.
type DatabaseInput struct {

	// The name of the database. For Hive compatibility, this is folded to lowercase
	// when it is stored.
	//
	// This member is required.
	Name *string

	// Creates a set of default permissions on the table for principals.
	CreateTableDefaultPermissions []PrincipalPermissions

	// A description of the database.
	Description *string

	// The location of the database (for example, an HDFS path).
	LocationUri *string

	// These key-value pairs define parameters and properties of the database. These
	// key-value pairs define parameters and properties of the database.
	Parameters map[string]string

	// A DatabaseIdentifier structure that describes a target database for resource
	// linking.
	TargetDatabase *DatabaseIdentifier

	noSmithyDocumentSerde
}

// Contains configuration information for maintaining Data Catalog security.
type DataCatalogEncryptionSettings struct {

	// When connection password protection is enabled, the Data Catalog uses a
	// customer-provided key to encrypt the password as part of CreateConnection or
	// UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection
	// properties. You can enable catalog encryption or only password encryption.
	ConnectionPasswordEncryption *ConnectionPasswordEncryption

	// Specifies the encryption-at-rest configuration for the Data Catalog.
	EncryptionAtRest *EncryptionAtRest

	noSmithyDocumentSerde
}

// The Lake Formation principal.
type DataLakePrincipal struct {

	// An identifier for the Lake Formation principal.
	DataLakePrincipalIdentifier *string

	noSmithyDocumentSerde
}

// Defines column statistics supported for timestamp data columns.
type DateColumnStatisticsData struct {

	// The number of distinct values in a column.
	//
	// This member is required.
	NumberOfDistinctValues int64

	// The number of null values in the column.
	//
	// This member is required.
	NumberOfNulls int64

	// The highest value in the column.
	MaximumValue *time.Time

	// The lowest value in the column.
	MinimumValue *time.Time

	noSmithyDocumentSerde
}

// Defines column statistics supported for fixed-point number data columns.
type DecimalColumnStatisticsData struct {

	// The number of distinct values in a column.
	//
	// This member is required.
	NumberOfDistinctValues int64

	// The number of null values in the column.
	//
	// This member is required.
	NumberOfNulls int64

	// The highest value in the column.
	MaximumValue *DecimalNumber

	// The lowest value in the column.
	MinimumValue *DecimalNumber

	noSmithyDocumentSerde
}

// Contains a numeric value in decimal format.
type DecimalNumber struct {

	// The scale that determines where the decimal point falls in the unscaled value.
	//
	// This member is required.
	Scale int32

	// The unscaled numeric value.
	//
	// This member is required.
	UnscaledValue []byte

	noSmithyDocumentSerde
}

// A development endpoint where a developer can remotely debug extract, transform,
// and load (ETL) scripts.
type DevEndpoint struct {

	// A map of arguments used to configure the DevEndpoint. Valid arguments are:
	//
	// *
	// "--enable-glue-datacatalog": ""
	//
	// You can specify a version of Python support for
	// development endpoints by using the Arguments parameter in the CreateDevEndpoint
	// or UpdateDevEndpoint APIs. If no arguments are provided, the version defaults to
	// Python 2.
	Arguments map[string]string

	// The AWS Availability Zone where this DevEndpoint is located.
	AvailabilityZone *string

	// The point in time at which this DevEndpoint was created.
	CreatedTimestamp *time.Time

	// The name of the DevEndpoint.
	EndpointName *string

	// The path to one or more Java .jar files in an S3 bucket that should be loaded in
	// your DevEndpoint. You can only use pure Java/Scala libraries with a DevEndpoint.
	ExtraJarsS3Path *string

	// The paths to one or more Python libraries in an Amazon S3 bucket that should be
	// loaded in your DevEndpoint. Multiple values must be complete paths separated by
	// a comma. You can only use pure Python libraries with a DevEndpoint. Libraries
	// that rely on C extensions, such as the pandas (http://pandas.pydata.org/) Python
	// data analysis library, are not currently supported.
	ExtraPythonLibsS3Path *string

	// The reason for a current failure in this DevEndpoint.
	FailureReason *string

	// Glue version determines the versions of Apache Spark and Python that Glue
	// supports. The Python version indicates the version supported for running your
	// ETL scripts on development endpoints. For more information about the available
	// Glue versions and corresponding Spark and Python versions, see Glue version
	// (https://docs.aws.amazon.com/glue/latest/dg/add-job.html) in the developer
	// guide. Development endpoints that are created without specifying a Glue version
	// default to Glue 0.9. You can specify a version of Python support for development
	// endpoints by using the Arguments parameter in the CreateDevEndpoint or
	// UpdateDevEndpoint APIs. If no arguments are provided, the version defaults to
	// Python 2.
	GlueVersion *string

	// The point in time at which this DevEndpoint was last modified.
	LastModifiedTimestamp *time.Time

	// The status of the last update.
	LastUpdateStatus *string

	// The number of Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
	NumberOfNodes int32

	// The number of workers of a defined workerType that are allocated to the
	// development endpoint. The maximum number of workers you can define are 299 for
	// G.1X, and 149 for G.2X.
	NumberOfWorkers *int32

	// A private IP address to access the DevEndpoint within a VPC if the DevEndpoint
	// is created within one. The PrivateAddress field is present only when you create
	// the DevEndpoint within your VPC.
	PrivateAddress *string

	// The public IP address used by this DevEndpoint. The PublicAddress field is
	// present only when you create a non-virtual private cloud (VPC) DevEndpoint.
	PublicAddress *string

	// The public key to be used by this DevEndpoint for authentication. This attribute
	// is provided for backward compatibility because the recommended attribute to use
	// is public keys.
	PublicKey *string

	// A list of public keys to be used by the DevEndpoints for authentication. Using
	// this attribute is preferred over a single public key because the public keys
	// allow you to have a different private key per client. If you previously created
	// an endpoint with a public key, you must remove that key to be able to set a list
	// of public keys. Call the UpdateDevEndpoint API operation with the public key
	// content in the deletePublicKeys attribute, and the list of new keys in the
	// addPublicKeys attribute.
	PublicKeys []string

	// The Amazon Resource Name (ARN) of the IAM role used in this DevEndpoint.
	RoleArn *string

	// The name of the SecurityConfiguration structure to be used with this
	// DevEndpoint.
	SecurityConfiguration *string

	// A list of security group identifiers used in this DevEndpoint.
	SecurityGroupIds []string

	// The current status of this DevEndpoint.
	Status *string

	// The subnet ID for this DevEndpoint.
	SubnetId *string

	// The ID of the virtual private cloud (VPC) used by this DevEndpoint.
	VpcId *string

	// The type of predefined worker that is allocated to the development endpoint.
	// Accepts a value of Standard, G.1X, or G.2X.
	//
	// * For the Standard worker type,
	// each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors
	// per worker.
	//
	// * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16
	// GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this
	// worker type for memory-intensive jobs.
	//
	// * For the G.2X worker type, each worker
	// maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor
	// per worker. We recommend this worker type for memory-intensive jobs.
	//
	// Known
	// issue: when a development endpoint is created with the G.2XWorkerType
	// configuration, the Spark drivers for the development endpoint will run on 4
	// vCPU, 16 GB of memory, and a 64 GB disk.
	WorkerType WorkerType

	// The YARN endpoint address used by this DevEndpoint.
	YarnEndpointAddress *string

	// The Apache Zeppelin port for the remote Apache Spark interpreter.
	ZeppelinRemoteSparkInterpreterPort int32

	noSmithyDocumentSerde
}

// Custom libraries to be loaded into a development endpoint.
type DevEndpointCustomLibraries struct {

	// The path to one or more Java .jar files in an S3 bucket that should be loaded in
	// your DevEndpoint. You can only use pure Java/Scala libraries with a DevEndpoint.
	ExtraJarsS3Path *string

	// The paths to one or more Python libraries in an Amazon Simple Storage Service
	// (Amazon S3) bucket that should be loaded in your DevEndpoint. Multiple values
	// must be complete paths separated by a comma. You can only use pure Python
	// libraries with a DevEndpoint. Libraries that rely on C extensions, such as the
	// pandas (http://pandas.pydata.org/) Python data analysis library, are not
	// currently supported.
	ExtraPythonLibsS3Path *string

	noSmithyDocumentSerde
}

// Defines column statistics supported for floating-point number data columns.
type DoubleColumnStatisticsData struct {

	// The number of distinct values in a column.
	//
	// This member is required.
	NumberOfDistinctValues int64

	// The number of null values in the column.
	//
	// This member is required.
	NumberOfNulls int64

	// The highest value in the column.
	MaximumValue float64

	// The lowest value in the column.
	MinimumValue float64

	noSmithyDocumentSerde
}

// Specifies an Amazon DynamoDB table to crawl.
type DynamoDBTarget struct {

	// The name of the DynamoDB table to crawl.
	Path *string

	// Indicates whether to scan all the records, or to sample rows from the table.
	// Scanning all the records can take a long time when the table is not a high
	// throughput table. A value of true means to scan all records, while a value of
	// false means to sample the records. If no value is specified, the value defaults
	// to true.
	ScanAll *bool

	// The percentage of the configured read capacity units to use by the Glue crawler.
	// Read capacity units is a term defined by DynamoDB, and is a numeric value that
	// acts as rate limiter for the number of reads that can be performed on that table
	// per second. The valid values are null or a value between 0.1 to 1.5. A null
	// value is used when user does not provide a value, and defaults to 0.5 of the
	// configured Read Capacity Unit (for provisioned tables), or 0.25 of the max
	// configured Read Capacity Unit (for tables using on-demand mode).
	ScanRate *float64

	noSmithyDocumentSerde
}

// An edge represents a directed connection between two components on a workflow
// graph.
type Edge struct {

	// The unique of the node within the workflow where the edge ends.
	DestinationId *string

	// The unique of the node within the workflow where the edge starts.
	SourceId *string

	noSmithyDocumentSerde
}

// Specifies the encryption-at-rest configuration for the Data Catalog.
type EncryptionAtRest struct {

	// The encryption-at-rest mode for encrypting Data Catalog data.
	//
	// This member is required.
	CatalogEncryptionMode CatalogEncryptionMode

	// The ID of the KMS key to use for encryption at rest.
	SseAwsKmsKeyId *string

	noSmithyDocumentSerde
}

// Specifies an encryption configuration.
type EncryptionConfiguration struct {

	// The encryption configuration for Amazon CloudWatch.
	CloudWatchEncryption *CloudWatchEncryption

	// The encryption configuration for job bookmarks.
	JobBookmarksEncryption *JobBookmarksEncryption

	// The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
	S3Encryption []S3Encryption

	noSmithyDocumentSerde
}

// Contains details about an error.
type ErrorDetail struct {

	// The code associated with this error.
	ErrorCode *string

	// A message describing the error.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// An object containing error details.
type ErrorDetails struct {

	// The error code for an error.
	ErrorCode *string

	// The error message for an error.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Evaluation metrics provide an estimate of the quality of your machine learning
// transform.
type EvaluationMetrics struct {

	// The type of machine learning transform.
	//
	// This member is required.
	TransformType TransformType

	// The evaluation metrics for the find matches algorithm.
	FindMatchesMetrics *FindMatchesMetrics

	noSmithyDocumentSerde
}

// Batch condition that must be met (specified number of events received or batch
// time window expired) before EventBridge event trigger fires.
type EventBatchingCondition struct {

	// Number of events that must be received from Amazon EventBridge before
	// EventBridge event trigger fires.
	//
	// This member is required.
	BatchSize int32

	// Window of time in seconds after which EventBridge event trigger fires. Window
	// starts when first event is received.
	BatchWindow *int32

	noSmithyDocumentSerde
}

// An execution property of a job.
type ExecutionProperty struct {

	// The maximum number of concurrent runs allowed for the job. The default is 1. An
	// error is returned when this threshold is reached. The maximum value you can
	// specify is controlled by a service limit.
	MaxConcurrentRuns int32

	noSmithyDocumentSerde
}

// Specifies configuration properties for an exporting labels task run.
type ExportLabelsTaskRunProperties struct {

	// The Amazon Simple Storage Service (Amazon S3) path where you will export the
	// labels.
	OutputS3Path *string

	noSmithyDocumentSerde
}

// The evaluation metrics for the find matches algorithm. The quality of your
// machine learning transform is measured by getting your transform to predict some
// matches and comparing the results to known matches from the same dataset. The
// quality metrics are based on a subset of your data, so they are not precise.
type FindMatchesMetrics struct {

	// The area under the precision/recall curve (AUPRC) is a single number measuring
	// the overall quality of the transform, that is independent of the choice made for
	// precision vs. recall. Higher values indicate that you have a more attractive
	// precision vs. recall tradeoff. For more information, see Precision and recall
	// (https://en.wikipedia.org/wiki/Precision_and_recall) in Wikipedia.
	AreaUnderPRCurve *float64

	// A list of ColumnImportance structures containing column importance metrics,
	// sorted in order of descending importance.
	ColumnImportances []ColumnImportance

	// The confusion matrix shows you what your transform is predicting accurately and
	// what types of errors it is making. For more information, see Confusion matrix
	// (https://en.wikipedia.org/wiki/Confusion_matrix) in Wikipedia.
	ConfusionMatrix *ConfusionMatrix

	// The maximum F1 metric indicates the transform's accuracy between 0 and 1, where
	// 1 is the best accuracy. For more information, see F1 score
	// (https://en.wikipedia.org/wiki/F1_score) in Wikipedia.
	F1 *float64

	// The precision metric indicates when often your transform is correct when it
	// predicts a match. Specifically, it measures how well the transform finds true
	// positives from the total true positives possible. For more information, see
	// Precision and recall (https://en.wikipedia.org/wiki/Precision_and_recall) in
	// Wikipedia.
	Precision *float64

	// The recall metric indicates that for an actual match, how often your transform
	// predicts the match. Specifically, it measures how well the transform finds true
	// positives from the total records in the source data. For more information, see
	// Precision and recall (https://en.wikipedia.org/wiki/Precision_and_recall) in
	// Wikipedia.
	Recall *float64

	noSmithyDocumentSerde
}

// The parameters to configure the find matches transform.
type FindMatchesParameters struct {

	// The value that is selected when tuning your transform for a balance between
	// accuracy and cost. A value of 0.5 means that the system balances accuracy and
	// cost concerns. A value of 1.0 means a bias purely for accuracy, which typically
	// results in a higher cost, sometimes substantially higher. A value of 0.0 means a
	// bias purely for cost, which results in a less accurate FindMatches transform,
	// sometimes with unacceptable accuracy. Accuracy measures how well the transform
	// finds true positives and true negatives. Increasing accuracy requires more
	// machine resources and cost. But it also results in increased recall. Cost
	// measures how many compute resources, and thus money, are consumed to run the
	// transform.
	AccuracyCostTradeoff *float64

	// The value to switch on or off to force the output to match the provided labels
	// from users. If the value is True, the find matches transform forces the output
	// to match the provided labels. The results override the normal conflation
	// results. If the value is False, the find matches transform does not ensure all
	// the labels provided are respected, and the results rely on the trained model.
	// Note that setting this value to true may increase the conflation execution time.
	EnforceProvidedLabels *bool

	// The value selected when tuning your transform for a balance between precision
	// and recall. A value of 0.5 means no preference; a value of 1.0 means a bias
	// purely for precision, and a value of 0.0 means a bias for recall. Because this
	// is a tradeoff, choosing values close to 1.0 means very low recall, and choosing
	// values close to 0.0 results in very low precision. The precision metric
	// indicates how often your model is correct when it predicts a match. The recall
	// metric indicates that for an actual match, how often your model predicts the
	// match.
	PrecisionRecallTradeoff *float64

	// The name of a column that uniquely identifies rows in the source table. Used to
	// help identify matching records.
	PrimaryKeyColumnName *string

	noSmithyDocumentSerde
}

// Specifies configuration properties for a Find Matches task run.
type FindMatchesTaskRunProperties struct {

	// The job ID for the Find Matches task run.
	JobId *string

	// The name assigned to the job for the Find Matches task run.
	JobName *string

	// The job run ID for the Find Matches task run.
	JobRunId *string

	noSmithyDocumentSerde
}

// Filters the connection definitions that are returned by the GetConnections API
// operation.
type GetConnectionsFilter struct {

	// The type of connections to return. Currently, SFTP is not supported.
	ConnectionType ConnectionType

	// A criteria string that must match the criteria recorded in the connection
	// definition for that connection definition to be returned.
	MatchCriteria []string

	noSmithyDocumentSerde
}

// A structure for returning a resource policy.
type GluePolicy struct {

	// The date and time at which the policy was created.
	CreateTime *time.Time

	// Contains the hash value associated with this policy.
	PolicyHash *string

	// Contains the requested policy document, in JSON format.
	PolicyInJson *string

	// The date and time at which the policy was last updated.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The database and table in the Glue Data Catalog that is used for input or output
// data.
type GlueTable struct {

	// A database name in the Glue Data Catalog.
	//
	// This member is required.
	DatabaseName *string

	// A table name in the Glue Data Catalog.
	//
	// This member is required.
	TableName *string

	// A unique identifier for the Glue Data Catalog.
	CatalogId *string

	// The name of the connection to the Glue Data Catalog.
	ConnectionName *string

	noSmithyDocumentSerde
}

// A classifier that uses grok patterns.
type GrokClassifier struct {

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, and so on.
	//
	// This member is required.
	Classification *string

	// The grok pattern applied to a data store by this classifier. For more
	// information, see built-in patterns in Writing Custom Classifiers
	// (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html).
	//
	// This member is required.
	GrokPattern *string

	// The name of the classifier.
	//
	// This member is required.
	Name *string

	// The time that this classifier was registered.
	CreationTime *time.Time

	// Optional custom grok patterns defined by this classifier. For more information,
	// see custom patterns in Writing Custom Classifiers
	// (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html).
	CustomPatterns *string

	// The time that this classifier was last updated.
	LastUpdated *time.Time

	// The version of this classifier.
	Version int64

	noSmithyDocumentSerde
}

// Specifies configuration properties for an importing labels task run.
type ImportLabelsTaskRunProperties struct {

	// The Amazon Simple Storage Service (Amazon S3) path from where you will import
	// the labels.
	InputS3Path *string

	// Indicates whether to overwrite your existing labels.
	Replace bool

	noSmithyDocumentSerde
}

// Specifies a JDBC data store to crawl.
type JdbcTarget struct {

	// The name of the connection to use to connect to the JDBC target.
	ConnectionName *string

	// A list of glob patterns used to exclude from the crawl. For more information,
	// see Catalog Tables with a Crawler
	// (https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html).
	Exclusions []string

	// The path of the JDBC target.
	Path *string

	noSmithyDocumentSerde
}

// Specifies a job definition.
type Job struct {

	// This field is deprecated. Use MaxCapacity instead. The number of Glue data
	// processing units (DPUs) allocated to runs of this job. You can allocate from 2
	// to 100 DPUs; the default is 10. A DPU is a relative measure of processing power
	// that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
	// information, see the Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// Deprecated: This property is deprecated, use MaxCapacity instead.
	AllocatedCapacity int32

	// The JobCommand that runs this job.
	Command *JobCommand

	// The connections used for this job.
	Connections *ConnectionsList

	// The time and date that this job definition was created.
	CreatedOn *time.Time

	// The default arguments for this job, specified as name-value pairs. You can
	// specify arguments here that your own job-execution script consumes, as well as
	// arguments that Glue itself consumes. For information about how to specify and
	// consume your own Job arguments, see the Calling Glue APIs in Python
	// (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide. For information about the key-value pairs that
	// Glue consumes to set up your job, see the Special Parameters Used by Glue
	// (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	DefaultArguments map[string]string

	// A description of the job.
	Description *string

	// An ExecutionProperty specifying the maximum number of concurrent runs allowed
	// for this job.
	ExecutionProperty *ExecutionProperty

	// Glue version determines the versions of Apache Spark and Python that Glue
	// supports. The Python version indicates the version supported for jobs of type
	// Spark. For more information about the available Glue versions and corresponding
	// Spark and Python versions, see Glue version
	// (https://docs.aws.amazon.com/glue/latest/dg/add-job.html) in the developer
	// guide. Jobs that are created without specifying a Glue version default to Glue
	// 0.9.
	GlueVersion *string

	// The last point in time when this job definition was modified.
	LastModifiedOn *time.Time

	// This field is reserved for future use.
	LogUri *string

	// For Glue version 1.0 or earlier jobs, using the standard worker type, the number
	// of Glue data processing units (DPUs) that can be allocated when this job runs. A
	// DPU is a relative measure of processing power that consists of 4 vCPUs of
	// compute capacity and 16 GB of memory. For more information, see the Glue pricing
	// page (https://aws.amazon.com/glue/pricing/). Do not set Max Capacity if using
	// WorkerType and NumberOfWorkers. The value that can be allocated for MaxCapacity
	// depends on whether you are running a Python shell job, an Apache Spark ETL job,
	// or an Apache Spark streaming ETL job:
	//
	// * When you specify a Python shell job
	// (JobCommand.Name="pythonshell"), you can allocate either 0.0625 or 1 DPU. The
	// default is 0.0625 DPU.
	//
	// * When you specify an Apache Spark ETL job
	// (JobCommand.Name="glueetl") or Apache Spark streaming ETL job
	// (JobCommand.Name="gluestreaming"), you can allocate from 2 to 100 DPUs. The
	// default is 10 DPUs. This job type cannot have a fractional DPU allocation.
	//
	// For
	// Glue version 2.0 jobs, you cannot instead specify a Maximum capacity. Instead,
	// you should specify a Worker type and the Number of workers.
	MaxCapacity *float64

	// The maximum number of times to retry this job after a JobRun fails.
	MaxRetries int32

	// The name you assign to this job definition.
	Name *string

	// Non-overridable arguments for this job, specified as name-value pairs.
	NonOverridableArguments map[string]string

	// Specifies configuration properties of a job notification.
	NotificationProperty *NotificationProperty

	// The number of workers of a defined workerType that are allocated when a job
	// runs. The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int32

	// The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
	Role *string

	// The name of the SecurityConfiguration structure to be used with this job.
	SecurityConfiguration *string

	// The job timeout in minutes. This is the maximum time that a job run can consume
	// resources before it is terminated and enters TIMEOUT status. The default is
	// 2,880 minutes (48 hours).
	Timeout *int32

	// The type of predefined worker that is allocated when a job runs. Accepts a value
	// of Standard, G.1X, or G.2X.
	//
	// * For the Standard worker type, each worker
	// provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
	//
	// *
	// For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64
	// GB disk), and provides 1 executor per worker. We recommend this worker type for
	// memory-intensive jobs.
	//
	// * For the G.2X worker type, each worker maps to 2 DPU (8
	// vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We
	// recommend this worker type for memory-intensive jobs.
	WorkerType WorkerType

	noSmithyDocumentSerde
}

// Defines a point that a job can resume processing.
type JobBookmarkEntry struct {

	// The attempt ID number.
	Attempt int32

	// The bookmark itself.
	JobBookmark *string

	// The name of the job in question.
	JobName *string

	// The unique run identifier associated with the previous job run.
	PreviousRunId *string

	// The run ID number.
	Run int32

	// The run ID number.
	RunId *string

	// The version of the job.
	Version int32

	noSmithyDocumentSerde
}

// Specifies how job bookmark data should be encrypted.
type JobBookmarksEncryption struct {

	// The encryption mode to use for job bookmarks data.
	JobBookmarksEncryptionMode JobBookmarksEncryptionMode

	// The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Specifies code that runs when a job is run.
type JobCommand struct {

	// The name of the job command. For an Apache Spark ETL job, this must be glueetl.
	// For a Python shell job, it must be pythonshell. For an Apache Spark streaming
	// ETL job, this must be gluestreaming.
	Name *string

	// The Python version being used to run a Python shell job. Allowed values are 2 or
	// 3.
	PythonVersion *string

	// Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that
	// runs a job.
	ScriptLocation *string

	noSmithyDocumentSerde
}

// The details of a Job node present in the workflow.
type JobNodeDetails struct {

	// The information for the job runs represented by the job node.
	JobRuns []JobRun

	noSmithyDocumentSerde
}

// Contains information about a job run.
type JobRun struct {

	// This field is deprecated. Use MaxCapacity instead. The number of Glue data
	// processing units (DPUs) allocated to this JobRun. From 2 to 100 DPUs can be
	// allocated; the default is 10. A DPU is a relative measure of processing power
	// that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
	// information, see the Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// Deprecated: This property is deprecated, use MaxCapacity instead.
	AllocatedCapacity int32

	// The job arguments associated with this run. For this job run, they replace the
	// default arguments set in the job definition itself. You can specify arguments
	// here that your own job-execution script consumes, as well as arguments that Glue
	// itself consumes. For information about how to specify and consume your own job
	// arguments, see the Calling Glue APIs in Python
	// (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide. For information about the key-value pairs that
	// Glue consumes to set up your job, see the Special Parameters Used by Glue
	// (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	Arguments map[string]string

	// The number of the attempt to run this job.
	Attempt int32

	// The date and time that this job run completed.
	CompletedOn *time.Time

	// An error message associated with this job run.
	ErrorMessage *string

	// The amount of time (in seconds) that the job run consumed resources.
	ExecutionTime int32

	// Glue version determines the versions of Apache Spark and Python that Glue
	// supports. The Python version indicates the version supported for jobs of type
	// Spark. For more information about the available Glue versions and corresponding
	// Spark and Python versions, see Glue version
	// (https://docs.aws.amazon.com/glue/latest/dg/add-job.html) in the developer
	// guide. Jobs that are created without specifying a Glue version default to Glue
	// 0.9.
	GlueVersion *string

	// The ID of this job run.
	Id *string

	// The name of the job definition being used in this run.
	JobName *string

	// The current state of the job run. For more information about the statuses of
	// jobs that have terminated abnormally, see Glue Job Run Statuses
	// (https://docs.aws.amazon.com/glue/latest/dg/job-run-statuses.html).
	JobRunState JobRunState

	// The last time that this job run was modified.
	LastModifiedOn *time.Time

	// The name of the log group for secure logging that can be server-side encrypted
	// in Amazon CloudWatch using KMS. This name can be /aws-glue/jobs/, in which case
	// the default encryption is NONE. If you add a role name and SecurityConfiguration
	// name (in other words,
	// /aws-glue/jobs-yourRoleName-yourSecurityConfigurationName/), then that security
	// configuration is used to encrypt the log group.
	LogGroupName *string

	// The number of Glue data processing units (DPUs) that can be allocated when this
	// job runs. A DPU is a relative measure of processing power that consists of 4
	// vCPUs of compute capacity and 16 GB of memory. For more information, see the
	// Glue pricing page (https://aws.amazon.com/glue/pricing/). Do not set Max
	// Capacity if using WorkerType and NumberOfWorkers. The value that can be
	// allocated for MaxCapacity depends on whether you are running a Python shell job
	// or an Apache Spark ETL job:
	//
	// * When you specify a Python shell job
	// (JobCommand.Name="pythonshell"), you can allocate either 0.0625 or 1 DPU. The
	// default is 0.0625 DPU.
	//
	// * When you specify an Apache Spark ETL job
	// (JobCommand.Name="glueetl"), you can allocate from 2 to 100 DPUs. The default is
	// 10 DPUs. This job type cannot have a fractional DPU allocation.
	MaxCapacity *float64

	// Specifies configuration properties of a job run notification.
	NotificationProperty *NotificationProperty

	// The number of workers of a defined workerType that are allocated when a job
	// runs. The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int32

	// A list of predecessors to this job run.
	PredecessorRuns []Predecessor

	// The ID of the previous run of this job. For example, the JobRunId specified in
	// the StartJobRun action.
	PreviousRunId *string

	// The name of the SecurityConfiguration structure to be used with this job run.
	SecurityConfiguration *string

	// The date and time at which this job run was started.
	StartedOn *time.Time

	// The JobRun timeout in minutes. This is the maximum time that a job run can
	// consume resources before it is terminated and enters TIMEOUT status. The default
	// is 2,880 minutes (48 hours). This overrides the timeout value set in the parent
	// job.
	Timeout *int32

	// The name of the trigger that started this job run.
	TriggerName *string

	// The type of predefined worker that is allocated when a job runs. Accepts a value
	// of Standard, G.1X, or G.2X.
	//
	// * For the Standard worker type, each worker
	// provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
	//
	// *
	// For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory and a
	// 64GB disk, and 1 executor per worker.
	//
	// * For the G.2X worker type, each worker
	// provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.
	WorkerType WorkerType

	noSmithyDocumentSerde
}

// Specifies information used to update an existing job definition. The previous
// job definition is completely overwritten by this information.
type JobUpdate struct {

	// This field is deprecated. Use MaxCapacity instead. The number of Glue data
	// processing units (DPUs) to allocate to this job. You can allocate from 2 to 100
	// DPUs; the default is 10. A DPU is a relative measure of processing power that
	// consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
	// information, see the Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// Deprecated: This property is deprecated, use MaxCapacity instead.
	AllocatedCapacity int32

	// The JobCommand that runs this job (required).
	Command *JobCommand

	// The connections used for this job.
	Connections *ConnectionsList

	// The default arguments for this job. You can specify arguments here that your own
	// job-execution script consumes, as well as arguments that Glue itself consumes.
	// For information about how to specify and consume your own Job arguments, see the
	// Calling Glue APIs in Python
	// (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide. For information about the key-value pairs that
	// Glue consumes to set up your job, see the Special Parameters Used by Glue
	// (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	DefaultArguments map[string]string

	// Description of the job being defined.
	Description *string

	// An ExecutionProperty specifying the maximum number of concurrent runs allowed
	// for this job.
	ExecutionProperty *ExecutionProperty

	// Glue version determines the versions of Apache Spark and Python that Glue
	// supports. The Python version indicates the version supported for jobs of type
	// Spark. For more information about the available Glue versions and corresponding
	// Spark and Python versions, see Glue version
	// (https://docs.aws.amazon.com/glue/latest/dg/add-job.html) in the developer
	// guide.
	GlueVersion *string

	// This field is reserved for future use.
	LogUri *string

	// For Glue version 1.0 or earlier jobs, using the standard worker type, the number
	// of Glue data processing units (DPUs) that can be allocated when this job runs. A
	// DPU is a relative measure of processing power that consists of 4 vCPUs of
	// compute capacity and 16 GB of memory. For more information, see the Glue pricing
	// page (https://aws.amazon.com/glue/pricing/). Do not set Max Capacity if using
	// WorkerType and NumberOfWorkers. The value that can be allocated for MaxCapacity
	// depends on whether you are running a Python shell job or an Apache Spark ETL
	// job:
	//
	// * When you specify a Python shell job (JobCommand.Name="pythonshell"), you
	// can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.
	//
	// * When you
	// specify an Apache Spark ETL job (JobCommand.Name="glueetl") or Apache Spark
	// streaming ETL job (JobCommand.Name="gluestreaming"), you can allocate from 2 to
	// 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU
	// allocation.
	//
	// For Glue version 2.0 jobs, you cannot instead specify a Maximum
	// capacity. Instead, you should specify a Worker type and the Number of workers.
	MaxCapacity *float64

	// The maximum number of times to retry this job if it fails.
	MaxRetries int32

	// Non-overridable arguments for this job, specified as name-value pairs.
	NonOverridableArguments map[string]string

	// Specifies the configuration properties of a job notification.
	NotificationProperty *NotificationProperty

	// The number of workers of a defined workerType that are allocated when a job
	// runs. The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int32

	// The name or Amazon Resource Name (ARN) of the IAM role associated with this job
	// (required).
	Role *string

	// The name of the SecurityConfiguration structure to be used with this job.
	SecurityConfiguration *string

	// The job timeout in minutes. This is the maximum time that a job run can consume
	// resources before it is terminated and enters TIMEOUT status. The default is
	// 2,880 minutes (48 hours).
	Timeout *int32

	// The type of predefined worker that is allocated when a job runs. Accepts a value
	// of Standard, G.1X, or G.2X.
	//
	// * For the Standard worker type, each worker
	// provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
	//
	// *
	// For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64
	// GB disk), and provides 1 executor per worker. We recommend this worker type for
	// memory-intensive jobs.
	//
	// * For the G.2X worker type, each worker maps to 2 DPU (8
	// vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We
	// recommend this worker type for memory-intensive jobs.
	WorkerType WorkerType

	noSmithyDocumentSerde
}

// A classifier for JSON content.
type JsonClassifier struct {

	// A JsonPath string defining the JSON data for the classifier to classify. Glue
	// supports a subset of JsonPath, as described in Writing JsonPath Custom
	// Classifiers
	// (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	//
	// This member is required.
	JsonPath *string

	// The name of the classifier.
	//
	// This member is required.
	Name *string

	// The time that this classifier was registered.
	CreationTime *time.Time

	// The time that this classifier was last updated.
	LastUpdated *time.Time

	// The version of this classifier.
	Version int64

	noSmithyDocumentSerde
}

// A partition key pair consisting of a name and a type.
type KeySchemaElement struct {

	// The name of a partition key.
	//
	// This member is required.
	Name *string

	// The type of a partition key.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// Specifies configuration properties for a labeling set generation task run.
type LabelingSetGenerationTaskRunProperties struct {

	// The Amazon Simple Storage Service (Amazon S3) path where you will generate the
	// labeling set.
	OutputS3Path *string

	noSmithyDocumentSerde
}

// When there are multiple versions of a blueprint and the latest version has some
// errors, this attribute indicates the last successful blueprint definition that
// is available with the service.
type LastActiveDefinition struct {

	// Specifies a path in Amazon S3 where the blueprint is published by the Glue
	// developer.
	BlueprintLocation *string

	// Specifies a path in Amazon S3 where the blueprint is copied when you create or
	// update the blueprint.
	BlueprintServiceLocation *string

	// The description of the blueprint.
	Description *string

	// The date and time the blueprint was last modified.
	LastModifiedOn *time.Time

	// A JSON string specifying the parameters for the blueprint.
	ParameterSpec *string

	noSmithyDocumentSerde
}

// Status and error information about the most recent crawl.
type LastCrawlInfo struct {

	// If an error occurred, the error information about the last crawl.
	ErrorMessage *string

	// The log group for the last crawl.
	LogGroup *string

	// The log stream for the last crawl.
	LogStream *string

	// The prefix for a message about this crawl.
	MessagePrefix *string

	// The time at which the crawl started.
	StartTime *time.Time

	// Status of the last crawl.
	Status LastCrawlStatus

	noSmithyDocumentSerde
}

// Specifies data lineage configuration settings for the crawler.
type LineageConfiguration struct {

	// Specifies whether data lineage is enabled for the crawler. Valid values are:
	//
	// *
	// ENABLE: enables data lineage for the crawler
	//
	// * DISABLE: disables data lineage
	// for the crawler
	CrawlerLineageSettings CrawlerLineageSettings

	noSmithyDocumentSerde
}

// The location of resources.
type Location struct {

	// An Amazon DynamoDB table location.
	DynamoDB []CodeGenNodeArg

	// A JDBC location.
	Jdbc []CodeGenNodeArg

	// An Amazon Simple Storage Service (Amazon S3) location.
	S3 []CodeGenNodeArg

	noSmithyDocumentSerde
}

// Defines column statistics supported for integer data columns.
type LongColumnStatisticsData struct {

	// The number of distinct values in a column.
	//
	// This member is required.
	NumberOfDistinctValues int64

	// The number of null values in the column.
	//
	// This member is required.
	NumberOfNulls int64

	// The highest value in the column.
	MaximumValue int64

	// The lowest value in the column.
	MinimumValue int64

	noSmithyDocumentSerde
}

// Defines a mapping.
type MappingEntry struct {

	// The source path.
	SourcePath *string

	// The name of the source table.
	SourceTable *string

	// The source type.
	SourceType *string

	// The target path.
	TargetPath *string

	// The target table.
	TargetTable *string

	// The target type.
	TargetType *string

	noSmithyDocumentSerde
}

// A structure containing metadata information for a schema version.
type MetadataInfo struct {

	// The time at which the entry was created.
	CreatedTime *string

	// The metadata key’s corresponding value.
	MetadataValue *string

	// Other metadata belonging to the same metadata key.
	OtherMetadataValueList []OtherMetadataValueListItem

	noSmithyDocumentSerde
}

// A structure containing a key value pair for metadata.
type MetadataKeyValuePair struct {

	// A metadata key.
	MetadataKey *string

	// A metadata key’s corresponding value.
	MetadataValue *string

	noSmithyDocumentSerde
}

// A structure for a machine learning transform.
type MLTransform struct {

	// A timestamp. The time and date that this machine learning transform was created.
	CreatedOn *time.Time

	// A user-defined, long-form description text for the machine learning transform.
	// Descriptions are not guaranteed to be unique and can be changed at any time.
	Description *string

	// An EvaluationMetrics object. Evaluation metrics provide an estimate of the
	// quality of your machine learning transform.
	EvaluationMetrics *EvaluationMetrics

	// This value determines which version of Glue this machine learning transform is
	// compatible with. Glue 1.0 is recommended for most customers. If the value is not
	// set, the Glue compatibility defaults to Glue 0.9. For more information, see Glue
	// Versions
	// (https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions)
	// in the developer guide.
	GlueVersion *string

	// A list of Glue table definitions used by the transform.
	InputRecordTables []GlueTable

	// A count identifier for the labeling files generated by Glue for this transform.
	// As you create a better transform, you can iteratively download, label, and
	// upload the labeling file.
	LabelCount int32

	// A timestamp. The last point in time when this machine learning transform was
	// modified.
	LastModifiedOn *time.Time

	// The number of Glue data processing units (DPUs) that are allocated to task runs
	// for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A
	// DPU is a relative measure of processing power that consists of 4 vCPUs of
	// compute capacity and 16 GB of memory. For more information, see the Glue pricing
	// page (http://aws.amazon.com/glue/pricing/). MaxCapacity is a mutually exclusive
	// option with NumberOfWorkers and WorkerType.
	//
	// * If either NumberOfWorkers or
	// WorkerType is set, then MaxCapacity cannot be set.
	//
	// * If MaxCapacity is set then
	// neither NumberOfWorkers or WorkerType can be set.
	//
	// * If WorkerType is set, then
	// NumberOfWorkers is required (and vice versa).
	//
	// * MaxCapacity and NumberOfWorkers
	// must both be at least 1.
	//
	// When the WorkerType field is set to a value other than
	// Standard, the MaxCapacity field is set automatically and becomes read-only.
	MaxCapacity *float64

	// The maximum number of times to retry after an MLTaskRun of the machine learning
	// transform fails.
	MaxRetries *int32

	// A user-defined name for the machine learning transform. Names are not guaranteed
	// unique and can be changed at any time.
	Name *string

	// The number of workers of a defined workerType that are allocated when a task of
	// the transform runs. If WorkerType is set, then NumberOfWorkers is required (and
	// vice versa).
	NumberOfWorkers *int32

	// A TransformParameters object. You can use parameters to tune (customize) the
	// behavior of the machine learning transform by specifying what data it learns
	// from and your preference on various tradeoffs (such as precious vs. recall, or
	// accuracy vs. cost).
	Parameters *TransformParameters

	// The name or Amazon Resource Name (ARN) of the IAM role with the required
	// permissions. The required permissions include both Glue service role permissions
	// to Glue resources, and Amazon S3 permissions required by the transform.
	//
	// * This
	// role needs Glue service role permissions to allow access to resources in Glue.
	// See Attach a Policy to IAM Users That Access Glue
	// (https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html).
	//
	// *
	// This role needs permission to your Amazon Simple Storage Service (Amazon S3)
	// sources, targets, temporary directory, scripts, and any libraries used by the
	// task run for this transform.
	Role *string

	// A map of key-value pairs representing the columns and data types that this
	// transform can run against. Has an upper bound of 100 columns.
	Schema []SchemaColumn

	// The current status of the machine learning transform.
	Status TransformStatusType

	// The timeout in minutes of the machine learning transform.
	Timeout *int32

	// The encryption-at-rest settings of the transform that apply to accessing user
	// data. Machine learning transforms can access user data encrypted in Amazon S3
	// using KMS.
	TransformEncryption *TransformEncryption

	// The unique transform ID that is generated for the machine learning transform.
	// The ID is guaranteed to be unique and does not change.
	TransformId *string

	// The type of predefined worker that is allocated when a task of this transform
	// runs. Accepts a value of Standard, G.1X, or G.2X.
	//
	// * For the Standard worker
	// type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
	// executors per worker.
	//
	// * For the G.1X worker type, each worker provides 4 vCPU,
	// 16 GB of memory and a 64GB disk, and 1 executor per worker.
	//
	// * For the G.2X
	// worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and
	// 1 executor per worker.
	//
	// MaxCapacity is a mutually exclusive option with
	// NumberOfWorkers and WorkerType.
	//
	// * If either NumberOfWorkers or WorkerType is
	// set, then MaxCapacity cannot be set.
	//
	// * If MaxCapacity is set then neither
	// NumberOfWorkers or WorkerType can be set.
	//
	// * If WorkerType is set, then
	// NumberOfWorkers is required (and vice versa).
	//
	// * MaxCapacity and NumberOfWorkers
	// must both be at least 1.
	WorkerType WorkerType

	noSmithyDocumentSerde
}

// The encryption-at-rest settings of the transform that apply to accessing user
// data.
type MLUserDataEncryption struct {

	// The encryption mode applied to user data. Valid values are:
	//
	// * DISABLED:
	// encryption is disabled
	//
	// * SSEKMS: use of server-side encryption with Key
	// Management Service (SSE-KMS) for user data stored in Amazon S3.
	//
	// This member is required.
	MlUserDataEncryptionMode MLUserDataEncryptionModeString

	// The ID for the customer-provided KMS key.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Specifies an Amazon DocumentDB or MongoDB data store to crawl.
type MongoDBTarget struct {

	// The name of the connection to use to connect to the Amazon DocumentDB or MongoDB
	// target.
	ConnectionName *string

	// The path of the Amazon DocumentDB or MongoDB target (database/collection).
	Path *string

	// Indicates whether to scan all the records, or to sample rows from the table.
	// Scanning all the records can take a long time when the table is not a high
	// throughput table. A value of true means to scan all records, while a value of
	// false means to sample the records. If no value is specified, the value defaults
	// to true.
	ScanAll *bool

	noSmithyDocumentSerde
}

// A node represents an Glue component (trigger, crawler, or job) on a workflow
// graph.
type Node struct {

	// Details of the crawler when the node represents a crawler.
	CrawlerDetails *CrawlerNodeDetails

	// Details of the Job when the node represents a Job.
	JobDetails *JobNodeDetails

	// The name of the Glue component represented by the node.
	Name *string

	// Details of the Trigger when the node represents a Trigger.
	TriggerDetails *TriggerNodeDetails

	// The type of Glue component represented by the node.
	Type NodeType

	// The unique Id assigned to the node within the workflow.
	UniqueId *string

	noSmithyDocumentSerde
}

// Specifies configuration properties of a notification.
type NotificationProperty struct {

	// After a job run starts, the number of minutes to wait before sending a job run
	// delay notification.
	NotifyDelayAfter *int32

	noSmithyDocumentSerde
}

// Specifies the sort order of a sorted column.
type Order struct {

	// The name of the column.
	//
	// This member is required.
	Column *string

	// Indicates that the column is sorted in ascending order (== 1), or in descending
	// order (==0).
	//
	// This member is required.
	SortOrder int32

	noSmithyDocumentSerde
}

// A structure containing other metadata for a schema version belonging to the same
// metadata key.
type OtherMetadataValueListItem struct {

	// The time at which the entry was created.
	CreatedTime *string

	// The metadata key’s corresponding value for the other metadata belonging to the
	// same metadata key.
	MetadataValue *string

	noSmithyDocumentSerde
}

// Represents a slice of table data.
type Partition struct {

	// The ID of the Data Catalog in which the partition resides.
	CatalogId *string

	// The time at which the partition was created.
	CreationTime *time.Time

	// The name of the catalog database in which to create the partition.
	DatabaseName *string

	// The last time at which the partition was accessed.
	LastAccessTime *time.Time

	// The last time at which column statistics were computed for this partition.
	LastAnalyzedTime *time.Time

	// These key-value pairs define partition parameters.
	Parameters map[string]string

	// Provides information about the physical location where the partition is stored.
	StorageDescriptor *StorageDescriptor

	// The name of the database table in which to create the partition.
	TableName *string

	// The values of the partition.
	Values []string

	noSmithyDocumentSerde
}

// Contains information about a partition error.
type PartitionError struct {

	// The details about the partition error.
	ErrorDetail *ErrorDetail

	// The values that define the partition.
	PartitionValues []string

	noSmithyDocumentSerde
}

// A structure for a partition index.
type PartitionIndex struct {

	// The name of the partition index.
	//
	// This member is required.
	IndexName *string

	// The keys for the partition index.
	//
	// This member is required.
	Keys []string

	noSmithyDocumentSerde
}

// A descriptor for a partition index in a table.
type PartitionIndexDescriptor struct {

	// The name of the partition index.
	//
	// This member is required.
	IndexName *string

	// The status of the partition index. The possible statuses are:
	//
	// * CREATING: The
	// index is being created. When an index is in a CREATING state, the index or its
	// table cannot be deleted.
	//
	// * ACTIVE: The index creation succeeds.
	//
	// * FAILED: The
	// index creation fails.
	//
	// * DELETING: The index is deleted from the list of
	// indexes.
	//
	// This member is required.
	IndexStatus PartitionIndexStatus

	// A list of one or more keys, as KeySchemaElement structures, for the partition
	// index.
	//
	// This member is required.
	Keys []KeySchemaElement

	// A list of errors that can occur when registering partition indexes for an
	// existing table.
	BackfillErrors []BackfillError

	noSmithyDocumentSerde
}

// The structure used to create and update a partition.
type PartitionInput struct {

	// The last time at which the partition was accessed.
	LastAccessTime *time.Time

	// The last time at which column statistics were computed for this partition.
	LastAnalyzedTime *time.Time

	// These key-value pairs define partition parameters.
	Parameters map[string]string

	// Provides information about the physical location where the partition is stored.
	StorageDescriptor *StorageDescriptor

	// The values of the partition. Although this parameter is not required by the SDK,
	// you must specify this parameter for a valid input. The values for the keys for
	// the new partition must be passed as an array of String objects that must be
	// ordered in the same order as the partition keys appearing in the Amazon S3
	// prefix. Otherwise Glue will add the values to the wrong keys.
	Values []string

	noSmithyDocumentSerde
}

// Contains a list of values defining partitions.
type PartitionValueList struct {

	// The list of values.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Specifies the physical requirements for a connection.
type PhysicalConnectionRequirements struct {

	// The connection's Availability Zone. This field is redundant because the
	// specified subnet implies the Availability Zone to be used. Currently the field
	// must be populated, but it will be deprecated in the future.
	AvailabilityZone *string

	// The security group ID list used by the connection.
	SecurityGroupIdList []string

	// The subnet ID used by the connection.
	SubnetId *string

	noSmithyDocumentSerde
}

// A job run that was used in the predicate of a conditional trigger that triggered
// this job run.
type Predecessor struct {

	// The name of the job definition used by the predecessor job run.
	JobName *string

	// The job-run ID of the predecessor job run.
	RunId *string

	noSmithyDocumentSerde
}

// Defines the predicate of the trigger, which determines when it fires.
type Predicate struct {

	// A list of the conditions that determine when the trigger will fire.
	Conditions []Condition

	// An optional field if only one condition is listed. If multiple conditions are
	// listed, then this field is required.
	Logical Logical

	noSmithyDocumentSerde
}

// Permissions granted to a principal.
type PrincipalPermissions struct {

	// The permissions that are granted to the principal.
	Permissions []Permission

	// The principal who is granted permissions.
	Principal *DataLakePrincipal

	noSmithyDocumentSerde
}

// Defines a property predicate.
type PropertyPredicate struct {

	// The comparator used to compare this property to others.
	Comparator Comparator

	// The key of the property.
	Key *string

	// The value of the property.
	Value *string

	noSmithyDocumentSerde
}

// When crawling an Amazon S3 data source after the first crawl is complete,
// specifies whether to crawl the entire dataset again or to crawl only folders
// that were added since the last crawler run. For more information, see
// Incremental Crawls in Glue
// (https://docs.aws.amazon.com/glue/latest/dg/incremental-crawls.html) in the
// developer guide.
type RecrawlPolicy struct {

	// Specifies whether to crawl the entire dataset again or to crawl only folders
	// that were added since the last crawler run. A value of CRAWL_EVERYTHING
	// specifies crawling the entire dataset again. A value of CRAWL_NEW_FOLDERS_ONLY
	// specifies crawling only folders that were added since the last crawler run.
	RecrawlBehavior RecrawlBehavior

	noSmithyDocumentSerde
}

// A wrapper structure that may contain the registry name and Amazon Resource Name
// (ARN).
type RegistryId struct {

	// Arn of the registry to be updated. One of RegistryArn or RegistryName has to be
	// provided.
	RegistryArn *string

	// Name of the registry. Used only for lookup. One of RegistryArn or RegistryName
	// has to be provided.
	RegistryName *string

	noSmithyDocumentSerde
}

// A structure containing the details for a registry.
type RegistryListItem struct {

	// The data the registry was created.
	CreatedTime *string

	// A description of the registry.
	Description *string

	// The Amazon Resource Name (ARN) of the registry.
	RegistryArn *string

	// The name of the registry.
	RegistryName *string

	// The status of the registry.
	Status RegistryStatus

	// The date the registry was updated.
	UpdatedTime *string

	noSmithyDocumentSerde
}

// The URIs for function resources.
type ResourceUri struct {

	// The type of the resource.
	ResourceType ResourceType

	// The URI for accessing the resource.
	Uri *string

	noSmithyDocumentSerde
}

// Specifies how Amazon Simple Storage Service (Amazon S3) data should be
// encrypted.
type S3Encryption struct {

	// The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
	KmsKeyArn *string

	// The encryption mode to use for Amazon S3 data.
	S3EncryptionMode S3EncryptionMode

	noSmithyDocumentSerde
}

// Specifies a data store in Amazon Simple Storage Service (Amazon S3).
type S3Target struct {

	// The name of a connection which allows a job or crawler to access data in Amazon
	// S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).
	ConnectionName *string

	// A list of glob patterns used to exclude from the crawl. For more information,
	// see Catalog Tables with a Crawler
	// (https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html).
	Exclusions []string

	// The path to the Amazon S3 target.
	Path *string

	// Sets the number of files in each leaf folder to be crawled when crawling sample
	// files in a dataset. If not set, all the files are crawled. A valid value is an
	// integer between 1 and 249.
	SampleSize *int32

	noSmithyDocumentSerde
}

// A scheduling object using a cron statement to schedule an event.
type Schedule struct {

	// A cron expression used to specify the schedule (see Time-Based Schedules for
	// Jobs and Crawlers
	// (https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify: cron(15
	// 12 * * ? *).
	ScheduleExpression *string

	// The state of the schedule.
	State ScheduleState

	noSmithyDocumentSerde
}

// A policy that specifies update and deletion behaviors for the crawler.
type SchemaChangePolicy struct {

	// The deletion behavior when the crawler finds a deleted object.
	DeleteBehavior DeleteBehavior

	// The update behavior when the crawler finds a changed schema.
	UpdateBehavior UpdateBehavior

	noSmithyDocumentSerde
}

// A key-value pair representing a column and data type that this transform can run
// against. The Schema parameter of the MLTransform may contain up to 100 of these
// structures.
type SchemaColumn struct {

	// The type of data in the column.
	DataType *string

	// The name of the column.
	Name *string

	noSmithyDocumentSerde
}

// The unique ID of the schema in the Glue schema registry.
type SchemaId struct {

	// The name of the schema registry that contains the schema.
	RegistryName *string

	// The Amazon Resource Name (ARN) of the schema. One of SchemaArn or SchemaName has
	// to be provided.
	SchemaArn *string

	// The name of the schema. One of SchemaArn or SchemaName has to be provided.
	SchemaName *string

	noSmithyDocumentSerde
}

// An object that contains minimal details for a schema.
type SchemaListItem struct {

	// The date and time that a schema was created.
	CreatedTime *string

	// A description for the schema.
	Description *string

	// the name of the registry where the schema resides.
	RegistryName *string

	// The Amazon Resource Name (ARN) for the schema.
	SchemaArn *string

	// The name of the schema.
	SchemaName *string

	// The status of the schema.
	SchemaStatus SchemaStatus

	// The date and time that a schema was updated.
	UpdatedTime *string

	noSmithyDocumentSerde
}

// An object that references a schema stored in the Glue Schema Registry.
type SchemaReference struct {

	// A structure that contains schema identity fields. Either this or the
	// SchemaVersionId has to be provided.
	SchemaId *SchemaId

	// The unique ID assigned to a version of the schema. Either this or the SchemaId
	// has to be provided.
	SchemaVersionId *string

	// The version number of the schema.
	SchemaVersionNumber int64

	noSmithyDocumentSerde
}

// An object that contains the error details for an operation on a schema version.
type SchemaVersionErrorItem struct {

	// The details of the error for the schema version.
	ErrorDetails *ErrorDetails

	// The version number of the schema.
	VersionNumber int64

	noSmithyDocumentSerde
}

// An object containing the details about a schema version.
type SchemaVersionListItem struct {

	// The date and time the schema version was created.
	CreatedTime *string

	// The Amazon Resource Name (ARN) of the schema.
	SchemaArn *string

	// The unique identifier of the schema version.
	SchemaVersionId *string

	// The status of the schema version.
	Status SchemaVersionStatus

	// The version number of the schema.
	VersionNumber int64

	noSmithyDocumentSerde
}

// A structure containing the schema version information.
type SchemaVersionNumber struct {

	// The latest version available for the schema.
	LatestVersion bool

	// The version number of the schema.
	VersionNumber int64

	noSmithyDocumentSerde
}

// Specifies a security configuration.
type SecurityConfiguration struct {

	// The time at which this security configuration was created.
	CreatedTimeStamp *time.Time

	// The encryption configuration associated with this security configuration.
	EncryptionConfiguration *EncryptionConfiguration

	// The name of the security configuration.
	Name *string

	noSmithyDocumentSerde
}

// Defines a non-overlapping region of a table's partitions, allowing multiple
// requests to be run in parallel.
type Segment struct {

	// The zero-based index number of the segment. For example, if the total number of
	// segments is 4, SegmentNumber values range from 0 through 3.
	//
	// This member is required.
	SegmentNumber int32

	// The total number of segments.
	//
	// This member is required.
	TotalSegments int32

	noSmithyDocumentSerde
}

// Information about a serialization/deserialization program (SerDe) that serves as
// an extractor and loader.
type SerDeInfo struct {

	// Name of the SerDe.
	Name *string

	// These key-value pairs define initialization parameters for the SerDe.
	Parameters map[string]string

	// Usually the class that implements the SerDe. An example is
	// org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
	SerializationLibrary *string

	noSmithyDocumentSerde
}

// Specifies skewed values in a table. Skewed values are those that occur with very
// high frequency.
type SkewedInfo struct {

	// A list of names of columns that contain skewed values.
	SkewedColumnNames []string

	// A mapping of skewed values to the columns that contain them.
	SkewedColumnValueLocationMaps map[string]string

	// A list of values that appear so frequently as to be considered skewed.
	SkewedColumnValues []string

	noSmithyDocumentSerde
}

// Specifies a field to sort by and a sort order.
type SortCriterion struct {

	// The name of the field on which to sort.
	FieldName *string

	// An ascending or descending sort.
	Sort Sort

	noSmithyDocumentSerde
}

// The batch condition that started the workflow run. Either the number of events
// in the batch size arrived, in which case the BatchSize member is non-zero, or
// the batch window expired, in which case the BatchWindow member is non-zero.
type StartingEventBatchCondition struct {

	// Number of events in the batch.
	BatchSize *int32

	// Duration of the batch window in seconds.
	BatchWindow *int32

	noSmithyDocumentSerde
}

// Describes the physical storage of table data.
type StorageDescriptor struct {

	// A list of reducer grouping columns, clustering columns, and bucketing columns in
	// the table.
	BucketColumns []string

	// A list of the Columns in the table.
	Columns []Column

	// True if the data in the table is compressed, or False if not.
	Compressed bool

	// The input format: SequenceFileInputFormat (binary), or TextInputFormat, or a
	// custom format.
	InputFormat *string

	// The physical location of the table. By default, this takes the form of the
	// warehouse location, followed by the database location in the warehouse, followed
	// by the table name.
	Location *string

	// Must be specified if the table contains any dimension columns.
	NumberOfBuckets int32

	// The output format: SequenceFileOutputFormat (binary), or
	// IgnoreKeyTextOutputFormat, or a custom format.
	OutputFormat *string

	// The user-supplied properties in key-value form.
	Parameters map[string]string

	// An object that references a schema stored in the Glue Schema Registry. When
	// creating a table, you can pass an empty list of columns for the schema, and
	// instead use a schema reference.
	SchemaReference *SchemaReference

	// The serialization/deserialization (SerDe) information.
	SerdeInfo *SerDeInfo

	// The information about values that appear frequently in a column (skewed values).
	SkewedInfo *SkewedInfo

	// A list specifying the sort order of each bucket in the table.
	SortColumns []Order

	// True if the table data is stored in subdirectories, or False if not.
	StoredAsSubDirectories bool

	noSmithyDocumentSerde
}

// Defines column statistics supported for character sequence data values.
type StringColumnStatisticsData struct {

	// The average string length in the column.
	//
	// This member is required.
	AverageLength float64

	// The size of the longest string in the column.
	//
	// This member is required.
	MaximumLength int64

	// The number of distinct values in a column.
	//
	// This member is required.
	NumberOfDistinctValues int64

	// The number of null values in the column.
	//
	// This member is required.
	NumberOfNulls int64

	noSmithyDocumentSerde
}

// Represents a collection of related data organized in columns and rows.
type Table struct {

	// The table name. For Hive compatibility, this must be entirely lowercase.
	//
	// This member is required.
	Name *string

	// The ID of the Data Catalog in which the table resides.
	CatalogId *string

	// The time when the table definition was created in the Data Catalog.
	CreateTime *time.Time

	// The person or entity who created the table.
	CreatedBy *string

	// The name of the database where the table metadata resides. For Hive
	// compatibility, this must be all lowercase.
	DatabaseName *string

	// A description of the table.
	Description *string

	// Indicates whether the table has been registered with Lake Formation.
	IsRegisteredWithLakeFormation bool

	// The last time that the table was accessed. This is usually taken from HDFS, and
	// might not be reliable.
	LastAccessTime *time.Time

	// The last time that column statistics were computed for this table.
	LastAnalyzedTime *time.Time

	// The owner of the table.
	Owner *string

	// These key-value pairs define properties associated with the table.
	Parameters map[string]string

	// A list of columns by which the table is partitioned. Only primitive types are
	// supported as partition keys. When you create a table used by Amazon Athena, and
	// you do not specify any partitionKeys, you must at least set the value of
	// partitionKeys to an empty list. For example: "PartitionKeys": []
	PartitionKeys []Column

	// The retention time for this table.
	Retention int32

	// A storage descriptor containing information about the physical storage of this
	// table.
	StorageDescriptor *StorageDescriptor

	// The type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.).
	TableType *string

	// A TableIdentifier structure that describes a target table for resource linking.
	TargetTable *TableIdentifier

	// The last time that the table was updated.
	UpdateTime *time.Time

	// If the table is a view, the expanded text of the view; otherwise null.
	ViewExpandedText *string

	// If the table is a view, the original text of the view; otherwise null.
	ViewOriginalText *string

	noSmithyDocumentSerde
}

// An error record for table operations.
type TableError struct {

	// The details about the error.
	ErrorDetail *ErrorDetail

	// The name of the table. For Hive compatibility, this must be entirely lowercase.
	TableName *string

	noSmithyDocumentSerde
}

// A structure that describes a target table for resource linking.
type TableIdentifier struct {

	// The ID of the Data Catalog in which the table resides.
	CatalogId *string

	// The name of the catalog database that contains the target table.
	DatabaseName *string

	// The name of the target table.
	Name *string

	noSmithyDocumentSerde
}

// A structure used to define a table.
type TableInput struct {

	// The table name. For Hive compatibility, this is folded to lowercase when it is
	// stored.
	//
	// This member is required.
	Name *string

	// A description of the table.
	Description *string

	// The last time that the table was accessed.
	LastAccessTime *time.Time

	// The last time that column statistics were computed for this table.
	LastAnalyzedTime *time.Time

	// The table owner.
	Owner *string

	// These key-value pairs define properties associated with the table.
	Parameters map[string]string

	// A list of columns by which the table is partitioned. Only primitive types are
	// supported as partition keys. When you create a table used by Amazon Athena, and
	// you do not specify any partitionKeys, you must at least set the value of
	// partitionKeys to an empty list. For example: "PartitionKeys": []
	PartitionKeys []Column

	// The retention time for this table.
	Retention int32

	// A storage descriptor containing information about the physical storage of this
	// table.
	StorageDescriptor *StorageDescriptor

	// The type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.).
	TableType *string

	// A TableIdentifier structure that describes a target table for resource linking.
	TargetTable *TableIdentifier

	// If the table is a view, the expanded text of the view; otherwise null.
	ViewExpandedText *string

	// If the table is a view, the original text of the view; otherwise null.
	ViewOriginalText *string

	noSmithyDocumentSerde
}

// Specifies a version of a table.
type TableVersion struct {

	// The table in question.
	Table *Table

	// The ID value that identifies this table version. A VersionId is a string
	// representation of an integer. Each version is incremented by 1.
	VersionId *string

	noSmithyDocumentSerde
}

// An error record for table-version operations.
type TableVersionError struct {

	// The details about the error.
	ErrorDetail *ErrorDetail

	// The name of the table in question.
	TableName *string

	// The ID value of the version in question. A VersionID is a string representation
	// of an integer. Each version is incremented by 1.
	VersionId *string

	noSmithyDocumentSerde
}

// The sampling parameters that are associated with the machine learning transform.
type TaskRun struct {

	// The last point in time that the requested task run was completed.
	CompletedOn *time.Time

	// The list of error strings associated with this task run.
	ErrorString *string

	// The amount of time (in seconds) that the task run consumed resources.
	ExecutionTime int32

	// The last point in time that the requested task run was updated.
	LastModifiedOn *time.Time

	// The names of the log group for secure logging, associated with this task run.
	LogGroupName *string

	// Specifies configuration properties associated with this task run.
	Properties *TaskRunProperties

	// The date and time that this task run started.
	StartedOn *time.Time

	// The current status of the requested task run.
	Status TaskStatusType

	// The unique identifier for this task run.
	TaskRunId *string

	// The unique identifier for the transform.
	TransformId *string

	noSmithyDocumentSerde
}

// The criteria that are used to filter the task runs for the machine learning
// transform.
type TaskRunFilterCriteria struct {

	// Filter on task runs started after this date.
	StartedAfter *time.Time

	// Filter on task runs started before this date.
	StartedBefore *time.Time

	// The current status of the task run.
	Status TaskStatusType

	// The type of task run.
	TaskRunType TaskType

	noSmithyDocumentSerde
}

// The configuration properties for the task run.
type TaskRunProperties struct {

	// The configuration properties for an exporting labels task run.
	ExportLabelsTaskRunProperties *ExportLabelsTaskRunProperties

	// The configuration properties for a find matches task run.
	FindMatchesTaskRunProperties *FindMatchesTaskRunProperties

	// The configuration properties for an importing labels task run.
	ImportLabelsTaskRunProperties *ImportLabelsTaskRunProperties

	// The configuration properties for a labeling set generation task run.
	LabelingSetGenerationTaskRunProperties *LabelingSetGenerationTaskRunProperties

	// The type of task run.
	TaskType TaskType

	noSmithyDocumentSerde
}

// The sorting criteria that are used to sort the list of task runs for the machine
// learning transform.
type TaskRunSortCriteria struct {

	// The column to be used to sort the list of task runs for the machine learning
	// transform.
	//
	// This member is required.
	Column TaskRunSortColumnType

	// The sort direction to be used to sort the list of task runs for the machine
	// learning transform.
	//
	// This member is required.
	SortDirection SortDirectionType

	noSmithyDocumentSerde
}

// The encryption-at-rest settings of the transform that apply to accessing user
// data. Machine learning transforms can access user data encrypted in Amazon S3
// using KMS. Additionally, imported labels and trained transforms can now be
// encrypted using a customer provided KMS key.
type TransformEncryption struct {

	// An MLUserDataEncryption object containing the encryption mode and
	// customer-provided KMS key ID.
	MlUserDataEncryption *MLUserDataEncryption

	// The name of the security configuration.
	TaskRunSecurityConfigurationName *string

	noSmithyDocumentSerde
}

// The criteria used to filter the machine learning transforms.
type TransformFilterCriteria struct {

	// The time and date after which the transforms were created.
	CreatedAfter *time.Time

	// The time and date before which the transforms were created.
	CreatedBefore *time.Time

	// This value determines which version of Glue this machine learning transform is
	// compatible with. Glue 1.0 is recommended for most customers. If the value is not
	// set, the Glue compatibility defaults to Glue 0.9. For more information, see Glue
	// Versions
	// (https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions)
	// in the developer guide.
	GlueVersion *string

	// Filter on transforms last modified after this date.
	LastModifiedAfter *time.Time

	// Filter on transforms last modified before this date.
	LastModifiedBefore *time.Time

	// A unique transform name that is used to filter the machine learning transforms.
	Name *string

	// Filters on datasets with a specific schema. The Map object is an array of
	// key-value pairs representing the schema this transform accepts, where Column is
	// the name of a column, and Type is the type of the data such as an integer or
	// string. Has an upper bound of 100 columns.
	Schema []SchemaColumn

	// Filters the list of machine learning transforms by the last known status of the
	// transforms (to indicate whether a transform can be used or not). One of
	// "NOT_READY", "READY", or "DELETING".
	Status TransformStatusType

	// The type of machine learning transform that is used to filter the machine
	// learning transforms.
	TransformType TransformType

	noSmithyDocumentSerde
}

// The algorithm-specific parameters that are associated with the machine learning
// transform.
type TransformParameters struct {

	// The type of machine learning transform. For information about the types of
	// machine learning transforms, see Creating Machine Learning Transforms
	// (https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html).
	//
	// This member is required.
	TransformType TransformType

	// The parameters for the find matches algorithm.
	FindMatchesParameters *FindMatchesParameters

	noSmithyDocumentSerde
}

// The sorting criteria that are associated with the machine learning transform.
type TransformSortCriteria struct {

	// The column to be used in the sorting criteria that are associated with the
	// machine learning transform.
	//
	// This member is required.
	Column TransformSortColumnType

	// The sort direction to be used in the sorting criteria that are associated with
	// the machine learning transform.
	//
	// This member is required.
	SortDirection SortDirectionType

	noSmithyDocumentSerde
}

// Information about a specific trigger.
type Trigger struct {

	// The actions initiated by this trigger.
	Actions []Action

	// A description of this trigger.
	Description *string

	// Batch condition that must be met (specified number of events received or batch
	// time window expired) before EventBridge event trigger fires.
	EventBatchingCondition *EventBatchingCondition

	// Reserved for future use.
	Id *string

	// The name of the trigger.
	Name *string

	// The predicate of this trigger, which defines when it will fire.
	Predicate *Predicate

	// A cron expression used to specify the schedule (see Time-Based Schedules for
	// Jobs and Crawlers
	// (https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify: cron(15
	// 12 * * ? *).
	Schedule *string

	// The current state of the trigger.
	State TriggerState

	// The type of trigger that this is.
	Type TriggerType

	// The name of the workflow associated with the trigger.
	WorkflowName *string

	noSmithyDocumentSerde
}

// The details of a Trigger node present in the workflow.
type TriggerNodeDetails struct {

	// The information of the trigger represented by the trigger node.
	Trigger *Trigger

	noSmithyDocumentSerde
}

// A structure used to provide information used to update a trigger. This object
// updates the previous trigger definition by overwriting it completely.
type TriggerUpdate struct {

	// The actions initiated by this trigger.
	Actions []Action

	// A description of this trigger.
	Description *string

	// Batch condition that must be met (specified number of events received or batch
	// time window expired) before EventBridge event trigger fires.
	EventBatchingCondition *EventBatchingCondition

	// Reserved for future use.
	Name *string

	// The predicate of this trigger, which defines when it will fire.
	Predicate *Predicate

	// A cron expression used to specify the schedule (see Time-Based Schedules for
	// Jobs and Crawlers
	// (https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify: cron(15
	// 12 * * ? *).
	Schedule *string

	noSmithyDocumentSerde
}

// Specifies a custom CSV classifier to be updated.
type UpdateCsvClassifierRequest struct {

	// The name of the classifier.
	//
	// This member is required.
	Name *string

	// Enables the processing of files that contain only one column.
	AllowSingleColumn *bool

	// Indicates whether the CSV file contains a header.
	ContainsHeader CsvHeaderOption

	// A custom symbol to denote what separates each column entry in the row.
	Delimiter *string

	// Specifies not to trim values before identifying the type of column values. The
	// default value is true.
	DisableValueTrimming *bool

	// A list of strings representing column names.
	Header []string

	// A custom symbol to denote what combines content into a single column value. It
	// must be different from the column delimiter.
	QuoteSymbol *string

	noSmithyDocumentSerde
}

// Specifies a grok classifier to update when passed to UpdateClassifier.
type UpdateGrokClassifierRequest struct {

	// The name of the GrokClassifier.
	//
	// This member is required.
	Name *string

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
	Classification *string

	// Optional custom grok patterns used by this classifier.
	CustomPatterns *string

	// The grok pattern used by this classifier.
	GrokPattern *string

	noSmithyDocumentSerde
}

// Specifies a JSON classifier to be updated.
type UpdateJsonClassifierRequest struct {

	// The name of the classifier.
	//
	// This member is required.
	Name *string

	// A JsonPath string defining the JSON data for the classifier to classify. Glue
	// supports a subset of JsonPath, as described in Writing JsonPath Custom
	// Classifiers
	// (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	JsonPath *string

	noSmithyDocumentSerde
}

// Specifies an XML classifier to be updated.
type UpdateXMLClassifierRequest struct {

	// The name of the classifier.
	//
	// This member is required.
	Name *string

	// An identifier of the data format that the classifier matches.
	Classification *string

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. This cannot identify a self-closing element (closed by />). An
	// empty row element that contains only attributes can be parsed as long as it ends
	// with a closing tag (for example,  is okay, but  is not).
	RowTag *string

	noSmithyDocumentSerde
}

// Represents the equivalent of a Hive user-defined function (UDF) definition.
type UserDefinedFunction struct {

	// The ID of the Data Catalog in which the function resides.
	CatalogId *string

	// The Java class that contains the function code.
	ClassName *string

	// The time at which the function was created.
	CreateTime *time.Time

	// The name of the catalog database that contains the function.
	DatabaseName *string

	// The name of the function.
	FunctionName *string

	// The owner of the function.
	OwnerName *string

	// The owner type.
	OwnerType PrincipalType

	// The resource URIs for the function.
	ResourceUris []ResourceUri

	noSmithyDocumentSerde
}

// A structure used to create or update a user-defined function.
type UserDefinedFunctionInput struct {

	// The Java class that contains the function code.
	ClassName *string

	// The name of the function.
	FunctionName *string

	// The owner of the function.
	OwnerName *string

	// The owner type.
	OwnerType PrincipalType

	// The resource URIs for the function.
	ResourceUris []ResourceUri

	noSmithyDocumentSerde
}

// A workflow is a collection of multiple dependent Glue jobs and crawlers that are
// run to complete a complex ETL task. A workflow manages the execution and
// monitoring of all its jobs and crawlers.
type Workflow struct {

	// This structure indicates the details of the blueprint that this particular
	// workflow is created from.
	BlueprintDetails *BlueprintDetails

	// The date and time when the workflow was created.
	CreatedOn *time.Time

	// A collection of properties to be used as part of each execution of the workflow.
	// The run properties are made available to each job in the workflow. A job can
	// modify the properties for the next jobs in the flow.
	DefaultRunProperties map[string]string

	// A description of the workflow.
	Description *string

	// The graph representing all the Glue components that belong to the workflow as
	// nodes and directed connections between them as edges.
	Graph *WorkflowGraph

	// The date and time when the workflow was last modified.
	LastModifiedOn *time.Time

	// The information about the last execution of the workflow.
	LastRun *WorkflowRun

	// You can use this parameter to prevent unwanted multiple updates to data, to
	// control costs, or in some cases, to prevent exceeding the maximum number of
	// concurrent runs of any of the component jobs. If you leave this parameter blank,
	// there is no limit to the number of concurrent workflow runs.
	MaxConcurrentRuns *int32

	// The name of the workflow.
	Name *string

	noSmithyDocumentSerde
}

// A workflow graph represents the complete workflow containing all the Glue
// components present in the workflow and all the directed connections between
// them.
type WorkflowGraph struct {

	// A list of all the directed connections between the nodes belonging to the
	// workflow.
	Edges []Edge

	// A list of the the Glue components belong to the workflow represented as nodes.
	Nodes []Node

	noSmithyDocumentSerde
}

// A workflow run is an execution of a workflow providing all the runtime
// information.
type WorkflowRun struct {

	// The date and time when the workflow run completed.
	CompletedOn *time.Time

	// This error message describes any error that may have occurred in starting the
	// workflow run. Currently the only error message is "Concurrent runs exceeded for
	// workflow: foo."
	ErrorMessage *string

	// The graph representing all the Glue components that belong to the workflow as
	// nodes and directed connections between them as edges.
	Graph *WorkflowGraph

	// Name of the workflow that was run.
	Name *string

	// The ID of the previous workflow run.
	PreviousRunId *string

	// The date and time when the workflow run was started.
	StartedOn *time.Time

	// The batch condition that started the workflow run.
	StartingEventBatchCondition *StartingEventBatchCondition

	// The statistics of the run.
	Statistics *WorkflowRunStatistics

	// The status of the workflow run.
	Status WorkflowRunStatus

	// The ID of this workflow run.
	WorkflowRunId *string

	// The workflow run properties which were set during the run.
	WorkflowRunProperties map[string]string

	noSmithyDocumentSerde
}

// Workflow run statistics provides statistics about the workflow run.
type WorkflowRunStatistics struct {

	// Total number of Actions that have failed.
	FailedActions int32

	// Total number Actions in running state.
	RunningActions int32

	// Total number of Actions that have stopped.
	StoppedActions int32

	// Total number of Actions that have succeeded.
	SucceededActions int32

	// Total number of Actions that timed out.
	TimeoutActions int32

	// Total number of Actions in the workflow run.
	TotalActions int32

	noSmithyDocumentSerde
}

// A classifier for XML content.
type XMLClassifier struct {

	// An identifier of the data format that the classifier matches.
	//
	// This member is required.
	Classification *string

	// The name of the classifier.
	//
	// This member is required.
	Name *string

	// The time that this classifier was registered.
	CreationTime *time.Time

	// The time that this classifier was last updated.
	LastUpdated *time.Time

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. This can't identify a self-closing element (closed by />). An
	// empty row element that contains only attributes can be parsed as long as it ends
	// with a closing tag (for example,  is okay, but  is not).
	RowTag *string

	// The version of this classifier.
	Version int64

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
