// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves multiple function definitions from the Data Catalog.
func (c *Client) GetUserDefinedFunctions(ctx context.Context, params *GetUserDefinedFunctionsInput, optFns ...func(*Options)) (*GetUserDefinedFunctionsOutput, error) {
	if params == nil {
		params = &GetUserDefinedFunctionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetUserDefinedFunctions", params, optFns, c.addOperationGetUserDefinedFunctionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetUserDefinedFunctionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetUserDefinedFunctionsInput struct {

	// An optional function-name pattern string that filters the function definitions
	// returned.
	//
	// This member is required.
	Pattern *string

	// The ID of the Data Catalog where the functions to be retrieved are located. If
	// none is provided, the Amazon Web Services account ID is used by default.
	CatalogId *string

	// The name of the catalog database where the functions are located. If none is
	// provided, functions from all the databases across the catalog will be returned.
	DatabaseName *string

	// The maximum number of functions to return in one response.
	MaxResults *int32

	// A continuation token, if this is a continuation call.
	NextToken *string

	noSmithyDocumentSerde
}

type GetUserDefinedFunctionsOutput struct {

	// A continuation token, if the list of functions returned does not include the
	// last requested function.
	NextToken *string

	// A list of requested function definitions.
	UserDefinedFunctions []types.UserDefinedFunction

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetUserDefinedFunctionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetUserDefinedFunctions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetUserDefinedFunctions{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetUserDefinedFunctionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetUserDefinedFunctions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// GetUserDefinedFunctionsAPIClient is a client that implements the
// GetUserDefinedFunctions operation.
type GetUserDefinedFunctionsAPIClient interface {
	GetUserDefinedFunctions(context.Context, *GetUserDefinedFunctionsInput, ...func(*Options)) (*GetUserDefinedFunctionsOutput, error)
}

var _ GetUserDefinedFunctionsAPIClient = (*Client)(nil)

// GetUserDefinedFunctionsPaginatorOptions is the paginator options for
// GetUserDefinedFunctions
type GetUserDefinedFunctionsPaginatorOptions struct {
	// The maximum number of functions to return in one response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetUserDefinedFunctionsPaginator is a paginator for GetUserDefinedFunctions
type GetUserDefinedFunctionsPaginator struct {
	options   GetUserDefinedFunctionsPaginatorOptions
	client    GetUserDefinedFunctionsAPIClient
	params    *GetUserDefinedFunctionsInput
	nextToken *string
	firstPage bool
}

// NewGetUserDefinedFunctionsPaginator returns a new
// GetUserDefinedFunctionsPaginator
func NewGetUserDefinedFunctionsPaginator(client GetUserDefinedFunctionsAPIClient, params *GetUserDefinedFunctionsInput, optFns ...func(*GetUserDefinedFunctionsPaginatorOptions)) *GetUserDefinedFunctionsPaginator {
	if params == nil {
		params = &GetUserDefinedFunctionsInput{}
	}

	options := GetUserDefinedFunctionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetUserDefinedFunctionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetUserDefinedFunctionsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next GetUserDefinedFunctions page.
func (p *GetUserDefinedFunctionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetUserDefinedFunctionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.GetUserDefinedFunctions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetUserDefinedFunctions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "glue",
		OperationName: "GetUserDefinedFunctions",
	}
}
