// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsAwsjson11_serializeOpAcceptMatch struct {
}

func (*awsAwsjson11_serializeOpAcceptMatch) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAcceptMatch) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptMatchInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.AcceptMatch")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAcceptMatchInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpClaimGameServer struct {
}

func (*awsAwsjson11_serializeOpClaimGameServer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpClaimGameServer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ClaimGameServerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.ClaimGameServer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentClaimGameServerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateAlias struct {
}

func (*awsAwsjson11_serializeOpCreateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateAlias")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateBuild struct {
}

func (*awsAwsjson11_serializeOpCreateBuild) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateBuild) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBuildInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateBuild")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateBuildInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateFleet struct {
}

func (*awsAwsjson11_serializeOpCreateFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateFleet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateFleetLocations struct {
}

func (*awsAwsjson11_serializeOpCreateFleetLocations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateFleetLocations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFleetLocationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateFleetLocations")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateFleetLocationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateGameServerGroup struct {
}

func (*awsAwsjson11_serializeOpCreateGameServerGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateGameServerGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGameServerGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateGameServerGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateGameServerGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateGameSession struct {
}

func (*awsAwsjson11_serializeOpCreateGameSession) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateGameSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGameSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateGameSession")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateGameSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateGameSessionQueue struct {
}

func (*awsAwsjson11_serializeOpCreateGameSessionQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateGameSessionQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGameSessionQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateGameSessionQueue")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateGameSessionQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateMatchmakingConfiguration struct {
}

func (*awsAwsjson11_serializeOpCreateMatchmakingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateMatchmakingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMatchmakingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateMatchmakingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateMatchmakingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateMatchmakingRuleSet struct {
}

func (*awsAwsjson11_serializeOpCreateMatchmakingRuleSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateMatchmakingRuleSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMatchmakingRuleSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateMatchmakingRuleSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateMatchmakingRuleSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreatePlayerSession struct {
}

func (*awsAwsjson11_serializeOpCreatePlayerSession) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreatePlayerSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePlayerSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreatePlayerSession")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreatePlayerSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreatePlayerSessions struct {
}

func (*awsAwsjson11_serializeOpCreatePlayerSessions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreatePlayerSessions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePlayerSessionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreatePlayerSessions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreatePlayerSessionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateScript struct {
}

func (*awsAwsjson11_serializeOpCreateScript) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateScript) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateScriptInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateScript")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateScriptInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateVpcPeeringAuthorization struct {
}

func (*awsAwsjson11_serializeOpCreateVpcPeeringAuthorization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateVpcPeeringAuthorization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpcPeeringAuthorizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateVpcPeeringAuthorization")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateVpcPeeringAuthorizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateVpcPeeringConnection struct {
}

func (*awsAwsjson11_serializeOpCreateVpcPeeringConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateVpcPeeringConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpcPeeringConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.CreateVpcPeeringConnection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateVpcPeeringConnectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteAlias struct {
}

func (*awsAwsjson11_serializeOpDeleteAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteAlias")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteBuild struct {
}

func (*awsAwsjson11_serializeOpDeleteBuild) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteBuild) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBuildInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteBuild")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteBuildInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteFleet struct {
}

func (*awsAwsjson11_serializeOpDeleteFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteFleet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteFleetLocations struct {
}

func (*awsAwsjson11_serializeOpDeleteFleetLocations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteFleetLocations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFleetLocationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteFleetLocations")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteFleetLocationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteGameServerGroup struct {
}

func (*awsAwsjson11_serializeOpDeleteGameServerGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteGameServerGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGameServerGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteGameServerGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteGameServerGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteGameSessionQueue struct {
}

func (*awsAwsjson11_serializeOpDeleteGameSessionQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteGameSessionQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGameSessionQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteGameSessionQueue")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteGameSessionQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteMatchmakingConfiguration struct {
}

func (*awsAwsjson11_serializeOpDeleteMatchmakingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteMatchmakingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMatchmakingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteMatchmakingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteMatchmakingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteMatchmakingRuleSet struct {
}

func (*awsAwsjson11_serializeOpDeleteMatchmakingRuleSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteMatchmakingRuleSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMatchmakingRuleSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteMatchmakingRuleSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteMatchmakingRuleSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteScalingPolicy struct {
}

func (*awsAwsjson11_serializeOpDeleteScalingPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteScalingPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteScalingPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteScalingPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteScalingPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteScript struct {
}

func (*awsAwsjson11_serializeOpDeleteScript) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteScript) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteScriptInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteScript")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteScriptInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteVpcPeeringAuthorization struct {
}

func (*awsAwsjson11_serializeOpDeleteVpcPeeringAuthorization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteVpcPeeringAuthorization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpcPeeringAuthorizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteVpcPeeringAuthorization")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteVpcPeeringAuthorizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteVpcPeeringConnection struct {
}

func (*awsAwsjson11_serializeOpDeleteVpcPeeringConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteVpcPeeringConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpcPeeringConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeleteVpcPeeringConnection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteVpcPeeringConnectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeregisterGameServer struct {
}

func (*awsAwsjson11_serializeOpDeregisterGameServer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeregisterGameServer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterGameServerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DeregisterGameServer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeregisterGameServerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeAlias struct {
}

func (*awsAwsjson11_serializeOpDescribeAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeAlias")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeBuild struct {
}

func (*awsAwsjson11_serializeOpDescribeBuild) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeBuild) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBuildInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeBuild")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeBuildInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeEC2InstanceLimits struct {
}

func (*awsAwsjson11_serializeOpDescribeEC2InstanceLimits) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeEC2InstanceLimits) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEC2InstanceLimitsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeEC2InstanceLimits")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeEC2InstanceLimitsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeFleetAttributes struct {
}

func (*awsAwsjson11_serializeOpDescribeFleetAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeFleetAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeFleetAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeFleetAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeFleetCapacity struct {
}

func (*awsAwsjson11_serializeOpDescribeFleetCapacity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeFleetCapacity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetCapacityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeFleetCapacity")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeFleetCapacityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeFleetEvents struct {
}

func (*awsAwsjson11_serializeOpDescribeFleetEvents) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeFleetEvents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetEventsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeFleetEvents")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeFleetEventsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeFleetLocationAttributes struct {
}

func (*awsAwsjson11_serializeOpDescribeFleetLocationAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeFleetLocationAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetLocationAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeFleetLocationAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeFleetLocationAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeFleetLocationCapacity struct {
}

func (*awsAwsjson11_serializeOpDescribeFleetLocationCapacity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeFleetLocationCapacity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetLocationCapacityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeFleetLocationCapacity")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeFleetLocationCapacityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeFleetLocationUtilization struct {
}

func (*awsAwsjson11_serializeOpDescribeFleetLocationUtilization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeFleetLocationUtilization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetLocationUtilizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeFleetLocationUtilization")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeFleetLocationUtilizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeFleetPortSettings struct {
}

func (*awsAwsjson11_serializeOpDescribeFleetPortSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeFleetPortSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetPortSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeFleetPortSettings")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeFleetPortSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeFleetUtilization struct {
}

func (*awsAwsjson11_serializeOpDescribeFleetUtilization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeFleetUtilization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetUtilizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeFleetUtilization")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeFleetUtilizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeGameServer struct {
}

func (*awsAwsjson11_serializeOpDescribeGameServer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeGameServer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGameServerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeGameServer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeGameServerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeGameServerGroup struct {
}

func (*awsAwsjson11_serializeOpDescribeGameServerGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeGameServerGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGameServerGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeGameServerGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeGameServerGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeGameServerInstances struct {
}

func (*awsAwsjson11_serializeOpDescribeGameServerInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeGameServerInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGameServerInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeGameServerInstances")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeGameServerInstancesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeGameSessionDetails struct {
}

func (*awsAwsjson11_serializeOpDescribeGameSessionDetails) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeGameSessionDetails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGameSessionDetailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeGameSessionDetails")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeGameSessionDetailsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeGameSessionPlacement struct {
}

func (*awsAwsjson11_serializeOpDescribeGameSessionPlacement) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeGameSessionPlacement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGameSessionPlacementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeGameSessionPlacement")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeGameSessionPlacementInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeGameSessionQueues struct {
}

func (*awsAwsjson11_serializeOpDescribeGameSessionQueues) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeGameSessionQueues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGameSessionQueuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeGameSessionQueues")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeGameSessionQueuesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeGameSessions struct {
}

func (*awsAwsjson11_serializeOpDescribeGameSessions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeGameSessions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGameSessionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeGameSessions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeGameSessionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeInstances struct {
}

func (*awsAwsjson11_serializeOpDescribeInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeInstances")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeInstancesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeMatchmaking struct {
}

func (*awsAwsjson11_serializeOpDescribeMatchmaking) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeMatchmaking) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMatchmakingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeMatchmaking")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeMatchmakingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeMatchmakingConfigurations struct {
}

func (*awsAwsjson11_serializeOpDescribeMatchmakingConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeMatchmakingConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMatchmakingConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeMatchmakingConfigurations")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeMatchmakingConfigurationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeMatchmakingRuleSets struct {
}

func (*awsAwsjson11_serializeOpDescribeMatchmakingRuleSets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeMatchmakingRuleSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMatchmakingRuleSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeMatchmakingRuleSets")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeMatchmakingRuleSetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribePlayerSessions struct {
}

func (*awsAwsjson11_serializeOpDescribePlayerSessions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribePlayerSessions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePlayerSessionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribePlayerSessions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribePlayerSessionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeRuntimeConfiguration struct {
}

func (*awsAwsjson11_serializeOpDescribeRuntimeConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeRuntimeConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRuntimeConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeRuntimeConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeRuntimeConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeScalingPolicies struct {
}

func (*awsAwsjson11_serializeOpDescribeScalingPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeScalingPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeScalingPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeScalingPolicies")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeScalingPoliciesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeScript struct {
}

func (*awsAwsjson11_serializeOpDescribeScript) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeScript) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeScriptInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeScript")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeScriptInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeVpcPeeringAuthorizations struct {
}

func (*awsAwsjson11_serializeOpDescribeVpcPeeringAuthorizations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeVpcPeeringAuthorizations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcPeeringAuthorizationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeVpcPeeringAuthorizations")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeVpcPeeringAuthorizationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeVpcPeeringConnections struct {
}

func (*awsAwsjson11_serializeOpDescribeVpcPeeringConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeVpcPeeringConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcPeeringConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.DescribeVpcPeeringConnections")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeVpcPeeringConnectionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetGameSessionLogUrl struct {
}

func (*awsAwsjson11_serializeOpGetGameSessionLogUrl) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetGameSessionLogUrl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGameSessionLogUrlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.GetGameSessionLogUrl")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetGameSessionLogUrlInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetInstanceAccess struct {
}

func (*awsAwsjson11_serializeOpGetInstanceAccess) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetInstanceAccess) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetInstanceAccessInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.GetInstanceAccess")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetInstanceAccessInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListAliases struct {
}

func (*awsAwsjson11_serializeOpListAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.ListAliases")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListAliasesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListBuilds struct {
}

func (*awsAwsjson11_serializeOpListBuilds) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListBuilds) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBuildsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.ListBuilds")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListBuildsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListFleets struct {
}

func (*awsAwsjson11_serializeOpListFleets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListFleets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFleetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.ListFleets")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListFleetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListGameServerGroups struct {
}

func (*awsAwsjson11_serializeOpListGameServerGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListGameServerGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGameServerGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.ListGameServerGroups")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListGameServerGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListGameServers struct {
}

func (*awsAwsjson11_serializeOpListGameServers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListGameServers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGameServersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.ListGameServers")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListGameServersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListScripts struct {
}

func (*awsAwsjson11_serializeOpListScripts) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListScripts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListScriptsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.ListScripts")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListScriptsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTagsForResource struct {
}

func (*awsAwsjson11_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutScalingPolicy struct {
}

func (*awsAwsjson11_serializeOpPutScalingPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutScalingPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutScalingPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.PutScalingPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutScalingPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRegisterGameServer struct {
}

func (*awsAwsjson11_serializeOpRegisterGameServer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRegisterGameServer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterGameServerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.RegisterGameServer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRegisterGameServerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRequestUploadCredentials struct {
}

func (*awsAwsjson11_serializeOpRequestUploadCredentials) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRequestUploadCredentials) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RequestUploadCredentialsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.RequestUploadCredentials")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRequestUploadCredentialsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpResolveAlias struct {
}

func (*awsAwsjson11_serializeOpResolveAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpResolveAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResolveAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.ResolveAlias")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentResolveAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpResumeGameServerGroup struct {
}

func (*awsAwsjson11_serializeOpResumeGameServerGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpResumeGameServerGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResumeGameServerGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.ResumeGameServerGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentResumeGameServerGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSearchGameSessions struct {
}

func (*awsAwsjson11_serializeOpSearchGameSessions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSearchGameSessions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchGameSessionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.SearchGameSessions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSearchGameSessionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartFleetActions struct {
}

func (*awsAwsjson11_serializeOpStartFleetActions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartFleetActions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartFleetActionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.StartFleetActions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartFleetActionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartGameSessionPlacement struct {
}

func (*awsAwsjson11_serializeOpStartGameSessionPlacement) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartGameSessionPlacement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartGameSessionPlacementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.StartGameSessionPlacement")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartGameSessionPlacementInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartMatchBackfill struct {
}

func (*awsAwsjson11_serializeOpStartMatchBackfill) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartMatchBackfill) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartMatchBackfillInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.StartMatchBackfill")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartMatchBackfillInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartMatchmaking struct {
}

func (*awsAwsjson11_serializeOpStartMatchmaking) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartMatchmaking) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartMatchmakingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.StartMatchmaking")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartMatchmakingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopFleetActions struct {
}

func (*awsAwsjson11_serializeOpStopFleetActions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopFleetActions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopFleetActionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.StopFleetActions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopFleetActionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopGameSessionPlacement struct {
}

func (*awsAwsjson11_serializeOpStopGameSessionPlacement) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopGameSessionPlacement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopGameSessionPlacementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.StopGameSessionPlacement")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopGameSessionPlacementInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopMatchmaking struct {
}

func (*awsAwsjson11_serializeOpStopMatchmaking) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopMatchmaking) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopMatchmakingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.StopMatchmaking")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopMatchmakingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSuspendGameServerGroup struct {
}

func (*awsAwsjson11_serializeOpSuspendGameServerGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSuspendGameServerGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SuspendGameServerGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.SuspendGameServerGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSuspendGameServerGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagResource struct {
}

func (*awsAwsjson11_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagResource struct {
}

func (*awsAwsjson11_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateAlias struct {
}

func (*awsAwsjson11_serializeOpUpdateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateAlias")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateBuild struct {
}

func (*awsAwsjson11_serializeOpUpdateBuild) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateBuild) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBuildInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateBuild")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateBuildInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateFleetAttributes struct {
}

func (*awsAwsjson11_serializeOpUpdateFleetAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateFleetAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFleetAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateFleetAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateFleetAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateFleetCapacity struct {
}

func (*awsAwsjson11_serializeOpUpdateFleetCapacity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateFleetCapacity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFleetCapacityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateFleetCapacity")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateFleetCapacityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateFleetPortSettings struct {
}

func (*awsAwsjson11_serializeOpUpdateFleetPortSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateFleetPortSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFleetPortSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateFleetPortSettings")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateFleetPortSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateGameServer struct {
}

func (*awsAwsjson11_serializeOpUpdateGameServer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateGameServer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGameServerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateGameServer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateGameServerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateGameServerGroup struct {
}

func (*awsAwsjson11_serializeOpUpdateGameServerGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateGameServerGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGameServerGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateGameServerGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateGameServerGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateGameSession struct {
}

func (*awsAwsjson11_serializeOpUpdateGameSession) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateGameSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGameSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateGameSession")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateGameSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateGameSessionQueue struct {
}

func (*awsAwsjson11_serializeOpUpdateGameSessionQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateGameSessionQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGameSessionQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateGameSessionQueue")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateGameSessionQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateMatchmakingConfiguration struct {
}

func (*awsAwsjson11_serializeOpUpdateMatchmakingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateMatchmakingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMatchmakingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateMatchmakingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateMatchmakingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateRuntimeConfiguration struct {
}

func (*awsAwsjson11_serializeOpUpdateRuntimeConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateRuntimeConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRuntimeConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateRuntimeConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateRuntimeConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateScript struct {
}

func (*awsAwsjson11_serializeOpUpdateScript) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateScript) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateScriptInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.UpdateScript")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateScriptInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpValidateMatchmakingRuleSet struct {
}

func (*awsAwsjson11_serializeOpValidateMatchmakingRuleSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpValidateMatchmakingRuleSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ValidateMatchmakingRuleSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("GameLift.ValidateMatchmakingRuleSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentValidateMatchmakingRuleSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentAttributeValue(v *types.AttributeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.N != nil {
		ok := object.Key("N")
		switch {
		case math.IsNaN(*v.N):
			ok.String("NaN")

		case math.IsInf(*v.N, 1):
			ok.String("Infinity")

		case math.IsInf(*v.N, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.N)

		}
	}

	if v.S != nil {
		ok := object.Key("S")
		ok.String(*v.S)
	}

	if v.SDM != nil {
		ok := object.Key("SDM")
		if err := awsAwsjson11_serializeDocumentStringDoubleMap(v.SDM, ok); err != nil {
			return err
		}
	}

	if v.SL != nil {
		ok := object.Key("SL")
		if err := awsAwsjson11_serializeDocumentStringList(v.SL, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCertificateConfiguration(v *types.CertificateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CertificateType) > 0 {
		ok := object.Key("CertificateType")
		ok.String(string(v.CertificateType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDesiredPlayerSession(v *types.DesiredPlayerSession, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PlayerData != nil {
		ok := object.Key("PlayerData")
		ok.String(*v.PlayerData)
	}

	if v.PlayerId != nil {
		ok := object.Key("PlayerId")
		ok.String(*v.PlayerId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDesiredPlayerSessionList(v []types.DesiredPlayerSession, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentDesiredPlayerSession(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentFilterConfiguration(v *types.FilterConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedLocations != nil {
		ok := object.Key("AllowedLocations")
		if err := awsAwsjson11_serializeDocumentLocationList(v.AllowedLocations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentFleetActionList(v []types.FleetAction, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentFleetIdOrArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentGameProperty(v *types.GameProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentGamePropertyList(v []types.GameProperty, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentGameProperty(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentGameServerGroupActions(v []types.GameServerGroupAction, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentGameServerGroupAutoScalingPolicy(v *types.GameServerGroupAutoScalingPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EstimatedInstanceWarmup != nil {
		ok := object.Key("EstimatedInstanceWarmup")
		ok.Integer(*v.EstimatedInstanceWarmup)
	}

	if v.TargetTrackingConfiguration != nil {
		ok := object.Key("TargetTrackingConfiguration")
		if err := awsAwsjson11_serializeDocumentTargetTrackingConfiguration(v.TargetTrackingConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentGameServerInstanceIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentGameSessionQueueDestination(v *types.GameSessionQueueDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationArn != nil {
		ok := object.Key("DestinationArn")
		ok.String(*v.DestinationArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentGameSessionQueueDestinationList(v []types.GameSessionQueueDestination, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentGameSessionQueueDestination(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentGameSessionQueueNameOrArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentInstanceDefinition(v *types.InstanceDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InstanceType) > 0 {
		ok := object.Key("InstanceType")
		ok.String(string(v.InstanceType))
	}

	if v.WeightedCapacity != nil {
		ok := object.Key("WeightedCapacity")
		ok.String(*v.WeightedCapacity)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInstanceDefinitions(v []types.InstanceDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInstanceDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentIpPermission(v *types.IpPermission, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FromPort != nil {
		ok := object.Key("FromPort")
		ok.Integer(*v.FromPort)
	}

	if v.IpRange != nil {
		ok := object.Key("IpRange")
		ok.String(*v.IpRange)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("Protocol")
		ok.String(string(v.Protocol))
	}

	if v.ToPort != nil {
		ok := object.Key("ToPort")
		ok.Integer(*v.ToPort)
	}

	return nil
}

func awsAwsjson11_serializeDocumentIpPermissionsList(v []types.IpPermission, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentIpPermission(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentLatencyMap(v map[string]int32, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.Integer(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentLaunchTemplateSpecification(v *types.LaunchTemplateSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LaunchTemplateId != nil {
		ok := object.Key("LaunchTemplateId")
		ok.String(*v.LaunchTemplateId)
	}

	if v.LaunchTemplateName != nil {
		ok := object.Key("LaunchTemplateName")
		ok.String(*v.LaunchTemplateName)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLocationConfiguration(v *types.LocationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLocationConfigurationList(v []types.LocationConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentLocationConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentLocationList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentMatchmakingConfigurationNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentMatchmakingIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentMatchmakingRuleSetNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentMetricGroupList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentPlayer(v *types.Player, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LatencyInMs != nil {
		ok := object.Key("LatencyInMs")
		if err := awsAwsjson11_serializeDocumentLatencyMap(v.LatencyInMs, ok); err != nil {
			return err
		}
	}

	if v.PlayerAttributes != nil {
		ok := object.Key("PlayerAttributes")
		if err := awsAwsjson11_serializeDocumentPlayerAttributeMap(v.PlayerAttributes, ok); err != nil {
			return err
		}
	}

	if v.PlayerId != nil {
		ok := object.Key("PlayerId")
		ok.String(*v.PlayerId)
	}

	if v.Team != nil {
		ok := object.Key("Team")
		ok.String(*v.Team)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPlayerAttributeMap(v map[string]types.AttributeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson11_serializeDocumentAttributeValue(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPlayerDataMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentPlayerIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentPlayerLatency(v *types.PlayerLatency, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LatencyInMilliseconds != 0 {
		ok := object.Key("LatencyInMilliseconds")
		switch {
		case math.IsNaN(float64(v.LatencyInMilliseconds)):
			ok.String("NaN")

		case math.IsInf(float64(v.LatencyInMilliseconds), 1):
			ok.String("Infinity")

		case math.IsInf(float64(v.LatencyInMilliseconds), -1):
			ok.String("-Infinity")

		default:
			ok.Float(v.LatencyInMilliseconds)

		}
	}

	if v.PlayerId != nil {
		ok := object.Key("PlayerId")
		ok.String(*v.PlayerId)
	}

	if v.RegionIdentifier != nil {
		ok := object.Key("RegionIdentifier")
		ok.String(*v.RegionIdentifier)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPlayerLatencyList(v []types.PlayerLatency, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPlayerLatency(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPlayerLatencyPolicy(v *types.PlayerLatencyPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaximumIndividualPlayerLatencyMilliseconds != nil {
		ok := object.Key("MaximumIndividualPlayerLatencyMilliseconds")
		ok.Integer(*v.MaximumIndividualPlayerLatencyMilliseconds)
	}

	if v.PolicyDurationSeconds != nil {
		ok := object.Key("PolicyDurationSeconds")
		ok.Integer(*v.PolicyDurationSeconds)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPlayerLatencyPolicyList(v []types.PlayerLatencyPolicy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPlayerLatencyPolicy(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPlayerList(v []types.Player, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPlayer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPriorityConfiguration(v *types.PriorityConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LocationOrder != nil {
		ok := object.Key("LocationOrder")
		if err := awsAwsjson11_serializeDocumentLocationList(v.LocationOrder, ok); err != nil {
			return err
		}
	}

	if v.PriorityOrder != nil {
		ok := object.Key("PriorityOrder")
		if err := awsAwsjson11_serializeDocumentPriorityTypeList(v.PriorityOrder, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPriorityTypeList(v []types.PriorityType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentQueueArnsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentResourceCreationLimitPolicy(v *types.ResourceCreationLimitPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NewGameSessionsPerCreator != nil {
		ok := object.Key("NewGameSessionsPerCreator")
		ok.Integer(*v.NewGameSessionsPerCreator)
	}

	if v.PolicyPeriodInMinutes != nil {
		ok := object.Key("PolicyPeriodInMinutes")
		ok.Integer(*v.PolicyPeriodInMinutes)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRoutingStrategy(v *types.RoutingStrategy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Message != nil {
		ok := object.Key("Message")
		ok.String(*v.Message)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentRuntimeConfiguration(v *types.RuntimeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameSessionActivationTimeoutSeconds != nil {
		ok := object.Key("GameSessionActivationTimeoutSeconds")
		ok.Integer(*v.GameSessionActivationTimeoutSeconds)
	}

	if v.MaxConcurrentGameSessionActivations != nil {
		ok := object.Key("MaxConcurrentGameSessionActivations")
		ok.Integer(*v.MaxConcurrentGameSessionActivations)
	}

	if v.ServerProcesses != nil {
		ok := object.Key("ServerProcesses")
		if err := awsAwsjson11_serializeDocumentServerProcessList(v.ServerProcesses, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3Location(v *types.S3Location, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("Bucket")
		ok.String(*v.Bucket)
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.ObjectVersion != nil {
		ok := object.Key("ObjectVersion")
		ok.String(*v.ObjectVersion)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentServerProcess(v *types.ServerProcess, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConcurrentExecutions != nil {
		ok := object.Key("ConcurrentExecutions")
		ok.Integer(*v.ConcurrentExecutions)
	}

	if v.LaunchPath != nil {
		ok := object.Key("LaunchPath")
		ok.String(*v.LaunchPath)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		ok.String(*v.Parameters)
	}

	return nil
}

func awsAwsjson11_serializeDocumentServerProcessList(v []types.ServerProcess, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentServerProcess(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentStringDoubleMap(v map[string]float64, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		switch {
		case math.IsNaN(v[key]):
			om.String("NaN")

		case math.IsInf(v[key], 1):
			om.String("Infinity")

		case math.IsInf(v[key], -1):
			om.String("-Infinity")

		default:
			om.Double(v[key])

		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTargetConfiguration(v *types.TargetConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("TargetValue")
		switch {
		case math.IsNaN(v.TargetValue):
			ok.String("NaN")

		case math.IsInf(v.TargetValue, 1):
			ok.String("Infinity")

		case math.IsInf(v.TargetValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.TargetValue)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentTargetTrackingConfiguration(v *types.TargetTrackingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetValue != nil {
		ok := object.Key("TargetValue")
		switch {
		case math.IsNaN(*v.TargetValue):
			ok.String("NaN")

		case math.IsInf(*v.TargetValue, 1):
			ok.String("Infinity")

		case math.IsInf(*v.TargetValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.TargetValue)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentVpcSubnets(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeOpDocumentAcceptMatchInput(v *AcceptMatchInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AcceptanceType) > 0 {
		ok := object.Key("AcceptanceType")
		ok.String(string(v.AcceptanceType))
	}

	if v.PlayerIds != nil {
		ok := object.Key("PlayerIds")
		if err := awsAwsjson11_serializeDocumentStringList(v.PlayerIds, ok); err != nil {
			return err
		}
	}

	if v.TicketId != nil {
		ok := object.Key("TicketId")
		ok.String(*v.TicketId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentClaimGameServerInput(v *ClaimGameServerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameServerData != nil {
		ok := object.Key("GameServerData")
		ok.String(*v.GameServerData)
	}

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	if v.GameServerId != nil {
		ok := object.Key("GameServerId")
		ok.String(*v.GameServerId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateAliasInput(v *CreateAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RoutingStrategy != nil {
		ok := object.Key("RoutingStrategy")
		if err := awsAwsjson11_serializeDocumentRoutingStrategy(v.RoutingStrategy, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateBuildInput(v *CreateBuildInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.OperatingSystem) > 0 {
		ok := object.Key("OperatingSystem")
		ok.String(string(v.OperatingSystem))
	}

	if v.StorageLocation != nil {
		ok := object.Key("StorageLocation")
		if err := awsAwsjson11_serializeDocumentS3Location(v.StorageLocation, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateFleetInput(v *CreateFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BuildId != nil {
		ok := object.Key("BuildId")
		ok.String(*v.BuildId)
	}

	if v.CertificateConfiguration != nil {
		ok := object.Key("CertificateConfiguration")
		if err := awsAwsjson11_serializeDocumentCertificateConfiguration(v.CertificateConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EC2InboundPermissions != nil {
		ok := object.Key("EC2InboundPermissions")
		if err := awsAwsjson11_serializeDocumentIpPermissionsList(v.EC2InboundPermissions, ok); err != nil {
			return err
		}
	}

	if len(v.EC2InstanceType) > 0 {
		ok := object.Key("EC2InstanceType")
		ok.String(string(v.EC2InstanceType))
	}

	if len(v.FleetType) > 0 {
		ok := object.Key("FleetType")
		ok.String(string(v.FleetType))
	}

	if v.InstanceRoleArn != nil {
		ok := object.Key("InstanceRoleArn")
		ok.String(*v.InstanceRoleArn)
	}

	if v.Locations != nil {
		ok := object.Key("Locations")
		if err := awsAwsjson11_serializeDocumentLocationConfigurationList(v.Locations, ok); err != nil {
			return err
		}
	}

	if v.LogPaths != nil {
		ok := object.Key("LogPaths")
		if err := awsAwsjson11_serializeDocumentStringList(v.LogPaths, ok); err != nil {
			return err
		}
	}

	if v.MetricGroups != nil {
		ok := object.Key("MetricGroups")
		if err := awsAwsjson11_serializeDocumentMetricGroupList(v.MetricGroups, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.NewGameSessionProtectionPolicy) > 0 {
		ok := object.Key("NewGameSessionProtectionPolicy")
		ok.String(string(v.NewGameSessionProtectionPolicy))
	}

	if v.PeerVpcAwsAccountId != nil {
		ok := object.Key("PeerVpcAwsAccountId")
		ok.String(*v.PeerVpcAwsAccountId)
	}

	if v.PeerVpcId != nil {
		ok := object.Key("PeerVpcId")
		ok.String(*v.PeerVpcId)
	}

	if v.ResourceCreationLimitPolicy != nil {
		ok := object.Key("ResourceCreationLimitPolicy")
		if err := awsAwsjson11_serializeDocumentResourceCreationLimitPolicy(v.ResourceCreationLimitPolicy, ok); err != nil {
			return err
		}
	}

	if v.RuntimeConfiguration != nil {
		ok := object.Key("RuntimeConfiguration")
		if err := awsAwsjson11_serializeDocumentRuntimeConfiguration(v.RuntimeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ScriptId != nil {
		ok := object.Key("ScriptId")
		ok.String(*v.ScriptId)
	}

	if v.ServerLaunchParameters != nil {
		ok := object.Key("ServerLaunchParameters")
		ok.String(*v.ServerLaunchParameters)
	}

	if v.ServerLaunchPath != nil {
		ok := object.Key("ServerLaunchPath")
		ok.String(*v.ServerLaunchPath)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateFleetLocationsInput(v *CreateFleetLocationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Locations != nil {
		ok := object.Key("Locations")
		if err := awsAwsjson11_serializeDocumentLocationConfigurationList(v.Locations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateGameServerGroupInput(v *CreateGameServerGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoScalingPolicy != nil {
		ok := object.Key("AutoScalingPolicy")
		if err := awsAwsjson11_serializeDocumentGameServerGroupAutoScalingPolicy(v.AutoScalingPolicy, ok); err != nil {
			return err
		}
	}

	if len(v.BalancingStrategy) > 0 {
		ok := object.Key("BalancingStrategy")
		ok.String(string(v.BalancingStrategy))
	}

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	if len(v.GameServerProtectionPolicy) > 0 {
		ok := object.Key("GameServerProtectionPolicy")
		ok.String(string(v.GameServerProtectionPolicy))
	}

	if v.InstanceDefinitions != nil {
		ok := object.Key("InstanceDefinitions")
		if err := awsAwsjson11_serializeDocumentInstanceDefinitions(v.InstanceDefinitions, ok); err != nil {
			return err
		}
	}

	if v.LaunchTemplate != nil {
		ok := object.Key("LaunchTemplate")
		if err := awsAwsjson11_serializeDocumentLaunchTemplateSpecification(v.LaunchTemplate, ok); err != nil {
			return err
		}
	}

	if v.MaxSize != nil {
		ok := object.Key("MaxSize")
		ok.Integer(*v.MaxSize)
	}

	if v.MinSize != nil {
		ok := object.Key("MinSize")
		ok.Integer(*v.MinSize)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VpcSubnets != nil {
		ok := object.Key("VpcSubnets")
		if err := awsAwsjson11_serializeDocumentVpcSubnets(v.VpcSubnets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateGameSessionInput(v *CreateGameSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasId != nil {
		ok := object.Key("AliasId")
		ok.String(*v.AliasId)
	}

	if v.CreatorId != nil {
		ok := object.Key("CreatorId")
		ok.String(*v.CreatorId)
	}

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.GameProperties != nil {
		ok := object.Key("GameProperties")
		if err := awsAwsjson11_serializeDocumentGamePropertyList(v.GameProperties, ok); err != nil {
			return err
		}
	}

	if v.GameSessionData != nil {
		ok := object.Key("GameSessionData")
		ok.String(*v.GameSessionData)
	}

	if v.GameSessionId != nil {
		ok := object.Key("GameSessionId")
		ok.String(*v.GameSessionId)
	}

	if v.IdempotencyToken != nil {
		ok := object.Key("IdempotencyToken")
		ok.String(*v.IdempotencyToken)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	if v.MaximumPlayerSessionCount != nil {
		ok := object.Key("MaximumPlayerSessionCount")
		ok.Integer(*v.MaximumPlayerSessionCount)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateGameSessionQueueInput(v *CreateGameSessionQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomEventData != nil {
		ok := object.Key("CustomEventData")
		ok.String(*v.CustomEventData)
	}

	if v.Destinations != nil {
		ok := object.Key("Destinations")
		if err := awsAwsjson11_serializeDocumentGameSessionQueueDestinationList(v.Destinations, ok); err != nil {
			return err
		}
	}

	if v.FilterConfiguration != nil {
		ok := object.Key("FilterConfiguration")
		if err := awsAwsjson11_serializeDocumentFilterConfiguration(v.FilterConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NotificationTarget != nil {
		ok := object.Key("NotificationTarget")
		ok.String(*v.NotificationTarget)
	}

	if v.PlayerLatencyPolicies != nil {
		ok := object.Key("PlayerLatencyPolicies")
		if err := awsAwsjson11_serializeDocumentPlayerLatencyPolicyList(v.PlayerLatencyPolicies, ok); err != nil {
			return err
		}
	}

	if v.PriorityConfiguration != nil {
		ok := object.Key("PriorityConfiguration")
		if err := awsAwsjson11_serializeDocumentPriorityConfiguration(v.PriorityConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TimeoutInSeconds != nil {
		ok := object.Key("TimeoutInSeconds")
		ok.Integer(*v.TimeoutInSeconds)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateMatchmakingConfigurationInput(v *CreateMatchmakingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AcceptanceRequired != nil {
		ok := object.Key("AcceptanceRequired")
		ok.Boolean(*v.AcceptanceRequired)
	}

	if v.AcceptanceTimeoutSeconds != nil {
		ok := object.Key("AcceptanceTimeoutSeconds")
		ok.Integer(*v.AcceptanceTimeoutSeconds)
	}

	if v.AdditionalPlayerCount != nil {
		ok := object.Key("AdditionalPlayerCount")
		ok.Integer(*v.AdditionalPlayerCount)
	}

	if len(v.BackfillMode) > 0 {
		ok := object.Key("BackfillMode")
		ok.String(string(v.BackfillMode))
	}

	if v.CustomEventData != nil {
		ok := object.Key("CustomEventData")
		ok.String(*v.CustomEventData)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.FlexMatchMode) > 0 {
		ok := object.Key("FlexMatchMode")
		ok.String(string(v.FlexMatchMode))
	}

	if v.GameProperties != nil {
		ok := object.Key("GameProperties")
		if err := awsAwsjson11_serializeDocumentGamePropertyList(v.GameProperties, ok); err != nil {
			return err
		}
	}

	if v.GameSessionData != nil {
		ok := object.Key("GameSessionData")
		ok.String(*v.GameSessionData)
	}

	if v.GameSessionQueueArns != nil {
		ok := object.Key("GameSessionQueueArns")
		if err := awsAwsjson11_serializeDocumentQueueArnsList(v.GameSessionQueueArns, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NotificationTarget != nil {
		ok := object.Key("NotificationTarget")
		ok.String(*v.NotificationTarget)
	}

	if v.RequestTimeoutSeconds != nil {
		ok := object.Key("RequestTimeoutSeconds")
		ok.Integer(*v.RequestTimeoutSeconds)
	}

	if v.RuleSetName != nil {
		ok := object.Key("RuleSetName")
		ok.String(*v.RuleSetName)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateMatchmakingRuleSetInput(v *CreateMatchmakingRuleSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RuleSetBody != nil {
		ok := object.Key("RuleSetBody")
		ok.String(*v.RuleSetBody)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreatePlayerSessionInput(v *CreatePlayerSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameSessionId != nil {
		ok := object.Key("GameSessionId")
		ok.String(*v.GameSessionId)
	}

	if v.PlayerData != nil {
		ok := object.Key("PlayerData")
		ok.String(*v.PlayerData)
	}

	if v.PlayerId != nil {
		ok := object.Key("PlayerId")
		ok.String(*v.PlayerId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreatePlayerSessionsInput(v *CreatePlayerSessionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameSessionId != nil {
		ok := object.Key("GameSessionId")
		ok.String(*v.GameSessionId)
	}

	if v.PlayerDataMap != nil {
		ok := object.Key("PlayerDataMap")
		if err := awsAwsjson11_serializeDocumentPlayerDataMap(v.PlayerDataMap, ok); err != nil {
			return err
		}
	}

	if v.PlayerIds != nil {
		ok := object.Key("PlayerIds")
		if err := awsAwsjson11_serializeDocumentPlayerIdList(v.PlayerIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateScriptInput(v *CreateScriptInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.StorageLocation != nil {
		ok := object.Key("StorageLocation")
		if err := awsAwsjson11_serializeDocumentS3Location(v.StorageLocation, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	if v.ZipFile != nil {
		ok := object.Key("ZipFile")
		ok.Base64EncodeBytes(v.ZipFile)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateVpcPeeringAuthorizationInput(v *CreateVpcPeeringAuthorizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameLiftAwsAccountId != nil {
		ok := object.Key("GameLiftAwsAccountId")
		ok.String(*v.GameLiftAwsAccountId)
	}

	if v.PeerVpcId != nil {
		ok := object.Key("PeerVpcId")
		ok.String(*v.PeerVpcId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateVpcPeeringConnectionInput(v *CreateVpcPeeringConnectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.PeerVpcAwsAccountId != nil {
		ok := object.Key("PeerVpcAwsAccountId")
		ok.String(*v.PeerVpcAwsAccountId)
	}

	if v.PeerVpcId != nil {
		ok := object.Key("PeerVpcId")
		ok.String(*v.PeerVpcId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteAliasInput(v *DeleteAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasId != nil {
		ok := object.Key("AliasId")
		ok.String(*v.AliasId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteBuildInput(v *DeleteBuildInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BuildId != nil {
		ok := object.Key("BuildId")
		ok.String(*v.BuildId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteFleetInput(v *DeleteFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteFleetLocationsInput(v *DeleteFleetLocationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Locations != nil {
		ok := object.Key("Locations")
		if err := awsAwsjson11_serializeDocumentLocationList(v.Locations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteGameServerGroupInput(v *DeleteGameServerGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DeleteOption) > 0 {
		ok := object.Key("DeleteOption")
		ok.String(string(v.DeleteOption))
	}

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteGameSessionQueueInput(v *DeleteGameSessionQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteMatchmakingConfigurationInput(v *DeleteMatchmakingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteMatchmakingRuleSetInput(v *DeleteMatchmakingRuleSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteScalingPolicyInput(v *DeleteScalingPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteScriptInput(v *DeleteScriptInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScriptId != nil {
		ok := object.Key("ScriptId")
		ok.String(*v.ScriptId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteVpcPeeringAuthorizationInput(v *DeleteVpcPeeringAuthorizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameLiftAwsAccountId != nil {
		ok := object.Key("GameLiftAwsAccountId")
		ok.String(*v.GameLiftAwsAccountId)
	}

	if v.PeerVpcId != nil {
		ok := object.Key("PeerVpcId")
		ok.String(*v.PeerVpcId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteVpcPeeringConnectionInput(v *DeleteVpcPeeringConnectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.VpcPeeringConnectionId != nil {
		ok := object.Key("VpcPeeringConnectionId")
		ok.String(*v.VpcPeeringConnectionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeregisterGameServerInput(v *DeregisterGameServerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	if v.GameServerId != nil {
		ok := object.Key("GameServerId")
		ok.String(*v.GameServerId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeAliasInput(v *DescribeAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasId != nil {
		ok := object.Key("AliasId")
		ok.String(*v.AliasId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeBuildInput(v *DescribeBuildInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BuildId != nil {
		ok := object.Key("BuildId")
		ok.String(*v.BuildId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeEC2InstanceLimitsInput(v *DescribeEC2InstanceLimitsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EC2InstanceType) > 0 {
		ok := object.Key("EC2InstanceType")
		ok.String(string(v.EC2InstanceType))
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeFleetAttributesInput(v *DescribeFleetAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetIds != nil {
		ok := object.Key("FleetIds")
		if err := awsAwsjson11_serializeDocumentFleetIdOrArnList(v.FleetIds, ok); err != nil {
			return err
		}
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeFleetCapacityInput(v *DescribeFleetCapacityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetIds != nil {
		ok := object.Key("FleetIds")
		if err := awsAwsjson11_serializeDocumentFleetIdOrArnList(v.FleetIds, ok); err != nil {
			return err
		}
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeFleetEventsInput(v *DescribeFleetEventsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeFleetLocationAttributesInput(v *DescribeFleetLocationAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.Locations != nil {
		ok := object.Key("Locations")
		if err := awsAwsjson11_serializeDocumentLocationList(v.Locations, ok); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeFleetLocationCapacityInput(v *DescribeFleetLocationCapacityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeFleetLocationUtilizationInput(v *DescribeFleetLocationUtilizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeFleetPortSettingsInput(v *DescribeFleetPortSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeFleetUtilizationInput(v *DescribeFleetUtilizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetIds != nil {
		ok := object.Key("FleetIds")
		if err := awsAwsjson11_serializeDocumentFleetIdOrArnList(v.FleetIds, ok); err != nil {
			return err
		}
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeGameServerGroupInput(v *DescribeGameServerGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeGameServerInput(v *DescribeGameServerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	if v.GameServerId != nil {
		ok := object.Key("GameServerId")
		ok.String(*v.GameServerId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeGameServerInstancesInput(v *DescribeGameServerInstancesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	if v.InstanceIds != nil {
		ok := object.Key("InstanceIds")
		if err := awsAwsjson11_serializeDocumentGameServerInstanceIds(v.InstanceIds, ok); err != nil {
			return err
		}
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeGameSessionDetailsInput(v *DescribeGameSessionDetailsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasId != nil {
		ok := object.Key("AliasId")
		ok.String(*v.AliasId)
	}

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.GameSessionId != nil {
		ok := object.Key("GameSessionId")
		ok.String(*v.GameSessionId)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.StatusFilter != nil {
		ok := object.Key("StatusFilter")
		ok.String(*v.StatusFilter)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeGameSessionPlacementInput(v *DescribeGameSessionPlacementInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PlacementId != nil {
		ok := object.Key("PlacementId")
		ok.String(*v.PlacementId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeGameSessionQueuesInput(v *DescribeGameSessionQueuesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.Names != nil {
		ok := object.Key("Names")
		if err := awsAwsjson11_serializeDocumentGameSessionQueueNameOrArnList(v.Names, ok); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeGameSessionsInput(v *DescribeGameSessionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasId != nil {
		ok := object.Key("AliasId")
		ok.String(*v.AliasId)
	}

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.GameSessionId != nil {
		ok := object.Key("GameSessionId")
		ok.String(*v.GameSessionId)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.StatusFilter != nil {
		ok := object.Key("StatusFilter")
		ok.String(*v.StatusFilter)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeInstancesInput(v *DescribeInstancesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeMatchmakingConfigurationsInput(v *DescribeMatchmakingConfigurationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.Names != nil {
		ok := object.Key("Names")
		if err := awsAwsjson11_serializeDocumentMatchmakingConfigurationNameList(v.Names, ok); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.RuleSetName != nil {
		ok := object.Key("RuleSetName")
		ok.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeMatchmakingInput(v *DescribeMatchmakingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TicketIds != nil {
		ok := object.Key("TicketIds")
		if err := awsAwsjson11_serializeDocumentMatchmakingIdList(v.TicketIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeMatchmakingRuleSetsInput(v *DescribeMatchmakingRuleSetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.Names != nil {
		ok := object.Key("Names")
		if err := awsAwsjson11_serializeDocumentMatchmakingRuleSetNameList(v.Names, ok); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribePlayerSessionsInput(v *DescribePlayerSessionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameSessionId != nil {
		ok := object.Key("GameSessionId")
		ok.String(*v.GameSessionId)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.PlayerId != nil {
		ok := object.Key("PlayerId")
		ok.String(*v.PlayerId)
	}

	if v.PlayerSessionId != nil {
		ok := object.Key("PlayerSessionId")
		ok.String(*v.PlayerSessionId)
	}

	if v.PlayerSessionStatusFilter != nil {
		ok := object.Key("PlayerSessionStatusFilter")
		ok.String(*v.PlayerSessionStatusFilter)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeRuntimeConfigurationInput(v *DescribeRuntimeConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeScalingPoliciesInput(v *DescribeScalingPoliciesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.StatusFilter) > 0 {
		ok := object.Key("StatusFilter")
		ok.String(string(v.StatusFilter))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeScriptInput(v *DescribeScriptInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScriptId != nil {
		ok := object.Key("ScriptId")
		ok.String(*v.ScriptId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeVpcPeeringAuthorizationsInput(v *DescribeVpcPeeringAuthorizationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeVpcPeeringConnectionsInput(v *DescribeVpcPeeringConnectionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetGameSessionLogUrlInput(v *GetGameSessionLogUrlInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameSessionId != nil {
		ok := object.Key("GameSessionId")
		ok.String(*v.GameSessionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetInstanceAccessInput(v *GetInstanceAccessInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListAliasesInput(v *ListAliasesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.RoutingStrategyType) > 0 {
		ok := object.Key("RoutingStrategyType")
		ok.String(string(v.RoutingStrategyType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListBuildsInput(v *ListBuildsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListFleetsInput(v *ListFleetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BuildId != nil {
		ok := object.Key("BuildId")
		ok.String(*v.BuildId)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ScriptId != nil {
		ok := object.Key("ScriptId")
		ok.String(*v.ScriptId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListGameServerGroupsInput(v *ListGameServerGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListGameServersInput(v *ListGameServersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListScriptsInput(v *ListScriptsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutScalingPolicyInput(v *PutScalingPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ComparisonOperator) > 0 {
		ok := object.Key("ComparisonOperator")
		ok.String(string(v.ComparisonOperator))
	}

	if v.EvaluationPeriods != nil {
		ok := object.Key("EvaluationPeriods")
		ok.Integer(*v.EvaluationPeriods)
	}

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if len(v.MetricName) > 0 {
		ok := object.Key("MetricName")
		ok.String(string(v.MetricName))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.PolicyType) > 0 {
		ok := object.Key("PolicyType")
		ok.String(string(v.PolicyType))
	}

	if v.ScalingAdjustment != 0 {
		ok := object.Key("ScalingAdjustment")
		ok.Integer(v.ScalingAdjustment)
	}

	if len(v.ScalingAdjustmentType) > 0 {
		ok := object.Key("ScalingAdjustmentType")
		ok.String(string(v.ScalingAdjustmentType))
	}

	if v.TargetConfiguration != nil {
		ok := object.Key("TargetConfiguration")
		if err := awsAwsjson11_serializeDocumentTargetConfiguration(v.TargetConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Threshold != 0 {
		ok := object.Key("Threshold")
		switch {
		case math.IsNaN(v.Threshold):
			ok.String("NaN")

		case math.IsInf(v.Threshold, 1):
			ok.String("Infinity")

		case math.IsInf(v.Threshold, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Threshold)

		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRegisterGameServerInput(v *RegisterGameServerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionInfo != nil {
		ok := object.Key("ConnectionInfo")
		ok.String(*v.ConnectionInfo)
	}

	if v.GameServerData != nil {
		ok := object.Key("GameServerData")
		ok.String(*v.GameServerData)
	}

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	if v.GameServerId != nil {
		ok := object.Key("GameServerId")
		ok.String(*v.GameServerId)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRequestUploadCredentialsInput(v *RequestUploadCredentialsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BuildId != nil {
		ok := object.Key("BuildId")
		ok.String(*v.BuildId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentResolveAliasInput(v *ResolveAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasId != nil {
		ok := object.Key("AliasId")
		ok.String(*v.AliasId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentResumeGameServerGroupInput(v *ResumeGameServerGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	if v.ResumeActions != nil {
		ok := object.Key("ResumeActions")
		if err := awsAwsjson11_serializeDocumentGameServerGroupActions(v.ResumeActions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSearchGameSessionsInput(v *SearchGameSessionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasId != nil {
		ok := object.Key("AliasId")
		ok.String(*v.AliasId)
	}

	if v.FilterExpression != nil {
		ok := object.Key("FilterExpression")
		ok.String(*v.FilterExpression)
	}

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.SortExpression != nil {
		ok := object.Key("SortExpression")
		ok.String(*v.SortExpression)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartFleetActionsInput(v *StartFleetActionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsAwsjson11_serializeDocumentFleetActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartGameSessionPlacementInput(v *StartGameSessionPlacementInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DesiredPlayerSessions != nil {
		ok := object.Key("DesiredPlayerSessions")
		if err := awsAwsjson11_serializeDocumentDesiredPlayerSessionList(v.DesiredPlayerSessions, ok); err != nil {
			return err
		}
	}

	if v.GameProperties != nil {
		ok := object.Key("GameProperties")
		if err := awsAwsjson11_serializeDocumentGamePropertyList(v.GameProperties, ok); err != nil {
			return err
		}
	}

	if v.GameSessionData != nil {
		ok := object.Key("GameSessionData")
		ok.String(*v.GameSessionData)
	}

	if v.GameSessionName != nil {
		ok := object.Key("GameSessionName")
		ok.String(*v.GameSessionName)
	}

	if v.GameSessionQueueName != nil {
		ok := object.Key("GameSessionQueueName")
		ok.String(*v.GameSessionQueueName)
	}

	if v.MaximumPlayerSessionCount != nil {
		ok := object.Key("MaximumPlayerSessionCount")
		ok.Integer(*v.MaximumPlayerSessionCount)
	}

	if v.PlacementId != nil {
		ok := object.Key("PlacementId")
		ok.String(*v.PlacementId)
	}

	if v.PlayerLatencies != nil {
		ok := object.Key("PlayerLatencies")
		if err := awsAwsjson11_serializeDocumentPlayerLatencyList(v.PlayerLatencies, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartMatchBackfillInput(v *StartMatchBackfillInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationName != nil {
		ok := object.Key("ConfigurationName")
		ok.String(*v.ConfigurationName)
	}

	if v.GameSessionArn != nil {
		ok := object.Key("GameSessionArn")
		ok.String(*v.GameSessionArn)
	}

	if v.Players != nil {
		ok := object.Key("Players")
		if err := awsAwsjson11_serializeDocumentPlayerList(v.Players, ok); err != nil {
			return err
		}
	}

	if v.TicketId != nil {
		ok := object.Key("TicketId")
		ok.String(*v.TicketId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartMatchmakingInput(v *StartMatchmakingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationName != nil {
		ok := object.Key("ConfigurationName")
		ok.String(*v.ConfigurationName)
	}

	if v.Players != nil {
		ok := object.Key("Players")
		if err := awsAwsjson11_serializeDocumentPlayerList(v.Players, ok); err != nil {
			return err
		}
	}

	if v.TicketId != nil {
		ok := object.Key("TicketId")
		ok.String(*v.TicketId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopFleetActionsInput(v *StopFleetActionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsAwsjson11_serializeDocumentFleetActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopGameSessionPlacementInput(v *StopGameSessionPlacementInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PlacementId != nil {
		ok := object.Key("PlacementId")
		ok.String(*v.PlacementId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopMatchmakingInput(v *StopMatchmakingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TicketId != nil {
		ok := object.Key("TicketId")
		ok.String(*v.TicketId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSuspendGameServerGroupInput(v *SuspendGameServerGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	if v.SuspendActions != nil {
		ok := object.Key("SuspendActions")
		if err := awsAwsjson11_serializeDocumentGameServerGroupActions(v.SuspendActions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson11_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateAliasInput(v *UpdateAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasId != nil {
		ok := object.Key("AliasId")
		ok.String(*v.AliasId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RoutingStrategy != nil {
		ok := object.Key("RoutingStrategy")
		if err := awsAwsjson11_serializeDocumentRoutingStrategy(v.RoutingStrategy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateBuildInput(v *UpdateBuildInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BuildId != nil {
		ok := object.Key("BuildId")
		ok.String(*v.BuildId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateFleetAttributesInput(v *UpdateFleetAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.MetricGroups != nil {
		ok := object.Key("MetricGroups")
		if err := awsAwsjson11_serializeDocumentMetricGroupList(v.MetricGroups, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.NewGameSessionProtectionPolicy) > 0 {
		ok := object.Key("NewGameSessionProtectionPolicy")
		ok.String(string(v.NewGameSessionProtectionPolicy))
	}

	if v.ResourceCreationLimitPolicy != nil {
		ok := object.Key("ResourceCreationLimitPolicy")
		if err := awsAwsjson11_serializeDocumentResourceCreationLimitPolicy(v.ResourceCreationLimitPolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateFleetCapacityInput(v *UpdateFleetCapacityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DesiredInstances != nil {
		ok := object.Key("DesiredInstances")
		ok.Integer(*v.DesiredInstances)
	}

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.Location != nil {
		ok := object.Key("Location")
		ok.String(*v.Location)
	}

	if v.MaxSize != nil {
		ok := object.Key("MaxSize")
		ok.Integer(*v.MaxSize)
	}

	if v.MinSize != nil {
		ok := object.Key("MinSize")
		ok.Integer(*v.MinSize)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateFleetPortSettingsInput(v *UpdateFleetPortSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.InboundPermissionAuthorizations != nil {
		ok := object.Key("InboundPermissionAuthorizations")
		if err := awsAwsjson11_serializeDocumentIpPermissionsList(v.InboundPermissionAuthorizations, ok); err != nil {
			return err
		}
	}

	if v.InboundPermissionRevocations != nil {
		ok := object.Key("InboundPermissionRevocations")
		if err := awsAwsjson11_serializeDocumentIpPermissionsList(v.InboundPermissionRevocations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateGameServerGroupInput(v *UpdateGameServerGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BalancingStrategy) > 0 {
		ok := object.Key("BalancingStrategy")
		ok.String(string(v.BalancingStrategy))
	}

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	if len(v.GameServerProtectionPolicy) > 0 {
		ok := object.Key("GameServerProtectionPolicy")
		ok.String(string(v.GameServerProtectionPolicy))
	}

	if v.InstanceDefinitions != nil {
		ok := object.Key("InstanceDefinitions")
		if err := awsAwsjson11_serializeDocumentInstanceDefinitions(v.InstanceDefinitions, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateGameServerInput(v *UpdateGameServerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameServerData != nil {
		ok := object.Key("GameServerData")
		ok.String(*v.GameServerData)
	}

	if v.GameServerGroupName != nil {
		ok := object.Key("GameServerGroupName")
		ok.String(*v.GameServerGroupName)
	}

	if v.GameServerId != nil {
		ok := object.Key("GameServerId")
		ok.String(*v.GameServerId)
	}

	if len(v.HealthCheck) > 0 {
		ok := object.Key("HealthCheck")
		ok.String(string(v.HealthCheck))
	}

	if len(v.UtilizationStatus) > 0 {
		ok := object.Key("UtilizationStatus")
		ok.String(string(v.UtilizationStatus))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateGameSessionInput(v *UpdateGameSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GameSessionId != nil {
		ok := object.Key("GameSessionId")
		ok.String(*v.GameSessionId)
	}

	if v.MaximumPlayerSessionCount != nil {
		ok := object.Key("MaximumPlayerSessionCount")
		ok.Integer(*v.MaximumPlayerSessionCount)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.PlayerSessionCreationPolicy) > 0 {
		ok := object.Key("PlayerSessionCreationPolicy")
		ok.String(string(v.PlayerSessionCreationPolicy))
	}

	if len(v.ProtectionPolicy) > 0 {
		ok := object.Key("ProtectionPolicy")
		ok.String(string(v.ProtectionPolicy))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateGameSessionQueueInput(v *UpdateGameSessionQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomEventData != nil {
		ok := object.Key("CustomEventData")
		ok.String(*v.CustomEventData)
	}

	if v.Destinations != nil {
		ok := object.Key("Destinations")
		if err := awsAwsjson11_serializeDocumentGameSessionQueueDestinationList(v.Destinations, ok); err != nil {
			return err
		}
	}

	if v.FilterConfiguration != nil {
		ok := object.Key("FilterConfiguration")
		if err := awsAwsjson11_serializeDocumentFilterConfiguration(v.FilterConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NotificationTarget != nil {
		ok := object.Key("NotificationTarget")
		ok.String(*v.NotificationTarget)
	}

	if v.PlayerLatencyPolicies != nil {
		ok := object.Key("PlayerLatencyPolicies")
		if err := awsAwsjson11_serializeDocumentPlayerLatencyPolicyList(v.PlayerLatencyPolicies, ok); err != nil {
			return err
		}
	}

	if v.PriorityConfiguration != nil {
		ok := object.Key("PriorityConfiguration")
		if err := awsAwsjson11_serializeDocumentPriorityConfiguration(v.PriorityConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TimeoutInSeconds != nil {
		ok := object.Key("TimeoutInSeconds")
		ok.Integer(*v.TimeoutInSeconds)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateMatchmakingConfigurationInput(v *UpdateMatchmakingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AcceptanceRequired != nil {
		ok := object.Key("AcceptanceRequired")
		ok.Boolean(*v.AcceptanceRequired)
	}

	if v.AcceptanceTimeoutSeconds != nil {
		ok := object.Key("AcceptanceTimeoutSeconds")
		ok.Integer(*v.AcceptanceTimeoutSeconds)
	}

	if v.AdditionalPlayerCount != nil {
		ok := object.Key("AdditionalPlayerCount")
		ok.Integer(*v.AdditionalPlayerCount)
	}

	if len(v.BackfillMode) > 0 {
		ok := object.Key("BackfillMode")
		ok.String(string(v.BackfillMode))
	}

	if v.CustomEventData != nil {
		ok := object.Key("CustomEventData")
		ok.String(*v.CustomEventData)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.FlexMatchMode) > 0 {
		ok := object.Key("FlexMatchMode")
		ok.String(string(v.FlexMatchMode))
	}

	if v.GameProperties != nil {
		ok := object.Key("GameProperties")
		if err := awsAwsjson11_serializeDocumentGamePropertyList(v.GameProperties, ok); err != nil {
			return err
		}
	}

	if v.GameSessionData != nil {
		ok := object.Key("GameSessionData")
		ok.String(*v.GameSessionData)
	}

	if v.GameSessionQueueArns != nil {
		ok := object.Key("GameSessionQueueArns")
		if err := awsAwsjson11_serializeDocumentQueueArnsList(v.GameSessionQueueArns, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NotificationTarget != nil {
		ok := object.Key("NotificationTarget")
		ok.String(*v.NotificationTarget)
	}

	if v.RequestTimeoutSeconds != nil {
		ok := object.Key("RequestTimeoutSeconds")
		ok.Integer(*v.RequestTimeoutSeconds)
	}

	if v.RuleSetName != nil {
		ok := object.Key("RuleSetName")
		ok.String(*v.RuleSetName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateRuntimeConfigurationInput(v *UpdateRuntimeConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("FleetId")
		ok.String(*v.FleetId)
	}

	if v.RuntimeConfiguration != nil {
		ok := object.Key("RuntimeConfiguration")
		if err := awsAwsjson11_serializeDocumentRuntimeConfiguration(v.RuntimeConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateScriptInput(v *UpdateScriptInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ScriptId != nil {
		ok := object.Key("ScriptId")
		ok.String(*v.ScriptId)
	}

	if v.StorageLocation != nil {
		ok := object.Key("StorageLocation")
		if err := awsAwsjson11_serializeDocumentS3Location(v.StorageLocation, ok); err != nil {
			return err
		}
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	if v.ZipFile != nil {
		ok := object.Key("ZipFile")
		ok.Base64EncodeBytes(v.ZipFile)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentValidateMatchmakingRuleSetInput(v *ValidateMatchmakingRuleSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RuleSetBody != nil {
		ok := object.Key("RuleSetBody")
		ok.String(*v.RuleSetBody)
	}

	return nil
}
