// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The Microsoft AD attributes of the Amazon FSx for Windows File Server file
// system.
type ActiveDirectoryBackupAttributes struct {

	// The ID of the AWS Managed Microsoft Active Directory instance to which the file
	// system is joined.
	ActiveDirectoryId *string

	// The fully qualified domain name of the self-managed AD directory.
	DomainName *string

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify AWS
	// resources. We require an ARN when you need to specify a resource unambiguously
	// across all of AWS. For more information, see Amazon Resource Names (ARNs) and
	// AWS Service Namespaces
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the AWS General Reference.
	ResourceARN *string

	noSmithyDocumentSerde
}

// Describes a specific Amazon FSx administrative action for the current Windows or
// Lustre file system.
type AdministrativeAction struct {

	// Describes the type of administrative action, as follows:
	//
	// * FILE_SYSTEM_UPDATE -
	// A file system update administrative action initiated by the user from the Amazon
	// FSx console, API (UpdateFileSystem), or CLI (update-file-system).
	//
	// *
	// STORAGE_OPTIMIZATION - Once the FILE_SYSTEM_UPDATE task to increase a file
	// system's storage capacity completes successfully, a STORAGE_OPTIMIZATION task
	// starts.
	//
	// * For Windows, storage optimization is the process of migrating the
	// file system data to the new, larger disks.
	//
	// * For Lustre, storage optimization
	// consists of rebalancing the data across the existing and newly added file
	// servers.
	//
	// You can track the storage optimization progress using the
	// ProgressPercent property. When STORAGE_OPTIMIZATION completes successfully, the
	// parent FILE_SYSTEM_UPDATE action status changes to COMPLETED. For more
	// information, see Managing storage capacity
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html)
	// in the Amazon FSx for Windows File Server User Guide and Managing storage and
	// throughput capacity
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html)
	// in the Amazon FSx for Lustre User Guide.
	//
	// * FILE_SYSTEM_ALIAS_ASSOCIATION - A
	// file system update to associate a new DNS alias with the file system. For more
	// information, see .
	//
	// * FILE_SYSTEM_ALIAS_DISASSOCIATION - A file system update to
	// disassociate a DNS alias from the file system. For more information, see .
	AdministrativeActionType AdministrativeActionType

	// Provides information about a failed administrative action.
	FailureDetails *AdministrativeActionFailureDetails

	// Provides the percent complete of a STORAGE_OPTIMIZATION administrative action.
	// Does not apply to any other administrative action type.
	ProgressPercent *int32

	// Time that the administrative action request was received.
	RequestTime *time.Time

	// Describes the status of the administrative action, as follows:
	//
	// * FAILED -
	// Amazon FSx failed to process the administrative action successfully.
	//
	// *
	// IN_PROGRESS - Amazon FSx is processing the administrative action.
	//
	// * PENDING -
	// Amazon FSx is waiting to process the administrative action.
	//
	// * COMPLETED -
	// Amazon FSx has finished processing the administrative task.
	//
	// *
	// UPDATED_OPTIMIZING - For a storage capacity increase update, Amazon FSx has
	// updated the file system with the new storage capacity, and is now performing the
	// storage optimization process. For more information, see Managing storage
	// capacity
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html)
	// in the Amazon FSx for Windows File Server User Guide and Managing storage and
	// throughput capacity
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html)
	// in the Amazon FSx for Lustre User Guide.
	Status Status

	// Describes the target value for the administration action, provided in the
	// UpdateFileSystem operation. Returned for FILE_SYSTEM_UPDATE administrative
	// actions.
	TargetFileSystemValues *FileSystem

	noSmithyDocumentSerde
}

// Provides information about a failed administrative action.
type AdministrativeActionFailureDetails struct {

	// Error message providing details about the failed administrative action.
	Message *string

	noSmithyDocumentSerde
}

// A DNS alias that is associated with the file system. You can use a DNS alias to
// access a file system using user-defined DNS names, in addition to the default
// DNS name that Amazon FSx assigns to the file system. For more information, see
// DNS aliases
// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
// in the FSx for Windows File Server User Guide.
type Alias struct {

	// Describes the state of the DNS alias.
	//
	// * AVAILABLE - The DNS alias is associated
	// with an Amazon FSx file system.
	//
	// * CREATING - Amazon FSx is creating the DNS
	// alias and associating it with the file system.
	//
	// * CREATE_FAILED - Amazon FSx was
	// unable to associate the DNS alias with the file system.
	//
	// * DELETING - Amazon FSx
	// is disassociating the DNS alias from the file system and deleting it.
	//
	// *
	// DELETE_FAILED - Amazon FSx was unable to disassocate the DNS alias from the file
	// system.
	Lifecycle AliasLifecycle

	// The name of the DNS alias. The alias name has to meet the following
	// requirements:
	//
	// * Formatted as a fully-qualified domain name (FQDN),
	// hostname.domain, for example, accounting.example.com.
	//
	// * Can contain
	// alphanumeric characters, the underscore (_), and the hyphen (-).
	//
	// * Cannot start
	// or end with a hyphen.
	//
	// * Can start with a numeric.
	//
	// For DNS names, Amazon FSx
	// stores alphabetic characters as lowercase letters (a-z), regardless of how you
	// specify them: as uppercase letters, lowercase letters, or the corresponding
	// letters in escape codes.
	Name *string

	noSmithyDocumentSerde
}

// A backup of an Amazon FSx file system.
type Backup struct {

	// The ID of the backup.
	//
	// This member is required.
	BackupId *string

	// The time when a particular backup was created.
	//
	// This member is required.
	CreationTime *time.Time

	// Metadata of the file system associated with the backup. This metadata is
	// persisted even if the file system is deleted.
	//
	// This member is required.
	FileSystem *FileSystem

	// The lifecycle status of the backup.
	//
	// * AVAILABLE - The backup is fully
	// available.
	//
	// * PENDING - For user-initiated backups on Lustre file systems only;
	// Amazon FSx has not started creating the backup.
	//
	// * CREATING - Amazon FSx is
	// creating the backup.
	//
	// * TRANSFERRING - For user-initiated backups on Lustre file
	// systems only; Amazon FSx is transferring the backup to S3.
	//
	// * COPYING - Amazon
	// FSx is copying the backup.
	//
	// * DELETED - Amazon FSx deleted the backup and it is
	// no longer available.
	//
	// * FAILED - Amazon FSx could not complete the backup.
	//
	// This member is required.
	Lifecycle BackupLifecycle

	// The type of the file system backup.
	//
	// This member is required.
	Type BackupType

	// The configuration of the self-managed Microsoft Active Directory (AD) to which
	// the Windows File Server instance is joined.
	DirectoryInformation *ActiveDirectoryBackupAttributes

	// Details explaining any failures that occur when creating a backup.
	FailureDetails *BackupFailureDetails

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the
	// backup of the Amazon FSx file system's data at rest.
	KmsKeyId *string

	// An AWS account ID. This ID is a 12-digit number that you use to construct Amazon
	// Resource Names (ARNs) for resources.
	OwnerId *string

	// The current percent of progress of an asynchronous task.
	ProgressPercent *int32

	// The Amazon Resource Name (ARN) for the backup resource.
	ResourceARN *string

	// The ID of the source backup. Specifies the backup you are copying.
	SourceBackupId *string

	// The source Region of the backup. Specifies the Region from where this backup is
	// copied.
	SourceBackupRegion *string

	// Tags associated with a particular file system.
	Tags []Tag

	noSmithyDocumentSerde
}

// If backup creation fails, this structure contains the details of that failure.
type BackupFailureDetails struct {

	// A message describing the backup creation failure.
	Message *string

	noSmithyDocumentSerde
}

// Provides a report detailing the data repository task results of the files
// processed that match the criteria specified in the report Scope parameter. FSx
// delivers the report to the file system's linked data repository in Amazon S3,
// using the path specified in the report Path parameter. You can specify whether
// or not a report gets generated for a task using the Enabled parameter.
type CompletionReport struct {

	// Set Enabled to True to generate a CompletionReport when the task completes. If
	// set to true, then you need to provide a report Scope, Path, and Format. Set
	// Enabled to False if you do not want a CompletionReport generated when the task
	// completes.
	//
	// This member is required.
	Enabled *bool

	// Required if Enabled is set to true. Specifies the format of the
	// CompletionReport. REPORT_CSV_20191124 is the only format currently supported.
	// When Format is set to REPORT_CSV_20191124, the CompletionReport is provided in
	// CSV format, and is delivered to {path}/task-{id}/failures.csv.
	Format ReportFormat

	// Required if Enabled is set to true. Specifies the location of the report on the
	// file system's linked S3 data repository. An absolute path that defines where the
	// completion report will be stored in the destination location. The Path you
	// provide must be located within the file system’s ExportPath. An example Path
	// value is "s3://myBucket/myExportPath/optionalPrefix". The report provides the
	// following information for each file in the report: FilePath, FileStatus, and
	// ErrorCode. To learn more about a file system's ExportPath, see .
	Path *string

	// Required if Enabled is set to true. Specifies the scope of the CompletionReport;
	// FAILED_FILES_ONLY is the only scope currently supported. When Scope is set to
	// FAILED_FILES_ONLY, the CompletionReport only contains information about files
	// that the data repository task failed to process.
	Scope ReportScope

	noSmithyDocumentSerde
}

// The Lustre configuration for the file system being created.
type CreateFileSystemLustreConfiguration struct {

	// (Optional) When you create your file system, your existing S3 objects appear as
	// file and directory listings. Use this property to choose how Amazon FSx keeps
	// your file and directory listings up to date as you add or modify objects in your
	// linked S3 bucket. AutoImportPolicy can have the following values:
	//
	// * NONE -
	// (Default) AutoImport is off. Amazon FSx only updates file and directory listings
	// from the linked S3 bucket when the file system is created. FSx does not update
	// file and directory listings for any new or changed objects after choosing this
	// option.
	//
	// * NEW - AutoImport is on. Amazon FSx automatically imports directory
	// listings of any new objects added to the linked S3 bucket that do not currently
	// exist in the FSx file system.
	//
	// * NEW_CHANGED - AutoImport is on. Amazon FSx
	// automatically imports file and directory listings of any new objects added to
	// the S3 bucket and any existing objects that are changed in the S3 bucket after
	// you choose this option.
	//
	// For more information, see Automatically import updates
	// from your S3 bucket
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html).
	AutoImportPolicy AutoImportPolicyType

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 90 days.
	// The default is 0.
	AutomaticBackupRetentionDays *int32

	// (Optional) Not available to use with file systems that are linked to a data
	// repository. A boolean flag indicating whether tags for the file system should be
	// copied to backups. The default value is false. If it's set to true, all file
	// system tags are copied to all automatic and user-initiated backups when the user
	// doesn't specify any backup-specific tags. If this value is true, and you specify
	// one or more backup tags, only the specified tags are copied to backups. If you
	// specify one or more tags when creating a user-initiated backup, no tags are
	// copied from the file system, regardless of this value. For more information, see
	// Working with backups
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html).
	CopyTagsToBackups *bool

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// Sets the data compression configuration for the file system. DataCompressionType
	// can have the following values:
	//
	// * NONE - (Default) Data compression is turned
	// off when the file system is created.
	//
	// * LZ4 - Data compression is turned on with
	// the LZ4 algorithm.
	//
	// For more information, see Lustre data compression
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).
	DataCompressionType DataCompressionType

	// Choose SCRATCH_1 and SCRATCH_2 deployment types when you need temporary storage
	// and shorter-term processing of data. The SCRATCH_2 deployment type provides
	// in-transit encryption of data and higher burst throughput capacity than
	// SCRATCH_1. Choose PERSISTENT_1 deployment type for longer-term storage and
	// workloads and encryption of data in transit. To learn more about deployment
	// types, see  FSx for Lustre Deployment Options
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html).
	// Encryption of data in-transit is automatically enabled when you access a
	// SCRATCH_2 or PERSISTENT_1 file system from Amazon EC2 instances that support
	// this feature (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data-
	// protection.html). (Default = SCRATCH_1) Encryption of data in-transit for
	// SCRATCH_2 and PERSISTENT_1 deployment types is supported when accessed from
	// supported instance types in supported AWS Regions. To learn more, Encrypting
	// Data in Transit
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html).
	DeploymentType LustreDeploymentType

	// The type of drive cache used by PERSISTENT_1 file systems that are provisioned
	// with HDD storage devices. This parameter is required when storage type is HDD.
	// Set to READ, improve the performance for frequently accessed files and allows
	// 20% of the total storage capacity of the file system to be cached. This
	// parameter is required when StorageType is set to HDD.
	DriveCacheType DriveCacheType

	// (Optional) The path in Amazon S3 where the root of your Amazon FSx file system
	// is exported. The path must use the same Amazon S3 bucket as specified in
	// ImportPath. You can provide an optional prefix to which new and changed data is
	// to be exported from your Amazon FSx for Lustre file system. If an ExportPath
	// value is not provided, Amazon FSx sets a default export path,
	// s3://import-bucket/FSxLustre[creation-timestamp]. The timestamp is in UTC
	// format, for example s3://import-bucket/FSxLustre20181105T222312Z. The Amazon S3
	// export bucket must be the same as the import bucket specified by ImportPath. If
	// you only specify a bucket name, such as s3://import-bucket, you get a 1:1
	// mapping of file system objects to S3 bucket objects. This mapping means that the
	// input data in S3 is overwritten on export. If you provide a custom prefix in the
	// export path, such as s3://import-bucket/[custom-optional-prefix], Amazon FSx
	// exports the contents of your file system to that export prefix in the Amazon S3
	// bucket.
	ExportPath *string

	// (Optional) The path to the Amazon S3 bucket (including the optional prefix) that
	// you're using as the data repository for your Amazon FSx for Lustre file system.
	// The root of your FSx for Lustre file system will be mapped to the root of the
	// Amazon S3 bucket you select. An example is s3://import-bucket/optional-prefix.
	// If you specify a prefix after the Amazon S3 bucket name, only object keys with
	// that prefix are loaded into the file system.
	ImportPath *string

	// (Optional) For files imported from a data repository, this value determines the
	// stripe count and maximum amount of data per file (in MiB) stored on a single
	// physical disk. The maximum number of disks that a single file can be striped
	// across is limited by the total number of disks that make up the file system. The
	// default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500
	// GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int32

	// Required for the PERSISTENT_1 deployment type, describes the amount of read and
	// write throughput for each 1 tebibyte of storage, in MB/s/TiB. File system
	// throughput capacity is calculated by multiplying ﬁle system storage capacity
	// (TiB) by the PerUnitStorageThroughput (MB/s/TiB). For a 2.4 TiB ﬁle system,
	// provisioning 50 MB/s/TiB of PerUnitStorageThroughput yields 120 MB/s of ﬁle
	// system throughput. You pay for the amount of throughput that you provision.
	// Valid values for SSD storage: 50, 100, 200. Valid values for HDD storage: 12,
	// 40.
	PerUnitStorageThroughput *int32

	// (Optional) The preferred start time to perform weekly maintenance, formatted
	// d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7,
	// beginning with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration object for the Microsoft Windows file system used in
// CreateFileSystem and CreateFileSystemFromBackup operations.
type CreateFileSystemWindowsConfiguration struct {

	// The throughput of an Amazon FSx file system, measured in megabytes per second,
	// in 2 to the nth increments, between 2^3 (8) and 2^11 (2048).
	//
	// This member is required.
	ThroughputCapacity *int32

	// The ID for an existing AWS Managed Microsoft Active Directory (AD) instance that
	// the file system should join when it's created.
	ActiveDirectoryId *string

	// An array of one or more DNS alias names that you want to associate with the
	// Amazon FSx file system. Aliases allow you to use existing DNS names to access
	// the data in your Amazon FSx file system. You can associate up to 50 aliases with
	// a file system at any time. You can associate additional DNS aliases after you
	// create the file system using the AssociateFileSystemAliases operation. You can
	// remove DNS aliases from the file system after it is created using the
	// DisassociateFileSystemAliases operation. You only need to specify the alias name
	// in the request payload. For more information, see Working with DNS Aliases
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
	// and Walkthrough 5: Using DNS aliases to access your file system
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html),
	// including additional steps you must take to be able to access your file system
	// using a DNS alias. An alias name has to meet the following requirements:
	//
	// *
	// Formatted as a fully-qualified domain name (FQDN), hostname.domain, for example,
	// accounting.example.com.
	//
	// * Can contain alphanumeric characters, the underscore
	// (_), and the hyphen (-).
	//
	// * Cannot start or end with a hyphen.
	//
	// * Can start with
	// a numeric.
	//
	// For DNS alias names, Amazon FSx stores alphabetic characters as
	// lowercase letters (a-z), regardless of how you specify them: as uppercase
	// letters, lowercase letters, or the corresponding letters in escape codes.
	Aliases []string

	// The configuration that Amazon FSx for Windows File Server uses to audit and log
	// user accesses of files, folders, and file shares on the Amazon FSx for Windows
	// File Server file system.
	AuditLogConfiguration *WindowsAuditLogCreateConfiguration

	// The number of days to retain automatic backups. The default is to retain backups
	// for 7 days. Setting this value to 0 disables the creation of automatic backups.
	// The maximum retention period for backups is 90 days.
	AutomaticBackupRetentionDays *int32

	// A boolean flag indicating whether tags for the file system should be copied to
	// backups. This value defaults to false. If it's set to true, all tags for the
	// file system are copied to all automatic and user-initiated backups where the
	// user doesn't specify tags. If this value is true, and you specify one or more
	// tags, only the specified tags are copied to backups. If you specify one or more
	// tags when creating a user-initiated backup, no tags are copied from the file
	// system, regardless of this value.
	CopyTagsToBackups *bool

	// The preferred time to take daily automatic backups, formatted HH:MM in the UTC
	// time zone.
	DailyAutomaticBackupStartTime *string

	// Specifies the file system deployment type, valid values are the following:
	//
	// *
	// MULTI_AZ_1 - Deploys a high availability file system that is configured for
	// Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability.
	// You can only deploy a Multi-AZ file system in AWS Regions that have a minimum of
	// three Availability Zones. Also supports HDD storage type
	//
	// * SINGLE_AZ_1 -
	// (Default) Choose to deploy a file system that is configured for single AZ
	// redundancy.
	//
	// * SINGLE_AZ_2 - The latest generation Single AZ file system.
	// Specifies a file system that is configured for single AZ redundancy and supports
	// HDD storage type.
	//
	// For more information, see  Availability and Durability:
	// Single-AZ and Multi-AZ File Systems
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
	DeploymentType WindowsDeploymentType

	// Required when DeploymentType is set to MULTI_AZ_1. This specifies the subnet in
	// which you want the preferred file server to be located. For in-AWS applications,
	// we recommend that you launch your clients in the same Availability Zone (AZ) as
	// your preferred file server to reduce cross-AZ data transfer costs and minimize
	// latency.
	PreferredSubnetId *string

	// The configuration that Amazon FSx uses to join the Windows File Server instance
	// to your self-managed (including on-premises) Microsoft Active Directory (AD)
	// directory. For more information, see  Using Amazon FSx with your self-managed
	// Microsoft Active Directory
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html).
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfiguration

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in the
	// UTC time zone, where d is the weekday number, from 1 through 7, beginning with
	// Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The data repository configuration object for Lustre file systems returned in the
// response of the CreateFileSystem operation.
type DataRepositoryConfiguration struct {

	// Describes the file system's linked S3 data repository's AutoImportPolicy. The
	// AutoImportPolicy configures how Amazon FSx keeps your file and directory
	// listings up to date as you add or modify objects in your linked S3 bucket.
	// AutoImportPolicy can have the following values:
	//
	// * NONE - (Default) AutoImport
	// is off. Amazon FSx only updates file and directory listings from the linked S3
	// bucket when the file system is created. FSx does not update file and directory
	// listings for any new or changed objects after choosing this option.
	//
	// * NEW -
	// AutoImport is on. Amazon FSx automatically imports directory listings of any new
	// objects added to the linked S3 bucket that do not currently exist in the FSx
	// file system.
	//
	// * NEW_CHANGED - AutoImport is on. Amazon FSx automatically imports
	// file and directory listings of any new objects added to the S3 bucket and any
	// existing objects that are changed in the S3 bucket after you choose this
	// option.
	//
	// For more information, see Automatically import updates from your S3
	// bucket
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html).
	AutoImportPolicy AutoImportPolicyType

	// The export path to the Amazon S3 bucket (and prefix) that you are using to store
	// new and changed Lustre file system files in S3.
	ExportPath *string

	// Provides detailed information about the data respository if its Lifecycle is set
	// to MISCONFIGURED.
	FailureDetails *DataRepositoryFailureDetails

	// The import path to the Amazon S3 bucket (and optional prefix) that you're using
	// as the data repository for your FSx for Lustre file system, for example
	// s3://import-bucket/optional-prefix. If a prefix is specified after the Amazon S3
	// bucket name, only object keys with that prefix are loaded into the file system.
	ImportPath *string

	// For files imported from a data repository, this value determines the stripe
	// count and maximum amount of data per file (in MiB) stored on a single physical
	// disk. The maximum number of disks that a single file can be striped across is
	// limited by the total number of disks that make up the file system. The default
	// chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB).
	// Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int32

	// Describes the state of the file system's S3 durable data repository, if it is
	// configured with an S3 repository. The lifecycle can have the following
	// values:
	//
	// * CREATING - The data repository configuration between the FSx file
	// system and the linked S3 data repository is being created. The data repository
	// is unavailable.
	//
	// * AVAILABLE - The data repository is available for use.
	//
	// *
	// MISCONFIGURED - Amazon FSx cannot automatically import updates from the S3
	// bucket until the data repository configuration is corrected. For more
	// information, see Troubleshooting a Misconfigured linked S3 bucket
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/troubleshooting.html#troubleshooting-misconfigured-data-repository).
	//
	// *
	// UPDATING - The data repository is undergoing a customer initiated update and
	// availability may be impacted.
	Lifecycle DataRepositoryLifecycle

	noSmithyDocumentSerde
}

// Provides detailed information about the data respository if its Lifecycle is set
// to MISCONFIGURED.
type DataRepositoryFailureDetails struct {

	// A detailed error message.
	Message *string

	noSmithyDocumentSerde
}

// A description of the data repository task. You use data repository tasks to
// perform bulk transfer operations between your Amazon FSx file system and its
// linked data repository.
type DataRepositoryTask struct {

	// The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	//
	// This member is required.
	CreationTime *time.Time

	// The globally unique ID of the file system, assigned by Amazon FSx.
	//
	// This member is required.
	FileSystemId *string

	// The lifecycle status of the data repository task, as follows:
	//
	// * PENDING -
	// Amazon FSx has not started the task.
	//
	// * EXECUTING - Amazon FSx is processing the
	// task.
	//
	// * FAILED - Amazon FSx was not able to complete the task. For example,
	// there may be files the task failed to process. The
	// DataRepositoryTaskFailureDetails property provides more information about task
	// failures.
	//
	// * SUCCEEDED - FSx completed the task successfully.
	//
	// * CANCELED -
	// Amazon FSx canceled the task and it did not complete.
	//
	// * CANCELING - FSx is in
	// process of canceling the task.
	//
	// You cannot delete an FSx for Lustre file system
	// if there are data repository tasks for the file system in the PENDING or
	// EXECUTING states. Please retry when the data repository task is finished (with a
	// status of CANCELED, SUCCEEDED, or FAILED). You can use the
	// DescribeDataRepositoryTask action to monitor the task status. Contact the FSx
	// team if you need to delete your file system immediately.
	//
	// This member is required.
	Lifecycle DataRepositoryTaskLifecycle

	// The system-generated, unique 17-digit ID of the data repository task.
	//
	// This member is required.
	TaskId *string

	// The type of data repository task; EXPORT_TO_REPOSITORY is the only type
	// currently supported.
	//
	// This member is required.
	Type DataRepositoryTaskType

	// The time that Amazon FSx completed processing the task, populated after the task
	// is complete.
	EndTime *time.Time

	// Failure message describing why the task failed, it is populated only when
	// Lifecycle is set to FAILED.
	FailureDetails *DataRepositoryTaskFailureDetails

	// An array of paths on the Amazon FSx for Lustre file system that specify the data
	// for the data repository task to process. For example, in an EXPORT_TO_REPOSITORY
	// task, the paths specify which data to export to the linked data repository.
	// (Default) If Paths is not specified, Amazon FSx uses the file system root
	// directory.
	Paths []string

	// Provides a report detailing the data repository task results of the files
	// processed that match the criteria specified in the report Scope parameter. FSx
	// delivers the report to the file system's linked data repository in Amazon S3,
	// using the path specified in the report Path parameter. You can specify whether
	// or not a report gets generated for a task using the Enabled parameter.
	Report *CompletionReport

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify AWS
	// resources. We require an ARN when you need to specify a resource unambiguously
	// across all of AWS. For more information, see Amazon Resource Names (ARNs) and
	// AWS Service Namespaces
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the AWS General Reference.
	ResourceARN *string

	// The time that Amazon FSx began processing the task.
	StartTime *time.Time

	// Provides the status of the number of files that the task has processed
	// successfully and failed to process.
	Status *DataRepositoryTaskStatus

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag

	noSmithyDocumentSerde
}

// Provides information about why a data repository task failed. Only populated
// when the task Lifecycle is set to FAILED.
type DataRepositoryTaskFailureDetails struct {

	// A detailed error message.
	Message *string

	noSmithyDocumentSerde
}

// (Optional) An array of filter objects you can use to filter the response of data
// repository tasks you will see in the the response. You can filter the tasks
// returned in the response by one or more file system IDs, task lifecycles, and by
// task type. A filter object consists of a filter Name, and one or more Values for
// the filter.
type DataRepositoryTaskFilter struct {

	// Name of the task property to use in filtering the tasks returned in the
	// response.
	//
	// * Use file-system-id to retrieve data repository tasks for specific
	// file systems.
	//
	// * Use task-lifecycle to retrieve data repository tasks with one
	// or more specific lifecycle states, as follows: CANCELED, EXECUTING, FAILED,
	// PENDING, and SUCCEEDED.
	Name DataRepositoryTaskFilterName

	// Use Values to include the specific file system IDs and task lifecycle states for
	// the filters you are using.
	Values []string

	noSmithyDocumentSerde
}

// Provides the task status showing a running total of the total number of files to
// be processed, the number successfully processed, and the number of files the
// task failed to process.
type DataRepositoryTaskStatus struct {

	// A running total of the number of files that the task failed to process.
	FailedCount *int64

	// The time at which the task status was last updated.
	LastUpdatedTime *time.Time

	// A running total of the number of files that the task has successfully processed.
	SucceededCount *int64

	// The total number of files that the task will process. While a task is executing,
	// the sum of SucceededCount plus FailedCount may not equal TotalCount. When the
	// task is complete, TotalCount equals the sum of SucceededCount plus FailedCount.
	TotalCount *int64

	noSmithyDocumentSerde
}

// The configuration object for the Amazon FSx for Lustre file system being deleted
// in the DeleteFileSystem operation.
type DeleteFileSystemLustreConfiguration struct {

	// Use if SkipFinalBackup is set to false, and you want to apply an array of tags
	// to the final backup. If you have set the file system property CopyTagsToBackups
	// to true, and you specify one or more FinalBackupTags when deleting a file
	// system, Amazon FSx will not copy any existing file system tags to the backup.
	FinalBackupTags []Tag

	// Set SkipFinalBackup to false if you want to take a final backup of the file
	// system you are deleting. By default, Amazon FSx will not take a final backup on
	// your behalf when the DeleteFileSystem operation is invoked. (Default = true)
	SkipFinalBackup *bool

	noSmithyDocumentSerde
}

// The response object for the Amazon FSx for Lustre file system being deleted in
// the DeleteFileSystem operation.
type DeleteFileSystemLustreResponse struct {

	// The ID of the final backup for this file system.
	FinalBackupId *string

	// The set of tags applied to the final backup.
	FinalBackupTags []Tag

	noSmithyDocumentSerde
}

// The configuration object for the Microsoft Windows file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemWindowsConfiguration struct {

	// A set of tags for your final backup.
	FinalBackupTags []Tag

	// By default, Amazon FSx for Windows takes a final backup on your behalf when the
	// DeleteFileSystem operation is invoked. Doing this helps protect you from data
	// loss, and we highly recommend taking the final backup. If you want to skip this
	// backup, use this flag to do so.
	SkipFinalBackup *bool

	noSmithyDocumentSerde
}

// The response object for the Microsoft Windows file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemWindowsResponse struct {

	// The ID of the final backup for this file system.
	FinalBackupId *string

	// The set of tags applied to the final backup.
	FinalBackupTags []Tag

	noSmithyDocumentSerde
}

// A description of a specific Amazon FSx file system.
type FileSystem struct {

	// A list of administrative actions for the file system that are in process or
	// waiting to be processed. Administrative actions describe changes to the Windows
	// file system that you have initiated using the UpdateFileSystem action.
	AdministrativeActions []AdministrativeAction

	// The time that the file system was created, in seconds (since
	// 1970-01-01T00:00:00Z), also known as Unix time.
	CreationTime *time.Time

	// The DNS name for the file system.
	DNSName *string

	// A structure providing details of any failures that occur when creating the file
	// system has failed.
	FailureDetails *FileSystemFailureDetails

	// The system-generated, unique 17-digit ID of the file system.
	FileSystemId *string

	// The type of Amazon FSx file system, either LUSTRE or WINDOWS.
	FileSystemType FileSystemType

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the file
	// system's data for Amazon FSx for Windows File Server file systems and persistent
	// Amazon FSx for Lustre file systems at rest. In either case, if not specified,
	// the Amazon FSx managed key is used. The scratch Amazon FSx for Lustre file
	// systems are always encrypted at rest using Amazon FSx managed keys. For more
	// information, see Encrypt
	// (https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html) in the
	// AWS Key Management Service API Reference.
	KmsKeyId *string

	// The lifecycle status of the file system, following are the possible values and
	// what they mean:
	//
	// * AVAILABLE - The file system is in a healthy state, and is
	// reachable and available for use.
	//
	// * CREATING - Amazon FSx is creating the new
	// file system.
	//
	// * DELETING - Amazon FSx is deleting an existing file system.
	//
	// *
	// FAILED - An existing file system has experienced an unrecoverable failure. When
	// creating a new file system, Amazon FSx was unable to create the file system.
	//
	// *
	// MISCONFIGURED indicates that the file system is in a failed but recoverable
	// state.
	//
	// * UPDATING indicates that the file system is undergoing a customer
	// initiated update.
	Lifecycle FileSystemLifecycle

	// The configuration for the Amazon FSx for Lustre file system.
	LustreConfiguration *LustreFileSystemConfiguration

	// The IDs of the elastic network interface from which a specific file system is
	// accessible. The elastic network interface is automatically created in the same
	// VPC that the Amazon FSx file system was created in. For more information, see
	// Elastic Network Interfaces
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html) in the
	// Amazon EC2 User Guide. For an Amazon FSx for Windows File Server file system,
	// you can have one network interface ID. For an Amazon FSx for Lustre file system,
	// you can have more than one.
	NetworkInterfaceIds []string

	// The AWS account that created the file system. If the file system was created by
	// an AWS Identity and Access Management (IAM) user, the AWS account to which the
	// IAM user belongs is the owner.
	OwnerId *string

	// The Amazon Resource Name (ARN) for the file system resource.
	ResourceARN *string

	// The storage capacity of the file system in gibibytes (GiB).
	StorageCapacity *int32

	// The storage type of the file system. Valid values are SSD and HDD. If set to
	// SSD, the file system uses solid state drive storage. If set to HDD, the file
	// system uses hard disk drive storage.
	StorageType StorageType

	// Specifies the IDs of the subnets that the file system is accessible from. For
	// Windows MULTI_AZ_1 file system deployment type, there are two subnet IDs, one
	// for the preferred file server and one for the standby file server. The preferred
	// file server subnet identified in the PreferredSubnetID property. All other file
	// systems have only one subnet ID. For Lustre file systems, and Single-AZ Windows
	// file systems, this is the ID of the subnet that contains the endpoint for the
	// file system. For MULTI_AZ_1 Windows file systems, the endpoint for the file
	// system is available in the PreferredSubnetID.
	SubnetIds []string

	// The tags to associate with the file system. For more information, see Tagging
	// Your Amazon EC2 Resources
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html) in the
	// Amazon EC2 User Guide.
	Tags []Tag

	// The ID of the primary VPC for the file system.
	VpcId *string

	// The configuration for this Microsoft Windows file system.
	WindowsConfiguration *WindowsFileSystemConfiguration

	noSmithyDocumentSerde
}

// A structure providing details of any failures that occur when creating the file
// system has failed.
type FileSystemFailureDetails struct {

	// A message describing any failures that occurred during file system creation.
	Message *string

	noSmithyDocumentSerde
}

// A filter used to restrict the results of describe calls. You can use multiple
// filters to return results that meet all applied filter requirements.
type Filter struct {

	// The name for this filter.
	Name FilterName

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []string

	noSmithyDocumentSerde
}

// The configuration for the Amazon FSx for Lustre file system.
type LustreFileSystemConfiguration struct {

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 90 days.
	// The default is 0.
	AutomaticBackupRetentionDays *int32

	// A boolean flag indicating whether tags on the file system should be copied to
	// backups. If it's set to true, all tags on the file system are copied to all
	// automatic backups and any user-initiated backups where the user doesn't specify
	// any tags. If this value is true, and you specify one or more tags, only the
	// specified tags are copied to backups. If you specify one or more tags when
	// creating a user-initiated backup, no tags are copied from the file system,
	// regardless of this value. (Default = false)
	CopyTagsToBackups *bool

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// The data compression configuration for the file system. DataCompressionType can
	// have the following values:
	//
	// * NONE - Data compression is turned off for the file
	// system.
	//
	// * LZ4 - Data compression is turned on with the LZ4 algorithm.
	//
	// For more
	// information, see Lustre data compression
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).
	DataCompressionType DataCompressionType

	// The data repository configuration object for Lustre file systems returned in the
	// response of the CreateFileSystem operation.
	DataRepositoryConfiguration *DataRepositoryConfiguration

	// The deployment type of the FSX for Lustre file system. Scratch deployment type
	// is designed for temporary storage and shorter-term processing of data. SCRATCH_1
	// and SCRATCH_2 deployment types are best suited for when you need temporary
	// storage and shorter-term processing of data. The SCRATCH_2 deployment type
	// provides in-transit encryption of data and higher burst throughput capacity than
	// SCRATCH_1. The PERSISTENT_1 deployment type is used for longer-term storage and
	// workloads and encryption of data in transit. To learn more about deployment
	// types, see  FSx for Lustre Deployment Options
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html).
	// (Default = SCRATCH_1)
	DeploymentType LustreDeploymentType

	// The type of drive cache used by PERSISTENT_1 file systems that are provisioned
	// with HDD storage devices. This parameter is required when storage type is HDD.
	// Set to READ, improve the performance for frequently accessed files and allows
	// 20% of the total storage capacity of the file system to be cached. This
	// parameter is required when StorageType is set to HDD.
	DriveCacheType DriveCacheType

	// You use the MountName value when mounting the file system. For the SCRATCH_1
	// deployment type, this value is always "fsx". For SCRATCH_2 and PERSISTENT_1
	// deployment types, this value is a string that is unique within an AWS Region.
	MountName *string

	// Per unit storage throughput represents the megabytes per second of read or write
	// throughput per 1 tebibyte of storage provisioned. File system throughput
	// capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput
	// (MB/s/TiB). This option is only valid for PERSISTENT_1 deployment types. Valid
	// values for SSD storage: 50, 100, 200. Valid values for HDD storage: 12, 40.
	PerUnitStorageThroughput *int32

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in the
	// UTC time zone. d is the weekday number, from 1 through 7, beginning with Monday
	// and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration of the self-managed Microsoft Active Directory (AD) directory
// to which the Windows File Server instance is joined.
type SelfManagedActiveDirectoryAttributes struct {

	// A list of up to two IP addresses of DNS servers or domain controllers in the
	// self-managed AD directory.
	DnsIps []string

	// The fully qualified domain name of the self-managed AD directory.
	DomainName *string

	// The name of the domain group whose members have administrative privileges for
	// the FSx file system.
	FileSystemAdministratorsGroup *string

	// The fully qualified distinguished name of the organizational unit within the
	// self-managed AD directory to which the Windows File Server instance is joined.
	OrganizationalUnitDistinguishedName *string

	// The user name for the service account on your self-managed AD domain that FSx
	// uses to join to your AD domain.
	UserName *string

	noSmithyDocumentSerde
}

// The configuration that Amazon FSx uses to join the Windows File Server instance
// to your self-managed (including on-premises) Microsoft Active Directory (AD)
// directory. For more information, see  Using Amazon FSx with your self-managed
// Microsoft Active Directory
// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html).
type SelfManagedActiveDirectoryConfiguration struct {

	// A list of up to two IP addresses of DNS servers or domain controllers in the
	// self-managed AD directory.
	//
	// This member is required.
	DnsIps []string

	// The fully qualified domain name of the self-managed AD directory, such as
	// corp.example.com.
	//
	// This member is required.
	DomainName *string

	// The password for the service account on your self-managed AD domain that Amazon
	// FSx will use to join to your AD domain.
	//
	// This member is required.
	Password *string

	// The user name for the service account on your self-managed AD domain that Amazon
	// FSx will use to join to your AD domain. This account must have the permission to
	// join computers to the domain in the organizational unit provided in
	// OrganizationalUnitDistinguishedName, or in the default location of your AD
	// domain.
	//
	// This member is required.
	UserName *string

	// (Optional) The name of the domain group whose members are granted administrative
	// privileges for the file system. Administrative privileges include taking
	// ownership of files and folders, setting audit controls (audit ACLs) on files and
	// folders, and administering the file system remotely by using the FSx Remote
	// PowerShell. The group that you specify must already exist in your domain. If you
	// don't provide one, your AD domain's Domain Admins group is used.
	FileSystemAdministratorsGroup *string

	// (Optional) The fully qualified distinguished name of the organizational unit
	// within your self-managed AD directory that the Windows File Server instance will
	// join. Amazon FSx only accepts OU as the direct parent of the file system. An
	// example is OU=FSx,DC=yourdomain,DC=corp,DC=com. To learn more, see RFC 2253
	// (https://tools.ietf.org/html/rfc2253). If none is provided, the FSx file system
	// is created in the default location of your self-managed AD directory. Only
	// Organizational Unit (OU) objects can be the direct parent of the file system
	// that you're creating.
	OrganizationalUnitDistinguishedName *string

	noSmithyDocumentSerde
}

// The configuration that Amazon FSx uses to join the Windows File Server instance
// to a self-managed Microsoft Active Directory (AD) directory.
type SelfManagedActiveDirectoryConfigurationUpdates struct {

	// A list of up to two IP addresses of DNS servers or domain controllers in the
	// self-managed AD directory.
	DnsIps []string

	// The password for the service account on your self-managed AD domain that Amazon
	// FSx will use to join to your AD domain.
	Password *string

	// The user name for the service account on your self-managed AD domain that Amazon
	// FSx will use to join to your AD domain. This account must have the permission to
	// join computers to the domain in the organizational unit provided in
	// OrganizationalUnitDistinguishedName.
	UserName *string

	noSmithyDocumentSerde
}

// Specifies a key-value pair for a resource tag.
type Tag struct {

	// A value that specifies the TagKey, the name of the tag. Tag keys must be unique
	// for the resource to which they are attached.
	//
	// This member is required.
	Key *string

	// A value that specifies the TagValue, the value assigned to the corresponding tag
	// key. Tag values can be null and don't have to be unique in a tag set. For
	// example, you can have a key-value pair in a tag set of finances : April and also
	// of payroll : April.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The configuration object for Amazon FSx for Lustre file systems used in the
// UpdateFileSystem operation.
type UpdateFileSystemLustreConfiguration struct {

	// (Optional) When you create your file system, your existing S3 objects appear as
	// file and directory listings. Use this property to choose how Amazon FSx keeps
	// your file and directory listing up to date as you add or modify objects in your
	// linked S3 bucket. AutoImportPolicy can have the following values:
	//
	// * NONE -
	// (Default) AutoImport is off. Amazon FSx only updates file and directory listings
	// from the linked S3 bucket when the file system is created. FSx does not update
	// the file and directory listing for any new or changed objects after choosing
	// this option.
	//
	// * NEW - AutoImport is on. Amazon FSx automatically imports
	// directory listings of any new objects added to the linked S3 bucket that do not
	// currently exist in the FSx file system.
	//
	// * NEW_CHANGED - AutoImport is on.
	// Amazon FSx automatically imports file and directory listings of any new objects
	// added to the S3 bucket and any existing objects that are changed in the S3
	// bucket after you choose this option.
	//
	// For more information, see Automatically
	// import updates from your S3 bucket
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html).
	AutoImportPolicy AutoImportPolicyType

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 90 days.
	// The default is 0.
	AutomaticBackupRetentionDays *int32

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the
	// day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00
	// specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string

	// Sets the data compression configuration for the file system. DataCompressionType
	// can have the following values:
	//
	// * NONE - Data compression is turned off for the
	// file system.
	//
	// * LZ4 - Data compression is turned on with the LZ4 algorithm.
	//
	// If
	// you don't use DataCompressionType, the file system retains its current data
	// compression configuration. For more information, see Lustre data compression
	// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).
	DataCompressionType DataCompressionType

	// (Optional) The preferred start time to perform weekly maintenance, formatted
	// d:HH:MM in the UTC time zone. d is the weekday number, from 1 through 7,
	// beginning with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// Updates the configuration for an existing Amazon FSx for Windows File Server
// file system. Amazon FSx only overwrites existing properties with non-null values
// provided in the request.
type UpdateFileSystemWindowsConfiguration struct {

	// The configuration that Amazon FSx for Windows File Server uses to audit and log
	// user accesses of files, folders, and file shares on the Amazon FSx for Windows
	// File Server file system..
	AuditLogConfiguration *WindowsAuditLogCreateConfiguration

	// The number of days to retain automatic daily backups. Setting this to zero (0)
	// disables automatic daily backups. You can retain automatic daily backups for a
	// maximum of 90 days. For more information, see Working with Automatic Daily
	// Backups
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups).
	AutomaticBackupRetentionDays *int32

	// The preferred time to start the daily automatic backup, in the UTC time zone,
	// for example, 02:00
	DailyAutomaticBackupStartTime *string

	// The configuration Amazon FSx uses to join the Windows File Server instance to
	// the self-managed Microsoft AD directory. You cannot make a self-managed
	// Microsoft AD update request if there is an existing self-managed Microsoft AD
	// update request in progress.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfigurationUpdates

	// Sets the target value for a file system's throughput capacity, in MB/s, that you
	// are updating the file system to. Valid values are 8, 16, 32, 64, 128, 256, 512,
	// 1024, 2048. You cannot make a throughput capacity update request if there is an
	// existing throughput capacity update request in progress. For more information,
	// see Managing Throughput Capacity
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html).
	ThroughputCapacity *int32

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in the
	// UTC time zone. Where d is the weekday number, from 1 through 7, with 1 = Monday
	// and 7 = Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The configuration that Amazon FSx for Windows File Server uses to audit and log
// user accesses of files, folders, and file shares on the Amazon FSx for Windows
// File Server file system. For more information, see  File access auditing
// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/file-access-auditing.html).
type WindowsAuditLogConfiguration struct {

	// Sets which attempt type is logged by Amazon FSx for file and folder accesses.
	//
	// *
	// SUCCESS_ONLY - only successful attempts to access files or folders are
	// logged.
	//
	// * FAILURE_ONLY - only failed attempts to access files or folders are
	// logged.
	//
	// * SUCCESS_AND_FAILURE - both successful attempts and failed attempts to
	// access files or folders are logged.
	//
	// * DISABLED - access auditing of files and
	// folders is turned off.
	//
	// This member is required.
	FileAccessAuditLogLevel WindowsAccessAuditLogLevel

	// Sets which attempt type is logged by Amazon FSx for file share accesses.
	//
	// *
	// SUCCESS_ONLY - only successful attempts to access file shares are logged.
	//
	// *
	// FAILURE_ONLY - only failed attempts to access file shares are logged.
	//
	// *
	// SUCCESS_AND_FAILURE - both successful attempts and failed attempts to access
	// file shares are logged.
	//
	// * DISABLED - access auditing of file shares is turned
	// off.
	//
	// This member is required.
	FileShareAccessAuditLogLevel WindowsAccessAuditLogLevel

	// The Amazon Resource Name (ARN) for the destination of the audit logs. The
	// destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis
	// Data Firehose delivery stream ARN. The name of the Amazon CloudWatch Logs log
	// group must begin with the /aws/fsx prefix. The name of the Amazon Kinesis Data
	// Firehouse delivery stream must begin with the aws-fsx prefix. The destination
	// ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream)
	// must be in the same AWS partition, AWS region, and AWS account as your Amazon
	// FSx file system.
	AuditLogDestination *string

	noSmithyDocumentSerde
}

// The Windows file access auditing configuration used when creating or updating an
// Amazon FSx for Windows File Server file system.
type WindowsAuditLogCreateConfiguration struct {

	// Sets which attempt type is logged by Amazon FSx for file and folder accesses.
	//
	// *
	// SUCCESS_ONLY - only successful attempts to access files or folders are
	// logged.
	//
	// * FAILURE_ONLY - only failed attempts to access files or folders are
	// logged.
	//
	// * SUCCESS_AND_FAILURE - both successful attempts and failed attempts to
	// access files or folders are logged.
	//
	// * DISABLED - access auditing of files and
	// folders is turned off.
	//
	// This member is required.
	FileAccessAuditLogLevel WindowsAccessAuditLogLevel

	// Sets which attempt type is logged by Amazon FSx for file share accesses.
	//
	// *
	// SUCCESS_ONLY - only successful attempts to access file shares are logged.
	//
	// *
	// FAILURE_ONLY - only failed attempts to access file shares are logged.
	//
	// *
	// SUCCESS_AND_FAILURE - both successful attempts and failed attempts to access
	// file shares are logged.
	//
	// * DISABLED - access auditing of file shares is turned
	// off.
	//
	// This member is required.
	FileShareAccessAuditLogLevel WindowsAccessAuditLogLevel

	// The Amazon Resource Name (ARN) that specifies the destination of the audit logs.
	// The destination can be any Amazon CloudWatch Logs log group ARN or Amazon
	// Kinesis Data Firehose delivery stream ARN, with the following requirements:
	//
	// *
	// The destination ARN that you provide (either CloudWatch Logs log group or
	// Kinesis Data Firehose delivery stream) must be in the same AWS partition, AWS
	// region, and AWS account as your Amazon FSx file system.
	//
	// * The name of the
	// Amazon CloudWatch Logs log group must begin with the /aws/fsx prefix. The name
	// of the Amazon Kinesis Data Firehouse delivery stream must begin with the aws-fsx
	// prefix.
	//
	// * If you do not provide a destination in AuditLogDestination, Amazon
	// FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log
	// group.
	//
	// * If AuditLogDestination is provided and the resource does not exist,
	// the request will fail with a BadRequest error.
	//
	// * If FileAccessAuditLogLevel and
	// FileShareAccessAuditLogLevel are both set to DISABLED, you cannot specify a
	// destination in AuditLogDestination.
	AuditLogDestination *string

	noSmithyDocumentSerde
}

// The configuration for this Microsoft Windows file system.
type WindowsFileSystemConfiguration struct {

	// The ID for an existing AWS Managed Microsoft Active Directory instance that the
	// file system is joined to.
	ActiveDirectoryId *string

	// An array of one or more DNS aliases that are currently associated with the
	// Amazon FSx file system. Aliases allow you to use existing DNS names to access
	// the data in your Amazon FSx file system. You can associate up to 50 aliases with
	// a file system at any time. You can associate additional DNS aliases after you
	// create the file system using the AssociateFileSystemAliases operation. You can
	// remove DNS aliases from the file system after it is created using the
	// DisassociateFileSystemAliases operation. You only need to specify the alias name
	// in the request payload. For more information, see DNS aliases
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html).
	Aliases []Alias

	// The configuration that Amazon FSx for Windows File Server uses to audit and log
	// user accesses of files, folders, and file shares on the Amazon FSx for Windows
	// File Server file system.
	AuditLogConfiguration *WindowsAuditLogConfiguration

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 90 days.
	AutomaticBackupRetentionDays *int32

	// A boolean flag indicating whether tags on the file system should be copied to
	// backups. This value defaults to false. If it's set to true, all tags on the file
	// system are copied to all automatic backups and any user-initiated backups where
	// the user doesn't specify any tags. If this value is true, and you specify one or
	// more tags, only the specified tags are copied to backups. If you specify one or
	// more tags when creating a user-initiated backup, no tags are copied from the
	// file system, regardless of this value.
	CopyTagsToBackups *bool

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string

	// Specifies the file system deployment type, valid values are the following:
	//
	// *
	// MULTI_AZ_1 - Specifies a high availability file system that is configured for
	// Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability,
	// and supports SSD and HDD storage.
	//
	// * SINGLE_AZ_1 - (Default) Specifies a file
	// system that is configured for single AZ redundancy, only supports SSD
	// storage.
	//
	// * SINGLE_AZ_2 - Latest generation Single AZ file system. Specifies a
	// file system that is configured for single AZ redundancy and supports SSD and HDD
	// storage.
	//
	// For more information, see Single-AZ and Multi-AZ File Systems
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
	DeploymentType WindowsDeploymentType

	// The list of maintenance operations in progress for this file system.
	MaintenanceOperationsInProgress []FileSystemMaintenanceOperation

	// For MULTI_AZ_1 deployment types, the IP address of the primary, or preferred,
	// file server. Use this IP address when mounting the file system on Linux SMB
	// clients or Windows SMB clients that are not joined to a Microsoft Active
	// Directory. Applicable for all Windows file system deployment types. This IP
	// address is temporarily unavailable when the file system is undergoing
	// maintenance. For Linux and Windows SMB clients that are joined to an Active
	// Directory, use the file system's DNSName instead. For more information on
	// mapping and mounting file shares, see Accessing File Shares
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html).
	PreferredFileServerIp *string

	// For MULTI_AZ_1 deployment types, it specifies the ID of the subnet where the
	// preferred file server is located. Must be one of the two subnet IDs specified in
	// SubnetIds property. Amazon FSx serves traffic from this subnet except in the
	// event of a failover to the secondary file server. For SINGLE_AZ_1 and
	// SINGLE_AZ_2 deployment types, this value is the same as that for SubnetIDs. For
	// more information, see Availability and durability: Single-AZ and Multi-AZ file
	// systems
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources).
	PreferredSubnetId *string

	// For MULTI_AZ_1 deployment types, use this endpoint when performing
	// administrative tasks on the file system using Amazon FSx Remote PowerShell. For
	// SINGLE_AZ_1 and SINGLE_AZ_2 deployment types, this is the DNS name of the file
	// system. This endpoint is temporarily unavailable when the file system is
	// undergoing maintenance.
	RemoteAdministrationEndpoint *string

	// The configuration of the self-managed Microsoft Active Directory (AD) directory
	// to which the Windows File Server instance is joined.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryAttributes

	// The throughput of the Amazon FSx file system, measured in megabytes per second.
	ThroughputCapacity *int32

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM in the
	// UTC time zone. d is the weekday number, from 1 through 7, beginning with Monday
	// and ending with Sunday.
	WeeklyMaintenanceStartTime *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
