// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the specified IPv4 address pools.
func (c *Client) DescribePublicIpv4Pools(ctx context.Context, params *DescribePublicIpv4PoolsInput, optFns ...func(*Options)) (*DescribePublicIpv4PoolsOutput, error) {
	if params == nil {
		params = &DescribePublicIpv4PoolsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribePublicIpv4Pools", params, optFns, c.addOperationDescribePublicIpv4PoolsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribePublicIpv4PoolsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribePublicIpv4PoolsInput struct {

	// One or more filters.
	//
	// * tag: - The key/value combination of a tag assigned to
	// the resource. Use the tag key in the filter name and the tag value as the filter
	// value. For example, to find all resources that have a tag with the key Owner and
	// the value TeamA, specify tag:Owner for the filter name and TeamA for the filter
	// value.
	//
	// * tag-key - The key of a tag assigned to the resource. Use this filter
	// to find all resources assigned a tag with a specific key, regardless of the tag
	// value.
	Filters []types.Filter

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The IDs of the address pools.
	PoolIds []string

	noSmithyDocumentSerde
}

type DescribePublicIpv4PoolsOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Information about the address pools.
	PublicIpv4Pools []types.PublicIpv4Pool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribePublicIpv4PoolsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribePublicIpv4Pools{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribePublicIpv4Pools{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribePublicIpv4Pools(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribePublicIpv4PoolsAPIClient is a client that implements the
// DescribePublicIpv4Pools operation.
type DescribePublicIpv4PoolsAPIClient interface {
	DescribePublicIpv4Pools(context.Context, *DescribePublicIpv4PoolsInput, ...func(*Options)) (*DescribePublicIpv4PoolsOutput, error)
}

var _ DescribePublicIpv4PoolsAPIClient = (*Client)(nil)

// DescribePublicIpv4PoolsPaginatorOptions is the paginator options for
// DescribePublicIpv4Pools
type DescribePublicIpv4PoolsPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribePublicIpv4PoolsPaginator is a paginator for DescribePublicIpv4Pools
type DescribePublicIpv4PoolsPaginator struct {
	options   DescribePublicIpv4PoolsPaginatorOptions
	client    DescribePublicIpv4PoolsAPIClient
	params    *DescribePublicIpv4PoolsInput
	nextToken *string
	firstPage bool
}

// NewDescribePublicIpv4PoolsPaginator returns a new
// DescribePublicIpv4PoolsPaginator
func NewDescribePublicIpv4PoolsPaginator(client DescribePublicIpv4PoolsAPIClient, params *DescribePublicIpv4PoolsInput, optFns ...func(*DescribePublicIpv4PoolsPaginatorOptions)) *DescribePublicIpv4PoolsPaginator {
	if params == nil {
		params = &DescribePublicIpv4PoolsInput{}
	}

	options := DescribePublicIpv4PoolsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribePublicIpv4PoolsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribePublicIpv4PoolsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next DescribePublicIpv4Pools page.
func (p *DescribePublicIpv4PoolsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribePublicIpv4PoolsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribePublicIpv4Pools(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribePublicIpv4Pools(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ec2",
		OperationName: "DescribePublicIpv4Pools",
	}
}
