// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// An internal service error occurred.
type InternalServiceError struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InternalServiceError) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalServiceError) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalServiceError) ErrorCode() string             { return "InternalServiceError" }
func (e *InternalServiceError) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The request was not valid. Verify that your request was properly formatted, that
// the signature was generated with the correct credentials, and that you haven't
// exceeded any of the service limits for your account.
type InvalidRequestException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRequestException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRequestException) ErrorCode() string             { return "InvalidRequestException" }
func (e *InvalidRequestException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified pipeline has been deleted.
type PipelineDeletedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *PipelineDeletedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PipelineDeletedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PipelineDeletedException) ErrorCode() string             { return "PipelineDeletedException" }
func (e *PipelineDeletedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified pipeline was not found. Verify that you used the correct user and
// account identifiers.
type PipelineNotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *PipelineNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PipelineNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PipelineNotFoundException) ErrorCode() string             { return "PipelineNotFoundException" }
func (e *PipelineNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified task was not found.
type TaskNotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TaskNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TaskNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TaskNotFoundException) ErrorCode() string             { return "TaskNotFoundException" }
func (e *TaskNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
