// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// Access denied.
type AccessDenied struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *AccessDenied) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDenied) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDenied) ErrorCode() string             { return "AccessDenied" }
func (e *AccessDenied) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Invalidation batch specified is too large.
type BatchTooLarge struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *BatchTooLarge) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BatchTooLarge) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BatchTooLarge) ErrorCode() string             { return "BatchTooLarge" }
func (e *BatchTooLarge) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A cache policy with this name already exists. You must provide a unique name. To
// modify an existing cache policy, use UpdateCachePolicy.
type CachePolicyAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CachePolicyAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CachePolicyAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CachePolicyAlreadyExists) ErrorCode() string             { return "CachePolicyAlreadyExists" }
func (e *CachePolicyAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot delete the cache policy because it is attached to one or more cache
// behaviors.
type CachePolicyInUse struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CachePolicyInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CachePolicyInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CachePolicyInUse) ErrorCode() string             { return "CachePolicyInUse" }
func (e *CachePolicyInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can't change the value of a public key.
type CannotChangeImmutablePublicKeyFields struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CannotChangeImmutablePublicKeyFields) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CannotChangeImmutablePublicKeyFields) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CannotChangeImmutablePublicKeyFields) ErrorCode() string {
	return "CannotChangeImmutablePublicKeyFields"
}
func (e *CannotChangeImmutablePublicKeyFields) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// If the CallerReference is a value you already sent in a previous request to
// create an identity but the content of the CloudFrontOriginAccessIdentityConfig
// is different from the original request, CloudFront returns a
// CloudFrontOriginAccessIdentityAlreadyExists error.
type CloudFrontOriginAccessIdentityAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CloudFrontOriginAccessIdentityAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudFrontOriginAccessIdentityAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudFrontOriginAccessIdentityAlreadyExists) ErrorCode() string {
	return "CloudFrontOriginAccessIdentityAlreadyExists"
}
func (e *CloudFrontOriginAccessIdentityAlreadyExists) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The Origin Access Identity specified is already in use.
type CloudFrontOriginAccessIdentityInUse struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CloudFrontOriginAccessIdentityInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CloudFrontOriginAccessIdentityInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CloudFrontOriginAccessIdentityInUse) ErrorCode() string {
	return "CloudFrontOriginAccessIdentityInUse"
}
func (e *CloudFrontOriginAccessIdentityInUse) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The CNAME specified is already defined for CloudFront.
type CNAMEAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CNAMEAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CNAMEAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CNAMEAlreadyExists) ErrorCode() string             { return "CNAMEAlreadyExists" }
func (e *CNAMEAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The caller reference you attempted to create the distribution with is associated
// with another distribution.
type DistributionAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DistributionAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DistributionAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DistributionAlreadyExists) ErrorCode() string             { return "DistributionAlreadyExists" }
func (e *DistributionAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified CloudFront distribution is not disabled. You must disable the
// distribution before you can delete it.
type DistributionNotDisabled struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DistributionNotDisabled) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DistributionNotDisabled) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DistributionNotDisabled) ErrorCode() string             { return "DistributionNotDisabled" }
func (e *DistributionNotDisabled) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified configuration for field-level encryption already exists.
type FieldLevelEncryptionConfigAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *FieldLevelEncryptionConfigAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FieldLevelEncryptionConfigAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FieldLevelEncryptionConfigAlreadyExists) ErrorCode() string {
	return "FieldLevelEncryptionConfigAlreadyExists"
}
func (e *FieldLevelEncryptionConfigAlreadyExists) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified configuration for field-level encryption is in use.
type FieldLevelEncryptionConfigInUse struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *FieldLevelEncryptionConfigInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FieldLevelEncryptionConfigInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FieldLevelEncryptionConfigInUse) ErrorCode() string {
	return "FieldLevelEncryptionConfigInUse"
}
func (e *FieldLevelEncryptionConfigInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified profile for field-level encryption already exists.
type FieldLevelEncryptionProfileAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *FieldLevelEncryptionProfileAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FieldLevelEncryptionProfileAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FieldLevelEncryptionProfileAlreadyExists) ErrorCode() string {
	return "FieldLevelEncryptionProfileAlreadyExists"
}
func (e *FieldLevelEncryptionProfileAlreadyExists) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified profile for field-level encryption is in use.
type FieldLevelEncryptionProfileInUse struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *FieldLevelEncryptionProfileInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FieldLevelEncryptionProfileInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FieldLevelEncryptionProfileInUse) ErrorCode() string {
	return "FieldLevelEncryptionProfileInUse"
}
func (e *FieldLevelEncryptionProfileInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum size of a profile for field-level encryption was exceeded.
type FieldLevelEncryptionProfileSizeExceeded struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *FieldLevelEncryptionProfileSizeExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FieldLevelEncryptionProfileSizeExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FieldLevelEncryptionProfileSizeExceeded) ErrorCode() string {
	return "FieldLevelEncryptionProfileSizeExceeded"
}
func (e *FieldLevelEncryptionProfileSizeExceeded) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A function with the same name already exists in this account. To create a
// function, you must provide a unique name. To update an existing function, use
// UpdateFunction.
type FunctionAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *FunctionAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FunctionAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FunctionAlreadyExists) ErrorCode() string             { return "FunctionAlreadyExists" }
func (e *FunctionAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot delete the function because it’s attached to one or more cache behaviors.
type FunctionInUse struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *FunctionInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FunctionInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FunctionInUse) ErrorCode() string             { return "FunctionInUse" }
func (e *FunctionInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The function is too large. For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type FunctionSizeLimitExceeded struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *FunctionSizeLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FunctionSizeLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FunctionSizeLimitExceeded) ErrorCode() string             { return "FunctionSizeLimitExceeded" }
func (e *FunctionSizeLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot delete a managed policy.
type IllegalDelete struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IllegalDelete) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalDelete) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalDelete) ErrorCode() string             { return "IllegalDelete" }
func (e *IllegalDelete) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified configuration for field-level encryption can't be associated with
// the specified cache behavior.
type IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior) ErrorCode() string {
	return "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior"
}
func (e *IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The update contains modifications that are not allowed.
type IllegalUpdate struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IllegalUpdate) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalUpdate) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalUpdate) ErrorCode() string             { return "IllegalUpdate" }
func (e *IllegalUpdate) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The value of Quantity and the size of Items don't match.
type InconsistentQuantities struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InconsistentQuantities) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InconsistentQuantities) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InconsistentQuantities) ErrorCode() string             { return "InconsistentQuantities" }
func (e *InconsistentQuantities) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An argument is invalid.
type InvalidArgument struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidArgument) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidArgument) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidArgument) ErrorCode() string             { return "InvalidArgument" }
func (e *InvalidArgument) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The default root object file name is too big or contains an invalid character.
type InvalidDefaultRootObject struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidDefaultRootObject) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDefaultRootObject) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDefaultRootObject) ErrorCode() string             { return "InvalidDefaultRootObject" }
func (e *InvalidDefaultRootObject) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An invalid error code was specified.
type InvalidErrorCode struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidErrorCode) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidErrorCode) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidErrorCode) ErrorCode() string             { return "InvalidErrorCode" }
func (e *InvalidErrorCode) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains forward cookies option which doesn't match with the
// expectation for the whitelisted list of cookie names. Either list of cookie
// names has been specified when not allowed or list of cookie names is missing
// when expected.
type InvalidForwardCookies struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidForwardCookies) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidForwardCookies) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidForwardCookies) ErrorCode() string             { return "InvalidForwardCookies" }
func (e *InvalidForwardCookies) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A CloudFront function association is invalid.
type InvalidFunctionAssociation struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidFunctionAssociation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidFunctionAssociation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidFunctionAssociation) ErrorCode() string             { return "InvalidFunctionAssociation" }
func (e *InvalidFunctionAssociation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified geo restriction parameter is not valid.
type InvalidGeoRestrictionParameter struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidGeoRestrictionParameter) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidGeoRestrictionParameter) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidGeoRestrictionParameter) ErrorCode() string             { return "InvalidGeoRestrictionParameter" }
func (e *InvalidGeoRestrictionParameter) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The headers specified are not valid for an Amazon S3 origin.
type InvalidHeadersForS3Origin struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidHeadersForS3Origin) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidHeadersForS3Origin) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidHeadersForS3Origin) ErrorCode() string             { return "InvalidHeadersForS3Origin" }
func (e *InvalidHeadersForS3Origin) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The If-Match version is missing or not valid.
type InvalidIfMatchVersion struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidIfMatchVersion) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidIfMatchVersion) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidIfMatchVersion) ErrorCode() string             { return "InvalidIfMatchVersion" }
func (e *InvalidIfMatchVersion) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Lambda@Edge function association is invalid.
type InvalidLambdaFunctionAssociation struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidLambdaFunctionAssociation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidLambdaFunctionAssociation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidLambdaFunctionAssociation) ErrorCode() string {
	return "InvalidLambdaFunctionAssociation"
}
func (e *InvalidLambdaFunctionAssociation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The location code specified is not valid.
type InvalidLocationCode struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidLocationCode) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidLocationCode) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidLocationCode) ErrorCode() string             { return "InvalidLocationCode" }
func (e *InvalidLocationCode) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The minimum protocol version specified is not valid.
type InvalidMinimumProtocolVersion struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidMinimumProtocolVersion) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMinimumProtocolVersion) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMinimumProtocolVersion) ErrorCode() string             { return "InvalidMinimumProtocolVersion" }
func (e *InvalidMinimumProtocolVersion) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Amazon S3 origin server specified does not refer to a valid Amazon S3
// bucket.
type InvalidOrigin struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidOrigin) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOrigin) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOrigin) ErrorCode() string             { return "InvalidOrigin" }
func (e *InvalidOrigin) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The origin access identity is not valid or doesn't exist.
type InvalidOriginAccessIdentity struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidOriginAccessIdentity) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOriginAccessIdentity) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOriginAccessIdentity) ErrorCode() string             { return "InvalidOriginAccessIdentity" }
func (e *InvalidOriginAccessIdentity) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The keep alive timeout specified for the origin is not valid.
type InvalidOriginKeepaliveTimeout struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidOriginKeepaliveTimeout) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOriginKeepaliveTimeout) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOriginKeepaliveTimeout) ErrorCode() string             { return "InvalidOriginKeepaliveTimeout" }
func (e *InvalidOriginKeepaliveTimeout) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The read timeout specified for the origin is not valid.
type InvalidOriginReadTimeout struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidOriginReadTimeout) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOriginReadTimeout) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOriginReadTimeout) ErrorCode() string             { return "InvalidOriginReadTimeout" }
func (e *InvalidOriginReadTimeout) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot specify SSLv3 as the minimum protocol version if you only want to
// support only clients that support Server Name Indication (SNI).
type InvalidProtocolSettings struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidProtocolSettings) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidProtocolSettings) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidProtocolSettings) ErrorCode() string             { return "InvalidProtocolSettings" }
func (e *InvalidProtocolSettings) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The query string parameters specified are not valid.
type InvalidQueryStringParameters struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidQueryStringParameters) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidQueryStringParameters) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidQueryStringParameters) ErrorCode() string             { return "InvalidQueryStringParameters" }
func (e *InvalidQueryStringParameters) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The relative path is too big, is not URL-encoded, or does not begin with a slash
// (/).
type InvalidRelativePath struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidRelativePath) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRelativePath) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRelativePath) ErrorCode() string             { return "InvalidRelativePath" }
func (e *InvalidRelativePath) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This operation requires the HTTPS protocol. Ensure that you specify the HTTPS
// protocol in your request, or omit the RequiredProtocols element from your
// distribution configuration.
type InvalidRequiredProtocol struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidRequiredProtocol) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRequiredProtocol) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRequiredProtocol) ErrorCode() string             { return "InvalidRequiredProtocol" }
func (e *InvalidRequiredProtocol) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A response code is not valid.
type InvalidResponseCode struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidResponseCode) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResponseCode) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResponseCode) ErrorCode() string             { return "InvalidResponseCode" }
func (e *InvalidResponseCode) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The tagging specified is not valid.
type InvalidTagging struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTagging) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTagging) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTagging) ErrorCode() string             { return "InvalidTagging" }
func (e *InvalidTagging) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The TTL order specified is not valid.
type InvalidTTLOrder struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTTLOrder) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTTLOrder) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTTLOrder) ErrorCode() string             { return "InvalidTTLOrder" }
func (e *InvalidTTLOrder) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A viewer certificate specified is not valid.
type InvalidViewerCertificate struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidViewerCertificate) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidViewerCertificate) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidViewerCertificate) ErrorCode() string             { return "InvalidViewerCertificate" }
func (e *InvalidViewerCertificate) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A web ACL ID specified is not valid. To specify a web ACL created using the
// latest version of WAF, use the ACL ARN, for example
// arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
// To specify a web ACL created using WAF Classic, use the ACL ID, for example
// 473e64fd-f30b-4765-81a0-62ad96dd167a.
type InvalidWebACLId struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidWebACLId) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidWebACLId) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidWebACLId) ErrorCode() string             { return "InvalidWebACLId" }
func (e *InvalidWebACLId) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A key group with this name already exists. You must provide a unique name. To
// modify an existing key group, use UpdateKeyGroup.
type KeyGroupAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *KeyGroupAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KeyGroupAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KeyGroupAlreadyExists) ErrorCode() string             { return "KeyGroupAlreadyExists" }
func (e *KeyGroupAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This operation requires a body. Ensure that the body is present and the
// Content-Type header is set.
type MissingBody struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MissingBody) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MissingBody) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MissingBody) ErrorCode() string             { return "MissingBody" }
func (e *MissingBody) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The cache policy does not exist.
type NoSuchCachePolicy struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchCachePolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchCachePolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchCachePolicy) ErrorCode() string             { return "NoSuchCachePolicy" }
func (e *NoSuchCachePolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified origin access identity does not exist.
type NoSuchCloudFrontOriginAccessIdentity struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchCloudFrontOriginAccessIdentity) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchCloudFrontOriginAccessIdentity) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchCloudFrontOriginAccessIdentity) ErrorCode() string {
	return "NoSuchCloudFrontOriginAccessIdentity"
}
func (e *NoSuchCloudFrontOriginAccessIdentity) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified distribution does not exist.
type NoSuchDistribution struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchDistribution) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchDistribution) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchDistribution) ErrorCode() string             { return "NoSuchDistribution" }
func (e *NoSuchDistribution) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified configuration for field-level encryption doesn't exist.
type NoSuchFieldLevelEncryptionConfig struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchFieldLevelEncryptionConfig) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchFieldLevelEncryptionConfig) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchFieldLevelEncryptionConfig) ErrorCode() string {
	return "NoSuchFieldLevelEncryptionConfig"
}
func (e *NoSuchFieldLevelEncryptionConfig) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified profile for field-level encryption doesn't exist.
type NoSuchFieldLevelEncryptionProfile struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchFieldLevelEncryptionProfile) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchFieldLevelEncryptionProfile) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchFieldLevelEncryptionProfile) ErrorCode() string {
	return "NoSuchFieldLevelEncryptionProfile"
}
func (e *NoSuchFieldLevelEncryptionProfile) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The function does not exist.
type NoSuchFunctionExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchFunctionExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchFunctionExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchFunctionExists) ErrorCode() string             { return "NoSuchFunctionExists" }
func (e *NoSuchFunctionExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified invalidation does not exist.
type NoSuchInvalidation struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchInvalidation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchInvalidation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchInvalidation) ErrorCode() string             { return "NoSuchInvalidation" }
func (e *NoSuchInvalidation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No origin exists with the specified Origin Id.
type NoSuchOrigin struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchOrigin) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchOrigin) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchOrigin) ErrorCode() string             { return "NoSuchOrigin" }
func (e *NoSuchOrigin) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The origin request policy does not exist.
type NoSuchOriginRequestPolicy struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchOriginRequestPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchOriginRequestPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchOriginRequestPolicy) ErrorCode() string             { return "NoSuchOriginRequestPolicy" }
func (e *NoSuchOriginRequestPolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified public key doesn't exist.
type NoSuchPublicKey struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchPublicKey) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchPublicKey) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchPublicKey) ErrorCode() string             { return "NoSuchPublicKey" }
func (e *NoSuchPublicKey) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The real-time log configuration does not exist.
type NoSuchRealtimeLogConfig struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchRealtimeLogConfig) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchRealtimeLogConfig) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchRealtimeLogConfig) ErrorCode() string             { return "NoSuchRealtimeLogConfig" }
func (e *NoSuchRealtimeLogConfig) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A resource that was specified is not valid.
type NoSuchResource struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchResource) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchResource) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchResource) ErrorCode() string             { return "NoSuchResource" }
func (e *NoSuchResource) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified streaming distribution does not exist.
type NoSuchStreamingDistribution struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NoSuchStreamingDistribution) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchStreamingDistribution) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchStreamingDistribution) ErrorCode() string             { return "NoSuchStreamingDistribution" }
func (e *NoSuchStreamingDistribution) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An origin request policy with this name already exists. You must provide a
// unique name. To modify an existing origin request policy, use
// UpdateOriginRequestPolicy.
type OriginRequestPolicyAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *OriginRequestPolicyAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OriginRequestPolicyAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OriginRequestPolicyAlreadyExists) ErrorCode() string {
	return "OriginRequestPolicyAlreadyExists"
}
func (e *OriginRequestPolicyAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot delete the origin request policy because it is attached to one or more
// cache behaviors.
type OriginRequestPolicyInUse struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *OriginRequestPolicyInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OriginRequestPolicyInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OriginRequestPolicyInUse) ErrorCode() string             { return "OriginRequestPolicyInUse" }
func (e *OriginRequestPolicyInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The precondition in one or more of the request fields evaluated to false.
type PreconditionFailed struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *PreconditionFailed) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PreconditionFailed) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PreconditionFailed) ErrorCode() string             { return "PreconditionFailed" }
func (e *PreconditionFailed) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified public key already exists.
type PublicKeyAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *PublicKeyAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PublicKeyAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PublicKeyAlreadyExists) ErrorCode() string             { return "PublicKeyAlreadyExists" }
func (e *PublicKeyAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified public key is in use.
type PublicKeyInUse struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *PublicKeyInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PublicKeyInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PublicKeyInUse) ErrorCode() string             { return "PublicKeyInUse" }
func (e *PublicKeyInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No profile specified for the field-level encryption query argument.
type QueryArgProfileEmpty struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *QueryArgProfileEmpty) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *QueryArgProfileEmpty) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *QueryArgProfileEmpty) ErrorCode() string             { return "QueryArgProfileEmpty" }
func (e *QueryArgProfileEmpty) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A real-time log configuration with this name already exists. You must provide a
// unique name. To modify an existing real-time log configuration, use
// UpdateRealtimeLogConfig.
type RealtimeLogConfigAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *RealtimeLogConfigAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RealtimeLogConfigAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RealtimeLogConfigAlreadyExists) ErrorCode() string             { return "RealtimeLogConfigAlreadyExists" }
func (e *RealtimeLogConfigAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot delete the real-time log configuration because it is attached to one or
// more cache behaviors.
type RealtimeLogConfigInUse struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *RealtimeLogConfigInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RealtimeLogConfigInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RealtimeLogConfigInUse) ErrorCode() string             { return "RealtimeLogConfigInUse" }
func (e *RealtimeLogConfigInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified real-time log configuration belongs to a different account.
type RealtimeLogConfigOwnerMismatch struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *RealtimeLogConfigOwnerMismatch) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RealtimeLogConfigOwnerMismatch) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RealtimeLogConfigOwnerMismatch) ErrorCode() string             { return "RealtimeLogConfigOwnerMismatch" }
func (e *RealtimeLogConfigOwnerMismatch) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot delete this resource because it is in use.
type ResourceInUse struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceInUse) ErrorCode() string             { return "ResourceInUse" }
func (e *ResourceInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The caller reference you attempted to create the streaming distribution with is
// associated with another distribution
type StreamingDistributionAlreadyExists struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *StreamingDistributionAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StreamingDistributionAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StreamingDistributionAlreadyExists) ErrorCode() string {
	return "StreamingDistributionAlreadyExists"
}
func (e *StreamingDistributionAlreadyExists) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified CloudFront distribution is not disabled. You must disable the
// distribution before you can delete it.
type StreamingDistributionNotDisabled struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *StreamingDistributionNotDisabled) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StreamingDistributionNotDisabled) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StreamingDistributionNotDisabled) ErrorCode() string {
	return "StreamingDistributionNotDisabled"
}
func (e *StreamingDistributionNotDisabled) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The CloudFront function failed.
type TestFunctionFailed struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TestFunctionFailed) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TestFunctionFailed) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TestFunctionFailed) ErrorCode() string             { return "TestFunctionFailed" }
func (e *TestFunctionFailed) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// You cannot create more cache behaviors for the distribution.
type TooManyCacheBehaviors struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyCacheBehaviors) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCacheBehaviors) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCacheBehaviors) ErrorCode() string             { return "TooManyCacheBehaviors" }
func (e *TooManyCacheBehaviors) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have reached the maximum number of cache policies for this account. For more
// information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyCachePolicies struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyCachePolicies) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCachePolicies) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCachePolicies) ErrorCode() string             { return "TooManyCachePolicies" }
func (e *TooManyCachePolicies) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot create anymore custom SSL/TLS certificates.
type TooManyCertificates struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyCertificates) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCertificates) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCertificates) ErrorCode() string             { return "TooManyCertificates" }
func (e *TooManyCertificates) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Processing your request would cause you to exceed the maximum number of origin
// access identities allowed.
type TooManyCloudFrontOriginAccessIdentities struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyCloudFrontOriginAccessIdentities) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCloudFrontOriginAccessIdentities) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCloudFrontOriginAccessIdentities) ErrorCode() string {
	return "TooManyCloudFrontOriginAccessIdentities"
}
func (e *TooManyCloudFrontOriginAccessIdentities) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Your request contains more cookie names in the whitelist than are allowed per
// cache behavior.
type TooManyCookieNamesInWhiteList struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyCookieNamesInWhiteList) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCookieNamesInWhiteList) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCookieNamesInWhiteList) ErrorCode() string             { return "TooManyCookieNamesInWhiteList" }
func (e *TooManyCookieNamesInWhiteList) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of cookies in the cache policy exceeds the maximum. For more
// information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyCookiesInCachePolicy struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyCookiesInCachePolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCookiesInCachePolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCookiesInCachePolicy) ErrorCode() string             { return "TooManyCookiesInCachePolicy" }
func (e *TooManyCookiesInCachePolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of cookies in the origin request policy exceeds the maximum. For more
// information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyCookiesInOriginRequestPolicy struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyCookiesInOriginRequestPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyCookiesInOriginRequestPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyCookiesInOriginRequestPolicy) ErrorCode() string {
	return "TooManyCookiesInOriginRequestPolicy"
}
func (e *TooManyCookiesInOriginRequestPolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Your request contains more CNAMEs than are allowed per distribution.
type TooManyDistributionCNAMEs struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionCNAMEs) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionCNAMEs) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionCNAMEs) ErrorCode() string             { return "TooManyDistributionCNAMEs" }
func (e *TooManyDistributionCNAMEs) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Processing your request would cause you to exceed the maximum number of
// distributions allowed.
type TooManyDistributions struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributions) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributions) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributions) ErrorCode() string             { return "TooManyDistributions" }
func (e *TooManyDistributions) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum number of distributions have been associated with the specified
// cache policy. For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyDistributionsAssociatedToCachePolicy struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsAssociatedToCachePolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsAssociatedToCachePolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsAssociatedToCachePolicy) ErrorCode() string {
	return "TooManyDistributionsAssociatedToCachePolicy"
}
func (e *TooManyDistributionsAssociatedToCachePolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of distributions have been associated with the specified
// configuration for field-level encryption.
type TooManyDistributionsAssociatedToFieldLevelEncryptionConfig struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsAssociatedToFieldLevelEncryptionConfig) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsAssociatedToFieldLevelEncryptionConfig) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsAssociatedToFieldLevelEncryptionConfig) ErrorCode() string {
	return "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig"
}
func (e *TooManyDistributionsAssociatedToFieldLevelEncryptionConfig) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of distributions that reference this key group is more than the
// maximum allowed. For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyDistributionsAssociatedToKeyGroup struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsAssociatedToKeyGroup) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsAssociatedToKeyGroup) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsAssociatedToKeyGroup) ErrorCode() string {
	return "TooManyDistributionsAssociatedToKeyGroup"
}
func (e *TooManyDistributionsAssociatedToKeyGroup) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of distributions have been associated with the specified
// origin request policy. For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyDistributionsAssociatedToOriginRequestPolicy struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsAssociatedToOriginRequestPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsAssociatedToOriginRequestPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsAssociatedToOriginRequestPolicy) ErrorCode() string {
	return "TooManyDistributionsAssociatedToOriginRequestPolicy"
}
func (e *TooManyDistributionsAssociatedToOriginRequestPolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the maximum number of distributions that are associated with a
// CloudFront function. For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyDistributionsWithFunctionAssociations struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsWithFunctionAssociations) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsWithFunctionAssociations) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsWithFunctionAssociations) ErrorCode() string {
	return "TooManyDistributionsWithFunctionAssociations"
}
func (e *TooManyDistributionsWithFunctionAssociations) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Processing your request would cause the maximum number of distributions with
// Lambda@Edge function associations per owner to be exceeded.
type TooManyDistributionsWithLambdaAssociations struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsWithLambdaAssociations) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsWithLambdaAssociations) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsWithLambdaAssociations) ErrorCode() string {
	return "TooManyDistributionsWithLambdaAssociations"
}
func (e *TooManyDistributionsWithLambdaAssociations) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of distributions have been associated with the specified
// Lambda@Edge function.
type TooManyDistributionsWithSingleFunctionARN struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyDistributionsWithSingleFunctionARN) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyDistributionsWithSingleFunctionARN) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyDistributionsWithSingleFunctionARN) ErrorCode() string {
	return "TooManyDistributionsWithSingleFunctionARN"
}
func (e *TooManyDistributionsWithSingleFunctionARN) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of configurations for field-level encryption have been
// created.
type TooManyFieldLevelEncryptionConfigs struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionConfigs) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionConfigs) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionConfigs) ErrorCode() string {
	return "TooManyFieldLevelEncryptionConfigs"
}
func (e *TooManyFieldLevelEncryptionConfigs) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of content type profiles for field-level encryption have been
// created.
type TooManyFieldLevelEncryptionContentTypeProfiles struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionContentTypeProfiles) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionContentTypeProfiles) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionContentTypeProfiles) ErrorCode() string {
	return "TooManyFieldLevelEncryptionContentTypeProfiles"
}
func (e *TooManyFieldLevelEncryptionContentTypeProfiles) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of encryption entities for field-level encryption have been
// created.
type TooManyFieldLevelEncryptionEncryptionEntities struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionEncryptionEntities) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionEncryptionEntities) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionEncryptionEntities) ErrorCode() string {
	return "TooManyFieldLevelEncryptionEncryptionEntities"
}
func (e *TooManyFieldLevelEncryptionEncryptionEntities) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of field patterns for field-level encryption have been
// created.
type TooManyFieldLevelEncryptionFieldPatterns struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionFieldPatterns) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionFieldPatterns) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionFieldPatterns) ErrorCode() string {
	return "TooManyFieldLevelEncryptionFieldPatterns"
}
func (e *TooManyFieldLevelEncryptionFieldPatterns) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of profiles for field-level encryption have been created.
type TooManyFieldLevelEncryptionProfiles struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionProfiles) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionProfiles) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionProfiles) ErrorCode() string {
	return "TooManyFieldLevelEncryptionProfiles"
}
func (e *TooManyFieldLevelEncryptionProfiles) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of query arg profiles for field-level encryption have been
// created.
type TooManyFieldLevelEncryptionQueryArgProfiles struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyFieldLevelEncryptionQueryArgProfiles) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFieldLevelEncryptionQueryArgProfiles) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFieldLevelEncryptionQueryArgProfiles) ErrorCode() string {
	return "TooManyFieldLevelEncryptionQueryArgProfiles"
}
func (e *TooManyFieldLevelEncryptionQueryArgProfiles) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the maximum number of CloudFront function associations for this
// distribution. For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyFunctionAssociations struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyFunctionAssociations) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFunctionAssociations) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFunctionAssociations) ErrorCode() string             { return "TooManyFunctionAssociations" }
func (e *TooManyFunctionAssociations) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have reached the maximum number of CloudFront functions for this account.
// For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyFunctions struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyFunctions) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyFunctions) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyFunctions) ErrorCode() string             { return "TooManyFunctions" }
func (e *TooManyFunctions) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of headers in the cache policy exceeds the maximum. For more
// information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyHeadersInCachePolicy struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyHeadersInCachePolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyHeadersInCachePolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyHeadersInCachePolicy) ErrorCode() string             { return "TooManyHeadersInCachePolicy" }
func (e *TooManyHeadersInCachePolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains too many headers in forwarded values.
type TooManyHeadersInForwardedValues struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyHeadersInForwardedValues) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyHeadersInForwardedValues) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyHeadersInForwardedValues) ErrorCode() string {
	return "TooManyHeadersInForwardedValues"
}
func (e *TooManyHeadersInForwardedValues) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of headers in the origin request policy exceeds the maximum. For more
// information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyHeadersInOriginRequestPolicy struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyHeadersInOriginRequestPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyHeadersInOriginRequestPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyHeadersInOriginRequestPolicy) ErrorCode() string {
	return "TooManyHeadersInOriginRequestPolicy"
}
func (e *TooManyHeadersInOriginRequestPolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have exceeded the maximum number of allowable InProgress invalidation batch
// requests, or invalidation objects.
type TooManyInvalidationsInProgress struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyInvalidationsInProgress) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyInvalidationsInProgress) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyInvalidationsInProgress) ErrorCode() string             { return "TooManyInvalidationsInProgress" }
func (e *TooManyInvalidationsInProgress) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have reached the maximum number of key groups for this account. For more
// information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyKeyGroups struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyKeyGroups) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyKeyGroups) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyKeyGroups) ErrorCode() string             { return "TooManyKeyGroups" }
func (e *TooManyKeyGroups) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of key groups referenced by this distribution is more than the
// maximum allowed. For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyKeyGroupsAssociatedToDistribution struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyKeyGroupsAssociatedToDistribution) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyKeyGroupsAssociatedToDistribution) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyKeyGroupsAssociatedToDistribution) ErrorCode() string {
	return "TooManyKeyGroupsAssociatedToDistribution"
}
func (e *TooManyKeyGroupsAssociatedToDistribution) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Your request contains more Lambda@Edge function associations than are allowed
// per distribution.
type TooManyLambdaFunctionAssociations struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyLambdaFunctionAssociations) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyLambdaFunctionAssociations) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyLambdaFunctionAssociations) ErrorCode() string {
	return "TooManyLambdaFunctionAssociations"
}
func (e *TooManyLambdaFunctionAssociations) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains too many origin custom headers.
type TooManyOriginCustomHeaders struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyOriginCustomHeaders) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyOriginCustomHeaders) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyOriginCustomHeaders) ErrorCode() string             { return "TooManyOriginCustomHeaders" }
func (e *TooManyOriginCustomHeaders) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Processing your request would cause you to exceed the maximum number of origin
// groups allowed.
type TooManyOriginGroupsPerDistribution struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyOriginGroupsPerDistribution) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyOriginGroupsPerDistribution) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyOriginGroupsPerDistribution) ErrorCode() string {
	return "TooManyOriginGroupsPerDistribution"
}
func (e *TooManyOriginGroupsPerDistribution) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the maximum number of origin request policies for this account.
// For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyOriginRequestPolicies struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyOriginRequestPolicies) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyOriginRequestPolicies) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyOriginRequestPolicies) ErrorCode() string             { return "TooManyOriginRequestPolicies" }
func (e *TooManyOriginRequestPolicies) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot create more origins for the distribution.
type TooManyOrigins struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyOrigins) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyOrigins) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyOrigins) ErrorCode() string             { return "TooManyOrigins" }
func (e *TooManyOrigins) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum number of public keys for field-level encryption have been created.
// To create a new public key, delete one of the existing keys.
type TooManyPublicKeys struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyPublicKeys) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyPublicKeys) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyPublicKeys) ErrorCode() string             { return "TooManyPublicKeys" }
func (e *TooManyPublicKeys) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of public keys in this key group is more than the maximum allowed.
// For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyPublicKeysInKeyGroup struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyPublicKeysInKeyGroup) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyPublicKeysInKeyGroup) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyPublicKeysInKeyGroup) ErrorCode() string             { return "TooManyPublicKeysInKeyGroup" }
func (e *TooManyPublicKeysInKeyGroup) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains too many query string parameters.
type TooManyQueryStringParameters struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyQueryStringParameters) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyQueryStringParameters) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyQueryStringParameters) ErrorCode() string             { return "TooManyQueryStringParameters" }
func (e *TooManyQueryStringParameters) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of query strings in the cache policy exceeds the maximum. For more
// information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyQueryStringsInCachePolicy struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyQueryStringsInCachePolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyQueryStringsInCachePolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyQueryStringsInCachePolicy) ErrorCode() string {
	return "TooManyQueryStringsInCachePolicy"
}
func (e *TooManyQueryStringsInCachePolicy) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of query strings in the origin request policy exceeds the maximum.
// For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyQueryStringsInOriginRequestPolicy struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyQueryStringsInOriginRequestPolicy) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyQueryStringsInOriginRequestPolicy) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyQueryStringsInOriginRequestPolicy) ErrorCode() string {
	return "TooManyQueryStringsInOriginRequestPolicy"
}
func (e *TooManyQueryStringsInOriginRequestPolicy) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the maximum number of real-time log configurations for this
// account. For more information, see Quotas
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// (formerly known as limits) in the Amazon CloudFront Developer Guide.
type TooManyRealtimeLogConfigs struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyRealtimeLogConfigs) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyRealtimeLogConfigs) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyRealtimeLogConfigs) ErrorCode() string             { return "TooManyRealtimeLogConfigs" }
func (e *TooManyRealtimeLogConfigs) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains more CNAMEs than are allowed per distribution.
type TooManyStreamingDistributionCNAMEs struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyStreamingDistributionCNAMEs) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyStreamingDistributionCNAMEs) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyStreamingDistributionCNAMEs) ErrorCode() string {
	return "TooManyStreamingDistributionCNAMEs"
}
func (e *TooManyStreamingDistributionCNAMEs) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Processing your request would cause you to exceed the maximum number of
// streaming distributions allowed.
type TooManyStreamingDistributions struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyStreamingDistributions) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyStreamingDistributions) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyStreamingDistributions) ErrorCode() string             { return "TooManyStreamingDistributions" }
func (e *TooManyStreamingDistributions) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request contains more trusted signers than are allowed per distribution.
type TooManyTrustedSigners struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TooManyTrustedSigners) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTrustedSigners) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTrustedSigners) ErrorCode() string             { return "TooManyTrustedSigners" }
func (e *TooManyTrustedSigners) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified key group does not exist.
type TrustedKeyGroupDoesNotExist struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TrustedKeyGroupDoesNotExist) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TrustedKeyGroupDoesNotExist) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TrustedKeyGroupDoesNotExist) ErrorCode() string             { return "TrustedKeyGroupDoesNotExist" }
func (e *TrustedKeyGroupDoesNotExist) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more of your trusted signers don't exist.
type TrustedSignerDoesNotExist struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TrustedSignerDoesNotExist) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TrustedSignerDoesNotExist) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TrustedSignerDoesNotExist) ErrorCode() string             { return "TrustedSignerDoesNotExist" }
func (e *TrustedSignerDoesNotExist) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This operation is not supported in this region.
type UnsupportedOperation struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *UnsupportedOperation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedOperation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedOperation) ErrorCode() string             { return "UnsupportedOperation" }
func (e *UnsupportedOperation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
