// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudformation

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a stack using the input information that was provided when the specified
// change set was created. After the call successfully completes, CloudFormation
// starts updating the stack. Use the DescribeStacks action to view the status of
// the update. When you execute a change set, CloudFormation deletes all other
// change sets associated with the stack because they aren't valid for the updated
// stack. If a stack policy is associated with the stack, CloudFormation enforces
// the policy during the update. You can't specify a temporary stack policy that
// overrides the current policy. To create a change set for the entire stack
// hierachy, IncludeNestedStacks must have been set to True.
func (c *Client) ExecuteChangeSet(ctx context.Context, params *ExecuteChangeSetInput, optFns ...func(*Options)) (*ExecuteChangeSetOutput, error) {
	if params == nil {
		params = &ExecuteChangeSetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ExecuteChangeSet", params, optFns, c.addOperationExecuteChangeSetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ExecuteChangeSetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The input for the ExecuteChangeSet action.
type ExecuteChangeSetInput struct {

	// The name or ARN of the change set that you want use to update the specified
	// stack.
	//
	// This member is required.
	ChangeSetName *string

	// A unique identifier for this ExecuteChangeSet request. Specify this token if you
	// plan to retry requests so that CloudFormation knows that you're not attempting
	// to execute a change set to update a stack with the same name. You might retry
	// ExecuteChangeSet requests to ensure that CloudFormation successfully received
	// them.
	ClientRequestToken *string

	// If you specified the name of a change set, specify the stack name or ID (ARN)
	// that is associated with the change set you want to execute.
	StackName *string

	noSmithyDocumentSerde
}

// The output for the ExecuteChangeSet action.
type ExecuteChangeSetOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationExecuteChangeSetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpExecuteChangeSet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpExecuteChangeSet{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpExecuteChangeSetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opExecuteChangeSet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opExecuteChangeSet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "cloudformation",
		OperationName: "ExecuteChangeSet",
	}
}
