// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The details of an AppInstance, an instance of an Amazon Chime SDK messaging
// application.
type AppInstance struct {

	// The ARN of the messaging instance.
	AppInstanceArn *string

	// The time at which an AppInstance was created. In epoch milliseconds.
	CreatedTimestamp *time.Time

	// The time an AppInstance was last updated. In epoch milliseconds.
	LastUpdatedTimestamp *time.Time

	// The metadata of an AppInstance.
	Metadata *string

	// The name of an AppInstance.
	Name *string

	noSmithyDocumentSerde
}

// The details of an AppInstanceAdmin.
type AppInstanceAdmin struct {

	// The AppInstanceAdmin data.
	Admin *Identity

	// The ARN of the AppInstance for which the user is an administrator.
	AppInstanceArn *string

	// The time at which an administrator was created.
	CreatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// Summary of the details of an AppInstanceAdmin.
type AppInstanceAdminSummary struct {

	// The details of the AppInstanceAdmin.
	Admin *Identity

	noSmithyDocumentSerde
}

// The details of the data-retention settings for an AppInstance.
type AppInstanceRetentionSettings struct {

	// The length of time in days to retain the messages in a channel.
	ChannelRetentionSettings *ChannelRetentionSettings

	noSmithyDocumentSerde
}

// Summary of the data for an AppInstance.
type AppInstanceSummary struct {

	// The AppInstance ARN.
	AppInstanceArn *string

	// The metadata of the AppInstance.
	Metadata *string

	// The name of the AppInstance.
	Name *string

	noSmithyDocumentSerde
}

// The details of an AppInstanceUser.
type AppInstanceUser struct {

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string

	// The time at which the AppInstanceUser was created.
	CreatedTimestamp *time.Time

	// The time at which the AppInstanceUser was last updated.
	LastUpdatedTimestamp *time.Time

	// The metadata of the AppInstanceUser.
	Metadata *string

	// The name of the AppInstanceUser.
	Name *string

	noSmithyDocumentSerde
}

// Summary of the details of an AppInstanceUser.
type AppInstanceUserSummary struct {

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string

	// The metadata of the AppInstanceUser.
	Metadata *string

	// The name of an AppInstanceUser.
	Name *string

	noSmithyDocumentSerde
}

// The details of the retention settings for a channel.
type ChannelRetentionSettings struct {

	// The time in days to retain the messages in a channel.
	RetentionDays *int32

	noSmithyDocumentSerde
}

// The details of a user.
type Identity struct {

	// The ARN in an Identity.
	Arn *string

	// The name in an Identity.
	Name *string

	noSmithyDocumentSerde
}

// Describes a tag applied to a resource.
type Tag struct {

	// The key of the tag.
	//
	// This member is required.
	Key *string

	// The value of the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
