// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// An object representing an Batch array job.
type ArrayProperties struct {

	// The size of the array job.
	Size int32

	noSmithyDocumentSerde
}

// An object representing the array properties of a job.
type ArrayPropertiesDetail struct {

	// The job index within the array that's associated with this job. This parameter
	// is returned for array job children.
	Index int32

	// The size of the array job. This parameter is returned for parent array jobs.
	Size int32

	// A summary of the number of array job children in each available job status. This
	// parameter is returned for parent array jobs.
	StatusSummary map[string]int32

	noSmithyDocumentSerde
}

// An object representing the array properties of a job.
type ArrayPropertiesSummary struct {

	// The job index within the array that's associated with this job. This parameter
	// is returned for children of array jobs.
	Index int32

	// The size of the array job. This parameter is returned for parent array jobs.
	Size int32

	noSmithyDocumentSerde
}

// An object representing the details of a container that's part of a job attempt.
type AttemptContainerDetail struct {

	// The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts
	// the job attempt.
	ContainerInstanceArn *string

	// The exit code for the job attempt. A non-zero exit code is considered a failure.
	ExitCode int32

	// The name of the CloudWatch Logs log stream associated with the container. The
	// log group for Batch jobs is /aws/batch/job. Each container attempt receives a
	// log stream name when they reach the RUNNING status.
	LogStreamName *string

	// The network interfaces associated with the job attempt.
	NetworkInterfaces []NetworkInterface

	// A short (255 max characters) human-readable string to provide additional details
	// about a running or stopped container.
	Reason *string

	// The Amazon Resource Name (ARN) of the Amazon ECS task that's associated with the
	// job attempt. Each container attempt receives a task ARN when they reach the
	// STARTING status.
	TaskArn *string

	noSmithyDocumentSerde
}

// An object representing a job attempt.
type AttemptDetail struct {

	// Details about the container in this job attempt.
	Container *AttemptContainerDetail

	// The Unix timestamp (in milliseconds) for when the attempt was started (when the
	// attempt transitioned from the STARTING state to the RUNNING state).
	StartedAt int64

	// A short, human-readable string to provide additional details about the current
	// status of the job attempt.
	StatusReason *string

	// The Unix timestamp (in milliseconds) for when the attempt was stopped (when the
	// attempt transitioned from the RUNNING state to a terminal state, such as
	// SUCCEEDED or FAILED).
	StoppedAt int64

	noSmithyDocumentSerde
}

// An object representing an Batch compute environment.
type ComputeEnvironmentDetail struct {

	// The Amazon Resource Name (ARN) of the compute environment.
	//
	// This member is required.
	ComputeEnvironmentArn *string

	// The name of the compute environment. Up to 128 letters (uppercase and
	// lowercase), numbers, hyphens, and underscores are allowed.
	//
	// This member is required.
	ComputeEnvironmentName *string

	// The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the
	// compute environment.
	//
	// This member is required.
	EcsClusterArn *string

	// The compute resources defined for the compute environment. For more information,
	// see Compute Environments
	// (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the Batch User Guide.
	ComputeResources *ComputeResource

	// The service role associated with the compute environment that allows Batch to
	// make calls to Amazon Web Services API operations on your behalf. For more
	// information, see Batch service IAM role
	// (https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html) in
	// the Batch User Guide.
	ServiceRole *string

	// The state of the compute environment. The valid values are ENABLED or DISABLED.
	// If the state is ENABLED, then the Batch scheduler can attempt to place jobs from
	// an associated job queue on the compute resources within the environment. If the
	// compute environment is managed, then it can scale its instances out or in
	// automatically, based on the job queue demand. If the state is DISABLED, then the
	// Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a
	// STARTING or RUNNING state continue to progress normally. Managed compute
	// environments in the DISABLED state don't scale out. However, they scale in to
	// minvCpus value after instances become idle.
	State CEState

	// The current status of the compute environment (for example, CREATING or VALID).
	Status CEStatus

	// A short, human-readable string to provide additional details about the current
	// status of the compute environment.
	StatusReason *string

	// The tags applied to the compute environment.
	Tags map[string]string

	// The type of the compute environment: MANAGED or UNMANAGED. For more information,
	// see Compute Environments
	// (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the Batch User Guide.
	Type CEType

	noSmithyDocumentSerde
}

// The order in which compute environments are tried for job placement within a
// queue. Compute environments are tried in ascending order. For example, if two
// compute environments are associated with a job queue, the compute environment
// with a lower order integer value is tried for job placement first. Compute
// environments must be in the VALID state before you can associate them with a job
// queue. All of the compute environments must be either EC2 (EC2 or SPOT) or
// Fargate (FARGATE or FARGATE_SPOT); EC2 and Fargate compute environments can't be
// mixed. All compute environments that are associated with a job queue must share
// the same architecture. Batch doesn't support mixing compute environment
// architecture types in a single job queue.
type ComputeEnvironmentOrder struct {

	// The Amazon Resource Name (ARN) of the compute environment.
	//
	// This member is required.
	ComputeEnvironment *string

	// The order of the compute environment. Compute environments are tried in
	// ascending order. For example, if two compute environments are associated with a
	// job queue, the compute environment with a lower order integer value is tried for
	// job placement first.
	//
	// This member is required.
	Order int32

	noSmithyDocumentSerde
}

// An object representing an Batch compute resource. For more information, see
// Compute Environments
// (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
// in the Batch User Guide.
type ComputeResource struct {

	// The maximum number of Amazon EC2 vCPUs that a compute environment can reach.
	// With both BEST_FIT_PROGRESSIVE and SPOT_CAPACITY_OPTIMIZED allocation
	// strategies, Batch might need to exceed maxvCpus to meet your capacity
	// requirements. In this event, Batch never exceeds maxvCpus by more than a single
	// instance. For example, no more than a single instance from among those specified
	// in your compute environment is allocated.
	//
	// This member is required.
	MaxvCpus int32

	// The VPC subnets where the compute resources are launched. These subnets must be
	// within the same VPC. Fargate compute resources can contain up to 16 subnets. For
	// more information, see VPCs and Subnets
	// (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the
	// Amazon VPC User Guide.
	//
	// This member is required.
	Subnets []string

	// The type of compute environment: EC2, SPOT, FARGATE, or FARGATE_SPOT. For more
	// information, see Compute Environments
	// (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the Batch User Guide. If you choose SPOT, you must also specify an Amazon EC2
	// Spot Fleet role with the spotIamFleetRole parameter. For more information, see
	// Amazon EC2 Spot Fleet role
	// (https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in
	// the Batch User Guide.
	//
	// This member is required.
	Type CRType

	// The allocation strategy to use for the compute resource if not enough instances
	// of the best fitting instance type can be allocated. This might be because of
	// availability of the instance type in the Region or Amazon EC2 service limits
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html).
	// For more information, see Allocation Strategies
	// (https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html)
	// in the Batch User Guide. This parameter isn't applicable to jobs that are
	// running on Fargate resources, and shouldn't be specified. BEST_FIT (default)
	// Batch selects an instance type that best fits the needs of the jobs with a
	// preference for the lowest-cost instance type. If additional instances of the
	// selected instance type aren't available, Batch waits for the additional
	// instances to be available. If there aren't enough instances available, or if the
	// user is reaching Amazon EC2 service limits
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html)
	// then additional jobs aren't run until the currently running jobs have completed.
	// This allocation strategy keeps costs lower but can limit scaling. If you are
	// using Spot Fleets with BEST_FIT then the Spot Fleet IAM Role must be specified.
	// BEST_FIT_PROGRESSIVE Batch will select additional instance types that are large
	// enough to meet the requirements of the jobs in the queue, with a preference for
	// instance types with a lower cost per unit vCPU. If additional instances of the
	// previously selected instance types aren't available, Batch will select new
	// instance types. SPOT_CAPACITY_OPTIMIZED Batch will select one or more instance
	// types that are large enough to meet the requirements of the jobs in the queue,
	// with a preference for instance types that are less likely to be interrupted.
	// This allocation strategy is only available for Spot Instance compute resources.
	// With both BEST_FIT_PROGRESSIVE and SPOT_CAPACITY_OPTIMIZED strategies, Batch
	// might need to go above maxvCpus to meet your capacity requirements. In this
	// event, Batch never exceeds maxvCpus by more than a single instance.
	AllocationStrategy CRAllocationStrategy

	// The maximum percentage that a Spot Instance price can be when compared with the
	// On-Demand price for that instance type before instances are launched. For
	// example, if your maximum percentage is 20%, then the Spot price must be less
	// than 20% of the current On-Demand price for that Amazon EC2 instance. You always
	// pay the lowest (market) price and never more than your maximum percentage. If
	// you leave this field empty, the default value is 100% of the On-Demand price.
	// This parameter isn't applicable to jobs that are running on Fargate resources,
	// and shouldn't be specified.
	BidPercentage int32

	// The desired number of Amazon EC2 vCPUS in the compute environment. Batch
	// modifies this value between the minimum and maximum values, based on job queue
	// demand. This parameter isn't applicable to jobs that are running on Fargate
	// resources, and shouldn't be specified.
	DesiredvCpus int32

	// Provides information used to select Amazon Machine Images (AMIs) for EC2
	// instances in the compute environment. If Ec2Configuration isn't specified, the
	// default is ECS_AL1. This parameter isn't applicable to jobs that are running on
	// Fargate resources, and shouldn't be specified.
	Ec2Configuration []Ec2Configuration

	// The Amazon EC2 key pair that's used for instances launched in the compute
	// environment. You can use this key pair to log in to your instances with SSH.
	// This parameter isn't applicable to jobs that are running on Fargate resources,
	// and shouldn't be specified.
	Ec2KeyPair *string

	// The Amazon Machine Image (AMI) ID used for instances launched in the compute
	// environment. This parameter is overridden by the imageIdOverride member of the
	// Ec2Configuration structure. This parameter isn't applicable to jobs that are
	// running on Fargate resources, and shouldn't be specified. The AMI that you
	// choose for a compute environment must match the architecture of the instance
	// types that you intend to use for that compute environment. For example, if your
	// compute environment uses A1 instance types, the compute resource AMI that you
	// choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of
	// the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see Amazon
	// ECS-optimized Amazon Linux 2 AMI
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// Deprecated: This field is deprecated, use ec2Configuration[].imageIdOverride
	// instead.
	ImageId *string

	// The Amazon ECS instance profile applied to Amazon EC2 instances in a compute
	// environment. You can specify the short name or full Amazon Resource Name (ARN)
	// of an instance profile. For example,  ecsInstanceRole  or
	// arn:aws:iam:::instance-profile/ecsInstanceRole . For more information, see
	// Amazon ECS Instance Role
	// (https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html) in
	// the Batch User Guide. This parameter isn't applicable to jobs that are running
	// on Fargate resources, and shouldn't be specified.
	InstanceRole *string

	// The instances types that can be launched. You can specify instance families to
	// launch any instance type within those families (for example, c5 or p3), or you
	// can specify specific sizes within a family (such as c5.8xlarge). You can also
	// choose optimal to select instance types (from the C4, M4, and R4 instance
	// families) that match the demand of your job queues. This parameter isn't
	// applicable to jobs that are running on Fargate resources, and shouldn't be
	// specified. When you create a compute environment, the instance types that you
	// select for the compute environment must share the same architecture. For
	// example, you can't mix x86 and ARM instances in the same compute environment.
	// Currently, optimal uses instance types from the C4, M4, and R4 instance
	// families. In Regions that don't have instance types from those instance
	// families, instance types from the C5, M5. and R5 instance families are used.
	InstanceTypes []string

	// The launch template to use for your compute resources. Any other compute
	// resource parameters that you specify in a CreateComputeEnvironment API operation
	// override the same parameters in the launch template. You must specify either the
	// launch template ID or launch template name in the request, but not both. For
	// more information, see Launch Template Support
	// (https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in
	// the Batch User Guide. This parameter isn't applicable to jobs that are running
	// on Fargate resources, and shouldn't be specified.
	LaunchTemplate *LaunchTemplateSpecification

	// The minimum number of Amazon EC2 vCPUs that an environment should maintain (even
	// if the compute environment is DISABLED). This parameter isn't applicable to jobs
	// that are running on Fargate resources, and shouldn't be specified.
	MinvCpus int32

	// The Amazon EC2 placement group to associate with your compute resources. If you
	// intend to submit multi-node parallel jobs to your compute environment, you
	// should consider creating a cluster placement group and associate it with your
	// compute resources. This keeps your multi-node parallel job on a logical grouping
	// of instances within a single Availability Zone with high network flow potential.
	// For more information, see Placement Groups
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in
	// the Amazon EC2 User Guide for Linux Instances. This parameter isn't applicable
	// to jobs that are running on Fargate resources, and shouldn't be specified.
	PlacementGroup *string

	// The Amazon EC2 security groups associated with instances launched in the compute
	// environment. One or more security groups must be specified, either in
	// securityGroupIds or using a launch template referenced in launchTemplate. This
	// parameter is required for jobs that are running on Fargate resources and must
	// contain at least one security group. Fargate doesn't support launch templates.
	// If security groups are specified using both securityGroupIds and launchTemplate,
	// the values in securityGroupIds are used.
	SecurityGroupIds []string

	// The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to
	// a SPOT compute environment. This role is required if the allocation strategy set
	// to BEST_FIT or if the allocation strategy isn't specified. For more information,
	// see Amazon EC2 Spot Fleet Role
	// (https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html) in
	// the Batch User Guide. This parameter isn't applicable to jobs that are running
	// on Fargate resources, and shouldn't be specified. To tag your Spot Instances on
	// creation, the Spot Fleet IAM role specified here must use the newer
	// AmazonEC2SpotFleetTaggingRole managed policy. The previously recommended
	// AmazonEC2SpotFleetRole managed policy doesn't have the required permissions to
	// tag Spot Instances. For more information, see Spot Instances not tagged on
	// creation
	// (https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag)
	// in the Batch User Guide.
	SpotIamFleetRole *string

	// Key-value pair tags to be applied to EC2 resources that are launched in the
	// compute environment. For Batch, these take the form of "String1": "String2",
	// where String1 is the tag key and String2 is the tag value−for example, { "Name":
	// "Batch Instance - C4OnDemand" }. This is helpful for recognizing your Batch
	// instances in the Amazon EC2 console. These tags can't be updated or removed
	// after the compute environment is created.Aany changes to these tags require that
	// you create a new compute environment and remove the old compute environment.
	// These tags aren't seen when using the Batch ListTagsForResource API operation.
	// This parameter isn't applicable to jobs that are running on Fargate resources,
	// and shouldn't be specified.
	Tags map[string]string

	noSmithyDocumentSerde
}

// An object representing the attributes of a compute environment that can be
// updated. For more information, see Compute Environments
// (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
// in the Batch User Guide.
type ComputeResourceUpdate struct {

	// The desired number of Amazon EC2 vCPUS in the compute environment. This
	// parameter isn't applicable to jobs that are running on Fargate resources, and
	// shouldn't be specified.
	DesiredvCpus int32

	// The maximum number of Amazon EC2 vCPUs that an environment can reach. With both
	// BEST_FIT_PROGRESSIVE and SPOT_CAPACITY_OPTIMIZED allocation strategies, Batch
	// might need to exceed maxvCpus to meet your capacity requirements. In this event,
	// Batch never exceeds maxvCpus by more than a single instance. That is, no more
	// than a single instance from among those specified in your compute environment.
	MaxvCpus int32

	// The minimum number of Amazon EC2 vCPUs that an environment should maintain. This
	// parameter isn't applicable to jobs that are running on Fargate resources, and
	// shouldn't be specified.
	MinvCpus int32

	// The Amazon EC2 security groups associated with instances launched in the compute
	// environment. This parameter is required for Fargate compute resources, where it
	// can contain up to 5 security groups. This can't be specified for EC2 compute
	// resources. Providing an empty list is handled as if this parameter wasn't
	// specified and no change is made.
	SecurityGroupIds []string

	// The VPC subnets where the compute resources are launched. Fargate compute
	// resources can contain up to 16 subnets. Providing an empty list will be handled
	// as if this parameter wasn't specified and no change is made. This can't be
	// specified for EC2 compute resources. For more information, see VPCs and Subnets
	// (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the
	// Amazon VPC User Guide.
	Subnets []string

	noSmithyDocumentSerde
}

// An object representing the details of a container that's part of a job.
type ContainerDetail struct {

	// The command that's passed to the container.
	Command []string

	// The Amazon Resource Name (ARN) of the container instance that the container is
	// running on.
	ContainerInstanceArn *string

	// The environment variables to pass to a container. Environment variables must not
	// start with AWS_BATCH; this naming convention is reserved for variables that are
	// set by the Batch service.
	Environment []KeyValuePair

	// The Amazon Resource Name (ARN) of the execution role that Batch can assume. For
	// more information, see Batch execution IAM role
	// (https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in
	// the Batch User Guide.
	ExecutionRoleArn *string

	// The exit code to return upon completion.
	ExitCode int32

	// The platform configuration for jobs that are running on Fargate resources. Jobs
	// that are running on EC2 resources must not specify this parameter.
	FargatePlatformConfiguration *FargatePlatformConfiguration

	// The image used to start the container.
	Image *string

	// The instance type of the underlying host infrastructure of a multi-node parallel
	// job. This parameter isn't applicable to jobs that are running on Fargate
	// resources.
	InstanceType *string

	// The Amazon Resource Name (ARN) associated with the job upon execution.
	JobRoleArn *string

	// Linux-specific modifications that are applied to the container, such as details
	// for device mappings.
	LinuxParameters *LinuxParameters

	// The log configuration specification for the container. This parameter maps to
	// LogConfig in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --log-driver option to docker run
	// (https://docs.docker.com/engine/reference/run/). By default, containers use the
	// same logging driver that the Docker daemon uses. However, the container might
	// use a different logging driver than the Docker daemon by specifying a log driver
	// with this parameter in the container definition. To use a different logging
	// driver for a container, the log system must be configured properly on the
	// container instance. Or, alternatively, it must be configured on a different log
	// server for remote logging options. For more information on the options for
	// different supported log drivers, see Configure logging drivers
	// (https://docs.docker.com/engine/admin/logging/overview/) in the Docker
	// documentation. Batch currently supports a subset of the logging drivers
	// available to the Docker daemon (shown in the LogConfiguration data type).
	// Additional log drivers might be available in future releases of the Amazon ECS
	// container agent. This parameter requires version 1.18 of the Docker Remote API
	// or greater on your container instance. To check the Docker Remote API version on
	// your container instance, log into your container instance and run the following
	// command: sudo docker version | grep "Server API version" The Amazon ECS
	// container agent running on a container instance must register the logging
	// drivers available on that instance with the ECS_AVAILABLE_LOGGING_DRIVERS
	// environment variable before containers placed on that instance can use these log
	// configuration options. For more information, see Amazon ECS Container Agent
	// Configuration
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LogConfiguration *LogConfiguration

	// The name of the CloudWatch Logs log stream associated with the container. The
	// log group for Batch jobs is /aws/batch/job. Each container attempt receives a
	// log stream name when they reach the RUNNING status.
	LogStreamName *string

	// For jobs run on EC2 resources that didn't specify memory requirements using
	// ResourceRequirement, the number of MiB of memory reserved for the job. For other
	// jobs, including all run on Fargate resources, see resourceRequirements.
	Memory int32

	// The mount points for data volumes in your container.
	MountPoints []MountPoint

	// The network configuration for jobs that are running on Fargate resources. Jobs
	// that are running on EC2 resources must not specify this parameter.
	NetworkConfiguration *NetworkConfiguration

	// The network interfaces associated with the job.
	NetworkInterfaces []NetworkInterface

	// When this parameter is true, the container is given elevated permissions on the
	// host container instance (similar to the root user). The default value is false.
	// This parameter isn't applicable to jobs that are running on Fargate resources
	// and shouldn't be provided, or specified as false.
	Privileged bool

	// When this parameter is true, the container is given read-only access to its root
	// file system. This parameter maps to ReadonlyRootfs in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --read-only option to docker run
	// (https://docs.docker.com/engine/reference/commandline/run/).
	ReadonlyRootFilesystem bool

	// A short (255 max characters) human-readable string to provide additional details
	// about a running or stopped container.
	Reason *string

	// The type and amount of resources to assign to a container. The supported
	// resources include GPU, MEMORY, and VCPU.
	ResourceRequirements []ResourceRequirement

	// The secrets to pass to the container. For more information, see Specifying
	// sensitive data
	// (https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html)
	// in the Batch User Guide.
	Secrets []Secret

	// The Amazon Resource Name (ARN) of the Amazon ECS task that's associated with the
	// container job. Each container attempt receives a task ARN when they reach the
	// STARTING status.
	TaskArn *string

	// A list of ulimit values to set in the container. This parameter maps to Ulimits
	// in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the --ulimit
	// option to docker run (https://docs.docker.com/engine/reference/run/). This
	// parameter isn't applicable to jobs that are running on Fargate resources.
	Ulimits []Ulimit

	// The user name to use inside the container. This parameter maps to User in the
	// Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the --user
	// option to docker run (https://docs.docker.com/engine/reference/run/).
	User *string

	// The number of vCPUs reserved for the container. For jobs that run on EC2
	// resources, you can specify the vCPU requirement for the job using
	// resourceRequirements, but you can't specify the vCPU requirements in both the
	// vcpus and resourceRequirement object. This parameter maps to CpuShares in the
	// Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --cpu-shares option to docker run
	// (https://docs.docker.com/engine/reference/run/). Each vCPU is equivalent to
	// 1,024 CPU shares. You must specify at least one vCPU. This is required but can
	// be specified in several places. It must be specified for each node at least
	// once. This parameter isn't applicable to jobs that run on Fargate resources. For
	// jobs that run on Fargate resources, you must specify the vCPU requirement for
	// the job using resourceRequirements.
	Vcpus int32

	// A list of volumes associated with the job.
	Volumes []Volume

	noSmithyDocumentSerde
}

// The overrides that should be sent to a container.
type ContainerOverrides struct {

	// The command to send to the container that overrides the default command from the
	// Docker image or the job definition.
	Command []string

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch, or you can override the
	// existing environment variables from the Docker image or the job definition.
	// Environment variables must not start with AWS_BATCH; this naming convention is
	// reserved for variables that are set by the Batch service.
	Environment []KeyValuePair

	// The instance type to use for a multi-node parallel job. This parameter isn't
	// applicable to single-node container jobs or jobs that run on Fargate resources,
	// and shouldn't be provided.
	InstanceType *string

	// This parameter indicates the amount of memory (in MiB) that's reserved for the
	// job. It overrides the memory parameter set in the job definition, but doesn't
	// override any memory requirement specified in the ResourceRequirement structure
	// in the job definition. To override memory requirements that are specified in the
	// ResourceRequirement structure in the job definition, ResourceRequirement must be
	// specified in the SubmitJob request, with type set to MEMORY and value set to the
	// new value. This parameter is supported for jobs that run on EC2 resources, but
	// isn't supported for jobs that run on Fargate resources. For these resources, use
	// resourceRequirement instead.
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Memory int32

	// The type and amount of resources to assign to a container. This overrides the
	// settings in the job definition. The supported resources include GPU, MEMORY, and
	// VCPU.
	ResourceRequirements []ResourceRequirement

	// This parameter indicates the number of vCPUs reserved for the container.It
	// overrides the vcpus parameter that's set in the job definition, but doesn't
	// override any vCPU requirement specified in the resourceRequirement structure in
	// the job definition. To override vCPU requirements that are specified in the
	// ResourceRequirement structure in the job definition, ResourceRequirement must be
	// specified in the SubmitJob request, with type set to VCPU and value set to the
	// new value. This parameter maps to CpuShares in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --cpu-shares option to docker run
	// (https://docs.docker.com/engine/reference/run/). Each vCPU is equivalent to
	// 1,024 CPU shares. You must specify at least one vCPU. This parameter is
	// supported for jobs that run on EC2 resources, but isn't supported for jobs that
	// run on Fargate resources. For Fargate resources, you can only use
	// resourceRequirement. For EC2 resources, you can use either this parameter or
	// resourceRequirement but not both.
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Vcpus int32

	noSmithyDocumentSerde
}

// Container properties are used in job definitions to describe the container
// that's launched as part of a job.
type ContainerProperties struct {

	// The command that's passed to the container. This parameter maps to Cmd in the
	// Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the COMMAND
	// parameter to docker run (https://docs.docker.com/engine/reference/run/). For
	// more information, see https://docs.docker.com/engine/reference/builder/#cmd
	// (https://docs.docker.com/engine/reference/builder/#cmd).
	Command []string

	// The environment variables to pass to a container. This parameter maps to Env in
	// the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the --env
	// option to docker run (https://docs.docker.com/engine/reference/run/). We don't
	// recommend using plaintext environment variables for sensitive information, such
	// as credential data. Environment variables must not start with AWS_BATCH; this
	// naming convention is reserved for variables that are set by the Batch service.
	Environment []KeyValuePair

	// The Amazon Resource Name (ARN) of the execution role that Batch can assume. For
	// jobs that run on Fargate resources, you must provide an execution role. For more
	// information, see Batch execution IAM role
	// (https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html) in
	// the Batch User Guide.
	ExecutionRoleArn *string

	// The platform configuration for jobs that are running on Fargate resources. Jobs
	// that are running on EC2 resources must not specify this parameter.
	FargatePlatformConfiguration *FargatePlatformConfiguration

	// The image used to start a container. This string is passed directly to the
	// Docker daemon. Images in the Docker Hub registry are available by default. Other
	// repositories are specified with  repository-url/image:tag . Up to 255 letters
	// (uppercase and lowercase), numbers, hyphens, underscores, colons, periods,
	// forward slashes, and number signs are allowed. This parameter maps to Image in
	// the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the IMAGE
	// parameter of docker run (https://docs.docker.com/engine/reference/run/). Docker
	// image architecture must match the processor architecture of the compute
	// resources that they're scheduled on. For example, ARM-based Docker images can
	// only run on ARM-based compute resources.
	//
	// * Images in Amazon ECR repositories
	// use the full registry and repository URI (for example,
	// 012345678910.dkr.ecr..amazonaws.com/).
	//
	// * Images in official repositories on
	// Docker Hub use a single name (for example, ubuntu or mongo).
	//
	// * Images in other
	// repositories on Docker Hub are qualified with an organization name (for example,
	// amazon/amazon-ecs-agent).
	//
	// * Images in other online repositories are qualified
	// further by a domain name (for example, quay.io/assemblyline/ubuntu).
	Image *string

	// The instance type to use for a multi-node parallel job. All node groups in a
	// multi-node parallel job must use the same instance type. This parameter isn't
	// applicable to single-node container jobs or jobs that run on Fargate resources,
	// and shouldn't be provided.
	InstanceType *string

	// The Amazon Resource Name (ARN) of the IAM role that the container can assume for
	// Amazon Web Services permissions. For more information, see IAM Roles for Tasks
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	JobRoleArn *string

	// Linux-specific modifications that are applied to the container, such as details
	// for device mappings.
	LinuxParameters *LinuxParameters

	// The log configuration specification for the container. This parameter maps to
	// LogConfig in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --log-driver option to docker run
	// (https://docs.docker.com/engine/reference/run/). By default, containers use the
	// same logging driver that the Docker daemon uses. However the container might use
	// a different logging driver than the Docker daemon by specifying a log driver
	// with this parameter in the container definition. To use a different logging
	// driver for a container, the log system must be configured properly on the
	// container instance (or on a different log server for remote logging options).
	// For more information on the options for different supported log drivers, see
	// Configure logging drivers
	// (https://docs.docker.com/engine/admin/logging/overview/) in the Docker
	// documentation. Batch currently supports a subset of the logging drivers
	// available to the Docker daemon (shown in the LogConfiguration data type). This
	// parameter requires version 1.18 of the Docker Remote API or greater on your
	// container instance. To check the Docker Remote API version on your container
	// instance, log into your container instance and run the following command: sudo
	// docker version | grep "Server API version" The Amazon ECS container agent
	// running on a container instance must register the logging drivers available on
	// that instance with the ECS_AVAILABLE_LOGGING_DRIVERS environment variable before
	// containers placed on that instance can use these log configuration options. For
	// more information, see Amazon ECS Container Agent Configuration
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LogConfiguration *LogConfiguration

	// This parameter indicates the memory hard limit (in MiB) for a container. If your
	// container attempts to exceed the specified number, it's terminated. You must
	// specify at least 4 MiB of memory for a job using this parameter. The memory hard
	// limit can be specified in several places. It must be specified for each node at
	// least once. This parameter maps to Memory in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the --memory
	// option to docker run (https://docs.docker.com/engine/reference/run/). This
	// parameter is supported on EC2 resources but isn't supported on Fargate
	// resources. For Fargate resources, you should specify the memory requirement
	// using resourceRequirement. You can also do this for EC2 resources. If you're
	// trying to maximize your resource utilization by providing your jobs as much
	// memory as possible for a particular instance type, see Memory Management
	// (https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in
	// the Batch User Guide.
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Memory int32

	// The mount points for data volumes in your container. This parameter maps to
	// Volumes in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the --volume
	// option to docker run (https://docs.docker.com/engine/reference/run/).
	MountPoints []MountPoint

	// The network configuration for jobs that are running on Fargate resources. Jobs
	// that are running on EC2 resources must not specify this parameter.
	NetworkConfiguration *NetworkConfiguration

	// When this parameter is true, the container is given elevated permissions on the
	// host container instance (similar to the root user). This parameter maps to
	// Privileged in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --privileged option to docker run
	// (https://docs.docker.com/engine/reference/run/). The default value is false.
	// This parameter isn't applicable to jobs that are running on Fargate resources
	// and shouldn't be provided, or specified as false.
	Privileged bool

	// When this parameter is true, the container is given read-only access to its root
	// file system. This parameter maps to ReadonlyRootfs in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --read-only option to docker run.
	ReadonlyRootFilesystem bool

	// The type and amount of resources to assign to a container. The supported
	// resources include GPU, MEMORY, and VCPU.
	ResourceRequirements []ResourceRequirement

	// The secrets for the container. For more information, see Specifying sensitive
	// data
	// (https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html)
	// in the Batch User Guide.
	Secrets []Secret

	// A list of ulimits to set in the container. This parameter maps to Ulimits in the
	// Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the --ulimit
	// option to docker run (https://docs.docker.com/engine/reference/run/). This
	// parameter isn't applicable to jobs that are running on Fargate resources and
	// shouldn't be provided.
	Ulimits []Ulimit

	// The user name to use inside the container. This parameter maps to User in the
	// Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the --user
	// option to docker run (https://docs.docker.com/engine/reference/run/).
	User *string

	// The number of vCPUs reserved for the job. Each vCPU is equivalent to 1,024 CPU
	// shares. This parameter maps to CpuShares in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --cpu-shares option to docker run
	// (https://docs.docker.com/engine/reference/run/). The number of vCPUs must be
	// specified but can be specified in several places. You must specify it at least
	// once for each node. This parameter is supported on EC2 resources but isn't
	// supported for jobs that run on Fargate resources. For these resources, use
	// resourceRequirement instead. You can use this parameter or resourceRequirements
	// structure but not both. This parameter isn't applicable to jobs that are running
	// on Fargate resources and shouldn't be provided. For jobs that run on Fargate
	// resources, you must specify the vCPU requirement for the job using
	// resourceRequirements.
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Vcpus int32

	// A list of data volumes used in a job.
	Volumes []Volume

	noSmithyDocumentSerde
}

// An object representing summary details of a container within a job.
type ContainerSummary struct {

	// The exit code to return upon completion.
	ExitCode int32

	// A short (255 max characters) human-readable string to provide additional details
	// about a running or stopped container.
	Reason *string

	noSmithyDocumentSerde
}

// An object representing a container instance host device. This object isn't
// applicable to jobs that are running on Fargate resources and shouldn't be
// provided.
type Device struct {

	// The path for the device on the host container instance.
	//
	// This member is required.
	HostPath *string

	// The path inside the container that's used to expose the host device. By default,
	// the hostPath value is used.
	ContainerPath *string

	// The explicit permissions to provide to the container for the device. By default,
	// the container has permissions for read, write, and mknod for the device.
	Permissions []DeviceCgroupPermission

	noSmithyDocumentSerde
}

// Provides information used to select Amazon Machine Images (AMIs) for instances
// in the compute environment. If Ec2Configuration isn't specified, the default is
// currently ECS_AL1 (Amazon Linux
// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami))
// for non-GPU, non AWSGraviton instances. Starting on March 31, 2021, this default
// will be changing to ECS_AL2 (Amazon Linux 2
// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami)).
// This object isn't applicable to jobs that are running on Fargate resources.
type Ec2Configuration struct {

	// The image type to match with the instance type to select an AMI. If the
	// imageIdOverride parameter isn't specified, then a recent Amazon ECS-optimized
	// AMI
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
	// (ECS_AL1) is used. Starting on March 31, 2021, this default will be changing to
	// ECS_AL2 (Amazon Linux 2
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami)).
	// ECS_AL2 Amazon Linux 2
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami)−
	// Default for all Amazon Web Services Graviton-based instance families (for
	// example, C6g, M6g, R6g, and T4g) and can be used for all non-GPU instance types.
	// ECS_AL2_NVIDIA Amazon Linux 2 (GPU)
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami)−Default
	// for all GPU instance families (for example P4 and G4) and can be used for all
	// non Amazon Web Services Graviton-based instance types. ECS_AL1 Amazon Linux
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami)−Default
	// for all non-GPU, non Amazon Web Services Graviton instance families. Amazon
	// Linux is reaching the end-of-life of standard support. For more information, see
	// Amazon Linux AMI (http://aws.amazon.com/amazon-linux-ami/).
	//
	// This member is required.
	ImageType *string

	// The AMI ID used for instances launched in the compute environment that match the
	// image type. This setting overrides the imageId set in the computeResource
	// object.
	ImageIdOverride *string

	noSmithyDocumentSerde
}

// The authorization configuration details for the Amazon EFS file system.
type EFSAuthorizationConfig struct {

	// The Amazon EFS access point ID to use. If an access point is specified, the root
	// directory value specified in the EFSVolumeConfiguration must either be omitted
	// or set to / which will enforce the path set on the EFS access point. If an
	// access point is used, transit encryption must be enabled in the
	// EFSVolumeConfiguration. For more information, see Working with Amazon EFS Access
	// Points (https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html) in the
	// Amazon Elastic File System User Guide.
	AccessPointId *string

	// Whether or not to use the Batch job IAM role defined in a job definition when
	// mounting the Amazon EFS file system. If enabled, transit encryption must be
	// enabled in the EFSVolumeConfiguration. If this parameter is omitted, the default
	// value of DISABLED is used. For more information, see Using Amazon EFS Access
	// Points
	// (https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints)
	// in the Batch User Guide. EFS IAM authorization requires that TransitEncryption
	// be ENABLED and that a JobRoleArn is specified.
	Iam EFSAuthorizationConfigIAM

	noSmithyDocumentSerde
}

// This is used when you're using an Amazon Elastic File System file system for job
// storage. For more information, see Amazon EFS Volumes
// (https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html) in the
// Batch User Guide.
type EFSVolumeConfiguration struct {

	// The Amazon EFS file system ID to use.
	//
	// This member is required.
	FileSystemId *string

	// The authorization configuration details for the Amazon EFS file system.
	AuthorizationConfig *EFSAuthorizationConfig

	// The directory within the Amazon EFS file system to mount as the root directory
	// inside the host. If this parameter is omitted, the root of the Amazon EFS volume
	// is used instead. Specifying / has the same effect as omitting this parameter.
	// The maximum length is 4,096 characters. If an EFS access point is specified in
	// the authorizationConfig, the root directory parameter must either be omitted or
	// set to /, which enforces the path set on the Amazon EFS access point.
	RootDirectory *string

	// Determines whether to enable encryption for Amazon EFS data in transit between
	// the Amazon ECS host and the Amazon EFS server. Transit encryption must be
	// enabled if Amazon EFS IAM authorization is used. If this parameter is omitted,
	// the default value of DISABLED is used. For more information, see Encrypting data
	// in transit
	// (https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html) in the
	// Amazon Elastic File System User Guide.
	TransitEncryption EFSTransitEncryption

	// The port to use when sending encrypted data between the Amazon ECS host and the
	// Amazon EFS server. If you don't specify a transit encryption port, it uses the
	// port selection strategy that the Amazon EFS mount helper uses. The value must be
	// between 0 and 65,535. For more information, see EFS Mount Helper
	// (https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in the Amazon
	// Elastic File System User Guide.
	TransitEncryptionPort int32

	noSmithyDocumentSerde
}

// Specifies a set of conditions to be met, and an action to take (RETRY or EXIT)
// if all conditions are met.
type EvaluateOnExit struct {

	// Specifies the action to take if all of the specified conditions (onStatusReason,
	// onReason, and onExitCode) are met. The values aren't case sensitive.
	//
	// This member is required.
	Action RetryAction

	// Contains a glob pattern to match against the decimal representation of the
	// ExitCode returned for a job. The pattern can be up to 512 characters in length.
	// It can contain only numbers, and can optionally end with an asterisk (*) so that
	// only the start of the string needs to be an exact match.
	OnExitCode *string

	// Contains a glob pattern to match against the Reason returned for a job. The
	// pattern can be up to 512 characters in length. It can contain letters, numbers,
	// periods (.), colons (:), and white space (including spaces and tabs). It can
	// optionally end with an asterisk (*) so that only the start of the string needs
	// to be an exact match.
	OnReason *string

	// Contains a glob pattern to match against the StatusReason returned for a job.
	// The pattern can be up to 512 characters in length. It can contain letters,
	// numbers, periods (.), colons (:), and white space (including spaces or tabs). It
	// can optionally end with an asterisk (*) so that only the start of the string
	// needs to be an exact match.
	OnStatusReason *string

	noSmithyDocumentSerde
}

// The platform configuration for jobs that are running on Fargate resources. Jobs
// that run on EC2 resources must not specify this parameter.
type FargatePlatformConfiguration struct {

	// The Fargate platform version where the jobs are running. A platform version is
	// specified only for jobs that are running on Fargate resources. If one isn't
	// specified, the LATEST platform version is used by default. This uses a recent,
	// approved version of the Fargate platform for compute resources. For more
	// information, see Fargate platform versions
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string

	noSmithyDocumentSerde
}

// Determine whether your data volume persists on the host container instance and
// where it is stored. If this parameter is empty, then the Docker daemon assigns a
// host path for your data volume, but the data isn't guaranteed to persist after
// the containers associated with it stop running.
type Host struct {

	// The path on the host container instance that's presented to the container. If
	// this parameter is empty, then the Docker daemon has assigned a host path for
	// you. If this parameter contains a file location, then the data volume persists
	// at the specified location on the host container instance until you delete it
	// manually. If the source path location doesn't exist on the host container
	// instance, the Docker daemon creates it. If the location does exist, the contents
	// of the source path folder are exported. This parameter isn't applicable to jobs
	// that run on Fargate resources and shouldn't be provided.
	SourcePath *string

	noSmithyDocumentSerde
}

// An object representing an Batch job definition.
type JobDefinition struct {

	// The Amazon Resource Name (ARN) for the job definition.
	//
	// This member is required.
	JobDefinitionArn *string

	// The name of the job definition.
	//
	// This member is required.
	JobDefinitionName *string

	// The revision of the job definition.
	//
	// This member is required.
	Revision int32

	// The type of job definition. If the job is run on Fargate resources, then
	// multinode isn't supported. For more information about multi-node parallel jobs,
	// see Creating a multi-node parallel job definition
	// (https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html) in
	// the Batch User Guide.
	//
	// This member is required.
	Type *string

	// An object with various properties specific to container-based jobs.
	ContainerProperties *ContainerProperties

	// An object with various properties specific to multi-node parallel jobs. If the
	// job runs on Fargate resources, then you must not specify nodeProperties; use
	// containerProperties instead.
	NodeProperties *NodeProperties

	// Default parameters or parameter substitution placeholders that are set in the
	// job definition. Parameters are specified as a key-value pair mapping. Parameters
	// in a SubmitJob request override any corresponding parameter defaults from the
	// job definition. For more information about specifying parameters, see Job
	// Definition Parameters
	// (https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html)
	// in the Batch User Guide.
	Parameters map[string]string

	// The platform capabilities required by the job definition. If no value is
	// specified, it defaults to EC2. Jobs run on Fargate resources specify FARGATE.
	PlatformCapabilities []PlatformCapability

	// Specifies whether to propagate the tags from the job or job definition to the
	// corresponding Amazon ECS task. If no value is specified, the tags aren't
	// propagated. Tags can only be propagated to the tasks during task creation. For
	// tags with the same name, job tags are given priority over job definitions tags.
	// If the total number of combined tags from the job and job definition is over 50,
	// the job is moved to the FAILED state.
	PropagateTags bool

	// The retry strategy to use for failed jobs that are submitted with this job
	// definition.
	RetryStrategy *RetryStrategy

	// The status of the job definition.
	Status *string

	// The tags applied to the job definition.
	Tags map[string]string

	// The timeout configuration for jobs that are submitted with this job definition.
	// You can specify a timeout duration after which Batch terminates your jobs if
	// they haven't finished.
	Timeout *JobTimeout

	noSmithyDocumentSerde
}

// An object representing an Batch job dependency.
type JobDependency struct {

	// The job ID of the Batch job associated with this dependency.
	JobId *string

	// The type of the job dependency.
	Type ArrayJobDependency

	noSmithyDocumentSerde
}

// An object representing an Batch job.
type JobDetail struct {

	// The job definition that's used by this job.
	//
	// This member is required.
	JobDefinition *string

	// The ID for the job.
	//
	// This member is required.
	JobId *string

	// The name of the job.
	//
	// This member is required.
	JobName *string

	// The Amazon Resource Name (ARN) of the job queue that the job is associated with.
	//
	// This member is required.
	JobQueue *string

	// The Unix timestamp (in milliseconds) for when the job was started (when the job
	// transitioned from the STARTING state to the RUNNING state). This parameter isn't
	// provided for child jobs of array jobs or multi-node parallel jobs.
	//
	// This member is required.
	StartedAt int64

	// The current status for the job. If your jobs don't progress to STARTING, see
	// Jobs Stuck in RUNNABLE Status
	// (https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable)
	// in the troubleshooting section of the Batch User Guide.
	//
	// This member is required.
	Status JobStatus

	// The array properties of the job, if it is an array job.
	ArrayProperties *ArrayPropertiesDetail

	// A list of job attempts associated with this job.
	Attempts []AttemptDetail

	// An object representing the details of the container that's associated with the
	// job.
	Container *ContainerDetail

	// The Unix timestamp (in milliseconds) for when the job was created. For non-array
	// jobs and parent array jobs, this is when the job entered the SUBMITTED state (at
	// the time SubmitJob was called). For array child jobs, this is when the child job
	// was spawned by its parent and entered the PENDING state.
	CreatedAt int64

	// A list of job IDs that this job depends on.
	DependsOn []JobDependency

	// The Amazon Resource Name (ARN) of the job.
	JobArn *string

	// An object representing the details of a node that's associated with a multi-node
	// parallel job.
	NodeDetails *NodeDetails

	// An object representing the node properties of a multi-node parallel job. This
	// isn't applicable to jobs that are running on Fargate resources.
	NodeProperties *NodeProperties

	// Additional parameters passed to the job that replace parameter substitution
	// placeholders or override any corresponding parameter defaults from the job
	// definition.
	Parameters map[string]string

	// The platform capabilities required by the job definition. If no value is
	// specified, it defaults to EC2. Jobs run on Fargate resources specify FARGATE.
	PlatformCapabilities []PlatformCapability

	// Specifies whether to propagate the tags from the job or job definition to the
	// corresponding Amazon ECS task. If no value is specified, the tags aren't
	// propagated. Tags can only be propagated to the tasks during task creation. For
	// tags with the same name, job tags are given priority over job definitions tags.
	// If the total number of combined tags from the job and job definition is over 50,
	// the job is moved to the FAILED state.
	PropagateTags bool

	// The retry strategy to use for this job if an attempt fails.
	RetryStrategy *RetryStrategy

	// A short, human-readable string to provide additional details about the current
	// status of the job.
	StatusReason *string

	// The Unix timestamp (in milliseconds) for when the job was stopped (when the job
	// transitioned from the RUNNING state to a terminal state, such as SUCCEEDED or
	// FAILED).
	StoppedAt int64

	// The tags applied to the job.
	Tags map[string]string

	// The timeout configuration for the job.
	Timeout *JobTimeout

	noSmithyDocumentSerde
}

// An object representing the details of an Batch job queue.
type JobQueueDetail struct {

	// The compute environments that are attached to the job queue and the order that
	// job placement is preferred. Compute environments are selected for job placement
	// in ascending order.
	//
	// This member is required.
	ComputeEnvironmentOrder []ComputeEnvironmentOrder

	// The Amazon Resource Name (ARN) of the job queue.
	//
	// This member is required.
	JobQueueArn *string

	// The name of the job queue.
	//
	// This member is required.
	JobQueueName *string

	// The priority of the job queue. Job queues with a higher priority (or a higher
	// integer value for the priority parameter) are evaluated first when associated
	// with the same compute environment. Priority is determined in descending order,
	// for example, a job queue with a priority value of 10 is given scheduling
	// preference over a job queue with a priority value of 1. All of the compute
	// environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or
	// FARGATE_SPOT); EC2 and Fargate compute environments can't be mixed.
	//
	// This member is required.
	Priority int32

	// Describes the ability of the queue to accept new jobs. If the job queue state is
	// ENABLED, it's able to accept jobs. If the job queue state is DISABLED, new jobs
	// can't be added to the queue, but jobs already in the queue can finish.
	//
	// This member is required.
	State JQState

	// The status of the job queue (for example, CREATING or VALID).
	Status JQStatus

	// A short, human-readable string to provide additional details about the current
	// status of the job queue.
	StatusReason *string

	// The tags applied to the job queue. For more information, see Tagging your Batch
	// resources (https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html)
	// in Batch User Guide.
	Tags map[string]string

	noSmithyDocumentSerde
}

// An object representing summary details of a job.
type JobSummary struct {

	// The ID of the job.
	//
	// This member is required.
	JobId *string

	// The name of the job.
	//
	// This member is required.
	JobName *string

	// The array properties of the job, if it is an array job.
	ArrayProperties *ArrayPropertiesSummary

	// An object representing the details of the container that's associated with the
	// job.
	Container *ContainerSummary

	// The Unix timestamp for when the job was created. For non-array jobs and parent
	// array jobs, this is when the job entered the SUBMITTED state (at the time
	// SubmitJob was called). For array child jobs, this is when the child job was
	// spawned by its parent and entered the PENDING state.
	CreatedAt int64

	// The Amazon Resource Name (ARN) of the job.
	JobArn *string

	// The Amazon Resource Name (ARN) of the job definition.
	JobDefinition *string

	// The node properties for a single node in a job summary list. This isn't
	// applicable to jobs that are running on Fargate resources.
	NodeProperties *NodePropertiesSummary

	// The Unix timestamp for when the job was started (when the job transitioned from
	// the STARTING state to the RUNNING state).
	StartedAt int64

	// The current status for the job.
	Status JobStatus

	// A short, human-readable string to provide additional details about the current
	// status of the job.
	StatusReason *string

	// The Unix timestamp for when the job was stopped (when the job transitioned from
	// the RUNNING state to a terminal state, such as SUCCEEDED or FAILED).
	StoppedAt int64

	noSmithyDocumentSerde
}

// An object representing a job timeout configuration.
type JobTimeout struct {

	// The time duration in seconds (measured from the job attempt's startedAt
	// timestamp) after which Batch terminates your jobs if they have not finished. The
	// minimum value for the timeout is 60 seconds.
	AttemptDurationSeconds int32

	noSmithyDocumentSerde
}

// A key-value pair object.
type KeyValuePair struct {

	// The name of the key-value pair. For environment variables, this is the name of
	// the environment variable.
	Name *string

	// The value of the key-value pair. For environment variables, this is the value of
	// the environment variable.
	Value *string

	noSmithyDocumentSerde
}

// A filter name and value pair that's used to return a more specific list of
// results from a ListJobs API operation.
type KeyValuesPair struct {

	// The name of the filter. Filter names are case sensitive.
	Name *string

	// The filter values.
	Values []string

	noSmithyDocumentSerde
}

// An object representing a launch template associated with a compute resource. You
// must specify either the launch template ID or launch template name in the
// request, but not both. If security groups are specified using both the
// securityGroupIds parameter of CreateComputeEnvironment and the launch template,
// the values in the securityGroupIds parameter of CreateComputeEnvironment will be
// used. This object isn't applicable to jobs that are running on Fargate
// resources.
type LaunchTemplateSpecification struct {

	// The ID of the launch template.
	LaunchTemplateId *string

	// The name of the launch template.
	LaunchTemplateName *string

	// The version number of the launch template, $Latest, or $Default. If the value is
	// $Latest, the latest version of the launch template is used. If the value is
	// $Default, the default version of the launch template is used. After the compute
	// environment is created, the launch template version that's used isn't changed,
	// even if the $Default or $Latest version for the launch template is updated. To
	// use a new launch template version, create a new compute environment, add the new
	// compute environment to the existing job queue, remove the old compute
	// environment from the job queue, and delete the old compute environment. Default:
	// $Default.
	Version *string

	noSmithyDocumentSerde
}

// Linux-specific modifications that are applied to the container, such as details
// for device mappings.
type LinuxParameters struct {

	// Any host devices to expose to the container. This parameter maps to Devices in
	// the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the --device
	// option to docker run (https://docs.docker.com/engine/reference/run/). This
	// parameter isn't applicable to jobs that are running on Fargate resources and
	// shouldn't be provided.
	Devices []Device

	// If true, run an init process inside the container that forwards signals and
	// reaps processes. This parameter maps to the --init option to docker run
	// (https://docs.docker.com/engine/reference/run/). This parameter requires version
	// 1.25 of the Docker Remote API or greater on your container instance. To check
	// the Docker Remote API version on your container instance, log into your
	// container instance and run the following command: sudo docker version | grep
	// "Server API version"
	InitProcessEnabled bool

	// The total amount of swap memory (in MiB) a container can use. This parameter is
	// translated to the --memory-swap option to docker run
	// (https://docs.docker.com/engine/reference/run/) where the value is the sum of
	// the container memory plus the maxSwap value. For more information, see
	// --memory-swap details
	// (https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details)
	// in the Docker documentation. If a maxSwap value of 0 is specified, the container
	// doesn't use swap. Accepted values are 0 or any positive integer. If the maxSwap
	// parameter is omitted, the container doesn't use the swap configuration for the
	// container instance it is running on. A maxSwap value must be set for the
	// swappiness parameter to be used. This parameter isn't applicable to jobs that
	// are running on Fargate resources and shouldn't be provided.
	MaxSwap int32

	// The value for the size (in MiB) of the /dev/shm volume. This parameter maps to
	// the --shm-size option to docker run
	// (https://docs.docker.com/engine/reference/run/). This parameter isn't applicable
	// to jobs that are running on Fargate resources and shouldn't be provided.
	SharedMemorySize int32

	// This allows you to tune a container's memory swappiness behavior. A swappiness
	// value of 0 causes swapping not to happen unless absolutely necessary. A
	// swappiness value of 100 causes pages to be swapped very aggressively. Accepted
	// values are whole numbers between 0 and 100. If the swappiness parameter isn't
	// specified, a default value of 60 is used. If a value isn't specified for
	// maxSwap, then this parameter is ignored. If maxSwap is set to 0, the container
	// doesn't use swap. This parameter maps to the --memory-swappiness option to
	// docker run (https://docs.docker.com/engine/reference/run/). Consider the
	// following when you use a per-container swap configuration.
	//
	// * Swap space must be
	// enabled and allocated on the container instance for the containers to use. The
	// Amazon ECS optimized AMIs don't have swap enabled by default. You must enable
	// swap on the instance to use this feature. For more information, see Instance
	// Store Swap Volumes
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html)
	// in the Amazon EC2 User Guide for Linux Instances or How do I allocate memory to
	// work as swap space in an Amazon EC2 instance by using a swap file?
	// (http://aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/)
	//
	// *
	// The swap space parameters are only supported for job definitions using EC2
	// resources.
	//
	// * If the maxSwap and swappiness parameters are omitted from a job
	// definition, each container will have a default swappiness value of 60, and the
	// total swap usage will be limited to two times the memory reservation of the
	// container.
	//
	// This parameter isn't applicable to jobs that are running on Fargate
	// resources and shouldn't be provided.
	Swappiness int32

	// The container path, mount options, and size (in MiB) of the tmpfs mount. This
	// parameter maps to the --tmpfs option to docker run
	// (https://docs.docker.com/engine/reference/run/). This parameter isn't applicable
	// to jobs that are running on Fargate resources and shouldn't be provided.
	Tmpfs []Tmpfs

	noSmithyDocumentSerde
}

// Log configuration options to send to a custom log driver for the container.
type LogConfiguration struct {

	// The log driver to use for the container. The valid values listed for this
	// parameter are log drivers that the Amazon ECS container agent can communicate
	// with by default. The supported log drivers are awslogs, fluentd, gelf,
	// json-file, journald, logentries, syslog, and splunk. Jobs that are running on
	// Fargate resources are restricted to the awslogs and splunk log drivers. awslogs
	// Specifies the Amazon CloudWatch Logs logging driver. For more information, see
	// Using the awslogs Log Driver
	// (https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html) in the
	// Batch User Guide and Amazon CloudWatch Logs logging driver
	// (https://docs.docker.com/config/containers/logging/awslogs/) in the Docker
	// documentation. fluentd Specifies the Fluentd logging driver. For more
	// information, including usage and options, see Fluentd logging driver
	// (https://docs.docker.com/config/containers/logging/fluentd/) in the Docker
	// documentation. gelf Specifies the Graylog Extended Format (GELF) logging driver.
	// For more information, including usage and options, see Graylog Extended Format
	// logging driver (https://docs.docker.com/config/containers/logging/gelf/) in the
	// Docker documentation. journald Specifies the journald logging driver. For more
	// information, including usage and options, see Journald logging driver
	// (https://docs.docker.com/config/containers/logging/journald/) in the Docker
	// documentation. json-file Specifies the JSON file logging driver. For more
	// information, including usage and options, see JSON File logging driver
	// (https://docs.docker.com/config/containers/logging/json-file/) in the Docker
	// documentation. splunk Specifies the Splunk logging driver. For more information,
	// including usage and options, see Splunk logging driver
	// (https://docs.docker.com/config/containers/logging/splunk/) in the Docker
	// documentation. syslog Specifies the syslog logging driver. For more information,
	// including usage and options, see Syslog logging driver
	// (https://docs.docker.com/config/containers/logging/syslog/) in the Docker
	// documentation. If you have a custom driver that's not listed earlier that you
	// want to work with the Amazon ECS container agent, you can fork the Amazon ECS
	// container agent project that's available on GitHub
	// (https://github.com/aws/amazon-ecs-agent) and customize it to work with that
	// driver. We encourage you to submit pull requests for changes that you want to
	// have included. However, Amazon Web Services doesn't currently support running
	// modified copies of this software. This parameter requires version 1.18 of the
	// Docker Remote API or greater on your container instance. To check the Docker
	// Remote API version on your container instance, log into your container instance
	// and run the following command: sudo docker version | grep "Server API version"
	//
	// This member is required.
	LogDriver LogDriver

	// The configuration options to send to the log driver. This parameter requires
	// version 1.19 of the Docker Remote API or greater on your container instance. To
	// check the Docker Remote API version on your container instance, log into your
	// container instance and run the following command: sudo docker version | grep
	// "Server API version"
	Options map[string]string

	// The secrets to pass to the log configuration. For more information, see
	// Specifying Sensitive Data
	// (https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html)
	// in the Batch User Guide.
	SecretOptions []Secret

	noSmithyDocumentSerde
}

// Details on a Docker volume mount point that's used in a job's container
// properties. This parameter maps to Volumes in the Create a container
// (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.19/#create-a-container)
// section of the Docker Remote API and the --volume option to docker run.
type MountPoint struct {

	// The path on the container where the host volume is mounted.
	ContainerPath *string

	// If this value is true, the container has read-only access to the volume.
	// Otherwise, the container can write to the volume. The default value is false.
	ReadOnly bool

	// The name of the volume to mount.
	SourceVolume *string

	noSmithyDocumentSerde
}

// The network configuration for jobs that are running on Fargate resources. Jobs
// that are running on EC2 resources must not specify this parameter.
type NetworkConfiguration struct {

	// Indicates whether the job should have a public IP address. For a job that is
	// running on Fargate resources in a private subnet to send outbound traffic to the
	// internet (for example, to pull container images), the private subnet requires a
	// NAT gateway be attached to route requests to the internet. For more information,
	// see Amazon ECS task networking
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html).
	// The default value is "DISABLED".
	AssignPublicIp AssignPublicIp

	noSmithyDocumentSerde
}

// An object representing the elastic network interface for a multi-node parallel
// job node.
type NetworkInterface struct {

	// The attachment ID for the network interface.
	AttachmentId *string

	// The private IPv6 address for the network interface.
	Ipv6Address *string

	// The private IPv4 address for the network interface.
	PrivateIpv4Address *string

	noSmithyDocumentSerde
}

// An object representing the details of a multi-node parallel job node.
type NodeDetails struct {

	// Specifies whether the current node is the main node for a multi-node parallel
	// job.
	IsMainNode bool

	// The node index for the node. Node index numbering begins at zero. This index is
	// also available on the node with the AWS_BATCH_JOB_NODE_INDEX environment
	// variable.
	NodeIndex int32

	noSmithyDocumentSerde
}

// Object representing any node overrides to a job definition that's used in a
// SubmitJob API operation. This isn't applicable to jobs that are running on
// Fargate resources and shouldn't be provided; use containerOverrides instead.
type NodeOverrides struct {

	// The node property overrides for the job.
	NodePropertyOverrides []NodePropertyOverride

	// The number of nodes to use with a multi-node parallel job. This value overrides
	// the number of nodes that are specified in the job definition. To use this
	// override:
	//
	// * There must be at least one node range in your job definition that
	// has an open upper boundary (such as : or n:).
	//
	// * The lower boundary of the node
	// range specified in the job definition must be fewer than the number of nodes
	// specified in the override.
	//
	// * The main node index specified in the job
	// definition must be fewer than the number of nodes specified in the override.
	NumNodes int32

	noSmithyDocumentSerde
}

// An object representing the node properties of a multi-node parallel job.
type NodeProperties struct {

	// Specifies the node index for the main node of a multi-node parallel job. This
	// node index value must be fewer than the number of nodes.
	//
	// This member is required.
	MainNode int32

	// A list of node ranges and their properties associated with a multi-node parallel
	// job.
	//
	// This member is required.
	NodeRangeProperties []NodeRangeProperty

	// The number of nodes associated with a multi-node parallel job.
	//
	// This member is required.
	NumNodes int32

	noSmithyDocumentSerde
}

// An object representing the properties of a node that's associated with a
// multi-node parallel job.
type NodePropertiesSummary struct {

	// Specifies whether the current node is the main node for a multi-node parallel
	// job.
	IsMainNode bool

	// The node index for the node. Node index numbering begins at zero. This index is
	// also available on the node with the AWS_BATCH_JOB_NODE_INDEX environment
	// variable.
	NodeIndex int32

	// The number of nodes associated with a multi-node parallel job.
	NumNodes int32

	noSmithyDocumentSerde
}

// Object representing any node overrides to a job definition that's used in a
// SubmitJob API operation.
type NodePropertyOverride struct {

	// The range of nodes, using node index values, that's used to override. A range of
	// 0:3 indicates nodes with index values of 0 through 3. If the starting range
	// value is omitted (:n), then 0 is used to start the range. If the ending range
	// value is omitted (n:), then the highest possible node index is used to end the
	// range.
	//
	// This member is required.
	TargetNodes *string

	// The overrides that should be sent to a node range.
	ContainerOverrides *ContainerOverrides

	noSmithyDocumentSerde
}

// An object representing the properties of the node range for a multi-node
// parallel job.
type NodeRangeProperty struct {

	// The range of nodes, using node index values. A range of 0:3 indicates nodes with
	// index values of 0 through 3. If the starting range value is omitted (:n), then 0
	// is used to start the range. If the ending range value is omitted (n:), then the
	// highest possible node index is used to end the range. Your accumulative node
	// ranges must account for all nodes (0:n). You can nest node ranges, for example
	// 0:10 and 4:5, in which case the 4:5 range properties override the 0:10
	// properties.
	//
	// This member is required.
	TargetNodes *string

	// The container details for the node range.
	Container *ContainerProperties

	noSmithyDocumentSerde
}

// The type and amount of a resource to assign to a container. The supported
// resources include GPU, MEMORY, and VCPU.
type ResourceRequirement struct {

	// The type of resource to assign to a container. The supported resources include
	// GPU, MEMORY, and VCPU.
	//
	// This member is required.
	Type ResourceType

	// The quantity of the specified resource to reserve for the container. The values
	// vary based on the type specified. type="GPU" The number of physical GPUs to
	// reserve for the container. The number of GPUs reserved for all containers in a
	// job shouldn't exceed the number of available GPUs on the compute resource that
	// the job is launched on. GPUs are not available for jobs that are running on
	// Fargate resources. type="MEMORY" The memory hard limit (in MiB) present to the
	// container. This parameter is supported for jobs that are running on EC2
	// resources. If your container attempts to exceed the memory specified, the
	// container is terminated. This parameter maps to Memory in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the --memory
	// option to docker run (https://docs.docker.com/engine/reference/run/). You must
	// specify at least 4 MiB of memory for a job. This is required but can be
	// specified in several places for multi-node parallel (MNP) jobs. It must be
	// specified for each node at least once. This parameter maps to Memory in the
	// Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the --memory
	// option to docker run (https://docs.docker.com/engine/reference/run/). If you're
	// trying to maximize your resource utilization by providing your jobs as much
	// memory as possible for a particular instance type, see Memory Management
	// (https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in
	// the Batch User Guide. For jobs that are running on Fargate resources, then value
	// is the hard limit (in MiB), and must match one of the supported values and the
	// VCPU values must be one of the values supported for that memory value. value =
	// 512 VCPU = 0.25 value = 1024 VCPU = 0.25 or 0.5 value = 2048 VCPU = 0.25, 0.5,
	// or 1 value = 3072 VCPU = 0.5, or 1 value = 4096 VCPU = 0.5, 1, or 2 value =
	// 5120, 6144, or 7168 VCPU = 1 or 2 value = 8192 VCPU = 1, 2, or 4 value = 9216,
	// 10240, 11264, 12288, 13312, 14336, 15360, or 16384 VCPU = 2 or 4 value = 17408,
	// 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672,
	// 29696, or 30720 VCPU = 4 type="VCPU" The number of vCPUs reserved for the
	// container. This parameter maps to CpuShares in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the
	// Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --cpu-shares option to docker run
	// (https://docs.docker.com/engine/reference/run/). Each vCPU is equivalent to
	// 1,024 CPU shares. For EC2 resources, you must specify at least one vCPU. This is
	// required but can be specified in several places; it must be specified for each
	// node at least once. For jobs that are running on Fargate resources, then value
	// must match one of the supported values and the MEMORY values must be one of the
	// values supported for that VCPU value. The supported values are 0.25, 0.5, 1, 2,
	// and 4 value = 0.25 MEMORY = 512, 1024, or 2048 value = 0.5 MEMORY = 1024, 2048,
	// 3072, or 4096 value = 1 MEMORY = 2048, 3072, 4096, 5120, 6144, 7168, or 8192
	// value = 2 MEMORY = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288,
	// 13312, 14336, 15360, or 16384 value = 4 MEMORY = 8192, 9216, 10240, 11264,
	// 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528,
	// 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The retry strategy associated with a job. For more information, see Automated
// job retries
// (https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html) in the
// Batch User Guide.
type RetryStrategy struct {

	// The number of times to move a job to the RUNNABLE status. You can specify
	// between 1 and 10 attempts. If the value of attempts is greater than one, the job
	// is retried on failure the same number of attempts as the value.
	Attempts int32

	// Array of up to 5 objects that specify conditions under which the job should be
	// retried or failed. If this parameter is specified, then the attempts parameter
	// must also be specified.
	EvaluateOnExit []EvaluateOnExit

	noSmithyDocumentSerde
}

// An object representing the secret to expose to your container. Secrets can be
// exposed to a container in the following ways:
//
// * To inject sensitive data into
// your containers as environment variables, use the secrets container definition
// parameter.
//
// * To reference sensitive information in the log configuration of a
// container, use the secretOptions container definition parameter.
//
// For more
// information, see Specifying sensitive data
// (https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html)
// in the Batch User Guide.
type Secret struct {

	// The name of the secret.
	//
	// This member is required.
	Name *string

	// The secret to expose to the container. The supported values are either the full
	// ARN of the Secrets Manager secret or the full ARN of the parameter in the Amazon
	// Web Services Systems Manager Parameter Store. If the Amazon Web Services Systems
	// Manager Parameter Store parameter exists in the same Region as the job you're
	// launching, then you can use either the full ARN or name of the parameter. If the
	// parameter exists in a different Region, then the full ARN must be specified.
	//
	// This member is required.
	ValueFrom *string

	noSmithyDocumentSerde
}

// The container path, mount options, and size of the tmpfs mount. This object
// isn't applicable to jobs that are running on Fargate resources.
type Tmpfs struct {

	// The absolute file path in the container where the tmpfs volume is mounted.
	//
	// This member is required.
	ContainerPath *string

	// The size (in MiB) of the tmpfs volume.
	//
	// This member is required.
	Size int32

	// The list of tmpfs volume mount options. Valid values: "defaults" | "ro" | "rw" |
	// "suid" | "nosuid" | "dev" | "nodev" | "exec" | "noexec" | "sync" | "async" |
	// "dirsync" | "remount" | "mand" | "nomand" | "atime" | "noatime" | "diratime" |
	// "nodiratime" | "bind" | "rbind" | "unbindable" | "runbindable" | "private" |
	// "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime" |
	// "norelatime" | "strictatime" | "nostrictatime" | "mode" | "uid" | "gid" |
	// "nr_inodes" | "nr_blocks" | "mpol"
	MountOptions []string

	noSmithyDocumentSerde
}

// The ulimit settings to pass to the container. This object isn't applicable to
// jobs that are running on Fargate resources.
type Ulimit struct {

	// The hard limit for the ulimit type.
	//
	// This member is required.
	HardLimit int32

	// The type of the ulimit.
	//
	// This member is required.
	Name *string

	// The soft limit for the ulimit type.
	//
	// This member is required.
	SoftLimit int32

	noSmithyDocumentSerde
}

// A data volume used in a job's container properties.
type Volume struct {

	// This parameter is specified when you are using an Amazon Elastic File System
	// file system for job storage. Jobs that are running on Fargate resources must
	// specify a platformVersion of at least 1.4.0.
	EfsVolumeConfiguration *EFSVolumeConfiguration

	// The contents of the host parameter determine whether your data volume persists
	// on the host container instance and where it is stored. If the host parameter is
	// empty, then the Docker daemon assigns a host path for your data volume. However,
	// the data isn't guaranteed to persist after the containers associated with it
	// stop running. This parameter isn't applicable to jobs that are running on
	// Fargate resources and shouldn't be provided.
	Host *Host

	// The name of the volume. Up to 255 letters (uppercase and lowercase), numbers,
	// hyphens, and underscores are allowed. This name is referenced in the
	// sourceVolume parameter of container definition mountPoints.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
